<?php
class Sms_model extends MY_Model
{
	public function __construct()
	{
		$this->companyID = $this->session->userdata('company_id');
	}

	public function get($args=array())
	{
		if(!isset($args['select']))
		{
			$args['select'] = array('id','tag','driver_mobile_no','bill_ref_no','user_type','client_mobile_no','status');
		}

		$this->db->select($args['select']);
		$this->db->from('dms_sms');
		$args['conditions']['ds.company_id'] = $this->companyID;
		if(isset($args['conditions']))
		{
			$this->db->where($args['conditions']);
		}
		if(isset($args['num_rows']))
		{
			return $this->db->get()->num_rows();
		}
		if(isset($args['order_by']))
		{
			if(!isset($args['order'])){$args['order'] = 'asc';}
			$this->db->order_by($args['order_by'],$args['order']);
		}
		if(isset($args['limit']))
		{
			$this->db->limit($args['limit'], $args['offset']);
		}
		return $this->db->get()->result_array();
	}

	public function get_all($args)
	{
		if(!isset($args['select']))
		{
			$args['select'] = array('id','tag','driver_mobile_no','bill_ref_no','user_type','client_mobile_no','status');
		}

		$this->db->select($args['select']);
		$this->db->from('dms_sms as ds');

		if(isset($args['join']))
		{
			foreach($args['join'] as $table=>$on)
			{
				$this->db->join($table,$on,'left');
			}
		}
		if(!array_key_exists('ds.status',$args['conditions']))
		{
			$this->db->where(array('ds.status >'=>0));
		}
		$args['conditions']['ds.company_id'] = $this->companyID;
		if(isset($args['conditions']))
		{
			$this->db->where($args['conditions']);
		}
		if(isset($args['num_rows']))
		{
			return $this->db->get()->num_rows();
		}
		if(isset($args['order_by']))
		{
			if(!isset($args['order'])){$args['order'] = 'asc';}
			$this->db->order_by($args['order_by'],$args['order']);
		}
		if(isset($args['limit']))
		{
			$this->db->limit($args['limit'], $args['offset']);
		}
		
		return $this->db->get()->result_array();
	}

	public function update($data,$conditions)
	{
		if($this->my_update('dms_sms',$data,$conditions))
		{
			return true;
		}
		return false;
	}

	public function update_bill($data,$conditions)
	{
		if($this->my_update('dms_sales',$data,$conditions))
		{
			return true;
		}
		return false;
	}

	public function update_point($args = array())
	{
		if($this->db->update('user_points',$args['data'],$args['conditions']))
		{
			return true;
		}
		return false;
	}

	public function get_user_point($conditions)
	{
		$prev_point=0;
		$rows = $this->db->select('points')->get_where('user_points',$conditions)->row_array();
		if(!empty($rows))
		{
			$prev_point = ceil($rows['points']);
		}
		return $prev_point;
	}

    public function sms_user()
    {
	    $args['select'] = array('username','password','entity_id','sms_type','sender_id','msg_suffix');
		$args['conditions']['status'] = 1;

		$this->db->select($args['select']);
		$this->db->from('dms_sms_user');
		$this->db->where($args['conditions']);
		return $this->db->get()->result_array();
    }
	
	public function sms_balance($username,$password,$route)
	{
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL,"http://sms.firstdial.info/creditsleft/".$username."/".$password."/".$route);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		$server_output = curl_exec ($ch);
		curl_close ($ch);
		return $server_output;
	}
	
	public function send($to,$message,$temp)
	{
		$sms_users = $this->sms_user();
		$sms_user = $sms_users[0];
		$username = $sms_user['username'];
		$password = $sms_user['password'];
		$entity_id = $sms_user['entity_id'];
		$route = $sms_user['sms_type'];
		$sender_id = $sms_user['sender_id'];
		$msg_suffix = $sms_user['msg_suffix'];
		
		$message1=str_replace("+"," ",$message);
		$message1=str_replace('\r\n','.',$message1);
		$message1=str_replace('\r','.',$message1);
		$message1=str_replace('\n','.',$message1);
		$message1=stripslashes(str_replace('\\','',$message1));
		
		$url = "http://sms.firstdial.info/sendsms?uname=".urlencode($username)."&pwd=".urlencode($password)."&senderid=".urlencode($sender_id)."&to=".urlencode($to)."&msg=".urlencode($message1)."&route=".urlencode($route)."&peid=".urlencode($entity_id)."&tempid=".urlencode($temp);
		
		$ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER,1);
        $data = curl_exec($ch); 
        curl_close($ch);
        return $data;
	}

	public function send1($to,$message,$temp)
	{
		$sms_users = $this->sms_user();
		$sms_user = $sms_users[0];
		
		$username = $sms_user['username'];
		$password = $sms_user['password'];
		$entity_id = $sms_user['entity_id'];
		$route = $sms_user['sms_type'];
		$sender_id = $sms_user['sender_id'];
		$msg_suffix = $sms_user['msg_suffix'];
		
		$msg_status = 0;$count = 0;
		$ch = curl_init();
		$message1=str_replace("&"," and ",$message);
		$message1=str_replace("+"," ",$message1);
		$message1=str_replace('\r\n','.',$message1);
		$message1=str_replace('\r','.',$message1);
		$message1=str_replace('\n','.',$message1);
		$message1=stripslashes(str_replace('\\','',$message1));
	//	$message1 .= ",".$msg_suffix;
		curl_setopt($ch, CURLOPT_URL,"http://sms.firstdial.info/sendsms");
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS,"uname=".urlencode($username)."&pwd=".urlencode($password)."&senderid=".urlencode($sender_id)."&to=".urlencode($to)."&msg=".urlencode($message1)."&route=".urlencode($route)."&peid=".urlencode($entity_id)."&tempid=".urlencode($temp));

		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		$server_output = curl_exec($ch); 
		curl_close($ch);
		$cur_date = date('Y-m-d H:i:s');
		$mresult="";
		$server_output = explode(',',$server_output); print_r($server_output); die;
		$mobile_nos = explode(',',$to);
		/*foreach($server_output as $key => $value)
		{
			$mobile_no = $mobile_nos[$key];
			if(is_numeric($value))
			{
				$count++;
				$mresult="success";
			}
			else
			{
				$mresult="failed";
			}
			//$this->insert("sms_send_details(phone,message,message_id,status,other_category,other_category_id,date)","'$mobile_no','$message1','$value','$mresult','$regno','$usertype','$cur_date'");
		}*/
		return $server_output;
	}
}
?>