<?php
class Sms_model extends MY_Model{
	
	#--------------------------------------
	
	public function __construct(){
		$this->companyID = $this->session->userdata('company_id');
	}
	
	#--------------------------------------
	
	public function get($args=array()){

		if(!isset($args['select'])){
			$args['select'] = array('id','tag','driver_mobile_no','bill_ref_no','user_type','client_mobile_no','status');
		}
		
		$this->db->select($args['select']);
		$this->db->from('dms_sms');
		$args['conditions']['ds.company_id'] = $this->companyID;
		if(isset($args['conditions'])){
			$this->db->where($args['conditions']);
		}
		
		if(isset($args['num_rows'])){
			return $this->db->get()->num_rows();
		}

		if(isset($args['order_by'])){ 
			if(!isset($args['order'])){$args['order'] = 'asc';}
			$this->db->order_by($args['order_by'],$args['order']);
		}

		if(isset($args['limit']))
		{
			$this->db->limit($args['limit'], $args['offset']);
		}

		return $this->db->get()->result_array();		
		
	}

	#--------------------------------------

	public function get_all($args){
		
		if(!isset($args['select'])){
			$args['select'] = array('id','tag','driver_mobile_no','bill_ref_no','user_type','client_mobile_no','status');
		}
		
		$this->db->select($args['select']);
		$this->db->from('dms_sms as ds');
		
		if(isset($args['join'])){
			foreach($args['join'] as $table=>$on){
				$this->db->join($table,$on,'left');
			}
		}
		
		if(!array_key_exists('ds.status',$args['conditions'])){
			$this->db->where(array('ds.status >'=>0));
		}
		$args['conditions']['ds.company_id'] = $this->companyID;
		if(isset($args['conditions'])){
			$this->db->where($args['conditions']);
		}

		if(isset($args['num_rows'])){
			return $this->db->get()->num_rows();
		}
		
		if(isset($args['order_by'])){ 
			if(!isset($args['order'])){$args['order'] = 'asc';}
			$this->db->order_by($args['order_by'],$args['order']);
		}

		if(isset($args['limit']))
		{
			$this->db->limit($args['limit'], $args['offset']);
		}
		#$this->db->get();echo $this->db->last_query();die;
		return $this->db->get()->result_array();
	}	
	
	#---------------------------------------------------------------------
	
	public function update($data,$conditions){
		if($this->my_update('dms_sms',$data,$conditions)){
			return true;
		}
		return false;		
	}

	#---------------------------------------------------------------------
	
	public function update_bill($data,$conditions){
		
		if($this->my_update('dms_sales',$data,$conditions)){
			return true;
		}
		return false;	
				
	}
	
	#---------------------------------------------------------------------
	
	public function update_point($args = array())
	{		
		if($this->db->update('user_points',$args['data'],$args['conditions'])){
			return true;
		}		
		return false;
	}	

	#---------------------------------------------------------------------

	public function get_user_point($conditions){
		$prev_point=0;
		$rows = $this->db->select('points')->get_where('user_points',$conditions)->row_array();
		if(!empty($rows)){
			$prev_point = ceil($rows['points']);
		}
		return $prev_point;
	}
}
?>