<?php
$bill_num = $bill_date = NULL;
if(!empty($purchase_vehicle)){
	$vtype_id = $purchase_vehicle[0]['vtype_id'];
	$bill_num = $purchase_vehicle[0]['bill_no'];
	$bill_date = $purchase_vehicle[0]['bill_date'];
	$vehicle_id = $purchase_vehicle[0]['vehicle_id'];
	$driver_id = $purchase_vehicle[0]['driver_id'];
	$to_id = $purchase_vehicle[0]['route_id'];
	$km = $purchase_vehicle[0]['km'];
	$remarks = $purchase_vehicle[0]['remarks'];
	$vehicle_type = $purchase_vehicle[0]['vehicle_type'];
	$vehicle_num = $purchase_vehicle[0]['vehicle_no'];
	$driver_name = $purchase_vehicle[0]['driver_name'];
	$bill_prefix = $this->stock->get_voucher_prefix($vtype_id);
}?>
<div class="panel panel-primary">
    <div class="panel-heading">
    <h6 class="panel-title"><i class="icon-truck"></i> <?= $this->lang->line('assign-vehicles'); ?> </h6>
    </div>
        <div class="panel-body">
        
        <?= form_open(); ?>
        
            <div class="form-group">
                <div class="row">
                    <div class="col-md-6">
                        <label><?=$this->lang->line('bill-no');?></label>
                        <div class="input-group">
                            <span class="input-group-addon text-bold" id="bill-prefix"><?= $bill_prefix; ?></span>
                            <?= form_input(array('name'=>'bill_no','class'=>'form-control text-right number','disabled'=>true),set_value('bill_no',$bill_num)); ?>
                        </div>
                        <?= form_error('bill_no');?>
                    </div>
                    <div class="col-md-6">
                        <label class=""><?=$this->lang->line('bill-date');?></label>
                        <?= form_input(array('name'=>'bill_date','class'=>'form-control','disabled'=>true),set_value('bill_date',cdateFormat($bill_date))); ?>
                        <?= form_error('bill_date');?>
                    </div>
                </div>
            </div>

            <?php
			$checkSts = 'checked';
			if($this->input->post()){
				if($this->input->post('vehicle_type')){
					$checkSts = 'checked';
				}else{
					$checkSts = '';
				}
			}else if(!empty($vehicle_type)){
				$checkSts = '';
			}
			?>
            
            <div class="form-group">
                <div class="row">
                    <div class="col-md-12">
                    <?= form_checkbox(array('name'=>'vehicle_type','value'=>1,'class'=>'vehicle-type','checked'=>$checkSts)); ?>
                        <label><?= $this->lang->line('company-vehicle'); ?></label>
                    </div>
                </div>
            </div>

            <?php 
			$CmpSts = 'display-none';
			if($this->input->post() && $this->input->post('vehicle_type')){
				$CmpSts = '';
			}else if(empty($vehicle_type)){
				$CmpSts = '';
			}?>

            <div class="form-group company-vehicle <?= $CmpSts; ?>">
                <div class="row">
                    <div class="col-md-6">
                        <label class="required"><?=$this->lang->line('vehicle');?></label>
						<?= form_dropdown('vehicle_id',$vehicles,set_value('vehicle_id',$vehicle_id),'class="form-control"'); ?>
                        <?= form_error('vehicle_id');?>
                    </div>
                    <div class="col-md-6">
                        <label class="required"><?=$this->lang->line('driver');?></label>
                        <?= form_dropdown('driver_id',$drivers,set_value('driver_id',$driver_id),'class="form-control"'); ?>
                        <?= form_error('driver_id');?>
                    </div>
                </div>
            </div>
            
            <?php
			$nonCmpSts = 'display-none';
			if($this->input->post() && !$this->input->post('vehicle_type')){
				$nonCmpSts = '';
			}else if(!$this->input->post() && !empty($vehicle_type)){
				$nonCmpSts = '';
			}?>
            <div class="form-group non-company-vehicle <?= $nonCmpSts; ?>">
                <div class="row">
                    <div class="col-md-6">
                        <label class="required"><?=$this->lang->line('vehicle');?></label>
						<?= form_input(array('name'=>'vehicle_no','class'=>'form-control'),set_value('vehicle_no',$vehicle_num)); ?>
                        <?= form_error('vehicle_no');?>
                    </div>
                    <div class="col-md-6">
                        <label class=""><?=$this->lang->line('driver');?></label>
                        <?= form_input(array('name'=>'driver_name','class'=>'form-control'),set_value('driver_name',$driver_name)); ?>
                    </div>
                </div>
            </div>  

            <div class="form-group">
                <div class="row">
                    <div class="col-md-6">
                        <label class="required"><?=$this->lang->line('route');?></label>
                        <?= form_dropdown('route_id',$routes,set_value('route_id',$to_id),'class="form-control"'); ?>
                        <?= form_error('route_id');?>
                    </div>
                    <div class="col-md-6">
                        <label class="required"><?=$this->lang->line('km');?></label>
                        <?= form_input(array('name'=>'km','class'=>'form-control decimal'),set_value('km',$km)); ?>
                        <?= form_error('km');?>
                    </div>
                </div>
            </div>             
                    
            <div class="form-group">
                <div class="row">

                    <div class="col-md-12">
                        <label class=""><?=$this->lang->line('remarks');?></label>
                        <?= form_textarea(array('name'=>'remarks','rows'=>3,'class'=>'form-control'),set_value('remarks',$remarks)); ?>
                        <?= form_error('remarks');?>
                    </div>
                </div>
            </div>
                     
            <div class="form-group">
            <div class="row">
            <div class="col-md-12">
                <?=form_button(array('type'=>'submit','class'=>'btn btn-primary pull-right','content'=>$this->lang->line('save')));?>
            </div>
            </div>
            </div>
            
            <?= form_close(); ?>

    </div>
</div>