var app_path = window.location.origin + '/dms/ajax/';
var file_path = window.location.origin + '/dms/assets/';
var customIcons = {low:{icon: file_path +'images/maps/red.png'},medium: {icon: file_path +'images/maps/blue.png'},high:{icon:file_path +'images/maps/green.png'}};
$(document).ready(function(){

	$(".get-map").click(function(){
		
		//selected area
		$.getJSON(app_path + 'Json_ajax/area_cordinates',{'area_id':$(".area-id").val()},function(data){
			$('#map').html('<i class="icon-spinner3 spin block-inner"></i>');
			var map = new google.maps.Map(document.getElementById("map"), {
	       		center: new google.maps.LatLng(data.cordinate_x,data.cordinate_y),
        		zoom: 15,
        		mapTypeId: 'roadmap'
    		});

			/*map.set('styles', [
	 		{featureType: 'road',elementType: 'geometry',stylers: [{color:'#000000'}]},
		 	{featureType: 'road',elementType: 'labels'},
		 	{featureType: 'landscape',elementType: 'geometry',stylers: [{hue:'#B9E69C'},{gamma:0.4},{saturation:82},{lightness:06}]},
		 	{featureType: 'poi',elementType: 'geometry',stylers: [{ visibility:"off" }]},
		 	{featureType: 'water',elementType: 'geometry',stylers: [{ visibility:"off" }]}
	 		]);*/

			map.set('styles',[
			{featureType:'landscape','elementType':'geometry',stylers:[{hue:'#DDFF00'},{gamma:1.8},{saturation:50}]}	
			]);
			$('#map').css('display','none').fadeIn(1000);
			//change marker according to the sales
			var icon = customIcons['low'] || {};
	 		if(data.sales <= 10){ icon = customIcons['high'];}
	 		else if(data.sales >10 && data.sales >=20){ icon = customIcons['medium'];}
	 		else{ icon = customIcons['high']; }

	 		var infoWindow = new google.maps.InfoWindow;
	 		var point = new google.maps.LatLng(parseFloat(data.cordinate_x),parseFloat(data.cordinate_y));
	 		
	 		var marker = new google.maps.Marker({map: map,position: point,icon:icon.icon});
	 		bindInfoWindow(marker, map, infoWindow, data.area,data.sales);
          	infoWindow.setContent('This is ' + data.area + '('+'Total Sales = ' + data.sales + ')');
          	infoWindow.open(map, marker);
		});	
		
	});
});

function bindInfoWindow(marker, map, infoWindow, area,sales) {
      google.maps.event.addListener(marker, 'click', function() {
        infoWindow.setContent('This is ' + area + '('+'Total Sales = ' + sales + ')');
        infoWindow.open(map, marker);
      });
    }