/**
 * AJAX long-polling
 *
 * 1. sends a request to the server (without a timestamp parameter)
 * 2. waits for an answer from server.php (which can take forever)
 * 3. if server.php responds (whenever), put data_from_file into #response
 * 4. and call the function again
 *
 * @param timestamp
 */
 
 
// initialize jQuery
/*$(document).ready(function(){
    getTarget();
});
*/
$(document).ready(function(){
	setInterval(function(){
	getTarget()
	},15000);
	getTarget();
});


function getTarget(currentCount)
{
    var base_url = $('body').data('baseurl');

    var queryString = {'cc' : currentCount};

    $.ajax(
        {
            type: 'GET',
            url: base_url + 'ajax/notify/notify_my_targets',
            data: queryString,
            success: function(data){
                // put result data into "obj"
				if(data != null && data != " " && data != "[]"){    
                    var obj = jQuery.parseJSON(data);
                    $(".target-li-holder").html('');
                    $('.notify-count').html(obj.count);
                    $.each(obj.targets, function(index, element) {
                        $(".target-li-holder").append('<li><i class="icon-target text-danger"></i><div><a href="'+base_url+'employees/my_targets">'+ element.id +' before ' + element.valid_to + '</div></li>');
                    });
				}
            }
        }
    );
}


