$(document).ready(function(e) {
    
	$('input').attr('autocomplete','off');
	
	var screenWidth = $(window).width();
	if(screenWidth >950 && screenWidth <1100){
		$('body').addClass('sidebar-narrow');
	}
	
	var base_url = $('body').data('baseurl');
	var app_path = base_url+'ajax/';

	/*----------------------------------------------------------*/

	$('.item_name').change(function(e) {		
		var item_ID = $(this).val();
		if(item_ID != "")
		{
			$(".godown").html('');
			$(".unit").html('');
			$('.rate').val('');
			$('.qnty').val('');
			$('.amount').val('');
			$('#stock-balance').html('');
			$.getJSON(app_path+'stock_ajax/get_item_godowns',{'item_id':item_ID},function(data){
				$(".godown").append('<option value="">Select</option>');			
				$.each(data,function(key,value){				
					$(".godown").append('<option value="' + key + '">'+ value +'</option>');
				});
			});
			$.getJSON(app_path+'stock_ajax/get_item_units',{'item_id':item_ID},function(data){
				//alert(JSON.stringify(data[0]));					
				$.each(data[0],function(key,value){
					var sel = '';
					if(key == data[1]){
						var sel = 'selected';
						$('#primary-unit').html(' / '+value);
					}
					$(".unit").append('<option value="' + key + '" '+sel+'>'+ value +'</option>');
				});
			});
			$.ajax({url:app_path+'purchase_order_ajax/get_item_rate/'+item_ID,
				success: function(data){						
				$('.rate').val(data);
			}
		});
		}
		else
		{
			$(".godown").html('<option value="">Select</option>');
			$(".unit").html('<option value="">Select</option>');
		}		
    });
	
	/*----------------------------------------------------------*/
	
	$('.godown').change(function(e) {
		var godown_id = $(this).val();			
		var item_id = $(".item_name").val();		
		var bill_date = $(".bill-date").val();
		if(item_id != "" && godown_id != "" && bill_date != "")
		{
			var url = app_path+'stock_ajax/get_stock_bal/'+godown_id+'/'+item_id+'/'+bill_date;
			ajax_function(url,'stock-balance');	
		}		
		$.getJSON(app_path+'stock_ajax/get_so_bill_dis_per/',{'disc_amt':disc_amt,'total':gnd_total},function(data){
			$('.bill_discount_per').val(data[0]);
			$('#grandTotalAmount').html(data[1]);
		});
    });
	
	/*----------------------------------------------------------*/
	
	$('.unit').change(function(e) {
        var itemID = $('.item_name').val();
		var unitID = $(this).val();
        var qnty = parseFloat($('.qnty').val());
		var rate = parseFloat($('.rate').val());
						
		$.getJSON(app_path+'purchase_order_ajax/get_item_unit_rate',{'item_id':itemID,'unit_id':unitID},function(data){
			rate = parseFloat(data[0]);
			rate = (data[0]);
			$('.rate').val(rate);
			$.getJSON(app_path+'purchase_order_ajax/get_amount/',{'qty':qnty,'rate':rate},function(data){
				$('.amount').val(data[0])
			});			
		});
    });
	
	/*---------------------------------------------------------*/
	$('.discount_per').on('change keyup',function(e) {
		
        var disc_per = parseFloat($('#discount_per').val());
		var rate = parseFloat($('.rate').val());
		var qnty = parseFloat($('.qnty').val());

		if(isNaN(disc_per) || disc_per == null){disc_per =0;}
		if(isNaN(rate) || rate == null){rate=0;}
		if(isNaN(qnty) || qnty == null){qnty=0;}
		
		if(disc_per >100){disc_per=100;$('#discount_per').val(disc_per);}

		$.getJSON(app_path+'stock_ajax/get_so_dis_amt',{'disc_per':disc_per,'rate':rate,'qnty':qnty},function(data){
		
			$('.discount_amt').val(data[0]);
			$('.amount').val(data[1]);
									
		});
		
    });
	
	/*----------------------------------------------------------*/	
	
	$('.discount_amt').keyup(function(e) {
		
		var rate = parseFloat($('.rate').val());
		var qnty = parseFloat($('.qnty').val());
		var disc_amt = parseFloat($('.discount_amt').val());

		if(isNaN(rate) || rate == null){rate=0;}
		if(isNaN(qnty) || qnty == null){qnty=0;}
		if(isNaN(disc_amt) || disc_amt == null){disc_amt=0;}
		var amount = (rate*qnty);
		if(amount < disc_amt){disc_amt=amount;$('.discount_amt').val(amount);}
		$.getJSON(app_path+'stock_ajax/get_so_dis_per',{'disc_amt':disc_amt,'rate':rate,'qnty':qnty},function(data){
			$('#discount_per').val(data[0]);
			$('.amount').val(data[1]);			
		});

    });

	/*-----------------------------------------------------------*/
	
	$('.freight-amt').keyup(function(e) { 
		var freight_amt = parseFloat($(this).val());
		var other_expense = parseFloat($('.other-expense').val());    
		var gnd_total = parseFloat($('#gnTotalAmt').val());
		var disc_amt = parseFloat($('.bill_discount_amount').val());
		if(isNaN(freight_amt) || freight_amt == null || freight_amt < 0){freight_amt=0;}
		if(isNaN(other_expense) || other_expense == null || other_expense < 0){other_expense=0;}
		if(freight_amt > gnd_total){freight_amt = gnd_total;$(this).val(freight_amt);}	
		gnd_total+=(freight_amt+other_expense)-disc_amt;
		gnd_total=gnd_total.toFixed(2);
		$.getJSON(app_path+'stock_ajax/get_rounded/',{'amount':gnd_total},function(data){
			$('#grandTotalAmount').html(data[0]);
			$('#roundOff').html(data[1]);
			$('#round_value').val(data[1]);
		});		
		//$('#grandTotalAmount').html(gnd_total);
	});
	
	/*----------------------------------------------------------*/
	
	$('.other-expense').keyup(function(e) { 
		var other_expense = parseFloat($(this).val());
		var freight_amt = parseFloat($('.freight-amt').val());    
		var gnd_total = parseFloat($('#gnTotalAmt').val());
		var disc_amt = parseFloat($('.bill_discount_amount').val());
		if(isNaN(freight_amt) || freight_amt == null || freight_amt < 0){freight_amt=0;}
		if(isNaN(other_expense) || other_expense == null || other_expense < 0){other_expense=0;}
		if(other_expense > gnd_total){other_expense = gnd_total;$(this).val(other_expense);}	
		gnd_total+=(freight_amt+other_expense)-disc_amt;
		gnd_total=gnd_total.toFixed(2);
		$.getJSON(app_path+'stock_ajax/get_rounded/',{'amount':gnd_total},function(data){
			$('#grandTotalAmount').html(data[0]);
			$('#roundOff').html(data[1]);
			$('#round_value').val(data[1]);
		});		
		//$('#grandTotalAmount').html(gnd_total);
	});
	
	/*----------------------------------------------------------*/
	
	$('.bill_discount_percent').keyup(function(e) {
		var disc_per = parseFloat($(this).val());
		var gnd_total = parseFloat($('#gnTotalAmt').val());
		var freight_amt = parseFloat($('.freight-amt').val());
		var other_expense = parseFloat($('.other-expense').val());
		
		if(isNaN(disc_per) || disc_per == null || disc_per < 0){disc_per=0;}
		if(isNaN(freight_amt) || freight_amt == null || freight_amt < 0){freight_amt=0;}
		if(isNaN(other_expense) || other_expense == null || other_expense < 0){other_expense=0;}
		gnd_total+=(freight_amt+other_expense);
		
		if(disc_per > 100){
			disc_per=100;$('.bill_discount_percent').val(disc_per);
		}
		var discount_amount = parseFloat((gnd_total*disc_per)/100);
		discount_amount = discount_amount.toFixed(2);
		gnd_total-=discount_amount;
		gnd_total = gnd_total.toFixed(2);
		$('.bill_discount_amount').val(discount_amount);
		$.getJSON(app_path+'stock_ajax/get_rounded/',{'amount':gnd_total},function(data){
			$('#grandTotalAmount').html(data[0]);
			$('#roundOff').html(data[1]);
			$('#round_value').val(data[1]);
		});		
		//$('#grandTotalAmount').html(gnd_total);
    });
	
	/*-----------------------------------------------------------*/
	
	$('.bill_discount_amount').keyup(function(e) {
    	
		var disc_amt = parseFloat($(this).val());    
		var gnd_total = parseFloat($('#gnTotalAmt').val());
		var freight_amt = parseFloat($('.freight-amt').val());
		var other_expense = parseFloat($('.other-expense').val());
		
		if(isNaN(disc_amt) || disc_amt == null || disc_amt < 0){disc_amt=0;}
		if(isNaN(freight_amt) || freight_amt == null || freight_amt < 0){freight_amt=0;}
		if(isNaN(other_expense) || other_expense == null || other_expense < 0){other_expense=0;}
		gnd_total+=(freight_amt+other_expense);
		
		if(disc_amt > gnd_total){disc_amt = gnd_total;$(this).val(disc_amt)}
				
		var discount_per = parseFloat((disc_amt*100)/gnd_total);
		discount_per = discount_per.toFixed(2);
		gnd_total-=disc_amt;
		gnd_total = gnd_total.toFixed(2);
		$('.bill_discount_percent').val(discount_per);
		$.getJSON(app_path+'stock_ajax/get_rounded/',{'amount':gnd_total},function(data){
			$('#grandTotalAmount').html(data[0]);
			$('#roundOff').html(data[1]);
			$('#round_value').val(data[1]);
		});
		//$('#grandTotalAmount').html(gnd_total);
    });		
	
	/*-----------------------------------------------------------*/

	$(".voucher-type").change(function(){
		var id = $(this).val();
		$.getJSON(base_url+'ajax/purchase_ajax/get_next_bill',{'vtype':id},function(data){
			if(data.vstatus == 1){
				$("#sdate-ajax").prop('readonly',true);
				$("#sbill-ajax").prop('readonly',true);
			}else{
				$("#sdate-ajax").prop('readonly',false);
				$("#sbill-ajax").prop('readonly',false);
			}
			$("#sdate-ajax").val(data.bill_date);
			$("#sbill-ajax").val(data.bill_no);
		});
	});
	
	/*-----------------------------------------------------------*/

	$('.cst').keyup(function(e) {
        var cst = $(this).val();
		if(cst > 100){cst=100;$('.cst').val(cst);}
    });
	
	/*-----------------------------------------------------------*/

	$(".voucher-types").change(function(){
		var id = $(this).val();
		$.ajax({url:base_url+'ajax/purchase_ajax/get_next_bill_no/'+id,
			success: function(data){
				$('#sbill-ajax').val(data);
			}
		});	
	});
	
	/*-----------------------------------------------------------*/

	$(".r-voucher-type").change(function(){
		var id = $(this).val();
		$.getJSON(base_url+'ajax/purchase_ajax/get_receipt_next_bill',{'vtype':id},function(data){
			if(data.vstatus == 1){
				$("#sdate-ajax").prop('readonly',true);
				$("#sbill-ajax").prop('readonly',true);
			}
			else{
				$("#sdate-ajax").prop('readonly',false);
				$("#sbill-ajax").prop('readonly',false);
			}
			$("#sdate-ajax").val(data.bill_date);
			$("#sbill-ajax").val(data.bill_no);
		});
	});
	
	/*-----------------------------------------------------------*/
});