<?php
$config = array(

	'designations/manage'=>array(
		array('field'=>'designation_name','label'=>'lang:designation','rules'=>'required|trim|xss_clean'),
		array('field'=>'department_id','label'=>'department','rules'=>'required'),
		array('field'=>'parent_id','label'=>'designation under','rules'=>'required')
	),
	'users/add'=>array(
		array('field'=>'fname','label'=>'lang:first name','rules'=>'required|trim|xss_clean'),
		array('field'=>'lname','label'=>'lang:last name','rules'=>'trim|xss_clean'),
		array('field'=>'landline','label'=>'lang:land line','rules'=>'trim|xss_clean'),
		array('field'=>'mobile','label'=>'lang:mobile','rules'=>'required|trim|xss_clean|is_natural|exact_length[10]|is_unique[users.mobile]'),
		array('field'=>'address','label'=>'lang:address','rules'=>'trim|xss_clean'),
		array('field'=>'dob','label'=>'lang:date of borth','rules'=>'trim|is_date|xss_clean'),
		array('field'=>'email','label'=>'lang:email','rules'=>'valid_email|trim|xss_clean'),
		array('field'=>'username','label'=>'lang:username','rules'=>'alpha_numeric|min_length[6]|trim|max_length[64]|xss_clean|is_unique[users.username]'),
		array('field'=>'password','label'=>'lang:password','rules'=>'special_char|min_length[6]|max_length[16]|trim|xss_clean'),
		array('field'=>'department_id','label'=>'lang:department','rules'=>'trim|required'),
		array('field'=>'designation_id','label'=>'lang:designation','rules'=>'trim|required'),
		array('field'=>'gender','label'=>'lang:gender','rules'=>'trim'),
		array('field'=>'age','label'=>'lang:age','rules'=>'trim|xss_clean|is_natural'),
		array('field'=>'religion','label'=>'lang:religion','rules'=>'trim'),
		array('field'=>'family_details','label'=>'lang:family-details','rules'=>'trim|xss_clean'),
		array('field'=>'branch_id','label'=>'lang:branch-name','rules'=>'required'),
		array('field'=>'qualification','label'=>'lang:qualification','rules'=>'trim|xss_clean'),
		array('field'=>'experience','label'=>'lang:experience','rules'=>'trim|xss_clean'),
		array('field'=>'date_of_join','label'=>'lang:date-of-join','rules'=>'required|is_date'),
		array('field'=>'marital_status','label'=>'lang:marital_status','rules'=>'required'),
		array('field'=>'date_of_marriage','label'=>'lang:date-of-marriage','rules'=>'is_date|trim|xss_clean'),
		array('field'=>'target','label'=>'lang:target','xss_clean|trim')


	),
	/*'users/update'=>array(
		array('field'=>'fname','label'=>'lang:first name','rules'=>'required|trim|xss_clean'),
		array('field'=>'lname','label'=>'lang:last name','rules'=>'trim|xss_clean'),
		array('field'=>'landline','label'=>'lang:land line','rules'=>'trim|xss_clean'),
		array('field'=>'mobile','label'=>'lang:mobile','rules'=>'required|trim|xss_clean|is_natural|exact_length[10]|is_edit_unique[users.mobile'),
		array('field'=>'address','label'=>'lang:address','rules'=>'trim|xss_clean'),
		array('field'=>'dob','label'=>'lang:date of borth','rules'=>'trim|is_date|xss_clean'),
		array('field'=>'email','label'=>'lang:email','rules'=>'valid_email|trim|xss_clean'),
		array('field'=>'username','label'=>'lang:username','rules'=>'alpha_numeric|min_length[6]|trim|max_length[64]|xss_clean|is_edit_unique[users.username]'),
		array('field'=>'password','label'=>'lang:password','rules'=>'special_char|min_length[6]|max_length[16]|trim|xss_clean'),
		array('field'=>'department_id','label'=>'lang:department','rules'=>'trim|required'),
		array('field'=>'designation_id','label'=>'lang:designation','rules'=>'trim|required'),
		array('field'=>'gender','label'=>'lang:gender','rules'=>'trim'),
		array('field'=>'age','label'=>'lang:age','rules'=>'trim|xss_clean|is_natural'),
		array('field'=>'religion','label'=>'lang:religion','rules'=>'trim|xss_clean'),
		array('field'=>'family_details','label'=>'lang:family-details','rules'=>'trim|xss_clean'),
		array('field'=>'branch_id','label'=>'lang:branch-name','rules'=>'required'),
		array('field'=>'qualification','label'=>'lang:qualification','rules'=>'trim|xss_clean'),
		array('field'=>'experience','label'=>'lang:experience','rules'=>'trim|xss_clean'),
		array('field'=>'date_of_join','label'=>'lang:date-of-join','rules'=>'required|is_date'),
		array('field'=>'marital_status','label'=>'lang:marital_status','rules'=>'required'),
		array('field'=>'date_of_marriage','label'=>'lang:date-of-marriage','rules'=>'is_date|trim|xss_clean'),
		array('field'=>'target','label'=>'lang:target','xss_clean|trim')


	),
	'company/info'=>array(
		array('field'=>'company_name','label'=>'lang:company-name','rules'=>'required|trim|xss_clean'),
		array('field'=>'company_landline','label'=>'lang:landline','rules'=>'required|trim|xss_clean'),
		array('field'=>'company_mobile','label'=>'lang:mobile','rules'=>'required|trim|xss_clean'),
		array('field'=>'company_address','label'=>'lang:company-address','rules'=>'required|trim|xss_clean'),
		array('field'=>'company_website','label'=>'lang:company-site','rules'=>'trim|xss_clean'),
		array('field'=>'company_email','label'=>'lang:company-email','rules'=>'trim|xss_clean|valid_emails'),
		array('field'=>'company_register_no','label'=>'lang:regno','rules'=>'trim|xss_clean'),
		array('field'=>'branch[area_id]','label'=>'lang:area1','rules'=>'trim|xss_clean'),
		array('field'=>'tax_type','label'=>'lang:tax-type','rules'=>'trim|xss_clean'),
		array('field'=>'cst_no','label'=>'lang:cst-no','rules'=>'trim|xss_clean'),
		array('field'=>'tin_no','label'=>'lang:tin-no','rules'=>'trim|xss_clean'),
		array('field'=>'presum_tax','label'=>'lang:presum-tax','rules'=>'trim|xss_clean')

	),*/
	'retailers/add'=>array(
		array('field'=>'retailer_name','label'=>'lang:name','rules'=>'required|trim|xss_clean|is_unique[retailer_master.retailer_name]'),
		array('field'=>'retailer_short_name','label'=>'lang:short-name','rules'=>'xss_clean|is_unique[retailer_master.retailer_short_name]'),
		array('field'=>'retailer_landline','label'=>'lang:landline','rules'=>'is_natural|trim|xss_clean'),
		array('field'=>'retailer_mobile','label'=>'lang:mobile','rules'=>'required|trim|xss_clean|is_natural|exact_length[10]|is_unique[retailer_master.retailer_mobile]'),
		array('field'=>'retailer_email','label'=>'lang:email','rules'=>'trim|xss_clean|valid_emails'),
		array('field'=>'retailer_address','label'=>'lang:email','rules'=>'trim|xss_clean'),
		array('field'=>'tin_no','label'=>'lang:tin-no','rules'=>'required|trim|xss_clean'),
		array('field'=>'area_id','label'=>'lang:area1','rules'=>'required|trim|xss_clean'),
		array('field'=>'fname','label'=>'lang:first name','rules'=>'required|trim|xss_clean'),
		array('field'=>'lname','label'=>'lang:last name','rules'=>'trim|xss_clean'),
		array('field'=>'email','label'=>'lang:email','rules'=>'trim|xss_clean'),
		array('field'=>'username','label'=>'lang:username','rules'=>'alpha_numeric|min_length[6]|trim|max_length[64]|xss_clean|is_unique[users.username]'),
		array('field'=>'password','label'=>'lang:password','rules'=>'special_char|min_length[6]|max_length[16]|trim|xss_clean'),
		array('field'=>'credit_limit','label'=>'lang:credit-limit','rules'=>'integer|trim|xss_clean'),
		array('field'=>'open_amount','label'=>'lang:opening-blance','rules'=>'greater_than|trim|xss_clean'),
		array('field'=>'dc_type','label'=>'lang:dc','rules'=>'trim|xss_clean')
	),
			
	'retailers/update'=>array(
		array('field'=>'retailer_name','label'=>'lang:name','rules'=>'required|trim|xss_clean'),
		array('field'=>'retailer_short_name','label'=>'lang:short-name','rules'=>'xss_clean|'),
		array('field'=>'retailer_landline','label'=>'lang:landline','rules'=>'is_natural|trim|xss_clean'),
		array('field'=>'retailer_mobile','label'=>'lang:mobile','rules'=>'required|trim|xss_clean|is_natural|exact_length[10]|is_edit_unique[retailer_master.retailer_mobile]'),
		array('field'=>'retailer_email','label'=>'lang:email','rules'=>'trim|xss_clean|valid_emails'),
		array('field'=>'retailer_address','label'=>'lang:mobile','rules'=>'trim|xss_clean'),
		array('field'=>'tin_no','label'=>'lang:tin-no','rules'=>'required|trim|xss_clean'),
		array('field'=>'area_id','label'=>'lang:area1','rules'=>'required|trim|xss_clean'),
		array('field'=>'fname','label'=>'lang:first name','rules'=>'required|trim|xss_clean'),
		array('field'=>'lname','label'=>'lang:last name','rules'=>'trim|xss_clean'),
		array('field'=>'email','label'=>'lang:email','rules'=>'trim|xss_clean'),
		array('field'=>'username','label'=>'lang:username','rules'=>'alpha_numeric|min_length[6]|trim|max_length[64]|xss_clean|callback_check_user_name'),
		array('field'=>'password','label'=>'lang:password','rules'=>'special_char|min_length[6]|max_length[16]|trim|xss_clean'),
		array('field'=>'credit_limit','label'=>'lang:credit-limit','rules'=>'integer|trim|xss_clean'),
		array('field'=>'open_amount','label'=>'lang:opening-blance','rules'=>'greater_than|trim|xss_clean'),
		array('field'=>'dc_type','label'=>'lang:dc','rules'=>'trim|xss_clean')
	),
			
	'branches/add'=>array(
		array('field'=>'branch_name','label'=>'lang:name','rules'=>'required|trim|xss_clean|is_unique[branch_master.branch_name]'),
		array('field'=>'branch_short_name','label'=>'lang:short-name','rules'=>'xss_clean|is_unique[branch_master.branch_short_name]'),
		array('field'=>'branch_landline','label'=>'lang:landline','rules'=>'trim|xss_clean'),
		array('field'=>'branch_mobile','label'=>'lang:mobile','rules'=>'required|trim|xss_clean|is_natural|exact_length[10]|is_unique[branch_master.branch_mobile]'),
		array('field'=>'branch_email','label'=>'lang:email','rules'=>'trim|xss_clean|valid_email'),
		array('field'=>'area_id','label'=>'lang:area1','rules'=>'required|trim|xss_clean'),
		array('field'=>'credit_limit','label'=>'lang:credit-limit','rules'=>'integer|trim|xss_clean'),
		array('field'=>'open_amount','label'=>'lang:opening-blance','rules'=>'greater_than|trim|xss_clean'),
		array('field'=>'dc_type','label'=>'lang:dc','rules'=>'trim|xss_clean')
		//array('field'=>'stock_capacity','label'=>'lang:stock-capacity','rules'=>'trim|xss_clean')	
		//array('field'=>'branch_target','label'=>'lang:target','rules'=>'trim|xss_clean'),
	),
	'branches/update'=>array(
		array('field'=>'branch_name','label'=>'lang:name','rules'=>'required|trim|xss_clean|is_edit_unique[branch_master.branch_name]'),
		array('field'=>'branch_short_name','label'=>'lang:short-name','rules'=>'trim|xss_clean|is_edit_unique[branch_master.branch_short_name]'),
		array('field'=>'branch_landline','label'=>'lang:landline','rules'=>'trim|xss_clean'),
		array('field'=>'branch_mobile','label'=>'lang:mobile','rules'=>'required|trim|xss_clean|is_natural|exact_length[10]|is_edit_unique[branch_master.branch_mobile]'),
		array('field'=>'branch_email','label'=>'lang:email','rules'=>'trim|xss_clean|valid_emails'),
		array('field'=>'branch_address','label'=>'lang:mobile','rules'=>'trim|xss_clean'),
		array('field'=>'area_id','label'=>'lang:area1','rules'=>'required|trim|xss_clean'),
		array('field'=>'credit_limit','label'=>'lang:credit-limit','rules'=>'integer|trim|xss_clean'),
		array('field'=>'open_amount','label'=>'lang:opening-blance','rules'=>'greater_than|trim|xss_clean'),
		array('field'=>'dc_type','label'=>'lang:dc','rules'=>'trim|xss_clean')

	),
	
	'vehicles/add'=>array(
		array('field'=>'vehicle_type_id','label'=>'lang:v_type','rules'=>'required|trim|xss_clean'),
		array('field'=>'vehicle_no','label'=>'lang:vehicle-no','rules'=>'required|trim|xss_clean|callback_check_vehicle_no'),
		#array('field'=>'vehicle_no','label'=>'lang:vehicle-no','rules'=>'required|trim|is_unique[vehicle_master.vehicle_no]|xss_clean'),
		array('field'=>'vehicle_chasis_no','label'=>'lang:chasis-no','rules'=>'required|trim|xss_clean'),
		array('field'=>'vehicle_rc_no','label'=>'lang:rc-no','rules'=>'required|trim|xss_clean'),
		array('field'=>'vehicle_mileage','label'=>'lang:mileage','rules'=>'required|trim|xss_clean'),
		array('field'=>'insurance_no','label'=>'lang:insurance-no','rules'=>'required|trim|xss_clean'),
		array('field'=>'insurance_company','label'=>'lang:company','rules'=>'required|trim|xss_clean'),
		array('field'=>'insurance_valid_from','label'=>'lang:valid-from','rules'=>'trim|xss_clean'),
		array('field'=>'insurance_to','label'=>'lang:valid-to','rules'=>'trim|xss_clean'),
		array('field'=>'insurance_amount','label'=>'lang:amount','rules'=>'required|trim|xss_clean|is_natural_no_zero'),
		array('field'=>'loan_provider','label'=>'lang:loan-provider','rules'=>'trim|xss_clean'),
		array('field'=>'loan_amount','label'=>'lang:loan-amount','rules'=>'trim|xss_clean|is_natural_no_zero'),
		array('field'=>'down_payment','label'=>'lang:down-payment','rules'=>'trim|xss_clean|is_natural_no_zero'),
		array('field'=>'monthly_payment','label'=>'lang:monthly-payment','rules'=>'trim|xss_clean|is_natural_no_zero'),
		array('field'=>'loan_bal_amount','label'=>'lang:balance-amount','rules'=>'trim|xss_clean|is_natural_no_zero')
	),
	
	/*'products/add'=>array(
		array('field'=>"item[item_name]",'label'=>'lang:item-name','rules'=>'required|trim|xss_clean'),
		array('field'=>"item[item_type_id]",'label'=>'lang:item-type','rules'=>'required|trim|xss_clean'),
		array('field'=>"item[item_manufacturer_id]",'label'=>'lang:manufacturer-name','rules'=>'required|trim|xss_clean'),
		array('field'=>"item[unit]",'label'=>'lang:unit','rules'=>'required|trim|xss_clean'),
		array('field'=>"item[alt_unit_id]",'label'=>'lang:alternate-unit','rules'=>'trim|xss_clean'),
		array('field'=>"item[conversion]",'label'=>'lang:conversion','rules'=>'trim|xss_clean'),
		array('field'=>"item[commodity_code]",'label'=>'lang:commodity-code','rules'=>'required|trim|xss_clean')
	),*/

	'vehicles/update'=>array(
		array('field'=>'vehicle_type_id','label'=>'lang:type','rules'=>'required|trim|xss_clean'),
		array('field'=>'vehicle_no','label'=>'lang:vehicle-no','rules'=>'required|trim'),
		array('field'=>'vehicle_no','label'=>'lang:vehicle-no','rules'=>'required|trim'),
		array('field'=>'vehicle_chasis_no','label'=>'lang:chasis-no','rules'=>'required|trim|xss_clean'),
		array('field'=>'vehicle_rc_no','label'=>'lang:rc-no','rules'=>'required|trim|xss_clean'),
		array('field'=>'vehicle_mileage','label'=>'lang:mileage','rules'=>'required|trim|xss_clean'),
		array('field'=>'insurance_no','label'=>'lang:insurance-no','rules'=>'trim|xss_clean'),
		array('field'=>'insurance_company','label'=>'lang:company','rules'=>'trim|xss_clean'),
		array('field'=>'insurance_valid_from','label'=>'lang:valid-from','rules'=>'trim|xss_clean'),
		array('field'=>'insurance_to','label'=>'lang:valid-to','rules'=>'trim|xss_clean'),
		array('field'=>'insurance_amount','label'=>'lang:amount','rules'=>'trim|xss_clean|numeric'),
		array('field'=>'loan_provider','label'=>'lang:loan-provider','rules'=>'trim|xss_clean'),
		array('field'=>'loan_amount','label'=>'lang:loan-amount','rules'=>'trim|xss_clean|numeric'),
		array('field'=>'down_payment','label'=>'lang:down-payment','rules'=>'trim|xss_clean|numeric'),
		array('field'=>'monthly_payment','label'=>'lang:monthly-payment','rules'=>'trim|xss_clean|numeric'),
		array('field'=>'loan_bal_amount','label'=>'lang:balance-amount','rules'=>'trim|xss_clean|numeric')
	),
	'vehicles/add_fuel'=>array(
		array('field'=>'vehicle_id','label'=>'lang:vehicle','rules'=>'required|trim|xss_clean'),
		array('field'=>'driver_id','label'=>'lang:driver','rules'=>'required|trim|xss_clean'),
		array('field'=>'bill_no','label'=>'lang:bill-no','rules'=>'required|trim|xss_clean'),
		array('field'=>'fuel_quantity','label'=>'lang:fuel-quantity','rules'=>'required|trim|xss_clean'),
		array('field'=>'fuel_amount','label'=>'lang:fuel-amount','rules'=>'required|trim|xss_clean|is_natural_no_zero'),
		array('field'=>'last_odometer_reading','label'=>'lang:last-odo-reading','rules'=>'required|trim|xss_clean|is_natural_no_zero'),
		array('field'=>'filling_date','label'=>'lang:filling-date','rules'=>'required|valid_date|trim|xss_clean'),
		array('field'=>'pump_name','label'=>'lang:pump-name','rules'=>'required|trim|xss_clean'),
		array('field'=>'fuel_mode','label'=>'lang:fuel-mode','rules'=>'trim|xss_clean'),
		array('field'=>'payment_mode','label'=>'lang:payment-mode','rules'=>'trim|xss_clean|required')
	),
	'vehicles/edit_fuel'=>array(
		array('field'=>'vehicle_id','label'=>'lang:vehicle','rules'=>'required|trim|xss_clean'),
		array('field'=>'driver_id','label'=>'lang:driver','rules'=>'required|trim|xss_clean'),
		array('field'=>'bill_no','label'=>'lang:bill-no','rules'=>'required|trim|xss_clean'),
		array('field'=>'fuel_quantity','label'=>'lang:fuel-quantity','rules'=>'required|trim|xss_clean'),
		array('field'=>'fuel_amount','label'=>'lang:fuel-amount','rules'=>'required|trim|xss_clean|numeric'),
		array('field'=>'last_odometer_reading','label'=>'lang:last-odo-reading','rules'=>'required|trim|xss_clean|numeric'),
		array('field'=>'filling_date','label'=>'lang:filling-date','rules'=>'required|trim|xss_clean'),
		array('field'=>'pump_name','label'=>'lang:pump-name','rules'=>'required|trim|xss_clean'),
		array('field'=>'fuel_mode','label'=>'lang:fuel-mode','rules'=>'trim|xss_clean'),
		array('field'=>'payment_mode','label'=>'lang:payment-mode','rules'=>'trim|xss_clean|required')
	),
	'masons/add'=>array(
		array('field'=>'fname','label'=>'lang:first name','rules'=>'required|trim|xss_clean'),
		array('field'=>'lname','label'=>'lang:last name','rules'=>'trim|xss_clean'),
		array('field'=>'landline','label'=>'lang:land line','rules'=>'trim|xss_clean'),
		array('field'=>'mobile','label'=>'lang:mobile','rules'=>'required|trim|xss_clean|is_natural|exact_length[10]|is_unique[users.mobile]'),
		array('field'=>'address','label'=>'lang:address','rules'=>'trim|xss_clean'),
		array('field'=>'dob','label'=>'lang:date of borth','rules'=>'is_date|xss_clean'),
		array('field'=>'email','label'=>'lang:email','rules'=>'valid_email|trim|xss_clean'),
		array('field'=>'username','label'=>'lang:username','rules'=>'trim|xss_clean|is_unique[users.username]'),
		array('field'=>'password','label'=>'lang:password','rules'=>'trim|xss_clean'),
		array('field'=>'area_id','label'=>'lang:area1','rules'=>'required|trim|xss_clean'),
		array('field'=>'gender','label'=>'lang:gender','rules'=>'trim'),
		array('field'=>'age','label'=>'lang:age','rules'=>'trim|xss_clean|is_natural'),
		array('field'=>'religion','label'=>'lang:religion','rules'=>'trim'),
		array('field'=>'family_details','label'=>'lang:family-details','rules'=>'trim|xss_clean'),
		array('field'=>'qualification','label'=>'lang:qualification','rules'=>'trim|xss_clean'),
		array('field'=>'experience','label'=>'lang:experience','rules'=>'trim|xss_clean'),
		array('field'=>'marital_status','label'=>'lang:marital_status','rules'=>'required'),
		array('field'=>'date_of_marriage','label'=>'lang:date-of-marriage','rules'=>'is_date|trim|xss_clean'),
		array('field'=>'branch_id','label'=>'lang:branch-name','rules'=>'required|trim|xss_clean')
		//array('field'=>'under_id','label'=>'lang:under','rules'=>'trim|xss_clean')*/
		//array('field'=>'target','label'=>'lang:target','xss_clean|trim')
	),
	'masons/edit'=>array(
		array('field'=>'fname','label'=>'lang:first name','rules'=>'required|trim|xss_clean'),
		array('field'=>'lname','label'=>'lang:last name','rules'=>'trim|xss_clean'),
		array('field'=>'landline','label'=>'lang:land line','rules'=>'trim|xss_clean'),
		array('field'=>'mobile','label'=>'lang:mobile','rules'=>'required|trim|xss_clean|is_natural|exact_length[10]|is_edit_unique[users.mobile]'),
		array('field'=>'address','label'=>'lang:address','rules'=>'xss_clean'),
		array('field'=>'dob','label'=>'lang:date of borth','rules'=>'is_date|xss_clean'),
		array('field'=>'email','label'=>'lang:email','rules'=>'valid_email|trim|xss_clean'),
		array('field'=>'username','label'=>'lang:username','rules'=>'trim|xss_clean|is_edit_unique[users.username]'),
		array('field'=>'password','label'=>'lang:password','rules'=>'trim|xss_clean'),
		array('field'=>'area_id','label'=>'lang:area1','rules'=>'required|trim|xss_clean'),
		array('field'=>'gender','label'=>'lang:gender','rules'=>'trim'),
		array('field'=>'age','label'=>'lang:age','rules'=>'trim|xss_clean|is_natural'),
		array('field'=>'religion','label'=>'lang:religion','rules'=>'trim'),
		array('field'=>'family_details','label'=>'lang:family-details','rules'=>'trim|xss_clean'),
		array('field'=>'qualification','label'=>'lang:qualification','rules'=>'trim|xss_clean'),
		array('field'=>'experience','label'=>'lang:experience','rules'=>'trim|xss_clean'),
		array('field'=>'marital_status','label'=>'lang:marital_status','rules'=>'required'),
		array('field'=>'date_of_marriage','label'=>'lang:date-of-marriage','rules'=>'is_date|trim|xss_clean'),
		array('field'=>'branch_id','label'=>'lang:branch','rules'=>'required|trim|xss_clean')
		/*array('field'=>'under_type','label'=>'lang:under','rules'=>'trim|xss_clean'),
		array('field'=>'under_id','label'=>'lang:under','rules'=>'trim|xss_clean')*/
		//array('field'=>'target','label'=>'lang:target','xss_clean|trim')
	),
	'engineers/add'=>array(
		array('field'=>'fname','label'=>'lang:first name','rules'=>'required|trim|xss_clean'),
		array('field'=>'lname','label'=>'lang:last name','rules'=>'trim|xss_clean'),
		array('field'=>'landline','label'=>'lang:land line','rules'=>'trim|xss_clean'),
		array('field'=>'mobile','label'=>'lang:mobile','rules'=>'required|trim|xss_clean|is_natural|exact_length[10]|is_unique[users.mobile]'),
		array('field'=>'address','label'=>'lang:address','rules'=>'trim|xss_clean'),
		array('field'=>'dob','label'=>'lang:date of borth','rules'=>'trim|is_date|xss_clean'),
		array('field'=>'email','label'=>'lang:email','rules'=>'valid_email|trim|xss_clean'),
		array('field'=>'username','label'=>'lang:username','rules'=>'alpha_numeric|min_length[6]|trim|xss_clean|is_unique[users.username]'),
		array('field'=>'password','label'=>'lang:password','rules'=>'special_char|min_length[6]|max_length[16]|trim|xss_clean'),
		array('field'=>'gender','label'=>'lang:gender','rules'=>'trim'),
		array('field'=>'age','label'=>'lang:age','rules'=>'trim|xss_clean|is_natural'),
		array('field'=>'religion','label'=>'lang:religion','rules'=>'trim'),
		array('field'=>'work_area','label'=>'lang:area','rules'=>'trim|xss_clean'),
		array('field'=>'family_details','label'=>'lang:family-details','rules'=>'trim|xss_clean'),
		array('field'=>'qualification','label'=>'lang:qualification','rules'=>'trim|xss_clean'),
		array('field'=>'experience','label'=>'lang:experience','rules'=>'trim|xss_clean'),
		array('field'=>'marital_status','label'=>'lang:marital_status','rules'=>'required'),
		array('field'=>'date_of_marriage','label'=>'lang:date-of-marriage','rules'=>'is_date|trim|xss_clean'),

		array('field'=>'company[company_name]','label'=>'lang:company-name','rules'=>'trim|xss_clean'),

		array('field'=>'company[company_address]','label'=>'lang:company-address','rules'=>'trim|xss_clean'),
		array('field'=>'company[phone_no]','label'=>'lang:phone-number','rules'=>'trim|xss_clean'),
		array('field'=>'branch_id','label'=>'lang:branch','rules'=>'required|trim|xss_clean'),
		array('field'=>'area_id','label'=>'lang:area1','rules'=>'required|trim|xss_clean')
	
	),
	'engineers/update'=>array(
		array('field'=>'fname','label'=>'lang:first name','rules'=>'required|trim|xss_clean'),
		array('field'=>'lname','label'=>'lang:last name','rules'=>'trim|xss_clean'),
		array('field'=>'landline','label'=>'lang:land line','rules'=>'trim|xss_clean|'),
		array('field'=>'mobile','label'=>'lang:mobile','rules'=>'required|trim|xss_clean|is_natural|exact_length[10]|is_edit_unique[users.mobile]'),
		array('field'=>'address','label'=>'lang:address','rules'=>'trim|xss_clean'),
		array('field'=>'dob','label'=>'lang:date of borth','rules'=>'trim|is_date|xss_clean'),
		array('field'=>'email','label'=>'lang:email','rules'=>'valid_email|trim|xss_clean'),
		array('field'=>'username','label'=>'lang:username','rules'=>'alpha_numeric|min_length[6]|trim|max_length[64]|xss_clean|is_edit_unique[users.username]'),
		array('field'=>'password','label'=>'lang:password','rules'=>'special_char|min_length[6]|max_length[16]|trim|xss_clean'),
		array('field'=>'gender','label'=>'lang:gender','rules'=>'trim'),
		array('field'=>'age','label'=>'lang:age','rules'=>'trim|xss_clean|is_natural'),
		array('field'=>'religion','label'=>'lang:religion','rules'=>'trim'),
		array('field'=>'work_area','label'=>'lang:area','rules'=>'trim|xss_clean'),
		array('field'=>'family_details','label'=>'lang:family-details','rules'=>'trim|xss_clean'),
		array('field'=>'qualification','label'=>'lang:qualification','rules'=>'trim|xss_clean'),
		array('field'=>'experience','label'=>'lang:experience','rules'=>'trim|xss_clean'),
		array('field'=>'marital_status','label'=>'lang:marital_status','rules'=>'required'),
		array('field'=>'date_of_marriage','label'=>'lang:date-of-marriage','rules'=>'is_date|trim|xss_clean'),
		array('field'=>'company[company_name]','label'=>'lang:company-name','rules'=>'trim|xss_clean|'),
		array('field'=>'company[company_address]','label'=>'lang:company-address','rules'=>'trim|xss_clean'),
		array('field'=>'company[phone_no]','label'=>'lang:landline','rules'=>'trim|xss_clean'),
		array('field'=>'branch_id','label'=>'lang:branch','rules'=>'required|trim|xss_clean'),
		array('field'=>'area_id','label'=>'lang:area1','rules'=>'required|trim|xss_clean')
	
	),
	'contractors/add'=>array(
		array('field'=>'fname','label'=>'lang:first name','rules'=>'required|trim|xss_clean'),
		array('field'=>'lname','label'=>'lang:last name','rules'=>'trim|xss_clean'),
		array('field'=>'landline','label'=>'lang:land line','rules'=>'trim|xss_clean'),
		array('field'=>'mobile','label'=>'lang:mobile','rules'=>'required|trim|xss_clean|is_natural|exact_length[10]|is_unique[users.mobile]'),
		array('field'=>'address','label'=>'lang:address','rules'=>'trim|xss_clean'),
		array('field'=>'dob','label'=>'lang:date of borth','rules'=>'is_date|trim|xss_clean'),
		array('field'=>'email','label'=>'lang:email','rules'=>'valid_email|trim|xss_clean'),
		array('field'=>'username','label'=>'lang:username','rules'=>'alpha_numeric|min_length[6]|trim|max_length[64]|xss_clean|is_unique[users.username]'),
		array('field'=>'password','label'=>'lang:password','rules'=>'special_char|min_length[6]|max_length[16]|trim|xss_clean'),
		array('field'=>'gender','label'=>'lang:gender','rules'=>'trim'),
		array('field'=>'age','label'=>'lang:age','rules'=>'trim|is_natural'),
		array('field'=>'religion','label'=>'lang:religion','rules'=>'trim'),
		array('field'=>'work_area','label'=>'lang:area','rules'=>'trim|xss_clean'),
		array('field'=>'family_details','label'=>'lang:family-details','rules'=>'trim|xss_clean'),
		array('field'=>'qualification','label'=>'lang:qualification','rules'=>'trim|xss_clean'),
		array('field'=>'experience','label'=>'lang:experience','rules'=>'trim|xss_clean'),
		array('field'=>'marital_status','label'=>'lang:marital_status','rules'=>'required'),
		array('field'=>'date_of_marriage','label'=>'lang:date-of-marriage','rules'=>'is_date|trim|xss_clean'),
		array('field'=>'company[company_name]','label'=>'lang:company-name','rules'=>'trim|xss_clean'),
		array('field'=>'company[company_address]','label'=>'lang:company-address','rules'=>'trim|xss_clean'),
		array('field'=>'company[phone_no]','label'=>'lang:landline','rules'=>'trim|xss_clean'),
		array('field'=>'branch_id','label'=>'lang:branch','rules'=>'required|trim|xss_clean'),
		array('field'=>'area_id','label'=>'lang:area1','rules'=>'required|trim|xss_clean')
	
	),
	'contractors/update'=>array(
		array('field'=>'fname','label'=>'lang:first name','rules'=>'required|trim|xss_clean'),
		array('field'=>'lname','label'=>'lang:last name','rules'=>'trim|xss_clean'),
		array('field'=>'landline','label'=>'lang:land line','rules'=>'trim|xss_clean'),
		array('field'=>'mobile','label'=>'lang:mobile','rules'=>'required|trim|xss_clean|is_natural|exact_length[10]|is_edit_unique[users.mobile]'),
		array('field'=>'address','label'=>'lang:address','rules'=>'trim|xss_clean'),
		array('field'=>'dob','label'=>'lang:date of borth','rules'=>'is_date|trim|xss_clean'),
		array('field'=>'email','label'=>'lang:email','rules'=>'valid_email|trim|xss_clean'),
		array('field'=>'username','label'=>'lang:username','rules'=>'alpha_numeric|min_length[6]|trim|max_length[64]|xss_clean|is_edit_unique[users.username]'),
		array('field'=>'password','label'=>'lang:password','rules'=>'special_char|min_length[6]|max_length[16]|trim|xss_clean'),
		array('field'=>'gender','label'=>'lang:gender','rules'=>'trim'),
		array('field'=>'age','label'=>'lang:age','rules'=>'trim|xss_clean|is_natural'),
		array('field'=>'religion','label'=>'lang:religion','rules'=>'trim'),
		array('field'=>'work_area','label'=>'lang:area','rules'=>'trim|xss_clean'),
		array('field'=>'family_details','label'=>'lang:family-details','rules'=>'trim|xss_clean'),
		array('field'=>'qualification','label'=>'lang:qualification','rules'=>'trim|xss_clean'),
		array('field'=>'experience','label'=>'lang:experience','rules'=>'trim|xss_clean'),
		array('field'=>'marital_status','label'=>'lang:marital_status','rules'=>'required'),
		array('field'=>'date_of_marriage','label'=>'lang:date-of-marriage','rules'=>'is_date|trim|xss_clean'),
		array('field'=>'company[company_name]','label'=>'lang:company-name','rules'=>'trim|xss_clean'),
		array('field'=>'company[company_address]','label'=>'lang:company-address','rules'=>'trim|xss_clean'),
		array('field'=>'company[phone_no]','label'=>'lang:landline','rules'=>'trim|xss_clean'),
		array('field'=>'branch_id','label'=>'lang:branch','rules'=>'required|trim|xss_clean'),
		array('field'=>'area_id','label'=>'lang:area1','rules'=>'required|trim|xss_clean')
	
	),
	'ledgers/add'=>array(
		array('field'=>'ledger_name','label'=>'lang:ledger-name','rules'=>'required|trim|xss_clean|is_unique[ledger_master.ledger_name]'),
		array('field'=>'tin_no','label'=>'lang:tin-no','rules'=>'trim|xss_clean'),
		array('field'=>'pincode','label'=>'lang:pincode','rules'=>'trim|xss_clean'),
		array('field'=>'pan_no','label'=>'lang:pan-it','rules'=>'trim|xss_clean'),
		array('field'=>'address','label'=>'lang:address','rules'=>'trim|xss_clean'),
		array('field'=>'vat_return','label'=>'lang:address','rules'=>'trim|xss_clean'),
		array('field'=>'access_value','label'=>'lang:address','rules'=>'trim|xss_clean'),
		array('field'=>'sub_group_id','label'=>'lang:under','rules'=>'required|trim|xss_clean'),
		array('field'=>'opening_balance','label'=>'lang:opening-blance','rules'=>'required|trim|xss_clean'),
		array('field'=>'opening_date','label'=>'lang:date','rules'=>'required|trim|xss_clean'),
		array('field'=>'description','label'=>'lang:description','rules'=>'trim|xss_clean')

	),
	'ledgers/update'=>array(
		array('field'=>'ledger_name','label'=>'lang:ledger-name','rules'=>'required|trim|xss_clean|is_edit_unique[ledger_master.ledger_name]'),
		array('field'=>'tin_no','label'=>'lang:tin-no','rules'=>'trim|xss_clean'),
		array('field'=>'pincode','label'=>'lang:pincode','rules'=>'trim|xss_clean'),
		array('field'=>'pan_no','label'=>'lang:pan-it','rules'=>'trim|xss_clean'),
		array('field'=>'address','label'=>'lang:address','rules'=>'trim|xss_clean'),
		array('field'=>'vat_return','label'=>'lang:address','rules'=>'trim|xss_clean'),
		array('field'=>'access_value','label'=>'lang:address','rules'=>'trim|xss_clean'),
		array('field'=>'sub_group_id','label'=>'lang:under','rules'=>'required|trim|xss_clean'),
		array('field'=>'opening_balance','label'=>'lang:opening-blance','rules'=>'required|trim|xss_clean'),
		array('field'=>'opening_date','label'=>'lang:date','rules'=>'required|trim|xss_clean'),
		array('field'=>'description','label'=>'lang:description','rules'=>'trim|xss_clean')
		),
	
	'products/update'=>array(
		array('field'=>"item[item_name]",'label'=>'lang:item-name','rules'=>'required|trim|xss_clean'),
		array('field'=>"item[item_type_id]",'label'=>'lang:item-type','rules'=>'required|trim|xss_clean'),
		array('field'=>"item[item_manufacturer_id]",'label'=>'lang:manufacturer-name','rules'=>'required|trim|xss_clean'),
		array('field'=>"unit[unit]",'label'=>'lang:unit','rules'=>'required|trim|xss_clean'),
		array('field'=>"unit[alternate_unit]",'label'=>'lang:alternate-unit','rules'=>'required|trim|xss_clean'),
		array('field'=>"item[hsn_code]",'label'=>'lang:hsn-code','rules'=>'required|trim|xss_clean'),
		array('field'=>"item[commodity_code]",'label'=>'lang:commodity-code','rules'=>'required|trim|xss_clean'),	
		array('field'=>"item[scheduled_no]",'label'=>'lang:schedule-no','rules'=>'required|trim|xss_clean'),
		array('field'=>"item[tariff_class]",'label'=>'lang:tariff-class','rules'=>'required|trim|xss_clean'),
		array('field'=>"item[cess_excempted]",'label'=>'lang:cess-exempted-or-not','rules'=>'required|trim|xss_clean'),
		array('field'=>"item[schedule_with_entry_no]",'label'=>'lang:schedule-with-entry-no','rules'=>'required|trim|xss_clean')
		

	),
	
	'sales_rpt/arwise'=>array(
		array('field'=>'from','label'=>'lang:from','rules'=>'is_date|required|xss_clean'),
		array('field'=>'to','label'=>'lang:to','rules'=>'is_date|required|xss_clean'),
		array('field'=>'ar_id','label'=>'lang:retailer','rules'=>'required|xss_clean')
	),

	'sales_rpt/branchwise'=>array(
		array('field'=>'from','label'=>'lang:from','rules'=>'is_date|required|xss_clean'),
		array('field'=>'to','label'=>'lang:to','rules'=>'is_date|required|xss_clean'),
		array('field'=>'branch_id','label'=>'lang:branch','rules'=>'required|xss_clean')
	),

	'graphs/emp_performance'=>array(

		array('field'=>'designation_id','label'=>'lang:designation','rules'=>'required|xss_clean|trim'),
		array('field'=>'from','label'=>'lang:from','rules'=>'required|xss_clean|trim|is_date'),
		array('field'=>'to','label'=>'lang:to','rules'=>'required|xss_clean|trim|is_date'),
		array('field'=>'item_id','label'=>'lang:item','rules'=>'required|xss_clean|trim')
	),

   //'vehicle_maintenance/add'=>array(
   	//array('field'=>'under_type','label'=>'lang:type','rules'=>'required|trim|xss_clean'),
   //	array('field'=>'vehicle_no','label'=>'lang:vehicle-no','rules'=>'required|trim|is_unique[vehicle_master.vehicle_no]|xss_clean'),
   	//array('field'=>'maintenance','label'=>'lang:maintenanec','rules'=>'required|trim|xss_clean'),
   //	array('field'=>'descriptions','label'=>'lang:descriptions','rules'=>'required|trim|xss_clean'),
   	//array('field'=>'payments','label'=>'lang:payments','rules'=>'required|trim|xss_clean'),
   	//array('field'=> 'payment_mode','label'=>'lang:payment_mode','rules'=>'trim|xss_clean'),
   	//array('field'=>'maintenance_date','label'=>'lang:maintenance_date','rules'=>'trim|xss_clean')

   	//)
	//)
	
	//ragesh code starts here
	//voucher add
	'vouchers/add' =>array(
		array('field' => 'voucher_name','label' => 'lang:voucher_name','rules' => 'required|xss_clean|trim'),
		array('field' => 'voucher_no','label' => 'lang:voucher_no','rules' => 'required|xss_clean|numeric'),
		array('field' => 'debit','label' => 'lang:debit','rules' => 'required|xss_clean'),
		array('field' => 'credit','label' => 'lang:credit','rules' => 'required|xss_clean')
	),	
	//ragesh code starts here
	'customer_master/add' =>array(

		array('field'=>'fname','label'=>'lang:first name','rules'=>'required|trim|xss_clean'),
		array('field'=>'lname','label'=>'lang:last name','rules'=>'trim|xss_clean'),
		array('field'=>'address','label'=>'lang:address','rules'=>'trim|xss_clean'),
		array('field'=>'phone_no','label'=>'lang:land line','rules'=>'trim|xss_clean'),
		array('field'=>'mobile_no','label'=>'lang:mobile','rules'=>'numeric|required|trim|xss_clean|exact_length[10]|is_unique[customer_master.mobile_no]'),
		array('field'=>'state','label'=>'lang:state','rules'=>'trim|xss_clean'),
		array('field'=>'district','label'=>'lang:district','rules'=>'trim|xss_clean'),
		array('field'=>'email_id','label'=>'lang:email','rules'=>'trim|xss_clean|valid_email'),
		//array('field'=>'branch_id','label'=>'lang:branch','rules'=>'required|trim|xss_clean'),
		array('field'=>'area_id','label'=>'lang:area1','rules'=>'required|trim|xss_clean'),
		array('field'=>'open_amount','label'=>'lang:opening-blance','rules'=>'trim|xss_clean'),
		array('field'=>'dc_type','label'=>'lang:dc','rules'=>'trim|xss_clean')
	),
	'customer_master/update' =>array(

		array('field'=>'fname','label'=>'lang:first name','rules'=>'required|trim|xss_clean'),
		array('field'=>'lname','label'=>'lang:last name','rules'=>'trim|xss_clean'),
		array('field'=>'address','label'=>'lang:address','rules'=>'trim|xss_clean'),
		array('field'=>'phone_no','label'=>'lang:land line','rules'=>'trim|xss_clean'),
		array('field'=>'mobile_no','label'=>'lang:mobile','rules'=>'numeric|required|trim|xss_clean|exact_length[10]|is_edit_unique[customer_master.mobile_no]'),
		array('field'=>'state','label'=>'lang:state','rules'=>'trim|xss_clean'),
		array('field'=>'district','label'=>'lang:district','rules'=>'trim|xss_clean'),
		array('field'=>'email_id','label'=>'lang:email','rules'=>'trim|xss_clean|valid_email'),
		//array('field'=>'branch_id','label'=>'lang:branch','rules'=>'required|trim|xss_clean'),
		array('field'=>'area_id','label'=>'lang:area1','rules'=>'required|trim|xss_clean'),
		array('field'=>'open_amount','label'=>'lang:opening-blance','rules'=>'trim|xss_clean'),
		array('field'=>'dc_type','label'=>'lang:dc','rules'=>'trim|xss_clean')
	)

);
?>
