<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

class Account_group_reports extends MY_Controller{

	public function __construct()
	{
		parent :: __construct();		
		$this->check_access_right();

		$this->load->library('Accounts');
	}
	
	public function index()
	{
		$fiscal_start_date = $this->dms->get_fiscal_year()['start_date'];
		$from_date = $to_date = $fiscal_start_date;		
		$vouchers_array = array();$sub_group_id = $dc = "";$opening_bal = 0;$tbp = "";
		$breadcrumb = array($this->lang->line('account-reports') => 'no_link',$this->lang->line('account-groups') => 'no_link');
		
		if(isset($_POST['btn_search']))
		{
			#-------------validation
			$this->form_validation->set_rules('sub_group_id','lang:sub-group','required|xss_clean');
			$this->form_validation->set_rules('from_date','lang:from-date','required|xss_clean|valid_date');
			if($this->input->post('from_date',true))
			{
				$from_date = $this->input->post('from_date',true);
				$this->form_validation->set_rules('to_date','lang:to-date',"required|xss_clean|valid_date|check_date[$from_date.>=]");
			}
			if($this->form_validation->run() === true)
			{
				$sub_group_id = $this->input->post('sub_group_id',true);
				$from_date = date('Y-m-d',strtotime($this->input->post('from_date',true)));
				$to_date = date('Y-m-d',strtotime($this->input->post('to_date',true)));
				$this->session->set_userdata(array('from_date' => $from_date,'to_date' => $to_date));
			}
		}
		else
		{
			if($this->uri->segment(3))
			{
				$sub_group_id = xss_clean($this->uri->segment(3));
				if($this->uri->segment(4) && $this->uri->segment(4) == 't')
				{
					$tbp = $this->uri->segment(4);
					$breadcrumb[$this->lang->line('go-back')] = "trial_balance/index";
				}
				elseif($this->uri->segment(4) && $this->uri->segment(4) == 'b')
				{
					$tbp = $this->uri->segment(4);
					$breadcrumb[$this->lang->line('go-back')] = "balance_sheet/index";
				}
				elseif($this->uri->segment(4) && $this->uri->segment(4) == 'p')
				{
					$tbp = $this->uri->segment(4);
					$breadcrumb[$this->lang->line('go-back')] = "profit_loss/index";
				}
				elseif($this->uri->segment(4) && $this->uri->segment(4) == 'c')
				{
					$tbp = $this->uri->segment(4);
					$breadcrumb[$this->lang->line('go-back')] = "cashbooks/index";
				}
			}
			if($this->session->userdata('from_date') && $this->session->userdata('to_date'))
			{
				$from_date = $this->session->userdata('from_date');
				$to_date = $this->session->userdata('to_date');				
				
				#----------validating dates
				if(!$this->form_validation->valid_date($from_date) || !$this->form_validation->valid_date($to_date)){
					redirect('users/logout');
				}
				else{
					if(!$this->form_validation->check_date($from_date,$to_date.".<=")){
						redirect('users/logout');
					}
				}
			}
		}		
		if(!empty($sub_group_id) && !empty($from_date) && !empty($to_date))
		{
			$next_date = date('Y-m-d',(strtotime($to_date)+86400));
				
			#---------ledgers of selected sub_group
			$ledger_array = $this->accounts->get_legders(array('columns' => array('a.id','a.ledger_name','a.dc'),'conditions' => array('a.sgroup_id' => $sub_group_id)));
			if(!empty($ledger_array))
			{
				$this->session->set_userdata(array('sub_group_id' => $sub_group_id,'from_date' => $from_date,'to_date' => $to_date));
				foreach($ledger_array as $key => $value)
				{
					$dr_amount = $cr_amount = 0;
					$opening_bal = 0;//$this->accounts->opening_bal($value['id'],$to_date);
					$voucher_bal = $this->accounts->voucher_bal($value['id'],$to_date,0,$from_date);
					if($value['dc'] == 'dr')
					{
						$voucher_amount = $opening_bal + ($voucher_bal['dr_amount'] - $voucher_bal['cr_amount']);
						if($voucher_amount > 0)
						{
							$dr_amount = $voucher_amount;
						}
						else
						{
							$cr_amount = -$voucher_amount;
						}
					}
					else
					{
						$voucher_amount = $opening_bal + ($voucher_bal['cr_amount'] - $voucher_bal['dr_amount']);
						if($voucher_amount > 0)
						{
							$cr_amount = $voucher_amount;
						}
						else
						{
							$dr_amount = -$voucher_amount;
						}
					}
					if($dr_amount > 0 || $cr_amount > 0)
					{
						$vouchers_array[$value['id']] = array('ledger_name' => $value['ledger_name'],'dr_amount' => $dr_amount,'cr_amount' => $cr_amount);
					}
				}
			}
		}		
				
		#-------------ledger details
		$sub_group_array = $this->accounts->get_account_groups();
		$sub_group_array[''] = "Select";
		ksort($sub_group_array);
		
		#-------------template
		$this->template->title('Account Groups Report');
		$this->template->main_heading('Account Groups Report');
		$this->template->breadcrumb($breadcrumb);
		$this->template->slice('account_reports/account_group_search',array('sub_groups' => $sub_group_array,'sub_group_id' => $sub_group_id,'from_date' => $from_date,'to_date' => $to_date,'astatus' => 0));		
		if(!empty($vouchers_array))
		{
			$access_rights = $this->have_access(514);
			$this->template->slice('account_reports/account_groups',array('voucher_array' => $vouchers_array,'sub_group_id' => $sub_group_id,'access_rights' => $access_rights,'tbp' => $tbp,'from_date' => $from_date,'to_date' => $to_date));
		}
		else{
			$this->message->set($this->lang->line('no-result-found'),'i');
		}
		$this->template->slice('dms/message');
		$this->template->render();
	}
}