<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Barcode extends MY_Controller {

    public function __construct() {
        parent::__construct();
        $this->CI = & get_instance();
    }

	public function index()
	{    
        $this->load->library(array('Stock','Zend','My_pdf','To_words','Barcode_lib'));
        $this->load->model('products/Item_model','item');
        
        $items = $this->barcode_lib->items();  

        if(isset($_POST['btn_sub']))
        { 
            $this->zend->load('Zend/Barcode');
		    $item_array = $this->input->post(NULL,true);
		    $code_array = array(); $total=0;
		        
		    for($i=1;$i<=10;$i++)
            {
                $item = $item_array['item'.$i];
                $item_det = explode("|",$item);
                $item_code = $item_det[0];
                $item_name = base64_encode($item_det[1]." ".$item_det[2]);
                $item_qty = $item_array['qty'.$i];
                $item_rate = $item_array['rate'.$i];
                              
                if($item_code!=null && $item_name!=null)  
                { 
                    $total += $item_qty;
                    $item_id = $this->stock->get_item_datas($item_code);
                    //$item_details = $this->stock->get_item($purchase['item_id'],array('item_code','item_name','model_no'));
                    $item_details = $this->stock->get_item($item_id,array('item_code','item_name','model_no'));
                    //$item_code = $item_details['item_code'];
                    $item_model = $item_details['model_no'];
                    $barcodeOptions = array('text' => $item_code,'barHeight'=> 15,'factor'=>1.5,'font'=>'assets/PTC55F.ttf','fontSize'=>10,'withQuietZones'=>true);
                    $rendererOptions = array();
				    $file = Zend_Barcode::draw('code128', 'image', $barcodeOptions, $rendererOptions);
                    $store_image = imagepng($file,"assets/barcode/{$item_code}.png");
                    $img_name = $item_code.'.png';
                    
                    $code_array[] = array('code'=>$item_code,'name'=>$item_name,'model'=>$item_model,'qty'=>$item_qty,'rate'=>$item_rate,'image'=>$img_name);
                }
            }
            
            $this->session->unset_userdata('dataArr');   
            $this->session->set_userdata("dataArr",json_encode($code_array));
			
			$link = base_url().'barcode/print_barcode';
			
			echo "<script> window.open('$link');</script>";
        }  
        
        $this->template->title($this->lang->line('generate-barcode'));
		$this->template->main_heading($this->lang->line('generate-barcode'));
        $this->template->breadcrumb(array($this->lang->line('products')=>'no_link',$this->lang->line('generate-barcode')=>'no_link'));
		$this->template->slice('dms/message'); 
		$this->template->slice('barcode/generate',array('items'=>$items,'itemcodes'=>$itemcodes)); 
        $this->template->other_script('barcode/barcode');
        $this->template->render(); 
    }
    
    public function bulk()
	{    
        $this->load->library(array('Stock','Zend','My_pdf','To_words','Barcode_lib'));
        $this->load->model('products/Item_model','item');
        
        $items = $code_array = array(); $item_group_id = '';
        if(isset($_POST['btn_get']))
        {
			$this->form_validation->set_rules('group_id','lang:item-group','required|xss_clean');
            if($this->form_validation->run('btn_get') === true)
            {
                $this->zend->load('Zend/Barcode');
                $item_group_id = $this->input->post('group_id',true);
                
                $results = $this->db->query("SELECT i.*,s.rate,s.qty from item_master as i inner join dms_stocks as s on i.id=s.item_id where i.item_group_id='$item_group_id' and s.stock_status='0' and s.status=1 order by i.id asc")->result_array();
                foreach($results as $row) {
                    $items[] = array('id'=>$row['id'], 'code'=>$row['item_code'], 'name'=>$row['item_name'], 'model'=>$row['model_no'], 'qty'=>$row['qty'], 'rate'=>$row['rate']);
                    $item_code = $row['item_code'];
                    $barcodeOptions = array('text' => $item_code,'barHeight'=> 15,'factor'=>1.5,'font'=>'assets/PTC55F.ttf','fontSize'=>10,'withQuietZones'=>true);
                    $rendererOptions = array();
                    $file = Zend_Barcode::draw('code128', 'image', $barcodeOptions, $rendererOptions);
                    $store_image = imagepng($file,"assets/barcode/{$item_code}.png");
                    $img_name = $item_code.'.png';
                    
                    $code_array[] = array('code'=>$item_code, 'name'=>$row['item_name'], 'model'=>$row['model_no'], 'qty'=>$row['qty'], 'rate'=>$row['rate'], 'image'=>$img_name);
                }
                
                $this->session->unset_userdata('dataArr');   
                $this->session->set_userdata("dataArr",json_encode($code_array));
            }
        }
        
        $item_groups = $this->item->item_group_listing();
		$item_groups['']  = 'Select';
		ksort($item_groups);
        
        $this->template->title($this->lang->line('bulk-barcode'));
		$this->template->main_heading($this->lang->line('bulk-barcode'));
        $this->template->breadcrumb(array($this->lang->line('products') => 'no_link', $this->lang->line('bulk-barcode') => 'no_link'));
		$this->template->slice('dms/message'); 
		$this->template->slice('barcode/bulk', array('item_groups' => $item_groups, 'item_group_id' => $item_group_id, 'items' => $items)); 
        $this->template->render(); 
    }
    
    public function print_barcode(){
                
        $company_id = $this->session->userdata('company_id');
        $qr_company = $this->db->select('company_short_name')->from('company_master')->where('id',$company_id)->get()->row_array();
        $company_name = $qr_company['company_short_name'];
        
        $codes = json_decode($this->session->userdata("dataArr"));
        $barcodes = array();
        foreach($codes as $key => $val)
        {
            $barcodes[] = array('code'=> $val->code,'name'=>$val->name,'model' => $val->model,'qty'=>$val->qty,'rate'=>$val->rate,'image'=>$val->image);
        }
        
		$this->load->view('barcode/code_pdf',array('barcodes' => $barcodes,'company'=>$company_name));	

       // $barcodes = $this->session->userdata("dataArr");
	
		//$this->load->view('barcode/code_pdf',array('barcodes' => $barcodes,'company'=>$company_name));		
	}
	
	
	#------------------------------------------------------------------------------------------------------------------------------------
	public function genarate_label()
	{    
        $this->load->library(array('Stock','Zend','My_pdf','To_words'));
        $this->load->model('products/Item_model','item');
        
        if(isset($_POST['btn_sub']))
        { 
            $this->zend->load('Zend/Barcode');
		    $label1 = $this->input->post('lab1');
		    $label2 = $this->input->post('lab2');
		    $quantity = $this->input->post('quantity');
		    
		    $barcodeOptions = array('barHeight'=> 15,'factor'=>1.5,'font'=>'assets/PTC55F.ttf','fontSize'=>10,'withQuietZones'=>true);
            $rendererOptions = array();
		    $code_array[] = array('label1'=>$label1,'label2'=>$label2,'quantity'=>$quantity);
            
            
            $this->session->unset_userdata('dataArr');   
            $this->session->set_userdata("dataArr",$code_array);
			
			$link = base_url().'barcode/print_label';
			
			echo "<script> window.open('$link');</script>";
        }
        
        $this->template->title($this->lang->line('generate-label'));
		$this->template->main_heading($this->lang->line('generate-label'));
        $this->template->breadcrumb(array($this->lang->line('products')=>'no_link',$this->lang->line('generate-label')=>'no_link'));
		$this->template->slice('dms/message'); 
		$this->template->slice('barcode/label_generate',array('items'=>$items,'itemcodes'=>$itemcodes)); 
        $this->template->other_script('barcode/barcode');
        $this->template->render(); 
    }

    public function print_label()
    {
        $company_id = $this->session->userdata('company_id');
        $qr_company = $this->db->select('company_short_name')->from('company_master')->where('id',$company_id)->get()->row_array();
        $company_name = $qr_company['company_short_name'];
        
        $labeles = $this->session->userdata("dataArr");
        
		$this->load->view('barcode/label_pdf',array('labeles' => $labeles,'company'=>$company_name));				
	}

	public function purchase()
	{    
        $this->load->library(array('Stock','Zend','My_pdf','To_words'));
        $this->load->model('products/Item_model','item');
        $this->load->model('purchase/Purchase_model','purchase_obj');
        
        if(!$this->uri->segment(4))
        {
			echo "<script>alert('".$this->lang->line('invalid-purchase-bill')."');window.close();</script>";
		}
		
		$purchase_id = $this->uri->segment(4);
		if($this->if_exists('dms_purchases',array('id'=>$purchase_id,'status'=>1)) === false)
		{
			echo "<script>alert('".$this->lang->line('invalid-purchase-bill')."');window.close();</script>";
		}
		
		$purchase_array = $this->purchase_obj->get_purchases_gst(array('columns' => array('a.vtype_id','a.bill_no','a.bill_date','a.invoice_no','a.invoice_date','a.group_id','a.vendor_id','a.bill_discount_per','a.bill_discount_amt','a.bill_freight','a.other_expense','a.cess','a.courier_charge','a.courier_gst','a.tax_type','a.narration','a.payment_mode','a.cr_period','a.created_by','a.created_on','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.discount_per','b.discount_amt','b.godown_id','b.cgst','b.sgst','b.igst','b.cgst_amt','b.sgst_amt','b.igst_amt'),'conditions' => array('a.id' => $purchase_id,'a.status !=' => 0,'b.status !=' => 0,'b.item_status >' => 0)));
    
        if(isset($_POST['btn_sub']))
        { 
            $this->zend->load('Zend/Barcode');
            $item_count = $_POST['total_items'];
    
            $code_array = array();
            for($i=1;$i<=$item_count;$i++)
            {
                if(isset($_POST["chk$i"]))
                {
                    $item_id = $_POST["item$i"];
                    $item_rate = $_POST["rate$i"];
                    $item_qty = $_POST["qty$i"];
                    
                    $item_details = $this->stock->get_item($item_id,array('item_code','item_name','model_no'));
                    $item_code = $item_details['item_code'];
                    $item_name = base64_encode($item_details['item_name']);
                    $item_model = $item_details['model_no'];
                    $barcodeOptions = array('text' => $item_code,'barHeight'=> 15,'factor'=>1.5,'font'=>'assets/PTC55F.ttf','fontSize'=>10,'withQuietZones'=>true);
                    $rendererOptions = array();
				    $file = Zend_Barcode::draw('code128', 'image', $barcodeOptions, $rendererOptions);
                    $store_image = imagepng($file,"assets/barcode/{$item_code}.png");
                    $img_name = $item_code.'.png';
                    
                    $code_array[] = array('code'=>$item_code,'name'=>$item_name,'model'=>$item_model,'qty'=>$item_qty,'rate'=>$item_rate,'image'=>$img_name);
                }    
            }
            
            $this->session->unset_userdata('dataArr');   
            $this->session->set_userdata("dataArr",json_encode($code_array));
			
			$link = base_url().'barcode/print_barcode';
			
			echo "<script> window.open('$link');</script>";
        }
    
    /*    if(empty($purchase_array))
        {
			echo "<script>alert('".$this->lang->line('invalid-purchase-bill')."');window.close();</script>";
		}
		else
		{
		    $this->zend->load('Zend/Barcode');
		    $code_array = array(); $total=0;
 
            foreach($purchase_array as $key => $purchase)
            {
                $item_details = $this->stock->get_item($purchase['item_id'],array('item_code','item_name','model_no'));
                $item_code = $item_details['item_code'];
                $item_name =  base64_encode($item_details['item_name']);
                $item_model = $item_details['model_no'];
                $item_qty = $purchase['qty'];
                $item_rate = $this->stock->get_item_rate($purchase['item_id']);
                
                //$barcodeOptions = array('text' => $item_code,'barHeight'=> 15,'factor'=>1.5);
                $barcodeOptions = array('text' => $item_code,'barHeight'=> 15,'factor'=>1.5,'font'=>'assets/PTC55F.ttf','fontSize'=>10,'withQuietZones'=>true);

                $rendererOptions = array();
				$file = Zend_Barcode::draw('code128', 'image', $barcodeOptions, $rendererOptions);
                $store_image = imagepng($file,"assets/barcode/{$item_code}.png");
                $img_name = $item_code.'.png';
                    
                $code_array[] = array('code'=>$item_code,'name'=>$item_name,'model'=>$item_model,'qty'=>$item_qty,'rate'=>$item_rate,'image'=>$img_name);
                 
            }
            
            
            $company_id = $this->session->userdata('company_id');
            $qr_company = $this->db->select('company_short_name')->from('company_master')->where('id',$company_id)->get()->row_array();
            $company_name = $qr_company['company_short_name'];
               
            $this->load->view('barcode/code_pdf',array('barcodes' => $code_array,'company'=>$company_name)); 
		}*/
		$this->template->title($this->lang->line('generate-barcode'));
		$this->template->main_heading($this->lang->line('generate-barcode'));
	    $this->template->breadcrumb(array($this->lang->line('products')=>'no_link',$this->lang->line('generate-barcode')=>'no_link'));
		$this->template->slice('dms/message'); 
		$this->template->slice('barcode/purchase',array('purchase_array'=>$purchase_array));
        $this->template->render(); 
	}
}