<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
	
	class Branches extends MY_Controller{


		#--------------------------------------------------------------------------------------------

		public function __construct(){

			parent :: __construct();
			$this->check_access_right();
			$this->load->model('branches/Branch_model','branch');
			$this->load->model('users/User_model','user');
			
			#---------------- Checking Financial year is enabled / closed-----------------#
			$method_array = array('add','update','delete');
			fiscal_status($this->uri->segment(2),$method_array,"branches/report");	
			#---------------- Checking Financial year is enabled / closed-----------------#							
		}

		#--------------------------------------------------------------------------------------------

		public function report(){

			$this->template->title($this->lang->line('branches'));
			$this->template->main_heading($this->lang->line('branch-settings'));
			$this->template->breadcrumb(array($this->lang->line('settings')=>'preferences/index',$this->lang->line('branches')=>'branches/add',$this->lang->line('report')=>'no_link'));
			$this->template->slice('dms/message');
			#pagination#
			$this->load->library('Pagination');
			$config['base_url'] = base_url('branches/report');
			$config['total_rows'] = $this->branch->get_all(array('company_id'=>$this->session->userdata('company_id'),'status'=>1),1);
			$config['per_page'] = $this->per_page();
			$config['uri_segment'] = 3;
			# Pagination Config Customizations
			$config['full_tag_open'] = '<ul class="pagination">';
			$config['full_tag_close'] = '</ul>';
			$config['first_link'] = 'First';
			$config['last_link'] = 'Last';
			$config['next_link'] = '&raquo;';
			$config['prev_link'] = '&laquo;';
			$config['cur_tag_open'] = '<li class="active"><a href="#">';
			$config['cur_tag_close'] = '</a></li>';
			$config['num_tag_open'] = '<li>';
			$config['num_tag_close'] = '</li>';
			$this->pagination->initialize($config);
			$offset = ($this->uri->segment(3))?$this->uri->segment(3):0;
			
			$user_det = array();
			if($this->session->userdata('id')=='-2' || $this->session->userdata('id')=='-1')
			{ 
			    $user_det = $this->user->get_all(array('users.id'=>$this->session->userdata('id')));
			}
			
			
			//$branch_id = $this->session->userdata('under_id');
            //$previous_status = $this->branch->get_previous_status($branch_id);
			$branches = $this->branch->get_all(array('company_id'=>$this->session->userdata('company_id'),'status'=>1),NULL,$config['per_page'],$offset);
			$links = $this->pagination->create_links();
			$this->template->slice('preferences/branches/report',array('branches'=>$branches,'count'=>$offset,'links'=>$links,'user_det'=>$user_det));
			$this->template->slice('dms/modals/more_details');
			$this->template->other_script('branches/show_branch');
			$this->template->slice('dms/modals/delete_confirm');
			$this->template->render();
		}

		#-----------------------------------------------------------------------------------

		public function add(){			
			
			$this->load->model('accounts/Ledger_model','ledger');
			if($this->form_validation->run('branches/add') === true){

				$data = $this->input->post(NULL,true);
				$open_amount = $this->input->post('open_amount',TRUE);
				$dc_type =  $this->input->post('dc_type',TRUE);

				#if no short-code, then company name itself
				$data['branch_short_name'] = ($data['branch_short_name'] != '')?$data['branch_short_name']:$data['branch_name'];
				$data['company_id'] = $this->session->userdata('company_id');
				unset($data['open_amount']);unset($data['dc_type']);
				if($this->branch->f_save('branch_master',$data)){

					$branch_id = $this->db->insert_id();
					$ledger['company_id'] = $this->session->userdata('company_id');
					$ledger['ledger_name'] = $data['branch_name'].'-'.$data['branch_mobile'];
					$ledger['branch_id'] = $this->session->userdata('under_id');;
					$ledger['sgroup_id'] = 15;
					$ledger['dc'] = $this->ledger->get_dc($ledger['sgroup_id']);
					$last_insert_id = $this->ledger->insert('dms_ledgers',$ledger);
					
					#update branch ledger id ;
					$this->branch->my_update('branch_master',array('ledger_id'=>$last_insert_id),array('id'=>$branch_id));
					$open['ledger_id'] = $last_insert_id ;
					if(!empty($open_amount)){
						if($dc_type != $ledger['dc']){
							$open['open_amount'] = -$open_amount;
						}else{
							$open['open_amount'] = $open_amount;
						}
						$open['company_id'] = $this->session->userdata('company_id');
						$open['branch_id'] = $ledger['branch_id'];
						$open['open_date'] = $this->dms->get_fiscal_year()['start_date'];
						$this->ledger->insert('dms_ledger_open_bals',$open);
					}
					
					#---------inserting godown details
					$godown['branch_id'] = $branch_id;
					$godown['godown_code'] = 'G1';
					$godown['godown_name'] = 'Main Godown';
					$godown['address'] = 'godown address';
					$this->branch->f_save('godown_master',$godown);
					$this->message->set($this->lang->line('branch-saved'));
				}else{
					$this->message->set($this->lang->line('branch-not-saved'));
				}
				redirect('branches/report');
			}

			#get all areas
			$this->load->model('areas/Area_model','area');
			$areas = $this->area->listing();
			$areas[''] = 'Select';ksort($areas);
			$dc_array = array('dr' => 'Dr','cr' => 'Cr');
			$this->template->title($this->lang->line('add-new-branch'));
			$this->template->main_heading($this->lang->line('branch-settings'));
			$this->template->breadcrumb(array($this->lang->line('settings')=>'preferences/index',$this->lang->line('branches')=>'no_link',$this->lang->line('report')=>'branches/report'));
			$this->template->slice('preferences/branches/new',array('areas'=>$areas,'dc_array'=>$dc_array));
			$this->template->render();
		}

		#-----------------------------------------------------------------------------------

		public function update($id){

			if(empty($id) || !$this->uri->segment(3)){
				redirect('branches/report');
			}
			$branch_id = $this->uri->segment(3);
			$this->load->model('accounts/Ledger_model','ledger');
			#get details of id
			$branch = $this->db->get_where('branch_master',array('id'=>$branch_id))->row_array();
			if(empty($branch)){
				redirect('branches/report');
			}
			$open_bal = array();
			if($branch['ledger_id'] !=0){
				$open_bal = $this->branch->open_balance($branch['ledger_id']);
			}
			#validation
			if($this->form_validation->run('branches/update') === true){

				$data = $this->input->post(NULL,TRUE);
				$open_amount = $this->input->post('open_amount',TRUE);
				$dc_type =  $this->input->post('dc_type',TRUE);
				unset($data['open_amount']);unset($data['dc_type']);
				if($this->input->post('open_id',TRUE)){

					if($open_amount !=0){

						$ledger['ledger_name'] = $data['branch_name'].'-'.$data['branch_mobile'];
						$ledger['sgroup_id'] = 15;
						$ledger['dc'] = $this->ledger->get_dc($ledger['sgroup_id']);
						$this->branch->my_update('dms_ledgers',$ledger,array('id'=>$data['ledger_id']));
						if($dc_type != $ledger['dc']){
							$open['open_amount'] = -$open_amount;
						}else{
							$open['open_amount'] = $open_amount;
						}					
						$this->branch->my_update('dms_ledger_open_bals',$open,array('id'=>$data['open_id'],'ledger_id'=>$data['ledger_id']));
						
					}else{
										
						#checking vat is set to open balence
						if($open_bal['vat'] == 1){

							$ledger['ledger_name'] = $data['branch_name'].'-'.$data['branch_mobile'];
							$ledger['sgroup_id'] = 15;
							$ledger['dc'] = $this->ledger->get_dc($ledger['sgroup_id']);
							$this->branch->my_update('dms_ledgers',$ledger,array('id'=>$data['ledger_id']));
							$open['open_amount'] = 0;
							$this->branch->my_update('dms_ledger_open_bals',$open,array('id'=>$data['open_id'],'ledger_id'=>$data['ledger_id']));

						}else{
							#delete dms_open_balance data 
							$this->branch->my_update('dms_ledger_open_bals',array('status'=>0),array('id'=>$data['open_id'],'ledger_id'=>$data['ledger_id']));
						}
					}
					unset($data['open_id']);
					unset($data['ledger_id']);
				}else{

					$ledger['ledger_name'] = $data['branch_name'].'-'.$data['branch_mobile'];
					$ledger['sgroup_id'] = 15;
					$ledger['dc'] = $this->ledger->get_dc($ledger['sgroup_id']);
					$this->branch->my_update('dms_ledgers',$ledger,array('id'=>$data['ledger_id']));
					if(!empty($open_amount)){

						if($dc_type != $ledger['dc']){
							$open['open_amount'] = -$open_amount;
						}else{
							$open['open_amount'] = $open_amount;
						}
						$open['company_id'] = $this->session->userdata('company_id');
						$open['ledger_id'] = $data['ledger_id'];
						$open['branch_id'] = $branch['id'];
						$open['open_date'] = $this->dms->get_fiscal_year()['start_date'];
						$this->ledger->insert('dms_ledger_open_bals',$open);
					}
					unset($data['ledger_id']);
				}

				if($this->branch->my_update('branch_master',$data,array('id'=>$id))){
					$this->message->set($this->lang->line('branch-updated'),'s');
				}else{
					$this->message->set($this->lang->line('branch-not-updated'),'e');	
				}
				redirect('branches/report');
			}

			#get all areas
			$this->load->model('areas/Area_model','area');
			$areas = $this->area->listing();
			$areas[''] = 'Select';ksort($areas);
			$dc_array = array('dr' => 'Dr','cr' => 'Cr');

			$this->template->title($this->lang->line('branch-settings'));
			$this->template->main_heading($this->lang->line('branch-settings'));
			$this->template->breadcrumb(array($this->lang->line('settings')=>'preferences/index',$this->lang->line('branches')=>'branches/add',$this->lang->line('update')=>'no_link',$this->lang->line('report')=>'branches/report'));
			$this->template->slice('preferences/branches/update',array('branch'=>$branch,'areas'=>$areas,'dc_array'=>$dc_array,'open_bal'=>$open_bal));
			$this->template->render();
		}

		#--------------------------------------------------------------------------------------------

		public function delete($id){

			if(empty($id) || !$this->uri->segment(3)){
				redirect('branches/report');
			}
			$id = $this->uri->segment(3);
			if($this->if_exists('branch_master',array('id'=>$id,'status'=>1)) === false){
				redirect('branches/report');
			}
			$branch = $this->db->get_where('branch_master',array('id'=>$id))->row_array();
			if(!empty($branch) && $branch['branch_type'] == 1){
				$this->message->set($this->lang->line('can-not-delete-main-branch'),'i');
				redirect('branches/report');
			}
			$ledgerID = $branch['ledger_id'];
			$total_users = $this->db->select('id')->get_where('users',array('branch_id'=>$id,'designation_id !='=>3,'status'=>1))->num_rows();
			$total_customers = $this->db->select('id')->get_where('customer_master',array('branch_id'=>$id,'status'=>1))->num_rows();
			$total_vouchers = $this->db->select('id')->get_where('dms_vouchers',array('branch_id'=>$id,'status'=>1))->num_rows();
			$total_branch_vouchers = $this->db->select('id')->from('dms_vouchers')->where('status',1)->where('dr_ledger',$ledgerID)->or_where('cr_ledger',$ledgerID)->get()->num_rows();
			$branch_godowns = $this->db->select(array('id'))->from('godown_master')->where(array('branch_id'=>$id,'status'=>1))->get()->result_array();

			$total_godowns=0;
			if(!empty($branch_godowns)){
				if(count($branch_godowns) == 1){
					$branch_main_godown = $branch_godowns[0]['id'];
					$total_godown_stocks = $this->db->select('id')->get_where('dms_stocks',array('godown_id'=>$branch_main_godown,'status'=>1))->num_rows();
					if(!empty($total_godown_stocks)){
						$total_godowns=1;
					}
				}else{
					$total_godowns=1;
				}
			}
			
			if(empty($total_users) && empty($total_customers) && empty($total_godowns) && empty($total_vouchers) && empty($total_branch_vouchers)){
				
				if($this->branch->my_update('branch_master',array('status'=>0),array('id'=>$id))){
					$this->branch->my_update('godown_master',array('status'=>0),array('branch_id'=>$id));	
					$this->message->set($this->lang->line('branch-deleted'),'s');
				}else{
					$this->message->set($this->lang->line('branch-not-deleted'),'e');
				}
			}else{
				$this->message->set($this->lang->line('can-not-delete-branch'),'i');
			}
			redirect('branches/report');
		}
		
		public function set_default(){

			$branch_id = $this->uri->segment(3);

			$this->db->update('users',array('branch_id'=>$branch_id),array('id'=>$this->session->userdata('id')));
			$this->session->set_userdata('under_id',$branch_id);
		
			$this->message->set($this->lang->line('default-shop-set'));
			redirect('branches/report');
		}
		
        public function target(){
            
            $branches = $this->db->get_where('branch_master',array('status'=>1,'tstatus'=>1))->result_array();
            if(isset($_POST['btn_save'])){
                $i=0;
                foreach($branches as $branch){
                    $bid = $branch['id'];
                    if(isset($_POST["targeta$bid"]) || isset($_POST["targetb$bid"]) || isset($_POST["targetc$bid"])){
                        $targeta = $_POST["targeta$bid"];
                        $targetb = $_POST["targetb$bid"];
                        $targetc = $_POST["targetc$bid"];
                        if($this->db->update('branch_master',array('target_a'=>$targeta,'target_b'=>$targetb,'target_c'=>$targetc),array('id'=>$bid))){
                            $i++;
                        }
                    }
                }
                if($i>0){
                    $this->message->set('Target Updated Successfully','s');
                }else{
                    $this->message->set('Target Cannot be Updated','e');
                }
                
                redirect('branches/target');
            }
            
            $this->template->title('Target');
			$this->template->main_heading('Target');
			$this->template->breadcrumb();
			$this->template->slice('preferences/branches/target',array('branches'=>$branches));
			$this->template->render();
        }
	}
?>