<?php if(! defined('BASEPATH')) exit('No direct script access alloed');

	class Collection_report extends MY_Controller{
	    
	    public function __construct(){
    		parent::__construct();
    		$this->check_access_right();
    		$this->companyID = $this->session->userdata('company_id');
            $this->branchID = $this->session->userdata('under_id');
    		#---------------- Checking Financial year is enabled / closed-----------------#
    		$method_array = array('report','staff_report');
    		fiscal_status($this->uri->segment(2),$method_array,"booking/report");
    		#---------------- Checking Financial year is enabled / closed-----------------#
    		$this->load->model('booking/Booking_model','book_obj');
    		$this->load->model('sales/Sales_model','sales_obj');
    		$this->load->library(array('Stock'));
    	}
    	
    	public function report(){
    		#----------uri array
    		$uri_array  = $this->uri->uri_to_assoc(3);
    		#----------redirect
    		$redirect = ""; $collection_array = array();
    		#----------dates within financial year
    		$cur_date = date('Y-m-d');
    		$from_date = $cur_date;
    		$to_date = $cur_date;
    		$cur_fiscal_yr = $this->dms->get_fiscal_year();
    		if($from_date < $cur_fiscal_yr['start_date'] || $from_date > $cur_fiscal_yr['end_date'] || $to_date < $cur_fiscal_yr['start_date'] || $to_date > $cur_fiscal_yr['end_date']){
    			$from_date = $cur_fiscal_yr['end_date'];
    			$to_date = $cur_fiscal_yr['end_date'];
    		}
    		#----------validation
    		$this->form_validation->set_rules('from_date','From Date','required|xss_clean|valid_date');
    		$this->form_validation->set_rules('to_date','To Date','required|xss_clean|valid_date');
    		if($this->form_validation->run() === true){
    			$from_date = date('Y-m-d',strtotime($this->input->post('from_date',true)));
    			$to_date = date('Y-m-d',strtotime($this->input->post('to_date',true)));
    		}
    		$fdate = strtotime($from_date);
    		$tdate = strtotime($to_date);
    		for ($i=$fdate;$i<=$tdate; $i+=86400) { 
    		    $idate = date('Y-m-d', $i); 
    		    #---------------- Booking ----------------
    		    $book_amount = 0;
                $book_array = $this->db->query("select sum(paid_amount) as collection from dms_booking where bill_date='$idate' and branch_id='$this->branchID' and status='1'")->row_array();
                if($book_array['collection']!='')
                {
                    $book_amount = $book_array['collection'];
                }
                $collection_array[$idate]['book'] = $book_amount;
                
                #---------------- Sales ----------------
                $sales_amount = 0;
                $sales_array = $this->db->query("select sum(vamount) as collection from dms_vouchers where vdate='$idate' and company_id='$this->companyID' and branch_id='$this->branchID' and table_name='dms_sales' and status='1'")->row_array();
                if($sales_array['collection']!=''){
                    $sales_amount = $sales_array['collection'];
                }
                $collection_array[$idate]['sale'] = $sales_amount;
                #---------------- Sales Return----------------
                $sales_return_amount = 0;
                $sales_return_array = $this->db->query("select sum(vamount) as collection from dms_vouchers where vdate='$idate' and company_id='$this->companyID' and branch_id='$this->branchID' and table_name='dms_sales_returns' and status='1'")->row_array();
                if($sales_return_array['collection']!='')
                {
                    $sales_return_amount = $sales_return_array['collection'];
                }
                $collection_array[$idate]['sale_return'] = $sales_return_amount;
            }  

    		#----------between condition
    		$between = "bill_date between '$from_date' and '$to_date'";
    		#----------total rows
    		if(empty($collection_array)){
    			$this->message->set($this->lang->line('no-voucher'),'i');
    		}
    		#----------sales report datas
    		$sales_array=$this->sales_obj->get_bills(array('conditions' => $conditions,'between' => $between,'like' => $like_array,'order_by'=>'bill_no','order'=>'DESC','limit'=>$config['per_page'],'offset'=>$offset));
    		#----------template
    		$this->template->title("Collection Report");
    		$this->template->main_heading($this->lang->line("collection-report"));
    		$this->template->breadcrumb(array($this->lang->line("collection-report") => 'no_link'));
    		$this->template->slice('collection_report/search',array('from_date' => $from_date,'to_date' => $to_date));
    		$this->template->slice('dms/message');
    		if(!empty($collection_array))
    		{
    			$this->template->slice('collection_report/report',array('collection_array' => $collection_array));
    			$this->template->slice('dms/modals/delete_confirm');
    		} 
    		$this->template->render();
    	}
    	
    	public function staff_report(){
    	    #----------uri array
    		$uri_array  = $this->uri->uri_to_assoc(3);
    		#----------redirect
    		$branch=$cur_date=$to_date=$cond=""; $collections=array();
    		#----------validation
    		$this->form_validation->set_rules('from_date','From Date','xss_clean|valid_date');
    		$this->form_validation->set_rules('to_date','To Date','xss_clean|valid_date');
    		if($this->form_validation->run() === true){
    		    $branch = $this->input->post('branch_id',true);
    			$from_date = date('Y-m-d',strtotime($this->input->post('from_date',true)));
    			$to_date = date('Y-m-d',strtotime($this->input->post('to_date',true)));
    		}
    		if($branch!=''){
    		    $cond .= " and b.branch_id='$branch'";
    		}
    		if($from_date!='' && $from_date!='0000-00-00' && $from_date!='1970-01-01'){
    		    $cond .= " and b.bill_date >= '$from_date'";
    		}
    		if($to_date!='' && $to_date!='0000-00-00' && $to_date!='1970-01-01'){
    		    $cond .= " and b.bill_date <= '$to_date'";
    		}
    		
    		$bookings = $this->db->query("select br.branch_name,b.branch_id,b.user_id,concat(u.fname,' ',u.lname) as sname,sum(b.amount1+b.amount2+b.balance_amount) as amount from dms_booking as b inner join users as u on b.user_id=u.id inner join branch_master as br on b.branch_id=br.id where b.status=1 $cond group by b.branch_id,b.user_id order by amount desc")->result_array();
    	    //$sales = $this->db->query("select br.branch_name,s.branch_id,s.user_id,concat(u.fname,' ',u.lname) as sname,sum(s.amount1+s.amount2) as amount from dms_sales as s inner join users as u on s.user_id=u.id inner join branch_master as br on s.branch_id=br.id where s.status=1 $cond group by s.branch_id,s.user_id")->result_array();
    	    foreach($bookings as $booking){
    	        if(isset($collections[$booking['branch_id']][$booking['user_id']])){
    	            $collections[$booking['branch_id']]['collect'][$booking['user_id']]['amount'] += $booking['amount'];
    	        }else{
    	            $collections[$booking['branch_id']]['bname'] = $booking['branch_name'];
    	            $collections[$booking['branch_id']]['collect'][$booking['user_id']]['name'] = $booking['sname'];
    	            $collections[$booking['branch_id']]['collect'][$booking['user_id']]['amount'] = $booking['amount'];
    	        }
    	    }
    	 /*   foreach($sales as $sale){
    	        if(isset($collections[$sale['branch_id']])){
    	            $collections[$sale['branch_id']]['collect'][$sale['user_id']]['amount'] += $sale['amount'];
    	        }else{
    	            $collections[$sale['branch_id']]['bname'] = $sale['branch_name'];
    	            $collections[$sale['branch_id']]['collect'][$sale['user_id']]['name'] = $sale['sname'];
    	            $collections[$sale['branch_id']]['collect'][$sale['user_id']]['amount'] = $sale['amount'];
    	        }
    	    }*/
    	    
    	    $this->load->model('branches/Branch_model','branch');
			$branches = $this->branch->listing(array('company_id'=>$this->session->userdata('company_id')));
			$branches[''] = 'All';
			ksort($branches);
    	    
    	    $this->template->title("Staff Collection Report");
    		$this->template->main_heading($this->lang->line("staff-collection-report"));
    		$this->template->breadcrumb(array($this->lang->line("staff-collection-report") => 'no_link'));
    		$this->template->slice('collection_report/staff/search',array('from_date'=>$from_date,'to_date'=>$to_date,'branches'=>$branches,'branch'=>$branch));
    		$this->template->slice('dms/message');
    		if(!empty($collections)){
    			$this->template->slice('collection_report/staff/report',array('collections'=>$collections));
    		} 
    		$this->template->render();
    	}
    	
    	public function average_report(){
    	    
    	    $this->load->model('branches/Branch_model','branch');
			$branches = $this->branch->listing(array('company_id'=>$this->session->userdata('company_id')));
    	    $collections=array();
    	    
    	    $this->form_validation->set_rules('from_date','From Date','xss_clean|valid_date');
    		$this->form_validation->set_rules('to_date','To Date','xss_clean|valid_date');
    		if($this->form_validation->run() === true){
    		    $from_date = date('Y-m-d',strtotime($this->input->post('from_date',true)));
    			$to_date = date('Y-m-d',strtotime($this->input->post('to_date',true)));
    			
    			foreach($branches as $bid => $bname){
        	        $amount=$custs=$avg=0;
        	        $row = $this->db->query("SELECT count(distinct(s.customer_id)) as cust,sum(si.taxable_amt) as taxable,sum(si.cgst_amt) as cgst,sum(si.sgst_amt) as sgst,sum(si.cess_amt) as cess FROM `dms_sales` as s inner join `dms_sales_items1` as si on s.group_id=si.group_id and si.status=1 WHERE s.branch_id='$bid' AND s.bill_date between '$from_date' and '$to_date' AND s.status = 1")->row_array();
        	        if($row['taxable']!='' && $row['taxable']!=0 && $row['cust']!='' && $row['cust']!=0){
        	            $amount = round($row['taxable']+$row['cgst']+$row['sgst']+$row['cess']);
        	            $custs = $row['cust'];
        	            $avg = $amount/$custs;
        	        }
        	        $collections[$bid] = array('name'=>$bname,'amount'=>$amount,'custs'=>$custs,'avg'=>$avg);
        	    }
    		}
    	    
    	    $this->template->title("Average Sales Report");
    		$this->template->main_heading($this->lang->line("average-sales-report"));
    		$this->template->breadcrumb(array($this->lang->line("average-sales-report") => 'no_link'));
    		$this->template->slice('collection_report/average/search',array('from_date'=>$from_date,'to_date'=>$to_date));
    		$this->template->slice('dms/message');
    		if(!empty($collections)){
    			$this->template->slice('collection_report/average/report',array('collections'=>$collections));
    		} 
    		$this->template->render();
    	}
	}
	