<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
	
class Company extends MY_Controller{

	#--------------------------------------------
	var $fiscal_start_date,$fiscal_end_date,$ctype = 0;
	public function __construct(){

		parent :: __construct();
		$this->check_access_right();
		$this->load->helper('html');
		$this->load->model('companies/Company_model','company');
		$this->load->model('fiscals/Fiscal_model','fiscal');		
		
		$fiscals = $this->dms->get_fiscal_year();
		if($fiscals)
		{
			$this->fiscal_start_date = $fiscals['start_date'];
			$this->fiscal_end_date = $fiscals['end_date'];
		}


		#-----------company_type
		if($this->company->company_type() == 1)
		{
			if($this->company->company_count())
			{				
				$this->ctype = 1;
			}
		}
	}

	#--------------------------------------------

	#company information settings
	public function info(){	

		#-----------checking company_type
		if($this->ctype == 1)
		{
			redirect('company/report');
		}

		#-----------ledger and fiscal models
		$this->load->model('accounts/Ledger_model','ledger');			
					
		$this->form_validation->set_rules('company_name','lang:company-name','required|trim|xss_clean');
		$this->form_validation->set_rules('company_landline','lang:landline','trim|xss_clean');
		$this->form_validation->set_rules('company_mobile','lang:mobile','required|trim|xss_clean|is_natural|exact_length[10]|is_unique[company_master.company_mobile]');
		$this->form_validation->set_rules('fsdate','lang:fiscal-yr','required|xss_clean|is_date');
		$this->form_validation->set_rules('company_address','lang:company-address','required|trim|xss_clean');
		$this->form_validation->set_rules('company_website','lang:company-site','trim|xss_clean');
		$this->form_validation->set_rules('company_email','lang:company-email','trim|xss_clean|valid_emails');
		$this->form_validation->set_rules('company_register_no','lang:regno','trim|xss_clean');
		$this->form_validation->set_rules('branch[area_id]','lang:area1','trim|xss_clean');
		$this->form_validation->set_rules('tax_type','lang:tax-type','trim|xss_clean');
		$this->form_validation->set_rules('cst_no','lang:cst-no','trim|xss_clean');
		$this->form_validation->set_rules('tin_no','lang:tin-no','trim|xss_clean');
		$this->form_validation->set_rules('presum_tax','lang:presum-tax','trim|xss_clean');
			
		if($this->input->post('is_tax',TRUE)=='yes'){

			$this->form_validation->set_rules('presum_tax','lang:presum-tax','required');
			$class = '';
			$class_tax = 'col-md-3';
			$class_cst ='hide';
		}else{
			$class = 'hide';
			$class_tax = 'col-md-4';
			$class_cst = '';
		}
		if($this->form_validation->run() == true){
			
			$file_upload_error = true;
			#if a logo image is uploaded
			if($_FILES['company_logo']['name'] != ''){
					
				$ext = pathinfo($_FILES['company_logo']['name'], PATHINFO_EXTENSION);
				#file name initialization
				$max_id = rand(0,1000);
				$f_part1 = $max_id+1;
				$f_part2 = $f_part1."company".date('YmdHis');
				$fileName = $f_part2.".".$ext;

				#file uploading 
				$config['upload_path'] =  FCPATH.'assets/images/logo/';
				$config['allowed_types'] = 'jpeg|jpg|png';
				$config['max_size']	= '600';
				$config['max_width']  = '2560';
				$config['max_height']  = '1600';
				$config['file_name'] = $fileName;
				$this->load->library('Upload');
				$this->upload->initialize($config);

				if($this->upload->do_upload('company_logo')){

					$file_upload_error = false;
					$config['image_library'] = 'gd2';
					$config['source_image']	= $config['upload_path'].$fileName;
					$config['create_thumb'] = TRUE;
					$config['maintain_ratio'] = true;
					$config['width']	= 100;
					$config['height']	= 100;

					$this->load->library('Image_lib', $config); 
					$this->image_lib->resize();
					#unlink original file & rename thumb
					unlink($config['upload_path'].$fileName);
					$thumb = $config['upload_path'].$f_part2.'_thumb'.'.'.$ext;
					$original = $config['upload_path'].$fileName;
					rename($thumb,$original);
				}else{
					$file_upload_error = true;
				}
			}else{
				$fileName = 'default_company.jpg'; 
				$file_upload_error = false;#dummy image in case no image uploaded
			}
			if($file_upload_error){
				$this->message->set($this->lang->line('unsupported-file'),'e');
			}else{

				$branch = $this->input->post('branch');
				$data = $this->input->post(NULL,true);
				unset($data['fsdate']);
				$data['company_short_name'] = ($data['company_short_name'] != '')?$data['company_short_name']:$data['company_name'];
				$data['company_logo'] =$fileName;
				unset($data['branch']);
				if($data['is_tax'] == 'no'){
					unset($data['presum_tax']);
					unset($data['pin_no']);
				}else{
					unset($data['cst_no']);
				}

				#getting details for saving branch
				$branch = $this->input->post('branch');
				$branch['branch_name'] = $data['company_name'];
				$branch['branch_short_name'] = $data['company_short_name'].'[MainBranch]';
				$branch['branch_landline'] = $data['company_landline'];
				$branch['branch_mobile'] = $data['company_mobile'];
				$branch['branch_address'] = $data['company_address'];
				$branch['branch_email'] = $data['company_email'];
				$branch['branch_type'] = 1;
				$branch['created_by'] = $this->session->userdata('id');
				$branch['created_on'] = date('Y-m-d H:i:s');

				#unset is_tax 
				unset($data['is_tax']);
				$data['updated_by'] = $this->session->userdata('id');
				$data['updated_on'] = date('Y-m-d H:i:s');
				if($this->db->insert('company_master',$data)){
					
					$company_id = $this->db->insert_id();
					$this->session->set_userdata('company_id',$company_id);
					
					#----------inserting fiscal year details
					$fsdate = date('Y-m-d',strtotime($this->input->post('fsdate',true)));
					$fiscal_yr_id = $this->fiscal->insert(array('company_id' => $company_id,'start_date' => $fsdate));
					
					#saving main branch details
					$branch['company_id'] = $company_id;
					$this->db->insert('branch_master',$branch);
					$branch_id = $this->db->insert_id();
					$this->session->set_userdata('under_id',$branch_id);					

					//after branch creation enter default dms ledger id for main branch 
					$ledger['company_id'] = $company_id;
					$ledger['ledger_name'] = $data['company_name'].'-'.$data['company_mobile'];
					$ledger['branch_id'] =$branch_id;
					$ledger['sgroup_id'] = 15;
					$ledger['dc'] = $this->ledger->get_dc($ledger['sgroup_id']);
					$last_insert_id = $this->ledger->insert('dms_ledgers',$ledger);
					
					#update branch id ;
					$this->db->update('branch_master',array('ledger_id'=>$last_insert_id),array('id'=>$branch_id));

					#insert first godwon details into godown master
					$godown['branch_id'] = $branch_id;
					$godown['godown_code'] = 'G1';
					$godown['godown_name'] = 'Main Godown';
					$godown['address'] = 'godown address';
					$godown['created_by'] = $this->session->userdata('id');
					$godown['created_on'] = date('Y-m-d H:i:s');
					$this->db->insert('godown_master',$godown);

					#insert  default constantmaster details
					$constant['company_id'] = $company_id;
					$constant['date_format'] = 'd/m/Y';
					$constant['decimal_place'] = 2;
					$constant['rows_per_page'] = 15;
					$constant['currency_symbol'] = 'Rs.';
					$this->db->insert('constant_master',$constant) ;
					
					#update superadmin comapny details and branch details 						
					$this->db->update('users',array('company_id'=>$company_id,'branch_id'=>$branch_id,'fiscal_yr_id' => $fiscal_yr_id),array('id'=> '-1'));

					#update administrator company and branch details
					$this->db->update('users',array('company_id'=>$company_id,'branch_id'=>$branch_id,'fiscal_yr_id' => $fiscal_yr_id),array('id'=>'-2'));
					$this->session->set_userdata('fiscal_yr_id',$fiscal_yr_id);
					$this->message->set($this->lang->line('company-info-saved'));
					redirect('company/report');						
				}
				else{
					$this->message->set($this->lang->line('no-company-saved'),'e');
				}
			}		
		}
		else{
			$this->message->set($this->lang->line('pls-fill-all-field'),'i');
		}
		
		#get all areas
		$this->load->model('areas/Area_model','area');
		$areas = $this->area->listing();
		$areas[''] = 'Select';ksort($areas);
		$this->template->title('Company Settings');
		$this->template->main_heading($this->lang->line('company-settings'));
		$this->template->breadcrumb(array($this->lang->line('settings')=>'preferences/',$this->lang->line('company-info')=>'no_link',$this->lang->line('company-detail')=>'company/report'));
		$this->template->slice('dms/message');
		$this->template->slice('preferences/company/info',array('areas'=>$areas,'class'=>$class,'class_tax'=>$class_tax,'class_cst'=>$class_cst));
		$this->template->other_script('company/company');
		$this->template->render();
	}


	#--------------------------------------------

	public function report(){				
		
		#------------checking company type
		if($this->ctype == 0)//single
		{
			$breadcrumb = array($this->lang->line('settings')=>'preferences/',$this->lang->line('company-info')=>'company/info',$this->lang->line('company-detail')=>'no_link');
		}
		else
		{
			$breadcrumb = array($this->lang->line('settings')=>'preferences/',$this->lang->line('company-detail')=>'no_link');
		}

		$this->load->library('Pagination');	
		$config['total_rows'] = $this->company->get_all('',1);
		$this->template->title('Company information');
		$this->template->main_heading($this->lang->line('company-info'));		
		$this->template->breadcrumb($breadcrumb);
		if($config['total_rows'] == 0)
		{
			$this->message->set($this->lang->line('no-company-found'),'i');
		}
		else
		{			
			$config['per_page'] = 1;
			$config['base_url'] = base_url('company/report');	
			# Pagination Config Customizations
			$config['full_tag_open'] = '<ul class="pagination">';
			$config['full_tag_close'] = '</ul>';
			$config['first_link'] = 'First';
			$config['last_link'] = 'Last';
			$config['next_link'] = '&raquo;';
			$config['prev_link'] = '&laquo;';
			$config['cur_tag_open'] = '<li class="active"><a href="#">';
			$config['cur_tag_close'] = '</a></li>';
			$config['num_tag_open'] = '<li>';
			$config['num_tag_close'] = '</li>';
			$this->pagination->initialize($config);
			$links = $this->pagination->create_links();			
			$start = ($this->uri->segment(3))?$this->uri->segment(3):0;
			if($start == 0 && $this->session->userdata('company_id'))		
			{
				$company_details = $this->company->get_all(array('id' => $this->session->userdata('company_id')),0,0,1);
			}
			else
			{
				if($this->session->userdata('company_id')){
					$start--;
				}
				$company_details = $this->company->get_all(array('id !=' => $this->session->userdata('company_id')),0,$start,$config['per_page']);
			}			
			$fiscal_details = $this->fiscal->get(array('columns' => 'start_date','order_by' => 'fiscal_order','order' => 'asc','limit' => 1,'offset' => 0));
			$fstart_date = "";
			if(!empty($fiscal_details))
			{
				$fstart_date = $fiscal_details[0]['start_date'];
			}
			if(!empty($company_details))
			{
				$company = $company_details[0];
				$this->template->append('preferences/company/report',array('company'=>$company,'fsdate' => $fstart_date,'links'=>$links));
			}
			else
			{
				$this->message->set($this->lang->line('no-company-found'));
			}
			$this->template->slice('dms/modals/delete_confirm');						
		}
		$this->template->slice('dms/message');
		$this->template->render();
	}

	#---------------------------------------------
	public function update(){
				
		$id = $this->uri->segment(3,0);
		$info = $this->db->get_where('company_master',array('id'=>$id))->row_array();
		if(empty($info)){
			redirect('company/report');
		}

		#------------checking company type
		if($this->ctype == 0)//single
		{
			$breadcrumb = array($this->lang->line('settings')=>'preferences/',$this->lang->line('company-info')=>'company/info',$this->lang->line('update')=>'no_link',$this->lang->line('company-detail')=>'company/report');
		}
		else
		{
			$breadcrumb = array($this->lang->line('settings')=>'preferences/',$this->lang->line('update')=>'no_link',$this->lang->line('company-detail')=>'company/report');
		}

		if($info['tax_type'] == 1){
			$class = 'hide';
			$class_tax = 'col-md-4';
			$class_cst = '';
                        $class_gst = 'hide';
			$info['is_tax'] = 'no';
		}else if($info['tax_type'] == 0){
			$class = '';
			$class_tax = 'col-md-3';
			$class_cst ='hide';
                        $class_gst = 'hide';
			$info['is_tax'] ='yes';
		}else{
                        $class = 'hide';
			$class_tax = 'col-md-2';
			$class_cst = 'hide';
                        $class_gst = '';
			$info['is_tax'] ='yes';
        
	        }	
		#-----------fiscal year details
		$fiscal_details = $this->fiscal->get(array('columns' => array('id','start_date'),'order_by' => 'fiscal_order','order' => 'asc','limit' => 1,'offset' => 0))[0];
		$fstart_date = $fiscal_details['start_date'];

		$this->form_validation->set_rules('company_name','lang:company-name','required|trim|xss_clean||is_edit_unique[company_master.company_name]');
		$this->form_validation->set_rules('company_landline','lang:landline','trim|xss_clean');
		$this->form_validation->set_rules('company_mobile','lang:mobile','required|trim|xss_clean|is_natural|exact_length[10]|is_edit_unique[company_master.company_mobile]');
		$this->form_validation->set_rules('fsdate','lang:fiscal-yr',"required|xss_clean|is_date|callback_fiscal_rules[$fstart_date]|check_date[$fstart_date.<=]");
		$this->form_validation->set_rules('company_address','lang:company-address','required|trim|xss_clean');
		$this->form_validation->set_rules('company_website','lang:company-site','trim|xss_clean');
		$this->form_validation->set_rules('company_email','lang:company-email','trim|xss_clean|valid_emails');
		$this->form_validation->set_rules('company_register_no','lang:regno','trim|xss_clean');
		$this->form_validation->set_rules('branch[area_id]','lang:area1','trim|xss_clean');
		$this->form_validation->set_rules('tax_type','lang:tax-type','trim|xss_clean');
		$this->form_validation->set_rules('cst_no','lang:cst-no','trim|xss_clean');
		$this->form_validation->set_rules('tin_no','lang:tin-no','trim|xss_clean');
		$this->form_validation->set_rules('presum_tax','lang:presum-tax','trim|xss_clean');
		$file_upload_error = true; 
		if($this->input->post('is_tax',TRUE) && $file_upload_error === true){
			if($this->input->post('is_tax',TRUE)=='yes'){
					$this->form_validation->set_rules('presum_tax','lang:presum-tax','required');
					$class = '';
					$class_tax = 'col-md-3';
					$class_cst ='hide';
			}else{
				$class = 'hide';
				$class_tax = 'col-md-4';
				$class_cst = '';
			}
		}
		
		#default settings
		if($this->form_validation->run() === true){
			if($_FILES['company_logo']['name'] != ''){
				$file_upload_error = true;
				$ext = pathinfo($_FILES['company_logo']['name'], PATHINFO_EXTENSION);
				#file name initialization
				$max_id = rand(0,1000);
				$f_part1 = $max_id+1;
				$f_part2 = $f_part1."company".date('YmdHis');
				$fileName = $f_part2.".".$ext;

				#file uploading 
				$config['upload_path'] =  base_url().'assets/images/logo/';
				$config['allowed_types'] = 'jpeg|jpg|png';
				$config['max_size']	= '600';
				$config['max_width']  = '2560';
				$config['max_height']  = '1600';
				$config['file_name'] = $fileName;
				$this->load->library('Upload');
				$this->upload->initialize($config);
				if($this->upload->do_upload('company_logo')){
					$file_upload_error = TRUE;
					$config['image_library'] = 'gd2';
					$config['source_image']	= $config['upload_path'].$fileName;
					$config['create_thumb'] = TRUE;
					$config['maintain_ratio'] = true;
					$config['width']	= 100;
					$config['height']	= 100;
					$this->load->library('Image_lib', $config); 
					$this->image_lib->resize();
					#unlink original file & rename thumb
					unlink($config['upload_path'].$fileName);
					$thumb = $config['upload_path'].$f_part2.'_thumb'.'.'.$ext;
					$original = $config['upload_path'].$fileName;
					rename($thumb,$original);
				}else{
					$file_upload_error = false;
				}
			}

			if(!$file_upload_error){
				$this->message->set($this->lang->line('invalid-photo'),'e');
			}else{
				$data = $this->input->post(NULL,TRUE);
				if(!empty( $fileName)){
					$data['company_logo'] = $fileName;
					if((strtolower($info['company_logo']) !='default_company.jpg')){
						unlink(FCPATH.'assets/images/logo/'.$info['company_logo']);
					 }
				}
				if($data['tax_type'] == 0){
					$data['cst_no'] = '';
				}else{
					$data['pin_no'] = '';
					$data['presum_tax'] = 0;
				}
				$dms_stocks = $this->db->select(array('id'))->from('dms_stocks')->where("stock_date between ".$this->fiscal_start_date." and ".$this->fiscal_end_date,NULL)->where('company_id',$id)->get()->num_rows();
				if(!empty($dms_stocks)){
					unset($data['tax_type']);
				}
				unset($data['is_tax']);
				$data['updated_by'] = $this->session->userdata('id');
				$data['updated_on'] = date('Y-m-d H:i:s');
				
				#-------------updating fiscal year details
				$fsdate = date('Y-m-d',strtotime($data['fsdate']));
				$this->fiscal->update_others(array('table' => 'fiscal_year_master','data' => array('start_date' => $fsdate),'conditions' => array('id' => $fiscal_details['id'])));
				unset($data['fsdate']);
				
				#-------------updating company details
				if($this->db->update('company_master',$data,array('id'=>$id))){		
					$this->message->set($this->lang->line('company-info-updated'));
				}else{
					$this->message->set($this->lang->line('company-info-not-updated'));
				}
				redirect('company/report');
			}
		}				

		$this->template->title($this->lang->line('company-settings'));
		$this->template->main_heading($this->lang->line('company-settings'));
		$this->template->breadcrumb($breadcrumb);
		$this->template->slice('dms/message');
		$this->template->slice('preferences/company/update',array('info'=>$info,'class'=>$class,'class_tax'=>$class_tax,'class_cst'=>$class_cst,'class_gst'=>$class_gst,'fsdate' => $fstart_date));
		$this->template->other_script('company/company');
		$this->template->render();
	}
	#---------------------------------------------
	public function delete(){
		
		$id = $this->uri->segment(3,0);		
		if($this->if_exists('company_master',array('id'=>$id,'status'=>1)) === false){			
			redirect('company/report');
		}		
		if($this->company->get_user_company($id)){
			$this->message->set($this->lang->line('there-are-employees'),'i');
		}
		else{
			if($this->db->update('company_master',array('status' => 0),array('id' => $id))){
				if($this->company->get_company() == $id)
				{
					$this->company->update_others(array('table' => 'users','data' => array('company_id' => 0,'branch_id' => 0,'fiscal_yr_id' => 0),'conditions' => array('id <' => 0)));
					$this->session->unset_userdata(array('company_id' => '','fiscal_yr_id' => '','under_id' => ''));
				}
				elseif($this->company->get_company(-1) == $id)
				{
					$this->company->update_others(array('table' => 'users','data' => array('company_id' => 0,'branch_id' => 0,'fiscal_yr_id' => 0,'online_status' => 0),'conditions' => array('id' => -1)));
				}
				$this->message->set($this->lang->line('company-deleted'));
			}else{
				$this->message->set($this->lang->line('company-not-deleted'));
			}
		}
		redirect('company/report');		
	}
	#---------------------------------------------
	/*public function default_company_settings(){

		$companies = $this->db->get_where('company_master')->result_array();

		$this->template->title('Company Settings');
		$this->template->main_heading($this->lang->line('company-settings'));
		$this->template->breadcrumb(array($this->lang->line('settings')=>'preferences/',$this->lang->line('company-detail')=>'company/report',$this->lang->line('company-info')=>'no_link'));
		$this->template->slice('preferences/company/default_company',array('companies'=>$companies));
		$this->template->render();
	}*/
	#---------------------------------------------
	public function set_default_company()
	{
		$company_id  = $this->uri->segment(3,0);	
		if($this->if_exists('company_master',array('id'=>$company_id,'status'=>1)) === false){		
			redirect('company/report');
		}

		if(empty($company_id)){ redirect('users/home');}		
		$this->session->set_userdata('company_id',$company_id);
		
		#----------main branch id
		$branch_id = $this->dms->get_main_branch();
		
		#----------fiscal year details
		$fiscal_details = $this->dms->get_default();
		
		$this->session->set_userdata(array('fiscal_yr_id' => $fiscal_details['id'],'under_id' => $branch_id));
		
		if($this->db->update('users',array('company_id' => $company_id,'branch_id' => $branch_id,'fiscal_yr_id' => $fiscal_details['id']),array('id'=>$this->session->userdata('id')))){
			$this->message->set($this->lang->line('set-default-company'));
			redirect('company/report');
		}		
	}
	#---------------------------------------------
	
	public function fiscal_rules($str,$start_date)
	{
		$date1 = date('Y-m-d',strtotime($str));
		$date2 = date('Y-m-d',strtotime($start_date));
		if($date1 != $date2)
		{
			$this->load->library('Accounts');
			$row = $this->accounts->last_closed_yr();
			$row1 = $this->company->get_stock_count();
			if(!$row1 && empty($row)){
				return true;
			}
			return false;
		}
		return true;
	}
}
?>