<?php if( ! defined('BASEPATH')) exit('No direct script access allowed');

class Company_type extends MY_Controller{
	
	public function __construct(){
		parent ::__construct();
	}
	
	#---------------------------------------------------------

	public function set(){
		
		$this->template->title($this->lang->line('company-type'));
		$this->template->main_heading($this->lang->line('company-type-settings'));
		$this->template->breadcrumb(array($this->lang->line('settings')=>'preferences/index',$this->lang->line('company-type')=>'no_link'));
		$this->template->slice('dms/message');
		
		$company_types = array();
		$company_type = NULL;
		
		$types = $this->db->select(array('id','type','status'))->from('dms_company_type')->get()->result_array();
		
		if(!empty($types)){
			foreach($types as $key=>$cmp_type){
				$company_types[$cmp_type['id']] = $cmp_type['type'];
				if($cmp_type['status'] == 1){
					$company_type = $cmp_type['id'];
				}
			}
		}
		
		$this->form_validation->set_rules('company_type','lang:company-type','xss_clean|required');
		if($this->form_validation->run() === true){
			
			$posted_company_type = $this->input->post('company_type');
			$total_companies = $this->db->get_where('company_master',array('status'=>1))->num_rows();
			if($posted_company_type == 1 && $total_companies >1){
				$this->message->set($this->lang->line('more-company-found'),'i');
			}else{
				if($this->db->update('dms_company_type',array('status'=>0),array())){
					$this->db->update('dms_company_type',array('status'=>1),array('id'=>$posted_company_type));
					$this->message->set($this->lang->line('company-type-changed'));
				}else{
					$this->message->set($this->lang->line('company-type-not-changed'));
				}
			}
			redirect('company_type/set');
		}
		
		$this->template->slice('preferences/company/company_type_settings',array('company_types'=>$company_types,'company_type'=>$company_type));
		$this->template->render();
	}
	
}

?>