<?php if( ! defined('BASEPATH')) exit('No direct script access allowed');

	class Contractors extends MY_Controller{

		public function __construct(){

			parent :: __construct();
			$this->load->model('users/Contractor_model','contractor'); 
			
			#---------------- Checking Financial year is enabled / closed-----------------#
			$method_array = array('add','update','delete','privilege');
			fiscal_status($this->uri->segment(2),$method_array,"contractors/report");
			#---------------- Checking Financial year is enabled / closed-----------------
		}

	 	#------------------------------------------------------------

		public function add(){

			#validation
			if($this->form_validation->run() === true){

				$file_upload_error = true;
				#upload the photo if one is selected.
				if($_FILES['photo']['name'] != ''){

					$ext = pathinfo($_FILES['photo']['name'], PATHINFO_EXTENSION);
					#file name initialization
					$max_id = $this->user->get_max_id();
					$f_part1 = $max_id+1;
					$f_part2 = $f_part1."user".date('YmdHis');
					$fileName = $f_part2.".".$ext;

					#file uploading 
					$config['upload_path'] =  FCPATH.'assets/images/photos/';
					$config['allowed_types'] = 'jpeg|jpg|png';
					$config['max_size']	= '600';
					$config['max_width']  = '2560';
					$config['max_height']  = '1600';
					$config['file_name'] = $fileName;
					$this->load->library('Upload');
					$this->upload->initialize($config);

					if($this->upload->do_upload('photo')){

						$file_upload_error = false;
						$config['image_library'] = 'gd2';
						$config['source_image']	= $config['upload_path'].$fileName;
						$config['create_thumb'] = TRUE;
						$config['maintain_ratio'] = false;
						$config['width']	= 150;
						$config['height']	= 120;

						$this->load->library('Image_lib', $config); 
						$this->image_lib->resize();
						#unlink original file & rename thumb
						unlink($config['upload_path'].$fileName);
						$thumb = $config['upload_path'].$f_part2.'_thumb'.'.'.$ext;
						$original = $config['upload_path'].$fileName;
						rename($thumb,$original);
					}else{
						$file_upload_error = true;
					}	

				}else{
					$fileName = $this->input->post('gender').'.jpg'; 
					$file_upload_error = false;#dummy image in case no image uploaded
				}

				if($file_upload_error){
					$this->message->set($this->lang->line('invalid-photo'),'e');
				}else{
					#get posted data#
					$data = $this->input->post(NULL,true);
					$data['photo'] = $fileName;
					$data['dob'] = ($data['dob'] != '')?date('Y-m-d',strtotime($data['dob'])):'';
					$data['date_of_marriage'] = ($data['date_of_marriage'] != '')?date('Y-m-d',strtotime($data['date_of_marriage'])):'';
					$data['company_id'] = $this->session->userdata('company_id');
					$data['designation_id'] =4;

					#filtering company data from posted data then uset com[pany data
					$company = $this->input->post('company',TRUE);
					unset($data['company']);
					#get finacilyear id 
					$data['fiscal_yr_id'] = $this->dms->get_default_fiscal_id();
		
					#load contractor model save company and save area			
					if($data['password'] != ''){
						$data['password'] = password_hash($data['password'],PASSWORD_DEFAULT);
					}
					#save contractor data in users
					if($this->contractor->save($data)){

						#getting last iserted id
						$contractor_id =$this->db->insert_id();
						#storing contractor company details#
						$company['contractor_id'] = $contractor_id;
						if($this->contractor->save_company($company)){
							$this->message->set($this->lang->line('contractor-saved'));
						}else{
							$this->message->set($this->lang->line('contractor-not-saved'));
						}
						redirect('contractors/report');
					}
				}
			}

			#branches listing
			$this->load->model('branches/Branch_model','branch');
			$branches = $this->branch->listing(array('company_id'=>$this->session->userdata('company_id')));
			$branches[''] = 'Select a branch';
			ksort($branches);
			
			#get all areas
			$this->load->model('areas/Area_model','area');
			$areas = $this->area->listing();
			$areas[''] = 'Select';ksort($areas);
			#template
			$this->template->title($this->lang->line('manage-contractors'));
			$this->template->main_heading($this->lang->line('manage-contractors'));
			$this->template->breadcrumb(array($this->lang->line('manage-contractors')=>'no_link',$this->lang->line('report')=>'contractors/report'));
			$this->template->slice('dms/message');
			$this->template->slice('contractors/add/new',array('branches'=>$branches,'areas'=>$areas));
			$this->template->other_script(array('user_add','users/user_name_check','masons/ar_branch_select'));
			$this->template->render();
		}
	 #------------------------------------------------------------
		public function report(){

			$this->load->library('Pagination');
			$config['total_rows'] = $this->contractor->get_all('',1);
			if($config['total_rows']==0){
				$this->message->set($this->lang->line('no-contractor'),'i');
			}
			$config['per_page'] = $this->per_page();
			$config['base_url'] = base_url('contractors/report');
			$config['uri_segment'] = 3;
			# Pagination Config Customizations
			$config['full_tag_open'] = '<ul class="pagination">';
			$config['full_tag_close'] = '</ul>';
			$config['first_link'] = 'First';
			$config['last_link'] = 'Last';
			$config['next_link'] = '&raquo;';
			$config['prev_link'] = '&laquo;';
			$config['cur_tag_open'] = '<li class="active"><a href="#">';
			$config['cur_tag_close'] = '</a></li>';
			$config['num_tag_open'] = '<li>';
			$config['num_tag_close'] = '</li>';
			$this->pagination->initialize($config); 
			$offset = ($this->uri->segment(3))?$this->uri->segment(3):0;
			$contractors = $this->contractor->get_all('',0,$offset,$config['per_page']);
			$links = $this->pagination->create_links();

			if(empty($contractors)){
				$this->message->set($this->lang->line('no-results-found'),'i');
			}
			#template
			$this->template->title($this->lang->line('manage-contractors'));
			$this->template->main_heading($this->lang->line('manage-contractors'));
			$this->template->breadcrumb(array($this->lang->line('manage-contractors')=>'contractors/add',$this->lang->line('report')=>'no_link'));
			$this->template->slice('dms/message');
			$this->template->slice('contractors/report',array('contractors'=>$contractors,'links'=>$links,'count'=>$offset));
			$this->template->slice('dms/modals/more_details');
			$this->template->other_script('contractors/contractor_show');
			$this->template->render();

		}
	 #------------------------------------------------------------
		public function update($id=FALSE){

			if(!$id){ redirect('contractors/report');}
			$id = $this->uri->segment(3); 
			#get details of id
			$contractor = $this->contractor->get_all(array('users.id'=>$id))[0];
			if(empty($contractor)){
				redirect('contractors/report');
			}
			#get engineer company details
			$company = $this->db->get_where('contractor_companies',array('contractor_id'=>$id))->row_array();

			$file_upload_error = true; #default settings
			if($this->form_validation->run('contractors/update') === true){

				if($_FILES['photo']['name'] != ''){
					$file_upload_error = true;
					$ext = pathinfo($_FILES['photo']['name'], PATHINFO_EXTENSION);

					#file name initialization
					$max_id = $this->user->get_max_id();
					$f_part1 = $max_id+1;
					$f_part2 = $f_part1."user".date('YmdHis');
					$fileName = $f_part2.".".$ext;

					#file uploading 
					$config['upload_path'] =  FCPATH.'assets/images/photos/';
					$config['allowed_types'] = 'jpeg|jpg|png';
					$config['max_size']	= '600';
					$config['max_width']  = '2560';
					$config['max_height']  = '1600';
					$config['file_name'] = $fileName;
					$this->load->library('Upload');
					$this->upload->initialize($config);

					if($this->upload->do_upload('photo')){
						$file_upload_error = TRUE;
						$config['image_library'] = 'gd2';
						$config['source_image']	= $config['upload_path'].$fileName;
						$config['create_thumb'] = TRUE;
						$config['maintain_ratio'] = false;
						$config['width']	= 150;
						$config['height']	= 120;

						$this->load->library('Image_lib', $config); 
						$this->image_lib->resize();
						#unlink original file & rename thumb
						unlink($config['upload_path'].$fileName);
						$thumb = $config['upload_path'].$f_part2.'_thumb'.'.'.$ext;
						$original = $config['upload_path'].$fileName;
						rename($thumb,$original);
					}else{
						$file_upload_error = false;
					}
				}

				if(!$file_upload_error){
					$this->message->set($this->lang->line('invalid-photo'),'e');
				}else{
						
					$data = $this->input->post(NULL,TRUE);
					if(!empty( $fileName)){
						$data['photo'] = $fileName;
						if((strtolower($contractor['photo']) !='male.jpg') && (strtolower($contractor['photo']) != 'female.jpg')){

							unlink(FCPATH.'assets/images/photos/'.$contractor['photo']);
						 }
					}

					$data['dob'] = ($data['dob'] != '')?date('Y-m-d',strtotime($data['dob'])):'';
					$data['date_of_marriage'] = ($data['date_of_marriage'] != '')?date('Y-m-d',strtotime($data['date_of_marriage'])):'';
			
					#comapny details update
					$company = $this->input->post('company',TRUE);
					unset($data['company']);
					$this->contractor->update_company($company,$id);
					if($data['password'] != ''){
						$data['password'] = password_hash($data['password'],PASSWORD_DEFAULT);
					}else{
						unset($data['password']);
					}
					#user details update
					if($this->contractor->my_update('users',$data,array('id'=>$id))){
						$this->message->set($this->lang->line('contractor-updated'));
					}else{
						$this->message->set($this->lang->line('contractor-not-updated'));
					}
					redirect('contractors/report');
				}
			}
			
			#branches listing
			$this->load->model('branches/Branch_model','branch');
			$branches = $this->branch->listing(array('company_id'=>$this->session->userdata('company_id')));
			$branches[''] = 'Select a branch';
			ksort($branches);

			#get all areas
			$this->load->model('areas/Area_model','area');
			$areas = $this->area->listing();
			$areas[''] = 'Select';ksort($areas);
			#template
			$this->template->title($this->lang->line('manage-contractors'));
			$this->template->main_heading($this->lang->line('manage-contractors'));
			$this->template->breadcrumb(array($this->lang->line('manage-contractors')=>'contractors/add',$this->lang->line('update')=>'no_link',$this->lang->line('report')=>'contractors/report'));
			$this->template->slice('contractors/edit/update',array('contractor'=>$contractor,'company'=>$company,'branches'=>$branches,'areas'=>$areas));
			$this->template->other_script(array('user_add','users/user_name_check','masons/ar_branch_select'));
			$this->template->render();
		}
		
		#------------------------------------------------------------

		public function delete($id){

			if(empty($id) || !$this->uri->segment(3)){redirect('contractors/report');}
			$id = $this->uri->segment(3);
			
			if($this->if_exists('users',array('id'=>$id,'designation_id'=>4,'status'=>1)) === false){
				redirect('contractors/report');
			}	

			$contractor = $this->contractor->get_all(array('users.id'=>$id))[0];
			
			$total_privileges = $this->db->select('id')->get_where('user_privileges',array('owner_id'=>$id))->num_rows();
			$total_sales = $this->db->select('id')->get_where('dms_sales',array('user_id'=>$id,'status'=>1))->num_rows();
			$total_so = $this->db->select('id')->get_where('dms_sales_orders',array('user_id'=>$id))->num_rows();
			$total_so_temps = $this->db->select('id')->get_where('dms_sales_order_temp',array('user_id'=>$id,'status'=>1))->num_rows();
			$total_targets = $this->db->select('id')->get_where('targets',array('designation_id'=>4,'user_id'=>$id,'status'=>1))->num_rows();
			
			if(empty($total_privileges) && empty($total_sales) && empty($total_so) && empty($total_so_temps) && empty($total_targets)){
			
				if((strtolower($contractor['photo']) !='male.jpg') && (strtolower($contractor['photo']) != 'female.jpg')){
					unlink(FCPATH.'assets/images/photos/'.$contractor['photo']);
				}
				if($this->contractor->my_update('users',array('status'=>0),array('id'=>$id))){
					$this->contractor->my_update('contractor_companies',array('status'=>0),array('contractor_id'=>$id));
					$this->message->set($this->lang->line('contractor-deleted'),'s');
				}else{
					$this->message->set($this->lang->line('contractor-not-deleted'),'e');
				}
			}else{
				$this->message->set($this->lang->line('can-not-delete-contractor'),'i');
			}
			redirect('contractors/report');
		}
	 #------------------------------------------------------------
	}
?>