<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

class Customer_points extends MY_Controller{

	var $companyID;
	var $branchID;
	var $createdBY;
	var $fiscal_start_date;
	var $fiscal_end_date;

	#------------------------------------------------------------------------------

	public function __construct(){

		parent::__construct();
		$this->check_access_right();
		$this->companyID = $this->session->userdata('company_id');
		$this->branchID = $this->session->userdata('under_id');
		$this->createdBY = $this->session->userdata('id');

		$fiscals = $this->dms->get_fiscal_year();
		$this->fiscal_start_date = $fiscals['start_date'];
		$this->fiscal_end_date = $fiscals['end_date'];
	}

	#------------------------------------------------------------------------------

        public function add(){

		$this->template->title($this->lang->line('customer-bonus-points'));
		$this->template->main_heading($this->lang->line('add-custbonus-points'));
		$this->template->breadcrumb(array($this->lang->line('user-bonus-points') => 'no_link'));

		$user_types = $customers =$targets = array();
		$customer_id=NULL;
		$this->load->model('designations/Designation_master_model','designations');
		//$this->load->model('customers/Customer_master_model','customer_points');
		$this->load->model('customers/Customer_point_model','customer_points');
		$this->load->library(array('Stock','Targets'));
		$user_types = $this->designations->desig_listing();
                $customers = $this->customer_points->listing();
                 
		$uri_array = $this->uri->uri_to_assoc(3);
		if(!empty($uri_array)){
		
			if(isset($uri_array['cust_id'])){
				$cust_id =  $uri_array['cust_id'];
			}
		}

		//$this->form_validation->set_rules('user_type','lang:user-type','xss_clean|trim|required');
		$this->form_validation->set_rules('cust_id','lang:customer','xss_clean|trim|required');
		$this->form_validation->set_rules('target_id','lang:target','trim|xss_clean|required');
		$this->form_validation->set_rules('point','lang:point','trim|xss_clean|required');

		if($this->form_validation->run() === true){

			//$user_type = $this->input->post('user_type');
			$cust_id = $this->input->post('cust_id');
			$target_id = $this->input->post('target_id');
			$point = $this->input->post('point');
			$group_id = $this->customer_points->get_bonus_group_id();

			$pre_total_point = $this->targets->get_customer_points(array('cp.user_id' => $cust_id,'cp.targets_id' => $target_id,'ds.status >'=>3,'ds.status <'=>6));
			$this->customer_points->save('customer_points',array('user_id' => $cust_id,'targets_id' => $target_id,'group_id' =>$group_id,'sms_point' => $point,'actual_point' => $point));
                        $c_point = $this->db->select(array('point'))->from('customer_total_point')->where('cid',$cust_id)->get()->row_array();
                        if($c_point)
                        {
                             $cur_point = $c_point['point'];
                             $new_point = $cur_point+$point;
                             $sqlu = "update customer_total_point set point='$new_point' where cid='$cust_id'";
                             $this->db->query($sqlu);
                        }
                        else
                        {
                            $sql1 = "insert into customer_total_point(cid,point) values('$cust_id','$point')";

                            $this->db->query($sql1);
                        }
			$sms_point = $point+$pre_total_point;
			$message = $this->targets->get_message($target_id,$sms_point);
			$this->customer_points->save('dms_sms_customer',array('company_id' =>$this->companyID,'bill_ref_no' =>$group_id,'user_id' =>$cust_id,'message'=>$message,'status'=>3));
			$this->message->set($this->lang->line('bonus-point-saved'));
			redirect('customer_points/add');
		}


			$args = array();
			$args['columns'] = array('a.id','a.user_id','a.target_type','a.valid_from','a.valid_to','b.qty','b.amount','b.points','itm.item_type','um.symbol');
			$args['conditions'] = array('user_id'=>0);
			$args['join'] = array('item_type_master as itm'=>'b.item_group_id=itm.id','unit_master as um'=>'b.unit_id=um.id');
			$args['all_data'] = 1;
                        $user_targets = $this->targets->get_customer_targets($args);
			if(!empty($user_targets)){
				foreach($user_targets as $key=>$target){
					if(empty($target['target_type'])){
						$targets[$target['id']] = $target['item_type'].' - '.$target['qty'].' '.$target['symbol'].' '.$target['points'].' points .    [ '.dateFormat($target['valid_from']).' - '.dateFormat($target['valid_to']).' ]';
					}else{
						$targets[$target['id']] = $target['item_type'].' - '.$target['amount'].' '.get_currency().' '.$target['points'].' points .    [ '.dateFormat($target['valid_from']).' - '.dateFormat($target['valid_to']).' ]';
					}
				}
			}
			
		

                $targets[''] = 'Select';
		ksort($targets);
		
		$customers[''] = 'Select';
		ksort($customers);
		
		
		# view starts here--------------------------------
		$this->template->slice('dms/message');
		$this->template->slice('customers/points/add_bonus_point',array('targets'=>$targets,'customers'=>$customers));
		$this->template->other_script(array('user_points/user_points'));
		$this->template->render();
	}

	#------------------------------------------------------------------------------


	public function report(){

		$this->template->title($this->lang->line('customer-point'));
		$this->template->main_heading($this->lang->line('customer-point'));
		$this->template->breadcrumb(array($this->lang->line('customer-point') => 'no_link'));

		//
		$customers = $user_points = array();
		$this->load->model('designations/Designation_master_model','designations');
		$this->load->model('customers/Customer_point_model','customer_points');
		//$this->load->model('users/User_point_model','user_points');
	
               
		#-----get select user points............................
		$this->form_validation->set_rules('cust_id','lang:customer','xss_clean|required');
		$links=$cust_id=NULL;$offset=$total_points=0;
		
		$customers = $this->customer_points->listing();
		
		$gift_status = $msg_status = array();
		$gift_status[0] = '<label class="rejected">'.$this->lang->line('rejected').'</label>';
		$gift_status[2] = '<label class="rejected">'.$this->lang->line('rejected').'</label>';
		$gift_status[1] = '<label class="pending">'.$this->lang->line('pending').'</label>';
		$gift_status[3] = '<label class="approved">'.$this->lang->line('approved').'</label>';

		$msg_status[0] = '<label class="rejected">'.$this->lang->line('rejected').'</label>';
		$msg_status[1] = '<label class="pending">'.$this->lang->line('pending').'</label>';
		$msg_status[2] = '<label class="rejected">'.$this->lang->line('rejected').'</label>';
		$msg_status[3] = '<label class="pending">'.$this->lang->line('message-sending').'</label>';
		$msg_status[4] = '<span class="pending">'.$this->lang->line('message-sending').'</span>';
		$msg_status[5] = '<span class="approved">'.$this->lang->line('message-sent').'</span>';
		$msg_status[6] = '<span class="rejected">'.$this->lang->line('message-not-sent').'</span>';

		if($this->form_validation->run() === true){

			$cust_id = $this->input->post('cust_id');

		}else{
			//if($this->uri->segment(3) && !empty($this->uri->segment(3)) && is_numeric($this->uri->segment(3))){
			//		$user_type_id = $this->uri->segment(3);
			//}
			if($this->uri->segment(3) && !empty($this->uri->segment(3)) && is_numeric($this->uri->segment(3))){
					$cust_id = $this->uri->segment(3);
			}
			//if($this->uri->segment(4) && !empty($this->uri->segment(4)) && is_numeric($this->uri->segment(4))){
			//		$user_id = $this->uri->segment(4);
			//}
		}

		$offset = ($this->uri->segment(5))?$this->uri->segment(5):0;
		if(!empty($cust_id)){
			#-------Pagination
			$this->load->library('Pagination');
			$config['uri_segment'] = 5;
			$config['per_page'] = $this->per_page();
			$config['base_url'] = base_url('customer_points/report/'.$cust_id);

			$args = array();
			$args['select'] = array('cp.created_on');
			$args['join'] = array('dms_sms_customer as ds'=>'cp.group_id=ds.bill_ref_no');
			$args['conditions'] = array('cp.user_id'=>$cust_id);
			$args['order_by'] = 'cp.created_on';
			$args['order'] = 'desc';
			$args['num_rows'] = 1;
			$config['total_rows'] = $this->customer_points->get($args);
			# Pagination Config Customizations
			$config['full_tag_open'] = '<ul class="pagination">';
			$config['full_tag_close'] = '</ul>';
			$config['first_link'] = 'First';
			$config['last_link'] = 'Last';
			$config['next_link'] = '&raquo;';
			$config['prev_link'] = '&laquo;';
			$config['cur_tag_open'] = '<li class="active"><a href="#">';
			$config['cur_tag_close'] = '</a></li>';
			$config['num_tag_open'] = '<li>';
			$config['num_tag_close'] = '</li>';
			$this->pagination->initialize($config);
			$links = $this->pagination->create_links();
			#---------------------------------------

			$args = array();
			$args['select'] = array('sum(cp.sms_point) as total_points');
			$args['join'] = array('dms_sms_customer as ds'=>'cp.group_id=ds.bill_ref_no');
			$args['conditions'] = array('cp.user_id'=>$cust_id);
			$args['order_by'] = 'cp.created_on';
			$args['order'] = 'desc';
			$customer_points_array = $this->customer_points->get($args);

			if(!empty($customer_points_array)){
				$total_points = $customer_points_array[0]['total_points'];
			}

			$args = array();
			$args['select'] = array('cp.created_on as point_date','cp.group_id','cp.sms_point','ds.driver_id','ds.bill_ref_no','ds.user_id','ds.message','ds.status as msg_status');
			$args['join'] = array('dms_sms_customer as ds'=>'cp.group_id=ds.bill_ref_no');
			$args['conditions'] = array('cp.user_id'=>$cust_id);
			$args['order_by'] = 'cp.created_on';
			$args['order'] = 'desc';
			$args['limit'] = $config['per_page'];
			$args['offset'] = $offset;
			$customer_points = $this->customer_points->get($args);

			if(empty($customer_points)){
				$this->message->set($this->lang->line('no-user-point-found'),'e');
			}

		}

		$customers[''] = 'Select';
		ksort($customers);
		# view starts here--------------------------------
		$this->template->slice('dms/message');
		$this->template->slice('customers/points/customer_point_report',array('customers'=>$customers,'customer_points'=>$customer_points,'count'=>$offset+1,'gift_status'=>$gift_status,'msg_status'=>$msg_status,'links'=>$links,'total_points'=>$total_points));
		$this->template->other_script(array('customer_points/customer_points'));
		$this->template->render();

	}

	#------------------------------------------------------------------------------


}
?>