<?php if( ! defined('BASEPATH')) exit ('No direct script aceess allowed');

	class Customer_types extends MY_Controller{

		public function __construct(){

			parent ::__construct();
			$this->load->model('customers/Customer_type_model','type');
			$this->check_access_right();
			#---------------- Checking Financial year is enabled / closed-----------------#
			$method_array = array('add','update','delete');
			fiscal_status($this->uri->segment(2),$method_array,"customer_types/report");	
			#---------------- Checking Financial year is enabled / closed-----------------#
		}
	   #--------------------------------------------------------
		public function add(){
			
			$this->template->title($this->lang->line('customer-type-settings'));
			$this->template->main_heading($this->lang->line('customer-type-settings'));
			$this->template->breadcrumb(array($this->lang->line('customer-types')=>'no_link',$this->lang->line('report')=>'customer_types/report',$this->lang->line('customer')=>'customer_master/add'));
			$this->template->slice('dms/message');	

			#validation
			$this->form_validation->set_rules('customer_type','lang:coustomer-type','required|trim|xss_clean|is_unique[customer_types.customer_type]');
			if($this->form_validation->run() === TRUE){
				$data = $this->input->post(NULL,TRUE);
				$data['company_id'] = $this->session->userdata('company_id');
				if($this->type->f_save('customer_types',$data)){
					$this->message->set($this->lang->line('cst-type-save'));
				}else{
					$this->message->set($this->lang->line('cst-type-not-save'));
				}
				redirect('customer_types/add');
			}

			#-------------------------loading view report--------------------------------
			#pagination
   	 		$this->load->library('Pagination');
   	 		$config['total_rows'] = $this->type->get_all(array('numrows'=>TRUE));
   	 		$config['base_url'] = base_url('customer_types/add');
   	 		$config['per_page'] = $this->per_page();
   	 		$config['uri_segment'] = 3;
			# Pagination Config Customizations
			$config['full_tag_open'] = '<ul class="pagination">';
			$config['full_tag_close'] = '</ul>';
			$config['first_link'] = 'First';
			$config['last_link'] = 'Last';
			$config['next_link'] = '&raquo;';
			$config['prev_link'] = '&laquo;';
			$config['cur_tag_open'] = '<li class="active"><a href="#">';
			$config['cur_tag_close'] = '</a></li>';
			$config['num_tag_open'] = '<li>';
			$config['num_tag_close'] = '</li>';
   	 		$this->pagination->initialize($config);
   	 		$links = $this->pagination->create_links();
   	 		$offset = $this->uri->segment($config['uri_segment'],0);
   	 		$types = $this->type->get_all(array('order_by'=>'created_on','order'=>'DESC','limit'=>$config['per_page'],'offset'=>$offset));
   	 		if(!empty($types)){
   	 			$this->template->append('customer/types/report',array('links'=>$links,'offset'=>$offset,'types'=>$types));
   	 		}
			#--------------------------------End------------------------------------------
			#template
			$this->template->slice('customer/types/new');
			$this->template->render();
		}

	   #--------------------------------------------------------

		public function report(){

			$this->template->title($this->lang->line('customer-type-settings'));
			$this->template->main_heading($this->lang->line('customer-type-settings'));
			$this->template->breadcrumb(array($this->lang->line('customer-types')=>'customer_types/add',$this->lang->line('report')=>'no_link',$this->lang->line('customer')=>'customer_master/add'));
			$this->template->slice('dms/message');
			#pagination
   	 		$this->load->library('Pagination');
   	 		$config['total_rows'] = $this->type->get_all(array('numrows'=>TRUE));
   	 		$config['base_url'] = base_url('customer_types/report');
   	 		$config['per_page'] = $this->per_page();
   	 		$config['uri_segment'] = 3;
			# Pagination Config Customizations
			$config['full_tag_open'] = '<ul class="pagination">';
			$config['full_tag_close'] = '</ul>';
			$config['first_link'] = 'First';
			$config['last_link'] = 'Last';
			$config['next_link'] = '&raquo;';
			$config['prev_link'] = '&laquo;';
			$config['cur_tag_open'] = '<li class="active"><a href="#">';
			$config['cur_tag_close'] = '</a></li>';
			$config['num_tag_open'] = '<li>';
			$config['num_tag_close'] = '</li>';	
   	 		$this->pagination->initialize($config);
   	 		$links = $this->pagination->create_links();
   	 		$offset = $this->uri->segment($config['uri_segment'],0);

   	 		$types = $this->type->get_all(array('order_by'=>'created_on','order'=>'DESC','limit'=>$config['per_page'],'offset'=>$offset));
			#template

			$this->template->slice('customer/types/report',array('links'=>$links,'offset'=>$offset,'types'=>$types));
			$this->template->render();
		}

		#--------------------------------------------------------

		public function delete($id){
			$type_id = $id;
			if(empty($type_id)){ redirect('customer_types/add');}

			if($this->if_exists('customer_types',array('id'=>$id,'status'=>1)) === false){
				redirect('customer_types/add');
			}

			$data['status'] = 0;
			$data['created_by'] = $this->session->userdata('id');
			$data['created_on'] = date('Y-m-d h:i:s');

			$total_pricelist = $this->db->select('id')->get_where('pricelist_settings',array('ctype_id'=>$type_id,'status'=>1))->num_rows();

			if(empty($total_pricelist)){

				if($this->type->delete_a(array('table'=>'customer_types','data'=>$data,'conditions'=>array('id'=>$type_id)))){
					$this->message->set($this->lang->line('cst-type-deleted'));
				}else{
					$this->message->set($this->lang->line('cst-type-not-deleted'));
				}
			}else{
				$this->message->set($this->lang->line('can-not-delete-cust-type'),'i');
			}
 			redirect('customer_types/add');
		}

	   #--------------------------------------------------------

		public function update($id){

			$this->template->title($this->lang->line('customer-type-settings'));
			$this->template->main_heading($this->lang->line('customer-type-settings'));
			$this->template->breadcrumb(array($this->lang->line('customer-types')=>'customer_types/add',$this->lang->line('update')=>'no_link',$this->lang->line('report')=>'customer_types/report',$this->lang->line('customer')=>'customer_master/add'));
			$this->template->slice('dms/message');

			$type_id = $id;
			if(empty($type_id)){ redirect('customer_types/add');}
			
			if($this->if_exists('customer_types',array('id'=>$id,'status'=>1)) === false){
				redirect('customer_types/add');
			}
						
			#get customer details
   	 		$type = $this->type->get_all(array('conditions'=>array('id'=>$type_id)))[0];
   	 		#validation
   	 		$this->form_validation->set_rules('customer_type','lang:coustomer-type','required|trim|xss_clean|is_edit_unique[customer_types.customer_type]');
   	 		if($this->form_validation->run() === TRUE){
   	 			$data = $this->input->post(NULL,TRUE);
   	 			if($this->type->update_a(array('table'=>'customer_types','data'=>$data,'conditions'=>array('id'=>$type_id)))){
					$this->message->set($this->lang->line('customer-type-updated'));
				}else{
					$this->message->set($this->lang->line('customer-type-not-updated'));
				}
				$call_ck_uri = $this->uri->uri_to_assoc(4);
				redirect($this->uri->assoc_to_uri($call_ck_uri));
   	 		}
   	 		#template
			$this->template->slice('customer/types/update',array('type'=> $type));
			$this->template->render();
		}

	   #--------------------------------------------------------

	}
?>