<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

	class Daily_tasks extends MY_Controller{

		function __construct(){
			parent :: __construct();
			$this->load->model('daily_tasks/Daily_task_model','dt');
			
			#---------------- Checking Financial year is enabled / closed-----------------#
			$method_array = array('dt_set_ind','dt_edit','dt_my_task_edit');
			fiscal_status($this->uri->segment(2),$method_array,"daily_tasks/dt_users_report");	
			#---------------- Checking Financial year is enabled / closed-----------------#
			
		}

	#-------------------------------------------------------------------------
	
	#date : 28-8-2014
	function dt_set_ind(){
		$this->template->title($this->lang->line('daily-tasks'));
		$this->template->main_heading($this->lang->line('daily-tasks'));
		$this->template->breadcrumb(array($this->lang->line('daily-tasks')=>'daily_tasks/dt_users_report',$this->lang->line('select-user')=>'no_link'));
		$this->form_validation->set_rules('task[task_date]','lang:date','required|is_date|xss_clean');
		$this->form_validation->set_rules('task[task_title]','lang:title','required|xss_clean|trim');
		$this->form_validation->set_rules('task[task_description]','lang:description','required|xss_clean|trim');
		if($this->form_validation->run() == TRUE){

			if(!$this->input->post('users')){
				$this->message->set($this->lang->line('select-atleast-one-user'),'e');
				$this->message->append_msg($this->lang->line('reupload-file'),'e');
			}else{
				$users = $this->input->post('users');
				$data = $this->input->post('task');
				$continue = 1;
				#upload file
				if($_FILES['task_file']['name'] != ''){
					$this->load->library('Image');
					$file_name = $this->image->random_name($_FILES['task_file']['name']);
					$ext = pathinfo($_FILES['task_file']['name'], PATHINFO_EXTENSION);
					
					#file uploading 
					$config['upload_path'] =  FCPATH.'assets/files/tasks/';
					$config['allowed_types'] = 'jpeg|jpg|png|pdf|xlsx|xls|doc|txt';
					$config['max_size']	= '2048';
					//$config['max_width']  = '2560';
					//$config['max_height']  = '1600';
					$config['file_name'] = $file_name;
					$this->load->library('Upload');
					$this->upload->initialize($config);

					if($this->upload->do_upload('task_file')){
						$data['task_file'] = $file_name;
					}else{
						$continue=0;
						$this->message->set($this->lang->line('invalid-filetype'),'e');//die;
					}
				}
				if($continue == 1){
					foreach($users as $user){
						$data['employee_id'] = $user;
						$this->dt->save($data);
					}
					$this->message->set($this->lang->line('task-saved'));
					redirect('daily_tasks/dt_set_ind');
				}
			}

		}else{
			if($this->input->post()){
				$this->message->set($this->lang->line('reupload-file'),'e');
			}	
		}

		#select all employees
		$this->load->model('users/User_model','users');
		$users = $this->user->get_all();
		$this->template->slice('dms/message');
		$this->template->slice('daily_tasks/select_user',array('users'=>$users));
		$this->template->other_script('daily_tasks/daily_tasks');
		$this->template->render();
	}	

	#--------------------------------------------------------------------------	

	#date : 28-8-2014
	function dt_set_desig(){
		$this->template->render();
	}

	#--------------------------------------------------------------------------
	#date:4-09-2014
	#purpose:employees complete tas reports
	function dt_users_report(){
		#defining 
		$links = NULL;
		$tasks = NULL;
		$offset = NULL;
		$filter_data = array('from_date'=>'','to_date'=>'','task_title'=>'');

		if(isset($_POST['filter']) || $this->uri->segment(3) != ''){

			if($this->input->post('search')){
				$filter_data = $this->input->post('search');
			}
			else{
				$filter_data = $this->uri->uri_to_assoc(3);
			}
			$filter_data = array_filter($filter_data);
			if(empty($filter_data)){
						$this->message->set($this->lang->line('use-one-filter'),'e');
			}
			else{
			
				if(isset($_POST['filter'])){
					
					if(isset($filter_data['from_date']) && $filter_data['from_date'] != ''){
						$this->form_validation->set_rules('search[from_date]','lang:date','required|is_date');
					}

					if(isset($filter_data['to_date']) && $filter_data['to_date'] != ''){
						$this->form_validation->set_rules('search[to_date]','lang:date','required|is_date');
					}

					if(isset($filter_data['task_title']) && $filter_data['task_title'] != ''){
						$this->form_validation->set_rules('search[task_title]','lang:task','required|xss_clean|trim');
					}

				}
				if($this->form_validation->run()==TRUE || $this->uri->segment(3) != ''){

					#---------checking from date and to date set----------------------------

					if(isset($filter_data['from_date']) && $filter_data['from_date']!=''){
						$from_date =date('Y-m-d',strtotime($filter_data['from_date']));
						$filter_data['from_date'] = $from_date;
					}

					if(isset($filter_data['to_date']) && $filter_data['to_date']!=''){
						$to_date =date('Y-m-d',strtotime($filter_data['to_date']));
						$filter_data['to_date'] = $to_date;
					}
					#---------checking date conditions----------------------------
					if(!empty($from_date)&& !empty($to_date)){
						$conditions['task_date >='] = $from_date;
						$conditions['task_date <='] = $to_date;
					}
					if(!empty($from_date) && empty($to_date)){
						$conditions['task_date >='] = $from_date;
					}
					if(!empty($to_date) && empty($from_date)){
						$conditions['task_date <='] = $to_date;
					}

					if(isset($filter_data['task_title']) && $filter_data['task_title']!=''){
						$conditions['task_title'] = $filter_data['task_title'];
					}

					$this->load->library('Pagination');
					$config['per_page'] = $this->per_page();
					$config['base_url'] = base_url('daily_tasks/dt_users_report').'/'.$this->uri->assoc_to_uri(array_filter($filter_data));
					$config['uri_segment'] = count(array_filter($filter_data)) * 2 + 3;
					$config['total_rows'] = $this->dt->get_all(array('numrows'=>TRUE,'conditions'=>$conditions));
					# Pagination Config Customizations
					$config['full_tag_open'] = '<ul class="pagination">';
					$config['full_tag_close'] = '</ul>';
					$config['first_link'] = 'First';
					$config['last_link'] = 'Last';
					$config['next_link'] = '&raquo;';
					$config['prev_link'] = '&laquo;';
					$config['cur_tag_open'] = '<li class="active"><a href="#">';
					$config['cur_tag_close'] = '</a></li>';
					$config['num_tag_open'] = '<li>';
					$config['num_tag_close'] = '</li>';
					$this->pagination->initialize($config);
					$links = $this->pagination->create_links();
					$offset = $this->uri->segment($config['uri_segment'],0);
					$tasks = $this->dt->get_all(array('order_by'=>'created_on','order'=>'DESC','limit'=>$config['per_page'],'offset'=>$offset,'conditions'=>$conditions,'group_by'=>'task.task_title'));
					if(empty($tasks)){
						$this->message->set($this->lang->line('no-task-data-found'),'e');
					}
					else{
						$this->template->append('daily_tasks/report',array('tasks'=>$tasks,'links'=>$links,'offset'=>$offset));
					}
	
				}
			}
			if(!isset($filter_data['from_date'])){ $filter_data['from_date'] = ''; }else{$filter_data['from_date'] = date(CAL_FORMAT,strtotime($filter_data['from_date']));}

			if(!isset($filter_data['to_date'])){ $filter_data['to_date'] = ''; }else{$filter_data['to_date'] = date(CAL_FORMAT,strtotime($filter_data['to_date']));}

			if(!isset($filter_data['task_title'])){ $filter_data['task_title'] = ''; }else{$filter_data['task_title'] = $filter_data['task_title'];}
		}
		if($this->session->userdata('id') == -1 || $this->session->userdata('id') == -2){
			$title_lists = $this->dt->title_listing(array('status'=>1));
		}
		else{
			$title_lists = $this->dt->title_listing(array('employee_id'=>$this->session->userdata('id'),'status'=>1));
		}
		if(empty($title_lists)){
			$this->message->set('No tasks has been found ');
		}
		$title_lists[''] = 'Select a task';
		ksort($title_lists);	

		#template;
		$this->template->title('Daily Tasks User Report');
		$this->template->main_heading($this->lang->line('daily-tasks'));
		$this->template->breadcrumb(array($this->lang->line('daily-tasks')=>'daily_tasks/dt_set_ind',$this->lang->line('report')=>'no_link'));
		$this->template->slice('dms/message');
		$this->template->slice('daily_tasks/search_report',array('links'=>$links,'offset'=>$offset,'tasks'=>$tasks,'data'=>$filter_data,'title_lists'=>$title_lists));
		$this->template->slice('dms/modals/more_details');
		$this->template->other_script('daily_tasks/task_assign_users');
		$this->template->render();
	}
	#---------------------------------------------------------------------------
	#date:10-09-2014
	#purpose:edit daily task
	function dt_edit(){

		$dt_id = $this->uri->segment(3);
		if(empty($dt_id)){ redirect('daily_tasks/dt_users_report');}

		#get detials of $dt_id;
		$task = $this->db->select()->get_where('employee_tasks',array('id'=>$dt_id))->row_array();
		if(empty($task)){
			redirect('daily_tasks/dt_users_report');
		}
		#get all employee ids assigned task
		$rows = $this->db->select('employee_id')->get_where('employee_tasks',array('task_title'=>$task['task_title']))->result_array();
		$user_ids = array();
		foreach($rows as $row){
			$user_ids[] = $row['employee_id'];
		}
		#validation
		$this->form_validation->set_rules('task[task_date]','lang:date','required|is_date|xss_clean');
		$this->form_validation->set_rules('task[task_title]','lang:title','required|xss_clean|trim');
		$this->form_validation->set_rules('task[task_description]','lang:description','required|xss_clean|trim');
		if($this->form_validation->run() == TRUE){

			if(!$this->input->post('users')){
				$this->message->set($this->lang->line('select-atleast-one-user'),'e');
				$this->message->append_msg($this->lang->line('reupload-file'),'e');
			}else{
				$users = $this->input->post('users');
				$data = $this->input->post('task');
				$continue = 1;
				#upload file
				if($_FILES['task_file']['name'] != ''){
					$this->load->library('Image');
					$file_name = $this->image->random_name($_FILES['task_file']['name']);
					$ext = pathinfo($_FILES['task_file']['name'], PATHINFO_EXTENSION);
					
					#file uploading 
					$config['upload_path'] =  FCPATH.'assets/files/tasks/';
					$config['allowed_types'] = 'jpeg|jpg|png|pdf|xlsx|xls|doc|txt';
					$config['max_size']	= '2048';
					//$config['max_width']  = '2560';
					//$config['max_height']  = '1600';
					$config['file_name'] = $file_name;
					$this->load->library('Upload');
					$this->upload->initialize($config);

					if($this->upload->do_upload('task_file')){
						$data['task_file'] = $file_name;
					}else{
						$continue=0;
						$this->message->set($this->lang->line('invalid-filetype'),'e');//die;
					}
				}

				#update task
				if($continue == 1){
					foreach($users as $user){
					
						if(!in_array($user,$user_ids)){
							$task = $this->db->select()->get_where('employee_tasks',array('id'=>$dt_id))->row_array();
							if(empty($data['task_file'])){
								$data['task_file'] = $task['task_file'];
							}
							$data['employee_id'] = $user;
							$this->dt->save($data);
						}
						else{
							$data['task_date'] = date('Y-m-d',strtotime($data['task_date']));
							$this->db->update('employee_tasks',$data,array('employee_id'=>$user,'task_title'=>$task['task_title']));
						}
					}
					foreach($user_ids as $id){
						if(!in_array($id,$users)){
							$this->db->update('employee_tasks',array('status'=>0),array('id'=>$id,'task_title'=>$task['task_title']));
						}
					}

					$this->message->set($this->lang->line('task-updated'));
					$call_ck_uri = $this->uri->uri_to_assoc(4);
					redirect($this->uri->assoc_to_uri($call_ck_uri));die;
				}
			}	

		}else{
			if($this->input->post()){
				$this->message->set($this->lang->line('reupload-file'),'e');
			}	
		}
		#select all employees
		$this->load->model('users/User_model','users');
		$users =  $this->user->get_all();
		#template
		$this->template->title('Edit A Daily Task');
		$this->template->main_heading($this->lang->line('daily-tasks'));
		$this->template->breadcrumb(array($this->lang->line('daily-tasks')=>'daily_tasks/dt_users_report',$this->lang->line('update')=>'no_link'));
		$this->template->slice('dms/message');
		$this->template->slice('daily_tasks/edit_user',array('users'=>$users,'task'=>$task,'user_ids'=>$user_ids));
		$this->template->other_script('daily_tasks/daily_tasks');
		$this->template->render();
	}
	#---------------------------------------------------------------------------
	#date:20-09-2014
	#purpose:get my_task
		function dt_my_tasks(){
		$this->dt->i_have_seen_my_tasks($this->session->userdata('id'));
		
		$task_id = $this->uri->segment(3);
		$conditions = array('employee_id'=>$this->session->userdata('id'),'id'=>$task_id);

		$tasks = $this->dt->get_all_my_task(array('conditions'=>$conditions,'limit'=>1,'offset'=>0));
		//echo $this->db->last_query();die;
		if(empty($tasks)){
			$this->message->set($this->lang->line('no-task-data-found'),'e');
		}
		
		$this->template->title('My Tasks');
		$this->template->main_heading($this->lang->line('daily-tasks'));
		$this->template->breadcrumb(array($this->lang->line('daily-tasks')=>'daily_tasks/all_my_tasks',$this->lang->line('report')=>'no_link'));
		$this->template->slice('dms/message');
		$this->template->slice('daily_tasks/my_task',array('tasks'=>$tasks));	
		$this->template->slice('dms/modals/more_details');
		$this->template->other_script('daily_tasks/task_details');
		$this->template->render();
	}
	#---------------------------------------------------------------------------
	#date:20-09-2014
	#purpose:edit my task;
	function dt_my_task_edit(){

		$my_task_id = $this->uri->segment(3);
		if(empty($my_task_id)){ redirect('daily_tasks/all_my_tasks');}

		#get detials of $dt_id;
		$task = $this->db->select()->get_where('employee_tasks',array('id'=>$my_task_id))->row_array();
		if(empty($task)){ redirect('daily_tasks/all_my_tasks');}
		$this->form_validation->set_rules('task[task_status]','lang:status','required|trim|xss_clean');
		$this->form_validation->set_rules('task[employee_comments]','lang:comments','required|trim|xss_clean');
		if($this->form_validation->run()==TRUE){

			$data = $this->input->post('task');
			$continue=1;
			#upload file
			if($_FILES['task_file']['name'] != ''){
				$this->load->library('Image');
				$file_name = $this->image->random_name($_FILES['task_file']['name']);
				$ext = pathinfo($_FILES['task_file']['name'], PATHINFO_EXTENSION);
				
				#file uploading 
				$config['upload_path'] =  FCPATH.'assets/files/tasks/';
				$config['allowed_types'] = 'jpeg|jpg|png|pdf|xlsx|xls|doc|txt';
				$config['max_size']	= '2048';
				//$config['max_width']  = '2560';
				//$config['max_height']  = '1600';
				$config['file_name'] = $file_name;
				$this->load->library('Upload');
				$this->upload->initialize($config);

				if($this->upload->do_upload('task_file')){
					$data['task_file'] = $file_name;
				}else{
					$continue=0;
					$this->message->set($this->lang->line('invalid-filetype'),'e');//die;
				}
			}

			$call_ck_uri = $this->uri->uri_to_assoc(4);
			#update task 
			if($continue ==1){
				if($this->db->update('employee_tasks',$data,array('id'=>$my_task_id))){

					$this->message->set($this->lang->line('task-updated'));
					redirect($this->uri->assoc_to_uri($call_ck_uri));die;

				}
				else{
					$this->message->set($this->lang->line('task-not-updated'));
					redirect($this->uri->assoc_to_uri($call_ck_uri));die;
				}

			}
		}else{
			if($this->input->post()){
				$this->message->set($this->lang->line('reupload-file'),'e');
			}	
		}

		#defiining task status array()
		$task_status = array(''=>'select','pending'=>'Pending','ongoing'=>'Ongoing','complete'=>'complete');
		#template
		$this->template->title('Edit My Task');
		$this->template->main_heading($this->lang->line('daily-tasks'));
		$this->template->breadcrumb(array($this->lang->line('daily-tasks')=>'daily_tasks/all_my_tasks',$this->lang->line('update')=>'no_link'));
		$this->template->slice('dms/message');
		$this->template->slice('daily_tasks/my_task_edit',array('task'=>$task,'task_status'=>$task_status));
		$this->template->render();

	}
	#---------------------------------------------------------------------------
	#date:29-09-2014
	#purpose get all tasks for assigned for employee:
	function all_my_tasks(){

		#defining 
		$links = NULL;
		$tasks = NULL;
		$offset = NULL;
		$filter_data = array('from_date'=>'','to_date'=>'','task_title'=>'');
		#title listing
		if(isset($_POST['filter']) || $this->uri->segment(4)!= ''){

			
			if($this->input->post('search')){

				$filter_data = $this->input->post('search');
			}
			else{
				$filter_data = $this->uri->uri_to_assoc(3);
			}
			$filter_data = array_filter($filter_data);
			if(empty($filter_data)){
						$this->message->set($this->lang->line('use-one-filter'),'e');
			}
			else{
			
				if(isset($_POST['filter'])){


					if(isset($filter_data['from_date']) && $filter_data['from_date'] != ''){
						$this->form_validation->set_rules('search[from_date]','lang:date','required|is_date');
					}

					if(isset($filter_data['to_date']) && $filter_data['to_date'] != ''){
						$this->form_validation->set_rules('search[to_date]','lang:date','required|is_date');
					}

					if(isset($filter_data['task_title']) && $filter_data['task_title'] != ''){
						$this->form_validation->set_rules('search[task_title]','lang:task','required|xss_clean|trim');
					}			
				}
				if($this->form_validation->run()==TRUE || $this->uri->segment(3) != ''){

					#---------checking from date and to date set----------------------------

					if(isset($filter_data['from_date']) && $filter_data['from_date']!=''){
						$from_date =date('Y-m-d',strtotime($filter_data['from_date']));
						$filter_data['from_date'] = $from_date;
					}

					if(isset($filter_data['to_date']) && $filter_data['to_date']!=''){
						$to_date =date('Y-m-d',strtotime($filter_data['to_date']));
						$filter_data['to_date'] = $to_date;
					}
					#---------checking date conditions----------------------------
					if(!empty($from_date)&& !empty($to_date)){
						$conditions['task_date >='] = $from_date;
						$conditions['task_date <='] = $to_date;
					}
					if(!empty($from_date) && empty($to_date)){
						$conditions['task_date >='] = $from_date;
					}
					if(!empty($to_date) && empty($from_date)){
						$conditions['task_date <='] = $to_date;
					}

					if(isset($filter_data['task_title']) && $filter_data['task_title']!=''){
						$conditions['task_title'] = $filter_data['task_title'];
					}
					
				}
			}
			if(!isset($filter_data['from_date'])){ $filter_data['from_date'] = ''; }else{$filter_data['from_date'] = date(CAL_FORMAT,strtotime($filter_data['from_date']));}

			if(!isset($filter_data['task_title'])){ $filter_data['task_title'] = ''; }else{$filter_data['task_title'] = $filter_data['task_title'];}

			if(!isset($filter_data['to_date'])){ $filter_data['to_date'] = ''; }else{$filter_data['to_date'] = date(CAL_FORMAT,strtotime($filter_data['to_date']));}
		}
		$conditions['employee_id'] = $this->session->userdata('id');
		$this->load->library('Pagination');
		$config['per_page'] = $this->per_page();
		$config['base_url'] = base_url('daily_tasks/all_my_tasks').'/'.$this->uri->assoc_to_uri(array_filter($filter_data));
		$config['uri_segment'] = count(array_filter($filter_data)) * 2 + 3;
		$config['total_rows'] = $this->dt->get_all_my_task(array('numrows'=>TRUE,'conditions'=>$conditions));
		# Pagination Config Customizations
        $config['full_tag_open'] = '<ul class="pagination">';
        $config['full_tag_close'] = '</ul>';
        $config['first_link'] = 'First';
        $config['last_link'] = 'Last';
        $config['next_link'] = '&raquo;';
        $config['prev_link'] = '&laquo;';
        $config['cur_tag_open'] = '<li class="active"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
		$this->pagination->initialize($config);
		$links = $this->pagination->create_links();
		$offset = $this->uri->segment($config['uri_segment'],0);
		$tasks = $this->dt->get_all_my_task(array('order_by'=>'created_on','order'=>'DESC','limit'=>$config['per_page'],'offset'=>$offset,'conditions'=>$conditions,'group_by'=>'task.task_title'));
		if(empty($tasks)){
			$this->message->set($this->lang->line('no-task-data-found'),'e');
		}
		else{
			$this->template->append('daily_tasks/all_my_tasks',array('tasks'=>$tasks,'links'=>$links,'offset'=>$offset));
		}
	
		$title_lists = $this->dt->title_listing(array('employee_id'=>$this->session->userdata('id')));
		$title_lists[''] = 'Select a task';
		ksort($title_lists);

       #template
		$this->template->title('All My Tasks');
		$this->template->main_heading($this->lang->line('daily-tasks'));
		$this->template->breadcrumb(array($this->lang->line('daily-tasks')=>'daily_tasks/dt_users_report',$this->lang->line('all-my-tasks')=>'no_link'));
		$this->template->slice('dms/message');
		$this->template->slice('daily_tasks/search_report',array('links'=>$links,'offset'=>$offset,'tasks'=>$tasks,'data'=>$filter_data,'title_lists'=>$title_lists));
		$this->template->slice('dms/modals/more_details');
		$this->template->other_script('daily_tasks/task_details');
		$this->template->render();
	}
	#---------------------------------------------------------------------------
	public function download_dt_file(){
		$file = $this->uri->segment(3);
		$this->load->helper('download');

		if(file_exists("assets/files/tasks/".$file)) {
			$image_name = $file;
			$image_path = $data = "assets/files/tasks/".$file;
			header('Content-Type: application/octet-stream');
			header("Content-Disposition: attachment; filename=$image_name");
			ob_clean();
			flush();
			readfile($image_path);
		}
	}
	#---------------------------------------------------------------------------
	public function dt_delete(){
		$dt_id = $this->uri->segment(3);
		$call_back_uri = $this->uri->uri_to_assoc(4);
		$call_back_uri = $this->uri->assoc_to_uri($call_back_uri);
		if(empty($dt_id)){ redirect('daily_tasks/dt_users_report');}
		if($this->if_exists('employee_tasks',array('id'=>$dt_id,'status'=>1)) === false){
				redirect('daily_tasks/dt_users_report');
		}
		$task = $this->db->select()->get_where('employee_tasks',array('id'=>$dt_id))->row_array();
		if(empty($task)){
			redirect('daily_tasks/dt_users_report');
		}
		if($this->dt->my_update('employee_tasks',array('status'=>0),array('task_title'=>$task['task_title']))){
			echo $this->db->last_query();die;
			$this->message->set($this->lang->line('task-deleted'),'s');
		}
		else{
			$this->message->set($this->lang->line('task-not-deleted'),'e');
		}
		redirect($call_back_uri);
	}
	#---------------------------------------------------------------------------
	}
?>