<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

class Delivery_note extends MY_Controller{

	public function __construct()
	{
		parent::__construct();

		$this->check_access_right();
		$this->companyID = $this->session->userdata('company_id');

		#---------------- Checking Financial year is enabled / closed-----------------#
		$method_array = array('add','delete_temp','update_temp','update','delete');
		fiscal_status($this->uri->segment(2),$method_array,"delivery_note/report");
		#---------------- Checking Financial year is enabled / closed-----------------#

		$this->load->model('sales/Delivery_note_model','sales');
		$this->load->model('vouchers/Voucher_model','vouchers');
		$this->load->library(array('Stock','Targets'));

		#-----------checking branch_type
		$this->branch_status = 0;
		if($this->dms->branch_type()){
			$this->branch_status = 1;
		}

		#-----------voucher type
		$this->vtype = 10;
	}

	public function add()
	{
		#----------loading models
		$this->load->model('designations/Designation_master_model','desig');
		$this->load->model('customers/Customer_type_model','customer_type');

		#----------voucher type
		$vtype_id = $this->vtype;

		#----------voucher type array
		$voucher_types = $this->vouchers->voucher_types($this->vtype);
		$bill_prefix = $this->stock->get_voucher_prefix($this->vtype);
		#----------voucher name
		$voucher_name = $this->vouchers->voucher_name($this->vtype);

		#-----------sales cst checking details
		$sales_cst = $this->stock->get_constant(array('sales_cst'));

		#------------presumptive tax checking
		$presumptive_tax = $this->stock->get_tax_type();

		#------------cess %
		$cess = $this->stock->get_cess();


		$this->load->library('Transport_lib');

		$vehicles =$drivers = $routes= $sales_vehicles = $sales_driver = array();

		$vehicles = $this->transport_lib->vehicles();
		$drivers = $this->transport_lib->drivers();
		$routes = $this->transport_lib->routes();


		#-----------delivery date and next bill no
		$rules = "callback_bill_no_exists";
		$disabled = "";
		$result_array = $this->sales->next_bill_no($this->vtype);
		$vtype_id = $result_array['vtype_id'];
		$voucher_no = $result_array['bill_no'];
		$voucher_date = $result_array['bill_date'];

		if($result_array['vstatus'])
		{

			#-----------redirection if sales order / purchase request conversion is pending
			if($result_array['s_status'] == 2)
			{
				redirect("order_to_sales/so_sales/".$result_array['sid']);
			}
			elseif($result_array['s_status'] == 1)
			{
				redirect("request_to_delivery/pr_delivery/".$result_array['sid']);
			}

			$disabled = "readonly";
			$group_id = $result_array['group_id'];
			$rules = "callback_bill_no_exists[$vtype_id.$group_id]";

			#------------checking cst enabled or not
			$cst_status = $this->sales->get_cst($group_id);
			if($cst_status)
			{
				$sales_cst = $cst_status;
			}
		}
		else
		{
			$group_id = $this->stock->get_group_id('dms_sales_items');
		}


		#-------------adding data to delivery temp
		if(isset($_POST['btn_add']))
		{
			#-----------validation
			$this->form_validation->set_rules('vtype_id','lang:voucher-types','required|xss_clean');
			$this->form_validation->set_rules('sales[bill_no]','lang:bill-no',"required|xss_clean|is_natural_no_zero|".$rules);
			$this->form_validation->set_rules('sales[bill_date]','lang:bill-date','required|xss_clean|valid_date');
			$this->form_validation->set_rules('sales[dno]','lang:dno',"xss_clean|trim");
			$this->form_validation->set_rules('sales[customer_type]','lang:customer-type','required|xss_clean');
			$this->form_validation->set_rules('sales[customer_id]','lang:customer-name','required|xss_clean');
			$this->form_validation->set_rules('item_id','lang:item-name','required|xss_clean');
			$this->form_validation->set_rules('godown_id','lang:godown','required|xss_clean');
			$this->form_validation->set_rules('cst','lang:cst','xss_clean|greater_or_equal[0]|less_or_equal[100]');
			$this->form_validation->set_rules('qty','lang:quantity','required|xss_clean|greater_than[0]|less_than[100000000]');
			$this->form_validation->set_rules('unit_id','lang:unit','required|xss_clean');
			$this->form_validation->set_rules('rate','lang:rate','required|xss_clean|greater_or_equal[0]|less_than[100000000]');
			$this->form_validation->set_rules('amount','lang:amount','xss_clean|required|greater_or_equal[0]|less_than[100000000]');
			$this->form_validation->set_rules('discount_per','lang:discount %','xss_clean|greater_than[0]|less_or_equal[100]');
			$this->form_validation->set_rules('discount_amt','lang:discount','xss_clean|greater_or_equal[0]|less_than[100000000]');

			#-----------adding temporary data
			if($this->form_validation->run('btn_add') === true)
			{

				$sales_temp_array = $this->input->post('sales',true);
				$sales_temp_array['vtype_id'] = $this->input->post('vtype_id',true);
				$sales_temp_array = array_filter($sales_temp_array);



				#-----------bill date and next bill no
				if($result_array['vstatus'] == 0)//data not in dms_delivery_notes
				{
					$vtype_id = $sales_temp_array['vtype_id'];
					$voucher_no = $sales_temp_array['bill_no'];
					$voucher_date = date('Y-m-d',strtotime($sales_temp_array['bill_date']));
					$sales_temp_result = $this->sales->get_sales(array('columns' => array('a.id'),'conditions' => array('a.created_by' => $this->session->userdata('id'),'vtype_id' => $vtype_id,'bill_no' => $voucher_no,'a.status' => -1),'numrows' => true));
					if($sales_temp_result == 0)
					{
						$group_id = $this->stock->get_group_id('dms_sales_items');
						$customer_type = $sales_temp_array['customer_type'];
						$customer_id = $sales_temp_array['customer_id'];
						$data_sales_temp=array('vtype_id' => $vtype_id,'branch_id' => $this->session->userdata('under_id'),'bill_no' => $voucher_no,'bill_date' => $voucher_date,'group_id' => $group_id,'dno' => $sales_temp_array['dno'],'customer_type_id' => $customer_type,'customer_id' => $customer_id,'status' => -1);
						if(array_key_exists('user_id',$sales_temp_array)){
							$data_sales_temp['user_id'] = $sales_temp_array['user_id'];
						}
						if(array_key_exists('pricelist_id',$sales_temp_array)){
							$data_sales_temp['pricelist_id'] = $sales_temp_array['pricelist_id'];
						}
						$this->sales->insert("dms_delivery_notes",$data_sales_temp);
					}
				}
				$item_array = $this->input->post(NULL,true);
				unset($item_array['sales']);
				unset($item_array['vtype_id']);
				unset($item_array['btn_add']);
				$item_array['group_id'] = $group_id;

				#----------rate calculation
				$item_array['rate'] = 0;
				if($item_array['qty'] != 0){
					$item_array['rate'] = $item_array['amount'] / $item_array['qty'];
				}

				#----------VAT calculation
				$cst = 0;
				if(isset($item_array['cst']))
				{
					$cst = $item_array['cst'];
				}
				if(empty($presumptive_tax))
				{
					if($cst == 0)
					{
						$vat_percent = $this->stock->get_item_vat($item_array['item_id']);
						$item_array['vat_percent'] = $vat_percent;
						$item_array['vat_amt'] = (($item_array['amount']-$item_array['discount_amt']) * $vat_percent) / 100;
					}
				}

				$item_array['status'] = -1;
				$item_array['item_status'] = 2;//sales only items
				$sales_temp_item_result = $this->sales->get_sales(array('columns' => array('b.id'),'conditions' => array('b.group_id' => $group_id,'item_id' => $item_array['item_id'],'godown_id' => $item_array['godown_id'],'unit_id' => $item_array['unit_id'],'a.status !=' => 0,'b.status !=' => 0),'numrows' => true));
				if($sales_temp_item_result == 0)
				{
					$sales_items_id = $this->sales->insert("dms_sales_items",$item_array);
					if($sales_items_id)
					{
						#--------------adding temporary stock balance in dms_stocks
						$stock_bal_temp = $this->stock->unit_conversion($item_array['item_id'],$item_array['unit_id'],$item_array['qty'],$item_array['rate'],$item_array['amount']);
						if($stock_bal_temp)
						{
							$this->sales->insert('dms_stocks',array('company_id' => $this->session->userdata('company_id'),'branch_id' => $this->session->userdata('under_id'),'godown_id' => $item_array['godown_id'],'item_id' => $item_array['item_id'],'qty' => $stock_bal_temp['qty'],'unit_id' => $stock_bal_temp['primary_unit'],'rate' => $stock_bal_temp['rate'],'amount' => $stock_bal_temp['amount'],'stock_date' => $voucher_date,'stock_status' => 5,'table_group_id' => $group_id,'table_id' => $sales_items_id,'status' => -1));
						}
						$this->message->set($this->lang->line('delivery-add-success'));
					}
					else
					{
						$this->message->set($this->lang->line('delivery-add-error'),'e');
					}
				}
				else
				{
					$this->message->set($this->lang->line('delivery-add-error'),'e');
				}
				redirect('delivery_note/add');
			}
		}

		#------------saving delivery_note voucher
		if(isset($_POST['btn_save']))
		{
			#-----------validation
			$this->form_validation->set_rules('area_id','lang:area','required|xss_clean');
			$this->form_validation->set_rules('remarks','lang:remarks','xss_clean');
			$this->form_validation->set_rules('freight','lang:freight','xss_clean|greater_or_equal[0]|less_than[100000000]');
			$this->form_validation->set_rules('other_expense','lang:other-expense','xss_clean|greater_or_equal[0]|less_than[100000000]');
			$this->form_validation->set_rules('bill_discount_per','lang:discount %','xss_clean|greater_or_equal[0]|less_or_equal[100]');
			$this->form_validation->set_rules('bill_discount_amt','lang:discount','xss_clean|greater_or_equal[0]|less_than[100000000]');

			#-------------------vehicle-----------------------------

			if($this->input->post('vehicle_type'))
			{
				$this->form_validation->set_rules('vehicle_id','lang:vehicle','xss_clean|required');
				$this->form_validation->set_rules('driver_id','lang:driver','xss_clean|required');
			}
			else
			{
				$this->form_validation->set_rules('vehicle_no','lang:vehicle','xss_clean|required');
				$this->form_validation->set_rules('driver_name','lang:driver','xss_clean');
			}
			$this->form_validation->set_rules('route_id','lang:to','xss_clean|required');
			$this->form_validation->set_rules('km','lang:km','xss_clean|is_numeric|greater_or_equal[0]');
			$this->form_validation->set_rules('vehicle_rent','lang:vehicle-rent','xss_clean|is_numeric|greater_or_equal[0]');



			#-----------saving data

			if($this->form_validation->run('btn_save') === true)
			{
				$sales_entry_array=array('area_id' => $this->input->post('area_id',true),'bill_discount_per' => $this->input->post('bill_discount_per',true),'bill_discount_amt	' => $this->input->post('bill_discount_amt',true),'bill_freight' => $this->input->post('freight',true),'other_expense' => $this->input->post('other_expense',true),'cess' => $cess,'narration' => $this->input->post('remarks',true),'status' => 1);

				$sales_entry_check = $this->sales->get_sales(array('columns' => array('a.bill_date','a.customer_type_id','a.customer_id','a.user_id'),'conditions' => array('a.group_id' => $group_id,'a.status !=' => 0)));
				if($sales_entry_check)
				{
					$bill_date = $sales_entry_check[0]['bill_date'];
					if($this->sales->update(array('table' => 'dms_delivery_notes','data' => $sales_entry_array,'conditions' => array('group_id' => $group_id))))
					{
						$this->sales->update(array('table' => 'dms_sales_items','data' => array('status' => 1),'conditions' => array('group_id' => $group_id)));

						#-------------enabling temporarily added stocks
						$sales_items_array = $this->sales->get_sales_items(array('columns' => array('id'),'conditions' => array('group_id' => $group_id,'status' => 1)));
						foreach($sales_items_array as $key => $value)
						{
							$this->sales->update_others(array('table' => 'dms_stocks','data' => array('status' => 1),'conditions' => array('stock_status' => 5,'table_id' => $value['id'])));
						}

						#vehicle assign

						$this->load->model('sales/Sales_vehicle_model','sales_vehicle');
						//$postedValues = $this->input->post();
						$sales_group_id = $group_id;
						$postedValues['vehicle_id'] = $this->input->post('vehicle_id',true);
						$postedValues['driver_id'] = $this->input->post('driver_id',true);
						$postedValues['vehicle_no'] = $this->input->post('vehicle_no',true);
						$postedValues['driver_name'] = $this->input->post('driver_name',true);
						$postedValues['route_id'] = $this->input->post('route_id',true);
						$postedValues['km'] = $this->input->post('km',true);
						$postedValues['vehicle_rent'] = $this->input->post('vehicle_rent',true);
						$postedValues['remarks'] = $this->input->post('remarks',true);


						$postedValues['group_id'] = $group_id;

						$vehicle_type = 1;
						if($this->input->post('vehicle_type'))
						{

							$postedValues['vehicle_type'] = 0;
							$args = array();
							$args['select'] = array('dsv.id');
							$args['conditions'] = array('dsv.group_id'=>$sales_group_id,'dsv.vehicle_id'=>$postedValues['vehicle_id']);
							$sales_vehicle = $this->sales_vehicle->get($args);

							$args = array();
							$args['select'] = array('dsv.id');
							$args['conditions'] = array('dsv.group_id'=>$sales_group_id,'dsv.driver_id'=>$postedValues['driver_id']);
							$sales_driver = $this->sales_vehicle->get($args);

						}
						else
						{

							$postedValues['vehicle_type'] = 1;
							$postedValues['vehicle_id'] = '';
							$postedValues['driver_id'] = '';

						}

						if(empty($sales_vehicle) && empty($sales_driver))
						{
							if($this->sales_vehicle->save($postedValues))
							{
								//$this->message->set($this->lang->line('vehicle-assigned'));
								redirect('dnote_vehicles/assign/avid/'.$salesID.'/'.$urlString);
							}
							else
							{
								//$this->message->set($this->lang->line('vehicle-not-assigned'),'e');
							}
						}


						$this->message->set($this->lang->line('delivery-save-success'));

					}
					else
					{
						$this->message->set($this->lang->line('delivery-save-error'),'e');
					}
					
				}
				else
				{
					$this->message->set($this->lang->line('delivery-save-error'),'e');
				}
				redirect('delivery_note/add');
			}
		}

		#------------customer type
		$user_types = array();$custType = 2;
		if($this->branch_status){
			$customerTypes = $this->desig->listing(array('department_id'=>0,'utype_status >'=>1));
		}
		else{
			$customerTypes = $this->desig->listing(array('id'=>2));
		}


		#------------item details / unit details / godown details
		$units = array();$goDowns = array();
		$units[''] = "Select";
		$args['select'] = array('id','item_code','item_name');
		$items = $this->stock->get_stock_items($args);
		if(empty($items)){
			$this->message->set($this->lang->line('no-items-found'),'i');
		}
		if($this->input->post('item_id',true)){
			$itemID = $this->input->post('item_id',true);
			$goDowns = $this->stock->get_item_godowns(array('item_id'=>$itemID,'listing'=>1));
			$units = $this->stock->get_units($itemID);
		}

		#------------delivery temp data
		$sales_temp_data = array();$cust_id="";$users = array();$user = "";$pricelists=array();$desig_id="";
		$price_list_id="";$stock_count="";$primary_unit['symbol']="";
		if($result_array['vstatus'])
		{
			#------------area details
			$this->load->model('areas/Area_model','area');
			$areas = $this->area->listing();

			$sales_temp_data = $this->sales->get_sales(array('columns' => array('a.group_id','a.customer_type_id','a.customer_id','a.user_id','a.pricelist_id','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.discount_per','b.discount_amt','b.godown_id','b.vat_amt','b.cst'),'conditions' => array('a.created_by' => $this->session->userdata('id'),'vtype_id' => $vtype_id,'bill_no' => $voucher_no,'a.status =' => -1,'b.status =' => -1)));

			#------------customer type
			$custType = $sales_temp_data[0]['customer_type_id'];

			#------------customer
			$cust_id = $sales_temp_data[0]['customer_id'];

			#------------user
			$user = $sales_temp_data[0]['user_id'];

			#------------user designation
			$desig_id = $this->dms->get_desig($user);

			#------------user details
			$users = $this->dms->get_users(array('conditions' => array('designation_id' => $desig_id,'branch_id' => $this->session->userdata('under_id'))));

			#------------pricelist id
			$price_list_id = $sales_temp_data[0]['pricelist_id'];;
		}
		else
		{
			$sales_array = $this->input->post('sales',true);
			#------------customer type
			if($sales_array['customer_type'] != ""){
				$custType = $sales_array['customer_type'];
			}
			if($sales_array['customer_id'] != ""){
				$cust_id = $sales_array['customer_id'];
			}

			#------------user details
			if($sales_array['user_type'] != ""){
				$desig_id = $sales_array['user_type'];
				$users = $this->dms->get_users(array('conditions' => array('designation_id' => $desig_id,'branch_id' => $this->session->userdata('under_id'))));
				if($sales_array['user_id'] != ""){
					$user = $sales_array['user_id'];
				}
			}

			#------------pricelist
			if(isset($sales_array['pricelist_id']) && $sales_array['pricelist_id'] != ""){
				$price_list_id = $sales_array['pricelist_id'];
			}

			#------------stock count of this item
			if($this->input->post('item_id',true) && $this->input->post('godown_id',true) && $sales_array['bill_date'] != ""){
				$stock_count = $this->stock->get_stock_count($this->input->post('godown_id',true),$this->input->post('item_id',true),$sales_array['bill_date']);
				$primary_unit = $this->stock->get_primary_unit($this->input->post('item_id',true));
			}
		}

		#------------customer details
		if($this->branch_status)
		{
			if($custType == 1){

				$this->load->model('branches/Branch_model','branches');
				$customers = $this->branches->listing(array('id !='=>$this->session->userdata('under_id')));
			}
			else if($custType ==2){
				$this->load->model('customers/Customer_master_model','customer_master');
				$customers = $this->customer_master->listing();
				#array('conditions'=>array('branch_id'=>$this->session->userdata('under_id')))
				#------------usertype details
				$user_types = $this->desig->listing(array('utype_status' => 1));
			}
			else{
				$this->load->model('retailers/Counter_model','retailer_master');
				$customers = $this->retailer_master->listing(array('company_id'=>$this->session->userdata('company_id')));
			}
		}
		else
		{
			$this->load->model('customers/Customer_master_model','customer_master');
			$customers = $this->customer_master->listing();
			#array('conditions'=>array('branch_id'=>$this->session->userdata('under_id')))

			#------------usertype details
			$user_types = $this->desig->listing(array('utype_status' => 1));
		}

		#------------pricelist details
		$pricelists = $this->customer_type->listing();

		$areas[''] = 'Select';ksort($areas);
		$customers[''] = "Select";ksort($customers);
		$user_types[''] = "Select";ksort($user_types);
		$pricelists[''] = 'Select';ksort($pricelists);
		$items[''] = 'Select';ksort($items);
		$goDowns[''] = 'Select';ksort($goDowns);
		$users[''] = 'Select';ksort($users);

		#------------template
		$this->template->title("New Delivery Note Voucher");
		$this->template->main_heading($this->lang->line("$voucher_name"));
		$this->template->breadcrumb(array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line("$voucher_name") => 'no_link',$this->lang->line('report') => 'delivery_note/report'));
		$this->template->slice('dms/message');
		$this->template->slice('sales/delivery_note/add',array('voucher_types' => $voucher_types,'voucher_type' => $vtype_id,'voucher_name' => $voucher_name,'voucher_no' => $voucher_no,'voucher_date' => $voucher_date,'custType' => $custType,'customerTypes' => $customerTypes,'customers' => $customers,'user_types' => $user_types,'users' => $users,'user' => $user,'pricelists' => $pricelists,'price_list_id' => $price_list_id,'items' => $items,'units' => $units,'goDowns' => $goDowns,'sales_temp_status' =>$result_array['vstatus'],'sales_temp_data' => $sales_temp_data,'areas' => $areas,'sales_cst' => $sales_cst,'presumptive_tax' => $presumptive_tax,'cess' => $cess,'disabled' => $disabled,'cust_id' => $cust_id,'desig_id' => $desig_id,'stock_count' => $stock_count,'primary_unit' => $primary_unit['symbol'],'bill_prefix'=>$bill_prefix,'vehicles'=>$vehicles,'drivers'=>$drivers,'routes'=>$routes));
		$this->template->other_script('sales/sales_order');


		$this->template->other_script('vehicles/assign_vehicle');

		$this->template->render();
	}

	public function delete_temp()
	{
		#----------delivery temp data
		$uri_array = $this->uri->uri_to_assoc(3);
		if(isset($uri_array['idu']) || isset($uri_array['ida']))
		{
			if(isset($uri_array['idu']))
			{
				$id = $uri_array['idu'];
				unset($uri_array['idu']);

				#-----------redirect uri
				$redirect_uri = "delivery_note/update/".$this->uri->assoc_to_uri($uri_array);
			}
			else
			{
				$id = $uri_array['ida'];
				unset($uri_array['ida']);

				#-----------redirect uri
				$redirect_uri = "delivery_note/add/".$this->uri->assoc_to_uri($uri_array);
			}

			$result = $this->sales->get_sales_items(array('columns' => array('group_id','status','item_status','created_by'),'conditions' => array('id' => $id)));
			if(!empty($result))
			{
				$row = $result[0];
				if($row['status'] == -1)
				{
					if($row['created_by'] == $this->session->userdata('id'))
					{
						#----------start transaction
						$this->db->trans_start();

						if($this->sales->delete(array('table' => 'dms_sales_items','conditions' => array('id' => $id))))
						{
							#-------------deleting stock bal. from dms_stocks
							$this->sales->delete(array('table' => 'dms_stocks','conditions' => array('table_id' => $id,'stock_status' => 5)));

							$count = $this->sales->get_sales_items(array('columns' => array('group_id'),'conditions' => array('group_id' => $row['group_id'],'status !=' => 0),'numrows' => true));
							if($count == 0){
								$this->sales->delete(array('table' => 'dms_delivery_notes','conditions' => array('group_id' => $row['group_id'])));
							}
							$this->message->set($this->lang->line('delivery-item-delete-success'));
						}
						else
						{
							$this->message->set($this->lang->line('delivery-item-delete-error'),'e');
						}

						#----------end transaction
						$this->db->trans_complete();
					}
					else
					{
						redirect('users/logout');
					}
				}
				else
				{
					#----------start transaction
					$this->db->trans_start();

					#-------------deleting item from dms_sales_items
					if($row['item_status'] == 2)//delivery_note
					{
						$this->sales->update(array('table' => 'dms_sales_items','data' => array('status' => 0),'conditions' => array('id' => $id)));
					}
					else//sales order
					{
						$this->sales->update(array('table' => 'dms_sales_items','data' => array('item_status' => -1),'conditions' => array('id' => $id)));
					}

					#-------------deleting stock bal. from dms_stocks
					$this->sales->update_others(array('table' => 'dms_stocks','data' => array('status' => 0),'conditions' => array('table_id' => $id,'stock_status' => 5)));

					#-------------deleting delivery bill
					$count = $this->sales->get_sales_items(array('columns' => array('group_id'),'conditions' => array('group_id' => $row['group_id'],'status !=' => 0,'item_status >' => 0),'numrows' => true));
					if($count == 0)
					{
						$this->sales->update(array('table' => 'dms_delivery_notes','data' => array('status' => 0),'conditions' => array('group_id' => $row['group_id'])));

						#-----------redirect uri
						$redirect_uri = "delivery_note/report/".$this->uri->assoc_to_uri($uri_array);
					}
					$this->message->set($this->lang->line('delivery-item-delete-success'));

					#----------end transaction
					$this->db->trans_complete();
				}
			}
			redirect($redirect_uri);
		}
		redirect('users/logout');
	}

	public function update_temp()
	{
		#----------delivery temp data
		$uri_array = $this->uri->uri_to_assoc(3);
		if(isset($uri_array['idu']) || isset($uri_array['ida']))
		{
			if(isset($uri_array['idu']))
			{
				$sales_temp_id = $uri_array['idu'];
				unset($uri_array['idu']);

				#-----------redirect uri
				$redirect_uri = "delivery_note/update/".$this->uri->assoc_to_uri($uri_array);
			}
			else
			{
				$sales_temp_id = $uri_array['ida'];
				unset($uri_array['ida']);

				#-----------redirect uri
				$redirect_uri = "delivery_note/add/".$this->uri->assoc_to_uri($uri_array);
			}

			$row = $this->sales->get_sales_items(array('columns' => array('id','group_id','item_id','qty','unit_id','rate','amount','discount_per','discount_amt','vat_amt','cst','godown_id','status','created_by'),'conditions' => array('id' => $sales_temp_id,'status !=' => 0)));
			if(!empty($row))
			{
				$sales_temp_data = $row[0];$continue = 1;
				if($sales_temp_data['status'] == -1){
					if($sales_temp_data['created_by'] != $this->session->userdata('id')){
						$continue = 0;
					}
				}
				if($continue == 1)
				{
					#-----------validation
					$this->form_validation->set_rules('godown_id','lang:godown','required|xss_clean');
					$this->form_validation->set_rules('cst','lang:cst','xss_clean|greater_or_equal[0]|less_or_equal[100]');
					$this->form_validation->set_rules('qty','lang:quantity','required|xss_clean|greater_than[0]|less_than[100000000]');
					$this->form_validation->set_rules('unit_id','lang:unit','required|xss_clean');
					$this->form_validation->set_rules('rate','lang:rate','required|xss_clean|greater_or_equal[0]|less_than[100000000]');
					$this->form_validation->set_rules('amount','lang:amount','xss_clean|required|greater_or_equal[0]|less_than[100000000]');
					$this->form_validation->set_rules('discount_per','lang:discount %','xss_clean|greater_or_equal[0]|less_or_equal[100]');
					$this->form_validation->set_rules('discount_amt','lang:discount','xss_clean|greater_or_equal[0]|less_than[100000000]');
					$this->form_validation->set_rules('vat_amt','lang:vat-amt','xss_clean|greater_or_equal[0]|less_than[100000000]');

					#-----------updating temporary data
					if($this->form_validation->run('btn_add') === true)
					{
						$item_temp_array = $this->input->post(NULL,true);

						#----------rate calculation
						$item_temp_array['rate'] = 0;
						if($item_temp_array['qty'] != 0){
							$item_temp_array['rate'] = $item_temp_array['amount'] / $item_temp_array['qty'];
						}

						if($this->sales->update(array('table' => 'dms_sales_items','data' => $item_temp_array,'conditions' => array('id' => $sales_temp_id)))){

							#--------------updating temporary stock balance in dms_stocks
							$stock_bal_temp = $this->stock->unit_conversion($sales_temp_data['item_id'],$item_temp_array['unit_id'],$item_temp_array['qty'],$item_temp_array['rate'],$item_temp_array['amount']);
							if($stock_bal_temp)
							{
								$this->sales->update_others(array('table' => 'dms_stocks','data' => array('godown_id' => $item_temp_array['godown_id'],'qty' => $stock_bal_temp['qty'],'unit_id' => $stock_bal_temp['primary_unit'],'rate' => $stock_bal_temp['rate'],'amount' => $stock_bal_temp['amount']),'conditions' => array('stock_status' => 5,'table_id' => $sales_temp_id)));
							}
							$this->message->set($this->lang->line('delivery-edit-temp-success'));
						}
						else{
							$this->message->set($this->lang->line('delivery-edit-temp-error'),'e');
						}
						redirect($redirect_uri);
					}

					#----------voucher name
					$voucher_name = $this->vouchers->voucher_name($this->vtype);

					#-----------sales cst checking details
					$sales_cst = $this->stock->get_constant(array('sales_cst'));

					#------------presumptive tax checking
					$presumptive_tax = $this->stock->get_tax_type();

					#------------checking cst enabled or not
					$cst_status = $this->sales->get_cst($sales_temp_data['group_id']);
					if($cst_status){
						$sales_cst = $cst_status;
					}

					#------------item details / unit details / godown details
					$units = array();$goDowns = array();
					$item_details = $this->stock->get_item($sales_temp_data['item_id'],array('item_code','item_name'));
					$items[$sales_temp_data['item_id']] = $item_details['item_code']." / ".$item_details['item_name'];
					$goDowns = $this->stock->get_item_godowns(array('item_id'=>$sales_temp_data['item_id'],'listing'=>1));
					$goDowns[''] = 'Select';
					ksort($goDowns);
					$units = $this->stock->get_units($sales_temp_data['item_id']);

					#------------delivery date
					$sale_date = $this->sales->get_sales(array('columns' => array('bill_date'),'conditions' => array('a.group_id' => $sales_temp_data['group_id'],'a.status !=' => 0)))[0];

					#------------stock count of this item
					$stock_count = $this->stock->get_stock_count($sales_temp_data['godown_id'],$sales_temp_data['item_id'],$sale_date['bill_date']);

					#------------primary unit details
					$primary_unit = $this->stock->get_primary_unit($sales_temp_data['item_id']);

					#------------template
					$this->template->title("Update Delivery Note Voucher");
					$this->template->main_heading($this->lang->line("$voucher_name"));
					$this->template->breadcrumb(array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line("$voucher_name") => 'delivery_note/add',$this->lang->line("update") => 'no_link',$this->lang->line('report') => 'delivery_note/report',$this->lang->line('go-back') => array($redirect_uri)));
					$this->template->slice('dms/message');
					$this->template->slice('sales/delivery_note/edit_temp',array('voucher_name' => $voucher_name,'items' => $items,'units' => $units,'goDowns' => $goDowns,'sales_temp_data' => $sales_temp_data,'sales_cst' => $sales_cst,'presumptive_tax' => $presumptive_tax,'stock_count' => $stock_count,'unit_symbol' => $primary_unit['symbol'],'sale_date' => $sale_date['bill_date']));
					$this->template->other_script('sales/sales_order');
					$this->template->render();
				}
				else
				{
					redirect('users/logout');
				}
			}
			else
			{
				redirect('users/logout');
			}
		}
		else
		{
			redirect('users/logout');
		}
	}

	public function bill_no_exists($bill_no,$v_details = NULL)
	{
		if($v_details == NULL){
			$where = array('vtype_id' => $this->input->post('vtype_id',true),'bill_no' => $bill_no,'status !=' => 0);
		}
		else{
			$exp = explode('.', $v_details);
			$where = array('vtype_id' => $exp[0],'bill_no' => $bill_no,'group_id !=' => $exp[1],'status !=' => 0);
		}
		$row = $this->sales->get_bills(array('columns' => array('id'),'conditions' => $where,'numrows' => true));
		if($row == 0){
			return true;
		}
		return false;
	}

	public function report()
	{
		#----------loading models
		$this->load->model('designations/Designation_master_model','desig');

		#----------voucher type
		$vtype_id = $this->vtype;
		$conditions = array('vtype_id' => $vtype_id,'status' => 1);
		$like_array = array();$vnos="";

		#----------voucher name
		$voucher_name = $this->vouchers->voucher_name($this->vtype);

		#----------voucher type array
		$voucher_types = $this->vouchers->voucher_types($this->vtype);

		#----------uri array
		$uri_array  = $this->uri->uri_to_assoc(3);

		#----------redirect
		$redirect = "";

		#----------pagination
		$this->load->library('Pagination');
		$config['per_page'] = $this->per_page();
		$config['base_url'] = base_url('delivery_note/report');
		$config['uri_segment'] = 3;

		#----------dates within financial year
		$cur_date = date('Y-m-d');
		$from_date = $cur_date;
		$to_date = $cur_date;
		$cur_fiscal_yr = $this->dms->get_fiscal_year();
		if($from_date < $cur_fiscal_yr['start_date'] || $from_date > $cur_fiscal_yr['end_date'] || $to_date < $cur_fiscal_yr['start_date'] || $to_date > $cur_fiscal_yr['end_date'])
		{
			$from_date = $cur_fiscal_yr['end_date'];
			$to_date = $cur_fiscal_yr['end_date'];
		}

		#----------validation
		$this->form_validation->set_rules('vtype_id','voucher-types','required|xss_clean');
		$this->form_validation->set_rules('from_date','From Date','required|xss_clean|valid_date');
		$this->form_validation->set_rules('to_date','To Date','required|xss_clean|valid_date');
		$this->form_validation->set_rules('bill_no','bill-no','xss_clean|trim');
		if($this->form_validation->run() === true)
		{
			$vtype_id = $this->input->post('vtype_id',true);
			$from_date = date('Y-m-d',strtotime($this->input->post('from_date',true)));
			$to_date = date('Y-m-d',strtotime($this->input->post('to_date',true)));
			$conditions['vtype_id'] = $vtype_id;
			$config['base_url'] .= '/vt/'.$vtype_id.'/fdate/'.$from_date.'/tdate/'.$to_date;
			$config['uri_segment'] += 6;
			$redirect .= '/vt/'.$vtype_id.'/fdate/'.$from_date.'/tdate/'.$to_date;
			if(!empty($this->input->post('bill_no',true)))
			{
				$vnos = $this->input->post('bill_no',true);
				$like_array['bill_no'] = $vnos;
				$config['base_url'] .= '/vn/'.$vnos;
				$config['uri_segment'] += 2;
				$redirect .= '/vn/'.$vnos;
			}
		}
		elseif(isset($uri_array['vt']))
		{
			$vtype_id = $uri_array['vt'];
			$conditions['vtype_id'] = $vtype_id;
			$config['base_url'] .= '/vt/'.$conditions['vtype_id'];
			$config['uri_segment'] += 2;
			$redirect .= '/vt/'.$vtype_id;
			if(isset($uri_array['fdate']) && isset($uri_array['tdate']))
			{
				$from_date = date('Y-m-d',strtotime($uri_array['fdate']));
				$to_date = date('Y-m-d',strtotime($uri_array['tdate']));
				$config['base_url'] .= '/fdate/'.$from_date.'/tdate/'.$to_date;
				$config['uri_segment'] += 4;
				$redirect .= '/fdate/'.$from_date.'/tdate/'.$to_date;
			}
			if(isset($uri_array['vn']))
			{
				$vnos = $uri_array['vn'];
				$like_array['bill_no'] = $vnos;
				$config['base_url'] .= '/vn/'.$vnos;
				$config['uri_segment'] += 2;
				$redirect .= '/vn/'.$vnos;
			}
		}

		#----------between condition
		$between = "bill_date between '$from_date' and '$to_date'";

		#----------total rows
		$config['total_rows'] = $this->sales->get_bills(array('columns' => array('id'),'conditions' => $conditions,'between' => $between,'like' => $like_array,'numrows'=>true));

		if($config['total_rows'] == 0){
			$this->message->set($this->lang->line('no-voucher'),'i');
		}

		#----------pagination
		$offset = $this->uri->segment($config['uri_segment'],0);
		# Pagination Config Customizations
        $config['full_tag_open'] = '<ul class="pagination">';
        $config['full_tag_close'] = '</ul>';
        $config['first_link'] = 'First';
        $config['last_link'] = 'Last';
        $config['next_link'] = '&raquo;';
        $config['prev_link'] = '&laquo;';
        $config['cur_tag_open'] = '<li class="active"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
		$this->pagination->initialize($config);
		$links = $this->pagination->create_links();
		$redirect .= '/'.$offset;

		#------------presumptive tax checking
		$presumptive_tax = $this->stock->get_tax_type();

		#----------delivery report datas
		$sales_array=$this->sales->get_bills(array('conditions' => $conditions,'between' => $between,'like' => $like_array,'order_by'=>'bill_date','order'=>'DESC','limit'=>$config['per_page'],'offset'=>$offset));

		#----------template
		$this->template->title("Delivery Note Report");
		$this->template->main_heading($this->lang->line("$voucher_name")." ".$this->lang->line("report"));
		$this->template->breadcrumb(array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line("$voucher_name") => 'delivery_note/add',$this->lang->line('report') => 'no_link'));
		$this->template->slice('sales/sales_entry/search',array('voucher_types' => $voucher_types,'vtype_id' => $vtype_id,'vnos' => $vnos,'from_date' => $from_date,'to_date' => $to_date,'rtype' => 'delivery_note'));
		$this->template->slice('dms/message');
		if(!empty($sales_array))
		{
			$this->template->slice('sales/delivery_note/report',array('sales_array' => $sales_array,'presumptive_tax' => $presumptive_tax,'offset' => $offset,'links' => $links,'redirect' => $redirect));
			$this->template->slice('dms/modals/delete_confirm');
		}
		$this->template->other_script('sales/sales_order');
		$this->template->render();
	}

	public function view()
	{
		#----------voucher type
		$vtype_id = $this->vtype;

		#----------delivery primary key
		$uri_array = $this->uri->uri_to_assoc(3);
		if(isset($uri_array['id']) || isset($uri_array['group_id']))
		{
			#----------voucher name
			$voucher_name = $this->vouchers->voucher_name($this->vtype);

			#----------breadcrumb
			$breadcrumb = array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line("$voucher_name") => 'delivery_note/add',$this->lang->line('report') => 'delivery_note/report',$this->lang->line("view") => 'no_link');

			if(isset($uri_array['group_id']))
			{
				$conditions = array('a.group_id' => $uri_array['group_id'],'a.status !=' => 0,'b.status !=' => 0);
				if(isset($uri_array['id']) || isset($uri_array['mid']) || isset($uri_array['sid']))
				{
					if(isset($uri_array['id'])){
						$breadcrumb_url = "stock_item_register/index/id/".$uri_array['id'];
					}
					elseif(isset($uri_array['mid'])){
						$breadcrumb_url = "stock_item_register/index/mid/".$uri_array['mid'];
					}
					elseif(isset($uri_array['sid'])){
						$breadcrumb_url = "stock_item_register/index/sid/".$uri_array['sid'];
					}
					if(isset($uri_array['rtype'])){
						$breadcrumb_url .= "/rtype/".$uri_array['rtype'];
					}
					$breadcrumb[$this->lang->line("go-back")] = $breadcrumb_url;
				}
			}
			else
			{
				$sales_id = $uri_array['id'];
				unset($uri_array['id']);
				$conditions = array('a.id' => $sales_id,'a.status !=' => 0,'b.status !=' => 0);
				$breadcrumb[$this->lang->line("go-back")] = "delivery_note/report/".$this->uri->assoc_to_uri($uri_array);
			}

			#----------delivery data
			$sales_array = $this->sales->get_sales(array('columns' => array('a.id as primary_id','a.vtype_id','a.branch_id','a.bill_no','a.bill_date','a.group_id','a.dno','a.customer_type_id','a.customer_id','a.user_id','a.area_id','a.bill_discount_per','a.bill_discount_amt','a.bill_freight','a.other_expense','a.cess','a.narration','a.pricelist_id','a.d_status','a.created_by','a.created_on','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.discount_per','b.discount_amt','b.godown_id','b.vat_amt','b.cst'),'conditions' => $conditions));
			if(!empty($sales_array))
			{
				#------------loading model
				$this->load->model('customers/Customer_type_model','customer_type');

				#------------presumptive tax checking
				$presumptive_tax = $this->stock->get_tax_type();

				#------------checking cst enabled or not
				$sales_cst = $this->sales->get_cst($sales_array[0]['group_id']);

				$voucher_type = $this->vouchers->voucher_name($sales_array[0]['vtype_id']);
				$customer_name = $this->stock->get_customer($sales_array[0]['customer_type_id'],$sales_array[0]['customer_id']);
				$user_type = $this->dms->get_desig($sales_array[0]['user_id'],1);
				$user = $this->dms->get_user_name($sales_array[0]['user_id']);
				$pricelist = $this->customer_type->get_pricelist($sales_array[0]['pricelist_id']);
				$area_id = $this->dms->get_area($sales_array[0]['area_id']);

				#----------template
				$this->template->title("Delivery Note Report");
				$this->template->main_heading($this->lang->line("$voucher_name")." ".$this->lang->line("view"));
				$this->template->breadcrumb($breadcrumb);
				$this->template->slice('dms/message');
				$this->template->slice('sales/delivery_note/view',array('sales_array' => $sales_array,'presumptive_tax' => $presumptive_tax,'sales_cst' => $sales_cst,'voucher_type' => $voucher_type,'customer_name' => $customer_name,'user_type' => $user_type['designation_name'],'user' => $user,'pricelist' => $pricelist,'area_id' => $area_id));
				$this->template->other_script('sales/sales_order');
				$this->template->render();
			}
			else
			{
				redirect('users/logout');
			}
		}
		else
		{
			redirect('users/logout');
		}
	}

	public function update()
	{
		#----------voucher type
		$vtype_id = $this->vtype;

		#----------delivery primary key
		$uri_array = $this->uri->uri_to_assoc(3);
		if(isset($uri_array['id']))
		{
			$sales_id = $uri_array['id'];
			$redirect = "/".$this->uri->assoc_to_uri($uri_array);
			unset($uri_array['id']);

			#----------redirect uri
			$redirect_uri = "delivery_note/report/".$this->uri->assoc_to_uri($uri_array);

			#----------redirect uri while updating
			$update_uri = $this->uri->assoc_to_uri($this->uri->uri_to_assoc(1));

			#----------voucher name
			$voucher_name = $this->vouchers->voucher_name($this->vtype);

			#-----------sales cst checking details
			$sales_cst = $this->stock->get_constant(array('sales_cst'));

			#------------presumptive tax checking
			$presumptive_tax = $this->stock->get_tax_type();

			#------------cess %
			$cess = $this->stock->get_cess();

			#------------bill group_id and date
			$item_details = $this->sales->get_group($sales_id);

			#-------------adding items to delivery bill
			if(isset($_POST['btn_add']))
			{
				#-----------validation
				$this->form_validation->set_rules('item_id','lang:item-name','required|xss_clean|is_natural_no_zero');
				$this->form_validation->set_rules('godown_id','lang:godown','required|xss_clean');
				$this->form_validation->set_rules('cst','lang:cst','xss_clean|greater_or_equal[0]|less_or_equal[100]');
				$this->form_validation->set_rules('qty','lang:quantity','required|xss_clean|greater_than[0]|less_than[100000000]');
				$this->form_validation->set_rules('unit_id','lang:unit','required|xss_clean');
				$this->form_validation->set_rules('rate','lang:rate','required|xss_clean|greater_or_equal[0]|less_than[100000000]');
				$this->form_validation->set_rules('amount','lang:amount','xss_clean|required|greater_or_equal[0]|less_than[100000000]');
				$this->form_validation->set_rules('discount_per','lang:discount %','xss_clean|greater_or_equal[0]|less_or_equal[100]');
				$this->form_validation->set_rules('discount_amt','lang:discount','xss_clean|greater_or_equal[0]|less_than[100000000]');
				//$this->form_validation->set_rules('freight','lang:freight','xss_clean|greater_or_equal[0]|less_than[100000000]');

				#-----------adding items
				if($this->form_validation->run('btn_add') === true)
				{
					$item_array['group_id'] = $item_details['group_id'];
					$item_array['item_id'] = $this->input->post('item_id',true);
					$item_array['qty'] = $this->input->post('qty',true);
					$item_array['unit_id'] = $this->input->post('unit_id',true);
					$item_array['amount'] = $this->input->post('amount',true);

					#----------rate calculation
					$item_array['rate'] = 0;
					if($item_array['qty'] != 0){
						$item_array['rate'] = $item_array['amount'] / $item_array['qty'];
					}
					//$item_array['rate'] = $this->input->post('rate',true);
					$item_array['discount_per'] = $this->input->post('discount_per',true);
					$item_array['discount_amt'] = $this->input->post('discount_amt',true);
					$item_array['godown_id'] = $this->input->post('godown_id',true);
					$item_array['status'] = 1;
					$item_array['item_status'] = 2;//sales only items
					$sales_temp_item_result = $this->sales->get_sales(array('columns' => array('b.id'),'conditions' => array('b.group_id' => $item_array['group_id'],'item_id' => $item_array['item_id'],'godown_id' => $item_array['godown_id'],'unit_id' => $item_array['unit_id'],'a.status !=' => 0,'b.status !=' => 0),'numrows' => true));
					if($sales_temp_item_result == 0){

						#----------VAT calculation
						$cst = 0;
						if($this->input->post('cst',true)){
							$cst = $this->input->post('cst',true);
							$item_array['cst'] = $cst;
						}
						if(empty($presumptive_tax)){
							if(!$cst){
								$vat_percent = $this->stock->get_item_vat($item_array['item_id']);
								$item_array['vat_percent'] = $vat_percent;
								$item_array['vat_amt'] = (($item_array['amount']-$item_array['discount_amt']) * $vat_percent) / 100;
							}
						}

						$sales_items_id = $this->sales->insert("dms_sales_items",$item_array);
						if($sales_items_id)
						{
							#--------------adding stock balance in dms_stocks
							$stock_bal = $this->stock->unit_conversion($item_array['item_id'],$item_array['unit_id'],$item_array['qty'],$item_array['rate'],$item_array['amount']);
							if($stock_bal)
							{
								$this->sales->insert('dms_stocks',array('company_id' => $this->session->userdata('company_id'),'branch_id' => $this->session->userdata('under_id'),'godown_id' => $item_array['godown_id'],'item_id' => $item_array['item_id'],'qty' => $stock_bal['qty'],'unit_id' => $stock_bal['primary_unit'],'rate' => $stock_bal['rate'],'amount' => $stock_bal['amount'],'stock_date' => $item_details['bill_date'],'stock_status' => 5,'table_group_id' => $item_array['group_id'],'table_id' => $sales_items_id));
							}
							$this->message->set($this->lang->line('delivery-add-success'));
						}
						else
						{
							$this->message->set($this->lang->line('delivery-add-error'),'e');
						}
					}
					else{
						$this->message->set($this->lang->line('delivery-add-error'),'e');
					}
					redirect($update_uri);
				}
			}

			#------------saving delivery voucher
			if(isset($_POST['btn_update']))
			{
				#-----------validation
				$this->form_validation->set_rules('bill_no','lang:bill-no',"required|xss_clean|is_natural_no_zero|callback_bill_no_exists[$item_details[vtype_id].$item_details[group_id]]");
				$this->form_validation->set_rules('bill_date','lang:bill-date','required|xss_clean|valid_date');
				$this->form_validation->set_rules('dno','lang:dno','xss_clean|trim');
				$this->form_validation->set_rules('customer_type','lang:customer-type','required|xss_clean');
				$this->form_validation->set_rules('customer_id','lang:customer-name','required|xss_clean');
				$this->form_validation->set_rules('area_id','lang:area','required|xss_clean');
				$this->form_validation->set_rules('remarks','lang:remarks','xss_clean');
				$this->form_validation->set_rules('freight','lang:freight','xss_clean|greater_or_equal[0]|less_than[100000000]');
				$this->form_validation->set_rules('other_expense','lang:other-expense','xss_clean|greater_or_equal[0]|less_than[100000000]');
				$this->form_validation->set_rules('bill_discount_per','lang:discount %','xss_clean|greater_or_equal[0]|less_or_equal[100]');
				$this->form_validation->set_rules('bill_discount_amt','lang:discount','xss_clean|greater_or_equal[0]|less_than[100000000]');

				#-----------updating data
				if($this->form_validation->run('btn_update') === true)
				{
					$bill_date = date('Y-m-d',strtotime($this->input->post('bill_date',true)));
					$sales_entry_array=array('bill_no' => $this->input->post('bill_no',true),'bill_date' => $bill_date,'dno' => $this->input->post('dno',true),'customer_type_id' => $this->input->post('customer_type',true),'customer_id' => $this->input->post('customer_id',true),'user_id' => $this->input->post('user_id',true),'area_id' => $this->input->post('area_id',true),'bill_discount_per' => $this->input->post('bill_discount_per',true),'bill_discount_amt	' => $this->input->post('bill_discount_amt',true),'bill_freight' => $this->input->post('freight',true),'other_expense' => $this->input->post('other_expense',true),'cess' => $cess,'narration' => $this->input->post('remarks',true),'status' => 1);
					if($this->sales->update(array('table' => 'dms_delivery_notes','data' => $sales_entry_array,'conditions' => array('id' => $sales_id)))){
						$this->message->set($this->lang->line('delivery-edit-success'));
					}
					else{
						$this->message->set($this->lang->line('delivery-edit-error'),'e');
					}
					redirect($update_uri);
				}
			}

			#----------delivery data
			$sales_array = $this->sales->get_sales(array('columns' => array('a.vtype_id','a.bill_no','a.bill_date','a.group_id','a.dno','a.customer_type_id','a.customer_id','a.user_id','a.area_id','a.bill_discount_per','a.bill_discount_amt','a.bill_freight','a.other_expense','a.cess','a.narration','a.pricelist_id','a.status','a.d_status','a.bill_status','a.created_by','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.discount_per','b.discount_amt','b.godown_id','b.vat_amt','b.cst'),'conditions' => array('a.id' => $sales_id,'a.status !=' => 0,'b.status !=' => 0)));
			if(!empty($sales_array))
			{
				if($sales_array[0]['d_status'] == 1 || $sales_array[0]['bill_status'] >=2){
					$this->message->set($this->lang->line('bill-already-converted'),'e');
					redirect($redirect_uri);
				}
				$continue = 1;
				if($sales_array[0]['status'] == -1){
					if($sales_array[0]['created_by'] != $this->session->userdata('id')){
						$continue = 0;
					}
				}
				if($continue == 1)
				{
					$stock_count="";$primary_unit['symbol']="";

					#------------loading model
					$this->load->model('designations/Designation_master_model','desig');
					$this->load->model('customers/Customer_type_model','customer_type');
					$this->load->model('areas/Area_model','area');

					#------------checking cst enabled or not
					$cst_status = $this->sales->get_cst($sales_array[0]['group_id']);
					if($cst_status){
						$sales_cst = $cst_status;
					}

					#------------customer type and customer details
					$user_types = $users = array();$desig_id = $user = "";
					if($this->branch_status){
						$customerTypes = $this->desig->listing(array('department_id'=>0,'utype_status >'=>1));

						#------------customer details
						if($sales_array[0]['customer_type_id'] == 1){
							$this->load->model('branches/Branch_model','branches');
							$customers = $this->branches->listing(array('id !='=>$this->session->userdata('under_id')));
						}
						else if($sales_array[0]['customer_type_id'] ==2){
							$this->load->model('customers/Customer_master_model','customer_master');
							$customers = $this->customer_master->listing(array('conditions'=>array('branch_id'=>$this->session->userdata('under_id'))));

							#------------usertype details
							$user_types = $this->desig->listing(array('utype_status' => 1));
							if($sales_array[0]['user_id'] > 0)
							{
								$user = $sales_array[0]['user_id'];
								$desig_id = $this->dms->get_desig($sales_array[0]['user_id']);

								#------------user details
								$users = $this->dms->get_users(array('conditions' => array('designation_id' => $desig_id,'branch_id' => $this->session->userdata('under_id'))));
							}
						}
						else{
							$this->load->model('retailers/Counter_model','retailer_master');
							$customers = $this->retailer_master->listing(array('company_id'=>$this->session->userdata('company_id')));
						}
					}
					else{
						$customerTypes = $this->desig->listing(array('id' => 2));
						$this->load->model('customers/Customer_master_model','customer_master');
						$customers = $this->customer_master->listing(array('conditions'=>array('branch_id'=>$this->session->userdata('under_id'))));

						#------------usertype details
						$user_types = $this->desig->listing(array('utype_status' => 1));
						if($sales_array[0]['user_id'] > 0)
						{
							$user = $sales_array[0]['user_id'];
							$desig_id = $this->dms->get_desig($sales_array[0]['user_id']);

							#------------user details
							$users = $this->dms->get_users(array('conditions' => array('designation_id' => $desig_id,'branch_id' => $this->session->userdata('under_id'))));
						}
					}

					#------------pricelist details
					$pricelists = $this->customer_type->listing();

					#------------area details
					$areas = $this->area->listing();

					#------------item details / unit details / godown details
					$units = array();$goDowns = array();
					$units[''] = "Select";
					$args['select'] = array('id','item_code','item_name');
					$items = $this->stock->get_stock_items($args);
					if(empty($items)){
						$this->message->set($this->lang->line('no-items-found'),'i');
					}
					if($this->input->post('item_id',true)){
						$itemID = $this->input->post('item_id',true);
						$goDowns = $this->stock->get_item_godowns(array('item_id'=>$itemID,'listing'=>1));
						$units = $this->stock->get_units($itemID);
					}

					#------------stock count of this item
					if($this->input->post('item_id',true) && $this->input->post('godown_id',true) && $sales_array[0]['bill_date'] != ""){
						$stock_count = $this->stock->get_stock_count($this->input->post('godown_id',true),$this->input->post('item_id',true),$sales_array[0]['bill_date']);
						$primary_unit = $this->stock->get_primary_unit($this->input->post('item_id',true));
					}

					$voucher_type = $this->vouchers->voucher_name($sales_array[0]['vtype_id']);
					$customer_name = $this->stock->get_customer($sales_array[0]['customer_type_id'],$sales_array[0]['customer_id']);

					$areas[''] = 'Select';ksort($areas);
					$customers[''] = "Select";ksort($customers);
					$user_types[''] = "Select";ksort($user_types);
					$pricelists[''] = 'Select';ksort($pricelists);
					$items[''] = 'Select';ksort($items);
					$goDowns[''] = 'Select';ksort($goDowns);
					$users[''] = 'Select';ksort($users);
					#----------template

					$this->template->title("Edit Delivery Note");
					$this->template->main_heading($this->lang->line("edit")." ".$this->lang->line("$voucher_name"));
					$this->template->breadcrumb(array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line("$voucher_name") => 'delivery_note/add',$this->lang->line('report') => 'delivery_note/report',$this->lang->line("update") => 'no_link',$this->lang->line("go-back") => array($redirect_uri)));
					$this->template->slice('dms/message');
					$this->template->slice('sales/delivery_note/edit',array('sales_array' => $sales_array,'presumptive_tax' => $presumptive_tax,'sales_cst' => $sales_cst,'voucher_type' => $voucher_type,'customer_name' => $customer_name,'desig_id' => $desig_id,'user' => $user,'price_list_id' => $sales_array[0]['pricelist_id'],'area_id' => $sales_array[0]['area_id'],'voucher_name' => $voucher_name,'customerTypes' => $customerTypes,'customers' => $customers,'user_types' => $user_types,'users' => $users,'pricelists' => $pricelists,'areas' => $areas,'items' => $items,'goDowns' => $goDowns,'units' => $units,'stock_count' => $stock_count,'primary_unit' => $primary_unit['symbol'],'redirect' => $redirect));
					$this->template->other_script('sales/sales_order');
					$this->template->render();
				}
				else
				{
					redirect('users/logout');
				}
			}
			else
			{
				redirect('users/logout');
			}

		}
		else
		{
			redirect('users/logout');
		}
	}

	public function delete()
	{
		#----------delivery primary key
		$uri_array = $this->uri->uri_to_assoc(3);
		if(isset($uri_array['id']))
		{
			$id = $uri_array['id'];
			unset($uri_array['id']);

			#----------redirect uri
			$redirect_uri = "delivery_note/report/".$this->uri->assoc_to_uri($uri_array);

			$result = $this->sales->get_sales(array('columns' => array('a.group_id','a.status','a.created_by','b.id'),'conditions' => array('a.id' => $id)));
			if(!empty($result))
			{
				$row = $result[0];$continue = 1;
				if($row['status'] == -1){
					if($row['created_by'] != $this->session->userdata('id')){
						$continue = 0;
					}
				}
				if($continue == 1)
				{
					if($this->sales->update_others(array('table' => 'dms_delivery_notes','data' => array('status' => 0),'conditions' => array('id' => $id))))
					{
						#-------------deleting sales_items
						$this->sales->update_others(array('table' => 'dms_sales_items','data' => array('status' => 0),'conditions' => array('group_id' => $row['group_id'])));
						foreach($result as $key => $value)
						{
							#-------------deleting stock bal. from dms_stocks
							$this->sales->update_others(array('table' => 'dms_stocks','data' => array('status' => 0),'conditions' => array('table_id' => $value['id'],'stock_status' => 5)));
						}

						$this->message->set($this->lang->line('delivery-delete-success'));
					}
					else
					{
						$this->message->set($this->lang->line('delivery-delete-error'),'e');
					}
				}
				else
				{
					redirect('users/logout');
				}
			}
			redirect($redirect_uri);
		}
		redirect('users/logout');
	}

	#------------------------------------------------------------------------------------------------

	public function pdf(){

		$pdf_name = 'delivery note';
		$pdf_contents = '';
		if(!$this->uri->segment(4)){
			echo "<script>alert('".$this->lang->line('invalid-delivery-note')."');window.close();</script>";
		}
		$sales_id = $this->uri->segment(4);
		if($this->if_exists('dms_delivery_notes',array('id'=>$sales_id,'status'=>1)) === false){
			echo "<script>alert('".$this->lang->line('invalid-delivery-note')."');window.close();</script>";
		}
		#----------voucher type
		$vtype_id = $this->vtype;

		#----------voucher name
		$voucher_name = $this->vouchers->voucher_name($this->vtype);

		$this->load->model('sales/Sales_vehicle_model','sales_vehicle');
		$this->load->library('My_pdf');
		$this->load->library('Stock');
		$this->load->library('To_words');
		$this->my_pdf->set_header();

		#----------sales data
		$sales_array = $this->sales->get_sales(array('columns' => array('a.vtype_id','a.bill_no','a.bill_date','a.group_id','a.dno','a.customer_type_id','a.customer_id','a.user_id','a.area_id','a.bill_discount_per','a.bill_discount_amt','a.bill_freight','a.other_expense','a.cess','a.narration','a.pricelist_id','a.d_status','a.created_by','a.created_on','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.discount_per','b.discount_amt','b.godown_id','b.vat_amt','b.cst'),'conditions' => array('a.id' => $sales_id,'a.status !=' => 0,'b.status !=' => 0)));

		if(empty($sales_array)){
			echo "<script>alert('".$this->lang->line('invalid-sales-bill')."');window.close();</script>";
		}else{
			#------------loading model
			$this->load->model('customers/Customer_type_model','customer_type');

			#------------presumptive tax checking
			$presumptive_tax = $this->stock->get_tax_type();

			#------------checking cst enabled or not
			$sales_cst = $this->sales->get_cst($sales_array[0]['group_id']);

			$voucher_type = $this->vouchers->voucher_name($sales_array[0]['vtype_id']);
			$customer_name = $this->stock->get_customer($sales_array[0]['customer_type_id'],$sales_array[0]['customer_id']);
			$user_type = $this->dms->get_desig($sales_array[0]['user_id'],1);
			$user = $this->dms->get_user_name($sales_array[0]['user_id']);
			$pricelist = $this->customer_type->get_pricelist($sales_array[0]['pricelist_id']);
			$area_id = $this->dms->get_area($sales_array[0]['area_id']);
			$pdf_file = 'delivery_note_pdf';

			$args = array();
			$args['select'] = array('dsv.id','rm.route_name','vm.vehicle_no','concat(u.fname," ",u.lname) as driver','u.mobile','dsv.km','dsv.remarks','dsv.vehicle_type','dsv.vehicle_no as vehicle_number','dsv.driver_name');
			$args['conditions'] = array('dsv.group_id'=>$sales_array[0]['group_id']);
			$args['join'] = array('route_master as rm'=>'dsv.route_id=rm.id','vehicle_master as vm'=>'dsv.vehicle_id=vm.id','users as u'=>'dsv.driver_id=u.id');
			$sales_vehicles = $this->sales_vehicle->get($args);

			$pdf_contents = $this->load->view('sales/delivery_note/'.$pdf_file,array('sales_array' => $sales_array,'presumptive_tax' => $presumptive_tax,'sales_cst' => $sales_cst,'voucher_type' => $voucher_type,'customer_name' => $customer_name,'user_type' => $user_type['designation_name'],'user' => $user,'pricelist' => $pricelist,'area_id' => $area_id,'vehicle_details'=>$sales_vehicles),true);
		}
		$this->my_pdf->output($pdf_name,$pdf_contents);
	}
}
?>