<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

class Delivery_to_receipt extends MY_Controller{

	var $companyID,$branchID,$createdBY,$fiscal_start_date,$fiscal_end_date;
	public function __construct()
	{
		parent::__construct();

		#$this->check_access_right();
		#---------------- Checking Financial year is enabled / closed-----------------#
		$method_array = array('add');
		fiscal_status($this->uri->segment(2),$method_array,"my_bills/delivery_notes");
		#---------------- Checking Financial year is enabled / closed-----------------#

		$this->companyID = $this->session->userdata('company_id');
		$this->branchID = $this->session->userdata('under_id');
		$this->createdBY = $this->session->userdata('id');
		$fiscals = $this->dms->get_fiscal_year();
		$this->fiscal_start_date = $fiscals['start_date'];
		$this->fiscal_end_date = $fiscals['end_date'];

		$this->load->model('purchase/Receipt_note_model','receipt');
		$this->load->model('vouchers/Voucher_model','vouchers');
		$this->load->library(array('Stock'));

		#----------voucher type
		$this->vtype = 9;

	}

	public function add()
	{
		#----------voucher type
		$vtype_id = $this->vtype;

		$this->template->title($this->lang->line('receipt-note'));
		$this->template->main_heading($this->lang->line('receipt-note'));
		$this->template->breadcrumb(array($this->lang->line('receipt-note') => 'no_link',$this->lang->line('report') => 'receipt_note/report'));

		#----------voucher type array
		$voucher_types = $this->vouchers->voucher_types($this->vtype);
		$bill_prefix = $this->stock->get_voucher_prefix($this->vtype);
		#----------voucher name
		$voucher_name = $this->vouchers->voucher_name($this->vtype);

		#-----------purchase cst checking details
		$purchase_cst = $this->stock->get_constant(array('purchase_cst'));

		#------------presumptive tax checking
		$presumptive_tax = $this->stock->get_tax_type();

		#------------cess %
		$cess = $this->stock->get_cess();

		#-----------receipt date and next bill no
		$result_array = $this->receipt->next_bill_no($this->vtype);
		$vtype_id = $result_array['vtype_id'];
		$voucher_no = $result_array['bill_no'];
		$voucher_date = $result_array['bill_date'];
		$units = $items = $goDowns = $receipt_temp_data = array();
		$vendors = $this->stock->get_vendors();
		$payment_modes = $this->stock->payment_modes();
		$args=array();
		$args['select'] = array('id','item_code','item_name');
		$items = $this->stock->get_stock_items($args);
		$goDowns = $this->stock->get_godowns(array('conditions'=>array('branch_id'=>$this->branchID),'listing'=>1));
		$goDowns[''] = 'Select';
		ksort($goDowns);
		if(empty($items)){
			$this->message->set($this->lang->line('no-items-found'),'i');
		}

		$args = array();
		$args['columns'] = array('a.group_id','a.pid','a.vendor_id','a.invoice_no','a.invoice_date','a.bill_discount_per','a.bill_discount_amt','a.bill_freight','a.other_expense','a.cess','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.discount_per','b.discount_amt','b.godown_id','b.vat_amt','b.cst');
		$args['conditions'] = array('a.created_by' =>$this->createdBY,'vtype_id' =>$vtype_id,'a.status =' => -1,'b.status =' => -1);
		$receipt_temp_data = $this->receipt->get_purchases($args);

		if(!empty($receipt_temp_data)){

			$vendor_id = $receipt_temp_data[0]['vendor_id'];
			$invoice_no = $receipt_temp_data[0]['invoice_no'];
			$invoice_date = $receipt_temp_data[0]['invoice_date'];
			$group_id = $receipt_temp_data[0]['group_id'];

		}else{
			$this->message->set($this->lang->line('invalid-delivery-note'),'e');
			redirect('my_bills/delivery_notes');
		}

		#------------saving purchase voucher
		if(isset($_POST['btn_save'])){
			$this->form_validation->set_rules('bill_date','lang:bill-date','required|xss_clean|valid_date|is_date|check_date['.date('Y-m-d').'.<=]');
			$this->form_validation->set_rules('bill_no','lang:bill-no',"required|xss_clean|is_natural_no_zero|callback_bill_no_exists[$vtype_id.$group_id");
			foreach($receipt_temp_data as $key=>$rItem){
				$this->form_validation->set_rules('godown_id_'.$rItem['id'],'lang:godown','required|xss_clean');
			}

			$this->form_validation->set_rules('freight','lang:freight','xss_clean|greater_or_equal[0]');
			$this->form_validation->set_rules('other_expense','lang:other-expense','xss_clean|greater_or_equal[0]');
			$this->form_validation->set_rules('remarks','lang:remarks','xss_clean');

			if($this->form_validation->run('btn_save') === true){

				$bill_num = $this->input->post('bill_no');
				$bill_date = date('Y-m-d',strtotime($this->input->post('bill_date')));
				$bill_freight = $this->input->post('freight');
				$bill_other_exp = $this->input->post('other_expense');
				$narration = $this->input->post('remarks');
				$this->db->trans_start();
				$saveReceipt = array();
				$saveReceipt['table'] = 'dms_receipt_notes';
				$saveReceipt['data'] = array('bill_no'=>$bill_num,'bill_date'=>$bill_date,'bill_freight'=>$bill_freight,'other_expense'=>$bill_other_exp,'narration'=>$narration,'status'=>1);
				$saveReceipt['conditions'] = array('created_by'=>$this->createdBY,'group_id'=>$group_id,'status ='=>-1);
				if($this->receipt->update_others($saveReceipt)){

					foreach($receipt_temp_data as $key=>$rItem){

						$pItemID = $rItem['id'];
						$godown_id = $this->input->post('godown_id_'.$pItemID);
						$itemID = $rItem['item_id'];
						$qty = $rItem['qty'];
						$rate = $rItem['rate'];
						$unitID = $rItem['unit_id'];
						$dnoteID = $rItem['pid'];
						$saveReceiptItems = array();
						$saveReceiptItems['table'] = 'dms_purchase_items';
						$saveReceiptItems['data'] = array('godown_id'=>$godown_id,'status'=>1);
						$saveReceiptItems['conditions'] = array('id'=>$pItemID,'status'=>-1);

						if($this->receipt->update_others($saveReceiptItems)){

							$convertedStock = $this->stock->unit_conversion($itemID,$unitID,$qty,$rate);
							if(!empty($convertedStock)){

								$this->receipt->insert('dms_stocks',array('company_id'=>$this->companyID,'branch_id' => $this->session->userdata('under_id'),'godown_id' =>$godown_id,'item_id' =>$itemID,'qty' => $convertedStock['qty'],'unit_id' => $convertedStock['primary_unit'],'rate' => $convertedStock['rate'],'stock_date' =>$bill_date,'stock_status' =>1,'table_group_id' => $group_id,'table_id' => $pItemID,'status' =>1));
							}
						}
				}
				$this->db->update('dms_delivery_notes',array('bill_status'=>2),array('id'=>$dnoteID));
				$this->db->trans_complete();
				$this->message->set($this->lang->line('receipt-save-success'));
				redirect('my_bills/delivery_notes');
			}
			}
		}
		$this->template->slice('dms/message');
		$this->template->slice('sales/receipt_note/delivery_to_receipt',array('voucher_types' => $voucher_types,'voucher_type' => $vtype_id,'voucher_no' => $voucher_no,'voucher_date' => $voucher_date,'voucher_no' => $voucher_no,'voucher_date' => $voucher_date,'vendors' => $vendors,'vendor_id' => $vendor_id,'invoice_no' => $invoice_no,'invoice_date' => $invoice_date,'purchase_cst' => $purchase_cst,'presumptive_tax' => $presumptive_tax,'purchase_temp_data' => $receipt_temp_data,'godowns'=>$goDowns,'bill_prefix'=>$bill_prefix));
		$this->template->other_script('purchase/sales_to_purchase');
		$this->template->render();
	}

	#--------------------------------------------------------------------------

	public function bill_no_exists($bill_no,$v_details = NULL)
	{
		if($v_details == NULL){
			$where = array('vtype_id' => $this->input->post('vtype_id',true),'bill_no' => $bill_no,'status !=' => 0);
		}
		else{
			$exp = explode('.', $v_details);
			$where = array('vtype_id' => $exp[0],'bill_no' => $bill_no,'group_id !=' => $exp[1],'status !=' => 0);
		}
		$row = $this->purchase->get_bills(array('columns' => array('id'),'conditions' => $where,'numrows' => true));
		if($row == 0){
			return true;
		}
		return false;
	}

	#--------------------------------------------------------------------------
}
?>