<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

class Delivery_to_sales extends MY_Controller{

	public function __construct()
	{
		parent::__construct();

		$this->check_access_right();
		$this->companyID = $this->session->userdata('company_id');
		#---------------- Checking Financial year is enabled / closed-----------------#
		$method_array = array('sales');
		fiscal_status($this->uri->segment(2),$method_array,"delivery_note/report");
		#---------------- Checking Financial year is enabled / closed-----------------#

		$this->load->model('sales/Delivery_note_model','delivery');
		$this->load->model('vouchers/Voucher_model','vouchers');
		$this->load->library(array('Stock','Targets','Sales_lib'));

		#----------voucher type
		$this->vtype = 6;
	}

	public function sales()
	{
		#----------delivery primary key
		if($this->uri->segment(4))
		{
			$delivery_id = $this->uri->segment(4);

			#----------delivery note data
			$delivery_array = $this->delivery->get_sales(array('columns' => array('a.id','a.branch_id','a.bill_date','a.group_id','a.customer_type_id','a.customer_id','a.user_id','a.area_id','a.bill_discount_per','a.bill_discount_amt','a.bill_freight','a.other_expense','a.cess','a.pricelist_id','a.narration','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.discount_per','b.discount_amt','b.godown_id','b.vat_amt','b.cst'),'conditions' => array('a.id' => $delivery_id,'a.d_status' => 0,'b.item_status >' => 0,'b.status !=' => 0)));
                        if(empty($delivery_array))
                        {
                               $delivery_array = $this->delivery->get_sales_gst(array('columns' => array('a.id','a.branch_id','a.bill_date','a.group_id','a.customer_type_id','a.customer_id','a.user_id','a.area_id','a.bill_discount_per','a.bill_discount_amt','a.bill_freight','a.other_expense','a.cess','a.pricelist_id','a.narration','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.discount_per','b.discount_amt','b.godown_id','b.cgst_amt','b.sgst_amt'),'conditions' => array('a.id' => $delivery_id,'a.d_status' => 0,'b.item_status >' => 0,'b.status !=' => 0))); 
                        }
			if(!empty($delivery_array))
			{
				$group_id = $delivery_array[0]['group_id'];

				#----------checking group_id exists for redirection
				$redirection_uri = $this->sales_lib->ds_group_id_exists($group_id);
				if($redirection_uri)
				{
					redirect($redirection_uri);
				}
				else
				{
					#----------bill details
					$bill_details = $delivery_array[0];

					#----------loading models
					$this->load->model('designations/Designation_master_model','desig');
					$this->load->model('customers/Customer_type_model','customer_type');

					#----------voucher type array
					$voucher_types = $this->vouchers->voucher_types($this->vtype);
					$bill_prefix = $this->stock->get_voucher_prefix($this->vtype);
					#----------voucher name
					$voucher_name = $this->vouchers->voucher_name($this->vtype);

					#----------next bill no
					$voucher_no = $this->delivery->next_bill($this->vtype);

					#-----------validation
					$this->form_validation->set_rules('vtype_id','lang:voucher-types','required|xss_clean');
					$this->form_validation->set_rules('bill_no','lang:bill-no',"required|xss_clean|is_natural_no_zero|callback_bill_no_exists");
					$this->form_validation->set_rules('bill_date','lang:bill-date',"required|xss_clean|valid_date|check_date[$bill_details[bill_date].>=]");
					$this->form_validation->set_rules('payment_mode','lang:payment-mode','required|xss_clean');
					if($this->input->post('payment_mode',true) == 2){
						$this->form_validation->set_rules('credit_period','lang:credit-period','required|xss_clean|is_natural');
					}elseif($this->input->post('bill_date',true) && $this->input->post('payment_mode',true) > 2){
						$bill_date1 = date('Y-m-d',strtotime($this->input->post('bill_date',true)));
						$this->form_validation->set_rules('ccd','lang:cash-cheque-dd','required|xss_clean');
						$this->form_validation->set_rules('cd_no','lang:cd-no','required|xss_clean|max_length[64]');
						$this->form_validation->set_rules('cheque_date','lang:cheque-date',"required|xss_clean|is_date|check_date[$bill_date1.>=]");
					}
					$this->form_validation->set_rules('remarks','lang:remarks','xss_clean');
					$this->form_validation->set_rules('freight','lang:freight','xss_clean|greater_or_equal[0]|less_than[100000000]');
					$this->form_validation->set_rules('other_expense','lang:other-expense','xss_clean|greater_or_equal[0]|less_than[100000000]');
					$this->form_validation->set_rules('bill_discount_per','lang:discount %','xss_clean|greater_or_equal[0]|less_or_equal[100]');
					$this->form_validation->set_rules('bill_discount_amt','lang:discount','xss_clean|greater_or_equal[0]|less_than[100000000]');

					#-----------saving data
					if($this->form_validation->run() === true)
					{
						$vtype_id = $this->input->post('vtype_id',true);
						$bill_no = $this->input->post('bill_no',true);
						$bill_date = date('Y-m-d',strtotime($this->input->post('bill_date',true)));
						$payment_mode = $this->input->post('payment_mode',true);
						$narration = $this->input->post('remarks',true);
						$bill_discount_amt = $this->input->post('bill_discount_amt',true);
						$freight = $this->input->post('freight',true);
						$other_expense = $this->input->post('other_expense',true);
						$sales_array = array('vtype_id' => $vtype_id,'branch_id' => $bill_details['branch_id'],'bill_no' => $bill_no,'bill_date' => $bill_date,'group_id' => $bill_details['group_id'],'sid' => $bill_details['id'],'s_status' => 3,'customer_type_id' => $bill_details['customer_type_id'],'customer_id' => $bill_details['customer_id'],'user_id' => $bill_details['user_id'],'area_id' => $bill_details['area_id'],'bill_discount_per' => $this->input->post('bill_discount_per',true),'bill_discount_amt' => $bill_discount_amt,'bill_freight' => $freight,'other_expense' => $other_expense,'cess' => $bill_details['cess'],'narration' => $narration,'pricelist_id' => $bill_details['pricelist_id'],'payment_mode' => $payment_mode,'cr_period' => $this->input->post('credit_period',true),'status' => 1);

						#----------start transaction
						$this->db->trans_start();

						if($this->delivery->insert('dms_sales',$sales_array)){
							$this->delivery->update_others(array('table' => 'dms_delivery_notes','data' => array('d_status' => 1),'conditions' => array('id' => $bill_details['id'])));

							#--------------checking for user points
							$user_points = 0;$user_type = "";
							if($bill_details['customer_type_id'] == 2)//customer
							{
								$user_id = $bill_details['user_id'];
								$designation_id = $this->dms->get_desig($user_id);
								if($designation_id == 4){
									$user_type = $designation_id;#"c";
								}elseif($designation_id == 5){
									$user_type = $designation_id;#"m";
								}elseif($designation_id == 6){
									$user_type = $designation_id;#"e";
								}
								$customer = $this->dms->get_data(array('table' => 'customer_master','columns' => 'ledger_id','conditions' => array('id' => $bill_details['customer_id'])));
							}
							else//branch or AR
							{
								$designation_id = $bill_details['customer_type_id'];
								$user_id = $bill_details['customer_id'];
								if($designation_id == 3)
								{
									$customer = $this->dms->get_data(array('table' => 'retailer_master','columns' => 'ledger_id','conditions' => array('id' => $bill_details['customer_id'])));
								}
								else
								{
									$customer = $this->dms->get_data(array('table' => 'branch_master','columns' => 'ledger_id','conditions' => array('id' => $bill_details['customer_id'])));
								}
							}

							#-------------adding bill to dms_vouchers
							$voucher_status = 1;
							$voucher_amount = $this->input->post('grand_total',true);
							$round_off_amount = $this->input->post('round_off_amount',true);
							$vat_amount = $this->input->post('vat_total',true);
							$cess_amount = $this->input->post('cess_total',true);
							if($payment_mode > 2)
							{
								$bill_date_time = strtotime($bill_date);
								$cheque_date = date('Y-m-d',strtotime($this->input->post('cheque_date',true)));
								$cheque_date_time = strtotime($cheque_date);
								if($this->input->post('ccd',true) == 1 && $cheque_date_time > $bill_date_time)
								{
									$voucher_status = 3;
								}
							}elseif($payment_mode == 2){
								$payment_mode = $customer[0]['ledger_id'];//customer
							}
							$voucher_group_id = $this->stock->get_group_id('dms_vouchers');
							$voucher_amount -= $bill_discount_amt;
							$voucher_amount += $round_off_amount;
							$voucher_array = array('company_id' => $this->session->userdata('company_id'),'branch_id' => $this->session->userdata('under_id'),'group_id' => $voucher_group_id,'vtype_id' => $vtype_id,'vno' => $bill_no,'vorder_no' => 1,'vdate' => $bill_date,'dr_ledger' => $payment_mode,'cr_ledger' => 4,'vamount' => $voucher_amount,'narration' => $narration,'table_name' => 'dms_sales','table_group_id' => $bill_details['group_id'],'status' => $voucher_status);
							$voucher_data = $this->dms->get_data(array('table' =>'dms_vouchers','columns' => 'id','conditions' => array('table_name' => 'dms_sales','table_group_id' => $bill_details['group_id']),'numrows' => true));
							if($voucher_data == 0)
							{
								$voucher_success = $this->delivery->insert('dms_vouchers',$voucher_array);
								if($voucher_success)
								{
									#-----------VAT
									$voucher_array['cr_ledger'] = 12;
									$voucher_array['vorder_no'] = 2;
									$voucher_array['vamount'] = $vat_amount;
									$this->delivery->insert('dms_vouchers',$voucher_array);
									#-----------CESS
									$voucher_array['cr_ledger'] = 15;
									$voucher_array['vorder_no'] = 3;
									$voucher_array['vamount'] = $cess_amount;
									$this->delivery->insert('dms_vouchers',$voucher_array);
									#-----------Freight
									$voucher_array['dr_ledger'] = 13;
									$voucher_array['cr_ledger'] = $payment_mode;
									$voucher_array['vorder_no'] = 4;
									$voucher_array['vamount'] = $freight;
									$this->delivery->insert('dms_vouchers',$voucher_array);
									#-----------Other Expense
									$voucher_array['dr_ledger'] = 14;
									$voucher_array['vorder_no'] = 5;
									$voucher_array['vamount'] = $other_expense;
									$this->delivery->insert('dms_vouchers',$voucher_array);

									if($payment_mode > 2)
									{
										$this->delivery->insert('dms_voucher_banks',array('group_id' => $voucher_group_id,'cash_type' => $this->input->post('ccd',true),'cd_no' => $this->input->post('cd_no',true),'pdc' => $cheque_date,'vdate' => $bill_date));
									}
								}
							}

							#--------------calculating user points
							if(!empty($user_type))
							{
								foreach($delivery_array as $key => $value)
								{
									if(!empty($user_id))
									{
										$user_points += $this->targets->get_bill_points($designation_id,$user_id,$value['item_id'],$value['unit_id'],$value['qty'],$value['rate'],$bill_date);
									}
								}
								if($user_points > 0)
								{
									$target_id = $this->targets->get_targets(array('columns' => 'a.id','conditions' => array('a.designation_id' => $designation_id,'a.user_id' => $user_id,'a.status' => 1),'bill_date' => $bill_date));
									if($target_id)
									{
										$this->sales->insert('user_points',array('designation_id' => $designation_id,'user_id' => $user_id,'targets_id' => $target_id['id'],'group_id' => $bill_details['group_id'],'sms_point' => $user_points,'actual_point' => $user_points));
									}
								}
								$user_data = $this->dms->get_data(array('table' =>'users','columns' => 'mobile','conditions' => array('id' => $user_id)));
								if(!empty($user_data)){
									$user_type_mobile=$user_data[0]['mobile'];
									$this->sales_obj->insert('dms_sms',array('company_id' =>$this->companyID,'bill_ref_no' => $bill_details['group_id'],'user_type'=>$user_type,'user_id'=>$user_id,'status'=>3));
								}
					
							}
							$this->message->set($this->lang->line('sales-save-success'));
						}
						else{
							$this->message->set($this->lang->line('sales-save-error'),'e');
						}

						#----------transaction completed
						$this->db->trans_complete();

						redirect('sales/report');
					}

					#------------loading model
					$this->load->model('customers/Customer_type_model','customer_type');

					#------------presumptive tax checking
					$presumptive_tax = $this->stock->get_tax_type();

					#------------checking cst enabled or not
					$sales_cst = $this->delivery->get_cst($bill_details['group_id']);

					$voucher_type = $this->vouchers->voucher_name($this->vtype);
					$customer_name = $this->stock->get_customer($bill_details['customer_type_id'],$bill_details['customer_id']);
					$utype = $this->dms->get_desig($bill_details['user_id'],1);
					$user = $this->dms->get_user_name($bill_details['user_id']);
					$pricelist = $this->customer_type->get_pricelist($bill_details['pricelist_id']);
					$area_id = $this->dms->get_area($bill_details['area_id']);

					#------------payment modes
					$payment_modes = $this->stock->payment_modes();

					#------------cheque / dd details
					$cd_status = 1;
					if($this->input->post('payment_mode',true) > 2){
						$cd_status = 0;
					}

					#------------template
					$this->template->title("New $voucher_name Voucher");
					$this->template->main_heading($this->lang->line("$voucher_name"));
					$this->template->breadcrumb(array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line("$voucher_name") => 'no_link'));
					$this->template->slice('dms/message');
					$this->template->slice('sales/delivery_note/sales',array('sales_array' => $delivery_array,'presumptive_tax' => $presumptive_tax,'sales_cst' => $sales_cst,'voucher_name' => $voucher_name,'voucher_types' => $voucher_types,'voucher_type' => $voucher_type,'voucher_no' => $voucher_no,'customer_name' => $customer_name,'user_type' => $utype['designation_name'],'user' => $user,'pricelist' => $pricelist,'area_id' => $area_id,'payment_modes' => $payment_modes,'cd_status' => $cd_status,'bill_prefix'=>$bill_prefix));
					$this->template->other_script('sales/sales_order');
					$this->template->render();
				}
			}
			else{
				redirect('users/logout');
			}
		}
		else{
			redirect('users/logout');
		}
	}

	public function bill_no_exists($bill_no)
	{
		$this->load->model('sales/Sales_model','sales');
		$vtype_id = $this->input->post('vtype_id',true);
		$row = $this->sales->get_bills(array('columns' => array('id'),'conditions' => array('vtype_id' => $vtype_id,'bill_no' => $bill_no,'status !=' => 0),'numrows' => true));
		if($row == 0){
			return true;
		}
		return false;
	}
}
?>