<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
	
	class Designations extends MY_Controller{

		public function __construct(){

			parent :: __construct();
			$this->check_access_right();
			$this->load->model('designations/Designation_master_model','desg');
			#---------------- Checking Financial year is enabled / closed-----------------#
			$method_array = array('manage','update','delete');
			fiscal_status($this->uri->segment(2),$method_array,"designations/report");	
			#---------------- Checking Financial year is enabled / closed-----------------#	
			
		}
		
		#--------------------------------------------------------
		
		public function manage(){

			$this->template->title($this->lang->line('designations'));
			$this->template->main_heading($this->lang->line('designations'));
			$this->template->breadcrumb(array($this->lang->line('settings')=>'preferences/',$this->lang->line('designations')=>'no_link',$this->lang->line('report')=>'designations/report'));

			#form_validation
			$this->form_validation->set_rules('designation_name','designation name','trim|xss_clean|required|callback_does_exist');
			$this->form_validation->set_rules('department_id','department name','trim|xss_clean|required');

			if($this->form_validation->run() === true){

				$data = $this->input->post(NULL,true);
				$data['company_id'] = $this->session->userdata('company_id');
				if($this->desg->f_save('designation_master',$data)){
					$this->message->set($this->lang->line('desg_save'),'s');
				}else{
					$this->message->set($this->lang->line('desg_save_err'),'e');
				}
				redirect('designations/report');
			}

			#get all departments
			$this->load->model('departments/Department_master_model','dept');
			$depts = $this->dept->listing();
			$depts[''] = 'select a department';
			ksort($depts);

			#dummy designation
			$this->load->model('designations/Designation_master_model','desg');
			$desgs = $this->desg->listing(array('department_id >'=>0));
			$desgs['-2'] = 'None';
			ksort($desgs);

			$this->template->slice('dms/message');
			$this->template->slice('preferences/designations/new',array('depts'=>$depts,'desgs'=>$desgs));
			$this->template->render();
		}

		#--------------------------------------------------------
		#use :  callback validation for designation
		public function does_exist($designation_name,$desig_id=NULL){
			$department_id = $this->input->post('department_id');
			if(!empty($desig_id)){
				$conditions['designation_master.id !=']=$desig_id;
			}
			$conditions['designation_master.designation_name']=$designation_name;
			$conditions['designation_master.status'] = 1;
			$this->db->select(array('designation_master.*'));
			$this->db->from('designation_master');
			$this->db->join('department_master','designation_master.department_id=department_master.id'." OR designation_master.department_id= '0'");
			foreach($conditions as $key=>$value){
				$this->db->where($key,$value);
			}
			$this->db->where(" (department_master.company_id='".$this->session->userdata('company_id')."' OR department_master.company_id='0')");
			$this->db->where(" (designation_master.department_id='".$department_id."' OR designation_master.department_id='0')");
			$row=$this->db->get()->result_array();
			if(!empty($row)){
				$this->form_validation->set_message('does_exist',$this->lang->line('designation-already-exists'));
				return FALSE;
			}else{
				return TRUE;
			}		
		}

		#--------------------------------------------------------	

		public function report(){

			#$this->load->model('designations/Designation_master_model','desg');
			$this->load->model('departments/Department_master_model','dept');
			$this->load->library('Pagination');
   	 		$config['total_rows'] = $this->desg->get_all1(array('numrows'=>TRUE));
   	 		$config['base_url'] = base_url('designations/report');
   	 		$config['per_page'] = $this->per_page();
   	 		$config['uri_segment'] = 3;
			# Pagination Config Customizations
			$config['full_tag_open'] = '<ul class="pagination">';
			$config['full_tag_close'] = '</ul>';
			$config['first_link'] = 'First';
			$config['last_link'] = 'Last';
			$config['next_link'] = '&raquo;';
			$config['prev_link'] = '&laquo;';
			$config['cur_tag_open'] = '<li class="active"><a href="#">';
			$config['cur_tag_close'] = '</a></li>';
			$config['num_tag_open'] = '<li>';
			$config['num_tag_close'] = '</li>';
   	 		$this->pagination->initialize($config);
   	 		$links = $this->pagination->create_links();
   	 		$offset = $this->uri->segment($config['uri_segment'],0);

   	 		$desgs = $this->desg->get_all1(array('order_by'=>'created_on','order'=>'DESC','limit'=>$config['per_page'],'offset'=>$offset));
			if(empty($desgs)){
				$this->message->set($this->lang->line('no-designations-found'),'i');
			}

			$this->template->title($this->lang->line('desig-report'));
			$this->template->main_heading($this->lang->line('designations'));
			$this->template->breadcrumb(array($this->lang->line('settings')=>'preferences/',$this->lang->line('designations')=>'designations/manage',$this->lang->line('report')=>'no_link'));
			$this->template->slice('dms/message');
			$this->template->slice('preferences/designations/report',array('desgs'=>$desgs,'links'=>$links,'offset'=>$offset));
			$this->template->slice('dms/modals/delete_confirm');
			$this->template->render();
		}

	#--------------------------------------------------------	
		public function update($id){

			if(empty($id) && !$this->input->post()){
				redirect('users/home');
			}
			$id = $this->uri->segment(3);
			#get details of id
			$desig= $this->db->get_where('designation_master',array('id'=>$id))->row_array();
			if(empty($desig)){
				redirect('designations/report');
			}
			if($id == 7 || $desig['department_id'] == 0){
				$this->message->set($this->lang->line('def-data-not-changed'),'i');
				redirect('designations/report');
			}
				
			#form_validation
			$this->form_validation->set_rules('designation_name','designation name',"trim|xss_clean|required|callback_does_exist[$id]");
			$this->form_validation->set_rules('department_id','department name','trim|xss_clean|required');

			if($this->form_validation->run('designations/manage') === true){

				$data = $this->input->post(NULL,true);
				if($data['parent_id'] == 0){
					$data['parent_id'] = -2;
				}

				if($this->desg->my_update('designation_master',$data,array('id'=>$id))){
					$this->message->set($this->lang->line('desg-update'),'s');
				}else{
					$this->message->set($this->lang->line('desg-update-err'),'e');
				}
				redirect('designations/report');
			}

			#get all departments
			$this->load->model('departments/Department_master_model','dept');
			$depts = $this->dept->listing();
			$depts[''] = 'select a department';
			
			$this->load->model('designations/Designation_master_model','desg');
			$desgs = $this->desg->listing(array('department_id'=>$desig['department_id']));
			$desgs[-2] = 'None';

			$this->template->title($this->lang->line('desig-edit'));
			$this->template->main_heading($this->lang->line('desig-edit'));
			$this->template->breadcrumb(array($this->lang->line('settings')=>'preferences/',$this->lang->line('designations')=>'designations/manage',$this->lang->line('update')=>'no_link',$this->lang->line('report')=>'designations/report'));
			$this->template->slice('preferences/designations/update',array('depts'=>$depts,'desgs'=>$desgs,'desig'=>$desig));
			$this->template->render();
		}

		#--------------------------------------------------------

		public function delete($id){
			if(empty($id)){
				redirect('users/home');
			}
			$id = $this->uri->segment(3);
			if($this->if_exists('designation_master',array('id'=>$id,'status'=>1)) === false){
				redirect('designations/report');
			}
			$desig= $this->db->get_where('designation_master',array('id'=>$id))->row_array();
			if($id != 7 && $desig['department_id'] != 0){
				
				$total_desig_leaves = $this->db->select('id')->get_where('designation_leave_types',array('designation'=>$id,'status'=>1))->num_rows();
				$total_users = $this->db->select('id')->get_where('users',array('designation_id'=>$id,'status'=>1))->num_rows();
				
				if(empty($total_desig_leaves) && empty($total_users)){

					if($this->db->update('designation_master',array('status'=>0),array('id'=>$id))){
						$this->message->set($this->lang->line('desg-deleted'));
					}else{
						$this->message->set($this->lang->line('desg-not-deleted'));
					}
				}else{
					$this->message->set($this->lang->line('can-not-delete-desig'),'i');
				}
			}else{
				$this->message->set($this->lang->line('def-data-not-changed'),'i');
			}
			redirect('designations/report');
		}	
	#--------------------------------------------------------

	}

?>