<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

	class Engineers extends MY_Controller{

		public function __construct(){

			parent :: __construct();
			$this->load->model('users/Engineer_model','engineer');
			$this->check_access_right();
			#---------------- Checking Financial year is enabled / closed-----------------#
			$method_array = array('add','update','delete','privilege');
			fiscal_status($this->uri->segment(2),$method_array,"engineers/report");	
			#---------------- Checking Financial year is enabled / closed-----------------#
		}

	 	#--------------------------------------------------------
		#date : 23=01-
		public function add(){
			#validation
			if($this->form_validation->run() === true){

				$file_upload_error = true;
				#upload the photo if one is selected.
				if($_FILES['photo']['name'] != ''){

					$ext = pathinfo($_FILES['photo']['name'], PATHINFO_EXTENSION);
					#file name initialization
					$max_id = $this->user->get_max_id();
					$f_part1 = $max_id+1;
					$f_part2 = $f_part1."user".date('YmdHis');
					$fileName = $f_part2.".".$ext;
					#file uploading 
					$config['upload_path'] =  FCPATH.'assets/images/photos/';
					$config['allowed_types'] = 'jpeg|jpg|png';
					$config['max_size']	= '600';
					$config['max_width']  = '2560';
					$config['max_height']  = '1600';
					$config['file_name'] = $fileName;
					$this->load->library('Upload');
					$this->upload->initialize($config);

					if($this->upload->do_upload('photo')){

							$file_upload_error = false;
							$config['image_library'] = 'gd2';
							$config['source_image']	= $config['upload_path'].$fileName;
							$config['create_thumb'] = TRUE;
							$config['maintain_ratio'] = false;
							$config['width']	= 150;
							$config['height']	= 120;

							$this->load->library('Image_lib', $config); 
							$this->image_lib->resize();
							#unlink original file & rename thumb
							unlink($config['upload_path'].$fileName);
							$thumb = $config['upload_path'].$f_part2.'_thumb'.'.'.$ext;
							$original = $config['upload_path'].$fileName;
							rename($thumb,$original);

					}else{
						$file_upload_error = true;
					}

				}else{
					$fileName = $this->input->post('gender').'.jpg'; #dummy image in case no image uploaded
					$file_upload_error = false;
				}

				if($file_upload_error){
					$this->message->set($this->lang->line('invalid-photo'),'e');
				}else{
					#get posted data#
					$data = $this->input->post(NULL,true);
					$data['photo'] = $fileName;
					$data['dob'] =($data['dob'] != '')?date('Y-m-d',strtotime($data['dob'])):'';
					$data['date_of_marriage'] = ($data['date_of_marriage'] != '')?date('Y-m-d',strtotime($data['date_of_marriage'])):'';
					$data['designation_id'] = 6;
					$data['company_id'] = $this->session->userdata('company_id');

					#filtering company data from posted data then uset com[pany data
					$company = $this->input->post('company',TRUE);
					unset($data['company']);
					$data['fiscal_yr_id'] = $this->dms->get_default_fiscal_id();
					if($data['password'] != ''){
						$data['password'] = password_hash($data['password'],PASSWORD_DEFAULT);
					}

					#save engineer data in users
					if($this->engineer->save($data)){
						#getting last iserted id
						$engineer_id =$this->db->insert_id();
						#storing engineer company details#
						$company['engineer_id'] = $engineer_id;
						if($this->engineer->save_company($company)){
							$this->message->set($this->lang->line('engineer-saved'));
						}else{
							$this->message->set($this->lang->line('engineer-not-saved'),'e');
						}
						redirect('engineers/report');
					}
				}
			}

			#get all areas
			$this->load->model('areas/Area_model','area');
			$areas = $this->area->listing();
			$areas[''] = 'Select';ksort($areas);

			#branches listing
			$this->load->model('branches/Branch_model','branch');
			$branches = $this->branch->listing(array('company_id'=>$this->session->userdata('company_id')));
			$branches[''] = 'Select a branch';
			ksort($branches);

			#template
			$this->template->title($this->lang->line('manage-engineers'));
			$this->template->main_heading($this->lang->line('manage-engineers'));
			$this->template->breadcrumb(array($this->lang->line('manage-engineers')=>'no_link',$this->lang->line('report')=>'engineers/report'));
			$this->template->slice('engineers/add/new',array('branches'=>$branches,'areas'=>$areas));
			$this->template->other_script(array('user_add','users/user_name_check','masons/ar_branch_select'));
			$this->template->render();

		}

		#--------------------------------------------------------

		public function report(){

			$this->load->library('Pagination');
			$config['total_rows'] = $this->engineer->get_all('',1);
			if($config['total_rows']==0){
				$this->message->set($this->lang->line('no-engineer'),'e');
			}
			$config['per_page'] = $this->per_page();
			$config['base_url'] = base_url('engineers/report');
			$config['uri_segment'] = 3;
			# Pagination Config Customizations
			$config['full_tag_open'] = '<ul class="pagination">';
			$config['full_tag_close'] = '</ul>';
			$config['first_link'] = 'First';
			$config['last_link'] = 'Last';
			$config['next_link'] = '&raquo;';
			$config['prev_link'] = '&laquo;';
			$config['cur_tag_open'] = '<li class="active"><a href="#">';
			$config['cur_tag_close'] = '</a></li>';
			$config['num_tag_open'] = '<li>';
			$config['num_tag_close'] = '</li>';
			$this->pagination->initialize($config); 
			$offset = ($this->uri->segment(3))?$this->uri->segment(3):0;
			$engineers = $this->engineer->get_all('',0,$offset,$config['per_page']);
			$links = $this->pagination->create_links();
			if(empty($engineers)){
				$this->message->set($this->lang->line('no-results-found'),'i');
			}
			#template
			$this->template->title($this->lang->line('manage-engineers'));
			$this->template->main_heading($this->lang->line('manage-engineers'));
			$this->template->breadcrumb(array($this->lang->line('manage-engineers')=>'engineers/add',$this->lang->line('report')=>'no_link'));
			$this->template->slice('dms/message');
			$this->template->slice('engineers/report',array('engineers'=>$engineers,'links'=>$links,'count'=>$offset));
			$this->template->slice('dms/modals/more_details');
			$this->template->other_script('engineers/engineer_show');
			$this->template->render();
		}

		#--------------------------------------------------------

		public function update($id = FALSE){

			if(!$id || !$this->uri->segment(3)){ redirect('engineers/report');}
			$id = $this->uri->segment(3); 
			if($this->if_exists('users',array('id'=>$id,'status'=>1,'designation_id'=>6)) === false){
				redirect('engineers/report');
			}			
			#get details of id
			$engineer = $this->engineer->get_all(array('users.id'=>$id))[0];
			#get engineer company details
			$company = $this->db->get_where('engineer_companies',array('engineer_id'=>$id,'status'=>1))->row_array();
			$file_upload_error = true; #default settings
				
			if($this->form_validation->run('engineers/update') === true){
				
				$file_upload_error = true; #dummy set
				if($_FILES['photo']['name'] != ''){
						
					$ext = pathinfo($_FILES['photo']['name'], PATHINFO_EXTENSION);
					#file name initialization
					$max_id = $this->user->get_max_id();
					$f_part1 = $max_id+1;
					$f_part2 = $f_part1."user".date('YmdHis');
					$fileName = $f_part2.".".$ext;

					#file uploading 
					$config['upload_path'] =  FCPATH.'assets/images/photos/';
					$config['allowed_types'] = 'jpeg|jpg|png';
					$config['max_size']	= '600';
					$config['max_width']  = '2560';
					$config['max_height']  = '1600';
					$config['file_name'] = $fileName;
					$this->load->library('Upload');
					$this->upload->initialize($config);

					if($this->upload->do_upload('photo')){

						$file_upload_error = TRUE;
						$config['image_library'] = 'gd2';
						$config['source_image']	= $config['upload_path'].$fileName;
						$config['create_thumb'] = TRUE;
						$config['maintain_ratio'] = false;
						$config['width']	= 150;
						$config['height']	= 120;
						$this->load->library('Image_lib', $config); 
						$this->image_lib->resize();

						#unlink original file & rename thumb
						unlink($config['upload_path'].$fileName);
						$thumb = $config['upload_path'].$f_part2.'_thumb'.'.'.$ext;
						$original = $config['upload_path'].$fileName;
						rename($thumb,$original);
					}else{
						$file_upload_error = false;
					}
				}

				if(!$file_upload_error){
					$this->message->set($this->lang->line('invalid-photo'),'e');
				}else{
					$data = $this->input->post(NULL,TRUE);
					if(!empty($fileName)){
						$data['photo'] = $fileName;
						if((strtolower($engineer['photo']) !='male.jpg') && (strtolower($engineer['photo']) != 'female.jpg')){
							unlink(FCPATH.'assets/images/photos/'.$engineer['photo']);
						}
					}
						
					$data['dob'] = $data['dob'] =($data['dob'] != '')?date('Y-m-d',strtotime($data['dob'])):'';
					$data['date_of_marriage'] = ($data['date_of_marriage'] != '')?date('Y-m-d',strtotime($data['date_of_marriage'])):'';
			
					#comapny details update
					$company = $this->input->post('company',TRUE);
					unset($data['company']);
					$this->engineer->update_company($company,$id);
					if($data['password'] != ''){
						$data['password'] = password_hash($data['password'],PASSWORD_DEFAULT);
					}else{
						unset($data['password']);
					}
					#user details update
					if($this->engineer->my_update('users',$data,array('id'=>$id))){
						$this->message->set($this->lang->line('engineer-updated'));
					}else{
						$this->message->set($this->lang->line('engineer-not-updated'));
					}
					redirect('engineers/report');
				}
			}
			#get all areas
			$this->load->model('areas/Area_model','area');
			$areas = $this->area->listing();
			$areas[''] = 'Select';ksort($areas);

			#branches listing
			$this->load->model('branches/Branch_model','branch');
			$branches = $this->branch->listing(array('company_id'=>$this->session->userdata('company_id')));
			$branches[''] = 'Select a branch';
			ksort($branches);
				
			#template
			$this->template->title($this->lang->line('manage-engineers'));
			$this->template->main_heading($this->lang->line('manage-engineers'));
			$this->template->breadcrumb(array($this->lang->line('manage-engineers')=>'engineers/add',$this->lang->line('update')=>'no_link',$this->lang->line('report')=>'engineers/report'));
			$this->template->slice('engineers/edit/update',array('engineer'=>$engineer,'company'=>$company,'branches'=>$branches,'areas'=>$areas));
			$this->template->other_script(array('user_add','users/user_name_check','masons/ar_branch_select'));
			$this->template->render();	

		}

	 	#--------------------------------------------------------

		public function delete($id){

			if(empty($id)){redirect('engineers/report');}
			$id = $this->uri->segment(3);
			if($this->if_exists('users',array('id'=>$id,'status'=>1,'designation_id'=>6)) === false){
				redirect('engineers/report');
			}
			$engineer = $this->engineer->get_all(array('users.id'=>$id))[0];
			
			$total_privileges = $this->db->select('id')->get_where('user_privileges',array('owner_id'=>$id))->num_rows();
			$total_sales = $this->db->select('id')->get_where('dms_sales',array('user_id'=>$id,'status'=>1))->num_rows();
			$total_so = $this->db->select('id')->get_where('dms_sales_orders',array('user_id'=>$id,'status'=>1))->num_rows();
			$total_so_temps = $this->db->select('id')->get_where('dms_sales_order_temp',array('user_id'=>$id,'status'=>1))->num_rows();
			$total_targets = $this->db->select('id')->get_where('targets',array('designation_id'=>6,'user_id'=>$id,'status'=>1))->num_rows();
			
			if(empty($total_privileges) && empty($total_sales) && empty($total_so) && empty($total_so_temps) && empty($total_targets)){

				if((strtolower($engineer['photo']) !='male.jpg') && (strtolower($engineer['photo']) != 'female.jpg')){
					unlink(FCPATH.'assets/images/photos/'.$engineer['photo']);
				}
				if($this->db->update('users',array('status'=>0),array('id'=>$id))){
					$this->db->update('engineer_companies',array('status'=>0),array('engineer_id'=>$id));
					$this->message->set($this->lang->line('engineer-deleted'),'s');
				}else{
					$this->message->set($this->lang->line('engineer-not-deleted'),'e');
				}
			}else{
				$this->message->set($this->lang->line('can-not-delete-engineer'),'i');
			}
			redirect('engineers/report');
		}

	 	#--------------------------------------------------------

	}
?>