<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

	class Enquiries extends MY_Controller{

		public function __construct(){

			parent :: __construct();
			//$this->check_access_right();
			$this->load->model('enquiries/Enquiry_model','enquiry');
			
			#---------------- Checking Financial year is enabled / closed-----------------#
			$method_array = array('add','update_all_enquiry','delete_enquiry_item','delete_all_enquiry','enq_to_sales');
			fiscal_status($this->uri->segment(2),$method_array,"enquiries/report");	
			#---------------- Checking Financial year is enabled / closed-----------------#

                        $this->load->library(array('Stock','Targets'));
                        
                         $this->vtype=6;
		
		}

	 #-------------------------------------------------
			#enquiry add option
			#date:08-08-2014
			public function add(){

				$submitted_data = FALSE; 		
				$more_items = array();
               
				#validation rules 

				$this->form_validation->set_rules('enq[name]','lang:name','required');
				$this->form_validation->set_rules('enq[address]','lang:address','trim|xss_clean');
				$this->form_validation->set_rules('enq[phone_no]','lang:phone-number','required');
				$this->form_validation->set_rules('enq[follow_up_date]','lang:follow-up-date','required');
				$this->form_validation->set_rules('enq[enquiry_date]','lang:enquiry-date','required');
				$this->form_validation->set_rules('enq[mason_id]','lang:mason','required');
				$this->form_validation->set_rules('enq[stage_id]','lang:work-stage','required');
			
				if($this->input->post())		
				{
					#mason validation - if new mason added
					if($this->input->post('is_mason') == 'yes'){
						$this->form_validation->set_rules('is_mason','is_mason','required');
						$this->form_validation->set_rules('mason[fname]','lang:fname','required|trim|xss_clean');
						$this->form_validation->set_rules('mason[mobile]','lang:mobile','required|trim|xss_clean');
						$this->form_validation->set_rules('mason[mason_type]','lang:type','required|trim|xss_clean');
					}
					#validation for itenm
					foreach($this->input->post('index') as $index){
						$this->form_validation->set_rules('item['.$index.'][item_id]','lang:item','required');
						$this->form_validation->set_rules('item['.$index.'][item_quantity]','lang:quantity','required|xss_clean');
						$this->form_validation->set_rules('item['.$index.'][item_unit]','lang:unit','required');
						$this->form_validation->set_rules('item['.$index.'][item_req_comments]','lang:comments','xss_clean');
					}
				
					$more_items = $this->input->post('item',TRUE);
					#unset first item
					unset($more_items[0]);

				}

				#dms lib
				$this->load->library('Dms');

				if($this->form_validation->run() == TRUE){

					# get posted item & enquiry data
					$enquiry_data = $this->input->post('enq');
					$enquiry_data['company_id'] = $this->session->userdata('company_id');
					$enquiry_data['fiscal_yr_id'] = $this->dms->get_default_fiscal_id();
					//echo '<pre>';print_r($enquiry_data);

					$this->load->model('stocks/Request_model','request');
					#if mason data is added
					if($this->input->post('is_mason') == 'yes'){
						
						$enquiry_data['mason_id'] = $this->request->save_mason($this->input->post('mason'));
						
					}

					$items  = $this->input->post('item');
					#saving enquiry data and enquiry items
					if($enq_id = $this->enquiry->save($enquiry_data)){

						//print_r($enq_id);die;
						foreach($items as $item){ $this->enquiry->save_items($enq_id,$item);}
						$this->message->set($this->lang->line('enquiry-save'),'s');
					}
					else{
						$this->message->set($this->lang->line('enquiry-not-saved'),'e');
					}
					redirect('enquiries/report');	
					
				}
				else{
					//echo validation_errors();die;
				}

				#decide whether to show/hide mason-add-form
				$class = 'hide';
				if($this->input->post('is_mason') == 'yes'){ $class="";}

				#get product-item list
				$items = $this->load->model('products/Item_model','item');
				$items = $this->item->listing();
				$items[''] = 'Select an item';

				#masons list
				$this->load->model('users/Mason_model','mason');
				$masons =$this->mason->listing();
				//$masons[''] = 'Select A Mason';
				$masons[0] = 'NIL'; ksort($masons);

				#get all units
				$this->load->model('products/Unit_model','unit');
				$units = $this->unit->listing();

				#listing work stages
				$stages = $this->enquiry->work_stage_listing();
				$stages[''] = 'Select Work Stage';
				ksort($stages);
				#enquiry source
				$enquiry_sources = array('telecall'=>'Telecall','online'=>'Online');
				#template
				$this->template->title('Add new enquiry');
				$this->template->main_heading($this->lang->line('manage-enquiry'));
				$this->template->slice('enquiries/add',array('items'=>$items,'units'=>$units,'more_items'=>$more_items,'masons'=>$masons,'stages'=>$stages,'class'=>$class,'enquiry_sources'=>$enquiry_sources));
				$this->template->breadcrumb(array($this->lang->line('manage-enquiry')=>'enquiries/report',$this->lang->line('new')=>'no_link'));

				$this->template->other_script(array('stocks/requests/add_more_items'));
				$this->template->render();
				
			}
	 #---------------------------------------------------------------------
			#enquiry Report
			#date:11-08-2014
			public function report()
			{
				#report with pagination
				$this->load->library('Pagination');
				$config['per_page'] = $this->per_page();
				$config['total_rows'] = $this->enquiry->get_all(array('total'=>1));

				$config['base_url'] = base_url('enquiries/report');
				$config['uri_segment'] = 3;
				# Pagination Config Customizations
				$config['full_tag_open'] = '<ul class="pagination">';
				$config['full_tag_close'] = '</ul>';
				$config['first_link'] = 'First';
				$config['last_link'] = 'Last';
				$config['next_link'] = '&raquo;';
				$config['prev_link'] = '&laquo;';
				$config['cur_tag_open'] = '<li class="active"><a href="#">';
				$config['cur_tag_close'] = '</a></li>';
				$config['num_tag_open'] = '<li>';
				$config['num_tag_close'] = '</li>';
				$this->pagination->initialize($config);
				$links = $this->pagination->create_links();
				$offset = $this->uri->segment(3,0);

				$enquiries = $this->enquiry->get_all(array('order_by'=>'created_on','order'=>'DESC','limit'=>$config['per_page'],'offset'=>$offset));

				$total_items =  FALSE;
				if(!empty($enquiries)){
					foreach($enquiries as $enq){
						$total_items[$enq['id']] = $this->enquiry->get_items(array('ei.enquiry_id'=>$enq['id'],'total'=>1));
					}
				}
				//echo '<pre>';print_r($total_items);die;

				$this->template->title('Enquiry Report');
				$this->template->main_heading($this->lang->line('manage-enquiry'));
				$this->template->breadcrumb(array($this->lang->line('manage-enquiry')=>'enquiries/add',$this->lang->line('report')=>'no_link'));
				$this->template->slice('dms/message');
				$this->template->slice('enquiries/report/report',array('enquiries'=>$enquiries,'links'=>$links,'offset'=>$offset,'total_items'=>$total_items));
				$this->template->other_script('enquiries/report/update_enquiry_item');
				$this->template->other_script('employees/employee_target');
				$this->template->slice('dms/modals/forms/update_enquiry_item_modal');

				
				$this->template->render();
			}
	 #---------------------------------------------------------------------------
			#date:15-8-2014
			#purpose: delete enquired each item
			public function delete_enquiry_item(){

				$enq_items_id = $this->uri->segment(3);
				if(empty($enq_items_id)){
					redirect('dms/');
				}

				if($this->db->update('enquiry_items',array('status'=>0),array('id'=>$enq_items_id))){
					$this->message->set($this->lang->line('enquiry-item-delete'),'s');
				}
				else{
					$this->message->set($this->lang->line('enquiry-item-not-delete'),'e');
				}
				redirect('enquiries/report');
			}
	 #---------------------------------------------------------------------------
			#date:15-8-2014
			#purpose:Delete entire enquiry details
			public function delete_all_enquiry(){

				$enq_id = $this->uri->segment(3);
				//print_r($req_id);die;
				if(empty($enq_id)){ redirect('dms/');}

				if($this->db->update('enquiries',array('status'=>0),array('id'=>$enq_id))){

					#update requsted stock status 
					$this->db->update('enquiry_items',array('status'=>0),array('enquiry_id'=>$enq_id));
					$this->message->set($this->lang->line('enquiry-delete'),'s');
				}
				else{

					$this->message->set($this->lang->line('enquirynot-delete'),'e');
					
				}
				redirect('enquiries/report');
			}
	 #---------------------------------------------------------------------------








         #---------------------------
			#date:15-8-2014
			#purpose:Update entire enquiry  deatils
			public function update_all_enquiry(){

				$more_items = array();

				$enquiry_id = $this->uri->segment(3);
				if(empty($enquiry_id)){ redirect('dms/');}

				#get all datas of enquiry id
				$enquiry = $this->db->select('')->get_where('enquiries',array('id'=>$enquiry_id))->row_array();
				
				#get enquiry item details of corresponding enquiry id
				$enquiry_items = $this->db->select('')->get_where('enquiry_items',array('enquiry_id'=>$enquiry_id,'status'=>1))->result_array();
				//echo '<pre>';print_r($enquiry_items);die;

				$this->form_validation->set_rules('enq[name]','lang:name','required');
				$this->form_validation->set_rules('enq[address]','lang:address','trim|xss_clean');
				$this->form_validation->set_rules('enq[phone_no]','lang:phone-number','required');
				$this->form_validation->set_rules('enq[follow_up_date]','lang:follow-up-date','required');
				$this->form_validation->set_rules('enq[enquiry_date]','lang:enquiry-date','required');

				if($this->input->post())		
				{
					#mason validation - if new mason added
					if($this->input->post('is_mason') == 'yes'){
						$this->form_validation->set_rules('is_mason','is_mason','required');
						$this->form_validation->set_rules('mason[fname]','lang:fname','required|trim|xss_clean');
						$this->form_validation->set_rules('mason[lname]','lang:lname','required|trim|xss_clean');
						$this->form_validation->set_rules('mason[mobile]','lang:mobile','required|trim|xss_clean');
						$this->form_validation->set_rules('mason[mason_type]','lang:type','required|trim|xss_clean');
					}
					#validation for itenm
					foreach($this->input->post('items') as $item){

					$this->form_validation->set_rules('item['.$item.'][item_id]','lang:item','required');
					$this->form_validation->set_rules('item['.$item.'][item_quantity]','lang:quantity','required|xss_clean');
					$this->form_validation->set_rules('item['.$item.'][item_unit]','lang:unit','required');
					$this->form_validation->set_rules('item['.$item.'][item_req_comments]','lang:comments','xss_clean');	

					}

					#echo '<pre>'; print_r($_POST);die;

					#print_r($this->input->post('index'));die;
					if(isset($_POST['item'][1]['item_id'])){

						foreach($this->input->post('index') as $index){

							$this->form_validation->set_rules('item['.$index.'][item_id]','lang:item','required');
							$this->form_validation->set_rules('item['.$index.'][item_quantity]','lang:quantity12','required|xss_clean');
							$this->form_validation->set_rules('item['.$index.'][item_unit]','lang:unit','required');
							$this->form_validation->set_rules('item['.$index.'][item_req_comments]','lang:comments','xss_clean');
						}
					
						$more_items = $this->input->post('index',TRUE);
						#unset first item
						unset($more_items[0]);
					}

				}

				if($this->form_validation->run() == TRUE){

					$enquiry_data = $this->input->post('enq');
					$enquiry_data['enquiry_date'] = date('Y-m-d',strtotime($enquiry_data['enquiry_date']));
					$enquiry_data['follow_up_date'] = date('Y-m-d',strtotime($enquiry_data['follow_up_date']));
				
					//$this->db->update('sales',$request_data,array('id'=>$req_id));
					//echo'<hr>';
					$posted_items = $this->input->post('item');
				
					$posted_new_items = array();
					//$p_n_item = array();
					$p_n_item =array();
					
					foreach($posted_items as $p_item){

						$posted_new_items[] = $p_item['id'];
						$p_n_item[$p_item['id']] = array('item_id'=>$p_item['item_id'],'item_quantity'=>$p_item['item_quantity'],'item_unit'=>$p_item['item_unit'],'item_req_comments'=>$p_item['item_req_comments']);

					}

					//echo '<pre>';print_r($p_n_item);
					//echo '<hr>';
					#echo '<pre>'; print_r($enquiry_items);die;
					$existed_items = array();
					foreach($enquiry_items as $e_item){

						$existed_items[] = $e_item['id'];

					}
					//echo '<hr>';
					//echo '<pre>';print_r($existed_items);die;

					foreach($existed_items as $e_item){

						if(!in_array($e_item,$posted_new_items)){

							$this->db->update('enquiry_items',array('status'=>0),array('id'=>$e_item,'enquiry_id'=>$enquiry_id));
						}
					}


					foreach($posted_new_items as $p_item){

						if(!in_array($p_item,$existed_items)){

							$p_item = $p_n_item[$p_item];

							$p_item['enquiry_id'] = $enquiry_id;
							$this->db->insert('enquiry_items',$p_item);

						}
						else{
							$item = $p_n_item[$p_item];
							$item['id'] = $p_item;
							//print_r($item);die;
							$this->db->update('enquiry_items',$item,array('id'=>$item['id'],'enquiry_id'=>$enquiry_id));
						}
					}

					$this->load->model('stocks/Request_model','request');
					#if mason data is added
					if($this->input->post('is_mason') == 'yes'){
						
						$enquiry_data['mason_id'] = $this->request->save_mason($this->input->post('mason'));
						
					}	
					#update enquiries data
					if($this->db->update('enquiries',$enquiry_data,array('id'=>$enquiry_id))){
						$this->message->set($this->lang->line('enquiry-update'),'s');
					}
					else{
						$this->message->set($this->lang->line('enquiry-not-update'),'e');
					}
					$call_ck_uri = $this->uri->uri_to_assoc(4);
					redirect($this->uri->assoc_to_uri($call_ck_uri));die;

				}

					#decide whether to show/hide mason-add-form
				$class = 'hide';
				if($this->input->post('is_mason') == 'yes'){ $class="";}
		
				#masons list
				$this->load->model('users/Mason_model','mason');
				$masons = $this->mason->listing();
				//$masons[''] = 'Select A Mason';
				$masons[0] = 'NIL'; ksort($masons);

				#get product-item list
				$items = $this->load->model('products/Item_model','item');
				$items = $this->item->listing();
				$items[''] = 'Select an item';

				#get all units
				$this->load->model('products/Unit_model','unit');
				$units = $this->unit->listing();

				#listing work stages
				$stages = $this->enquiry->work_stage_listing();
				$stages[''] = 'Select Work Stage';
				ksort($stages);

				#enquiry sources
				$enquiry_sources = array('telecall'=>'Telecall','online'=>'Online');

				#template
				$this->template->title('Edit Enquiry Details');
				$this->template->main_heading($this->lang->line('manage-enquiry'));
				$this->template->slice('enquiries/edit/edit',array('enquiry'=>$enquiry,'enquiry_items'=>$enquiry_items,'items'=>$items,'units'=>$units,'more_items'=>$more_items,'class'=>$class,'masons'=>$masons,'stages'=>$stages,'enquiry_sources'=>$enquiry_sources));
				$this->template->other_script(array('enquiries/edit/add_more_items'));
				$this->template->render();


			}
			
			
			
			public function enq_to_sales()
			{
				if($this->uri->segment(3))
				{
					$enquiry_id = $this->uri->segment(3);
                 
                                    
				    $enquiry_array =  $this->enquiry->get_sales(array('columns'=>array('a.id','a.company_id','a.mason_id','a.stage_id','a.name','a.phone_no','a.address','a.created_by','a.enquiry_date','a.follow_up_date','a.fiscal_yr_id','b.enquiry_id','b.item_id','b.item_quantity','b.item_unit','b.status'),'conditions' => array('a.id' =>$enquiry_id,'a.status'=>1)));
$us_id=$enquiry_array[0]['created_by'];
$name= $enquiry_array[0]['name'];
$address=$enquiry_array[0]['address'];
$mobile_no=$enquiry_array[0]['phone_no'];


					if(!empty($enquiry_array))
                                        {                    
                                              #----------loading models
						$this->load->model('designations/Designation_master_model','desig');
						$this->load->model('customers/Customer_type_model','customer_type');
				                $this->load->model('vouchers/Voucher_model','vouchers');
                                                $this->load->model('sales/Sales_model','sales_obj');
						#----------voucher type
						$vtype_id = $this->vtype;
                                       		
						#----------voucher type array
						$voucher_types = $this->vouchers->voucher_types($this->vtype);
                                  
						$bill_prefix = $this->stock->get_voucher_prefix($this->vtype);
                                             
						#----------voucher name
						$voucher_name = $this->vouchers->voucher_name($this->vtype);
				
						#-----------sales cst checking details
						$sales_cst = $this->stock->get_constant(array('sales_cst'));
				
						#------------presumptive tax checking
						$presumptive_tax = $this->stock->get_tax_type();
				
						#------------cess %
						$cess = $this->stock->get_cess();
						$this->load->library('Transport_lib');
				
						$vehicles =$drivers = $routes= $sales_vehicles = $sales_driver = array();
				
						$vehicles = $this->transport_lib->vehicles();
						$drivers = $this->transport_lib->drivers();
						$routes = $this->transport_lib->routes();
				
						#-----------sales date and next bill no
						$rules = "callback_bill_no_exists";
						$disabled = "readonly";
						$result_array = $this->sales_obj->next_bill_no($this->vtype);
						$vtype_id = $result_array['vtype_id'];
						$voucher_no = $result_array['bill_no'];
						$voucher_date = $result_array['bill_date'];
                                           //     $bill_no=$this->sales_obj->next_bill($this->vtype);

						if($result_array['vstatus'])
						{
							
							#-----------redirection if sales order / delivery note / purchase request conversion is pending
							if($result_array['s_status'] == 2)
							{
								redirect("order_to_sales/so_sales/".$result_array['sid']);
							} 
							/*elseif($result_array['s_status'] == 3){
							redirect("delivery_to_sales/sales/".$result_array['sid']);
						}*/
							elseif($result_array['s_status'] == 1)
							{
								redirect("request_to_sales/pr_sales/".$result_array['sid']);
							}

							$disabled = "readonly";
							$group_id = $result_array['group_id'];
							$rules = "callback_bill_no_exists[$vtype_id.$group_id]";
				
							$voucher_details = $this->dms->get_data(array('table' => 'dms_vouchers as a','join' => array('table' => 'dms_sales as b','on' => 'a.table_group_id = b.group_id'),'columns' => 'b.id','conditions' => array('a.table_name' => 'dms_sales','a.table_group_id' => $group_id)));
							if(!empty($voucher_details))
							{
								redirect("sales/update/id/".$voucher_details[0]['id']);
							}
				
							#------------checking cst enabled or not
							$cst_status = $this->sales_obj->get_cst($group_id);
							if($cst_status)
							{
								$sales_cst = $cst_status;
							}
						}
						else
						{
							
							$group_id = $this->stock->get_group_id('dms_sales_items1');
						}
				
						#-------------adding data to sales temp

						$customerID = $this->enquiry->save_customer(array('fname'=>$name,'address'=>$address,'mobile_no'=>$mobile_no,'status'=>1));
						
						
						$enquiry_sales_temp=array('vtype_id' => $vtype_id,'branch_id' => $this->session->userdata('under_id'),'bill_no' =>$voucher_no,'bill_date' => $voucher_date,'group_id' => $group_id,'customer_type_id' => 2,'customer_id' => $customerID,'user_id'=>$us_id,'status' => -1);
						
						$this->sales_obj->insert("dms_sales",$enquiry_sales_temp);
						
						foreach($enquiry_array as $enq_array)
						{
							$a=0;
							$enq_item_array['group_id']= $group_id;
							$enq_item_array['item_id']=$enq_array['item_id'];
							
							$qty=$enq_array['item_quantity'];
							
							$enq_item_array['qty']=$qty;
							$enq_item_array['unit_id']=$enq_array['item_unit'];
							
							$itemid=$enq_array['item_id'];
							
							$rate=$this->stock->get_item_rate($itemid);
							$enq_item_array['rate']=$rate;
							
							$a=$qty*$rate;
							
							$enq_item_array['amount']=$a;
							
							$cgst = $this->stock->get_item_cgst($itemid);
							$sgst = $this->stock->get_item_sgst($itemid);
							$enq_item_array['cgst']=$cgst;
							$enq_item_array['sgst']=$sgst;
							$enq_item_array['cgst_amt']=($a*$cgst)/100;
							$enq_item_array['sgst_amt']=($a*$sgst)/100;
							$enq_item_array['godown_id']=1;
							
							$enq_item_array['status'] = -1;								
							$enq_item_array['item_status'] = 2;
							
							$this->sales_obj->insert("dms_sales_items1",$enq_item_array);

						}
                                                $this->db->query("update enquiries set status=2 where id='$enquiry_id'");
 redirect('sales/add');
						
					} 
				}

			}


			
	 #---------------------------------------------------------------------------
			public function search(){

				$links = NULL;
				$enquiries = NULL;
				$total_items = NULL;
				$offset = NULL;
				$filter_data = array('search_type'=>'','from_date'=>'','to_date'=>'','mason_id'=>''); 

				if(isset($_POST['filter']) || $this->uri->segment(3) != ''){

					//echo 'hai';die;
					//$filter_data = $this->input->post('search',TRUE);
					#print_r($_POST['search']);die;
					
				
					if($this->input->post('search')){

						$filter_data = $this->input->post('search');
					}
					else{
						$filter_data = $this->uri->uri_to_assoc(3);
						//echo'<pre>';print_r($filter_data);die;
					}
					
					$filter_data = array_filter($filter_data);
					//print_r($filter_data);die;
					$count = count($filter_data);

					if($count==1 && isset($filter_data['search_type'])){
						$this->message->set($this->lang->line('use-one-filter'),'e');
					}
					else{
					
						if(isset($_POST['filter'])){


							if(isset($filter_data['from_date']) && $filter_data['from_date'] != ''){
								$this->form_validation->set_rules('search[from_date]','lang:date','is_date|required');
							}

							if(isset($filter_data['to_date']) && $filter_data['to_date'] != ''){
								$this->form_validation->set_rules('search[to_date]','lang:date','is_date|required');
							}
							$this->form_validation->set_rules('search[mason_id]','lang:mason','xss_clean');
							$this->form_validation->set_rules('search[search_type]','lang:mason','xss_clean');

							
						}

						if($this->form_validation->run() == TRUE || $this->uri->segment(3)){

							#load enquiry model
							$this->load->model('enquiries/Enquiry_model','enquiry');
							#---------checking from date and to date set----------------------------

							if(isset($filter_data['from_date']) && $filter_data['from_date']!=''){
								$from_date =date('Y-m-d',strtotime($filter_data['from_date']));
								//print_r($from_date);echo'<hr>';
								$filter_data['from_date'] = $from_date;
							}

							if(isset($filter_data['to_date']) && $filter_data['to_date']!=''){
								$to_date =date('Y-m-d',strtotime($filter_data['to_date']));
								//print_r($to_date);echo'<hr>';
								$filter_data['to_date'] = $to_date;
							}
							#---------checking from date and to date set----------------------------

							#----------search conditions wit enquiry date---------------------------
							if(isset($filter_data['search_type']) && $filter_data['search_type']=='enquiry' && isset($filter_data['from_date']) || isset($filter_data['to_date'])){

								if(!empty($from_date)&& !empty($to_date)){
									$conditions['enquiry_date >='] = $from_date;
									$conditions['enquiry_date <='] = $to_date;
									//print_r($conditions);die;
								}
								if(!empty($from_date) && empty($to_date)){
									$conditions['enquiry_date >='] = $from_date;
									//$conditions['enquiry_date <='] = $from_date;
								}
								if(!empty($to_date) && empty($from_date)){
									$conditions['enquiry_date <='] = $to_date;
								}


							}
							#----------search conditions wit enquiry date---------------------------

							#----------search conditions wit follow up date---------------------------
							if(isset($filter_data['search_type']) && $filter_data['search_type']=='followup' && isset($filter_data['from_date']) || isset($filter_data['to_date'])){

								if(!empty($from_date)&& !empty($to_date)){
									$conditions['follow_up_date >='] = $from_date;
									$conditions['follow_up_date <='] = $to_date;
									//print_r($conditions);die;
								}
								if(!empty($from_date) && empty($to_date)){
									$conditions['follow_up_date >='] = $from_date;
									//$conditions['enquiry_date <='] = $from_date;
								}
								if(!empty($to_date) && empty($from_date)){
									$conditions['follow_up_date <='] = $to_date;
								}


							}
							#----------search conditions wit follow up date---------------------------
							if(isset($filter_data['mason_id']) && $filter_data['mason_id']!=''){
								$conditions['mason_id'] =  $filter_data['mason_id'];
							}

							$conditions['total'] = 1;
							$this->load->library('Pagination');
							$config['per_page'] = $this->per_page();
							$config['base_url'] = base_url('enquiries/search').'/'.$this->uri->assoc_to_uri(array_filter($filter_data));
							 $config['uri_segment'] = count(array_filter($filter_data)) * 2 + 3;
							$config['total_rows'] = $this->enquiry->get_all($conditions);
							//echo $this->db->last_query();die;
							# Pagination Config Customizations
							$config['full_tag_open'] = '<ul class="pagination">';
							$config['full_tag_close'] = '</ul>';
							$config['first_link'] = 'First';
							$config['last_link'] = 'Last';
							$config['next_link'] = '&raquo;';
							$config['prev_link'] = '&laquo;';
							$config['cur_tag_open'] = '<li class="active"><a href="#">';
							$config['cur_tag_close'] = '</a></li>';
							$config['num_tag_open'] = '<li>';
							$config['num_tag_close'] = '</li>';	
							$this->pagination->initialize($config);
							$links = $this->pagination->create_links();
							$offset = $this->uri->segment($config['uri_segment'] ,0);

							$conditions['order_by'] = 'created_on';
							$conditions['order'] = 'DESC';
							$conditions['limit']  = $config['per_page']; 
							$conditions['offset'] = $offset;
							unset($conditions['total']);
							$enquiries = $this->enquiry->get_all($conditions);
							//echo '<pre>';print_r($enquiries);die;

							$total_items =  FALSE;
							if(!empty($enquiries)){
								foreach($enquiries as $enq){
									$total_items[$enq['id']] = $this->enquiry->get_items(array('ei.enquiry_id'=>$enq['id'],'total'=>1));
								}
							}
							if(empty($enquiries)){
								$this->message->set($this->lang->line('no-enquiry-data-found'),'e');
							}
						}
						
					
					}
					#set dummy filter data again for the unset values
					if(!isset($filter_data['from_date'])){ $filter_data['from_date'] = ''; }else{$filter_data['from_date'] = date(CAL_FORMAT,strtotime($filter_data['from_date']));}
					if(!isset($filter_data['to_date'])){ $filter_data['to_date'] = ''; }else{$filter_data['to_date'] = date(CAL_FORMAT,strtotime($filter_data['to_date']));}
					if(!isset($filter_data['mason_id'])){ $filter_data['mason_id'] = ''; }
					//if(!isset($filter_data['site_id'])){ $filter_data['site_id'] = ''; }
				}

				#search type
				$search_types = array('enquiry'=>'Enquiry Date','followup'=>'Follow up Date');

				#mason list 
				$this->load->model('users/Mason_model','mason');
				$masons = $this->mason->listing();
				$masons[''] = 'select';
				//echo $this->db->last_query();die;
				ksort($masons);

				
				
				#template
				$this->template->title('Enquiries Search');
				$this->template->main_heading($this->lang->line('enquiry-search'));
				$this->template->breadcrumb(array($this->lang->line('manage-enquiry')=>'enquiries/report',$this->lang->line('search')=>'no_link'));
				$this->template->slice('dms/message');
				$this->template->slice('enquiries/enquiry_search',array('search_types'=>$search_types,'masons'=>$masons,'enquiries'=>$enquiries,'links'=>$links,'offset'=>$offset,'total_items'=>$total_items,'data'=>$filter_data));
				$this->template->render();
			}
	 #---------------------------------------------------------------------------
			#date:18-10-2014
			#purpose:single enquiry report through dashborad remainder
			public function single_enquiry_report(){

				$enq_id = $this->uri->segment(3);
				#get details of enq id;
				$enquiries = $this->enquiry->get_all(array('e.id'=>$enq_id));

				//echo '<pre>';print_r($enquiries);die;

				//$enquiries = $this->enquiry->get_all(array('order_by'=>'created_on','order'=>'DESC','limit'=>$config['per_page'],'offset'=>$offset));

				$total_items =  FALSE;
				$links = '';
				$offset = 0;
				if(!empty($enquiries)){
					foreach($enquiries as $enq){
						$total_items[$enq['id']] = $this->enquiry->get_items(array('ei.enquiry_id'=>$enq['id'],'total'=>1));
					}
				}
				//echo '<pre>';print_r($total_items);die;

				$this->template->title('Enquiry Report');
				$this->template->main_heading($this->lang->line('manage-enquiry'));
				$this->template->breadcrumb(array($this->lang->line('manage-enquiry')=>'enquiries/add',$this->lang->line('report')=>'no_link'));
				$this->template->slice('dms/message');
				$this->template->slice('enquiries/report/single_enquiry_report',array('enquiries'=>$enquiries,'links'=>$links,'offset'=>$offset,'total_items'=>$total_items));
				$this->template->other_script('enquiries/report/update_enquiry_item');
				$this->template->other_script('employees/employee_target');
				$this->template->slice('dms/modals/forms/update_enquiry_item_modal');

				
				$this->template->render();
			}
	 #---------------------------------------------------------------------------
	 
	 
	 
	 
	 
	 
	 
	}	
		