<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

class Evats extends MY_Controller{

	public function __construct()
	{
		parent::__construct();

		$this->load->library(array('Tax','Stock'));
		$this->load->helper(array('file','download'));
	}

	public function purchase()
	{
		$fiscal_start_date = $this->dms->get_fiscal_year()['start_date'];
		$from_date = $to_date = date('Y-m-d');#$fiscal_start_date;
		$btn_id = "download_purchase_tax";
                
		if(isset($_POST['btn_search']))
		{
			#-------------validation
			$this->form_validation->set_rules('from_date','lang:from-date','required|xss_clean|valid_date');
			if($this->input->post('from_date',true))
			{
				$from_date = $this->input->post('from_date',true);
				$this->form_validation->set_rules('to_date','lang:to-date',"required|xss_clean|valid_date|check_date[$from_date.>=]");
			}
			if($this->form_validation->run() === true)
			{
				$from_date = date('Y-m-d',strtotime($this->input->post('from_date',true)));
				$to_date = date('Y-m-d',strtotime($this->input->post('to_date',true)));

                                
                                if($this->tax->generate_purchase_egst($from_date,$to_date)){
					$data = file_get_contents("assets/evats/purchase/Purchase.txt"); // Read the file's contents
					force_download('Purchase.txt',$data);//download
				} 
                                
			}
		}

		#-------------template
		$this->template->title('E-GST Purchases');
		$this->template->main_heading('E-GST Purchases');
		$this->template->breadcrumb(array($this->lang->line('tax-reports') => 'no_link',$this->lang->line('e-vat-purchases') => 'no_link'));
		$this->template->slice('tax_reports/tax_search',array('from_date' => $from_date,'to_date' => $to_date,'btn_id'=>$btn_id));
		$this->template->slice('dms/message');
		$this->template->render();
	}

	public function sales()
	{
		$fiscal_start_date = $this->dms->get_fiscal_year()['start_date'];
		$from_date = $to_date = date('Y-m-d');#$fiscal_start_date;
		$btn_id = "download_sales_tax";
		if(isset($_POST['btn_search']))
		{
			#-------------validation
			$this->form_validation->set_rules('from_date','lang:from-date','required|xss_clean|valid_date');
			if($this->input->post('from_date',true))
			{
				$from_date = $this->input->post('from_date',true);
				$this->form_validation->set_rules('to_date','lang:to-date',"required|xss_clean|valid_date|check_date[$from_date.>=]");
			}
			if($this->form_validation->run() === true)
			{
				$from_date = date('Y-m-d',strtotime($this->input->post('from_date',true)));
				$to_date = date('Y-m-d',strtotime($this->input->post('to_date',true)));

                                
                                if($this->tax->generate_sales_egst($from_date,$to_date))
                                {
					$data = file_get_contents("assets/evats/sales/Sales.txt");// Read the file's contents
					force_download('Sales.txt',$data);//download
				}
                              
			}
		}

		#-------------template
		$this->template->title('E-GST Sales');
		$this->template->main_heading('E-GST Sales');
		$this->template->breadcrumb(array($this->lang->line('tax-reports') => 'no_link',$this->lang->line('e-vat-sales') => 'no_link'));
		$this->template->slice('tax_reports/tax_search',array('from_date' => $from_date,'to_date' => $to_date,'btn_id'=>$btn_id));
		$this->template->slice('dms/message');
		$this->template->render();
	}

}
?>