<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

	class Graphs extends MY_Controller{

		var $fiscal_start , $fiscal_end ;
	#-------------------------------------------------------------------------------

		function __construct(){
			parent :: __construct();
			$this->check_access_right();
			$fiscals = $this->dms->get_fiscal_year();
			$this->fiscal_start = $fiscals['start_date'];
			$this->fiscal_end = $fiscals['end_date'];
		}

	#-------------------------------------------------------------------------------
		
		#date : 1-9-2014
		function ar_performance(){

			$this->load->model('retailers/Counter_model','retailer');
			$this->load->model('graphs/Graph_model','graph');
			$ars = $this->retailer->listing(array('company_id'=>$this->session->userdata('company_id')));

			$from_date = $this->fiscal_start;
			$to_date = $this->fiscal_end;
			$sales_new = array();	

			$this->form_validation->set_rules('from_date','lang:from','trim|xclean|valid_date');
			$this->form_validation->set_rules('to_date','lang:to','trim|xclean|valid_date');
			
			if($this->form_validation->run() == TRUE){

				$sel_from_date = $this->input->post('from_date');
				$sel_to_date = $this->input->post('to_date');
				if(!empty($sel_from_date) && !empty($sel_to_date) && $sel_from_date <= $sel_to_date){
					$from_date = date('Y-m-d',strtotime($sel_from_date));
					$to_date = date('Y-m-d',strtotime($sel_to_date));
				}
			}

			foreach ($ars as $id => $name) {
				$sales = $this->graph->get_area_wise_sales(array('conditions'=>array('sls.customer_type_id'=>3,'sls.customer_id'=>$id),'from_date'=>$from_date,'to_date'=>$to_date));		
				
				if(!empty($sales)){
					
					$sum = 0;
					foreach ($sales as $key => $sale) {
						$sum = $sum+$sale['vamount'];
					}
					$sales_new[$id] = $sum;
					
				}else{
					
					$sales_new[$id] = 0;
				}
		    }		
			$this->template->title($this->lang->line('ar').' '.$this->lang->line('performance-graph'));
			$this->template->main_heading($this->lang->line('ar').' '.$this->lang->line('performance-graph'));
			$this->template->breadcrumb(array($this->lang->line('graphs')=>'no_link',$this->lang->line('ar').' '.$this->lang->line('performance-graph')=>'no_link',$this->lang->line('area_wise_sales')=>'graphs/area_wise_sales'));
			$this->template->slice('graphs/bars/ar_perfomance',array('ars'=>$ars,'sales'=>$sales_new,'from_date'=>$from_date,'to_date'=>$to_date));
			#flot JS
			$this->template->script('londinium/scripts/plugins/charts/flot');
			$this->template->script('londinium/scripts/plugins/charts/flot.orderbars');
			$this->template->script('londinium/scripts/plugins/charts/flot.animator.min');
			$this->template->other_script('graphs/jquery.flot.axislabels');
			$this->template->render();
		}

	#-------------------------------------------------------------------------------

		#date : 09-09-2014
		function emp_performance(){

			#draw no graph
			$draw_graph = FALSE;
			$this->template->title('Employee performance');
			$this->template->main_heading($this->lang->line('emp-performance'));
			$this->template->breadcrumb(array($this->lang->line('graphs')=>'graphs/index',$this->lang->line('emp-performance')=>'no_link'));

			#designation listing
			$this->load->model('designations/Designation_master_model');
			$desgs = $this->designation_master_model->listing(array('id !='=>1));
			$desgs = array_map('strtoupper',$desgs);

			#list items
			$this->load->model('products/Item_model','item');
			$items = $this->item->listing();
			$items = array_map('ucfirst',$items);

			#validation
			if($this->form_validation->run() == TRUE){

				$draw_graph = TRUE;
				#flot JS
				$this->template->script('londinium/scripts/plugins/charts/flot');
				$this->template->script('londinium/scripts/plugins/charts/flot.orderbars');
				$this->template->script('londinium/scripts/plugins/charts/flot.animator.min');
				$this->template->other_script('graphs/jquery.flot.axislabels');

				#models
				$this->load->model('users/User_target_model','ut');
				$this->load->model('stocks/Order_model','order');
				$this->load->library('Cart_lib');

				#users
				$users = $this->user->listing(array('designation_id'=>$this->input->post('designation_id'),'user_type'=>'employee','status'=>1,'designation_id !='=>1));
				#echo $this->db->last_query();

				if(empty($users)){
					$draw_graph = FALSE;
					$this->message->set($this->lang->line('no-emps-found'),'e');
					$this->message->append_msg($this->lang->line('make-sure-user-active'),'i');
				}else{

					#print_r($users);
				
					$from = date('Y-m-d',strtotime($this->input->post('from',TRUE)));
					$to = date('Y-m-d',strtotime($this->input->post('to',TRUE)));
					$item_id = $this->input->post('item_id',TRUE);

					#there are employees
					foreach($users as $user_id=>$name){

						if(!isset($t_targets[$user_id])){
							$t_targets[$user_id] = 0; #total targets
							$t_orders[$user_id] = 0; #total orders
						}

						#target count
						$qty = $this->ut->total_target_qty(array('conditions'=>array('t.user_id'=>$user_id,'valid_from>='=>$from,'valid_to<='=>$to,'item_id'=>$item_id)));
						#echo $qty.'---';
						#echo $this->db->last_query().'<hr/>';

						$t_targets[$user_id] = $t_targets[$user_id] + $qty;
						#echo '<hr/>';

						#order count
						$qty = $this->order->total_order_qty(array('conditions'=>array('s.user_id'=>$user_id,'item_id'=>$item_id),'between'=>array('DATE(s.created_on)'=>array($from,$to))));
						#echo $qty.'---';
						#echo $this->db->last_query().'<hr/>';
						$t_orders[$user_id] = $t_orders[$user_id] + $qty;

						#not-achieved orders
						$nt_achieved[$user_id] = $t_targets[$user_id] - $t_orders[$user_id];
						if($nt_achieved[$user_id] < 0){ $nt_achieved[$user_id] = 0; }

					} #nd foreach

					if(max($t_targets) >= max($t_orders)){ $max = max($t_targets);}
					else{ $max = max($t_orders);}

					
					$this->template->append('graphs/bars/emp_performance_graph',array('max'=>$max,'t_targets'=>$t_targets,'t_orders'=>$t_orders,'nt_achieved'=>$nt_achieved,'users'=>$users));

					

				}


			}

			$this->template->slice('dms/message');
			$this->template->slice('graphs/bars/emp_performance',array('desgs'=>$desgs,'items'=>$items));
			$this->template->render();
		}

	#---------------------------------------------------
	
		#date:23-9-2014
		#purpose:enquiry to sales conversion
		function enquiry_conversion(){
			#draw no graph
			//$draw_graph = FALSE;
			$this->form_validation->set_rules('from','lang:from','required|is_date');
			$this->form_validation->set_rules('to','lang:to','required|is_date');
			if($this->form_validation->run() == true){

				#get sales assigned for this date-range
				$from = date('Y-m-d',strtotime($this->input->post('from')));
				$to = date('Y-m-d',strtotime($this->input->post('to')));
				#condition array=
				$conditions['date_of_delivery >='] = $from;
				$conditions['date_of_delivery <='] = $to;
				$conditions['final_status'] = 1;
				$conditions['status'] =1;
				$total_sales = $this->db->select('')->get_where('sales',$conditions)->result_array();
				$total_sales = count($total_sales);
				$conditions['enquiry'] =1;
				$enquiry_sales = $this->db->select('')->get_where('sales',$conditions)->result_array();
				$enquiry_sales = count($enquiry_sales);
				$this->template->script('londinium/scripts/plugins/charts/flot');
				$this->template->script('londinium/scripts/plugins/charts/flot.pie');
				//$this->template->script('londinium/scripts/plugins/charts/flot.animator.min');
				//$this->template->other_script('graphs/jquery.flot.axislabels');

				$this->template->append('graphs/pie/enquiry_conversion_graph',array('t_sales'=>$total_sales,'e_sales'=>$enquiry_sales));
			}

			#template:
			$this->template->title($this->lang->line('enquiry-sales-graph'));
			$this->template->main_heading($this->lang->line('enquiry-sales-graph'));
			$this->template->breadcrumb(array($this->lang->line('graphs')=>'graphs/index',$this->lang->line('enquiry-conversion')=>'no_link'));
			$this->template->slice('graphs/pie/enquiry_conversion');
			$this->template->render();

		}
	#-------------------------------------------------------
		function area_wise_sales(){

			$this->load->model('branches/Branch_model','branch');
			$this->load->model('areas/Area_model','area');
			$this->load->model('graphs/Graph_model','graph');
				
			$from_date = $this->fiscal_start;
			$to_date = $this->fiscal_end;
			$branch_id = $this->session->userdata('under_id');

			$this->form_validation->set_rules('branch_id','lang:branch','trim|xss_clean');
			$this->form_validation->set_rules('from_date','lang:from','trim|xclean|valid_date');
			$this->form_validation->set_rules('to_date','lang:to','trim|xclean|valid_date');
			
			if($this->form_validation->run() == TRUE){

				if(!empty($this->input->post('branch_id'))){
					$branch_id = $this->input->post('branch_id');
				}
				$sel_from_date = $this->input->post('from_date');
				$sel_to_date = $this->input->post('to_date');
				if(!empty($sel_from_date) && !empty($sel_to_date) && $sel_from_date <= $sel_to_date){
					$from_date = date('Y-m-d',strtotime($sel_from_date));
					$to_date = date('Y-m-d',strtotime($sel_to_date));
				}
			}

			$sales_new =array();
			$areas = $this->area->get_all(array('conditions'=>array('status'=>1)));
			$areas_list = $this->area->listing();
			ksort($areas_list);
			
			foreach ($areas as $key => $area) {
				$sales = $this->graph->get_area_wise_sales(array('conditions'=>array('sls.branch_id'=>$branch_id,'sls.area_id'=>$area['id']),'from_date'=>$from_date,'to_date'=>$to_date));
				if(!empty($sales)){
					$sum = 0;
					foreach ($sales as $key => $sale) {
						$sum = $sum+$sale['vamount'];
					}
					$sales_new[$area['id']] = $sum;
				} else {
					$sales_new[$area['id']] = 0;
				}
		    }

			#checking branch is main branch or branch
			$filter_data = array('branch_id'=>$this->session->userdata('under_id'));
			$branch_type = $this->branch->branch_type($this->session->userdata('under_id'));
			#branches listing
			if($branch_type == 1){
				$branches = $this->branch->listing(array('company_id'=>$this->session->userdata('company_id')));
				$branches[''] = 'Select a branch';
				ksort($branches);
			} else {
				$branches = $this->branch->listing(array('company_id'=>$this->session->userdata('company_id'),'id'=>$this->session->userdata('under_id')));
				$branches[''] = 'Select a branch';
				ksort($branches);
			}
			$areas = $this->area->get_all(array('conditions'=>array('status'=>1)));
			if(!empty($areas)){
				#flot JS
				$this->template->script('londinium/scripts/plugins/charts/flot');
				$this->template->script('londinium/scripts/plugins/charts/flot.orderbars');
				$this->template->script('londinium/scripts/plugins/charts/flot.animator.min');
				$this->template->other_script('graphs/jquery.flot.axislabels');
				$this->template->append('graphs/bars/area_wise_sales_graph',array('areas'=>$areas_list,'sales'=>$sales_new));
			}

			$this->template->title($this->lang->line('area_wise_sales'));
			$this->template->main_heading($this->lang->line('area_wise_sales'));
			$this->template->breadcrumb(array($this->lang->line('graphs')=>'no_link',$this->lang->line('ar').' '.$this->lang->line('performance-graph')=>'graphs/ar_performance',$this->lang->line('area_wise_sales')=>'no_link'));
			$this->template->slice('graphs/bars/area_wise_select',array('branches'=>$branches,'data'=>$filter_data,'from_date'=>$from_date,'to_date'=>$to_date));
			$this->template->render();
		}
	#-------------------------------------------------------	

	}
?>