<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
	
	class Holidays extends MY_Controller{

		function __construct(){
			parent :: __construct();
			$this->load->model('holidays/Holiday_model','hday');
			
			#---------------- Checking Financial year is enabled / closed-----------------#
			$method_array = array('h_delete');
			fiscal_status($this->uri->segment(2),$method_array,"holidays/set");	
			#---------------- Checking Financial year is enabled / closed-----------------#
			
		}

	#---------------------------------------------
		
		#date : 26-8-2014
		#purpose : set holidays
		function set(){

			$this->template->title('Holiday settings');
			$this->template->main_heading($this->lang->line('holiday-settings'));
			$this->template->breadcrumb(array($this->lang->line('settings')=>'preferences/index',$this->lang->line('holidays')=>'no_link'));

			$this->form_validation->set_rules('h_date','lang:date','required|is_date|trim|xss_clean');
			$this->form_validation->set_rules('h_type','lang:type','required|trim|xss_clean');
			$this->form_validation->set_rules('comments','lang:comments','required|trim|xss_clean');

			if($this->form_validation->run() == TRUE){
				
				$data = $this->input->post(NULL,TRUE);
				$data['h_date'] = date('Y-m-d',strtotime($data['h_date']));

				if($this->hday->is_exists($data)){

					$this->message->set($this->lang->line('duplicate-hday-entry'),'e');
				}else{	

					if($this->hday->save_a('holiday_master',$data)){
						$this->message->set($this->lang->line('holiday-saved'));
					}else{
						$this->message->set($this->lang->line('holiday-not-saved'));
					}
					redirect('holidays/set');
				}	
			}

			$holidays = $this->hday->get_all(array('order_by'=>'h_date','order'=>'desc'));

			$this->template->slice('dms/message');
			$this->template->slice('holidays/set');

			if(!empty($holidays)){
				$this->template->slice('holidays/report',array('holidays'=>$holidays));
			}
				
			$this->template->render();
		}

	#---------------------------------------------
		#date : 26-8-2014
		function h_delete($id = NULL){

			if(!$id){ redirect('access/');}
			if($this->if_exists('holiday_master',array('id'=>$id,'status'=>1)) === false){
				redirect('holidays/set');
			}

			if($this->db->delete('holiday_master',array('id'=>$id))){
				$this->message->set($this->lang->line('holiday-deleted'));
			}else{
				$this->message->set($this->lang->line('holiday-not-deleted'));
			}

			redirect('holidays/set');

		}
	#---------------------------------------------	



	}
?>