<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

class Ledger_monthly_reports extends MY_Controller{

	public function __construct()
	{
		parent :: __construct();		
		$this->check_access_right();

		$this->load->library('Accounts');
	}
	
	public function index($id = NULL)
	{
		$fiscal_start_date = $this->dms->get_fiscal_year()['start_date'];
		$ledger_id = $dc = $sub_group_id = $tbp = "";$opening_bal = 0;$voucher_array = array();
		$from_date = $to_date = date('Y-m-d'); //$fiscal_start_date;
		
		#-------------breadcrumb
		$breadcrumb = array($this->lang->line('account-reports') => 'no_link',$this->lang->line('monthly-ledger-report') => 'no_link');
		
		if(isset($_POST['btn_search']))
		{
			#-------------validation
			$this->form_validation->set_rules('ledger_id','lang:ledgers','required|xss_clean');
			$this->form_validation->set_rules('from_date','lang:from-date','required|xss_clean|valid_date');
			if($this->input->post('from_date',true))
			{
				$from_date = $this->input->post('from_date',true);
				$this->form_validation->set_rules('to_date','lang:to-date',"required|xss_clean|valid_date|check_date[$from_date.>=]");
			}
			if($this->form_validation->run() === true)
			{
				$ledger_id = $this->input->post('ledger_id',true);
				$from_date = date('Y-m-d',strtotime($this->input->post('from_date',true)));
				$to_date = date('Y-m-d',strtotime($this->input->post('to_date',true)));	
				$this->session->set_userdata(array('from_date' => $from_date,'to_date' => $to_date));		
			}
		}
		else
		{
			if($this->uri->segment(3))
			{
				$ledger_id = xss_clean($this->uri->segment(3));				
			}
			if($this->uri->segment(4))
			{
				$sub_group_id = xss_clean($this->uri->segment(4));				
				$breadcrumb[$this->lang->line('go-back')] = "account_group_reports/index/".$sub_group_id;
			}
			if($this->uri->segment(5))
			{
				$tbp = $this->uri->segment(5);		
				$breadcrumb[$this->lang->line('go-back')] .= "/".$tbp;
			}
			if($this->session->userdata('from_date') && $this->session->userdata('to_date'))
			{
				$from_date = $this->session->userdata('from_date');
				$to_date = $this->session->userdata('to_date');				
				
				#----------validating dates
				if(!$this->form_validation->valid_date($from_date) || !$this->form_validation->valid_date($to_date)){
					redirect('users/logout');
				}
				else{
					if(!$this->form_validation->check_date($from_date,$to_date.".<=")){
						redirect('users/logout');
					}
				}
			}
		}
		
		if(!empty($ledger_id) && !empty($from_date) && !empty($to_date))
		{
			$from_time = strtotime($from_date);
			$to_time = strtotime($to_date);
			$from_year = date('Y',$from_time);
			$to_year = date('Y',$to_time);
			$from_month = date('n',$from_time);
			$to_month = date('n',$to_time);
			$month_array = $this->dms->get_months($from_date,$to_date,1);
			$dc = $this->accounts->get_dc($ledger_id);
			$opening_bal = $this->accounts->opening_bal($ledger_id,$from_date);
			$month_start_date = $from_year."-".$from_month."-01";
			$open_voucher_bal = $this->accounts->voucher_bal($ledger_id,$month_start_date);
			if($dc == 'dr')
			{
				$opening_bal += ($open_voucher_bal['dr_amount'] - $open_voucher_bal['cr_amount']);
			}
			else
			{
				$opening_bal += ($open_voucher_bal['cr_amount'] - $open_voucher_bal['dr_amount']);
			}
			foreach($month_array as $key => $value)
			{											
				$voucher_bal = $this->accounts->voucher_bal($ledger_id,$value['to_date'],0,$value['from_date']);
				$voucher_array[$key] = array('month' => $value['month'],'dr_amount' => $voucher_bal['dr_amount'],'cr_amount' => $voucher_bal['cr_amount'],'from_date' => $value['from_date'],'to_date' => $value['to_date']);
			}
		}
				
		#-------------ledger details
		$ledger_array = $this->accounts->get_legders();
		$ledger_array[''] = "Select";
		ksort($ledger_array);
		
		#-------------template
		$this->template->title('Monthly Ledger Wise Report');
		$this->template->main_heading('Monthly Ledger Wise Report');
		$this->template->breadcrumb($breadcrumb);
		$this->template->slice('account_reports/ledger_search',array('ledgers' => $ledger_array,'ledger_id' => $ledger_id,'from_date' => $from_date,'to_date' => $to_date));	
		if(!empty($voucher_array))
		{
			$access_rights = $this->have_access(434);
			$this->template->append('account_reports/monthly_ledgers',array('voucher_array' => $voucher_array,'sub_group_id' => $sub_group_id,'ledger_id' => $ledger_id,'opening_bal' => $opening_bal,'dc' => $dc,'access_rights' => $access_rights,'tbp' => $tbp,'from_date' => $from_date,'to_date' => $to_date));
		}
		else{
			$this->message->set($this->lang->line('no-result-found'),'i');
		}
		$this->template->slice('dms/message');
		$this->template->render();
	}
}