<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

class Ledger_reports extends MY_Controller{

	public function __construct()
	{
		parent :: __construct();
		$this->check_access_right();
        $this->userID = $this->session->userdata('id');
		$this->load->library('Accounts');
		$this->load->model('accounts/ledger_report/Ledger_report_model','ledger');
	}

	public function index(){
		$fiscal_start_date = $this->dms->get_fiscal_year()['start_date'];
		$from_date = $to_date = date('Y-m-d'); //$fiscal_start_date;
		$vouchers_array = array(); $ledger_id = $dc = $sub_group_id = ""; $opening_bal = 0;
        $branch_id = '';
		$breadcrumb = array($this->lang->line('account-reports') => 'no_link',$this->lang->line('ledgers') => 'no_link');
		$breadcrumb_url = $tbp = "";
		if(isset($_POST['btn_search'])){
			$this->form_validation->set_rules('ledger_id','lang:ledgers','required|xss_clean');
			$this->form_validation->set_rules('from_date','lang:from-date','required|xss_clean|valid_date');
			if($this->input->post('from_date',true)){
				$from_date = $this->input->post('from_date',true);
				$this->form_validation->set_rules('to_date','lang:to-date',"required|xss_clean|valid_date|check_date[$from_date.>=]");
			}
			if($this->form_validation->run() === true){
			    $branch_id = $this->input->post('branch_id',true);
				$ledger_id = $this->input->post('ledger_id',true);
				$user_id = $this->input->post('particulars',true);
				$from_date = date('Y-m-d',strtotime($this->input->post('from_date',true)));
				$to_date = date('Y-m-d',strtotime($this->input->post('to_date',true)));
				$this->session->set_userdata(array('from_date' => $from_date,'to_date' => $to_date));
			}
		}else{
			if($this->uri->segment(3)){
				$ledger_id = xss_clean($this->uri->segment(3));
				$breadcrumb_url = "ledger_monthly_reports/index/".$ledger_id;
				$breadcrumb[$this->lang->line('go-back')] = $breadcrumb_url;
			}
			if($this->uri->segment(6) || $this->uri->segment(4)){
				if($this->uri->segment(4) == 'sid'){
					$sub_group_id = xss_clean($this->uri->segment(5));
				}else{
					$sub_group_id = xss_clean($this->uri->segment(6));
				}
				$breadcrumb_url .= "/".$sub_group_id;
				$breadcrumb[$this->lang->line('go-back')] = $breadcrumb_url;
			}
			if($this->uri->segment(7)){
				$tbp = xss_clean($this->uri->segment(7));
				$breadcrumb_url .= "/".$tbp;
				$breadcrumb[$this->lang->line('go-back')] = $breadcrumb_url;
			}
			if(($this->uri->segment(4) && $this->uri->segment(4) != 'sid') && $this->uri->segment(5)){
				$from_date = date('Y-m-d',strtotime($this->uri->segment(4)));
				$to_date = date('Y-m-d',strtotime($this->uri->segment(5)));
				#----------validating dates
				if(!$this->form_validation->valid_date($from_date) || !$this->form_validation->valid_date($to_date)){
					redirect('users/logout');
				}else{
					if(!$this->form_validation->check_date($from_date,$to_date.".<=")){
						redirect('users/logout');
					}
					/*else{
						$this->session->set_userdata(array('from_date' => $from_date,'to_date' => $to_date));
					}*/
				}
			}elseif($this->session->userdata('from_date') && $this->session->userdata('to_date')){
				$from_date = $this->session->userdata('from_date');
				$to_date = $this->session->userdata('to_date');
				#----------validating dates
				if(!$this->form_validation->valid_date($from_date) || !$this->form_validation->valid_date($to_date)){
					redirect('users/logout');
				}else{
					if(!$this->form_validation->check_date($from_date,$to_date.".<=")){
						redirect('users/logout');
					}
				}
			}
		}
        if($branch_id==''){
            $branch_id = $this->session->userdata('under_id');
        }

		if(!empty($ledger_id) && !empty($from_date) && !empty($to_date)){
			$dc = $this->accounts->get_dc($ledger_id);
			$vouchers_array = array();
			if($user_id !=''){ 
			    $vouchers = $this->ledger->getVouchers1($branch_id,$ledger_id,$user_id,$from_date,$to_date);
			}else{
			    $vouchers = $this->ledger->getVouchers($branch_id,$ledger_id,$from_date,$to_date);
			}
			if(!empty($vouchers)){ 
				foreach($vouchers as $key => $value){ 
					$vouchers_array[$value['group_id']] = $this->ledger->getVoucherBill1($value['group_id'],$ledger_id); 
					$vamount = $this->ledger->getBillAmount($value['group_id'],$ledger_id);
					$dr_amount = $cr_amount = 0;
					if($dc == 'dr'){
						$bill_amount = ($vamount['dr_amount'] - $vamount['cr_amount']);
						if($bill_amount > 0){
							$dr_amount = $bill_amount;
						}elseif($bill_amount < 0){
							$cr_amount = -$bill_amount;
						}
					}else{
						$bill_amount = ($vamount['cr_amount'] - $vamount['dr_amount']);
						if($bill_amount > 0){
							$cr_amount = $bill_amount;
						}elseif($bill_amount < 0){
							$dr_amount = -$bill_amount;
						}
					}
					if($vouchers_array[$value['group_id']]['dr_ledger'] == $ledger_id){
						$particular_id = $vouchers_array[$value['group_id']]['cr_ledger'];
					}else{
						$particular_id = $vouchers_array[$value['group_id']]['dr_ledger'];
					}
					$ledger_name = $this->accounts->get_ledger_name($particular_id);
					$vouchers_array[$value['group_id']]['ledger_name'] = $ledger_name;
					$vouchers_array[$value['group_id']]['dr_amount'] = $dr_amount;
					$vouchers_array[$value['group_id']]['cr_amount'] = $cr_amount;
				}
			}

			$opening_bal = $this->accounts->branch_opening_bal($ledger_id,$branch_id,$from_date);
			$open_voucher_bal = $this->accounts->branch_voucher_bal($ledger_id,$branch_id,$from_date);
			if($dc == 'dr'){
				$opening_bal += ($open_voucher_bal['dr_amount'] - $open_voucher_bal['cr_amount']);
			}else{
				$opening_bal += ($open_voucher_bal['cr_amount'] - $open_voucher_bal['dr_amount']);
			}
		}
		#-------------ledger details
	//	$ledger_array = $this->accounts->get_legders(array('conditions' => array('branch_id' => $this->session->userdata('under_id'),'branch_id'=>0)));
		$ledger_array = $this->accounts->get_legders();

		$ledger_array[''] = "Select";
		ksort($ledger_array);
		
		$users = $this->dms->get_users(array('conditions' => array('branch_id' => $this->session->userdata('under_id'),'id>'=>0)));
		$users[''] = 'Select';ksort($users);
        
        $this->load->model('branches/Branch_model','branch');
		$branches = $this->branch->listing(array('company_id'=>$this->session->userdata('company_id')));
		$branches[''] = 'Select';
		ksort($branches);    
        
		#-------------template
		$this->template->title('Ledger Wise Report');
		$this->template->main_heading('Ledger Wise Report');
		$this->template->breadcrumb($breadcrumb);
		$this->template->slice('account_reports/ledger_search',array('branches'=>$branches,'branch_id'=>$branch_id,'ledgers' => $ledger_array,'ledger_id' => $ledger_id,'from_date' => $from_date,'to_date' => $to_date,'users'=>$users,'user'=>$user_id));
		if(!empty($vouchers_array) || $opening_bal != 0){
			$this->template->append('account_reports/ledgers',array('voucher_array' => $vouchers_array,'ledger_id' => $ledger_id,'sub_group_id' => $sub_group_id,'opening_bal' => $opening_bal,'dc' => $dc,'tbp' => $tbp));
		}else{
			$this->message->set($this->lang->line('no-result-found'),'i');
		}
		$this->template->slice('dms/message');
		$this->template->render();
	}
}