<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

class My_bills extends MY_Controller{

	#===============================================
	var $companyID;
	var $branchID;
	var $createdBY;
	var $fiscal_start_date;
	var $fiscal_end_date;

	public function __construct(){
		parent::__construct();
		$this->check_access_right();

		$this->companyID = $this->session->userdata('company_id');
		$this->branchID = $this->session->userdata('under_id');
		$this->createdBY = $this->session->userdata('id');
		$fiscals = $this->dms->get_fiscal_year();
		$this->fiscal_start_date = $fiscals['start_date'];
		$this->fiscal_end_date = $fiscals['end_date'];

		$this->load->model('sales/Sales_model','sales_obj');
		$this->load->model('vouchers/Voucher_model','vouchers');
		$this->load->library(array('Stock','Targets'));

		#----------voucher type
		$this->vtype = 6;

	}

	#---------------------------------------------------------------------------------------

	public function purchase_bills(){

		$this->template->title($this->lang->line('my-purchases'));
		$this->template->main_heading($this->lang->line('my-purchases'));
		$this->template->breadcrumb(array($this->lang->line('my-purchases') => 'no_link'));
		$payment_modes = array();
		$args = array();
		$args['columns'] = array('id','branch_id','designation_id','department_id');
		$args['conditions'] = array('id'=>$this->createdBY);
		$userDetails = $this->dms->get_users($args)[$this->createdBY];
		$this->load->library('Stock');
		$mainBranch = $this->dms->get_main_branch();# get main branch id
		$payment_modes = $this->stock->payment_modes();
		$user_type = $links= $selMode = $selDate = NULL;$offset=0;

		if(!empty($userDetails)){
			$departmentID = $userDetails['department_id'];
			$designationID = $userDetails['designation_id'];
			$userBranch = $userDetails['branch_id'];
			if($designationID == 3){
				$user_type = 3;
			}else{
				$user_type = 1;
			}
		}

		$this->load->model('sales/Sales_model','sales');
		$url_string = NULL;$uriSegment = 3;
		$this->form_validation->set_rules('payment_mode','lang:payment-mode','xclean');
		$this->form_validation->set_rules('date','lang:date','xss_clean|valid_date|is_date');
		$status = 0;
		if($this->form_validation->run() === true){

			if($this->input->post('payment_mode') && !empty($this->input->post('payment_mode'))){
				$payment_mode = $this->input->post('payment_mode');
			}

			if($this->input->post('date') && !empty($this->input->post('date'))){
				$search_date = date('Y-m-d',strtotime($this->input->post('date')));
			}
		}else{
			if($this->uri->segment(3)){
				$uriArray = $this->uri->uri_to_assoc(3);
				if(array_key_exists('mode',$uriArray)){
					$payment_mode = $uriArray['mode'];
				}
				if(array_key_exists('date',$uriArray)){
					$search_date = date('Y-m-d',strtotime($uriArray['date']));
				}
				if(array_key_exists('status',$uriArray)){
					$status = $uriArray['status'];
				}
			}
		}

		$conditions = array('branch_id'=>$mainBranch,'customer_type_id'=>$user_type,'customer_id'=>$userBranch,'status'=>1);


		if(!empty($status)){
			if($status == 1){
				$conditions['bill_status <='] = 1;
			}else{
				$conditions['bill_status'] = 2;
			}
		}else{
			$conditions['bill_status <='] =2;
		}
		if(!empty($payment_mode)){
			$conditions['payment_mode'] = $payment_mode;
			$url_string .= '/mode/'.$payment_mode;
			$selMode = $payment_mode;
			$uriSegment += 2;
		}
		if(!empty($search_date)){
			#------sps--------------
			$conditions['bill_date'] = $search_date;
			#------end--------------
			$url_string .= '/date/'.$search_date;
			$selDate = $search_date;
			$uriSegment += 2;
		}

		$this->load->library('Pagination');
		$config['per_page'] = $this->per_page();
		$args = array();
		$args['columns'] = array('id');
		$args['numrows'] = 1;
		$args['conditions'] = $conditions;
		$config['total_rows'] = $this->sales->get_bills($args);
		$offset = ($this->uri->segment($uriSegment))?$this->uri->segment($uriSegment):0;
		$config['base_url'] = base_url('my_bills/purchase_bills'.$url_string);
		$config['uri_segment'] = $uriSegment;
		# Pagination Config Customizations
        $config['full_tag_open'] = '<ul class="pagination">';
        $config['full_tag_close'] = '</ul>';
        $config['first_link'] = 'First';
        $config['last_link'] = 'Last';
        $config['next_link'] = '&raquo;';
        $config['prev_link'] = '&laquo;';
        $config['cur_tag_open'] = '<li class="active"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
		$this->pagination->initialize($config);
		$links = $this->pagination->create_links();

		$args = array();
		$args['columns'] = array('id','vtype_id','bill_no','bill_date','group_id','customer_type_id','customer_id','user_id','area_id','bill_discount_per','bill_discount_amt','bill_freight','other_expense','cess','payment_mode','bill_status');
		$args['conditions'] = $conditions;
		$args['limit'] = $config['per_page'];
		$args['offset'] = $offset;
		$args['order_by'] = 'bill_date';
		$args['order'] = 'desc';
		$sales = $this->sales->get_bills($args);
		$presumptive_tax = $this->stock->get_tax_type();

		$sales_report = array();
		foreach($sales as $sKey=>$sale){

			if($sale['bill_status'] == 0){
				$this->sales->update_others(array('table'=>'dms_sales','data'=>array('bill_status'=>1),'conditions'=>array('id'=>$sale['id'])));
			}
			$paymentMode = '';$total_amount = $total_tax_amount = $presum_amount = 0;
			$group_id = $sale['group_id'];
			$sales_details = $this->sales->get_sales_items(array('columns' => array('item_id','qty','rate','amount','discount_amt','vat_percent','vat_amt','cst'),'conditions' => array('group_id' => $group_id,'status' => 1,'item_status >' => 0)));

			foreach($sales_details as $siKey => $sales_item){

				$tax_amount = $vat = 0;
				$net_value = ($sales_item['amount']-$sales_item['discount_amt']);
				if(empty($presumptive_tax)){
					if($sales_item['cst'] == 0){
						$vat = $this->stock->get_item_vat($sales_item['item_id']);
						$tax_amount = $sales_item['vat_amt'];//($vat*$net_value)/100;
					}else{
						$tax_amount = ($sales_item['cst']*$net_value)/100;
					}
				}
				$total_tax_amount += $tax_amount;
				$total_amount += $net_value;
			}
			$total_amount += $total_tax_amount;
			if(!empty($presumptive_tax)){
				$presum_amount = ($presumptive_tax[0]*$total_amount)/100;
				$total_amount += $presum_amount;
			}
			$cess_amount = (($total_tax_amount+$presum_amount)*$sale['cess'])/100;
			$total_amount += (($cess_amount+$sale['bill_freight']+$sale['other_expense'])-$sale['bill_discount_amt']);
			$paymentMode = $this->stock->ledger_name($sale['payment_mode']);
			$sales_report[$sale['id']] = array('id'=>$sale['id'],'vtype_id'=>$sale['vtype_id'],'bill_no'=>$sale['bill_no'],'bill_date'=>$sale['bill_date'],'payment_mode'=>$paymentMode,'bill_status'=>$sale['bill_status'],'amount'=>$total_amount,'customer_type'=>$sale['customer_type_id']);
		}
		if(empty($sales_report)){
			$this->message->set($this->lang->line('no-purchases-found'),'e');
		}
		$payment_modes[''] = 'Select';
		# view starts here--------------------------------
		$this->template->slice('dms/message');
		$this->template->slice('my_bills/purchases',array('purchase_report'=>$sales_report,'payment_modes'=>$payment_modes,'count'=>$offset+1,'links'=>$links,'p_mode'=>$selMode,'srch_date'=>$selDate));
		$this->template->other_script('sales/sales');
		$this->template->slice('dms/modals/more_details');
		$this->template->render();
	}

	#---------------------------------------------------------------------------------------

	public function purchase_to_stock(){

		if(!$this->uri->segment(3)){
			redirect('my_bills/purchase_bills');
		}
		$salesID = $this->uri->segment(3);
		$args = array();
		$args['columns'] = array('id','branch_id','designation_id','department_id');
		$args['conditions'] = array('id'=>$this->createdBY);
		$userDetails = $this->dms->get_users($args)[$this->createdBY];
		$insert_count=0;

		if(!empty($userDetails)){
			$departmentID = $userDetails['department_id'];
			$designationID = $userDetails['designation_id'];
			$userBranch = $userDetails['branch_id'];
			if($designationID === 3){
				$user_type = 3;
			}else{
				$user_type = 1;
			}
		}else{
			redirect('users/logout');
		}

		if($this->if_exists('dms_sales',array('id'=>$salesID,'customer_type_id'=>$user_type,'customer_id'=>$userBranch,'status'=>1)) === false){
			$this->message->set($this->lang->line('invalid-purchase'),'e');
			redirect('my_bills/purchase_bills');
		}
		$this->load->model('sales/Sales_model','sales');
		$this->load->model('purchase/Purchase_model','purchase');
		$this->load->model('vouchers/Voucher_model','vouchers');
		$this->load->library(array('Stock'));

		$vtype = 5;
		$result_array = $this->purchase->next_bill_no($vtype);
		$vtype_id = $result_array['vtype_id'];
		$voucher_no = $result_array['bill_no'];
		$voucher_date = $result_array['bill_date'];

		$purchaseTemp = $this->purchase->get_purchases(array('columns' => array('a.group_id','a.p_status'),'conditions' => array('a.created_by' => $this->createdBY,'vtype_id' => $vtype_id,'a.status =' => -1)));
		#,'b.status =' => -1

		if(!empty($purchaseTemp)){
			$this->message->set($this->lang->line('pending-purchase-exists'),'e');
			if($purchaseTemp[0]['p_status'] == 4){
				redirect('sales_to_purchase/add');
			}else{
				redirect('purchase/add');
			}
		}
		$mainBranch = $this->dms->get_main_branch();# get main branch id
		$sales_array = $this->sales->get_sales(array('columns' => array('a.id as sales_id','a.vtype_id','a.branch_id','a.bill_no','a.bill_date','a.group_id','a.customer_type_id','a.customer_id','a.user_id','a.area_id','a.bill_discount_per','a.bill_discount_amt','a.bill_freight','a.other_expense','a.cess','a.narration','a.pricelist_id','a.payment_mode','a.cr_period','a.bill_status','a.created_by','a.created_on','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.discount_per','b.discount_amt','b.godown_id','b.vat_percent','b.vat_amt','b.cst'),'conditions' => array('a.id' => $salesID,'a.branch_id'=>$mainBranch,'a.status !=' => 0,'b.status !=' => 0,'b.item_status >' => 0)));

		if(empty($sales_array)){
			$this->message->set($this->lang->line('invalid-purchase'),'e');
			redirect('my_bills/purchase_bills');
		}else{

			$this->db->trans_start();
			$group_id = $this->stock->get_group_id('dms_purchase_items');
			$salesID = $sales_array[0]['sales_id'];
			$salesBranchID = $sales_array[0]['branch_id'];
			$salesBill = $sales_array[0]['bill_no'];
			$salesDate = $sales_array[0]['bill_date'];
			$salesBillDiscPer = $sales_array[0]['bill_discount_per'];
			$salesBillDiscAmt = $sales_array[0]['bill_discount_amt'];
			$salesBillFreight = $sales_array[0]['bill_freight'];
			$salesOtherExp = $sales_array[0]['other_expense'];
			$salesCess = $sales_array[0]['cess'];
			$salesPayMode = $sales_array[0]['payment_mode'];
			$salesCRPrd = $sales_array[0]['cr_period'];
			$salesGroupID = $sales_array[0]['group_id'];
			$bill_status = $sales_array[0]['bill_status'];
			#-------------------------------------------------------------------------------------------

			$delivery_exists = 1;
			$args = array();
			$args['columns'] = array('ddn.id as dnote_id','ddn.bill_status as dnote_bill_status');
			$args['table'] = 'dms_sales as ds';
			$args['conditions'] = array('ds.id'=>$salesID);
			$args['join'] = array('table'=>'dms_delivery_notes as ddn','on'=>'ds.group_id=ddn.group_id','type'=>'inner');
			$check_sales = $this->dms->get_data($args);

			if(!empty($check_sales)){

				$dnoteID = $check_sales[0]['dnote_id'];
				$dnoteStatus = $check_sales[0]['dnote_bill_status'];
				# 2 = approve and added to stock as receipt-note

				$args = array();
				$args['columns'] = array('id','group_id');
				$args['table'] = 'dms_receipt_notes';
				$args['conditions'] = array('branch_id'=>$this->branchID,'pid'=>$dnoteID,'p_status'=>4);
				$check_receipt = $this->dms->get_data($args);

				if(empty($check_receipt) && $dnoteStatus != 2){
					$delivery_exists = 0;
				}else{
					if(!empty($check_receipt)){
						$group_id = $check_receipt[0]['group_id'];
					}
				}
			}

			#-----------------------------------------------------------------------------------------
			if(!empty($delivery_exists)){

			$args = array();
			$args['columns'] = array('id');
			$args['conditions'] = array('p_status'=>4,'pid'=>$salesID);
			$purchase = $this->purchase->get_bills($args);
			if($bill_status < 2 || empty($purchase)){

				#-------------------------------------------------------------------------------
				#if($salesPayMode != 2){
					$sales_voucher_banks = array();$sales_vouchers = array();

					$voucher_group_id = $this->stock->get_group_id('dms_vouchers');
					$args = array();
					$args['columns'] = array('id','company_id','branch_id','group_id','vtype_id','vno','vorder_no','vorder_no','vdate','dr_ledger','cr_ledger','vamount','narration','table_name','table_group_id','status');
					$args['table'] = 'dms_vouchers';
					$args['conditions'] = array('table_name'=>'dms_sales','table_group_id'=>$salesGroupID);
					$sales_vouchers = $this->dms->get_data($args);

					$salesDR = $sales_vouchers[0]['dr_ledger'];
					$salesVamount = $sales_vouchers[0]['vamount'];
					$salesVoucherGpID = $sales_vouchers[0]['group_id'];
					$purchasePaymentMode = $salesPayMode;
					$voucher_status =1;
					if($salesPayMode >2){

						$args = array();
						$args['columns'] = array('id','group_id','cash_type','cd_no','pdc','vdate','cq_status','status');
						$args['table'] = 'dms_voucher_banks';
						$args['conditions'] = array('group_id'=>$salesVoucherGpID);
						$sales_voucher_banks = $this->dms->get_data($args);
						if(!empty($sales_voucher_banks)){
							$sales_cash_type = $sales_voucher_banks[0]['cash_type'];
							$cheque_num = $sales_voucher_banks[0]['cd_no'];
							$salesPDC = $sales_voucher_banks[0]['pdc'];
							if($sales_cash_type == 1){
								$voucher_status = 3;
							}
						}
					}else if($salesPayMode == 2){

						$vendorDetails = $this->dms->get_data(array('table' =>'branch_master','columns' => 'ledger_id','conditions' => array('id' => $salesBranchID)));
						$salesPayMode = $vendorDetails[0]['ledger_id'];//customer
					}

					$voucher_array = array('company_id' => $this->companyID,'branch_id'=> $this->branchID,'group_id' => $voucher_group_id,'vtype_id' =>5,'vno' =>$voucher_no,'vorder_no' => 1,'vdate' =>$salesDate,'dr_ledger' => 3,'cr_ledger' => $salesPayMode,'vamount' =>$salesVamount,'table_name' => 'dms_purchases','table_group_id' => $group_id,'status' => $voucher_status);

					$savePurchase = array('vtype_id'=>5,'branch_id'=>$this->branchID,'bill_no'=>$voucher_no,'bill_date'=>$salesDate,'invoice_no'=>$salesBill,'invoice_date'=>$salesDate,'group_id'=>$group_id,'pid'=>$salesID,'p_status'=>4,'vendor_id'=>$mainBranch,'bill_discount_per'=>$salesBillDiscPer,'bill_discount_amt'=>$salesBillDiscAmt,'bill_freight'=>$salesBillFreight,'other_expense'=>$salesOtherExp,'cess'=>$salesCess,'payment_mode'=>$purchasePaymentMode,'cr_period'=>$salesCRPrd,'status'=>-1);

					if($this->purchase->insert('dms_purchases',$savePurchase)){

					$purchase_voucher = $this->dms->get_data(array('table' => 'dms_vouchers','columns' => 'group_id','conditions' => array('table_name' => 'dms_purchases','table_group_id' => $group_id)));
					if(empty($purchase_voucher)){
						$vorder_no=0;
						foreach($sales_vouchers as $sales_voucher){
							$vorder_no++;
							$voucher_array['vorder_no'] = $vorder_no;
							$voucher_array['vamount'] = $sales_voucher['vamount'];
							if($sales_voucher['cr_ledger'] == 4){
								$voucher_array['dr_ledger'] = 3;
							}else if($sales_voucher['cr_ledger'] == 12){
								$voucher_array['dr_ledger'] = 11;
							}else if($sales_voucher['cr_ledger'] == 15){
								$voucher_array['dr_ledger'] = 15;
							}else if($sales_voucher['dr_ledger'] == 13){
								$voucher_array['dr_ledger'] = 13;
							}else if($sales_voucher['dr_ledger'] == 14){
								$voucher_array['dr_ledger'] = 14;
							}
							$this->purchase->insert('dms_vouchers',$voucher_array);
						}
						if($salesPayMode > 2 && !empty($sales_voucher_banks)){
							$this->purchase->insert('dms_voucher_banks',array('group_id' => $voucher_group_id,'cash_type' => $sales_cash_type,'cd_no' => $cheque_num,'pdc' => $salesPDC,'vdate' => $voucher_date));
						}
					}else{

						if($this->purchase->update_others(array('table' => 'dms_vouchers','data' => array('vno' =>$voucher_no,'vdate' =>$voucher_date,'vamount' => $salesVamount,'status' => $voucher_status),'conditions' => array('group_id' => $purchase_voucher[0]['group_id'])))){
							if($salesPayMode > 2){
								$this->purchase->update_others(array('table' => 'dms_voucher_banks','data' => array('cd_no' => $cheque_num,'pdc' => $salesPDC,'vdate' => $voucher_date),'conditions' => array('group_id' => $purchase_voucher[0]['group_id'])));
							}
						}
					}
				#}

				#--------------------------------------------------------------------------------
					if(empty($check_receipt)){
						foreach($sales_array  as $key=>$sales_item){

							$purchaseItems = array('group_id'=>$group_id,'item_id'=>$sales_item['item_id'],'godown_id'=>0,'qty'=>$sales_item['qty'],'unit_id'=>$sales_item['unit_id'],'rate'=>$sales_item['rate'],'amount'=>$sales_item['amount'],'discount_per'=>$sales_item['discount_per'],'discount_amt'=>$sales_item['discount_amt'],'vat_percent'=>$sales_item['vat_percent'],'vat_amt'=>$sales_item['vat_amt'],'cst'=>$sales_item['cst'],'item_status'=>2,'status'=>-1);
							$this->purchase->insert('dms_purchase_items',$purchaseItems);
						}
					}
				}
				$this->db->trans_complete();
				redirect('sales_to_purchase/add');
			}else{
				$this->message->set($this->lang->line('sales-purchase-converted'),'e');
				redirect('my_bills/purchase_bills');
			}
		}else{
			$this->message->set($this->lang->line('sales-purchase-rnote-pending'),'e');
			redirect('my_bills/purchase_bills');
		}
		}
	}

	#---------------------------------------------------------------------------------------

	public function delivery_notes(){

		$this->template->title($this->lang->line('receipt-note'));
		$this->template->main_heading($this->lang->line('receipt-note'));
		$this->template->breadcrumb(array($this->lang->line('receipt-note') => 'no_link'));
		$payment_modes = array();

		$args = array();
		$args['columns'] = array('id','branch_id','designation_id','department_id');
		$args['conditions'] = array('id'=>$this->createdBY);
		$userDetails = $this->dms->get_users($args)[$this->createdBY];
		$this->load->library('Stock');
		$mainBranch = $this->dms->get_main_branch();# get main branch id
		$dnote_status = array(''=>'Select',1=>'Pending',2=>'Approved');
		$user_type = $links= $selMode = $selDate = NULL;$offset=0;

		if(!empty($userDetails)){
			$departmentID = $userDetails['department_id'];
			$designationID = $userDetails['designation_id'];
			$userBranch = $userDetails['branch_id'];
			if($designationID == 3){
				$user_type = 3;
			}else{
				$user_type = 1;
			}
		}

		$this->load->model('sales/Delivery_note_model','delivery_note');
		$url_string = NULL;$uriSegment = 3;
		$this->form_validation->set_rules('dnote_sts','lang:dnote-status','xclean');
		$this->form_validation->set_rules('date','lang:date','xss_clean|valid_date|is_date');

		if($this->form_validation->run() === true){

			if($this->input->post('dnote_sts') && !empty($this->input->post('dnote_sts'))){
				$d_status = $this->input->post('dnote_sts');
			}

			if($this->input->post('date') && !empty($this->input->post('date'))){
				$search_date = date('Y-m-d',strtotime($this->input->post('date')));
			}
		}else{
			if($this->uri->segment(3)){
				$uriArray = $this->uri->uri_to_assoc(3);
				if(array_key_exists('mode',$uriArray)){
					$d_status = $uriArray['mode'];
				}
				if(array_key_exists('date',$uriArray)){
					$search_date = date('Y-m-d',strtotime($uriArray['date']));
				}
			}
		}

		$conditions = array('branch_id'=>$mainBranch,'customer_type_id'=>$user_type,'customer_id'=>$userBranch,'status'=>1);
		if(!empty($d_status)){
			if($d_status == 1){
				$conditions['bill_status <='] = $d_status;
			}else{
				$conditions['bill_status'] = $d_status;
			}
			$url_string .= '/mode/'.$d_status;
			$selMode = $d_status;
			$uriSegment += 2;
		}else{
			$conditions['bill_status <='] = 2;
		}
		if(!empty($search_date)){
			#------sps-----------
			$conditions['bill_date'] = $search_date;
			#------end--------------
			$url_string .= '/date/'.$search_date;
			$conditions['bill_date'] = $search_date;
			$selDate = $search_date;
			$uriSegment += 2;
		}
		$this->load->library('Pagination');
		$config['per_page'] = $this->per_page();
		$args = array();
		$args['columns'] = array('id');
		$args['numrows'] = 1;
		$args['conditions'] = $conditions;
		$config['total_rows'] = $this->delivery_note->get_bills($args);

		$offset = ($this->uri->segment($uriSegment))?$this->uri->segment($uriSegment):0;
		$config['base_url'] = base_url('my_bills/delivery_notes'.$url_string);
		$config['uri_segment'] = $uriSegment;
		# Pagination Config Customizations
        $config['full_tag_open'] = '<ul class="pagination">';
        $config['full_tag_close'] = '</ul>';
        $config['first_link'] = 'First';
        $config['last_link'] = 'Last';
        $config['next_link'] = '&raquo;';
        $config['prev_link'] = '&laquo;';
        $config['cur_tag_open'] = '<li class="active"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
		$this->pagination->initialize($config);
		$links = $this->pagination->create_links();

		$args = array();
		$args['columns'] = array('id','vtype_id','bill_no','bill_date','group_id','customer_type_id','customer_id','user_id','area_id','bill_discount_per','bill_discount_amt','bill_freight','other_expense','cess','bill_status');
		$args['conditions'] = $conditions;
		$args['limit'] = $config['per_page'];
		$args['offset'] = $offset;
		$delivery_notes = $this->delivery_note->get_bills($args);
		$presumptive_tax = $this->stock->get_tax_type();

		$dnote_report = array();
		foreach($delivery_notes as $dKey=>$dnote){

			if($dnote['bill_status'] == 0){
				$this->delivery_note->update_others(array('table'=>'dms_delivery_notes','data'=>array('bill_status'=>1),'conditions'=>array('id'=>$dnote['id'])));
			}
			$paymentMode = '';$total_amount = $total_tax_amount = $presum_amount = 0;
			$group_id = $dnote['group_id'];
			$dnote_details = $this->delivery_note->get_sales_items(array('columns' => array('item_id','qty','rate','amount','discount_amt','vat_percent','vat_amt','cst'),'conditions' => array('group_id' => $group_id,'status' => 1,'item_status >' => 0)));

			foreach($dnote_details as $diKey => $dnote_item){

				$tax_amount = $vat = 0;
				$net_value = ($dnote_item['amount']-$dnote_item['discount_amt']);
				if(empty($presumptive_tax)){
					if($dnote_item['cst'] == 0){
						$vat = $this->stock->get_item_vat($dnote_item['item_id']);
						$tax_amount = $dnote_item['vat_amt'];//($vat*$net_value)/100;
					}else{
						$tax_amount = ($dnote_item['cst']*$net_value)/100;
					}
				}
				$total_tax_amount += $tax_amount;
				$total_amount += $net_value;
			}
			$total_amount += $total_tax_amount;
			if(!empty($presumptive_tax)){
				$presum_amount = ($presumptive_tax[0]*$total_amount)/100;
				$total_amount += $presum_amount;
			}
			$cess_amount = (($total_tax_amount+$presum_amount)*$dnote['cess'])/100;
			$total_amount += (($cess_amount+$dnote['bill_freight']+$dnote['other_expense'])-$dnote['bill_discount_amt']);
			$dnote_report[$dnote['id']] = array('id'=>$dnote['id'],'vtype_id'=>$dnote['vtype_id'],'bill_no'=>$dnote['bill_no'],'bill_date'=>$dnote['bill_date'],'bill_status'=>$dnote['bill_status'],'amount'=>$total_amount);
		}
		if(empty($dnote_report)){
			$this->message->set($this->lang->line('no-receipt-note-found'),'e');
		}
		$payment_modes[''] = 'Select';
		# view starts here--------------------------------
		$this->template->slice('dms/message');
		$this->template->slice('my_bills/delivery_notes',array('delivery_notes'=>$dnote_report,'dnote_status'=>$dnote_status,'count'=>$offset+1,'links'=>$links,'d_status'=>$selMode,'srch_date'=>$selDate));
		$this->template->other_script('sales/sales');
		$this->template->slice('dms/modals/more_details');
		$this->template->render();

	}

	#---------------------------------------------------------------------------------------

	public function delivery_to_receipt(){

		if(!$this->uri->segment(3)){
			redirect('my_bills/delivery_notes');
		}

		$dnoteID = $this->uri->segment(3);
		$args = array();
		$args['columns'] = array('id','branch_id','designation_id','department_id');
		$args['conditions'] = array('id'=>$this->createdBY);
		$userDetails = $this->dms->get_users($args)[$this->createdBY];
		$insert_count=0;

		if(!empty($userDetails)){
			$departmentID = $userDetails['department_id'];
			$designationID = $userDetails['designation_id'];
			$userBranch = $userDetails['branch_id'];
			if($designationID === 3){
				$user_type = 3;
			}else{
				$user_type = 1;
			}
		}else{
			redirect('users/logout');
		}

		if($this->if_exists('dms_delivery_notes',array('id'=>$dnoteID,'customer_type_id'=>$user_type,'customer_id'=>$userBranch,'status'=>1)) === false){

			$this->message->set($this->lang->line('invalid-delivery-note'),'e');
			redirect('my_bills/delivery_notes');
		}
		$this->load->model('sales/Delivery_note_model','delivery_note');
		$this->load->model('purchase/Receipt_note_model','receipt');
		$this->load->model('vouchers/Voucher_model','vouchers');
		$this->load->library(array('Stock'));

		$vtype = 9;
		$result_array = $this->receipt->next_bill_no($vtype);
		$vtype_id = $result_array['vtype_id'];
		$voucher_no = $result_array['bill_no'];
		$voucher_date = $result_array['bill_date'];

		$receiptTemp = $this->receipt->get_purchases(array('columns' => array('a.group_id','a.p_status'),'conditions' => array('a.created_by' => $this->createdBY,'vtype_id' => $vtype_id,'a.status =' => -1,'b.status =' => -1)));
		if(!empty($receiptTemp)){
			if($receiptTemp[0]['p_status'] != 4){
				$this->message->set($this->lang->line('pending-receipt-exists'),'i');
				redirect('receipt_note/add/v-type/9');
			}
		}

		$mainBranch = $this->dms->get_main_branch();# get main branch id
		$dnote_array = $this->delivery_note->get_sales(array('columns' => array('a.id as sales_id','a.vtype_id','a.bill_no','a.bill_date','a.group_id','a.customer_type_id','a.customer_id','a.user_id','a.area_id','a.bill_discount_per','a.bill_discount_amt','a.bill_freight','a.other_expense','a.cess','a.narration','a.pricelist_id','a.bill_status','a.created_by','a.created_on','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.discount_per','b.discount_amt','b.godown_id','b.vat_percent','b.vat_amt','b.cst'),'conditions' => array('a.id' => $dnoteID,'a.branch_id'=>$mainBranch,'a.status !=' => 0,'b.status !=' => 0,'b.item_status >' => 0)));

		if(empty($dnote_array)){

			$this->message->set($this->lang->line('invalid-delivery-note'),'e');
			redirect('my_bills/delivery_notes');
		}else{

			if(empty($receiptTemp)){

				$this->db->trans_start();
				$group_id = $this->stock->get_group_id('dms_purchase_items');
				$salesID = $dnote_array[0]['sales_id'];
				$salesBill = $dnote_array[0]['bill_no'];
				$salesDate = $dnote_array[0]['bill_date'];
				$salesGroupID = $dnote_array[0]['group_id'];
				$salesBillDiscPer = $dnote_array[0]['bill_discount_per'];
				$salesBillDiscAmt = $dnote_array[0]['bill_discount_amt'];
				$salesBillFreight = $dnote_array[0]['bill_freight'];
				$salesOtherExp = $dnote_array[0]['other_expense'];
				$salesCess = $dnote_array[0]['cess'];
				$bill_status = $dnote_array[0]['bill_status'];

				$args = array();
				$args['columns'] = array('id');
				$args['conditions'] = array('p_status'=>4,'pid'=>$dnoteID);
				$receipt = $this->receipt->get_bills($args);

				if($bill_status < 2 || empty($receipt)){

					$saveReceipt = array('vtype_id'=>9,'branch_id'=>$this->branchID,'bill_no'=>$voucher_no,'bill_date'=>$salesDate,'invoice_no'=>$salesBill,'invoice_date'=>$salesDate,'group_id'=>$group_id,'pid'=>$dnoteID,'p_status'=>4,'vendor_id'=>$mainBranch,'bill_discount_per'=>$salesBillDiscPer,'bill_discount_amt'=>$salesBillDiscAmt,'bill_freight'=>$salesBillFreight,'other_expense'=>$salesOtherExp,'cess'=>$salesCess,'status'=>-1);

					if($this->receipt->insert('dms_receipt_notes',$saveReceipt)){

						foreach($dnote_array  as $key=>$dnote_item){

							$dnoteItems = array('group_id'=>$group_id,'item_id'=>$dnote_item['item_id'],'godown_id'=>0,'qty'=>$dnote_item['qty'],'unit_id'=>$dnote_item['unit_id'],'rate'=>$dnote_item['rate'],'amount'=>$dnote_item['amount'],'discount_per'=>$dnote_item['discount_per'],'discount_amt'=>$dnote_item['discount_amt'],'vat_percent'=>$dnote_item['vat_percent'],'vat_amt'=>$dnote_item['vat_amt'],'cst'=>$dnote_item['cst'],'item_status'=>2,'status'=>-1);
							$this->receipt->insert('dms_purchase_items',$dnoteItems);

						}
						$this->db->trans_complete();
						redirect('delivery_to_receipt/add');
					}
				}else{
					$this->message->set($this->lang->line('delivery-receipt-converted'),'e');
					redirect('my_bills/delivery_notes');
				}
			}else{
				redirect('delivery_to_receipt/add');
			}
		}
	}

	#---------------------------------------------------------------------------------------
	#---------------------------------------------------------------------------------------
	public function pdf(){

		$pdf_name = 'sales';
		$pdf_contents = '';
		if(!$this->uri->segment(4)){
			echo "<script>alert('".$this->lang->line('invalid-sales-bill')."');window.close();</script>";
		}
		$sales_id = $this->uri->segment(4);
		if($this->if_exists('dms_sales',array('id'=>$sales_id,'status'=>1)) === false){
			echo "<script>alert('".$this->lang->line('invalid-sales-bill')."');window.close();</script>";
		}
		#----------voucher type
		$vtype_id = $this->vtype;

		#----------voucher name
		$voucher_name = $this->vouchers->voucher_name($this->vtype);
		$mainBranch = $this->dms->get_main_branch();# get main branch id


		$this->load->library('My_pdf');
		$this->load->library('To_words');


		$this->load->model('sales/Sales_vehicle_model','sales_vehicle');
		$this->load->library('My_pdf');
		$this->load->library('To_words');

		#----------sales data
		$sales_array = $this->sales_obj->get_sales(array('columns' => array('a.vtype_id','a.bill_no','a.bill_date','a.group_id','a.customer_type_id','a.customer_id','a.user_id','a.area_id','a.bill_discount_per','a.bill_discount_amt','a.bill_freight','a.other_expense','a.cess','a.narration','a.pricelist_id','a.payment_mode','a.cr_period','a.created_by','a.created_on','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.discount_per','b.discount_amt','b.godown_id','b.vat_amt','b.cst'),'conditions' => array('a.id' => $sales_id,'a.status !=' => 0,'b.status !=' => 0,'b.item_status >' => 0,'a.branch_id'=>$mainBranch)));
		//echo $sales_id;
		//$str = $this->db->last_query();
		//echo $str;
		//print_r($sales_array);die;
		if(empty($sales_array)){
			echo "<script>alert('".$this->lang->line('invalid-sales-bill')."');window.close();</script>";
		}else{
			#------------loading model
			$this->load->model('customers/Customer_type_model','customer_type');
			#------------presumptive tax checking
			$presumptive_tax = $this->stock->get_tax_type();
			#------------checking cst enabled or not
			$pdf_name = 'sales_bill_'.$sales_array[0]['bill_no'];
			$sales_cst = $this->sales_obj->get_cst($sales_array[0]['group_id']);
			$voucher_type = $this->vouchers->voucher_name($sales_array[0]['vtype_id']);
			$customer_name = $this->stock->get_customer($sales_array[0]['customer_type_id'],$sales_array[0]['customer_id']);
			$user_type = $this->dms->get_desig($sales_array[0]['user_id'],1);
			$user = $this->dms->get_user_name($sales_array[0]['user_id']);
			$pricelist = $this->customer_type->get_pricelist($sales_array[0]['pricelist_id']);
			$area_id = $this->dms->get_area($sales_array[0]['area_id']);
			$payment_mode = $this->stock->ledger_name($sales_array[0]['payment_mode']);
			$pdf_file = 'sales_bill_ar_pdf';

			$args = array();
			$args['select'] = array('dsv.id','rm.route_name','vm.vehicle_no','concat(u.fname," ",u.lname) as driver','u.mobile','dsv.km','dsv.remarks','dsv.vehicle_type','dsv.vehicle_no as vehicle_number','dsv.driver_name');
			$args['conditions'] = array('dsv.group_id'=>$sales_array[0]['group_id']);
			$args['join'] = array('route_master as rm'=>'dsv.route_id=rm.id','vehicle_master as vm'=>'dsv.vehicle_id=vm.id','users as u'=>'dsv.driver_id=u.id');
			$sales_vehicles = $this->sales_vehicle->get($args);

			if($sales_array[0]['customer_type_id'] == 2){
				$pdf_file = 'sales_bill_pdf';

			}else{
				$this->my_pdf->set_tin();
			}

			$this->my_pdf->set_header();

			$pdf_contents = $this->load->view('sales/sales_entry/'.$pdf_file,array('sales_array' => $sales_array,'presumptive_tax' => $presumptive_tax,'sales_cst' => $sales_cst,'voucher_type' => $voucher_type,'customer_name' => $customer_name,'user_type' => $user_type['designation_name'],'user' => $user,'pricelist' => $pricelist,'area_id' => $area_id,'payment_mode' => $payment_mode,'vehicle_details'=>$sales_vehicles),true);
		}
		$this->my_pdf->output($pdf_name,$pdf_contents);
	}
}?>