<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');
class Openingstock_barcode extends MY_Controller
{
	#-------------------------------------------------
	var $companyID,$branchID,$fiscal_start_date,$fiscal_end_date;
	
	public function __construct(){
		parent :: __construct();
		$this->check_access_right();
		
		#---------------- Checking Financial year is enabled / closed-----------------#
		$method_array = array('add','edit','delete');
		fiscal_status($this->uri->segment(2),$method_array,"opening_stock/report");	
		#---------------- Checking Financial year is enabled / closed-----------------#	
		$this->branchID = $this->session->userdata('under_id');
		$this->companyID = $this->session->userdata('company_id');	
		$this->load->model('products/Opening_stock_model','opening_stock');
		$this->load->library(array('Stock'));
		$this->load->model('products/Item_model','item');
		$fiscals = $this->dms->get_fiscal_year();
		$this->fiscal_start_date = $fiscals['start_date'];
		$this->fiscal_end_date = $fiscals['end_date'];		
	}
	
	#-------------------------------------------------
	
	public function add()
	{ 
	    $this->template->title($this->lang->line('opening-stock-set'));
		$this->template->main_heading($this->lang->line('opening-stock-set'));
		$this->template->breadcrumb(array($this->lang->line('products') => 'products/add',$this->lang->line('openings') => 'no_link',$this->lang->line('report') => 'opening_stock/report'));
		
	    $itemcodes = $this->item->itemcode(); 
	    
	    $godowns = $this->stock->get_godowns(array('conditions'=>array('branch_id'=>$this->branchID)));
	    //print_r($godowns);
		if(empty($godowns)){
			$this->message->set($this->lang->line('no-godown-found'),'i');
		}
		#---------save opening stock-----------------------------------
		$item_array = $this->input->post(NULL,true);
		foreach($godowns as $key=>$goDown)
		{
		    $goDownID = $goDown['id'];
		}
	$fiscalStartDate = $this->fiscal_start_date;
	//print_r($fiscalStartDate);
	$opening_amount = 0;
	for($i=1;$i<=10;$i++)
                {
                    $item_code = $item_array['code'.$i];
                     $qty = $item_array['qty'.$i];
                     $rate = $item_array['rate'.$i];
                     $amount = $item_array['amt'.$i];
                    if($item_code!=null )  
                    { 
                        
                        $itemarray = array();
                        /*$qry_godown = $this->db->select('id')->from('godown_master')->where(array('branch_id' => $this->branch_id,'status'=>1))->get()->row_array();
		                $godown_id = $qry_godown['id'];*/
                                   
                        $itemID = $this->stock->get_item_datas($item_code);
                        $item_unit = $this->stock->get_unit_id($itemID); 
                         
                        $itemarray['godown_id'] = $goDownID;
                        $itemarray['item_unit'] = $item_unit;
                        $itemarray['item_id'] = $itemID;
                        
                        $args = array();
			        	$args['select'] = array('id');
				        $args['conditions'] = array('company_id'=>$this->companyID,'godown_id'=>$goDownID,'item_id'=>$itemID,'stock_status'=>0);
				        $checkExists = $this->opening_stock->get($args);
				        
				        if(empty($checkExists)){
				            
				            $opening_amount += $amount;
				            
					        $saveArray = array('company_id'=>$this->companyID,'branch_id'=>$this->branchID,'godown_id'=>$goDownID,'item_id'=>$itemID,'qty'=>$qty,'unit_id'=>$item_unit,'rate'=>$rate,'stock_date'=>$fiscalStartDate,'stock_status'=>0);
					        if($this->opening_stock->save($saveArray)){
						    $insertCount ++;
					        }
				        }
				        else
				        {
				            $this->message->set($this->lang->line('opening-stock-exists'),'e');

				        }

                        
                    }
                }
if($opening_amount >0){
    

    
    
    $check_opening = $this->opening_stock->get_opening_balance(array('select'=>array('id','open_amount'),'conditions'=>array('company_id'=>$this->companyID,'branch_id'=>$this->branchID,'open_date'=>$fiscalStartDate)));
				if(empty($check_opening)){
					$this->opening_stock->save_opening_balance(array('company_id'=>$this->companyID,'branch_id'=>$this->branchID,'open_amount'=>$opening_amount,'open_date'=>$fiscalStartDate,'status'=>1));
				}
			else{
					$up_id = $check_opening[0]['id'];
					$prev_opening = $check_opening[0]['open_amount'];
					//print_r($prev_opening);
					
					$new_opening = $prev_opening+$opening_amount;
					//print_r($new_opening);
					$this->opening_stock->update_opening_balance(array('open_amount'=>$new_opening),array('company_id'=>$this->companyID,'branch_id'=>$this->branchID,'open_date'=>$fiscalStartDate));
				}
			}
	    
	    if($insertCount >0){
				$this->message->set($this->lang->line('opening-stock-saved'));
				redirect('opening_stock/report');
			}
	    #---------save opening stock-----------------------------------		
		$this->template->slice('dms/message');
		$this->template->slice('products/openings/barcode/opening_stock',array('items'=>$items,'itemcodes'=>$itemcodes,'godowns'=>$godowns,'checkedItems'=>$checkedArray,'symbol'=>$unit_symbol,'unit_symbol'=>$unit_symbol,'unit_name'=>$unit_name));
		$this->template->other_script(array('barcode/opening_stock'));
		$this->template->render();
	}
	
}