<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

class Order_to_delivery extends MY_Controller{

	public function __construct()
	{
		parent::__construct();
		$this->check_access_right();

		#---------------- Checking Financial year is enabled / closed-----------------#
		$method_array = array('delivery','d_update','d_delete');
		fiscal_status($this->uri->segment(2),$method_array,"sales_order/report");
		#---------------- Checking Financial year is enabled / closed-----------------#

		$this->load->model('sales/Delivery_note_model','delivery_obj');
		$this->load->model('vouchers/Voucher_model','vouchers');
		$this->load->library(array('Stock','Sales_lib'));

		#----------voucher type
		$this->vtype = 10;
	}

	public function delivery()
	{
		#----------voucher type
		$vtype_id = $this->vtype;

		#----------sales order primary key
		$so_id = $this->uri->segment(3);

		#----------sales order data
		$sales_order_array = $this->dms->get_data(array('table' => 'dms_sales_orders','columns' => array('id','branch_id','so_date','group_id','customer_type_id','customer_id','user_id','area_id','so_discount_per','so_discount_amt','cess','remarks','pricelist_id'),'conditions' => array('id' => $so_id,'status' => 1,'so_status' => 0)));
		if(!empty($sales_order_array))
		{
			$group_id = $sales_order_array[0]['group_id'];//group_id

			#----------checking group_id exists for redirection
			$redirection_uri = $this->sales_lib->sod_group_id_exists($group_id);
			if($redirection_uri)
			{
				redirect($redirection_uri);
			}
			else
			{
				#-----------delivery date and next bill no
				$disabled = "";
				$rules = "callback_bill_no_exists";
				$result_array = $this->delivery_obj->next_bill_no($this->vtype);
				$vtype_id = $result_array['vtype_id'];
				$voucher_no = $result_array['bill_no'];
				$voucher_date = $result_array['bill_date'];
				if($result_array['vstatus']){
					$disabled = "readonly";
					$rules = "callback_bill_no_exists[$vtype_id.$group_id]";
				}

				#----------sales order date
				$so_date = $sales_order_array[0]['so_date'];

				#------------presumptive tax checking
				$presumptive_tax = $this->stock->get_tax_type();

				#-------------adding data to delivery temp
				if(isset($_POST['btn_add']))
				{
					#-----------validation
					$this->form_validation->set_rules('vtype_id','lang:voucher-types','required|xss_clean');
					$this->form_validation->set_rules('bill_no','lang:bill-no',"required|xss_clean|is_natural_no_zero|".$rules);
					$this->form_validation->set_rules('bill_date','lang:bill-date',"required|xss_clean|valid_date|check_date[$so_date.>=]");
					$this->form_validation->set_rules('item_id','lang:item-name','required|xss_clean');
					$this->form_validation->set_rules('godown_id','lang:godown','required|xss_clean');
					$this->form_validation->set_rules('cst','lang:cst','xss_clean|greater_or_equal[0]|less_or_equal[100]');
					$this->form_validation->set_rules('qty','lang:quantity','required|xss_clean|greater_than[0]|less_than[100000000]');
					$this->form_validation->set_rules('unit_id','lang:unit','required|xss_clean');
					$this->form_validation->set_rules('rate','lang:rate','required|xss_clean|greater_or_equal[0]|less_than[100000000]');
					$this->form_validation->set_rules('amount','lang:amount','xss_clean|required|greater_or_equal[0]|less_than[100000000]');
					$this->form_validation->set_rules('discount_per','lang:discount %','xss_clean|greater_than[0]|less_or_equal[100]');
					$this->form_validation->set_rules('discount_amt','lang:discount','xss_clean|greater_or_equal[0]|less_than[100000000]');

					#-----------adding temporary data
					if($this->form_validation->run('btn_add') === true)
					{
						#----------VAT calculation
					/*	$cst = $vat_amt = $vat_percent = 0;
						if($this->input->post('cst',true)){
							$cst = $this->input->post('cst',true);
						}
						if(empty($presumptive_tax)){
							if($cst == 0){
								$vat_percent = $this->stock->get_item_vat($this->input->post('item_id',true));
								$vat_amt = (($this->input->post('amount',true)-$this->input->post('discount_amt',true)) * $vat_percent) / 100;
							}
						}    */


						$cgst = $this->stock->get_item_cgst($this->input->post('item_id',true));
						$sgst = $this->stock->get_item_sgst($this->input->post('item_id',true));
						$cgst_amt = (($this->input->post('amount',true)-$this->input->post('discount_amt',true)) * $cgst) / 100;
						$sgst_amt = (($this->input->post('amount',true)-$this->input->post('discount_amt',true)) * $sgst) / 100;
echo $cgst." ".$cgst_amt;
						#----------rate calculation
						$rate = 0;
						if($this->input->post('qty',true) != 0){
							$rate = $this->input->post('amount',true) / $this->input->post('qty',true);
						}

					//	$item_array = array('group_id' => $group_id,'item_id' => $this->input->post('item_id',true),'qty' => $this->input->post('qty',true),'unit_id' => $this->input->post('unit_id',true),'rate' => $rate,'amount' => $this->input->post('amount',true),'discount_per' => $this->input->post('discount_per',true),'discount_amt' => $this->input->post('discount_amt',true),'vat_percent' => $vat_percent,'vat_amt' => $vat_amt,'cst' => $cst,'godown_id' => $this->input->post('godown_id',true),'status' => -1,'item_status' => 2);

                                                $item_array = array('group_id' => $group_id,'item_id' => $this->input->post('item_id',true),'qty' => $this->input->post('qty',true),'unit_id' => $this->input->post('unit_id',true),'rate' => $rate,'amount' => $this->input->post('amount',true),'discount_per' => $this->input->post('discount_per',true),'discount_amt' => $this->input->post('discount_amt',true),'cgst' => $cgst,'sgst' => $sgst,'cgst_amt' => $cgst_amt,'sgst_amt' => $sgst_amt,'godown_id' => $this->input->post('godown_id',true),'status' => -1,'item_status' => 2);

						$sales_temp_item_result = $this->delivery_obj->get_sales_gst(array('columns' => array('b.id'),'conditions' => array('b.group_id' => $group_id,'item_id' => $item_array['item_id'],'godown_id' => $item_array['godown_id'],'unit_id' => $item_array['unit_id'],'a.status !=' => 0,'b.status !=' => 0,'b.item_status !=' => -1),'numrows' => true));
						if($sales_temp_item_result == 0)
						{
							#--------------adding delivery bill
							if($result_array['vstatus'] == 0)//data not in dms_delivery_notes
							{
								$vtype_id = $this->input->post('vtype_id',true);
								$voucher_no = $this->input->post('bill_no',true);
								$voucher_date = date('Y-m-d',strtotime($this->input->post('bill_date',true)));
								$data_sales_temp=array('vtype_id' => $vtype_id,'branch_id' => $sales_order_array[0]['branch_id'],'bill_no' => $voucher_no,'bill_date' => $voucher_date,'group_id' => $group_id,'sid' => $sales_order_array[0]['id'],'s_status' => 2,'customer_type_id' => $sales_order_array[0]['customer_type_id'],'customer_id' => $sales_order_array[0]['customer_id'],'user_id' => $sales_order_array[0]['user_id'],'area_id' => $sales_order_array[0]['area_id'],'pricelist_id' => $sales_order_array[0]['pricelist_id'],'status' => -1);
								$this->delivery_obj->insert("dms_delivery_notes",$data_sales_temp);
							}

							#--------------adding sales items
					//		$sales_items_id = $this->delivery_obj->insert("dms_sales_items",$item_array);
                                                        $sales_items_id = $this->delivery_obj->insert("dms_sales_items1",$item_array);
							if($sales_items_id)
							{
								#--------------adding temporary stock balance in dms_stocks
								$stock_bal_temp = $this->stock->unit_conversion($item_array['item_id'],$item_array['unit_id'],$item_array['qty'],$item_array['rate'],$item_array['amount']);
								if($stock_bal_temp)
								{
									$this->delivery_obj->insert('dms_stocks',array('company_id' => $this->session->userdata('company_id'),'branch_id' => $this->session->userdata('under_id'),'godown_id' => $item_array['godown_id'],'item_id' => $item_array['item_id'],'qty' => $stock_bal_temp['qty'],'unit_id' => $stock_bal_temp['primary_unit'],'rate' => $stock_bal_temp['rate'],'amount' => $stock_bal_temp['amount'],'stock_date' => $voucher_date,'stock_status' => 5,'table_group_id' => $group_id,'table_id' => $sales_items_id,'status' => -1));
								}
								$this->message->set($this->lang->line('delivery-add-success'));
							}
							else
							{
								$this->message->set($this->lang->line('delivery-add-error'),'e');
							}
						}
						else{
							$this->message->set($this->lang->line('delivery-add-error'),'e');
						}
						$redirect_uri = $this->uri->uri_to_assoc(1);
						redirect($this->uri->assoc_to_uri($redirect_uri));
					}
				}

				#------------saving delivery voucher
				if(isset($_POST['btn_save']))
				{
					#-----------validation
					$sales_entry_check = $this->delivery_obj->get_bills(array('columns' => array('id'),'conditions' => array('group_id' => $group_id,'status !=' => 0)));
					if(!$sales_entry_check)
					{
						$this->form_validation->set_rules('vtype_id','lang:voucher-types','required|xss_clean');
						$this->form_validation->set_rules('bill_no','lang:bill-no',"required|xss_clean|is_natural_no_zero|".$rules);
						$this->form_validation->set_rules('bill_date','lang:bill-date',"required|xss_clean|valid_date|check_date[$so_date.>=]");
					}

					$this->form_validation->set_rules('remarks','lang:remarks','xss_clean');
					$this->form_validation->set_rules('freight','lang:freight','xss_clean|greater_or_equal[0]');
					$this->form_validation->set_rules('other_expense','lang:other-expense','xss_clean|greater_or_equal[0]');
					$this->form_validation->set_rules('bill_discount_per','lang:discount %','xss_clean|greater_or_equal[0]|less_or_equal[100]');
					$this->form_validation->set_rules('bill_discount_amt','lang:discount','xss_clean|greater_or_equal[0]');

					#-----------saving data
					if($this->form_validation->run('btn_save') === true)
					{
						$success = 0;
						$sales_entry_array=array('bill_discount_per' => $this->input->post('bill_discount_per',true),'bill_discount_amt' => $this->input->post('bill_discount_amt',true),'bill_freight' => $this->input->post('freight',true),'other_expense' => $this->input->post('other_expense',true),'cess' => $sales_order_array[0]['cess'],'narration' => $this->input->post('remarks',true),'status' => 1);

						#------------checking data is in dms_delivery_notes table
						if(!$sales_entry_check)//not in dms_delivery_notes table
						{
							$voucher_date = date('Y-m-d',strtotime($this->input->post('bill_date',true)));
							$sales_entry_array['vtype_id'] = $this->input->post('vtype_id',true);
							$sales_entry_array['branch_id'] = $sales_order_array[0]['branch_id'];
							$sales_entry_array['bill_no'] = $this->input->post('bill_no',true);
							$sales_entry_array['bill_date'] = $voucher_date;
							$sales_entry_array['group_id'] = $group_id;
							$sales_entry_array['sid'] = $sales_order_array[0]['id'];
							$sales_entry_array['s_status'] = 2;
							$sales_entry_array['customer_type_id'] = $sales_order_array[0]['customer_type_id'];
							$sales_entry_array['customer_id'] = $sales_order_array[0]['customer_id'];
							$sales_entry_array['user_id'] = $sales_order_array[0]['user_id'];
							$sales_entry_array['area_id'] = $sales_order_array[0]['area_id'];
							$sales_entry_array['pricelist_id'] = $sales_order_array[0]['pricelist_id'];
							if($this->delivery_obj->insert('dms_delivery_notes',$sales_entry_array)){
								$success = 1;
							}
						}
						else
						{
							if($this->delivery_obj->update(array('table' => 'dms_delivery_notes','data' => $sales_entry_array,'conditions' => array('group_id' => $group_id)))){
								$success = 1;
							}
						}
						if($success)
						{
							#------------updating sales_item status
							$this->delivery_obj->update_others(array('table' => 'dms_sales_items1','data' => array('status' => 1),'conditions' => array('group_id' => $group_id)));
							$this->delivery_obj->update_others(array('table' => 'dms_sales_items1','data' => array('item_status' => 1),'conditions' => array('group_id' => $group_id,'item_status' => 0)));

							#------------updating sales_order status
							$this->delivery_obj->update_others(array('table' => 'dms_sales_orders','data' => array('so_status' => 1),'conditions' => array('group_id' => $group_id)));

							$sales_items_array = $this->delivery_obj->get_sales_itemss(array('columns' => array('id','item_id','qty','unit_id','rate','amount','godown_id'),'conditions' => array('group_id' => $group_id,'status' => 1,'item_status !=' => -1)));
							foreach($sales_items_array as $key => $value)
							{
								#--------------checking stock exists or not
								if(!$this->stock->check_stock(array('stock_status' => 5,'table_id' => $value['id'])))
								{
									#--------------adding temporary stock balance in dms_stocks
									$stock_bal_temp = $this->stock->unit_conversion($value['item_id'],$value['unit_id'],$value['qty'],$value['rate'],$value['amount']);
									if($stock_bal_temp)
									{
										$this->delivery_obj->insert('dms_stocks',array('company_id' => $this->session->userdata('company_id'),'branch_id' => $this->session->userdata('under_id'),'godown_id' => $value['godown_id'],'item_id' => $value['item_id'],'qty' => $stock_bal_temp['qty'],'unit_id' => $stock_bal_temp['primary_unit'],'rate' => $stock_bal_temp['rate'],'amount' => $stock_bal_temp['amount'],'stock_date' => $voucher_date,'stock_status' => 5,'table_group_id' => $group_id,'table_id' => $value['id'],'status' => 1));
									}
								}
								else
								{
									#-------------enabling temporarily added stocks
									$this->delivery_obj->update_others(array('table' => 'dms_stocks','data' => array('stock_date' => $voucher_date,'status' => 1),'conditions' => array('stock_status' => 5,'table_id' => $value['id'])));
								}
							}
							$this->message->set($this->lang->line('delivery-save-success'));
						}
						else
						{
							$this->message->set($this->lang->line('delivery-save-error'),'e');
						}
						redirect('delivery_note/add');
					}
				}

				#----------delivery items
				$sales_items = $this->delivery_obj->get_sales_itemss(array('conditions' => array('group_id' => $sales_order_array[0]['group_id'],'status !=' => 0,'item_status !=' => -1)));

				#----------voucher type array
				$voucher_types = $this->vouchers->voucher_types($this->vtype);
				$bill_prefix = $this->stock->get_voucher_prefix($this->vtype);
				#----------voucher name
				$voucher_name = $this->vouchers->voucher_name($this->vtype);

				#-----------sales cst checking details
				$sales_cst = $this->stock->get_constant(array('sales_cst'));

				#------------item details / unit details / godown details
				$units = array();$goDowns = array();
				$units[''] = "Select";
				$args['select'] = array('id','item_code','item_name');
				$items = $this->stock->get_stock_items($args);
				if(empty($items)){
					$this->message->set($this->lang->line('no-items-found'),'i');
				}
				if($this->input->post('item_id',true)){
					$itemID = $this->input->post('item_id',true);
					$goDowns = $this->stock->get_item_godowns(array('item_id'=>$itemID,'listing'=>1));
					$units = $this->stock->get_units($itemID);
				}

				$items[''] = 'Select';ksort($items);
				$goDowns[''] = 'Select';ksort($goDowns);

				#------------stock count of this item
				$stock_count = "";$primary_unit['symbol'] = "";
				if($this->input->post('item_id',true) && $this->input->post('godown_id',true) && $this->input->post('bill_date',true)){
					$bill_date = date('Y-m-d',strtotime($this->input->post('bill_date',true)));
					$stock_count = $this->stock->get_stock_count($this->input->post('godown_id',true),$this->input->post('item_id',true),$bill_date);
					$primary_unit = $this->stock->get_primary_unit($this->input->post('item_id',true));
				}

				$customer_name = $this->stock->get_customer($sales_order_array[0]['customer_type_id'],$sales_order_array[0]['customer_id']);
				$user_type = $this->dms->get_desig($sales_order_array[0]['user_id'],1);
				$user = $this->dms->get_user_name($sales_order_array[0]['user_id']);

				#------------loading model
				$this->load->model('customers/Customer_type_model','customer_type');

				$pricelist = $this->customer_type->get_pricelist($sales_order_array[0]['pricelist_id']);
				$area_id = $this->dms->get_area($sales_order_array[0]['area_id']);

				#------------checking cst enabled or not
				$cst_status = $this->delivery_obj->get_cst($group_id);
				if($cst_status){ $sales_cst = $cst_status; }

				#------------template
				$this->template->title($this->lang->line("$voucher_name"));
				$this->template->main_heading($this->lang->line("$voucher_name"));
				$this->template->breadcrumb(array($this->lang->line("$voucher_name") => 'no_link',$this->lang->line('report') => 'delivery_note/report'));
				$this->template->slice('dms/message');
				$this->template->slice('sales/sales_order/delivery',array('sales_order_array' => $sales_order_array,'customer_name' => $customer_name,'user_type' => $user_type['designation_name'],'user' => $user,'pricelist' => $pricelist,'area_id' => $area_id,'voucher_types' => $voucher_types,'voucher_name' => $voucher_name,'voucher_type' => $vtype_id,'disabled' => $disabled,'items' => $items,'goDowns' => $goDowns,'units' => $units,'sales_cst' => $sales_cst,'stock_count' => $stock_count,'primary_unit' => $primary_unit['symbol'],'sales_items' => $sales_items,'voucher_no' => $voucher_no,'voucher_date' => $voucher_date,'presumptive_tax'=>$presumptive_tax,'bill_prefix'=>$bill_prefix));
				$this->template->other_script('sales/sales_order');
				$this->template->render();
			}
		}
		else
		{
			redirect(base_url());
		}
	}

	public function d_update()
	{
		#----------sales items id from sales / sales order
		$sales_temp_id = $this->uri->segment(3);

		$row = $this->delivery_obj->get_sales_items(array('columns' => array('id','group_id','item_id','qty','unit_id','rate','amount','discount_per','discount_amt','vat_amt','cst','godown_id','item_status'),'conditions' => array('id' => $sales_temp_id)));
		if(!empty($row))
		{
			$sales_temp_data = $row[0];

			#-----------validation
			$this->form_validation->set_rules('godown_id','lang:godown','required|xss_clean');
			$this->form_validation->set_rules('cst','lang:cst','xss_clean|greater_or_equal[0]|less_or_equal[100]');
			$this->form_validation->set_rules('qty','lang:quantity','required|xss_clean|greater_than[0]|less_than[100000000]');
			$this->form_validation->set_rules('unit_id','lang:unit','required|xss_clean');
			$this->form_validation->set_rules('rate','lang:rate','required|xss_clean|greater_or_equal[0]|less_than[100000000]');
			$this->form_validation->set_rules('amount','lang:amount','xss_clean|required|greater_or_equal[0]|less_than[100000000]');
			$this->form_validation->set_rules('discount_per','lang:discount %','xss_clean|greater_or_equal[0]|less_or_equal[100]');
			$this->form_validation->set_rules('discount_amt','lang:discount','xss_clean|greater_or_equal[0]|less_than[100000000]');
			$this->form_validation->set_rules('vat_amt','lang:vat-amt','xss_clean|greater_or_equal[0]|less_than[100000000]');

			#-----------redirect uri
			$update_uri = $this->uri->uri_to_assoc(4);
			$redirect_uri = $this->uri->assoc_to_uri($update_uri);

			#-----------updating temporary data
			if($this->form_validation->run() === true)
			{
				$item_temp_array = $this->input->post(NULL,true);

				#----------rate calculation
				$item_temp_array['rate'] = 0;
				if($item_temp_array['qty'] != 0){
					$item_temp_array['rate'] = $item_temp_array['amount'] / $item_temp_array['qty'];
				}

				#------------presumptive tax checking
				$presumptive_tax = $this->stock->get_tax_type();

				#----------VAT calculation
				$cst = 0;
				if(array_key_exists('cst',$item_temp_array)){
					$cst = $item_temp_array['cst'];
				}
				if(empty($presumptive_tax)){
					if($cst == 0){
						$item_temp_array['vat_percent'] = $this->stock->get_item_vat($sales_temp_data['item_id']);
					}
				}

				if($sales_temp_data['item_status'] == 0 && ($sales_temp_data['qty'] != $item_temp_array['qty'] || $sales_temp_data['unit_id'] != $item_temp_array['unit_id'] || $sales_temp_data['rate'] != $item_temp_array['rate'] || $sales_temp_data['discount_per'] != $item_temp_array['discount_per'] || $sales_temp_data['discount_amt'] != $item_temp_array['discount_amt'] || $sales_temp_data['godown_id'] != $item_temp_array['godown_id'] || $sales_temp_data['cst'] != $cst || $sales_temp_data['vat_amt'] != $item_temp_array['vat_amt']))
				{
					$item_temp_array['group_id'] = $sales_temp_data['group_id'];
					$item_temp_array['item_id'] = $sales_temp_data['item_id'];
					$item_temp_array['status'] = -1;
					$item_temp_array['item_status'] = 2;
					$sales_temp_data['item_status'] = 2;
					if($this->delivery_obj->update_others(array('table' => 'dms_sales_items','data' => array('item_status' => -1),'conditions' => array('id' => $sales_temp_id)))){
						$sales_temp_id = $this->delivery_obj->insert('dms_sales_items',$item_temp_array);
						$this->message->set($this->lang->line('delivery-edit-temp-success'));
					}
				}
				else
				{
					$this->delivery_obj->update_others(array('table' => 'dms_sales_items','data' => $item_temp_array,'conditions' => array('id' => $sales_temp_id)));
					$this->message->set($this->lang->line('delivery-edit-temp-success'));
				}

				#--------------updating temporary stock balance in dms_stocks
				if($sales_temp_data['item_status'] == 2)
				{
					$stock_bal_temp = $this->stock->unit_conversion($sales_temp_data['item_id'],$item_temp_array['unit_id'],$item_temp_array['qty'],$item_temp_array['rate'],$item_temp_array['amount']);
					if($stock_bal_temp)
					{
						if($this->stock->check_stock(array('stock_status' => 5,'table_id' => $sales_temp_id,'status !=' => 0)))
						{
							$this->delivery_obj->update_others(array('table' => 'dms_stocks','data' => array('godown_id' => $item_temp_array['godown_id'],'qty' => $stock_bal_temp['qty'],'unit_id' => $stock_bal_temp['primary_unit'],'rate' => $stock_bal_temp['rate'],'amount' => $stock_bal_temp['amount']),'conditions' => array('stock_status' => 5,'table_id' => $sales_temp_id)));
						}
						else
						{
							$this->delivery_obj->insert('dms_stocks',array('company_id' => $this->session->userdata('company_id'),'branch_id' => $this->session->userdata('under_id'),'godown_id' => $item_temp_array['godown_id'],'item_id' => $sales_temp_data['item_id'],'qty' => $stock_bal_temp['qty'],'unit_id' => $stock_bal_temp['primary_unit'],'rate' => $stock_bal_temp['rate'],'amount' => $stock_bal_temp['amount'],'stock_status' => 5,'table_group_id' => $sales_temp_data['group_id'],'table_id' => $sales_temp_id,'status' => -1));
						}
					}
				}
				redirect($redirect_uri);
			}

			#----------voucher name
			$voucher_name = $this->vouchers->voucher_name($this->vtype);

			#-----------sales cst checking details
			$sales_cst = $this->stock->get_constant(array('sales_cst'));

			#------------presumptive tax checking
			$presumptive_tax = $this->stock->get_tax_type();

			#------------checking cst enabled or not
			$cst_status = $this->delivery_obj->get_cst($sales_temp_data['group_id']);
			if($cst_status){
				$sales_cst = $cst_status;
			}

			#------------item details / unit details / godown details
			$units = array();$goDowns = array();
			$item_details = $this->stock->get_item($sales_temp_data['item_id'],array('item_code','item_name'));
			$items[$sales_temp_data['item_id']] = $item_details['item_code']." / ".$item_details['item_name'];
			$goDowns = $this->stock->get_item_godowns(array('item_id'=>$sales_temp_data['item_id'],'listing'=>1));
			$goDowns[''] = 'Select';
			ksort($goDowns);
			$units = $this->stock->get_units($sales_temp_data['item_id']);

			#------------sale date
			$sale_bill_date = "";$stock_count = "";
			$sale_data = $this->delivery_obj->get_bills(array('columns' => 'bill_date','conditions' => array('group_id' => $sales_temp_data['group_id'],'status !=' => 0)));
			if(!empty($sale_data))
			{
				$sale_bill_date = $sale_data[0]['bill_date'];

				#------------stock count of this item
				$stock_count = $this->stock->get_stock_count($sales_temp_data['godown_id'],$sales_temp_data['item_id'],$sale_bill_date);
			}

			#------------primary unit details
			$primary_unit = $this->stock->get_primary_unit($sales_temp_data['item_id']);

			#------------template
			$this->template->title("Update Delivery Note Voucher");
			$this->template->main_heading($this->lang->line("$voucher_name"));
			$this->template->breadcrumb(array($this->lang->line("$voucher_name") => 'order_to_delivery/delivery',$this->lang->line("update") => 'no_link',$this->lang->line('go-back') => array($redirect_uri)));
			$this->template->slice('dms/message');
			$this->template->slice('sales/sales_entry/edit_temp',array('voucher_name' => $voucher_name,'items' => $items,'units' => $units,'goDowns' => $goDowns,'sales_temp_data' => $sales_temp_data,'sales_cst' => $sales_cst,'presumptive_tax' => $presumptive_tax,'stock_count' => $stock_count,'unit_symbol' => $primary_unit['symbol'],'sale_date' => $sale_bill_date));
			$this->template->other_script('sales/sales_order');
			$this->template->render();
		}
		else
		{
			redirect(base_url());
		}
	}

	public function d_delete()
	{
		$id=$this->uri->segment(3,0);

		#-----------redirect uri
		$update_uri = $this->uri->uri_to_assoc(4);
		$redirect_uri = $this->uri->assoc_to_uri($update_uri);

		$result = $this->delivery_obj->get_sales_items(array('columns' => array('group_id','status','item_status'),'conditions' => array('id' => $id)));
		if(!empty($result))
		{
			$row = $result[0];
			if($row['item_status'] == 0)
			{
				$this->delivery_obj->update_others(array('table' => 'dms_sales_items','data' => array('item_status' => -1),'conditions' => array('id' => $id)));
				$this->message->set($this->lang->line('sales-item-delete-success'));
			}
			else
			{
				if($row['status'] == -1)
				{
					if($this->delivery_obj->delete(array('table' => 'dms_sales_items','conditions' => array('id' => $id))))
					{
						#-------------deleting stock bal. from dms_stocks
						$this->delivery_obj->delete(array('table' => 'dms_stocks','conditions' => array('table_id' => $id,'stock_status' => 5)));

						$count = $this->delivery_obj->get_sales_items(array('columns' => array('group_id'),'conditions' => array('group_id' => $row['group_id'],'status !=' => 0,'item_status !=' => 0),'numrows' => true));
						if($count == 0){
							$this->delivery_obj->delete(array('table' => 'dms_delivery_notes','conditions' => array('group_id' => $row['group_id'])));
						}
						$this->message->set($this->lang->line('sales-item-delete-success'));
					}
					else
					{
						$this->message->set($this->lang->line('sales-item-delete-error'),'e');
					}
				}
			}
		}
		redirect($redirect_uri);
	}

	public function bill_no_exists($bill_no,$v_details = NULL)
	{
		if($v_details == NULL){
			$where = array('vtype_id' => $this->input->post('vtype_id',true),'bill_no' => $bill_no,'status !=' => 0);
		}
		else{
			$exp = explode('.', $v_details);
			$where = array('vtype_id' => $exp[0],'bill_no' => $bill_no,'group_id !=' => $exp[1],'status !=' => 0);
		}
		$row = $this->delivery_obj->get_bills(array('columns' => array('id'),'conditions' => $where,'numrows' => true));
		if($row == 0){
			return true;
		}
		return false;
	}
}
?>