<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

class Order_to_receipt extends MY_Controller{

	public function __construct()
	{
		parent::__construct();

		$this->check_access_right();

		#---------------- Checking Financial year is enabled / closed-----------------#
		$method_array = array('receipt','d_update','d_delete');
		fiscal_status($this->uri->segment(2),$method_array,"purchase_order/report");
		#---------------- Checking Financial year is enabled / closed-----------------#

		$this->load->model('purchase/Receipt_note_model','receipt_obj');
		$this->load->model('vouchers/Voucher_model','vouchers');
		$this->load->library(array('Stock','Purchase_lib'));

		#----------voucher type
		$this->vtype = 9;
	}

	public function receipt()
	{
		#----------purchase order primary key
		$so_id = $this->uri->segment(3);

		#----------purchase order data
		$purchase_order_array = $this->dms->get_data(array('table' => 'dms_purchase_orders','columns' => array('id','branch_id','po_date','group_id','vendor_id','po_discount_per','po_discount_amt','cess','remarks'),'conditions' => array('id' => $so_id,'po_status' => 0,'status' => 1)));
		if(!empty($purchase_order_array))
		{
			$group_id = $purchase_order_array[0]['group_id'];//group_id

			#----------checking group_id exists for redirection
			$redirection_uri = $this->purchase_lib->por_group_id_exists($group_id);
			if($redirection_uri)
			{
				redirect($redirection_uri);
			}
			else
			{
				#-----------purchase date and next bill no
				$rules = "callback_bill_no_exists";
				$disabled = $inv_no = "";$inv_date = date('Y-m-d');
				$result_array = $this->receipt_obj->next_bill_no($this->vtype);
				$vtype_id = $result_array['vtype_id'];
				$voucher_no = $result_array['bill_no'];
				$voucher_date = $result_array['bill_date'];
				if($result_array['vstatus']){
					$invoice_details = $this->receipt_obj->get_bills(array('columns' => array('invoice_no','invoice_date'),'conditions' => array('group_id' => $group_id)));
					$inv_no = $invoice_details[0]['invoice_no'];
					$inv_date = $invoice_details[0]['invoice_date'];
					$disabled = "readonly";
					$rules = "callback_bill_no_exists[$vtype_id.$group_id]";
				}

				#----------purchase order date
				$po_date = $purchase_order_array[0]['po_date'];

				#------------presumptive tax checking
				$presumptive_tax = $this->stock->get_tax_type();

				#-------------adding data to purchase temp
				if(isset($_POST['btn_add']))
				{
					#-----------validation
					$this->form_validation->set_rules('vtype_id','lang:voucher-types','required|xss_clean');
					$this->form_validation->set_rules('bill_no','lang:bill-no',"required|xss_clean|is_natural_no_zero|".$rules);
					$this->form_validation->set_rules('bill_date','lang:bill-date',"required|xss_clean|valid_date|check_date[$po_date.>=]");
					$this->form_validation->set_rules('invoice_no','lang:invoice-no',"required|xss_clean");
					$this->form_validation->set_rules('invoice_date','lang:invoice-date',"required|xss_clean|is_date");
					$this->form_validation->set_rules('item_id','lang:item-name','required|xss_clean');
					$this->form_validation->set_rules('godown_id','lang:godown','required|xss_clean');
					$this->form_validation->set_rules('cst','lang:cst','xss_clean|greater_or_equal[0]|less_or_equal[100]');
					$this->form_validation->set_rules('qty','lang:quantity','required|xss_clean|greater_than[0]|less_than[100000000]');
					$this->form_validation->set_rules('unit_id','lang:unit','required|xss_clean');
					$this->form_validation->set_rules('rate','lang:rate','required|xss_clean|greater_or_equal[0]|less_than[100000000]');
					$this->form_validation->set_rules('amount','lang:amount','xss_clean|required|greater_or_equal[0]|less_than[100000000]');
					$this->form_validation->set_rules('discount_per','lang:discount %','xss_clean|greater_than[0]|less_or_equal[100]');
					$this->form_validation->set_rules('discount_amt','lang:discount','xss_clean|greater_or_equal[0]|less_than[100000000]');

					#-----------adding temporary data
					if($this->form_validation->run('btn_add') === true)
					{
						#----------VAT calculation
						$cst = $vat_amt = $vat_percent = 0;
						if($this->input->post('cst',true)){
							$cst = $this->input->post('cst',true);
						}
						if(empty($presumptive_tax)){
							if($cst == 0){
								$vat_percent = $this->stock->get_item_vat($this->input->post('item_id',true));
								$vat_amt = (($this->input->post('amount',true)-$this->input->post('discount_amt',true)) * $vat_percent) / 100;
							}
						}

						#----------rate calculation
						$rate = 0;
						if($this->input->post('qty',true) != 0){
							$rate = $this->input->post('amount',true) / $this->input->post('qty',true);
						}

						$item_array = array('group_id' => $group_id,'item_id' => $this->input->post('item_id',true),'qty' => $this->input->post('qty',true),'unit_id' => $this->input->post('unit_id',true),'rate' => $rate,'amount' => $this->input->post('amount',true),'discount_per' => $this->input->post('discount_per',true),'discount_amt' => $this->input->post('discount_amt',true),'vat_percent' => $vat_percent,'vat_amt' => $vat_amt,'cst' => $cst,'godown_id' => $this->input->post('godown_id',true),'status' => -1,'item_status' => 2);

						$purchase_temp_item_result = $this->receipt_obj->get_purchases(array('columns' => array('b.id'),'conditions' => array('b.group_id' => $group_id,'item_id' => $item_array['item_id'],'godown_id' => $item_array['godown_id'],'unit_id' => $item_array['unit_id'],'a.status !=' => 0,'b.status !=' => 0,'b.item_status !=' => -1),'numrows' => true));
						if($purchase_temp_item_result == 0)
						{
							#--------------adding purchase bill
							if($result_array['vstatus'] == 0)//data not in dms_purchases
							{
								$vtype_id = $this->input->post('vtype_id',true);
								$voucher_no = $this->input->post('bill_no',true);
								$voucher_date = date('Y-m-d',strtotime($this->input->post('bill_date',true)));
								$invoice_date = date('Y-m-d',strtotime($this->input->post('invoice_date',true)));
								$invoice_no = $this->input->post('invoice_no',true);
								$data_purchase_temp=array('vtype_id' => $vtype_id,'branch_id' => $purchase_order_array[0]['branch_id'],'bill_no' => $voucher_no,'bill_date' => $voucher_date,'invoice_no' => $invoice_no,'invoice_date' => $invoice_date,'group_id' => $group_id,'pid' => $purchase_order_array[0]['id'],'p_status' => 2,'vendor_id' => $purchase_order_array[0]['vendor_id'],'status' => -1);
								$this->receipt_obj->insert("dms_receipt_notes",$data_purchase_temp);
							}

							#--------------adding purchase items
							$purchase_items_id = $this->receipt_obj->insert("dms_purchase_items",$item_array);
							if($purchase_items_id)
							{
								#--------------adding temporary stock balance in dms_stocks
								$stock_bal_temp = $this->stock->unit_conversion($item_array['item_id'],$item_array['unit_id'],$item_array['qty'],$item_array['rate'],$item_array['amount']);
								if($stock_bal_temp)
								{
									$this->receipt_obj->insert('dms_stocks',array('company_id' => $this->session->userdata('company_id'),'branch_id' => $this->session->userdata('under_id'),'godown_id' => $item_array['godown_id'],'item_id' => $item_array['item_id'],'qty' => $stock_bal_temp['qty'],'unit_id' => $stock_bal_temp['primary_unit'],'rate' => $stock_bal_temp['rate'],'amount' => $stock_bal_temp['amount'],'stock_date' => $voucher_date,'stock_status' => 1,'table_group_id' => $group_id,'table_id' => $purchase_items_id,'status' => -1));
								}
								$this->message->set($this->lang->line('purchase-add-success'));
							}
							else
							{
								$this->message->set($this->lang->line('purchase-add-error'),'e');
							}
						}
						else{
							$this->message->set($this->lang->line('purchase-add-error'),'e');
						}
						$redirect_uri = $this->uri->uri_to_assoc(1);
						redirect($this->uri->assoc_to_uri($redirect_uri));
					}
				}

				#------------saving purchase voucher
				if(isset($_POST['btn_save']))
				{
					#-----------validation
					$purchase_entry_check = $this->receipt_obj->get_bills(array('columns' => array('id'),'conditions' => array('group_id' => $group_id,'status !=' => 0)));
					if(!$purchase_entry_check)
					{
						$this->form_validation->set_rules('vtype_id','lang:voucher-types','required|xss_clean');
						$this->form_validation->set_rules('bill_no','lang:bill-no',"required|xss_clean|is_natural_no_zero|".$rules);
						$this->form_validation->set_rules('bill_date','lang:bill-date',"required|xss_clean|valid_date|check_date[$po_date.>=]");
						$this->form_validation->set_rules('invoice_no','lang:invoice-no',"required|xss_clean");
						$this->form_validation->set_rules('invoice_date','lang:invoice-date',"required|xss_clean|is_date");
					}

					$this->form_validation->set_rules('remarks','lang:remarks','xss_clean');
					$this->form_validation->set_rules('freight','lang:freight','xss_clean|greater_or_equal[0]');
					$this->form_validation->set_rules('other_expense','lang:other-expense','xss_clean|greater_or_equal[0]');
					$this->form_validation->set_rules('bill_discount_per','lang:discount %','xss_clean|greater_or_equal[0]|less_or_equal[100]');
					$this->form_validation->set_rules('bill_discount_amt','lang:discount','xss_clean|greater_or_equal[0]');

					#-----------saving data
					if($this->form_validation->run('btn_save') === true)
					{
						$success = 0;
						$purchase_entry_array=array('invoice_no' => $this->input->post('invoice_no',true),'invoice_date' => date('Y-m-d',strtotime($this->input->post('invoice_date',true))),'vendor_id'=>$purchase_order_array[0]['vendor_id'],'bill_discount_per' => $this->input->post('bill_discount_per',true),'bill_discount_amt' => $this->input->post('bill_discount_amt',true),'bill_freight' => $this->input->post('freight',true),'other_expense' => $this->input->post('other_expense',true),'cess' => $purchase_order_array[0]['cess'],'narration' => $this->input->post('remarks',true),'status' => 1);

						#------------checking data is in dms_purchases table
						if(!$purchase_entry_check)//not in dms_purchases table
						{
							$voucher_date = date('Y-m-d',strtotime($this->input->post('bill_date',true)));
							$purchase_entry_array['vtype_id'] = $this->input->post('vtype_id',true);
							$purchase_entry_array['branch_id'] = $purchase_order_array[0]['branch_id'];
							$purchase_entry_array['bill_no'] = $this->input->post('bill_no',true);
							$purchase_entry_array['bill_date'] = $voucher_date;
							$purchase_entry_array['group_id'] = $group_id;
							$purchase_entry_array['pid'] = $purchase_order_array[0]['id'];
							$purchase_entry_array['p_status'] = 2;

							if($this->receipt_obj->insert('dms_receipt_notes',$purchase_entry_array)){
								$success = 1;
							}
						}
						else
						{
							if($this->receipt_obj->update(array('table' => 'dms_receipt_notes','data' => $purchase_entry_array,'conditions' => array('group_id' => $group_id)))){
								$success = 1;
							}
						}

						if($success)
						{
							#------------updating godown
							$godown_id = $this->stock->get_godown();
							$this->receipt_obj->update_others(array('table' => 'dms_purchase_items','data' => array('godown_id' => $godown_id),'conditions' => array('group_id' => $group_id,'item_status' => 0)));

							#------------updating purchase_item status
							$this->receipt_obj->update_others(array('table' => 'dms_purchase_items','data' => array('status' => 1),'conditions' => array('group_id' => $group_id)));
							$this->receipt_obj->update_others(array('table' => 'dms_purchase_items','data' => array('item_status' => 1),'conditions' => array('group_id' => $group_id,'item_status' => 0)));

							#------------updating purchase_order status
							$this->receipt_obj->update_others(array('table' => 'dms_purchase_orders','data' => array('po_status' => 1),'conditions' => array('group_id' => $group_id)));

							$purchase_items_array = $this->receipt_obj->get_purchase_items(array('columns' => array('id','item_id','qty','unit_id','rate','amount','godown_id'),'conditions' => array('group_id' => $group_id,'status' => 1,'item_status !=' => -1)));
							foreach($purchase_items_array as $key => $value)
							{
								#--------------checking stock exists or not
								if(!$this->stock->check_stock(array('stock_status' => 1,'table_id' => $value['id'],'status !=' => 0)))
								{
									#--------------adding temporary stock balance in dms_stocks
									$stock_bal_temp = $this->stock->unit_conversion($value['item_id'],$value['unit_id'],$value['qty'],$value['rate'],$value['amount']);
									if($stock_bal_temp)
									{
										$this->receipt_obj->insert('dms_stocks',array('company_id' => $this->session->userdata('company_id'),'branch_id' => $this->session->userdata('under_id'),'godown_id' => $value['godown_id'],'item_id' => $value['item_id'],'qty' => $stock_bal_temp['qty'],'unit_id' => $stock_bal_temp['primary_unit'],'rate' => $stock_bal_temp['rate'],'amount' => $stock_bal_temp['amount'],'stock_date' => $voucher_date,'stock_status' => 1,'table_group_id' => $group_id,'table_id' => $value['id'],'status' => 1));
									}
								}
								else
								{
									#-------------enabling temporarily added stocks
									$this->receipt_obj->update_others(array('table' => 'dms_stocks','data' => array('stock_date' => $voucher_date,'status' => 1),'conditions' => array('stock_status' => 1,'table_id' => $value['id'])));
								}
							}
							$this->message->set($this->lang->line('receipt-save-success'));
						}
						else
						{
							$this->message->set($this->lang->line('receipt-save-error'),'e');
						}
						redirect('receipt_note/add');
					}
				}

				#----------receipt items
				$purchase_items = $this->receipt_obj->get_purchase_itemss(array('conditions' => array('group_id' => $purchase_order_array[0]['group_id'],'status !=' => 0,'item_status !=' => -1)));

				#----------voucher type array
				$voucher_types = $this->vouchers->voucher_types($this->vtype);
				$bill_prefix = $this->stock->get_voucher_prefix($this->vtype);
				#----------voucher name
				$voucher_name = $this->vouchers->voucher_name($this->vtype);

				#-----------purchase cst checking details
				$purchase_cst = $this->stock->get_constant(array('purchase_cst'));

				#------------vendor details
				$vendor_name = $this->stock->vendor_name($purchase_order_array[0]['vendor_id']);

				#------------item details / unit details / godown details
				$units = array();$goDowns = array();
				$units[''] = "Select";
				$args['select'] = array('id','item_code','item_name');
				$items = $this->stock->get_stock_items($args);
				if(empty($items)){
					$this->message->set($this->lang->line('no-items-found'),'i');
				}
				if($this->input->post('item_id',true)){
					$itemID = $this->input->post('item_id',true);
					$goDowns = $this->stock->get_item_godowns(array('item_id'=>$itemID,'listing'=>1));
					$units = $this->stock->get_units($itemID);
				}

				$items[''] = 'Select';ksort($items);
				$goDowns[''] = 'Select';ksort($goDowns);

				#------------stock count of this item
				$stock_count = $primary_unit['symbol'] = "";
				if($this->input->post('item_id',true) && $this->input->post('godown_id',true) && $this->input->post('bill_date',true)){
					$bill_date = date('Y-m-d',strtotime($this->input->post('bill_date',true)));
					$stock_count = $this->stock->get_stock_count($this->input->post('godown_id',true),$this->input->post('item_id',true),$bill_date);
					$primary_unit = $this->stock->get_primary_unit($this->input->post('item_id',true));
				}


				#------------checking cst enabled or not
				$cst_status = $this->receipt_obj->get_cst($group_id);
				if($cst_status){ $purchase_cst = $cst_status; }

				#------------template
				$this->template->title("New Receipt Note Voucher");
				$this->template->main_heading($this->lang->line("$voucher_name"));
				$this->template->breadcrumb(array($this->lang->line("$voucher_name") => 'no_link',$this->lang->line('report') => 'receipt_note/report'));
				$this->template->slice('dms/message');
				$this->template->slice('purchase/purchase_order/receipt',array('purchase_order_array' => $purchase_order_array,'voucher_types' => $voucher_types,'vendor_name' => $vendor_name,'invoice_no' => $inv_no,'invoice_date' => $inv_date,'voucher_name' => $voucher_name,'voucher_type' => $vtype_id,'disabled' => $disabled,'items' => $items,'goDowns' => $goDowns,'units' => $units,'purchase_cst' => $purchase_cst,'stock_count' => $stock_count,'primary_unit' => $primary_unit['symbol'],'purchase_items' => $purchase_items,'voucher_no' => $voucher_no,'voucher_date' => $voucher_date,'presumptive_tax'=>$presumptive_tax,'bill_prefix'=>$bill_prefix));
				$this->template->other_script('purchase/purchase');
				$this->template->render();
			}
		}
		else
		{
			redirect(base_url());
		}
	}

	public function r_update()
	{
		#----------purchase items id from purchase / purchase order
		$purchase_temp_id = $this->uri->segment(3);

		$row = $this->receipt_obj->get_purchase_items(array('columns' => array('id','group_id','item_id','qty','unit_id','rate','amount','discount_per','discount_amt','vat_amt','cst','godown_id','item_status'),'conditions' => array('id' => $purchase_temp_id)));
		if(!empty($row))
		{
			$purchase_temp_data = $row[0];

			#-----------validation
			$this->form_validation->set_rules('godown_id','lang:godown','required|xss_clean');
			$this->form_validation->set_rules('cst','lang:cst','xss_clean|greater_or_equal[0]|less_or_equal[100]');
			$this->form_validation->set_rules('qty','lang:quantity','required|xss_clean|greater_than[0]|less_than[100000000]');
			$this->form_validation->set_rules('unit_id','lang:unit','required|xss_clean');
			$this->form_validation->set_rules('rate','lang:rate','required|xss_clean|greater_or_equal[0]|less_than[100000000]');
			$this->form_validation->set_rules('amount','lang:amount','xss_clean|required|greater_or_equal[0]|less_than[100000000]');
			$this->form_validation->set_rules('discount_per','lang:discount %','xss_clean|greater_or_equal[0]|less_or_equal[100]');
			$this->form_validation->set_rules('discount_amt','lang:discount','xss_clean|greater_or_equal[0]|less_than[100000000]');
			$this->form_validation->set_rules('vat_amt','lang:vat-amt','xss_clean|greater_or_equal[0]|less_than[100000000]');

			#-----------redirect uri
			$update_uri = $this->uri->uri_to_assoc(4);
			$redirect_uri = $this->uri->assoc_to_uri($update_uri);

			#-----------updating temporary data
			if($this->form_validation->run() === true)
			{
				$item_temp_array = $this->input->post(NULL,true);

				#----------rate calculation
				$item_temp_array['rate'] = 0;
				if($item_temp_array['qty'] != 0){
					$item_temp_array['rate'] = $item_temp_array['amount'] / $item_temp_array['qty'];
				}

				#------------presumptive tax checking
				$presumptive_tax = $this->stock->get_tax_type();

				#----------VAT calculation
				$cst = 0;
				if(array_key_exists('cst',$item_temp_array)){
					$cst = $item_temp_array['cst'];
				}
				if(empty($presumptive_tax)){
					if($cst == 0){
						$item_temp_array['vat_percent'] = $this->stock->get_item_vat($purchase_temp_data['item_id']);
					}
				}

				if($purchase_temp_data['item_status'] == 0 && ($purchase_temp_data['qty'] != $item_temp_array['qty'] || $purchase_temp_data['unit_id'] != $item_temp_array['unit_id'] || $purchase_temp_data['rate'] != $item_temp_array['rate'] || $purchase_temp_data['discount_per'] != $item_temp_array['discount_per'] || $purchase_temp_data['discount_amt'] != $item_temp_array['discount_amt'] || $purchase_temp_data['godown_id'] != $item_temp_array['godown_id'] || $purchase_temp_data['cst'] != $cst || $purchase_temp_data['vat_amt'] != $item_temp_array['vat_amt']))
				{
					$item_temp_array['group_id'] = $purchase_temp_data['group_id'];
					$item_temp_array['item_id'] = $purchase_temp_data['item_id'];
					$item_temp_array['status'] = -1;
					$item_temp_array['item_status'] = 2;
					$purchase_temp_data['item_status'] = 2;
					if($this->receipt_obj->update_others(array('table' => 'dms_purchase_items','data' => array('item_status' => -1),'conditions' => array('id' => $purchase_temp_id)))){
						$purchase_temp_id = $this->receipt_obj->insert('dms_purchase_items',$item_temp_array);
						$this->message->set($this->lang->line('purchase-edit-temp-success'));
					}
				}
				else
				{
					$this->receipt_obj->update_others(array('table' => 'dms_purchase_items','data' => $item_temp_array,'conditions' => array('id' => $purchase_temp_id)));
					$this->message->set($this->lang->line('purchase-edit-temp-success'));
				}

				#--------------updating temporary stock balance in dms_stocks
				if($purchase_temp_data['item_status'] == 2)
				{
					$stock_bal_temp = $this->stock->unit_conversion($purchase_temp_data['item_id'],$item_temp_array['unit_id'],$item_temp_array['qty'],$item_temp_array['rate'],$item_temp_array['amount']);
					if($stock_bal_temp)
					{
						if($this->stock->check_stock(array('stock_status' => 1,'table_id' => $purchase_temp_id,'status !=' => 0)))
						{
							$this->receipt_obj->update_others(array('table' => 'dms_stocks','data' => array('godown_id' => $item_temp_array['godown_id'],'qty' => $stock_bal_temp['qty'],'unit_id' => $stock_bal_temp['primary_unit'],'rate' => $stock_bal_temp['rate'],'amount' => $stock_bal_temp['amount']),'conditions' => array('stock_status' => 1,'table_id' => $purchase_temp_id)));
						}
						else
						{
							$this->receipt_obj->insert('dms_stocks',array('company_id' => $this->session->userdata('company_id'),'branch_id' => $this->session->userdata('under_id'),'godown_id' => $item_temp_array['godown_id'],'item_id' => $purchase_temp_data['item_id'],'qty' => $stock_bal_temp['qty'],'unit_id' => $stock_bal_temp['primary_unit'],'rate' => $stock_bal_temp['rate'],'amount' => $stock_bal_temp['amount'],'stock_status' => 1,'table_group_id' => $purchase_temp_data['group_id'],'table_id' => $purchase_temp_id,'status' => -1));
						}
					}
				}
				redirect($redirect_uri);
			}

			#----------voucher name
			$voucher_name = $this->vouchers->voucher_name($this->vtype);

			#-----------purchase cst checking details
			$purchase_cst = $this->stock->get_constant(array('purchase_cst'));

			#------------presumptive tax checking
			$presumptive_tax = $this->stock->get_tax_type();

			#------------checking cst enabled or not
			$cst_status = $this->receipt_obj->get_cst($purchase_temp_data['group_id']);
			if($cst_status){
				$purchase_cst = $cst_status;
			}

			#------------item details / unit details / godown details
			$units = array();$goDowns = array();
			$item_details = $this->stock->get_item($purchase_temp_data['item_id'],array('item_code','item_name'));
			$items[$purchase_temp_data['item_id']] = $item_details['item_code']." / ".$item_details['item_name'];
			$goDowns = $this->stock->get_item_godowns(array('item_id'=>$purchase_temp_data['item_id'],'listing'=>1));
			$goDowns[''] = 'Select';
			ksort($goDowns);
			$units = $this->stock->get_units($purchase_temp_data['item_id']);

			#------------purchase date
			$purchase_bill_date = $stock_count = "";
			$purchase_data = $this->receipt_obj->get_bills(array('columns' => 'bill_date','conditions' => array('group_id' => $purchase_temp_data['group_id'],'status !=' => 0)));
			if(!empty($purchase_data))
			{
				$purchase_bill_date = $purchase_data[0]['bill_date'];

				#------------stock count of this item
				$stock_count = $this->stock->get_stock_count($purchase_temp_data['godown_id'],$purchase_temp_data['item_id'],$purchase_bill_date);
			}

			#------------primary unit details
			$primary_unit = $this->stock->get_primary_unit($purchase_temp_data['item_id']);

			#------------template
			$this->template->title("Update Receipt Note Voucher");
			$this->template->main_heading($this->lang->line("$voucher_name"));
			$this->template->breadcrumb(array($this->lang->line("$voucher_name") => 'order_to_receipt/receipt',$this->lang->line("update") => 'no_link',$this->lang->line('go-back') => array($redirect_uri)));
			$this->template->slice('dms/message');
			$this->template->slice('purchase/purchase_entry/edit_temp',array('voucher_name' => $voucher_name,'items' => $items,'units' => $units,'goDowns' => $goDowns,'purchase_temp_data' => $purchase_temp_data,'purchase_cst' => $purchase_cst,'presumptive_tax' => $presumptive_tax,'stock_count' => $stock_count,'unit_symbol' => $primary_unit['symbol'],'purchase_date' => $purchase_bill_date));
			$this->template->other_script('purchase/purchase');
			$this->template->render();
		}
		else
		{
			redirect(base_url());
		}
	}

	public function r_delete()
	{
		$id=$this->uri->segment(3,0);

		#-----------redirect uri
		$update_uri = $this->uri->uri_to_assoc(4);
		$redirect_uri = $this->uri->assoc_to_uri($update_uri);

		$result = $this->receipt_obj->get_purchase_items(array('columns' => array('group_id','status','item_status'),'conditions' => array('id' => $id)));
		if(!empty($result))
		{
			$row = $result[0];
			if($row['item_status'] == 0)
			{
				$this->receipt_obj->update_others(array('table' => 'dms_purchase_items','data' => array('item_status' => -1),'conditions' => array('id' => $id)));
				$this->message->set($this->lang->line('purchase-item-delete-success'));
			}
			else
			{
				if($row['status'] == -1)
				{
					if($this->receipt_obj->delete(array('table' => 'dms_purchase_items','conditions' => array('id' => $id))))
					{
						#-------------deleting stock bal. from dms_stocks
						$this->receipt_obj->delete(array('table' => 'dms_stocks','conditions' => array('table_id' => $id,'stock_status' => 1)));

						$count = $this->receipt_obj->get_purchase_items(array('columns' => array('group_id'),'conditions' => array('group_id' => $row['group_id'],'status !=' => 0,'item_status !=' => 0),'numrows' => true));
						if($count == 0){
							$this->receipt_obj->delete(array('table' => 'dms_receipt_notes','conditions' => array('group_id' => $row['group_id'])));
						}
						$this->message->set($this->lang->line('purchase-item-delete-success'));
					}
					else
					{
						$this->message->set($this->lang->line('purchase-item-delete-error'),'e');
					}
				}
			}
		}
		redirect($redirect_uri);
	}

	public function bill_no_exists($bill_no,$v_details = NULL)
	{
		if($v_details == NULL){
			$where = array('vtype_id' => $this->input->post('vtype_id',true),'bill_no' => $bill_no,'status !=' => 0);
		}
		else{
			$exp = explode('.', $v_details);
			$where = array('vtype_id' => $exp[0],'bill_no' => $bill_no,'group_id !=' => $exp[1],'status !=' => 0);
		}
		$row = $this->receipt_obj->get_bills(array('columns' => array('id'),'conditions' => $where,'numrows' => true));
		if($row == 0){
			return true;
		}
		return false;
	}
}
?>