<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

class Order_to_sales extends MY_Controller{

	public function __construct()
	{
		parent::__construct();

		$this->check_access_right();
		$this->companyID = $this->session->userdata('company_id');
		#---------------- Checking Financial year is enabled / closed-----------------#
		$method_array = array('so_sales','so_update','so_delete');
		fiscal_status($this->uri->segment(2),$method_array,"sales_order/report");
		#---------------- Checking Financial year is enabled / closed-----------------#

		$this->load->model('sales/Sales_model','sales_obj');
		$this->load->model('vouchers/Voucher_model','vouchers');
		$this->load->library(array('Stock','Targets','Sales_lib'));

		#----------voucher type
		$this->vtype = 6;
	}

	public function so_sales()
	{
		#----------voucher type
		$vtype_id = $this->vtype;

		#----------sales order primary key
		$so_id = $this->uri->segment(3);

		#----------sales order data
		$sales_order_array = $this->dms->get_data(array('table' => 'dms_sales_orders','columns' => array('id','branch_id','so_date','group_id','customer_type_id','customer_id','user_id','area_id','so_discount_per','so_discount_amt','cess','remarks','pricelist_id'),'conditions' => array('id' => $so_id,'status' => 1,'so_status' => 0)));
		if(!empty($sales_order_array))
		{
			$group_id = $sales_order_array[0]['group_id'];
			#----------checking group_id exists for redirection
			$redirection_uri = $this->sales_lib->sos_group_id_exists($group_id);
			if($redirection_uri)
			{
				redirect($redirection_uri);
			}
			else
			{
				#-----------sales date and next bill no
				$rules = "callback_bill_no_exists";
				$disabled = "";
				$result_array = $this->sales_obj->next_bill_no($this->vtype);
				$vtype_id = $result_array['vtype_id'];
				$voucher_no = $result_array['bill_no'];
				$voucher_date = $result_array['bill_date'];
				if($result_array['vstatus']){
					$disabled = "readonly";
					$rules = "callback_bill_no_exists[$vtype_id.$group_id]";
				}

				#----------sales order date
				$so_date = $sales_order_array[0]['so_date'];
				$l_date = '2017-07-01';

				#------------presumptive tax checking
				$presumptive_tax = $this->stock->get_tax_type();

				#-------------adding data to sales temp
				if(isset($_POST['btn_add']))
				{
					#-----------validation
					$this->form_validation->set_rules('vtype_id','lang:voucher-types','required|xss_clean');
					$this->form_validation->set_rules('bill_no','lang:bill-no',"required|xss_clean|is_natural_no_zero|".$rules);
					$this->form_validation->set_rules('bill_date','lang:bill-date',"required|xss_clean|valid_date|check_date[$so_date.>=]");
					$this->form_validation->set_rules('item_id','lang:item-name','required|xss_clean');
					$this->form_validation->set_rules('godown_id','lang:godown','required|xss_clean');
					$this->form_validation->set_rules('cst','lang:cst','xss_clean|greater_or_equal[0]|less_or_equal[100]');
					$this->form_validation->set_rules('qty','lang:quantity','required|xss_clean|greater_than[0]|less_than[100000000]');
					$this->form_validation->set_rules('unit_id','lang:unit','required|xss_clean');
					$this->form_validation->set_rules('rate','lang:rate','required|xss_clean|greater_or_equal[0]|less_than[100000000]');
					$this->form_validation->set_rules('amount','lang:amount','xss_clean|required|greater_or_equal[0]|less_than[100000000]');
					$this->form_validation->set_rules('discount_per','lang:discount %','xss_clean|greater_than[0]|less_or_equal[100]');
					$this->form_validation->set_rules('discount_amt','lang:discount','xss_clean|greater_or_equal[0]|less_than[100000000]');

					#-----------adding temporary data
					if($this->form_validation->run('btn_add') === true)
					{
						#----------VAT calculation
						if($so_date < $l_date)
						{
							$cst = $vat_amt = $vat_percent = 0;
							if($this->input->post('cst',true)){
								$cst = $this->input->post('cst',true);
							}
							if(empty($presumptive_tax)){
								if($cst == 0){
									$vat_percent = $this->stock->get_item_vat($this->input->post('item_id',true));
									$vat_amt = (((float)$this->input->post('amount',true)-$this->input->post('discount_amt',true)) * (float)$vat_percent) / 100;
								}
							}
						}
						else
						{
							$cgst = $this->stock->get_item_cgst($this->input->post('item_id',true));
							$sgst = $this->stock->get_item_sgst($this->input->post('item_id',true));
							$cgstAmt = (((float)$this->input->post('amount',true)-(float)$this->input->post('discount_amt',true)) * (float)$cgst) / 100;
							$sgstAmt = (((float)$this->input->post('amount',true)-(float)$this->input->post('discount_amt',true)) * (float)$sgst) / 100;	
							$vat_amt = (float)$cgstAmt+(float)$sgstAmt;
						}

						#----------rate calculation
						$rate = 0;
						if($this->input->post('qty',true) != 0){
							$rate = (float)$this->input->post('amount',true) / (float)$this->input->post('qty',true);
						}
						if($so_date < $l_date)
						{
							$item_array = array('group_id' => $group_id,'item_id' => $this->input->post('item_id',true),'qty' => $this->input->post('qty',true),'unit_id' => $this->input->post('unit_id',true),'rate' => $rate,'amount' => $this->input->post('amount',true),'discount_per' => $this->input->post('discount_per',true),'discount_amt' => $this->input->post('discount_amt',true),'godown_id' => $this->input->post('godown_id',true),'status' => -1,'item_status' => 2);

							
						}
						else
						{
							$item_array = array('group_id' => $group_id,'item_id' => $this->input->post('item_id',true),'qty' => $this->input->post('qty',true),'unit_id' => $this->input->post('unit_id',true),'rate' => $rate,'amount' => $this->input->post('amount',true),'discount_per' => $this->input->post('discount_per',true),'discount_amt' => $this->input->post('discount_amt',true),'cgst' => $cgst,'sgst'=>$sgst,'cgst_amt' => $cgstAmt,'sgst_amt' => $sgstAmt,'godown_id' => $this->input->post('godown_id',true),'status' => -1,'item_status' => 2);
						}
							$sales_temp_item_result = $this->sales_obj->get_sales(array('columns' => array('b.id'),'conditions' => array('b.group_id' => $group_id,'item_id' => $item_array['item_id'],'godown_id' => $item_array['godown_id'],'unit_id' => $item_array['unit_id'],'a.status !=' => 0,'b.status !=' => 0,'b.item_status !=' => -1),'numrows' => true));	
					if(empty($sales_temp_item_result))
					{
						$sales_temp_item_result = $this->sales_obj->get_sales_gst(array('columns' => array('b.id'),'conditions' => array('b.group_id' => $group_id,'item_id' => $item_array['item_id'],'godown_id' => $item_array['godown_id'],'unit_id' => $item_array['unit_id'],'a.status !=' => 0,'b.status !=' => 0,'b.item_status !=' => -1),'numrows' => true));	
						
					}
						if($sales_temp_item_result == 0)
						{
							$sales_temp_array['vtype_id'] = $this->input->post('vtype_id',true);
							$sales_temp_array['bill_no'] = $this->input->post('bill_no',true);
							$sales_temp_array['bill_date'] = $this->input->post('bill_date',true);

							#--------------adding sales bill
							if($result_array['vstatus'] == 0)//data not in dms_sales
							{
								$vtype_id = $sales_temp_array['vtype_id'];
								$voucher_no = $sales_temp_array['bill_no'];
								$voucher_date = date('Y-m-d',strtotime($sales_temp_array['bill_date']));
								$data_sales_temp=array('vtype_id' => $vtype_id,'branch_id' => $sales_order_array[0]['branch_id'],'bill_no' => $voucher_no,'bill_date' => $voucher_date,'group_id' => $group_id,'sid' => $sales_order_array[0]['id'],'s_status' => 2,'customer_type_id' => $sales_order_array[0]['customer_type_id'],'customer_id' => $sales_order_array[0]['customer_id'],'user_id' => $sales_order_array[0]['user_id'],'area_id' => $sales_order_array[0]['area_id'],'pricelist_id' => $sales_order_array[0]['pricelist_id'],'status' => -1);
								$this->sales_obj->insert("dms_sales",$data_sales_temp);
							}

							#--------------adding sales items
							if($voucher_date<$l_date)
							{
								$sales_items_id = $this->sales_obj->insert("dms_sales_items1",$item_array);
							}
							else
							{
								$sales_items_id = $this->sales_obj->insert("dms_sales_items1",$item_array);	
							}
							if($sales_items_id)
							{
								#--------------adding temporary stock balance in dms_stocks
								$stock_bal_temp = $this->stock->unit_conversion($item_array['item_id'],$item_array['unit_id'],$item_array['qty'],$item_array['rate'],$item_array['amount']);
								if($stock_bal_temp)
								{
									$this->sales_obj->insert('dms_stocks',array('company_id' => $this->session->userdata('company_id'),'branch_id' => $this->session->userdata('under_id'),'godown_id' => $item_array['godown_id'],'item_id' => $item_array['item_id'],'qty' => $stock_bal_temp['qty'],'unit_id' => $stock_bal_temp['primary_unit'],'rate' => $stock_bal_temp['rate'],'amount' => $stock_bal_temp['amount'],'stock_date' => $voucher_date,'stock_status' => 6,'table_group_id' => $group_id,'table_id' => $sales_items_id,'status' => -1));
								}
								$this->message->set($this->lang->line('sales-add-success'));
							}
							else
							{
								$this->message->set($this->lang->line('sales-add-error'),'e');
							}
						}
						else{
							$this->message->set($this->lang->line('sales-add-error'),'e');
						}
						$redirect_uri = $this->uri->uri_to_assoc(1);
						redirect($this->uri->assoc_to_uri($redirect_uri));
					}
				}

				#------------saving sales voucher
				if(isset($_POST['btn_save']))
				{
					#-----------validation
					$sales_entry_check = $this->sales_obj->get_bills(array('columns' => array('id'),'conditions' => array('group_id' => $group_id,'status !=' => 0)));
					if(!$sales_entry_check)
					{
						$this->form_validation->set_rules('vtype_id','lang:voucher-types','required|xss_clean');
						$this->form_validation->set_rules('bill_no','lang:bill-no',"required|xss_clean|is_natural_no_zero|".$rules);
						$this->form_validation->set_rules('bill_date','lang:bill-date',"required|xss_clean|valid_date|check_date[$so_date.>=]");
					}
					$this->form_validation->set_rules('payment_mode','lang:payment-mode','required|xss_clean');
					$this->form_validation->set_rules('credit_period','lang:credit-period','xss_clean|is_natural');
					if($this->input->post('payment_mode',true) == 2){
						$this->form_validation->set_rules('credit_period','lang:credit-period','required|xss_clean|is_natural');
					}
					elseif($this->input->post('payment_mode',true) > 2){
						$voucher_date = date('Y-m-d',strtotime($this->input->post('bill_date',true)));
						$this->form_validation->set_rules('ccd','lang:cash-cheque-dd','required|xss_clean');
						$this->form_validation->set_rules('cd_no','lang:cd-no','required|xss_clean');
						$this->form_validation->set_rules('cheque_date','lang:cheque-date',"required|xss_clean|is_date|check_date[$voucher_date.>=]");
					}
					$this->form_validation->set_rules('remarks','lang:remarks','xss_clean');
					$this->form_validation->set_rules('freight','lang:freight','xss_clean|greater_or_equal[0]');
					$this->form_validation->set_rules('other_expense','lang:other-expense','xss_clean|greater_or_equal[0]');
					$this->form_validation->set_rules('bill_discount_per','lang:discount %','xss_clean|greater_or_equal[0]|less_or_equal[100]');
					$this->form_validation->set_rules('bill_discount_amt','lang:discount','xss_clean|greater_or_equal[0]');

					#-----------saving data
					if($this->form_validation->run('btn_save') === true)
					{
						$success = 0;
						$voucher_date = date('Y-m-d',strtotime($this->input->post('bill_date',true)));
						$bill_date = $voucher_date;
						$voucher_no = $this->input->post('bill_no',true);
						$bill_no = $voucher_no;
						$narration = $this->input->post('remarks',true);
						$payment_mode = $this->input->post('payment_mode',true);
						$bill_discount_amt = $this->input->post('bill_discount_amt',true);
						$freight = $this->input->post('freight',true);
						$other_expense = $this->input->post('other_expense',true);

						$sales_entry_array=array('bill_no' => $voucher_no,'bill_date' => $voucher_date,'bill_discount_per' => $this->input->post('bill_discount_per',true),'bill_discount_amt' => $bill_discount_amt,'bill_freight' => $freight,'other_expense' => $other_expense,'cess' => $sales_order_array[0]['cess'],'narration' => $narration,'payment_mode' => $payment_mode,'cr_period' => $this->input->post('credit_period',true),'status' => 1);

						#----------start transaction
						$this->db->trans_start();

						#------------checking data is in dms_sales table
						if(!$sales_entry_check)//not in dms_sales table
						{
							$sales_entry_array['vtype_id'] = $this->input->post('vtype_id',true);
							$vtype_id = $sales_entry_array['vtype_id'];
							$sales_entry_array['branch_id'] = $sales_order_array[0]['branch_id'];
							$sales_entry_array['group_id'] = $group_id;
							$sales_entry_array['sid'] = $sales_order_array[0]['id'];
							$sales_entry_array['s_status'] = 2;
							$sales_entry_array['customer_type_id'] = $sales_order_array[0]['customer_type_id'];
							$sales_entry_array['customer_id'] = $sales_order_array[0]['customer_id'];
							$sales_entry_array['user_id'] = $sales_order_array[0]['user_id'];
							$sales_entry_array['area_id'] = $sales_order_array[0]['area_id'];
							$sales_entry_array['pricelist_id'] = $sales_order_array[0]['pricelist_id'];
							if($this->sales_obj->insert('dms_sales',$sales_entry_array))
							{
								$success = 1;
							}
						}
						else
						{
							if($this->sales_obj->update(array('table' => 'dms_sales','data' => $sales_entry_array,'conditions' => array('group_id' => $group_id))))
							{
								$success = 1;
							}
						}
						if($success)
						{
							#------------updating sales_item status
							$this->sales_obj->update_others(array('table' => 'dms_sales_items1','data' => array('status' => 1),'conditions' => array('group_id' => $group_id,'status !=' => 0)));
							$this->sales_obj->update_others(array('table' => 'dms_sales_items1','data' => array('item_status' => 1),'conditions' => array('group_id' => $group_id,'item_status' => 0)));

							#------------updating sales_order status
							$this->sales_obj->update_others(array('table' => 'dms_sales_orders','data' => array('so_status' => 2),'conditions' => array('group_id' => $group_id)));

							#--------------checking for user points
							$user_points = 0;$user_type = "";
							if($sales_order_array[0]['customer_type_id'] == 2)//customer
							{
								$user_id = $sales_order_array[0]['user_id'];
								$designation_id = $this->dms->get_desig($user_id);
								if($designation_id == 4){
									$user_type = $designation_id;#"c";
								}
								elseif($designation_id == 5){
									$user_type = $designation_id;#"m";
								}
								elseif($designation_id == 6){
									$user_type = $designation_id;#"e";
								}
								$customer = $this->dms->get_data(array('table' => 'customer_master','columns' => 'ledger_id','conditions' => array('id' => $sales_order_array[0]['customer_id'])));
							}
							else//branch or AR
							{
								$designation_id = $sales_order_array[0]['customer_type_id'];
								$user_id = $sales_order_array[0]['customer_id'];
								if($designation_id == 3)
								{
									$customer = $this->dms->get_data(array('table' => 'retailer_master','columns' => 'ledger_id','conditions' => array('id' => $sales_order_array[0]['customer_id'])));
								}
								else
								{
									$customer = $this->dms->get_data(array('table' => 'branch_master','columns' => 'ledger_id','conditions' => array('id' => $sales_order_array[0]['customer_id'])));
								}
							}

							#-------------adding bill to dms_vouchers
							$voucher_status = 1;
							$voucher_amount = $this->input->post('grand_total',true);
							$round_off_amount = $this->input->post('round_off_amount',true);
							$vat_amount = $this->input->post('vat_total',true);
							$cess_amount = $this->input->post('cess_total',true);
							if($payment_mode > 2)
							{
								$bill_date_time = strtotime($bill_date);
								$cheque_date = date('Y-m-d',strtotime($this->input->post('cheque_date',true)));
								$cheque_date_time = strtotime($cheque_date);
								if($this->input->post('ccd',true) == 1 && $cheque_date_time > $bill_date_time)
								{
									$voucher_status = 3;
								}
							}elseif($payment_mode == 2){
								$payment_mode = $customer[0]['ledger_id'];//customer
							}
							$voucher_group_id = $this->stock->get_group_id('dms_vouchers');
							$voucher_amount -= $bill_discount_amt;
							$voucher_amount += $round_off_amount;

							$voucher_array = array('company_id' => $this->session->userdata('company_id'),'branch_id' => $this->session->userdata('under_id'),'group_id' => $voucher_group_id,'vtype_id' => $vtype_id,'vno' => $bill_no,'vorder_no' => 1,'vdate' => $bill_date,'dr_ledger' => $payment_mode,'cr_ledger' => 4,'vamount' => $voucher_amount,'narration' => $narration,'table_name' => 'dms_sales','table_group_id' => $group_id,'status' => $voucher_status);
							$voucher_data = $this->dms->get_data(array('table' =>'dms_vouchers','columns' => 'id','conditions' => array('table_name' => 'dms_sales','table_group_id' => $group_id),'numrows' => true));
							if($voucher_data == 0)
							{
								$voucher_success = $this->sales_obj->insert('dms_vouchers',$voucher_array);
								if($voucher_success)
								{
									#-----------VAT
									$voucher_array['cr_ledger'] = 12;
									$voucher_array['vorder_no'] = 2;
									$voucher_array['vamount'] = $vat_amount;
									$this->sales_obj->insert('dms_vouchers',$voucher_array);
									#-----------CESS
									$voucher_array['cr_ledger'] = 15;
									$voucher_array['vorder_no'] = 3;
									$voucher_array['vamount'] = $cess_amount;
									$this->sales_obj->insert('dms_vouchers',$voucher_array);
									#-----------Freight
									$voucher_array['dr_ledger'] = 13;
									$voucher_array['cr_ledger'] = $payment_mode;
									$voucher_array['vorder_no'] = 4;
									$voucher_array['vamount'] = $freight;
									$this->sales_obj->insert('dms_vouchers',$voucher_array);
									#-----------Other Expense
									$voucher_array['dr_ledger'] = 14;
									$voucher_array['vorder_no'] = 5;
									$voucher_array['vamount'] = $other_expense;
									$this->sales_obj->insert('dms_vouchers',$voucher_array);

									if($payment_mode > 2)
									{
										$this->sales_obj->insert('dms_voucher_banks',array('group_id' => $voucher_group_id,'cash_type' => $this->input->post('ccd',true),'cd_no' => $this->input->post('cd_no',true),'pdc' => $cheque_date,'vdate' => $bill_date));
									}
								}
							}

							$sales_items_array = $this->sales_obj->get_sales_itemss(array('columns' => array('id','item_id','qty','unit_id','rate','amount','godown_id'),'conditions' => array('group_id' => $group_id,'status' => 1,'item_status !=' => -1)));
							foreach($sales_items_array as $key => $value)
							{
								#--------------checking stock exists or not
								if(!$this->stock->check_stock(array('stock_status' => 6,'table_id' => $value['id'])))
								{
									#--------------adding temporary stock balance in dms_stocks
									$stock_bal_temp = $this->stock->unit_conversion($value['item_id'],$value['unit_id'],$value['qty'],$value['rate'],$value['amount']);
									if($stock_bal_temp)
									{
										$this->sales_obj->insert('dms_stocks',array('company_id' => $this->session->userdata('company_id'),'branch_id' => $this->session->userdata('under_id'),'godown_id' => $value['godown_id'],'item_id' => $value['item_id'],'qty' => $stock_bal_temp['qty'],'unit_id' => $stock_bal_temp['primary_unit'],'rate' => $stock_bal_temp['rate'],'amount' => $stock_bal_temp['amount'],'stock_date' => $voucher_date,'stock_status' => 6,'table_group_id' => $group_id,'table_id' => $value['id'],'status' => 1));
									}
								}
								else
								{
									#-------------enabling temporarily added stocks
									$this->sales_obj->update_others(array('table' => 'dms_stocks','data' => array('status' => 1),'conditions' => array('stock_status' => 6,'table_id' => $value['id'])));
								}

								#--------------calculating user points
								if(!empty($user_id) && !empty($user_type))
								{
									$user_points += $this->targets->get_bill_points($designation_id,$user_id,$value['item_id'],$value['unit_id'],$value['qty'],$value['rate'],$voucher_date);
								}
							}

							#--------------calculating user points
							if($user_points > 0)
							{
								$target_id = $this->targets->get_targets(array('columns' => 'a.id','conditions' => array('a.designation_id' => $designation_id,'a.user_id' => $user_id,'a.status' => 1),'bill_date' => $voucher_date));
								if($target_id)
								{
									$this->sales_obj->insert('user_points',array('designation_id' => $designation_id,'user_id' => $user_id,'targets_id' => $target_id['id'],'group_id' => $group_id,'sms_point' => $user_points,'actual_point'=>$user_points));
								}
							}
							if(!empty($user_type)){
								$user_data = $this->dms->get_data(array('table' =>'users','columns' => 'mobile','conditions' => array('id' => $user_id)));
								if(!empty($user_data)){
									$user_type_mobile=$user_data[0]['mobile'];
									$this->sales_obj->insert('dms_sms',array('company_id' =>$this->companyID,'bill_ref_no' => $group_id,'user_type'=>$user_type,'user_id'=>$user_id,'status'=>3));
								}
							}							
							$this->message->set($this->lang->line('sales-save-success'));
						}
						else
						{
							$this->message->set($this->lang->line('sales-save-error'),'e');
						}

						#----------transaction completed
						$this->db->trans_complete();

						redirect('sales/add');
					}
				}

				#----------sales items
				$sales_items = $this->sales_obj->get_sales_itemss(array('conditions' => array('group_id' => $sales_order_array[0]['group_id'],'status !=' => 0,'item_status !=' => -1)));

				#----------voucher type array
				$voucher_types = $this->vouchers->voucher_types($this->vtype);
				$bill_prefix = $this->stock->get_voucher_prefix($this->vtype);
				#----------voucher name
				$voucher_name = $this->vouchers->voucher_name($this->vtype);

				#-----------sales cst checking details
				$sales_cst = $this->stock->get_constant(array('sales_cst'));

				#------------item details / unit details / godown details
				$units = array();$goDowns = array();
				$units[''] = "Select";
				$args['select'] = array('id','item_code','item_name');
				$items = $this->stock->get_stock_items($args);
				if(empty($items)){
					$this->message->set($this->lang->line('no-items-found'),'i');
				}
				if($this->input->post('item_id',true)){
					$itemID = $this->input->post('item_id',true);
					$goDowns = $this->stock->get_item_godowns(array('item_id'=>$itemID,'listing'=>1));
					$units = $this->stock->get_units($itemID);
				}

				$items[''] = 'Select';ksort($items);
				$goDowns[''] = 'Select';ksort($goDowns);

				#------------stock count of this item
				$stock_count = "";$primary_unit['symbol'] = "";
				if($this->input->post('item_id',true) && $this->input->post('godown_id',true) && $this->input->post('bill_date',true)){
					$bill_date = date('Y-m-d',strtotime($this->input->post('bill_date',true)));
					$stock_count = $this->stock->get_stock_count($this->input->post('godown_id',true),$this->input->post('item_id',true),$bill_date);
					$primary_unit = $this->stock->get_primary_unit($this->input->post('item_id',true));
				}

				$customer_name = $this->stock->get_customer($sales_order_array[0]['customer_type_id'],$sales_order_array[0]['customer_id']);
				$user_type = $this->dms->get_desig($sales_order_array[0]['user_id'],1);
				$user = $this->dms->get_user_name($sales_order_array[0]['user_id']);

				#------------loading model
				$this->load->model('customers/Customer_type_model','customer_type');

				$pricelist = $this->customer_type->get_pricelist($sales_order_array[0]['pricelist_id']);
				$area_id = $this->dms->get_area($sales_order_array[0]['area_id']);

				#------------payment modes
				$payment_modes = $this->stock->payment_modes();

				#------------checking cst enabled or not
				/*$cst_status = $this->sales_obj->get_cst($group_id);*/
				$cst_status = 0;
				if($cst_status){ $sales_cst = $cst_status; }

				#------------cheque / dd details
				$cd_status = 1;
				if($this->input->post('payment_mode',true) > 2){
					$cd_status = 0;
				}

				#------------template
				$this->template->title("New Sales Voucher");
				$this->template->main_heading($this->lang->line("$voucher_name"));
				$this->template->breadcrumb(array($this->lang->line("$voucher_name") => 'no_link',$this->lang->line('report') => 'sales/report'));
				$this->template->slice('dms/message');
				$this->template->slice('sales/sales_order/sales',array('sales_order_array' => $sales_order_array,'customer_name' => $customer_name,'user_type' => $user_type['designation_name'],'user' => $user,'pricelist' => $pricelist,'area_id' => $area_id,'voucher_types' => $voucher_types,'voucher_name' => $voucher_name,'voucher_type' => $vtype_id,'disabled' => $disabled,'items' => $items,'goDowns' => $goDowns,'units' => $units,'sales_cst' => $sales_cst,'stock_count' => $stock_count,'primary_unit' => $primary_unit['symbol'],'payment_modes' => $payment_modes,'sales_items' => $sales_items,'voucher_no' => $voucher_no,'voucher_date' => $voucher_date,'cd_status' => $cd_status,'presumptive_tax'=>$presumptive_tax,'bill_prefix'=>$bill_prefix));
				$this->template->other_script('sales/sales_order');
				$this->template->render();
			}
		}
		else{
			redirect('users/logout');
		}
	}

	public function so_update()
	{
		#----------sales items id from sales / sales order
		$sales_temp_id = $this->uri->segment(3);

		// $row = $this->sales_obj->get_sales_items(array('columns' => array('id','group_id','item_id','qty','unit_id','rate','amount','discount_per','discount_amt','vat_amt','cst','godown_id','item_status'),'conditions' => array('id' => $sales_temp_id)));
		$row = $this->sales_obj->get_sales_itemss(array('columns' => array('id','group_id','item_id','qty','unit_id','rate','amount','discount_per','discount_amt','cgst_amt','sgst_amt','godown_id','item_status'),'conditions' => array('id' => $sales_temp_id)));
		if(!empty($row))
		{
			$sales_temp_data = $row[0];

			#-----------validation
			$this->form_validation->set_rules('godown_id','lang:godown','required|xss_clean');
			$this->form_validation->set_rules('cst','lang:cst','xss_clean|greater_or_equal[0]|less_or_equal[100]');
			$this->form_validation->set_rules('qty','lang:quantity','required|xss_clean|greater_than[0]|less_than[100000000]');
			$this->form_validation->set_rules('unit_id','lang:unit','required|xss_clean');
			$this->form_validation->set_rules('rate','lang:rate','required|xss_clean|greater_or_equal[0]|less_than[100000000]');
			$this->form_validation->set_rules('amount','lang:amount','xss_clean|required|greater_or_equal[0]|less_than[100000000]');
			$this->form_validation->set_rules('discount_per','lang:discount %','xss_clean|greater_or_equal[0]|less_or_equal[100]');
			$this->form_validation->set_rules('discount_amt','lang:discount','xss_clean|greater_or_equal[0]|less_than[100000000]');
			$this->form_validation->set_rules('vat_amt','lang:vat-amt','xss_clean|greater_or_equal[0]|less_than[100000000]');

			#-----------redirect uri
			$update_uri = $this->uri->uri_to_assoc(4);
			$redirect_uri = $this->uri->assoc_to_uri($update_uri);

			#-----------updating temporary data
			if($this->form_validation->run() === true)
			{
				$item_temp_array = $this->input->post(NULL,true);

				#----------rate calculation
				$item_temp_array['rate'] = 0;
				if($item_temp_array['qty'] != 0){
					$item_temp_array['rate'] = $item_temp_array['amount'] / $item_temp_array['qty'];
				}

				#------------presumptive tax checking
				$presumptive_tax = $this->stock->get_tax_type();

				#----------VAT calculation
			/*	$cst = 0;
				if(array_key_exists('cst',$item_temp_array)){
					$cst = $item_temp_array['cst'];
				}
				if(empty($presumptive_tax)){
					if($cst == 0){
						$item_temp_array['vat_percent'] = $this->stock->get_item_vat($sales_temp_data['item_id']);
					}
				}	*/
				$item_temp_array['cgst'] =  $this->stock->get_item_cgst($sales_temp_data['item_id']);
				$item_temp_array['sgst'] =  $this->stock->get_item_sgst($sales_temp_data['item_id']);
				
				#----------start transaction
				$this->db->trans_start();

		//		if($sales_temp_data['item_status'] == 0 && ($sales_temp_data['qty'] != $item_temp_array['qty'] || $sales_temp_data['unit_id'] != $item_temp_array['unit_id'] || $sales_temp_data['rate'] != $item_temp_array['rate'] || $sales_temp_data['discount_per'] != $item_temp_array['discount_per'] || $sales_temp_data['discount_amt'] != $item_temp_array['discount_amt'] || $sales_temp_data['godown_id'] != $item_temp_array['godown_id'] || $sales_temp_data['cst'] != $cst || $sales_temp_data['vat_amt'] != $item_temp_array['vat_amt']))
				if($sales_temp_data['item_status'] == 0 && ($sales_temp_data['qty'] != $item_temp_array['qty'] || $sales_temp_data['unit_id'] != $item_temp_array['unit_id'] || $sales_temp_data['rate'] != $item_temp_array['rate'] || $sales_temp_data['discount_per'] != $item_temp_array['discount_per'] || $sales_temp_data['discount_amt'] != $item_temp_array['discount_amt'] || $sales_temp_data['godown_id'] != $item_temp_array['godown_id'] || $sales_temp_data['sgst_amt'] != $item_temp_array['sgst_amt'] || $sales_temp_data['cgst_amt'] != $item_temp_array['cgst_amt']))
				{
					$item_temp_array['group_id'] = $sales_temp_data['group_id'];
					$item_temp_array['item_id'] = $sales_temp_data['item_id'];
					$item_temp_array['status'] = -1;
					$item_temp_array['item_status'] = 2;
					$sales_temp_data['item_status'] = 2;
					if($this->sales_obj->update_others(array('table' => 'dms_sales_items1','data' => array('item_status' => -1),'conditions' => array('id' => $sales_temp_id)))){
						$sales_temp_id = $this->sales_obj->insert('dms_sales_items1',$item_temp_array);
						$this->message->set($this->lang->line('sales-edit-temp-success'));
					}
				}
				else
				{
					$item_temp_array['status'] = -1;
					$this->sales_obj->update_others(array('table' => 'dms_sales_items1','data' => $item_temp_array,'conditions' => array('id' => $sales_temp_id)));
					$this->message->set($this->lang->line('sales-edit-temp-success'));
				}

				#--------------updating bill status in dms_sales
				if($this->sales_obj->get_bills(array('columns' => 'id','conditions' => array('group_id' => $sales_temp_data['group_id'],'status =' => 1),'numrows' => true)) > 0)
				{
					$this->sales_obj->update_others(array('table' => 'dms_sales','data' => array('status' => -1),'conditions' => array('group_id' => $sales_temp_data['group_id'])));
				}

				#--------------updating temporary stock balance in dms_stocks
				if($sales_temp_data['item_status'] == 2)
				{
					$stock_bal_temp = $this->stock->unit_conversion($sales_temp_data['item_id'],$item_temp_array['unit_id'],$item_temp_array['qty'],$item_temp_array['rate'],$item_temp_array['amount']);
					if($stock_bal_temp)
					{
						$this->sales_obj->update_others(array('table' => 'dms_stocks','data' => array('godown_id' => $item_temp_array['godown_id'],'qty' => $stock_bal_temp['qty'],'unit_id' => $stock_bal_temp['primary_unit'],'rate' => $stock_bal_temp['rate'],'amount' => $stock_bal_temp['amount']),'conditions' => array('stock_status' => 6,'table_id' => $sales_temp_id)));
					}
				}

				#----------end transaction
				$this->db->trans_complete();

				redirect($redirect_uri);
			}

			#----------voucher name
			$voucher_name = $this->vouchers->voucher_name($this->vtype);

			#-----------sales cst checking details
			$sales_cst = $this->stock->get_constant(array('sales_cst'));

			#------------presumptive tax checking
			$presumptive_tax = $this->stock->get_tax_type();

			#------------checking cst enabled or not
		/*	$cst_status = $this->sales_obj->get_cst($sales_temp_data['group_id']);*/
		$cst_status = 0;
			if($cst_status){
				$sales_cst = $cst_status;
			}

			#------------item details / unit details / godown details
			$units = array();$goDowns = array();
			$item_details = $this->stock->get_item($sales_temp_data['item_id'],array('item_code','item_name'));
			$items[$sales_temp_data['item_id']] = $item_details['item_code']." / ".$item_details['item_name'];
			$goDowns = $this->stock->get_item_godowns(array('item_id'=>$sales_temp_data['item_id'],'listing'=>1));
			$goDowns[''] = 'Select';
			ksort($goDowns);
			$units = $this->stock->get_units($sales_temp_data['item_id']);

			#------------sale date
			$sale_bill_date = "";$stock_count = "";
			$sale_data = $this->sales_obj->get_bills(array('columns' => 'bill_date','conditions' => array('group_id' => $sales_temp_data['group_id'],'status !=' => 0)));
			if(!empty($sale_data))
			{
				$sale_bill_date = $sale_data[0]['bill_date'];

				#------------stock count of this item
				$stock_count = $this->stock->get_stock_count($sales_temp_data['godown_id'],$sales_temp_data['item_id'],$sale_bill_date);
			}

			#------------primary unit details
			$primary_unit = $this->stock->get_primary_unit($sales_temp_data['item_id']);

			#------------template
			$this->template->title("Update Sales Voucher");
			$this->template->main_heading($this->lang->line("$voucher_name"));
			$this->template->breadcrumb(array($this->lang->line("$voucher_name") => 'order_to_sales/so_sales',$this->lang->line("update") => 'no_link',$this->lang->line('go-back') => array($redirect_uri)));
			$this->template->slice('dms/message');
			$this->template->slice('sales/sales_entry/edit_temp',array('voucher_name' => $voucher_name,'items' => $items,'units' => $units,'goDowns' => $goDowns,'sales_temp_data' => $sales_temp_data,'sales_cst' => $sales_cst,'presumptive_tax' => $presumptive_tax,'stock_count' => $stock_count,'unit_symbol' => $primary_unit['symbol'],'sale_date' => $sale_bill_date));
			$this->template->other_script('sales/sales_order');
			$this->template->render();
		}
		else
		{
			redirect(base_url());
		}
	}

	public function so_delete()
	{
		$id=$this->uri->segment(3,0);

		#-----------redirect uri
		$update_uri = $this->uri->uri_to_assoc(4);
		$redirect_uri = $this->uri->assoc_to_uri($update_uri);

		$result = $this->sales_obj->get_sales_items(array('columns' => array('group_id','status','item_status'),'conditions' => array('id' => $id)));
		if(!empty($result))
		{
			$row = $result[0];
			if($row['item_status'] == 0)
			{
				$this->sales_obj->update_others(array('table' => 'dms_sales_items1','data' => array('item_status' => -1),'conditions' => array('id' => $id)));
				$this->message->set($this->lang->line('sales-item-delete-success'));
			}
			else
			{
				if($row['status'] == -1)
				{
					#----------start transaction
					$this->db->trans_start();

					if($this->sales_obj->delete(array('table' => 'dms_sales_items1','conditions' => array('id' => $id))))
					{
						#-------------deleting stock bal. from dms_stocks
						$this->sales_obj->delete(array('table' => 'dms_stocks','conditions' => array('table_id' => $id,'stock_status' => 6)));

						$count = $this->sales_obj->get_sales_items(array('columns' => array('group_id'),'conditions' => array('group_id' => $row['group_id'],'status !=' => 0,'item_status !=' => 0),'numrows' => true));
						if($count == 0){
							$this->sales_obj->delete(array('table' => 'dms_sales','conditions' => array('group_id' => $row['group_id'])));
						}
						$this->message->set($this->lang->line('sales-item-delete-success'));
					}
					else
					{
						$this->message->set($this->lang->line('sales-item-delete-error'),'e');
					}

					#----------end transaction
					$this->db->trans_complete();
				}
			}
		}
		redirect($redirect_uri);
	}

	public function bill_no_exists($bill_no,$v_details = NULL)
	{
		if($v_details == NULL){
			$where = array('vtype_id' => $this->input->post('vtype_id',true),'bill_no' => $bill_no,'status !=' => 0);
		}
		else{
			$exp = explode('.', $v_details);
			$where = array('vtype_id' => $exp[0],'bill_no' => $bill_no,'group_id !=' => $exp[1],'status !=' => 0);
		}
		$row = $this->sales_obj->get_bills(array('columns' => array('id'),'conditions' => $where,'numrows' => true));
		if($row == 0){
			return true;
		}
		return false;
	}
}
?>