<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

class Payment_against_bill extends MY_Controller{

	var $companyID;
	var $branchID;
	var $createdBY;
	var $fiscal_start_date;
	var $fiscal_end_date;

	#------------------------------------
	public function __construct(){

		parent::__construct();
		$this->check_access_right();

		#---------------- Checking Financial year is enabled / closed-----------------#
		$method_array = array('add','edit','delete');
		fiscal_status($this->uri->segment(2),$method_array,"payment_against_bill/report");
		#---------------- Checking Financial year is enabled / closed-----------------#

		$this->companyID = $this->session->userdata('company_id');
		$this->branchID = $this->session->userdata('under_id');
		$this->createdBY = $this->session->userdata('id');
		$fiscals = $this->dms->get_fiscal_year();
		$this->fiscal_start_date = $fiscals['start_date'];
		$this->fiscal_end_date = $fiscals['end_date'];
	}

	#----------------------------------------------------------------------

	public function add(){

		$this->template->title($this->lang->line('payment-against-bill'));
		$this->template->main_heading($this->lang->line('payment-against-bill'));
		$this->template->breadcrumb(array($this->lang->line('payment-against-bill') => 'no_link',$this->lang->line('report') => 'payment_against_bill/report'));

		$this->load->library('Stock');
		$this->load->model('payments/Payment_against_bill_model','payment_against_bill');
		$this->load->library('Payment_ab_lib');
		$this->load->model('vouchers/Voucher_model','voucher');
		$vendors = $vendorBalanceBills = $bank_accounts = $existsRAB = array();
		$inputSelects = array('vendors','vendorBalanceBills','bank_accounts');
		$receiptNo = $this->payment_against_bill->get_receipt_number();
		$voucherNo = $this->voucher->get_voucher_number(1);
		$receiptNo = $voucherNo;
		$vendor_id = NULL;$vendor_bill=$bank = NULL;
		$vendors = $this->stock->get_vendors();

		$existsRAB = array();
		$args = array();
		$args['select'] = array('dvab.id','dvab.bill_no','dvab.bill_date','dvab.customer_type_id','dvab.customer_id','dvabi.id as dvabi_id','dvabi.ps_id','dvabi.received_amount','dvabi.discount','dp.bill_no as purchase_bill_no','dp.bill_date as purchase_bill_date');
		$args['conditions'] = array('dvab.branch_id'=>$this->branchID,'dvab.bill_type'=>1,'dvab.status'=>-1,'dvab.created_by'=>$this->createdBY);
		$args['join'] = array('dms_voucher_against_bill_items as dvabi'=>'dvab.id=dvabi.vid','dms_purchases as dp'=>'dvabi.ps_id=dp.id');
		$existsRAB = $this->payment_against_bill->get($args);

		if(!empty($existsRAB)){
			$vendor_id = $existsRAB[0]['customer_id'];
			$receipt_date = date('Y-m-d',strtotime($existsRAB[0]['bill_date']));
			$tempReceiptID = $existsRAB[0]['id'];
			$vendorBalanceBills = $this->payment_ab_lib->get_vendor_bill($vendor_id);
			$bank_accounts = $this->stock->payment_modes(array('sub_groups'=>array(14)));
		}

		if(isset($_POST['add_to_bill'])){
			if(empty($existsRAB)){
				$this->form_validation->set_rules('bill_date','lang:bill-date','xss_clean|required|valid_date|is_date|check_date['.date('Y-m-d').'.<=]');
				$this->form_validation->set_rules('vendor_id','lang:vendor','xss_clean|required');
			}
			if($this->input->post('vendor_id')){
				$vendor_id = $this->input->post('vendor_id');
				$vendorBalanceBills = $this->payment_ab_lib->get_vendor_bill($vendor_id);
			}
			$this->form_validation->set_rules('bill_no','lang:bill-no','xss_clean|required|is_natural|greater_than[0]');
			$this->form_validation->set_rules('vendor_bill','lang:purchase-bill','xss_clean|required');
			$this->form_validation->set_rules('received_amount','lang:current-payment','xss_clean|required|greater_than[0]');
			$this->form_validation->set_rules('discount_amount','lang:discount','xss_clean|numeric');
			$this->form_validation->set_rules('amount','lang:amount','xss_clean');
			$this->form_validation->set_rules('cbill_date','lang:bill-date','xss_clean');
			$this->form_validation->set_rules('cbill_amt','lang:bill-amount','xss_clean');
			$this->form_validation->set_rules('cpr_amt','lang:previous-payments','xss_clean');

			if($this->form_validation->run('add_to_bill') === true){

				$tempReceiptID = NULL;
				$postedItems = $this->input->post();
				$bill_num = $postedItems['bill_no'];
				if(empty($existsRAB)){
					$receipt_date = date('Y-m-d',strtotime($postedItems['bill_date']));
				}
				$purchase_bill = $this->payment_ab_lib->get_purchase_bill($postedItems['vendor_bill']);
				$bill_date = date('Y-m-d',strtotime($purchase_bill['bill_date']));
				$bill_amount = round_this($purchase_bill['bill_amount']);
				$total_paid_amount = $this->payment_ab_lib->get_bill_payment($postedItems['vendor_bill']);
				$balance_bill_amount = ($bill_amount-$total_paid_amount);

				$args = array();
				$args['columns'] = array('id');
				$args['table'] = 'dms_vouchers';
				$args['conditions'] = array('vno'=>$bill_num,'vtype_id'=>1,'status !='=>0);
				$vouchers = $this->voucher->get_vouchers($args);

				$args = array();
				$args['columns'] = array('id');
				$args['table'] = 'dms_voucher_temps';
				$args['conditions'] = array('vno'=>$bill_num,'vtype_id'=>1);
				$vouchersTemps = $this->voucher->get_vouchers($args);

				if(empty($vouchers) && empty($vouchersTemps)){

					if(strtotime($receipt_date) >= strtotime($bill_date)){
						if($postedItems['received_amount'] <= $balance_bill_amount){
							$this->db->trans_start();
							if(empty($existsRAB)){
								#---save temp data
								if($this->payment_against_bill->save_bill(array('branch_id'=>$this->branchID,'bill_no'=>$bill_num,'bill_date'=>$receipt_date,'customer_id'=>$postedItems['vendor_id'],'bill_type'=>1,'status'=>-1,'created_by'=>$this->createdBY))){
									$tempReceiptID = $this->db->insert_id();
								}
							}else{
								$tempReceiptID = $existsRAB[0]['id'];
								$this->payment_against_bill->update(array('bill_no'=>$bill_num),array('id'=>$tempReceiptID));
							}

							if(!empty($tempReceiptID)){

								#dms_voucher_against_bill_items
								$args = array();
								$args['select'] = array('dvab.id');
								$args['conditions'] = array('dvab.id'=>$tempReceiptID,'dvabi.ps_id'=>$postedItems['vendor_bill'],'dvabi.status'=>1);
								$args['join'] = array('dms_voucher_against_bill_items as dvabi'=>'dvab.id=dvabi.vid');
								$checkRcptBill = $this->payment_against_bill->get($args);
								if(empty($checkRcptBill)){
									if($this->payment_against_bill->save_bill_items(array('vid'=>$tempReceiptID,'ps_id'=>$postedItems['vendor_bill'],'received_amount'=>$postedItems['received_amount'],'discount'=>$postedItems['discount_amount'],'status'=>1))){
										$this->db->trans_complete();
										$this->message->set($this->lang->line('bill-added-to-pab'));
										redirect('payment_against_bill/add');
									}
								}else{
									$this->message->set($this->lang->line('same-bill-exists'),'e');
								}
							}
						}else{
							$this->message->set($this->lang->line('greater-balance-amount'),'e');
						}
					}else{
						$this->message->set($this->lang->line('enter-valid-payment-date'),'e');
					}
				}else{
					$this->message->set($this->lang->line('enter-valid-pvoucher-number'),'e');
				}
			}
		}
		#-----------------

		if(isset($_POST['save'])){

			$this->form_validation->set_rules('receipt_mode','lang:payment-mode','xss_clean|required');
			$this->form_validation->set_rules('bill_no','lang:bill-no','xss_clean|required|is_natural|greater_than[0]');
			$chequeNoRule = $chequeDateRule = $colBankRule = 'xss_clean';
			if($this->input->post('receipt_mode') && $this->input->post('receipt_mode') != 0){
				$chequeNoRule .= '|required';
				$chequeDateRule .= '|required|is_date';
				$colBankRule .= '|required';
				$this->form_validation->set_rules('ccd','lang:transaction-type','xss_clean|required');
			}
			$this->form_validation->set_rules('cheque_no','lang:cd-no',$chequeNoRule);
			$this->form_validation->set_rules('cheque_date','lang:cheque-date',$chequeDateRule);
			$this->form_validation->set_rules('payment_mode','lang:collection-bank',$colBankRule);
			$this->form_validation->set_rules('narration','lang:narration','xss_clean');
			if($this->form_validation->run('save') === true){

				$chequeDd = $this->input->post('receipt_mode');
				$bill_num = $this->input->post('bill_no');
				$args = array();
				$args['columns'] = array('id');
				$args['table'] = 'dms_vouchers';
				$args['conditions'] = array('vno'=>$bill_num,'vtype_id'=>1,'status !='=>0);
				$vouchers = $this->voucher->get_vouchers($args);

				$args = array();
				$args['columns'] = array('id');
				$args['table'] = 'dms_voucher_temps';
				$args['conditions'] = array('vno'=>$bill_num,'vtype_id'=>1);
				$vouchersTemps = $this->voucher->get_vouchers($args);

				if(empty($vouchers) && empty($vouchersTemps)){

					if($this->input->post('receipt_mode') != 0){
						$ccd = $this->input->post('ccd',true);
						$payment_mode = $this->input->post('payment_mode');
						$cheque_no = $this->input->post('cheque_no');
						$chequeDate = date('Y-m-d',strtotime($this->input->post('cheque_date')));

					}else{
						$ccd = 0;
						$payment_mode = 0;
						$cheque_no = NULL;
						$chequeDate = '0000-00-00';

					}
					$narration = $this->input->post('narration');

					$args = array();
					$args['fields'] = array('ledger_id');
					$args['return'] = 1;
					$args['conditions'] = array('id'=>$vendor_id);
					$vendorDetails = $this->stock->get_vendors($args);
					$cust_ledgerID = $vendorDetails['ledger_id'];

					$drLedgerID = 1;# ledger id of CASH
					if($chequeDd > 0){
						$drLedgerID = $payment_mode;# ledger id of bank accounts
					}

					if(!empty($cust_ledgerID)){
						$this->db->trans_start();
						$updateArray = array('bill_no'=>$bill_num,'cash_type'=>$ccd,'payment_mode'=>$drLedgerID,'narration'=>$narration,'cheque_no'=>$cheque_no,'cheque_date'=>$chequeDate,'status'=>1);

						if($this->payment_against_bill->update($updateArray,array('id'=>$tempReceiptID))){

							#-------voucher starts here---------------------------------------------------------------------
							$receiptAmounts = $this->payment_against_bill->get_receipt_amount($tempReceiptID);
							$receiptAmount = $receiptAmounts['amount'];
							$receiptDiscount = $receiptAmounts['discount'];
							$receiptAmount = $receiptAmount-$receiptDiscount;
							#$newVchrNo = $this->voucher->get_voucher_number(1);
							$groupID = $this->stock->get_group_id('dms_vouchers');
							$voucherStatus = 1;

							if(strtotime($chequeDate) > strtotime($receipt_date) && $chequeDd >0){

								$voucherStatus = 3;
							}
							if($chequeDd > 0){
								if($this->voucher->insert('dms_voucher_banks',array('group_id'=>$groupID,'cash_type'=>$ccd,'cd_no'=>$cheque_no,'pdc'=>$chequeDate,'vdate'=>$receipt_date,'cq_status'=>0))){
								}
							}

							$this->voucher->insert("dms_vouchers",array('group_id'=>$groupID,'vtype_id'=>1,'vno'=>$bill_num,'vorder_no'=>1,'vdate'=>$receipt_date,'cr_ledger'=>$drLedgerID,'dr_ledger'=>$cust_ledgerID,'vamount'=>$receiptAmount,'table_name'=>'dms_voucher_against_bills','table_group_id'=>$tempReceiptID,'status'=>$voucherStatus));

							if(!empty($receiptDiscount) and $receiptDiscount>0){

								$this->voucher->insert("dms_vouchers",array('group_id'=>$groupID,'vtype_id'=>1,'vno'=>$bill_num,'vorder_no'=>2,'vdate'=>$receipt_date,'dr_ledger'=>$cust_ledgerID,'cr_ledger'=>9,'vamount'=>$receiptDiscount,'table_name'=>'dms_voucher_against_bills','table_group_id'=>$tempReceiptID,'status'=>$voucherStatus));
							}
							#=====================================================
							$this->db->trans_complete();
							$this->message->set($this->lang->line('pab-saved'));
							redirect('payment_against_bill/add');
						}
					}else{
						$this->message->set($this->lang->line('pab-saved'),'e');
						redirect('payment_against_bill/add');
					}
				}else{
					$this->message->set($this->lang->line('enter-valid-pvoucher-number'),'e');
				}
			}
		}
		#----------------------

		foreach($inputSelects as $key=>$selectBox){
			$arrayName = $$selectBox;
			$arrayName[''] = 'Select';
			$$selectBox = $arrayName;
			ksort($$selectBox);
		}

		# view starts here--------------------------------
		$this->template->slice('dms/message');
		$this->template->slice('payment_against_bill/add_payment_against_bill',array('bill_num'=>$receiptNo,'vendors'=>$vendors,'vendor_id'=>$vendor_id,'vendor_bills'=>$vendorBalanceBills,'vendor_bill'=>$vendor_bill,'payment_bill_items'=>$existsRAB,'bank_accounts'=>$bank_accounts,'bank'=>$bank));
		$this->template->other_script(array('payments/payment_against_bill'));
		$this->template->render();
	}

	#-----------------------------------------------------------------------

	public function remove_temp_item(){

		if(!$this->uri->segment(3)){
			redirect('users/logout');
		}
		$tempItemID = $this->uri->segment(3);
		if($this->if_exists('dms_voucher_against_bill_items',array('id'=>$tempItemID,'created_by'=>$this->createdBY)) === false){
			redirect('payment_against_bill/add');
		}
		$this->load->model('payments/Payment_against_bill_model','payment_against_bill');

		if($this->payment_against_bill->delete_item($tempItemID)){
			$this->message->set($this->lang->line('item-deleted-from-bill'));
		}

		redirect('payment_against_bill/add');
	}

	#-----------------------------------------------------------------------

	public function report(){

		$this->template->title($this->lang->line('payment-against-bill-report'));
		$this->template->main_heading($this->lang->line('payment-against-bill-report'));
		$this->template->breadcrumb(array($this->lang->line('payment-against-bill') => 'payment_against_bill/add',$this->lang->line('report') => 'no_link'));

		$this->load->library('Stock');
		$this->load->model('payments/Payment_against_bill_model','payment_against_bill');
		$offset =0;$links=NULL;$payments = array();

		$this->load->library('Pagination');
		$config['per_page'] = $this->per_page();
		$config['uri_segment'] = 3;
		$config['base_url'] = base_url('payment_against_bill/report');
		$offset = ($this->uri->segment(3))?$this->uri->segment(3):0;
		$from_date = $this->fiscal_start_date;
		$to_date = $this->fiscal_end_date;
		if(isset($_POST['get'])){

			$this->form_validation->set_rules('from_date','lang:from-date','xss_clean|required|is_date');
			$this->form_validation->set_rules('to_date','lang:to-date','xss_clean|required|is_date');
			if($this->form_validation->run() === true){
				$from_date = date('Y-m-d',strtotime($this->input->post('from_date')));
				$to_date = date('Y-m-d',strtotime($this->input->post('to_date')));
				$config['base_url'] = base_url('payment_against_bill/report/'.$from_date.'/'.$to_date);
			}
		}else if($this->uri->segment(3) && $this->uri->segment(4)){

			$from_date = date('Y-m-d',strtotime($this->uri->segment(3)));
			$to_date = date('Y-m-d',strtotime($this->uri->segment(4)));
			$config['uri_segment'] = 5;
			$offset = ($this->uri->segment(5))?$this->uri->segment(5):0;
			$config['base_url'] = base_url('payment_against_bill/report/'.$from_date.'/'.$to_date);

		}else{
			$from_date = date('Y-m-d');#$this->fiscal_start_date;
			$to_date = date('Y-m-d');#$this->fiscal_end_date;
		}

		$args = array();
		$args['select'] = array('dvab.id');
		$args['num_rows'] = 1;
		$args['between'] = array($from_date,$to_date);
		$args['conditions'] = array('dvab.branch_id'=>$this->branchID,'dvab.bill_type'=>1,'dvab.status'=>1);
		$config['total_rows'] = $this->payment_against_bill->get($args);
		# Pagination Config Customizations
        $config['full_tag_open'] = '<ul class="pagination">';
        $config['full_tag_close'] = '</ul>';
        $config['first_link'] = 'First';
        $config['last_link'] = 'Last';
        $config['next_link'] = '&raquo;';
        $config['prev_link'] = '&laquo;';
        $config['cur_tag_open'] = '<li class="active"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
		$this->pagination->initialize($config);
		$links = $this->pagination->create_links();

		$args = array();
		$args['select'] = array('dvab.id','dvab.bill_no','dvab.bill_date','dvab.customer_id','dvab.payment_mode','dvab.narration','dvab.cheque_no','dvab.cheque_date');
		if($this->dms->get_main_branch($this->branchID) === true){
			$args['select'][] = 'imm.manufacturer_name';
		}else{
			$args['select'][] = 'bm.branch_name as manufacturer_name';
		}
		$args['conditions'] = array('dvab.branch_id'=>$this->branchID,'dvab.bill_type'=>1,'dvab.status'=>1);
		if($this->dms->get_main_branch($this->branchID) === true){
			$args['join'] = array('item_manufacturer_master as imm'=>'dvab.customer_id=imm.id');
		}else{
			$args['join'] = array('branch_master as bm'=>'dvab.customer_id=bm.id');
		}
		$args['limit'] = $config['per_page'];
		$args['offset'] = $offset;
		$payments = $this->payment_against_bill->get($args);
		if(empty($payments)){
			$this->message->set($this->lang->line('no-result-found'),'i');
		}
		foreach($payments as $key=>$payment){

			$receiptsDtls = $this->payment_against_bill->get_receipt_amount($payment['id']);
			$receiptAmount=0;
			if(!empty($receiptsDtls)){
				$receiptAmount = $receiptsDtls['amount']-$receiptsDtls['discount'];
			}
			$payments[$key]['amount'] = $receiptAmount;
		}


		# view starts here--------------------------------
		$this->template->slice('dms/message');
		$this->template->slice('date/between_date_search',array('from_date'=>$from_date,'to_date'=>$to_date));
		$this->template->slice('payment_against_bill/payment_against_bill_report',array('payments'=>$payments,'count'=>$offset+1,'links'=>$links));
		$this->template->other_script(array('payments/payment_against_bill'));
		$this->template->render();
	}

	#------------------------------------------------------------------------

	public function view(){

		if(!$this->uri->segment(3)){
			redirect('payment_against_bill/report');
		}

		$receiptID = $this->uri->segment(3);
		if($this->if_exists('dms_voucher_against_bills',array('id'=>$receiptID,'status'=>1,'bill_type'=>1)) === false){
			redirect('payment_against_bill/report');
		}
		$uriArray = $this->uri->uri_to_assoc(4);
		$urlString = $this->uri->assoc_to_uri($uriArray);
		$this->load->library('Stock');
		$this->load->model('payments/Payment_against_bill_model','payment_against_bill');
		$this->load->library('Payment_ab_lib');
		$payments = array();

		$this->template->title($this->lang->line('view-payment-against-bill'));
		$this->template->main_heading($this->lang->line('view-payment-against-bill'));
		$this->template->breadcrumb(array($this->lang->line('payment-against-bill') => 'payment_against_bill/add',$this->lang->line('report') => 'payment_against_bill/report',$this->lang->line('view')=>'no_link',$this->lang->line('go-back')=>array('payment_against_bill/report/'.$urlString)));

		$args = array();
		$args['select'] = array('dvab.id','dvab.bill_no','dvab.bill_date','dvab.customer_type_id','dvab.customer_id','dvab.cash_type','dvab.payment_mode','dvab.narration','dvab.cheque_no','dvab.cheque_date','dvabi.id as dvabi_id','dvabi.ps_id','dvabi.received_amount','dvabi.discount','dp.bill_no as purchase_bill_no','dp.bill_date as purchase_bill_date','dl.ledger_name');
		$args['conditions'] = array('dvab.id'=>$receiptID,'dvabi.status'=>1);
		$args['join'] = array('dms_voucher_against_bill_items as dvabi'=>'dvab.id=dvabi.vid','dms_purchases as dp'=>'dvabi.ps_id=dp.id','dms_ledgers as dl'=>'dvab.payment_mode=dl.id');
		$payments = $this->payment_against_bill->get($args);

		# view starts here--------------------------------
		$this->template->slice('dms/message');
		$this->template->slice('payment_against_bill/view_payment_against_bill',array('payments'=>$payments));
		$this->template->other_script(array('payments/payment_against_bill'));
		$this->template->render();
	}

	#------------------------------------------------------------------------

	public function edit(){

		if(!$this->uri->segment(3)){
			redirect('payment_against_bill/report');
		}

		$receiptID = $this->uri->segment(3);
		if($this->if_exists('dms_voucher_against_bills',array('id'=>$receiptID,'status'=>1,'bill_type'=>1)) === false){
			redirect('payment_against_bill/report');
		}
		$uriArray = $this->uri->uri_to_assoc(4);
		$urlString = $this->uri->assoc_to_uri($uriArray);

		$this->load->library('Stock');
		$this->load->model('payments/Payment_against_bill_model','payment_against_bill');
		$this->load->library('Payment_ab_lib');

		$this->template->title($this->lang->line('edit-payment-against-bill'));
		$this->template->main_heading($this->lang->line('edit-payment-against-bill'));
		$this->template->breadcrumb(array($this->lang->line('payment-against-bill') => 'payment_against_bill/add',$this->lang->line('report') => 'payment_against_bill/report',$this->lang->line('edit')=>'no_link',$this->lang->line('go-back')=>array('payment_against_bill/report/'.$urlString)));

		$vendors = $vendorBalanceBills = $bank_accounts = $voucher_details=$receipts=array();
		$inputSelects = array('vendors','vendorBalanceBills','bank_accounts');
		$vendor_id = $vendor_bill=$bank = '';
		$vendors = $this->stock->get_vendors();
		$bank_accounts = $this->stock->payment_modes(array('sub_groups'=>array(14)));

		$existsRAB = array();
		$args = array();
		$args['select'] = array('dvab.id','dvab.bill_no','dvab.bill_date','dvab.customer_id','dvab.cash_type','dvab.payment_mode','dvab.narration','dvab.cheque_no','dvab.cheque_date','dvabi.id as dvabi_id','dvabi.ps_id','dvabi.received_amount','dvabi.discount','dp.bill_no as purchase_bill_no','dp.bill_date as purchase_bill_date','dl.ledger_name');
		$args['conditions'] = array('dvab.id'=>$receiptID,'dvabi.status'=>1);
		$args['join'] = array('dms_voucher_against_bill_items as dvabi'=>'dvab.id=dvabi.vid','dms_purchases as dp'=>'dvabi.ps_id=dp.id','dms_ledgers as dl'=>'dvab.payment_mode=dl.id');
		$receipts = $this->payment_against_bill->get($args);

		$args = array();
		$args['select'] = array('dv.*','dv.status as voucher_status','dv.group_id as voucher_group');
		$args['conditions'] = array('dvab.id'=>$receiptID,'dv.table_name'=>'dms_voucher_against_bills','dv.status !='=>0);
		$args['join'] = array('dms_vouchers as dv'=>'dvab.id=dv.table_group_id');
		$voucher_details = $this->payment_against_bill->get($args);

		$preVoucherStatus=0;$voucherGroupID=$voucherDrLedger=0;
		if(!empty($receipts)){

			$args = array();
			$args['fields'] = array('ledger_id');
			$args['return'] = 1;
			$args['conditions'] = array('id'=>$receipts[0]['customer_id']);
			$vendorDetails = $this->stock->get_vendors($args);
			$vendor_ledgerID = $vendorDetails['ledger_id'];

			$args = array();
			if(!empty($voucher_details)){
				$preVoucherStatus = $voucher_details[0]['voucher_status'];
				$voucherGroupID = $voucher_details[0]['voucher_group'];
				$voucherDrLedger = $voucher_details[0]['dr_ledger'];
			}
			$preCashType = $receipts[0]['cash_type'];
			$receipt_date = $receipts[0]['bill_date'];
			$receipt_number = $receipts[0]['bill_no'];
			$vendorBalanceBills = $this->payment_ab_lib->get_vendor_bill($receipts[0]['customer_id']);

		}

		if(isset($_POST['add_to_bill'])){

			$this->form_validation->set_rules('bill_no','lang:bill-no','xss_clean|required|is_natural|greater_than[0]');
			$this->form_validation->set_rules('bill_date','lang:bill-date','xss_clean|required|valid_date|is_date|check_date['.date('Y-m-d').'.<=]');
			$this->form_validation->set_rules('vendor_bill','lang:purchase-bill','xss_clean|required');
			$this->form_validation->set_rules('received_amount','lang:current-payment','xss_clean|required|greater_than[0]');
			$this->form_validation->set_rules('discount_amount','lang:discount','xss_clean|numeric');
			$this->form_validation->set_rules('amount','lang:amount','xss_clean');
			$this->form_validation->set_rules('cbill_date','lang:bill-date','xss_clean');
			$this->form_validation->set_rules('cbill_amt','lang:bill-amount','xss_clean');
			$this->form_validation->set_rules('cpr_amt','lang:previous-payments','xss_clean');

			if($this->form_validation->run('add_to_bill') === true){

				$cust_bill = $this->input->post('vendor_bill');
				$received_amount = $this->input->post('received_amount');
				$args = array();
				$args['select'] = array('dvab.id');
				$args['conditions'] = array('dvab.id'=>$receiptID,'dvabi.ps_id'=>$cust_bill,'dvabi.status'=>1);
				$args['join'] = array('dms_voucher_against_bill_items as dvabi'=>'dvab.id=dvabi.vid');
				$checkRcptBill = $this->payment_against_bill->get($args);

				if(empty($checkRcptBill)){
					$this->db->trans_start();
					if($this->payment_against_bill->save_bill_items(array('vid'=>$receiptID,'ps_id'=>$cust_bill,'received_amount'=>$received_amount,'status'=>1))){

						#---update voucher----------------------------------------------
						$receiptAmounts = $this->payment_against_bill->get_receipt_amount($receiptID);
						$receiptAmount = $receiptAmounts['amount'];
						$receiptDiscount = $receiptAmounts['discount'];
						$receiptAmount = $receiptAmount-$receiptDiscount;

						$this->load->model('vouchers/Voucher_model','voucher');
						$args = array();
						$args['table'] = 'dms_vouchers';
						$args['columns'] = array('id');
						$args['conditions'] = array('table_name'=>'dms_voucher_against_bills','table_group_id'=>$receiptID,'cr_ledger'=>9);
						$dicount_voucher = $this->dms->get_data($args);
						$this->voucher->update(array('table'=>'dms_vouchers','data'=>array('vamount'=>$receiptAmount),'conditions'=>array('table_name'=>'dms_voucher_against_bills','table_group_id'=>$receiptID,'vorder_no'=>1)));
						if(empty($dicount_voucher)){
							if(!empty($receiptDiscount)){

								$this->voucher->insert("dms_vouchers",array('group_id'=>$voucherGroupID,'vtype_id'=>1,'vno'=>$receipt_number,'vorder_no'=>2,'vdate'=>$receipt_date,'dr_ledger'=>$vendor_ledgerID,'cr_ledger'=>9,'vamount'=>$receiptDiscount,'table_name'=>'dms_voucher_against_bills','table_group_id'=>$receiptID,'status'=>$voucherStatus));

							}
						}else{
							if(!empty($receiptDiscount)){
								$this->voucher->update(array('table'=>'dms_vouchers','data'=>array('vamount'=>$receiptDiscount,'status'=>1),'conditions'=>array('table_name'=>'dms_voucher_against_bills','table_group_id'=>$receiptID,'cr_ledger'=>9)));
							}else{
								$this->voucher->update(array('table'=>'dms_vouchers','data'=>array('vamount'=>$receiptDiscount,'status'=>0),'conditions'=>array('table_name'=>'dms_voucher_against_bills','table_group_id'=>$receiptID,'cr_ledger'=>9)));
							}
						}
						#====================================
						$this->db->trans_complete();
						$this->message->set($this->lang->line('bill-added-to-pab'));
						redirect('payment_against_bill/edit/'.$receiptID.'/'.$urlString);
					}

				}else{
					$this->message->set($this->lang->line('same-bill-exists'),'e');
				}
			}
		}


		if(isset($_POST['save'])){

			$this->form_validation->set_rules('bill_no','lang:bill-no','xss_clean|required|is_natural|greater_than[0]');
			$this->form_validation->set_rules('bill_date','lang:bill-date','xss_clean|required|valid_date|is_date|check_date['.date('Y-m-d').'.<=]');
			$this->form_validation->set_rules('receipt_mode','lang:payment-mode','xss_clean');
			$chequeNoRule = $chequeDateRule = $colBankRule = 'xss_clean';
			if($this->input->post('receipt_mode') && $this->input->post('receipt_mode')){
				$chequeNoRule .= '|required';
				$chequeDateRule .= '|required|is_date';
				$colBankRule .= '|required';
				$this->form_validation->set_rules('ccd','lang:transaction-type','xss_clean|required');
			}
			$this->form_validation->set_rules('cheque_no','lang:cd-no',$chequeNoRule);
			$this->form_validation->set_rules('cheque_date','lang:cheque-date',$chequeDateRule);
			$this->form_validation->set_rules('payment_mode','lang:collection-bank',$colBankRule);
			$this->form_validation->set_rules('narration','lang:narration','xss_clean');
			if($this->form_validation->run() === true){

				$bill_no = $this->input->post('bill_no');
				$receipt_date = date('Y-m-d',strtotime($this->input->post('bill_date')));
				$chequeDd = $this->input->post('receipt_mode');
				$narration = $this->input->post('narration');

				$args = array();
				$args['select'] = array('dvab.id');
				$args['conditions'] = array('dvab.id !='=>$receiptID,'bill_no'=>$bill_no,'bill_type'=>1);
				$checkPmnt = $this->payment_against_bill->get($args);

				if(empty($checkPmnt)){

					if($chequeDd != 0){
						$ccd = $this->input->post('ccd',true);
						$payment_mode = $this->input->post('payment_mode');
						$cheque_no = $this->input->post('cheque_no');
						$chequeDate = date('Y-m-d',strtotime($this->input->post('cheque_date')));
					}else{
						$ccd = 0;
						$payment_mode = 0;
						$cheque_no = NULL;
						$chequeDate = '0000-00-00';
					}

					$drLedgerID = 1;# ledger id of CASH
					if($chequeDd > 0){
						$drLedgerID = $payment_mode;# ledger id of bank accounts
					}
					$this->db->trans_start();
					$updateArray = array('bill_no'=>$bill_no,'bill_date'=>$receipt_date,'cash_type'=>$ccd,'payment_mode'=>$drLedgerID,'narration'=>$narration,'cheque_no'=>$cheque_no,'cheque_date'=>$chequeDate,'status'=>1);

					if($this->payment_against_bill->update($updateArray,array('id'=>$receiptID))){

						#------Voucher Updates------------------------------
						$this->load->model('vouchers/Voucher_model','voucher');

						$voucherStatus = 1;
						if(strtotime($chequeDate) > strtotime($receipt_date) && $chequeDd >0){
							$voucherStatus = 3;
						}
						if($chequeDd > 0){
							if($this->if_exists('dms_voucher_banks',array('group_id'=>$voucherGroupID)) === true){

								$upVbnks = array('cash_type'=>$ccd,'cd_no'=>$cheque_no,'pdc'=>$chequeDate,'vdate'=>$receipt_date,'status'=>1);
								$this->voucher->update(array('table'=>'dms_voucher_banks','data'=>$upVbnks,'conditions'=>array('group_id'=>$voucherGroupID)));

							}else{

								$this->voucher->insert('dms_voucher_banks',array('group_id'=>$voucherGroupID,'cash_type'=>$ccd,'cd_no'=>$cheque_no,'pdc'=>$chequeDate,'vdate'=>$receipt_date,'cq_status'=>0));
							}

						}else{
							$this->voucher->update(array('table'=>'dms_voucher_banks','data'=>array('status'=>0),'conditions'=>array('group_id'=>$voucherGroupID)));

						}
						if($preCashType >0 && $preVoucherStatus ==1){
							$voucherStatus=1;
						}
						$this->voucher->update(array('table'=>'dms_vouchers','data'=>array('vdate'=>$receipt_date,'cr_ledger'=>$drLedgerID,'narration' => $narration,'status'=>$voucherStatus),'conditions'=>array('group_id'=>$voucherGroupID,'table_name'=>'dms_voucher_against_bills','table_group_id'=>$receiptID)));

						$this->db->trans_complete();
						$this->message->set($this->lang->line('pab-saved'));
						redirect('payment_against_bill/edit/'.$receiptID.'/'.$urlString);
					}
				}else{
					$this->message->set($this->lang->line('pab-bill-already-exists'),'e');
				}
			}
		}
		foreach($inputSelects as $key=>$selectBox){
			$arrayName = $$selectBox;
			$arrayName[''] = 'Select';
			$$selectBox = $arrayName;
			ksort($$selectBox);
		}

		# view starts here--------------------------------
		$this->template->slice('dms/message');
		$this->template->slice('payment_against_bill/edit_payment_against_bill',array('receipts'=>$receipts,'voucher_status'=>$preVoucherStatus,'vendors'=>$vendors,'vendor_bills'=>$vendorBalanceBills,'vendor_bill'=>$vendor_bill,'bank_accounts'=>$bank_accounts,'bank'=>$bank));
		$this->template->other_script(array('payments/payment_against_bill'));
		$this->template->render();
	}

	#-------------------------------------------------------------------------

	public function edit_item(){

		if(!$this->uri->segment(3)){
			redirect('payment_against_bill/report');
		}
		$receiptItemID = $this->uri->segment(3);
		if($this->if_exists('dms_voucher_against_bill_items',array('id'=>$receiptItemID,'status'=>1)) === false){
			redirect('payment_against_bill/report');
		}
		$uriArray = $this->uri->uri_to_assoc(4);
		$urlString = $this->uri->assoc_to_uri($uriArray);
		$this->load->library('Stock');
		$this->load->model('payments/Payment_against_bill_model','payment_against_bill');
		$this->load->library('Payment_ab_lib');

		$this->template->title($this->lang->line('edit-payment-against-bill'));
		$this->template->main_heading($this->lang->line('edit-payment-against-bill'));
		$this->template->breadcrumb(array($this->lang->line('payment-against-bill') => 'payment_against_bill/add',$this->lang->line('report') => 'payment_against_bill/report',$this->lang->line('edit')=>'no_link',$this->lang->line('go-back')=>array('payment_against_bill/edit/'.$urlString)));

		$args = array();
		$args['select'] = array('dvab.id','dvab.bill_no','dvab.bill_date','dvab.customer_id','dvab.cash_type','dvab.payment_mode','dvab.narration','dvab.cheque_no','dvab.cheque_date','dvabi.id as dvabi_id','dvabi.ps_id','dvabi.received_amount','dvabi.discount','dp.bill_no as purchase_bill_no','dp.bill_date as purchase_bill_date');
		$args['conditions'] = array('dvabi.id'=>$receiptItemID,'dvabi.status'=>1);
		$args['join'] = array('dms_voucher_against_bill_items as dvabi'=>'dvab.id=dvabi.vid','dms_purchases as dp'=>'dvabi.ps_id=dp.id');
		$receipts = $this->payment_against_bill->get($args);
		$vendorBalanceBills = array(''=>'Select');

		if(!empty($receipts)){

			$args = array();
			$receiptID = $receipts[0]['id'];
			$receipt_date = $receipts[0]['bill_date'];
			$receipt_number = $receipts[0]['bill_no'];
			$args = array();
			$args['select'] = array('dv.*','dv.status as voucher_status','dv.group_id as voucher_group');
			$args['conditions'] = array('dvab.id'=>$receiptID,'dv.table_name'=>'dms_voucher_against_bills','dv.status !='=>0);
			$args['join'] = array('dms_vouchers as dv'=>'dvab.id=dv.table_group_id');
			$voucher_details = $this->payment_against_bill->get($args);
			$preVoucherStatus=0;$voucherGroupID=$voucherDrLedger=0;
			if(!empty($voucher_details)){
				$preVoucherStatus = $voucher_details[0]['voucher_status'];
				$voucherGroupID = $voucher_details[0]['voucher_group'];
				$voucherDrLedger = $voucher_details[0]['dr_ledger'];
			}

			$vendorBalanceBills = $this->payment_against_bill->get_vendor_bill(array('vendor_id'=>$receipts[0]['customer_id']));
			$previous_receipts=$bill_amount=$received_amount=0;
			$disabled = 'disabled';
			$sales_bill = $this->payment_ab_lib->get_purchase_bill($receipts[0]['ps_id']);
			$bill_amount = get_rounded($sales_bill['bill_amount']);
			$received_amount = $receipts[0]['received_amount'];
			$discount_amount = $receipts[0]['discount'];
			$amount = $received_amount-$discount_amount;
			#$condition = array('dvab.bill_date <='=>$receipts[0]['bill_date'],'dvab.bill_no <='=>$receipts[0]['bill_no']);
			$paid_amount = $this->payment_ab_lib->get_bill_payment($receipts[0]['ps_id']);
			$total_paid_amount = $this->payment_ab_lib->get_bill_payment($receipts[0]['ps_id']);
			$total_paid_amount -= $received_amount;
			if($paid_amount >0){
				$previous_receipts = $paid_amount-$received_amount;
			}
			$balance_amount = $bill_amount-$total_paid_amount;
		}

		$this->form_validation->set_rules('received_amount','lang:current-payment','xss_clean|required|greater_than[0]|less_or_equal['.$balance_amount.']');
		$this->form_validation->set_rules('discount_amount','lang:discount','xss_clean|numeric');
		$this->form_validation->set_rules('amount','lang:amount','xss_clean');
		if($this->form_validation->run() === true){

			$receivedAmount= $this->input->post('received_amount');
			$discount_amt = $this->input->post('discount_amount');
			$this->db->trans_start();
			if($this->payment_against_bill->update_receipt_item(array('received_amount'=>$receivedAmount,'discount'=>$discount_amt),array('id'=>$receiptItemID))){

				#====================================
				#---update voucher----------------------------------------------
				$receiptAmounts = $this->payment_against_bill->get_receipt_amount($receiptID);
				$receiptAmount = $receiptAmounts['amount'];
				$receiptDiscount = $receiptAmounts['discount'];
				$receiptAmount = $receiptAmount-$receiptDiscount;

				$args = array();
				$args['table'] = 'dms_vouchers';
				$args['columns'] = array('id');
				$args['conditions'] = array('table_name'=>'dms_voucher_against_bills','table_group_id'=>$receiptID,'cr_ledger'=>9);
				$dicount_voucher = $this->dms->get_data($args);

				$this->load->model('vouchers/Voucher_model','voucher');
				$this->voucher->update(array('table'=>'dms_vouchers','data'=>array('vamount'=>$receiptAmount),'conditions'=>array('table_name'=>'dms_voucher_against_bills','table_group_id'=>$receiptID,'status !='=>0,'vorder_no'=>1)));
				if(empty($dicount_voucher)){
					if(!empty($receiptDiscount)){
						$this->voucher->insert("dms_vouchers",array('group_id'=>$voucherGroupID,'vtype_id'=>1,'vno'=>$receipt_number,'vorder_no'=>2,'vdate'=>$receipt_date,'dr_ledger'=>$voucherDrLedger,'cr_ledger'=>9,'vamount'=>$receiptDiscount,'table_name'=>'dms_voucher_against_bills','table_group_id'=>$receiptID,'status'=>$preVoucherStatus));

					}
				}else{
					if(!empty($receiptDiscount)){
						$this->voucher->update(array('table'=>'dms_vouchers','data'=>array('vamount'=>$receiptDiscount,'status'=>1),'conditions'=>array('table_name'=>'dms_voucher_against_bills','table_group_id'=>$receiptID,'cr_ledger'=>9)));
					}else{
						$this->voucher->update(array('table'=>'dms_vouchers','data'=>array('vamount'=>$receiptDiscount,'status'=>0),'conditions'=>array('table_name'=>'dms_voucher_against_bills','table_group_id'=>$receiptID,'cr_ledger'=>9)));
					}
				}
				#====================================
				$this->db->trans_complete();
				$this->message->set($this->lang->line('bill-added-to-rab'));
				redirect('payment_against_bill/edit/'.$urlString);
			}
		}

		# view starts here--------------------------------
		$this->template->slice('dms/message');
		$this->template->slice('payment_against_bill/edit_payment_against_bill_item',array('receipts'=>$receipts,'vendor_bills'=>$vendorBalanceBills,'bill_amount'=>$bill_amount,'previous_receipts'=>$previous_receipts,'received_amount'=>$received_amount,'discount'=>$discount_amount,'amount'=>$amount));
		$this->template->other_script(array('payments/payment_against_bill'));
		$this->template->render();

	}

	#-------------------------------------------------------------------------

	public function remove_item(){

		if(!$this->uri->segment(3)){
			redirect('payment_against_bill/report');
		}
		$receiptItemID = $this->uri->segment(3);
		if($this->if_exists('dms_voucher_against_bill_items',array('id'=>$receiptItemID,'status'=>1)) === false){
			redirect('payment_against_bill/report');
		}
		$uriArray = $this->uri->uri_to_assoc(4);
		$urlString = $this->uri->assoc_to_uri($uriArray);
		$this->load->model('payments/Payment_against_bill_model','payment_against_bill');
		$this->load->library('Payment_ab_lib');

		$args = array();
		$args['select'] = array('dvab.id','dvab.bill_no','dvab.bill_date');
		$args['conditions'] = array('dvabi.id'=>$receiptItemID,'dvabi.status'=>1);
		$args['join'] = array('dms_voucher_against_bill_items as dvabi'=>'dvab.id=dvabi.vid');
		$receipts = $this->payment_against_bill->get($args);
		if(!empty($receipts)){
			$receiptID = $receipts[0]['id'];

			$receipt_date = $receipts[0]['bill_date'];
			$receipt_number = $receipts[0]['bill_no'];
			$args = array();
			$args['select'] = array('dv.*','dv.status as voucher_status','dv.group_id as voucher_group');
			$args['conditions'] = array('dvab.id'=>$receiptID,'dv.table_name'=>'dms_voucher_against_bills','dv.status !='=>0);
			$args['join'] = array('dms_vouchers as dv'=>'dvab.id=dv.table_group_id');
			$voucher_details = $this->payment_against_bill->get($args);
			$preVoucherStatus=0;$voucherGroupID=$voucherDrLedger=0;
			if(!empty($voucher_details)){
				$preVoucherStatus = $voucher_details[0]['voucher_status'];
				$voucherGroupID = $voucher_details[0]['voucher_group'];
				$voucherDrLedger = $voucher_details[0]['dr_ledger'];
			}

			$this->db->trans_start();
			if($this->payment_against_bill->update_receipt_item(array('status'=>0),array('id'=>$receiptItemID))){
				#====================================

				$args = array();
				$args['select'] = array('dvab.id');
				$args['conditions'] = array('dvab.id'=>$receiptID,'dvabi.status'=>1);
				$args['num_rows'] = 1;
				$args['join'] = array('dms_voucher_against_bill_items as dvabi'=>'dvab.id=dvabi.vid');
				$receiptsItemsCount = $this->payment_against_bill->get($args);
				if(empty($receiptsItemsCount)){
					$this->payment_against_bill->update(array('status'=>0),array('id'=>$receiptID));
				}
				#---update voucher----------------------------------------------
				$receiptAmounts = $this->payment_against_bill->get_receipt_amount($receiptID);
				$receiptAmount = $receiptAmounts['amount'];
				$receiptDiscount = $receiptAmounts['discount'];
				$receiptAmount = $receiptAmount-$receiptDiscount;

				$args = array();
				$args['table'] = 'dms_vouchers';
				$args['columns'] = array('id');
				$args['conditions'] = array('table_name'=>'dms_voucher_against_bills','table_group_id'=>$receiptID,'cr_ledger'=>9);
				$dicount_voucher = $this->dms->get_data($args);

				$this->load->model('vouchers/Voucher_model','voucher');
				$updateArray = array('vamount'=>$receiptAmount);
				if(empty($receiptAmount)){
					$updateArray['status'] = 0;
				}
				$this->voucher->update(array('table'=>'dms_vouchers','data'=>$updateArray,'conditions'=>array('table_name'=>'dms_voucher_against_bills','table_group_id'=>$receiptID,'status !='=>0,'vorder_no'=>1)));

				if(!empty($dicount_voucher)){
					if(!empty($receiptDiscount)){
						$this->voucher->update(array('table'=>'dms_vouchers','data'=>array('vamount'=>$receiptDiscount,'status'=>0),'conditions'=>array('table_name'=>'dms_voucher_against_bills','table_group_id'=>$receiptID,'cr_ledger'=>9)));
					}else{
						$this->voucher->update(array('table'=>'dms_vouchers','data'=>array('vamount'=>$receiptDiscount,'status'=>0),'conditions'=>array('table_name'=>'dms_voucher_against_bills','table_group_id'=>$receiptID,'cr_ledger'=>9)));
					}
				}
				#====================================
				$this->message->set($this->lang->line('bill-added-to-rab'));
			}
			$this->db->trans_complete();
		}
		redirect('payment_against_bill/edit/'.$urlString);
	}

	#-------------------------------------------------------------------------

	public function delete(){

		if(!$this->uri->segment(3)){
			redirect('payment_against_bill/report');
		}
		$receiptID = $this->uri->segment(3);
		if($this->if_exists('dms_voucher_against_bills',array('id'=>$receiptID,'status'=>1,'bill_type'=>1)) === false){
			redirect('payment_against_bill/report');
		}
		$uriArray = $this->uri->uri_to_assoc(4);
		$urlString = $this->uri->assoc_to_uri($uriArray);
		$this->load->model('payments/Payment_against_bill_model','payment_against_bill');

		if($this->payment_against_bill->update(array('status'=>0),array('id'=>$receiptID))){
			$this->payment_against_bill->update_receipt_item(array('status'=>0),array('vid'=>$receiptID));
			#---update voucher----------------------------------------------
			$receiptAmounts = $this->payment_against_bill->get_receipt_amount($receiptID);
			$receiptAmount = $receiptAmounts['amount'];
			$this->load->model('vouchers/Voucher_model','voucher');
			$updateArray = array('vamount'=>0);
			$updateArray['status'] = 0;
			$args = array();
			$args['columns'] = array('id','group_id');
			$args['table'] = 'dms_vouchers';
			$args['conditions'] = array('table_name'=>'dms_voucher_against_bills','table_group_id'=>$receiptID);
			$voucherDtls = $this->voucher->get_vouchers($args);
			$voucherGroupId = $voucherDtls[0]['group_id'];
			$this->voucher->update(array('table'=>'dms_vouchers','data'=>$updateArray,'conditions'=>array('table_name'=>'dms_voucher_against_bills','table_group_id'=>$receiptID,'status !='=>0)));
			$this->voucher->update(array('table'=>'dms_voucher_banks','data'=>array('status'=>0),'conditions'=>array('group_id'=>$voucherGroupId)));
			#====================================
			$this->message->set($this->lang->line('bill-added-to-rab'));
		}
		redirect('payment_against_bill/report/'.$urlString);
	}

	#-------------------------------------------------------------------------

	public function pdf(){

		if(!$this->uri->segment(3)){
			echo "<script>alert('".$this->lang->line('invalid-ra-bill')."');window.close();</script>";
		}
		$receiptID = $this->uri->segment(3);
		if($this->if_exists('dms_voucher_against_bills',array('id'=>$receiptID,'status'=>1,'bill_type'=>1)) === false){
			echo "<script>alert('".$this->lang->line('invalid-ra-bill')."');window.close();</script>";
		}
		$pdf_name = 'payment_voucher';
		$this->load->library('Stock');
		$this->load->model('payments/Payment_against_bill_model','payment_against_bill');
		$this->load->library('Payment_ab_lib');
		$this->load->library('My_pdf');
		$this->load->library('To_words');

		$this->my_pdf->set_tin();
		$this->my_pdf->set_header();
		$receipts = array();
		$args = array();
		$args['select'] = array('dvab.id','dvab.bill_no','dvab.bill_date','dvab.customer_type_id','dvab.customer_id','dvab.cash_type','dvab.payment_mode','dvab.narration','dvab.cheque_no','dvab.cheque_date','dvabi.id as dvabi_id','dvabi.ps_id','dvabi.received_amount','dvabi.discount','dp.bill_no as purchase_bill_no','dp.bill_date as purchase_bill_date','dl.ledger_name');
		$args['conditions'] = array('dvab.id'=>$receiptID,'dvabi.status'=>1);
		$args['join'] = array('dms_voucher_against_bill_items as dvabi'=>'dvab.id=dvabi.vid','dms_purchases as dp'=>'dvabi.ps_id=dp.id','dms_ledgers as dl'=>'dvab.payment_mode=dl.id');
		$receipts = $this->payment_against_bill->get($args);

		if(empty($receipts)){
			echo "<script>alert('".$this->lang->line('invalid-ra-bill')."');window.close();</script>";
		}else{
			$pdf_name .= '_no_'.$receipts[0]['bill_no'];
		}
		$pdf_contents = $this->load->view('payment_against_bill/payment_against_bill_pdf',array('receipts'=>$receipts),true);
		$this->my_pdf->output($pdf_name,$pdf_contents);
	}

	#--------------------------------------------------------------------------

	public function excel(){

		$from_date = $this->uri->segment(3);
		$to_date = $this->uri->segment(4);

		$this->load->model('payments/Payment_against_bill_model','payment_against_bill');

		$args = array();
		$args['select'] = array('dvab.id','dvab.bill_no','dvab.bill_date','dvab.customer_type_id','dvab.customer_id','dvab.cash_type','dvab.payment_mode','dvab.narration','dvab.cheque_no','dvab.cheque_date','dl.ledger_name');
		$args['between'] = array($from_date,$to_date);
		$args['conditions'] = array('dvab.branch_id'=>$this->branchID,'dvab.bill_type'=>1,'dvab.status'=>1);
		$args['join'] = array('dms_ledgers as dl'=>'dvab.payment_mode=dl.id');
		$receipts = $this->payment_against_bill->get($args);

		$excel_head = 'Payment Against Bill Report '.date('d/m/Y',strtotime($from_date)).' To '. date('d/m/Y',strtotime($to_date));

		if(empty($receipts)){
			echo "<script>window.close();</script>";
		}

		$this->load->library('My_excel');
		$this->load->library('Stock');
		$this->my_excel->set_title($excel_head);
		$this->my_excel->set_headline($excel_head);
		$line=$startLine=$this->my_excel->report_head_line();
		$headings = array('#','Bill No','Bill Date','Vendor','Phone No.','Payment Mode','Bank','Cheque / DD No.','Cheque Date.','Narration','Amount','Discount','Net Amount');
		$head_width = array(NULL,NULL,12,30,15,15,20,18,14,15,25,20,20);
		$this->my_excel->set_report_head($headings,$head_width,$line);
		$i=0;
		$cashTypes = array(0=>'CASH',1=>'CHEQUE',2=>'DD');
		$totalAmount = 0;
		$line++;
		foreach($receipts as $key=>$receipt){$i++;

			$receiptID= $receipt['id'];
			$customerID = $receipt['customer_id'];
			$args = array();
			$args['return'] = 1;
			$args['conditions'] = array('id'=>$customerID);
			$vendorDetails = $this->stock->get_vendors($args);
			$vendorName = $vendorDetails['name'];
			$vendorPhone = $vendorDetails['phone'];

			$args = array();$receiptAmount=0;$receiptDiscount=0;
			$args['select'] = array('sum(received_amount) as receipt_amount','sum(discount) as discount');
			$args['conditions'] = array('dvab.id'=>$receipt['id'],'dvabi.status'=>1);
			$args['join'] = array('dms_voucher_against_bill_items as dvabi'=>'dvab.id=dvabi.vid');
			$receiptsDtls = $this->payment_against_bill->get($args);
			if(!empty($receiptsDtls)){
				$receiptAmount = $receiptsDtls[0]['receipt_amount'];
				$receiptDiscount = $receiptsDtls[0]['discount'];
			}
			$ledger_name=NULL;
			if(!empty($receipt['cash_type'])){
				$ledger_name = $receipt['ledger_name'];
			}
			$totalAmount += ($receiptAmount-$receiptDiscount);
			$cheqeNo = $receipt['cheque_no'].' ';
			$this->my_excel->set_data_align('A'.$line,NULL);
			$this->my_excel->set_cell_value('A'.$line,$i);
			$this->my_excel->set_data_align('B'.$line,'L');
			$this->my_excel->set_cell_value('B'.$line,$receipt['bill_no']);
			$this->my_excel->set_cell_value('C'.$line,dateFormat($receipt['bill_date']));
			$this->my_excel->set_data_align('C'.$line,NULL);
			$this->my_excel->set_data_align('C'.$line,'C');
			$this->my_excel->set_cell_value('D'.$line,$vendorName);
			$this->my_excel->set_data_align('E'.$line,'L');
			$this->my_excel->set_cell_value('E'.$line,$vendorPhone);
			$this->my_excel->set_cell_value('F'.$line,$cashTypes[$receipt['cash_type']]);
			$this->my_excel->set_cell_value('G'.$line,$ledger_name);
			$this->my_excel->set_cell_value('H'.$line,$cheqeNo);
			$this->my_excel->set_cell_value('I'.$line,dateFormat($receipt['cheque_date']));
			$this->my_excel->set_data_align('I'.$line,'C');
			$this->my_excel->set_cell_value('J'.$line,$receipt['narration']);
			$this->my_excel->number_format('K'.$line);
			$this->my_excel->set_cell_value('K'.$line,($receiptAmount));
			$this->my_excel->number_format('L'.$line);
			$this->my_excel->set_cell_value('L'.$line,$receiptDiscount);
			$this->my_excel->number_format('M'.$line);
			$total = $receiptAmount-$receiptDiscount;
			$this->my_excel->set_cell_value('M'.$line,$total);
			$line++;
		}
		$this->my_excel->set_bold('A'.$line.':'.'M'.$line);
		$this->my_excel->merge_cell('A'.$line.':L'.$line);
		$this->my_excel->set_data_align('A'.$line,'R');
		$this->my_excel->set_font_size('A'.$line,14);
		$this->my_excel->set_cell_value('A'.$line,'Total Amount');
		$this->my_excel->number_format('M'.$line);
		$this->my_excel->set_cell_value('M'.$line,$totalAmount);
		$this->my_excel->set_border('A'.$startLine.':M'.$line);
		$this->my_excel->output_excel();
	}

	#------------------------------------------------------------------------------------

        public function add_all(){

		$this->template->title($this->lang->line('payment-against-bill'));
		$this->template->main_heading($this->lang->line('payment-against-bill'));
		$this->template->breadcrumb(array($this->lang->line('payment-against-bill') => 'no_link',$this->lang->line('report') => 'payment_against_bill/report'));

		$this->load->library('Stock');
		$this->load->model('payments/Payment_against_bill_model','payment_against_bill');
		$this->load->library('Payment_ab_lib');
		$this->load->model('vouchers/Voucher_model','voucher');
		$vendors = $vendorBalanceBills = $bank_accounts = $existsRAB = array();
		$inputSelects = array('vendors','vendorBalanceBills','bank_accounts');
		$receiptNo = $this->payment_against_bill->get_receipt_number();
		$voucherNo = $this->voucher->get_voucher_number(1);
		$receiptNo = $voucherNo;
		$vendor_id = NULL;$vendor_bill=$bank = NULL;
		$vendors = $this->stock->get_vendors();

		$existsRAB = array();
		$args = array();
		$args['select'] = array('dvab.id','dvab.bill_no','dvab.bill_date','dvab.customer_type_id','dvab.customer_id','dvabi.id as dvabi_id','dvabi.ps_id','dvabi.received_amount','dvabi.discount','dp.bill_no as purchase_bill_no','dp.bill_date as purchase_bill_date');
		$args['conditions'] = array('dvab.branch_id'=>$this->branchID,'dvab.bill_type'=>1,'dvab.status'=>-1,'dvab.created_by'=>$this->createdBY);
		$args['join'] = array('dms_voucher_against_bill_items as dvabi'=>'dvab.id=dvabi.vid','dms_purchases as dp'=>'dvabi.ps_id=dp.id');
		$existsRAB = $this->payment_against_bill->get($args);

		if(!empty($existsRAB)){
			$vendor_id = $existsRAB[0]['customer_id'];
			$receipt_date = date('Y-m-d',strtotime($existsRAB[0]['bill_date']));
			$tempReceiptID = $existsRAB[0]['id'];
			$vendorBalanceBills = $this->payment_ab_lib->get_vendor_bill($vendor_id);
			$bank_accounts = $this->stock->payment_modes(array('sub_groups'=>array(14)));
		}

		if(isset($_POST['add_to_bill'])){
			if(empty($existsRAB)){
				$this->form_validation->set_rules('bill_date','lang:bill-date','xss_clean|required|valid_date|is_date|check_date['.date('Y-m-d').'.<=]');
				$this->form_validation->set_rules('vendor_id','lang:vendor','xss_clean|required');
			}
			if($this->input->post('vendor_id')){
				$vendor_id = $this->input->post('vendor_id');
				$vendorBalanceBills = $this->payment_ab_lib->get_vendor_bill($vendor_id);
			}
			$this->form_validation->set_rules('bill_no','lang:bill-no','xss_clean|required|is_natural|greater_than[0]');
			//$this->form_validation->set_rules('vendor_bill','lang:purchase-bill','xss_clean|required');
			$this->form_validation->set_rules('received_amount','lang:current-payment','xss_clean|required|greater_than[0]');
			$this->form_validation->set_rules('discount_amount','lang:discount','xss_clean|numeric');
			$this->form_validation->set_rules('amount','lang:amount','xss_clean');
			$this->form_validation->set_rules('cbill_date','lang:bill-date','xss_clean');
			$this->form_validation->set_rules('cbill_amt','lang:bill-amount','xss_clean');
			$this->form_validation->set_rules('cpr_amt','lang:previous-payments','xss_clean');

			if($this->form_validation->run('add_to_bill') === true){

				$tempReceiptID = NULL;
				$postedItems = $this->input->post();
				$bill_num = $postedItems['bill_no'];
				if(empty($existsRAB)){
					$receipt_date = date('Y-m-d',strtotime($postedItems['bill_date']));
				}
				$purchase_bill = $this->payment_ab_lib->get_purchase_bill($postedItems['vendor_bill']);
				$bill_date = date('Y-m-d',strtotime($purchase_bill['bill_date']));
				$bill_amount = round_this($purchase_bill['bill_amount']);
				$total_paid_amount = $this->payment_ab_lib->get_bill_payment($postedItems['vendor_bill']);
				$balance_bill_amount = ($bill_amount-$total_paid_amount);

				$args = array();
				$args['columns'] = array('id');
				$args['table'] = 'dms_vouchers';
				$args['conditions'] = array('vno'=>$bill_num,'vtype_id'=>1,'status !='=>0);
				$vouchers = $this->voucher->get_vouchers($args);

				$args = array();
				$args['columns'] = array('id');
				$args['table'] = 'dms_voucher_temps';
				$args['conditions'] = array('vno'=>$bill_num,'vtype_id'=>1);
				$vouchersTemps = $this->voucher->get_vouchers($args);

				if(empty($vouchers) && empty($vouchersTemps))
				{
					$vendorBalanceBillss = $this->payment_ab_lib->get_all_vendor_bill($postedItems['vendor_id']);
					if(!empty($vendorBalanceBillss))
					{	
						$tot_bill_amt = $postedItems['cbill_amt'];
						$tot_paid = $postedItems['cpr_amt'];
						$tot_bal = $tot_bill_amt-$tot_paid;
						$recieved_amt = $postedItems['received_amount'] ;
						if($recieved_amt <= $tot_bal)
						{									
							$this->db->trans_start();
							if(empty($existsRAB))
							{
								#---save temp data
								if($this->payment_against_bill->save_bill(array('branch_id'=>$this->branchID,'bill_no'=>$bill_num,'bill_date'=>$receipt_date,'customer_id'=>$postedItems['vendor_id'],'bill_type'=>1,'status'=>-1,'created_by'=>$this->createdBY)))
								{
									$tempReceiptID = $this->db->insert_id();
								}
							}
						/*	else
							{
								$tempReceiptID = $existsRAB[0]['id'];
								$this->payment_against_bill->update(array('bill_no'=>$bill_num),array('id'=>$tempReceiptID));
							}	*/
							
							foreach($vendorBalanceBillss as $key => $value)
							{																		
								$purchase_bill = $key;
								$bill_date = date('Y-m-d',strtotime($value['bill_date']));
								$bill_amount = round_this($value['bill_amount']);
								$total_paid_amount = $this->payment_ab_lib->get_bill_payment($key);
								$balance_bill_amount = ($bill_amount-$total_paid_amount);
								
								if(strtotime($receipt_date) >= strtotime($bill_date))
								{
									if($recieved_amt > 0)
									{									
										if($recieved_amt <= $balance_bill_amount)
										{								
											if(!empty($tempReceiptID))
											{
												#dms_voucher_against_bill_items
												$args = array();
												$args['select'] = array('dvab.id');
												$args['conditions'] = array('dvab.id'=>$tempReceiptID,'dvabi.ps_id'=>$purchase_bill,'dvabi.status'=>1);
												$args['join'] = array('dms_voucher_against_bill_items as dvabi'=>'dvab.id=dvabi.vid');
												$checkRcptBill = $this->payment_against_bill->get($args);
												if(empty($checkRcptBill))
												{
													if($this->payment_against_bill->save_bill_items(array('vid'=>$tempReceiptID,'ps_id'=>$purchase_bill,'received_amount'=>$recieved_amt,'discount'=>0,'status'=>1)))
													{
														$this->db->trans_complete();
														$this->message->set($this->lang->line('bill-added-to-pab'));	
														$recieved_amt=0;													
													}
												}
												else
												{
													$this->message->set($this->lang->line('same-bill-exists'),'e');
												}
											}
										}
										else
										{
											if(!empty($tempReceiptID))
											{
												#dms_voucher_against_bill_items
												$args = array();
												$args['select'] = array('dvab.id');
												$args['conditions'] = array('dvab.id'=>$tempReceiptID,'dvabi.ps_id'=>$purchase_bill,'dvabi.status'=>1);
												$args['join'] = array('dms_voucher_against_bill_items as dvabi'=>'dvab.id=dvabi.vid');
												$checkRcptBill = $this->payment_against_bill->get($args);
												if(empty($checkRcptBill))
												{
													if($this->payment_against_bill->save_bill_items(array('vid'=>$tempReceiptID,'ps_id'=>$purchase_bill,'received_amount'=>$balance_bill_amount,'discount'=>0,'status'=>1)))
													{
														$this->db->trans_complete();
														$this->message->set($this->lang->line('bill-added-to-pab'));	
														$recieved_amt -= $balance_bill_amount;													
													}
												}
												else
												{
													$this->message->set($this->lang->line('same-bill-exists'),'e');
												}
											}
										}
									}						
								}
								else
								{
									$this->message->set($this->lang->line('enter-valid-payment-date'),'e');
								}
							}
							redirect('payment_against_bill/add_all');
						}		
						else
						{
							$this->message->set($this->lang->line('greater-balance-amount'),'e');
						}
					}
				}
				else
				{
					$this->message->set($this->lang->line('enter-valid-pvoucher-number'),'e');
				}
			}
		}
		#-----------------

		if(isset($_POST['save'])){

			$this->form_validation->set_rules('receipt_mode','lang:payment-mode','xss_clean|required');
			$this->form_validation->set_rules('bill_no','lang:bill-no','xss_clean|required|is_natural|greater_than[0]');
			$chequeNoRule = $chequeDateRule = $colBankRule = 'xss_clean';
			if($this->input->post('receipt_mode') && $this->input->post('receipt_mode') != 0){
				$chequeNoRule .= '|required';
				$chequeDateRule .= '|required|is_date';
				$colBankRule .= '|required';
				$this->form_validation->set_rules('ccd','lang:transaction-type','xss_clean|required');
			}
			$this->form_validation->set_rules('cheque_no','lang:cd-no',$chequeNoRule);
			$this->form_validation->set_rules('cheque_date','lang:cheque-date',$chequeDateRule);
			$this->form_validation->set_rules('payment_mode','lang:collection-bank',$colBankRule);
			$this->form_validation->set_rules('narration','lang:narration','xss_clean');
			if($this->form_validation->run('save') === true){

				$chequeDd = $this->input->post('receipt_mode');
				$bill_num = $this->input->post('bill_no');
				$args = array();
				$args['columns'] = array('id');
				$args['table'] = 'dms_vouchers';
				$args['conditions'] = array('vno'=>$bill_num,'vtype_id'=>1,'status !='=>0);
				$vouchers = $this->voucher->get_vouchers($args);

				$args = array();
				$args['columns'] = array('id');
				$args['table'] = 'dms_voucher_temps';
				$args['conditions'] = array('vno'=>$bill_num,'vtype_id'=>1);
				$vouchersTemps = $this->voucher->get_vouchers($args);

				if(empty($vouchers) && empty($vouchersTemps)){

					if($this->input->post('receipt_mode') != 0){
						$ccd = $this->input->post('ccd',true);
						$payment_mode = $this->input->post('payment_mode');
						$cheque_no = $this->input->post('cheque_no');
						$chequeDate = date('Y-m-d',strtotime($this->input->post('cheque_date')));

					}else{
						$ccd = 0;
						$payment_mode = 0;
						$cheque_no = NULL;
						$chequeDate = '0000-00-00';

					}
					$narration = $this->input->post('narration');

					$args = array();
					$args['fields'] = array('ledger_id');
					$args['return'] = 1;
					$args['conditions'] = array('id'=>$vendor_id);
					$vendorDetails = $this->stock->get_vendors($args);
					$cust_ledgerID = $vendorDetails['ledger_id'];

					$drLedgerID = 1;# ledger id of CASH
					if($chequeDd > 0){
						$drLedgerID = $payment_mode;# ledger id of bank accounts
					}

					if(!empty($cust_ledgerID)){
						$this->db->trans_start();
						$updateArray = array('bill_no'=>$bill_num,'cash_type'=>$ccd,'payment_mode'=>$drLedgerID,'narration'=>$narration,'cheque_no'=>$cheque_no,'cheque_date'=>$chequeDate,'status'=>1);

						if($this->payment_against_bill->update($updateArray,array('id'=>$tempReceiptID))){

							#-------voucher starts here---------------------------------------------------------------------
							$receiptAmounts = $this->payment_against_bill->get_receipt_amount($tempReceiptID);
							$receiptAmount = $receiptAmounts['amount'];
							$receiptDiscount = $receiptAmounts['discount'];
							$receiptAmount = $receiptAmount-$receiptDiscount;
							#$newVchrNo = $this->voucher->get_voucher_number(1);
							$groupID = $this->stock->get_group_id('dms_vouchers');
							$voucherStatus = 1;

							if(strtotime($chequeDate) > strtotime($receipt_date) && $chequeDd >0){

								$voucherStatus = 3;
							}
							if($chequeDd > 0){
								if($this->voucher->insert('dms_voucher_banks',array('group_id'=>$groupID,'cash_type'=>$ccd,'cd_no'=>$cheque_no,'pdc'=>$chequeDate,'vdate'=>$receipt_date,'cq_status'=>0))){
								}
							}

							$this->voucher->insert("dms_vouchers",array('group_id'=>$groupID,'vtype_id'=>1,'vno'=>$bill_num,'vorder_no'=>1,'vdate'=>$receipt_date,'cr_ledger'=>$drLedgerID,'dr_ledger'=>$cust_ledgerID,'vamount'=>$receiptAmount,'table_name'=>'dms_voucher_against_bills','table_group_id'=>$tempReceiptID,'status'=>$voucherStatus));

							if(!empty($receiptDiscount) and $receiptDiscount>0){

								$this->voucher->insert("dms_vouchers",array('group_id'=>$groupID,'vtype_id'=>1,'vno'=>$bill_num,'vorder_no'=>2,'vdate'=>$receipt_date,'dr_ledger'=>$cust_ledgerID,'cr_ledger'=>9,'vamount'=>$receiptDiscount,'table_name'=>'dms_voucher_against_bills','table_group_id'=>$tempReceiptID,'status'=>$voucherStatus));
							}
							#=====================================================
							$this->db->trans_complete();
							$this->message->set($this->lang->line('pab-saved'));
							redirect('payment_against_bill/add_all');
						}
					}else{
						$this->message->set($this->lang->line('pab-saved'),'e');
						redirect('payment_against_bill/add_all');
					}
				}else{
					$this->message->set($this->lang->line('enter-valid-pvoucher-number'),'e');
				}
			}
		}
		#----------------------

		foreach($inputSelects as $key=>$selectBox){
			$arrayName = $$selectBox;
			$arrayName[''] = 'Select';
			$$selectBox = $arrayName;
			ksort($$selectBox);
		}

		# view starts here--------------------------------
		$this->template->slice('dms/message');
		$this->template->slice('payment_against_bill/add_all_payment_against_bill',array('bill_num'=>$receiptNo,'vendors'=>$vendors,'vendor_id'=>$vendor_id,'vendor_bills'=>$vendorBalanceBills,'vendor_bill'=>$vendor_bill,'payment_bill_items'=>$existsRAB,'bank_accounts'=>$bank_accounts,'bank'=>$bank));
		$this->template->other_script(array('payments/payment_against_bill1'));
		$this->template->render();
	}
     
       public function report_all()
       {	                
                $this->companyID = $this->session->userdata('company_id');		
		$this->load->model('purchase/Purchase_model','purchase_obj');
		$this->load->model('vouchers/Voucher_model','vouchers');
		$this->load->library(array('Stock','My_excel'));
                $this->load->model('payments/Payment_against_bill_model','payment_against_bill');
		$this->load->library('Payment_ab_lib');
		#----------voucher type
		$this->vtype = 5;

		$vtype_id = $this->vtype;
		$conditions = array('vtype_id' => $vtype_id,'status' => 1,'payment_mode'=>2);
		$like_array = array();$vnos="";

		#----------voucher name
		$voucher_name = $this->vouchers->voucher_name($this->vtype);

		#----------voucher type array
		$voucher_types = $this->vouchers->voucher_types($this->vtype);

		#----------item array
		$args['select'] = array('id','item_code','item_name');
		$items = $this->stock->get_stock_items($args);
		$items[''] = "Select";
		ksort($items);
		$item_id = "";
                $vendors = $this->stock->get_vendors();
                $vendors[''] = "Select";
		ksort($vendors);
                $vendor_id = "";

		#----------uri array
		$uri_array  = $this->uri->uri_to_assoc(3);

		#----------redirect
		$redirect = "";

		#----------pagination
		$this->load->library('Pagination');
		$config['per_page'] = $this->per_page();
		$config['base_url'] = base_url('payment_against_bill/report_all');
		$config['uri_segment'] = 3;

		#----------dates within financial year
		$cur_date = date('Y-m-d');
		$from_date = $cur_date;
		$to_date = $cur_date;
		$cur_fiscal_yr = $this->dms->get_fiscal_year();
		if($from_date < $cur_fiscal_yr['start_date'] || $from_date > $cur_fiscal_yr['end_date'] || $to_date < $cur_fiscal_yr['start_date'] || $to_date > $cur_fiscal_yr['end_date'])
		{
			$from_date = $cur_fiscal_yr['end_date'];
			$to_date = $cur_fiscal_yr['end_date'];
		}

		#----------validation
		$this->form_validation->set_rules('vtype_id','voucher-types','required|xss_clean');
		$this->form_validation->set_rules('from_date','From Date','required|xss_clean|valid_date');
		$this->form_validation->set_rules('to_date','To Date','required|xss_clean|valid_date');
		$this->form_validation->set_rules('bill_no','bill-no','xss_clean|trim');
		$this->form_validation->set_rules('item_id','item','xss_clean|trim');
		if($this->form_validation->run() === true)
		{
			$vtype_id = $this->input->post('vtype_id',true);
			$from_date = date('Y-m-d',strtotime($this->input->post('from_date',true)));
			$to_date = date('Y-m-d',strtotime($this->input->post('to_date',true)));
			$conditions['vtype_id'] = $vtype_id;
			$config['base_url'] .= '/vt/'.$vtype_id.'/fdate/'.$from_date.'/tdate/'.$to_date;
			$config['uri_segment'] += 6;
			$redirect .= '/vt/'.$vtype_id.'/fdate/'.$from_date.'/tdate/'.$to_date;
			if(!empty($this->input->post('bill_no',true)))
			{
				$vnos = $this->input->post('bill_no',true);
				$like_array['bill_no'] = $vnos;
				$config['base_url'] .= '/vn/'.$vnos;
				$config['uri_segment'] += 2;
				$redirect .= '/vn/'.$vnos;
			}
			if(!empty($this->input->post('item_id',true)))
			{
				$item_id = $this->input->post('item_id',true);                             
				$config['base_url'] .= '/item/'.$item_id;
				$config['uri_segment'] += 2;
				$redirect .= '/item/'.$item_id;
			}
                        if(!empty($this->input->post('vendor_id',true)))
			{
				$vendor_id = $this->input->post('vendor_id',true);                             
				$config['base_url'] .= '/vendor/'.$vendor_id;
				$config['uri_segment'] += 2;
				$redirect .= '/vendor/'.$vendor_id;
                                $conditions['vendor_id'] = $vendor_id;
			}
		}
		elseif(isset($uri_array['vt']))
		{
			$vtype_id = $uri_array['vt'];
			$conditions['vtype_id'] = $vtype_id;
			$config['base_url'] .= '/vt/'.$conditions['vtype_id'];
			$config['uri_segment'] += 2;
			$redirect .= '/vt/'.$vtype_id;
			if(isset($uri_array['fdate']) && isset($uri_array['tdate']))
			{
				$from_date = date('Y-m-d',strtotime($uri_array['fdate']));
				$to_date = date('Y-m-d',strtotime($uri_array['tdate']));
				$config['base_url'] .= '/fdate/'.$from_date.'/tdate/'.$to_date;
				$config['uri_segment'] += 4;
				$redirect .= '/fdate/'.$from_date.'/tdate/'.$to_date;
			}
			if(isset($uri_array['vn']))
			{
				$vnos = $uri_array['vn'];
				$like_array['bill_no'] = $vnos;
				$config['base_url'] .= '/vn/'.$vnos;
				$config['uri_segment'] += 2;
				$redirect .= '/vn/'.$vnos;
			}
			if(isset($uri_array['item']))
			{
				$item_id = $uri_array['item'];
				$config['base_url'] .= '/item/'.$item_id;
				$config['uri_segment'] += 2;
				$redirect .= '/item/'.$item_id;
			}
                        if(isset($uri_array['vendor']))
			{
				$vendor_id = $uri_array['vendor'];
				$config['base_url'] .= '/vendor/'.$vendor_id;
				$config['uri_segment'] += 2;
				$redirect .= '/vendor/'.$vendor_id;
			}
		}

		#----------between condition
		$between = "bill_date between '$from_date' and '$to_date'";
                
		#----------total rows

		$config['total_rows'] = $this->purchase_obj->get_bills(array('columns' => array('id'),'conditions' => $conditions,'between' => $between,'like' => $like_array,'numrows'=>true,'item_condition' => $item_id));

		if($config['total_rows'] == 0){
			$this->message->set($this->lang->line('no-voucher'),'i');
		}

		#----------pagination
		$offset = $this->uri->segment($config['uri_segment'],0);
		# Pagination Config Customizations
        $config['full_tag_open'] = '<ul class="pagination">';
        $config['full_tag_close'] = '</ul>';
        $config['first_link'] = 'First';
        $config['last_link'] = 'Last';
        $config['next_link'] = '&raquo;';
        $config['prev_link'] = '&laquo;';
        $config['cur_tag_open'] = '<li class="active"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
		$this->pagination->initialize($config);
		$links = $this->pagination->create_links();
		$redirect .= '/'.$offset;

		#------------presumptive tax checking
		$presumptive_tax = $this->stock->get_tax_type();

		#----------purchase report datas
		$purchase_array=$this->purchase_obj->get_bills(array('conditions' => $conditions,'between' => $between,'like' => $like_array,'order_by'=>'bill_date','order'=>'DESC','limit'=>$config['per_page'],'offset'=>$offset,'item_condition' => $item_id));

		#----------template
		$this->template->title("Vendor Report");
		$this->template->main_heading($this->lang->line("$voucher_name")." ".$this->lang->line("report"));
		
		$this->template->slice('payment_against_bill/search',array('voucher_types' => $voucher_types,'vtype_id' => $vtype_id,'vnos' => $vnos,'from_date' => $from_date,'to_date' => $to_date,'rtype' => 'payment_against_bill','items' => $items,'item' => $item_id,'vendors'=>$vendors,'vendor_id'=>$vendor_id));
		$this->template->slice('dms/message');
		if(!empty($purchase_array))
		{
			$this->template->slice('payment_against_bill/report',array('purchase_array' => $purchase_array,'presumptive_tax' => $presumptive_tax,'offset' => $offset,'links' => $links,'redirect' => $redirect));
			$this->template->slice('dms/modals/delete_confirm');
		}
		$this->template->other_script('purchase/purchase');
		$this->template->render();
	}

}
?>