<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

class Preturn_to_sreturn extends MY_Controller{

	var $companyID,$branchID,$createdBY,$fiscal_start_date,$fiscal_end_date;
	public function __construct()
	{
		parent::__construct();

		$this->check_access_right();

		#---------------- Checking Financial year is enabled / closed-----------------#
		$method_array = array('requests');
		fiscal_status($this->uri->segment(2),$method_array,"preturn_to_sreturn/requests");
		#---------------- Checking Financial year is enabled / closed-----------------#
		$this->load->library(array('Stock'));

		$this->companyID = $this->session->userdata('company_id');
		$this->branchID = $this->session->userdata('under_id');
		$this->createdBY = $this->session->userdata('id');
		$fiscals = $this->dms->get_fiscal_year();
		$this->fiscal_start_date = $fiscals['start_date'];
		$this->fiscal_end_date = $fiscals['end_date'];

		#----------voucher type
		$this->vtype = 8;
	}

	#-------------------------------------------------------

	public function requests(){

		$this->template->title($this->lang->line('sales-return-requests'));
		$this->template->main_heading($this->lang->line('sales-return-requests'));
		$this->template->breadcrumb(array($this->lang->line('sales-return-requests') => 'no_link'));

		$this->load->model('purchase/Purchase_return_model','purchase_return');
		$this->load->model('vouchers/Voucher_model','vouchers');
		$this->load->library('Stock');
		$this->load->library('Pagination');
		$offset=0;$links = NULL;

		$presumptive_tax = $this->stock->get_tax_type();

		$links = $from_date = $to_date = NULL;$offset=0;
		$config['per_page'] = $this->per_page();
		$config['uri_segment'] = 3;
		$offset = ($this->uri->segment(3))?$this->uri->segment(3):0;
		$config['base_url'] = base_url('preturn_to_sreturn/requests');

		$args = array();
		$args['select'] = array('id');
		$args['conditions'] = array('vendor_id'=>$this->branchID,'branch_id !='=>$this->branchID,'p_status'=>0,'status'=>1);
		$args['numrows'] = 1;
		$config['total_rows'] = $this->purchase_return->get_bills($args);
		# Pagination Config Customizations
        $config['full_tag_open'] = '<ul class="pagination">';
        $config['full_tag_close'] = '</ul>';
        $config['first_link'] = 'First';
        $config['last_link'] = 'Last';
        $config['next_link'] = '&raquo;';
        $config['prev_link'] = '&laquo;';
        $config['cur_tag_open'] = '<li class="active"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
		$this->pagination->initialize($config);
		$links = $this->pagination->create_links();

		$args = array();
		$args['columns'] = array('id','vtype_id','bill_no','bill_date','branch_id','return_bill_no','group_id','vendor_id','bill_freight','other_expense','cess','payment_mode','p_status','bill_status');
		$args['conditions'] = array('vendor_id'=>$this->branchID,'branch_id !='=>$this->branchID,'p_status'=>0,'status'=>1);
		$args['limit'] = $config['per_page'];
		$args['offset'] = $offset;
		$purchase_returns = $this->purchase_return->get_bills($args);

		$sales_return_requests = array();
		foreach($purchase_returns as $key=>$preturn){
			$total_amount = 0;$total_tax_amount = 0;$presum_amount = 0;

			if($preturn['bill_status'] == 0){
				$this->purchase_return->update_others(array('table'=>'dms_purchase_returns','data'=>array('bill_status'=>1),'conditions'=>array('id'=>$preturn['id'])));
			}

			$args = array();
			$requested_branch_id = $preturn['branch_id'];
			$requested_by = $this->stock->get_customer(1,$requested_branch_id);
			$args['columns'] = array('item_id','qty','rate','amount','vat_amt','cst');
			$args['conditions'] = array('group_id' => $preturn['group_id'],'status' => 1);
			$preturn_items = $this->purchase_return->get_purchase_items($args);
			foreach($preturn_items as $priKey => $pitem){
				$tax_amount = 0;
				$net_value = $pitem['amount'];

				if(empty($presumptive_tax)){
					if($pitem['cst'] == 0){
						$vat = $this->stock->get_item_vat($pitem['item_id']);
						$tax_amount = $pitem['vat_amt'];//($vat*$net_value)/100;
					}else{
						$tax_amount = ($pitem['cst']*$net_value)/100;
					}
				}
				$total_tax_amount += $tax_amount;
				$total_amount += $net_value;
			}
			$total_amount += $total_tax_amount;
			if(!empty($presumptive_tax)){
				$presum_amount = ($presumptive_tax[0]*$total_amount)/100;
				$total_amount += $presum_amount;
			}
			$cess_amount = (($total_tax_amount+$presum_amount)*$preturn['cess'])/100;
			$total_amount += ($cess_amount+$preturn['bill_freight']+$preturn['other_expense']);
			$paymentMode = $this->stock->ledger_name($preturn['payment_mode']);
			$sales_return_requests[$preturn['id']] = array('id'=>$preturn['id'],'vtype_id'=>$preturn['vtype_id'],'bill_no'=>$preturn['bill_no'],'bill_date'=>$preturn['bill_date'],'payment_mode'=>$paymentMode,'bill_status'=>$preturn['p_status'],'amount'=>$total_amount,'requested_by'=>$requested_by);
		}

		if(empty($sales_return_requests)){
			$this->message->set($this->lang->line('no-sales-return-found'),'e');
		}

		$this->template->slice('dms/message');
		$this->template->slice('sales/sales_return/pending_requests',array('sales_returns_requests'=>$sales_return_requests,'count'=>$offset+1,'links'=>$links));
		$this->template->other_script('sales/sales');
		$this->template->slice('dms/modals/more_details');
		$this->template->render();

	}

	#-------------------------------------------------------

	public function sales_return(){

		if($this->uri->segment(3)){
			$purchaseRtnID = $this->uri->segment(3);
			if($this->if_exists('dms_purchase_returns',array('id'=>$purchaseRtnID,'vendor_id'=>$this->branchID,'branch_id !='=>$this->branchID)) === false){
				$this->message->set($this->lang->line('invalid-sr-request'),'e');
				redirect('preturn_to_sreturn/requests');
			}
		}
		$cd_status = 1;$ccd = $cd_no = $pdc = "";
		$this->template->title($this->lang->line('sales-return'));
		$this->template->main_heading($this->lang->line('sales-return'));
		$this->template->breadcrumb(array($this->lang->line('sales-return') => 'no_link'));

		$this->load->model('purchase/Purchase_return_model','purchase_return');
		$this->load->model('sales/Sales_return_model','sales_return');
		$this->load->model('vouchers/Voucher_model','vouchers');
		$this->load->model('areas/Area_model','area');
		$this->load->model('designations/Designation_master_model','desig');
		$this->load->model('customers/Customer_master_model','customer_master');
		$this->load->library('Stock');

		$voucher_types = $this->vouchers->voucher_types($this->vtype);
		$bill_prefix = $this->stock->get_voucher_prefix($this->vtype);
		$return_bills = $this->sales_return->get_sales_bills();
		$customerTypes = $this->desig->listing(array('department_id'=>0,'utype_status >'=>1));
		$sales_cst = $this->stock->get_constant(array('sales_cst'));
		$cess = $this->stock->get_cess();
		$customers = $this->stock->get_customers(1);
		$godowns = $this->stock->get_godowns(array('conditions'=>array('branch_id'=>$this->branchID),'listing'=>1));
		$payment_mode = $this->stock->payment_modes();
		$presumptive_tax = $this->stock->get_tax_type();
		$areas = $this->area->listing();
		$args = array();
		$args['columns'] = array('id','s_status');
		$args['conditions'] = array('created_by'=>$this->createdBY,'status'=>-1,'branch_id'=>$this->branchID);
		$sales_return_temp = $this->sales_return->get_bills($args);

		if(!empty($sales_return_temp)){
			if($sales_return_temp[0]['s_status'] == 0){
				$this->message->set($this->lang->line('pending-sales-return-exists'),'e');
				redirect('sales_return/add');
			}
		}else{
			if(!$this->uri->segment(3)){
				redirect('users/logout');
			}
		}

		if(empty($sales_return_temp)){

			$this->db->trans_start();
			$result_array = $this->sales_return->next_bill_no($this->vtype);
			$vtype_id = $result_array['vtype_id'];
			$voucher_no = $result_array['bill_no'];
			$voucher_date = $result_array['bill_date'];

			$args = array();
			$args['columns'] = array('a.id','a.vtype_id','a.branch_id','a.group_id','a.bill_no','a.bill_date','a.return_bill_no','a.vendor_id','a.bill_freight','a.other_expense','a.cess','a.payment_mode','a.p_status','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.vat_percent','b.vat_amt','b.cst','b.godown_id');
			$args['conditions'] = array('a.id'=>$purchaseRtnID,'a.vendor_id'=>$this->branchID,'a.branch_id !='=>$this->branchID,'a.branch_id'=>'','a.p_status'=>0);
			$purchase_returns = $this->purchase_return->get_purchases($args);

			if(empty($purchase_returns)){
				$this->message->set($this->lang->line('invalid-sr-request'),'e');
				redirect('preturn_to_sreturn/requests');
			}else{

				$group_id = $this->stock->get_group_id('dms_sales_return_items');
				$purchaseID = $purchase_returns[0]['return_bill_no'];
				$customerID = $purchase_returns[0]['branch_id'];
				$cust_id = $customerID;
				$preturnBillFreight = $purchase_returns[0]['bill_freight'];
				$preturnBillOthExp = $purchase_returns[0]['other_expense'];
				$preturnBillCess = $purchase_returns[0]['cess'];
				$preturnPayMode = $purchase_returns[0]['payment_mode'];
				$preturnStatus = $purchase_returns[0]['p_status'];
				$preturnGroupID = $purchase_returns[0]['group_id'];
				$preturnBillDate = $purchase_returns[0]['bill_date'];
				$salesID = 0;

				if(!empty($purchaseID)){
					$this->db->select(array('pid','p_status'));
					$this->db->from('dms_purchases');
					$this->db->where(array('id'=>$purchaseID));
					$purchases = $this->db->get()->row_array();
					if(!empty($purchases) && $purchases['p_status'] == 4){
						$salesID = $purchases['pid'];
					}
				}

				if($preturnStatus == 0){

					$return_voucher_banks = array();$return_vouchers = array();
					$voucher_group_id = $this->stock->get_group_id('dms_vouchers');
					$args = array();
					$args['columns'] = array('id','company_id','branch_id','group_id','vtype_id','vno','vorder_no','vorder_no','vdate','dr_ledger','cr_ledger','vamount','narration','table_name','table_group_id','status');
					$args['table'] = 'dms_vouchers';
					$args['conditions'] = array('table_name'=>'dms_purchase_returns','table_group_id'=>$preturnGroupID);
					$return_vouchers = $this->dms->get_data($args);

					$preturnDR = $return_vouchers[0]['dr_ledger'];
					$preturnVamount = $return_vouchers[0]['vamount'];
					$preturnVoucherGpID = $return_vouchers[0]['group_id'];
					$voucher_status =1;

					if($preturnPayMode >2){

						$args = array();
						$args['columns'] = array('id','group_id','cash_type','cd_no','pdc','vdate','cq_status','status');
						$args['table'] = 'dms_voucher_banks';
						$args['conditions'] = array('group_id'=>$preturnVoucherGpID);
						$return_voucher_banks = $this->dms->get_data($args);

						if(!empty($return_voucher_banks)){
							$preturn_cash_type = $return_voucher_banks[0]['cash_type'];
							$cheque_num = $return_voucher_banks[0]['cd_no'];
							$preturnPDC = $return_voucher_banks[0]['pdc'];
							if($preturn_cash_type == 1){
								$voucher_status = 3;
							}
						}
					}else if($preturnPayMode == 2){
						$customerDetails = $this->dms->get_data(array('table' =>'branch_master','columns' => 'ledger_id','conditions' => array('id' => $customerID)));
						$preturnPayMode = $customerDetails[0]['ledger_id'];//customer
					}

					$voucher_array = array('company_id' => $this->companyID,'branch_id' => $this->branchID,'group_id' => $voucher_group_id,'vtype_id' =>8,'vno' =>$voucher_no,'vorder_no' => 1,'vdate' =>$preturnBillDate,'dr_ledger' => 6,'cr_ledger' => $preturnPayMode,'vamount' =>$preturnVamount,'table_name' => 'dms_sales_returns','table_group_id' => $group_id,'status' => $voucher_status);

					$purchase_voucher = $this->dms->get_data(array('table' => 'dms_vouchers','columns' => 'group_id','conditions' => array('table_name' => 'dms_sales_returns','table_group_id' => $group_id)));

					if(empty($purchase_voucher)){
						$vorder_no=0;
						foreach($return_vouchers as $vKey=>$return_voucher){
							$vorder_no++;
							$voucher_array['vorder_no'] = $vorder_no;
							$voucher_array['vamount'] = $return_voucher['vamount'];

							if($return_voucher['cr_ledger'] ==5){
								$voucher_array['dr_ledger'] = 6;
							}else if($return_voucher['cr_ledger'] == 11){
								$voucher_array['dr_ledger'] = 12;
							}else if($return_voucher['cr_ledger'] == 15){
								$voucher_array['dr_ledger'] = 15;
							}else if($return_voucher['cr_ledger'] == 13){
								$voucher_array['dr_ledger'] = 13;
							}else if($return_voucher['cr_ledger'] == 14){
								$voucher_array['dr_ledger'] = 14;
							}
							$this->purchase_return->insert('dms_vouchers',$voucher_array);
						}
						if($preturnPayMode > 2 && !empty($return_voucher_banks)){
							$this->purchase_return->insert('dms_voucher_banks',array('group_id' => $voucher_group_id,'cash_type' => $preturn_cash_type,'cd_no' => $cheque_num,'pdc' => $preturnPDC,'vdate' => $preturnBillDate));
						}
					}

					$saveSalesRtn = array('vtype_id'=>8,'branch_id'=>$this->branchID,'group_id'=>$group_id,'bill_no'=>$voucher_no,'bill_date'=>$preturnBillDate,'return_bill_no'=>$salesID,'customer_type_id'=>1,'customer_id'=>$customerID,'bill_freight'=>$preturnBillFreight,'other_expense'=>$preturnBillOthExp,'cess'=>$preturnBillCess,'payment_mode'=>$preturnPayMode,'sid'=>$purchaseRtnID,'s_status'=>1,'status'=>-1);

					if($this->sales_return->insert("dms_sales_returns",$saveSalesRtn)){
						foreach($purchase_returns as $key=>$preturn){
							$saveSalesRtnItems = array('group_id'=>$group_id,'item_id'=>$preturn['item_id'],'godown_id'=>0,'qty'=>$preturn['qty'],'unit_id'=>$preturn['unit_id'],'rate'=>$preturn['rate'],'amount'=>$preturn['amount'],'vat_percent'=>$preturn['vat_percent'],'vat_amt'=>$preturn['vat_amt'],'cst'=>$preturn['cst'],'status'=>-1);
							$this->sales_return->insert("dms_sales_return_items",$saveSalesRtnItems);
						}
					}
				}
			}
			$this->db->trans_complete();
		}
		$args = array();
		$args['columns'] = array('a.id','a.vtype_id','a.branch_id','a.group_id','a.bill_no','a.bill_date','a.return_bill_no','a.customer_type_id','a.customer_id','a.area_id','a.bill_freight','a.other_expense','a.cess','a.payment_mode','a.narration','a.sid','a.s_status','b.id as sr_id','b.item_id','b.godown_id','b.qty','b.unit_id','b.rate','b.amount','b.vat_amt','b.cst');
		$args['conditions'] = array('a.created_by'=>$this->createdBY,'a.status'=>-1,'a.branch_id'=>$this->branchID);
		$sales_return_temp = $this->sales_return->get_sales($args);

			if(!empty($sales_return_temp)){
				$sales_return_id = $sales_return_temp[0]['id'];
				$vtype_id = $sales_return_temp[0]['vtype_id'];
				$voucher_no = $sales_return_temp[0]['bill_no'];
				$voucher_date = $sales_return_temp[0]['bill_date'];
				$group_id = $sales_return_temp[0]['group_id'];
				$salesID = $sales_return_temp[0]['return_bill_no'];
				$cust_id = $sales_return_temp[0]['customer_id'];
				$preturnID = $sales_return_temp[0]['sid'];
				$sales_return_pay_mode = $sales_return_temp[0]['payment_mode'];
				$sales_cst = $this->sales_return->get_cst($sales_return_temp[0]['group_id']);

			$cd_status = 1;$ccd = $cd_no = $pdc = "";
			$cheque_dd_array = $this->vouchers->cheque_data(array('columns' => array('b.cash_type','b.cd_no','b.pdc'),'conditions' => array('a.table_name' =>'dms_sales_returns','a.table_group_id' =>$group_id)));
				if(!empty($cheque_dd_array)){
					$cd_status = 0;
					$ccd = $cheque_dd_array[0]['cash_type'];
					$cd_no = $cheque_dd_array[0]['cd_no'];
					$pdc = $cheque_dd_array[0]['pdc'];
				}
			}

			$this->form_validation->set_rules('bill_no','lang:bill-no',"required|xss_clean|is_natural_no_zero|callback_bill_no_exists[$vtype_id.$group_id]");
			$this->form_validation->set_rules('bill_date','lang:bill-date','required|xss_clean|valid_date|is_date');
			$this->form_validation->set_rules('area_id','lang:area','xss_clean|required');
			foreach($sales_return_temp as $key=>$item){
				$this->form_validation->set_rules('godown_id_'.$item['sr_id'],'lang:godown','xss_clean|required');
			}
			if($this->form_validation->run() === true){

				$areaID = $this->input->post('area_id');
				$bill_no = $this->input->post('bill_no');
				$bill_date = date('Y-m-d',strtotime($this->input->post('bill_date')));
				$totalSalesReturnAmount = $this->input->post('grand_total');

				$args = array();
				$args['columns'] = array('id','company_id','branch_id','group_id','vtype_id','vno','vorder_no','vorder_no','vdate','dr_ledger','cr_ledger','vamount','narration','table_name','table_group_id','status');
				$args['table'] = 'dms_vouchers';
				$args['conditions'] = array('table_name'=>'dms_sales_returns','table_group_id'=>$group_id);
				$sales_return_vouchers = $this->dms->get_data($args);

				$this->db->trans_start();
				if($this->sales_return->update_others(array('table'=>'dms_sales_returns','data'=>array('bill_no'=>$bill_no,'bill_date'=>$bill_date,'area_id'=>$areaID,'status'=>1),'conditions'=>array('id'=>$sales_return_id)))){

						$voucher_status =1;
						if($sales_return_pay_mode > 2){
							$voucher_status = 3;
						}
						#------------------------------------------------------------------------------------------
							if($this->sales_return->update_others(array('table' => 'dms_vouchers','data' => array('vno' =>$bill_no,'vdate' =>$bill_date),'conditions' => array('group_id' => $sales_return_vouchers[0]['group_id'])))){
								if($sales_return_pay_mode > 2){
									$this->sales_return->update_others(array('table' => 'dms_voucher_banks','data' => array('vdate' => $bill_date),'conditions' => array('group_id' => $sales_return_vouchers[0]['group_id'])));
								}
							}
						}
					#------------------------------------------------------------------------------------------


					foreach($sales_return_temp as $key=>$item){

						$srItemID = $item['sr_id'];
						$itemID = $item['item_id'];
						$qty = $item['qty'];
						$unitID = $item['unit_id'];
						$rate = $item['rate'];
						$amount = $item['amount'];
						$godown_id = $this->input->post('godown_id_'.$item['sr_id']);

						if($this->sales_return->update_others(array('table'=>'dms_sales_return_items','data'=>array('status'=>1),'conditions'=>array('status'=>-1,'id'=>$srItemID)))){
							$convertedStock = $this->stock->unit_conversion($itemID,$unitID,$qty,$rate,$amount);
							if(!empty($convertedStock)){

								$this->sales_return->insert('dms_stocks',array('company_id'=>$this->companyID,'branch_id' => $this->session->userdata('under_id'),'godown_id' =>$godown_id,'item_id' =>$itemID,'qty' => $convertedStock['qty'],'unit_id' => $convertedStock['primary_unit'],'rate' => $convertedStock['rate'],'amount' => $convertedStock['amount'],'stock_date' =>$bill_date,'stock_status' =>8,'table_group_id' => $sales_return_vouchers[0]['group_id'],'table_id' => $srItemID,'status' =>1));
							}
						}
					}

					$args = array();
					$args['columns'] = array('a.id','a.group_id','b.id as pitem_id');
					$args['conditions'] = array('a.id'=>$preturnID,'a.branch_id'=>'');
					$purchaseRtns = $this->purchase_return->get_purchases($args);

					foreach($purchaseRtns as $prtkey	=>$pRtn){
						$this->db->update('dms_stocks',array('status'=>1),array('table_id'=>$pRtn['pitem_id'],'stock_status'=>4));
						$this->db->update('dms_vouchers',array('status'=>1),array('table_name'=>'dms_purchase_returns','table_group_id'=>$pRtn['group_id']));

						$args = array();
						$args['columns'] = array('id','group_id');
						$args['table'] = 'dms_vouchers';
						$args['conditions'] = array('table_name'=>'dms_purchase_returns','table_group_id'=>$pRtn['group_id']);
						$prtn_vouchers = $this->dms->get_data($args);
						if(!empty($prtn_vouchers)){
							$vchrGroupId = $prtn_vouchers[0]['group_id'];
							$this->db->update('dms_voucher_banks',array('status'=>1),array('group_id'=>$vchrGroupId));
						}
					}

				$this->db->update('dms_purchase_returns',array('p_status'=>1),array('id'=>$preturnID));
				$this->db->trans_complete();
				$this->message->set($this->lang->line('sales_return-save-success'));
				redirect('preturn_to_sreturn/requests');

				}


		$salesBill = NULL;

		if(!empty($salesID)){
			$this->db->select(array('bill_no','bill_date'));
			$this->db->from('dms_sales');
			$this->db->where(array('id'=>$salesID));
			$rowsSales = $this->db->get()->row_array();
			$salesBill = $rowsSales['bill_no'];
		}

		$return_bills[''] ='Select';
		ksort($return_bills);
		$godowns[''] = 'Select';
		ksort($godowns);
		$areas[''] = 'Select';
		ksort($areas);
		$this->template->slice('dms/message');
		$this->template->slice('sales/sales_return/purchase_return_to_sales_return',array('voucher_types'=>$voucher_types,'voucher_type' => $vtype_id,'voucher_no'=>$voucher_no,'voucher_date'=>$voucher_date,'return_bill'=>$salesBill,'customerTypes' => $customerTypes,'custType' =>1,'customers' => $customers,'cust_id' => $cust_id,'sales_returns'=>$sales_return_temp,'sales_cst'=>$sales_cst,'cess'=>$cess,'godowns'=>$godowns,'areas'=>$areas,'presumptive_tax' => $presumptive_tax,'payment_mode' => $payment_mode,'cd_status' => $cd_status,'ccd' =>$ccd,'cd_no' =>$cd_no,'pdc' => $pdc,'bill_prefix'=>$bill_prefix));
		$this->template->other_script('sales/sales_return');
		$this->template->render();

	}

	#-------------------------------------------------------

	public function bill_no_exists($bill_no,$v_details = NULL)
	{
		if($v_details == NULL){
			$where = array('vtype_id' => $this->input->post('vtype_id',true),'bill_no' => $bill_no,'status !=' => 0);
		}
		else{
			$exp = explode('.', $v_details);
			$where = array('vtype_id' => $exp[0],'bill_no' => $bill_no,'group_id !=' => $exp[1],'status !=' => 0);
		}
		$row = $this->sales_return->get_bills(array('columns' => array('id'),'conditions' => $where,'numrows' => true));
		if($row == 0){
			return true;
		}
		return false;
	}

	#------------------------------------------------------
}
?>