<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

	class Pricelist extends MY_Controller{

		public function __construct(){

			parent ::__construct();
			$this->check_access_right();
			$this->load->model('customers/Pricelist_model','pricelist');
		}
	   #----------------------------------------------------------------------
		public function add(){

			$ctypeID=NULL;
			$this->load->model('products/Item_model','item');
			$checked = array();
			#validation
			if($this->input->post('submit_one')){
				$this->form_validation->set_rules('ctype_id','lang:customer-type','required');
			}

			$valid = FALSE;
			if(isset($_POST['submit_two'])){
			
				$item_ids = $this->input->post('item_id');
				if(! empty($item_ids)){
					foreach ($item_ids as $item_id) {
						$checked[$item_id] =TRUE;
						$this->form_validation->set_rules('item['.$item_id.'][qty_from]','lang:from','required');
						$this->form_validation->set_rules('item['.$item_id.'][qty_to]','lang:to','required');
						$this->form_validation->set_rules('item['.$item_id.'][qty_unit]','lang:unit','required');
						$this->form_validation->set_rules('item['.$item_id.'][qty_amount]','lang:rate','required');
						$this->form_validation->set_rules('item['.$item_id.'][discount]','lang:discount','trim|xss_calean');
						$this->form_validation->set_rules('item['.$item_id.'][percentage]','lang:percentage','trim|xss_calean');
					}
				}else{
					$this->message->set($this->lang->line('pricelist-select'),'e');
				}
				$valid = TRUE;
			}

			if($this->form_validation->run() === TRUE){

				$valid = TRUE;
				 if(isset($_POST['submit_two']) && $valid){

				 	$cust_id  = $this->input->post('ctype_id');
				 	$item_ids = $this->input->post('item_id');
				 	$items = $this->input->post('item');
				 	$continue1 = NULL; $continue2 = NULL; 
				 	#condition checking when saving pricelist
				 	foreach($item_ids as $item){
						$data = $items[$item];
						if( $data['qty_to'] > $data['qty_from']){
							$row = $this->pricelist->save_range_check($data,$item);
							if(empty($row)){
								$continue2 = 1;
								$new_id = $item;
								break;
							}else{
								$continue2 = 0;
							}
							$continue1 = 0;
						}else{
							$continue1 = 1;
							break;
						}
					}
				
				 	if($continue2 == 1){
				 		$new_items= $this->item->get_all(array('item.id'=>$new_id))[0];
				 		$this->message->set($this->lang->line('pricelist-set').' '.$new_items['item_code'].'/'.$new_items['item_name'],'e');
				 	}else{

				 		if($continue1 == NULL && $continue2 == NULL){
						 	foreach ($item_ids as $item) {
								$data = $items[$item];
								$data['item_id'] = $item;

								$data['ctype_id'] = $cust_id;
								unset($data['percentage']);
								$flag = 0;
								if($this->pricelist->f_save('pricelist_settings',$data)){
									$flag = 1;
								}
						 	}
						 	if($flag == 1){
						 		$this->message->set($this->lang->line('pricelist-saved'),'s');
						 	}else{
						 		$this->message->set($this->lang->line('pricelist-not-saved'),'e');
						 	}
						 	redirect('pricelist/report');
				 		}else{
					 		$this->message->set($this->lang->line('qunatity-range-invalid'),'e');
					 	}
				 	}
 				}
			}
			
			if((isset($_POST['submit_one']) || isset($_POST['submit_two'])) && $valid){

				$ctypeID = $this->input->post('ctype_id');
				$items= $this->item->get_all();
				$this->load->model('products/Unit_model','unit');
				$units = $this->unit->listing();
				if(empty($items)){
					$this->message->set($this->lang->line('add-product-first'),'e');
				}
				if(!empty($items)){
					$this->template->append('customer/pricelist/add/product_pricelist.php',array('items'=>$items,'units'=>$units,'checked'=>$checked,'ctt'=>$ctypeID));
				}
			}
			#customer types listing for  
			$this->load->model('customers/Customer_type_model','type');
			$ctypes = $this->type->listing();
			$ctypes[''] = 'select a type';
			ksort($ctypes);

			#template
			$this->template->title($this->lang->line('pricelist-settings'));
			$this->template->main_heading($this->lang->line('pricelist-settings'));
			$this->template->breadcrumb(array($this->lang->line('pricelist')=>'no_link',$this->lang->line('report')=>'pricelist/report'));
			
			$this->template->slice('dms/message');
			$this->template->slice('customer/pricelist/add/select_product',array('ctypes'=>$ctypes,'ctype_id'=>$ctypeID));
			$this->template->other_script('customer/pricelist');
			$this->template->render();
		}

	   #----------------------------------------------------------------------

		public function report(){

			$links = NULL;
			$offset = NULL;
			$pricelists = NULL;
			$filter_data = array('ctype_id'=>'','item_id'=>'');

			if(isset($_POST['search']) || $this->uri->segment(3) !=''){

				$filter_data = $this->input->post(NULL,TRUE);
				if($this->input->post()){
					$filter_data = $this->input->post(NULL,TRUE);
				}else{
					$filter_data = $this->uri->uri_to_assoc(3);
				}
				$filter_data = array_filter($filter_data);
				$count = count($filter_data);
				if($count==0){
					$this->message->set($this->lang->line('use-one-search'),'e');
				}else{
					if(isset($filter_data['ctype_id'])){
						$conditions['ps.ctype_id'] = $filter_data['ctype_id'];
					}
					if(isset($filter_data['item_id'])){
						$conditions['ps.item_id'] = $filter_data['item_id'];
					}
					 if(isset($filter_data['ctype_id']) && isset($filter_data['item_id'])){
						$conditions['ps.ctype_id'] = $filter_data['ctype_id'];
						$conditions['ps.item_id'] = $filter_data['item_id'];
					}
					$this->load->library('Pagination');
		   	 		$config['total_rows'] = $this->pricelist->get_all(array('numrows'=>TRUE,'conditions'=>$conditions));
		   	 		if($config['total_rows']==0){
		   	 			$this->message->set($this->lang->line('no-result-found'),'i');
		   	 		}
		   	 		$config['base_url'] = base_url('pricelist/report').'/'.$this->uri->assoc_to_uri(array_filter($filter_data));
		   	 		$config['per_page'] = $this->per_page();
		   	 		$config['uri_segment'] = count(array_filter($filter_data))*2+3;
					# Pagination Config Customizations
					$config['full_tag_open'] = '<ul class="pagination">';
					$config['full_tag_close'] = '</ul>';
					$config['first_link'] = 'First';
					$config['last_link'] = 'Last';
					$config['next_link'] = '&raquo;';
					$config['prev_link'] = '&laquo;';
					$config['cur_tag_open'] = '<li class="active"><a href="#">';
					$config['cur_tag_close'] = '</a></li>';
					$config['num_tag_open'] = '<li>';
					$config['num_tag_close'] = '</li>';
		   	 		$this->pagination->initialize($config);
		   	 		$links = $this->pagination->create_links();
		   	 		$offset = $this->uri->segment($config['uri_segment'],0);
		   	 		$pricelists = $this->pricelist->get_all(array('conditions'=>$conditions,'order_by'=>'created_on','order'=>'DESC','limit'=>$config['per_page'],'offset'=>$offset));
				}
				if(!isset($filter_data['ctype_id'])){ $filter_data['ctype_id'] = ''; }
				if(!isset($filter_data['item_id'])){ $filter_data['item_id'] = ''; }
			}

   	 		$this->load->model('customers/Customer_type_model','type');
			$ctypes = $this->type->listing();
			$ctypes[''] = 'select a type';
			ksort($ctypes);
			$this->load->model('products/Item_model','item');
			$items = $this->item->listing();
			$items[''] = 'select a item';
			ksort($items);

			$this->template->title($this->lang->line('pricelist-settings'));
			$this->template->main_heading($this->lang->line('pricelist-settings'));
			$this->template->breadcrumb(array($this->lang->line('pricelist')=>'pricelist/add',$this->lang->line('report')=>'no_link'));
			$this->template->slice('dms/message');
			$this->template->slice('customer/pricelist/select_report',array('ctypes'=>$ctypes,'items'=>$items,'offset'=>$offset,'links'=>$links,'pricelists'=>$pricelists,'data'=>$filter_data));
			$this->template->render();

		}

	   #----------------------------------------------------------------------
	   
		public function update($id){

			if(!$this->uri->segment(3)){
				redirect('pricelist/report');
			}
			$this->load->model('products/Item_model','item');
			$pricelist_id = $this->uri->segment(3);
			
			if($this->if_exists('pricelist_settings',array('id'=>$pricelist_id,'status'=>1)) === false){
				redirect('pricelist/report');
			}

   	 		if(empty($pricelist_id)){ redirect('pricelist/report');}

			#validation
			$this->form_validation->set_rules('ctype_id','lang:customer-type','required');
			$this->form_validation->set_rules('qty_from','lang:from','required');
			$this->form_validation->set_rules('item_id','lang:product','required');
			$this->form_validation->set_rules('qty_to','lang:to','required');
			$this->form_validation->set_rules('qty_unit','lang:unit','required');
			$this->form_validation->set_rules('qty_amount','lang:rate','required');
			$this->form_validation->set_rules('discount','lang:discount','trim|xss_calean');
			$this->form_validation->set_rules('percentage','lang:percentage','trim|xss_calean');

			if($this->form_validation->run() === TRUE){

				$data = $this->input->post(NULL,TRUE);
				unset($data['percentage']);
				$continue = NULL;
				#condition checking when updating pricelist
				if($data['qty_to'] > $data['qty_from']){
					$row = $this->pricelist->update_range_check($pricelist_id,$data);
					if(empty($row)){
						$continue = 1;
					}
				}else{
					$continue = 2;
				}
				if($continue == 2){
					$this->message->set($this->lang->line('qunatity-range-invalid'),'e');
				}else if($continue == 1){
					$new_items= $this->item->get_all(array('item.id'=>$data['item_id']))[0];
					$this->message->set($this->lang->line('pricelist-set').' '.$new_items['item_code'].'/'.$new_items['item_name'],'e');
				}else{

					if($this->pricelist->update_a(array('table'=>'pricelist_settings','data'=>$data,'conditions'=>array('id'=>$pricelist_id)))){
						$this->message->set($this->lang->line('pricelist-updated'));
					}else{
						$this->message->set($this->lang->line('pricelist-not-updated'));
					}
					$call_ck_uri = $this->uri->uri_to_assoc(4);
					redirect($this->uri->assoc_to_uri($call_ck_uri));
				}
			}
   	 		$pricelist = $this->pricelist->get_all(array('conditions'=>array('ps.id'=>$pricelist_id)))[0];
			#customer types listing for  
			$this->load->model('customers/Customer_type_model','type');
			$ctypes = $this->type->listing();
			$ctypes[''] = 'select a type';
			ksort($ctypes);
				
			$items= $this->item->listing();
			$items[''] = 'Select A Product';
			ksort($items);
			
			$this->load->model('products/Unit_model','unit');
			$units = $this->unit->listing();

			$this->template->title($this->lang->line('pricelist-settings'));
			$this->template->main_heading($this->lang->line('pricelist-settings'));
			$this->template->breadcrumb(array($this->lang->line('pricelist')=>'pricelist/add',$this->lang->line('update')=>'no_link',$this->lang->line('report')=>'pricelist/report'));
			$this->template->slice('dms/message');
			$this->template->slice('customer/pricelist/update',array('ctypes'=>$ctypes,'pricelist'=>$pricelist,'units'=>$units,'items'=>$items));
			$this->template->other_script('customer/pricelist_update');
			$this->template->render();

		}

	   #----------------------------------------------------------------------

		public function delete($id){

			$pricelist_id = $id;
			if(!$this->uri->segment(3)){
				redirect('pricelist/report');
			}			
			if(empty($pricelist_id)){ redirect('pricelist/report');}
			if($this->if_exists('pricelist_settings',array('id'=>$pricelist_id,'status'=>1)) === false){
				redirect('pricelist/report');
			}			

			$data['status'] = 0;
			$data['created_by'] = $this->session->userdata('id');
			$data['created_on'] = date('Y-m-d h:i:s');

			$total_sales = $this->db->select('id')->get_where('dms_sales',array('pricelist_id'=>$pricelist_id,'status'=>1))->num_rows();
			
			if(empty($total_sales)){
				if($this->pricelist->delete_a(array('table'=>'pricelist_settings','data'=>$data,'conditions'=>array('id'=>$pricelist_id)))){
					$this->message->set($this->lang->line('pricelist-deleted'),'s');
				}else{
					$this->message->set($this->lang->line('pricelist-not-deleted'),'e');
				}
			}else{
				$this->message->set($this->lang->line('can-not-delete-pricelist'),'i');
			}
 			redirect('pricelist/report');
		}

	   #----------------------------------------------------------------------
	}
?>