<?php if( !defined('BASEPATH'))exit('No direct script access allowed');

class Product_upload_excel extends MY_Controller{

	public function __construct()
	{
		parent ::__construct();
		$this->check_access_right();
		$this->branchID = $this->session->userdata('under_id');
		$this->companyID = $this->session->userdata('company_id');	
		$this->load->library('My_excel','Stock');
		$this->load->model('products/Item_model','item');
		$this->load->model('products/Product_upload_model','productupload');
		$this->load->model('products/Opening_stock_model','opening_stock');
		
		$fiscals = $this->dms->get_fiscal_year();
		$this->fiscal_start_date = $fiscals['start_date'];
		$this->fiscal_end_date = $fiscals['end_date'];	
	}

	public function upload_data()
	{
		$this->load->library('Stock');
		$continue = 1;
		$error_bill_no =array();
		
		$item_groups = $this->item->item_group_listing();
		$item_groups['']  = 'select';
		ksort($item_groups);
		
		$fiscalStartDate = $this->fiscal_start_date;
		
		$godowns = $this->stock->get_godowns(array('listing'=>1));
		$godowns['']  = 'select';
		ksort($godowns);
        
		if($this->uri->segment(3) !='')
		{
			$error_bill_no = $this->uri->uri_to_assoc(3);
			$this->uri->rsegment(3);
		}
		
		if($this->input->post('upload',TRUE))
		{
			$this->form_validation->set_rules('purcahse_file','lang:purchase-bill','callback_file_empty');
			if($this->form_validation->run() == TRUE)
			{
				if($_FILES['product_file']['name'] != '')
				{
					$this->load->library('Image');
					$item_group_id = $this->input->post('item_group_id',TRUE);
					$godown_id = $this->input->post('godown_id',TRUE);
					$brnch_id = $this->stock->get_godown_branch($godown_id);
					$file_name = $this->image->random_name($_FILES['product_file']['name']);
					$fpart1 ="data_".date('YmdHis');
					$ext = pathinfo($_FILES['product_file']['name'], PATHINFO_EXTENSION);
					$file_name = $fpart1.".".$ext;
					if($ext != 'xlsx' && $ext != 'xls')
					{
						$this->message->set($this->lang->line('product-invalid-filetype'),'e');
					}
					else
					{
						#file uploading
						$config['upload_path'] =  FCPATH.'assets/files/product/';
						$config['allowed_types'] = 'xlsx|xls';
						$config['max_size']	= '2048';
						$config['file_name'] = $file_name;
						$this->load->library('Upload');
						$this->upload->initialize($config);
						if($this->upload->do_upload('product_file')){
							$data['product_file'] = $file_name;
							$file = FCPATH."assets/files/product/".$file_name;
							if (!empty($file) && file_exists($file)){ 
								$this->my_excel->excelObj = $this->my_excel->excelRdr->load($file);
                                $last_row = $this->my_excel->excelObj->getActiveSheet()->getHighestDataRow(); 
								$i=2;
								$invalid_dates = array('','0000-00-00','1970-01-01','0','');
								$opening_amount = 0; $k=0;
								for($i=2;$i<=$last_row;$i++){  
									$error_rows = array();
									$item_code = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('A'.$i)->getValue());
									$item_name = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('B'.$i)->getValue());
									$item_model = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('C'.$i)->getValue());
									$item_type = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('D'.$i)->getValue());
									$item_hsn = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('E'.$i)->getValue());
									$item_qty = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('F'.$i)->getValue());
									$item_unit = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('G'.$i)->getValue());
									$item_rate = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('H'.$i)->getValue());
									//$item_lcost = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('I'.$i)->getValue());
									$d_date = date('Y-m-d');
									if (!preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/",$d_date)){
									   $d_date='';
									}
									if(empty($item_code) || in_array($d_date,$invalid_dates) || empty($item_name) || empty($item_type) ||  empty($item_unit)){ 
										if(in_array($d_date,$invalid_dates)){
											$error_rows['bill_date'] = $this->lang->line('invalid-bill-date');
										}
										if(empty($item_code)){
											$error_rows['item_code'] = $this->lang->line('invalid-item-code');
										}
										if(empty($item_name)){
											$error_rows['item_name'] = $this->lang->line('invalid-item-name');
										}
										if(empty($item_type)){
											$error_rows['item_type'] = $this->lang->line('invalid-item-type');
										}
										if(empty($item_unit)){
											$error_rows['item_unit'] = $this->lang->line('invalid-item-unit');
										}
									}else{ 
										#----------------checking bill date is currnt finacual year/and closed financial year
										$check_date = $this->form_validation->valid_date($d_date);
                                        $unit_id = $this->productupload->get_unit_id($item_unit);
                                        $item_id = $this->productupload->get_item_id($item_code,$item_name,$item_model,$item_group_id,$item_type,$unit_id,$item_hsn);
										if($item_id!=''){ 
                                            $stock_data = array();
                                            $stock_data['company_id'] = $this->session->userdata('company_id');
                                            $stock_data['branch_id'] = $brnch_id;
                                            $stock_data['godown_id'] = $godown_id;
                                            $stock_data['item_id'] = $item_id; 
                                            $stock_data['qty'] = $item_qty;
                                            $stock_data['unit_id'] = $unit_id;
                                            $stock_data['rate'] = $item_rate;
                                            $stock_data['amount'] = (float)$item_qty*(float)$item_rate;
                                            $stock_data['stock_date'] = $d_date;
                                            $stock_data['stock_status'] = 0;
                                            $stock_data['status'] = 1;
                                            (float)$opening_amount += (float)$item_qty*(float)$item_rate;
                                            $this->productupload->f_save('dms_stocks',$stock_data);
                                            if(!empty($item_rate)){
                                                $rate_data = array();
                                                $rate_data['company_id'] = $this->session->userdata('company_id');
                                                $rate_data['item_id'] = $item_id; 
                                                $rate_data['rate'] = $item_rate;
                                                $rate_data['valid_from'] = $d_date;
                                                $rate_data['status'] = 1;
                                                $this->productupload->f_save('dms_item_rates',$rate_data);
										    }
                                            if(!empty($item_lcost)){
                                                $this->db->update('dms_item_rates',array('landing_cost'=>$item_lcost),array('item_id'=>$item_id));
                                            } 
										}
									}
									if(!empty($error_rows)){
										if(empty($error_string)){
											$error_string = "Row $i [ ".implode(" ,",$error_rows)." ]<br>";
										}else{
											$error_string .= "Row $i [ ".implode(" ,",$error_rows)." ]<br>";
										}
									}
								}
								if($opening_amount >0){
                                    $check_opening = $this->opening_stock->get_opening_balance(array('select'=>array('id','open_amount'),'conditions'=>array('company_id'=>$this->companyID,'branch_id'=>$this->branchID,'open_date'=>$fiscalStartDate)));
                                    if(empty($check_opening)){
                                        $this->opening_stock->save_opening_balance(array('company_id'=>$this->companyID,'branch_id'=>$this->branchID,'open_amount'=>$opening_amount,'open_date'=>$fiscalStartDate,'status'=>1));
                                    }else{
                                        $up_id = $check_opening[0]['id'];
                                        $prev_opening = $check_opening[0]['open_amount'];
                                        $new_opening = (float)$prev_opening+(float)$opening_amount;
                                        $this->opening_stock->update_opening_balance(array('open_amount'=>$new_opening),array('company_id'=>$this->companyID,'branch_id'=>$this->branchID,'open_date'=>$fiscalStartDate));
                                    }
                                }
								if(!empty($error_string)){ ?>
									<script>localStorage.setItem('perrors',"<?php echo $error_string;?>");</script>
								<?php }
							}else{
								$continue = 0;
								$this->message->set($this->lang->line('invalid-filetype'),'e');
							}
						}else{
							$continue=0;
							$this->message->set($this->lang->line('invalid-filetype'),'e');
						}
						if($continue ==1){
							$this->message->set($this->lang->line('product-data-uploaded','s'));
						}
					}
				}
			}
		}

		$this->template->title($this->lang->line('products').' '.$this->lang->line('upload'));
		$this->template->main_heading($this->lang->line('products').' '.$this->lang->line('upload'));
		$this->template->breadcrumb(array($this->lang->line('products') => 'products/add',$this->lang->line('report') => 'products/report',$this->lang->line('upload')=>'no_link'));
		$this->template->slice('dms/message');
		$this->template->slice('products/upload_data/upload',array('groups'=>$item_groups,'godowns'=>$godowns,'itemc'=>$item_code));
		$this->template->render();
	}
#-------------------------------------------------------------------upload product details-----------------------------------------------------------------------------
	
	public function update_product_details(){
        $this->load->library('Stock');
		$continue = 1;
		$error_bill_no=array();
		
        if($this->uri->segment(3) !=''){
			$error_bill_no = $this->uri->uri_to_assoc(3);
			$this->uri->rsegment(3);
		}
	  
        if($this->input->post('upload',TRUE)){
            $this->form_validation->set_rules('purcahse_file','lang:purchase-bill','callback_file_empty');
			if($this->form_validation->run() == TRUE){
                if($_FILES['product_file']['name'] != ''){
				    $this->load->library('Image');
					$file_name = $this->image->random_name($_FILES['product_file']['name']);
					$fpart1 = "data_".date('YmdHis');
					$ext = pathinfo($_FILES['product_file']['name'], PATHINFO_EXTENSION);
					$file_name = $fpart1.".".$ext;
					if($ext != 'xlsx' && $ext != 'xls'){
						$this->message->set($this->lang->line('product-invalid-filetype'),'e');
					}else{
					    #file uploading
						$config['upload_path'] = FCPATH.'assets/files/update_product_details/';
						$config['allowed_types'] = 'xlsx|xls';
						$config['max_size']	= '2048';
						$config['file_name'] = $file_name;
						$this->load->library('Upload');
						$this->upload->initialize($config);
						if($this->upload->do_upload('product_file')){
							$data['product_file'] = $file_name;
							$file = FCPATH."assets/files/update_product_details/".$file_name;
							if(!empty($file) && file_exists($file)){ 
								$this->my_excel->excelObj = $this->my_excel->excelRdr->load($file);
                                $last_row = $this->my_excel->excelObj->getActiveSheet()->getHighestDataRow();
								for($i=2;$i<=$last_row;$i++){  
									$error_rows = array();
									#-----------------read from excel
                                    $item_code = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('A'.$i)->getValue());
									$item_name = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('B'.$i)->getValue());
									if(empty($item_code) || empty($item_name)){ 
										if(empty($item_code)){
											$error_rows['item_code'] = $this->lang->line('invalid-item-code');
										}
										if(empty($item_name)){
											$error_rows['item_name'] = $this->lang->line('invalid-item-name');
										}
									}else{ 
                                        $this->db->update('item_master',array('item_name'=>$item_name),array('item_code'=>$item_code));
									}
								}
								
								if(!empty($error_rows)){
									if(empty($error_string)){
										$error_string = "Row $i [ ".implode(" ,",$error_rows)." ]<br>";
									}else{
										$error_string .= "Row $i [ ".implode(" ,",$error_rows)." ]<br>";
									}
								}
							}
								
							if(!empty($error_string)){ ?>
								<script>localStorage.setItem('perrors',"<?php echo $error_string;?>");</script>
							<?php }
						}else{
							$continue = 0;
							$this->message->set($this->lang->line('invalid-filetype'),'e');
						}
					}
                }else{
					$continue=0;
					$this->message->set($this->lang->line('invalid-filetype'),'e');
				}
				if($continue ==1){
					$this->message->set($this->lang->line('product-data-uploaded','s'));
				}
			}
				    
		}

        #--------------------template
		$this->template->title($this->lang->line('products').' '.$this->lang->line('details').' '.$this->lang->line('upload'));
		$this->template->main_heading($this->lang->line('products').' '.$this->lang->line('details').' '.$this->lang->line('upload'));
		$this->template->breadcrumb(array($this->lang->line('products') => 'products/add',$this->lang->line('report') => 'products/report',$this->lang->line('upload')=>'no_link'));
		$this->template->slice('dms/message');
		$this->template->slice('products/update_product_details');
		$this->template->render();  
	}
	
	public function upload_product_details()
	{
	  $this->load->library('Stock');
		$continue = 1;
		$error_bill_no =array();
		
		$item_groups = $this->item->item_group_listing();
		$item_groups['']  = 'select';
		ksort($item_groups);
		
		$fiscalStartDate = $this->fiscal_start_date;
		
		$godowns = $this->stock->get_godowns1(array('listing'=>1));
		$godowns['']  = 'select';
		ksort($godowns);
		
	  if($this->uri->segment(3) !='')
		{
			$error_bill_no = $this->uri->uri_to_assoc(3);
			$this->uri->rsegment(3);
		}
	  
	  if($this->input->post('upload',TRUE))
		{
		    
		    $this->form_validation->set_rules('purcahse_file','lang:purchase-bill','callback_file_empty');
			if($this->form_validation->run() == TRUE)
			{
			    if($_FILES['product_file']['name'] != '')
				{
				    $this->load->library('Image');
					$item_group_id = $this->input->post('item_group_id',TRUE);
					//$godown_id = $this->input->post('godown_id',TRUE);
					$file_name = $this->image->random_name($_FILES['product_file']['name']);
					$fpart1 ="data_".date('YmdHis');
					$ext = pathinfo($_FILES['product_file']['name'], PATHINFO_EXTENSION);
					$file_name = $fpart1.".".$ext;
					if($ext != 'xlsx' && $ext != 'xls')
					{
						$this->message->set($this->lang->line('product-invalid-filetype'),'e');
					}
					else
					{
					    #file uploading
						$config['upload_path'] =  FCPATH.'assets/files/product_details/';
						$config['allowed_types'] = 'xlsx|xls';
						$config['max_size']	= '2048';
						$config['file_name'] = $file_name;
						$this->load->library('Upload');
						$this->upload->initialize($config);
						if($this->upload->do_upload('product_file'))
						{
							$data['product_file'] = $file_name;
							$file = FCPATH."assets/files/product_details/".$file_name;
							if (!empty($file) && file_exists($file))
							{ 
								$this->my_excel->excelObj = $this->my_excel->excelRdr->load($file);
							    $last_row = $this->my_excel->excelObj->getActiveSheet()->getHighestDataRow();
								$i=2;

								$invalid_dates = array('','0000-00-00','1970-01-01','0','');
								$opening_amount = 0; $k=0;
								for($i=2;$i<=$last_row;$i++)
								{  
									$error_rows = array();
									#-----------------read from excel
								    $item_code = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('A'.$i)->getValue());
									$item_name = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('B'.$i)->getValue());
									//$item_type = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('C'.$i)->getValue());
									
									$model_no = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('C'.$i)->getValue());
									$diametre = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('D'.$i)->getValue());
									$lense_type = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('E'.$i)->getValue());
									$dv1 = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('F'.$i)->getValue());
									$dv2 = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('G'.$i)->getValue());
									$dv3 = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('H'.$i)->getValue());
									$dv4 = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('I'.$i)->getValue());
									$nv1 = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('J'.$i)->getValue());
									$nv2 = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('K'.$i)->getValue());
									$nv3 = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('L'.$i)->getValue());
									$nv4 = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('M'.$i)->getValue());
									$padd = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('N'.$i)->getValue());
									$tint = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('O'.$i)->getValue());
									$coating = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('P'.$i)->getValue());
									$lpower = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('Q'.$i)->getValue());
									$hpower = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('R'.$i)->getValue());
									$lwidth = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('S'.$i)->getValue());
									$index = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('T'.$i)->getValue());
									$material = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('U'.$i)->getValue());
									$bwidth = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('V'.$i)->getValue());
									$alength = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('W'.$i)->getValue());
									$gender = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('X'.$i)->getValue());
									$shape = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('Y'.$i)->getValue());
									$color = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('Z'.$i)->getValue());
									$frame_type = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('AA'.$i)->getValue());
									$size = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('AB'.$i)->getValue());
									$clense_color = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('AC'.$i)->getValue());
									$ocolor = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('AD'.$i)->getValue());
									$olense_color = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('AE'.$i)->getValue());
									$ogender = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('AF'.$i)->getValue());
									$rframe_type = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('AG'.$i)->getValue());
									$rframe_color = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('AH'.$i)->getValue());
									$rgender = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('AI'.$i)->getValue());
									$rpower = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('AJ'.$i)->getValue());
									$batch = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('AK'.$i)->getValue());
									
									$item_hsn = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('AL'.$i)->getValue());
								//	$item_qty = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('AN'.$i)->getValue());
								//	$item_unit = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('AM'.$i)->getValue());
								//	$item_rate = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('AP'.$i)->getValue());
									
									/*$d_date = $this->my_excel->excelObj->getActiveSheet()->getCell('AQ'.$i)->getValue();
									$d_date = PHPExcel_Style_NumberFormat::toFormattedString($d_date, 'YYYY-MM-DD');
									if (!preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/",$d_date)){
									   $d_date='';
									}
									$d_date = date('Y-m-d',strtotime($d_date));*/
									if(empty($item_code) ||  empty($item_name))
									{ 
										/*if(in_array($d_date,$invalid_dates)){
											$error_rows['bill_date'] = $this->lang->line('invalid-bill-date');
										}*/
										if(empty($item_code)){
											$error_rows['item_code'] = $this->lang->line('invalid-item-code');
										}
										if(empty($item_name)){
											$error_rows['item_name'] = $this->lang->line('invalid-item-name');
										}
										
									
										/*if(empty($item_unit)){
											$error_rows['item_unit'] = $this->lang->line('invalid-item-unit');
										}*/
									}
									else
									{ 
										#----------------checking bill date is currnt finacual year/and closed financial year
										$item_type = $this->stock->get_type($item_group_id);
									    $check_date = $this->form_validation->valid_date($d_date);
                                        //$unit_id = $this->productupload->get_unit_id($item_unit);
                                       // echo $item_code." ".$item_name." ".$item_group_id." ".$item_type." ".$unit_id." ".$item_hsn."<br>";
										$item_id = $this->productupload->get_itemdetails_id($item_code,$item_name,$item_group_id,$item_type,$model_no,$diametre,$lense_type,$dv1,$dv2,$dv3,$dv4,$nv1,$nv2,$nv3,$nv4,$padd,$tint,$coating,$lpower,$hpower,$lwidth,$index,$material,$bwidth,$alength,$gender,$shape,$color,$frame_type,$size,$clense_color,$ocolor,$olense_color,$ogender,$rframe_type,$rframe_color,$rgender,$rpower,$batch,$unit_id,$item_hsn);
								    	if($item_id!='')
										{
										    
										    /*---------------------------------------------------------------------*/
										    
										    $this->db->update('item_master',array('model_no	'=>$model_no,'diametre'=>$diametre,'lens_type'=>$lense_type,'dv1'=>$dv1,'dv2'=>$dv2,'dv3'=>$dv3,'dv4'=>$dv4,'nv1'=>$nv1,'nv2'=>$nv2,'nv3'=>$nv3,'nv4'=>$nv4,'padd'=>$padd,'tint'=>$tint,'coating'=>$coating,'lpower'=>$lpower,'hpower'=>$hpower,'lwidth'=>$lwidth,'lindex'=>$index,'material'=>$material,'bwidth'=>$bwidth,'alength'=>$alength,'gender'=>$gender,'shape'=>$shape,'color'=>$color,'frame_type'=>$frame_type,'size'=>$size,'clens_color'=>$clense_color,'ocolor'=>$ocolor,'olens_color'=>$olense_color,'ogender'=>$ogender,'rframe_type'=>$rframe_type,'rframe_color'=>$rframe_color,'rgender'=>$rgender,'rpower'=>$rpower,'batch'=>$batch,'hsn'=>$item_hsn),array('id'=>$item_id));
										    
										    
										    
										    /*----------------------------------------------------------------------*/
										    /*$stock_data = array();
										    $stock_data['company_id'] = $this->session->userdata('company_id');
										    $stock_data['branch_id'] = $this->session->userdata('under_id');
										    $stock_data['godown_id'] = $godown_id;
										    $stock_data['item_id'] = $item_id; 
										    $stock_data['qty'] = $item_qty;
										    $stock_data['unit_id'] = $unit_id;
										    $stock_data['rate'] = $item_rate;
										    $stock_data['amount'] = $item_qty*$item_rate;
										    $stock_data['stock_date'] = $d_date;
										    $stock_data['stock_status'] = 0;
										    $stock_data['status'] = 1;
										    $opening_amount += $item_qty*$item_rate;
										  	  $args = array();
                            				$args['select'] = array('id');
                            				$args['conditions'] = array('company_id'=>$this->companyID,'godown_id'=>$godown_id,'item_id'=>$item_id,'stock_status'=>0);
                            				$checkExists = $this->opening_stock->get($args);
                            				if(empty($checkExists))
                            				{      
                            				
										        $this->productupload->f_save('dms_stocks',$stock_data);
                            				}
                            				else
                            				{ 
                            				    $up_id = $checkExists[0]['id'];
                            				    $uparray = array();
                            				    $this->db->update('dms_stocks',array('qty'=>$item_qty,'rate'=>$item_rate,'amount'=>$stock_data['amount']),array('id'=>$up_id));
                            				}
										    */
										    
										    
										    
										}
										
										
										
										
										
									}
									if(!empty($error_rows))
									{
										if(empty($error_string)){
											$error_string = "Row $i [ ".implode(" ,",$error_rows)." ]<br>";
										}
										else{
											$error_string .= "Row $i [ ".implode(" ,",$error_rows)." ]<br>";
										}
									}
									
									
								}
								
								
								if(!empty($error_string))
								{
									?>
									<script>localStorage.setItem('perrors',"<?php echo $error_string;?>");</script>
									<?php
								}
								
								
								
							}
							else
							{
								$continue = 0;
								$this->message->set($this->lang->line('invalid-filetype'),'e');
							}

						}
						else
						{
							$continue=0;
							$this->message->set($this->lang->line('invalid-filetype'),'e');
						}
						if($continue ==1)
						{
							$this->message->set($this->lang->line('product-data-uploaded','s'));
							//redirect('Purchase_upload_excel/upload_bill');
						}
					}
				    
				}
			    
			}
		    
		}
	  
	  
	  #--------------------template
		$this->template->title($this->lang->line('products').' '.$this->lang->line('details').' '.$this->lang->line('upload'));
		$this->template->main_heading($this->lang->line('products').' '.$this->lang->line('details').' '.$this->lang->line('upload'));
		$this->template->breadcrumb(array($this->lang->line('products') => 'products/add',$this->lang->line('report') => 'products/report',$this->lang->line('upload')=>'no_link'));
		$this->template->slice('dms/message');
		$this->template->slice('products/upload_data/product_details',array('groups'=>$item_groups,'godowns'=>$godowns,'itemc'=>$item_code));
		$this->template->render();  
	}

    public function upload_landing_cost(){
        $this->load->library('Stock');
		$continue = 1;
		$error_bill_no =array();
		
		$item_groups = $this->item->item_group_listing();
		$item_groups['']  = 'select';
		ksort($item_groups);
		
		$fiscalStartDate = $this->fiscal_start_date;
		
		$godowns = $this->stock->get_godowns1(array('listing'=>1));
		$godowns['']  = 'select';
		ksort($godowns);
		
        if($this->uri->segment(3) !=''){
			$error_bill_no = $this->uri->uri_to_assoc(3);
			$this->uri->rsegment(3);
		}
	  
	    if($this->input->post('upload',TRUE)){
		    $this->form_validation->set_rules('purcahse_file','lang:purchase-bill','callback_file_empty');
			if($this->form_validation->run() == TRUE){
			    if($_FILES['product_file']['name'] != ''){
				    $this->load->library('Image');
					$file_name = $this->image->random_name($_FILES['product_file']['name']);
					$fpart1 ="data_".date('YmdHis');
					$ext = pathinfo($_FILES['product_file']['name'], PATHINFO_EXTENSION);
					$file_name = $fpart1.".".$ext;
					if($ext != 'xlsx' && $ext != 'xls'){
						$this->message->set($this->lang->line('product-invalid-filetype'),'e');
					}else{
					    #file uploading
						$config['upload_path'] =  FCPATH.'assets/files/landingcost_details/';
						$config['allowed_types'] = 'xlsx|xls';
						$config['max_size']	= '2048';
						$config['file_name'] = $file_name;
						$this->load->library('Upload');
						$this->upload->initialize($config);
						if($this->upload->do_upload('product_file')){
							$data['product_file'] = $file_name;
							$file = FCPATH."assets/files/landingcost_details/".$file_name;
							if(!empty($file) && file_exists($file)){ 
								$this->my_excel->excelObj = $this->my_excel->excelRdr->load($file);
							    $last_row = $this->my_excel->excelObj->getActiveSheet()->getHighestDataRow();
								$i=2;

								$opening_amount = 0; $k=0;
								for($i=2;$i<=$last_row;$i++){  
									$error_rows = array();
									$item_code = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('A'.$i)->getValue());
									$item_name = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('B'.$i)->getValue());
									$landing_cost = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('C'.$i)->getValue());
									$rate = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('D'.$i)->getValue());
									
									if(empty($item_code)){
										$error_rows['item_code'] = $this->lang->line('invalid-item-code');
									}else{ 
										$row = $this->db->query("select * from item_master where item_code='$item_code'")->result_array();
										$item_id = $row[0]['id'];
										
										if(!empty($item_id)) {
										    $rarray = [];
										    if($landing_cost!='' && $landing_cost > 0) {
										        $rarray['landing_cost'] = $landing_cost;
										    }
										    if($rate!='' && $rate > 0) {
										        $rarray['rate'] = $rate;
										    }
										    
										    if(!empty($rarray)) {
										        $rarray['company_id'] = $this->session->userdata('company_id');
                                                $rarray['item_id'] = $item_id; 
                                                $rarray['valid_from'] = date('Y-m-d');
                                                $rarray['status'] = 1;
                                                $this->productupload->f_save('dms_item_rates',$rarray);
										        
										        
										        
										        
										       // $this->db->update('dms_item_rates',$rarray,array('item_id'=>$item_id));
										    }
										}
									}
									if(!empty($error_rows)){
										if(empty($error_string)){
											$error_string = "Row $i [ ".implode(" ,",$error_rows)." ]<br>";
										}else{
											$error_string .= "Row $i [ ".implode(" ,",$error_rows)." ]<br>";
										}
									}
								}
								
								if(!empty($error_string)){ ?>
									<script>localStorage.setItem('perrors',"<?php echo $error_string;?>");</script>
                                <?php }
    						}else{
    								$continue = 0;
    								$this->message->set($this->lang->line('invalid-filetype'),'e');
    						}
						}else{
							$continue=0;
							$this->message->set($this->lang->line('invalid-filetype'),'e');
						}
						if($continue ==1){
							$this->message->set($this->lang->line('landing-data-uploaded','s'));
							//redirect('Purchase_upload_excel/upload_bill');
						}
					}
				}
			}
		}
	  
	    #--------------------template
		$this->template->title($this->lang->line('landing').' '.$this->lang->line('cost').' '.$this->lang->line('upload'));
		$this->template->main_heading($this->lang->line('landing').' '.$this->lang->line('cost').' '.$this->lang->line('upload'));
		$this->template->breadcrumb(array($this->lang->line('products') => 'products/add',$this->lang->line('report') => 'products/report',$this->lang->line('upload')=>'no_link'));
		$this->template->slice('dms/message');
		$this->template->slice('products/upload_data/landing_cost_details',array('groups'=>$item_groups,'godowns'=>$godowns,'itemc'=>$item_code));
		$this->template->render();  
	}

    #-----------------------------------------------------------------------------------------------------------------------------------------------------------------------

	public function file_empty()
	{
		if(isset($_FILES['product_file']) && !empty($_FILES['product_file']['name'])){
			return true;
		}else{
			return false;
		}
	}
}
?>