<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

	class Products extends MY_Controller{

		public function __construct(){
			parent :: __construct();
			$this->check_access_right();
			
			#---------------- Checking Financial year is enabled / closed-----------------#
			$method_array = array('add','add_item_type','update','delete','add_mans','add_mans','delete_mans','update_mans','update_item_type','delete_item_type');
			fiscal_status($this->uri->segment(2),$method_array,"products/report");	
			#---------------- Checking Financial year is enabled / closed-----------------#	
			
			$fiscals = $this->dms->get_fiscal_year();
		    $this->fiscal_start_date = $fiscals['start_date'];
			$this->fiscal_end_date = $fiscals['end_date'];	
			
    	    $this->branchID = $this->session->userdata('under_id');
		    $this->companyID = $this->session->userdata('company_id');	
	
		}

		#-----------------------------------------------
		
		#date : 11-6-2014
		#purpose : master product sub-menu links
		public function index(){

			$this->template->title($this->lang->line('manage-products'));
			$this->template->main_heading($this->lang->line('manage-products'));
			$this->template->breadcrumb(array($this->lang->line('products')=>'products/add',$this->lang->line('settings')=>'no_link'));

			#get menus under products
			$this->db->select('mm.*');
			$this->db->from('menu_master mm');
			$this->db->join('user_privileges up','up.menu_id=mm.id');
			$this->db->where('up.user_group','individual');

			if($this->session->userdata('id')!='-1')
			{
				$this->db->where('up.owner_id',$this->session->userdata('id'));
			}
			$this->db->where_in('mm.menu_group',array('item-types'));
			$this->db->where('mm.menu_parent',56); #product-master
			$this->db->where('mm.menu_type','settings');
			$this->db->order_by('menu_order','ASC');
			$menus = $this->db->get()->result_array();

			if(!$menus){redirect('dms/');}
			$this->template->slice('preferences/general/link_list',array('menus'=>$menus));
			$this->template->render();

		}	

		#------------------------------------------------
		
		#date : 7-6-2014	
		#purpose : add new product item
		public function add()
		{
			#get all units
			$this->load->model('products/Unit_model','unit');
			$this->load->model('products/Manufacture_model','manu');
			$this->load->model('products/Item_model','item');
			$this->load->model('godown/Godown_model','godown');
			$this->load->library('Stock');
          
			#validation rules
			$this->form_validation->set_rules('item_code','lang:item-code','required|trim|xss_clean|is_unique[item_master.item_code]');
			$this->form_validation->set_rules('item_name','lang:item-name','required|trim|xss_clean|is_unique[item_master.item_name]');
			$this->form_validation->set_rules('item_group_id','lang:item-type','required|trim|xss_clean');
			$this->form_validation->set_rules('item_manufacturer_id','lang:manufacturer-name','required|trim|xss_clean');
			$this->form_validation->set_rules('unit_id','lang:unit','required|trim|xss_clean');		
            $this->form_validation->set_rules('item_types','lang:item_type','required'); 
			$this->form_validation->set_rules('alt_unit_id','lang:alternate-unit','trim|xss_clean|callback_check_alternative_unit');
			$this->form_validation->set_rules('alt_unit_conversion','lang:conversion','trim|xss_clean');
			$this->form_validation->set_rules('unit_conversion','lang:conversion','trim|xss_clean');
			$this->form_validation->set_rules('hsn','lang:hsn-code','trim|xss_clean');
			$this->form_validation->set_rules('stock_type','lang:commodity-code','trim|xss_clean');
			
			if(!empty($this->input->post('unit_id')))
			{
				$alt_units = $this->stock->get_units($this->input->post('unit_id'),1);
				$alt_units[0] = 'Select';
				ksort($alt_units);
				if($this->input->post('alt_unit_id') > 1)
				{
					$this->form_validation->set_rules('unit_conversion','lang:conversion','required|trim|xss_clean');
					$this->form_validation->set_rules('alt_unit_conversion','lang:conversion','required|trim|xss_clean');
				}
			}
			$alt_units[0] = 'Select';
			
			$args['select'] = array('id','item_code','item_name');
		    $items = $this->stock->get_stock_items($args);
		    $items[''] = 'Select';ksort($items);
			#listing functions 
			#unit listing
			$units = $this->unit->listing();
			$godowns = $this->godown->listing1();
			#manufature listing
			$manus = $this->manu->listing();
			$tint = $this->item->tint_listing();
            $shape = $this->item->shape_listing();
			#item group listing
			$item_groups = $this->item->item_group_listing();
			$item_groups['']  = 'select';
			ksort($item_groups);
			#validation and save
			if($this->form_validation->run() === true)
			{ 
				$data = $this->input->post(NULL,TRUE);
				$data['company_id'] = $this->session->userdata('company_id');
                $data['edate'] = date('Y-m-d',strtotime($data['edate']));
				if(empty($data['alt_unit_id']) && $data['alt_unit_id']==0)
				{
					unset($data['alt_unit_id']);
					unset($data['unit_conversion']);
					unset($data['alt_unit_conversion']);
				}
				
				$tp = $data['item_types'];
				$cd = $data['item_code'];

                if($tp=='aframe' || $tp=='alens')
    			{
    			    $data['code_id'] = substr($cd,3);
    			}
    			else if($tp=='contact' || $tp=='solution' || $tp=='oframe' || $tp=='olens' || $tp=='essilor' || $tp=='eupgrade' || $tp=='kodak')
    			{
    			    $data['code_id'] = substr($cd,2);
    			}
    			else
    			{
    			    $data['code_id'] = substr($cd,1);
    			}
    			
    			$new_stock = array(); $new_rate = array(); $new_itmstk = array();
                $new_stock['company_id'] = $new_rate['company_id'] = $this->session->userdata('company_id');
                $new_stock['branch_id'] = $this->session->userdata('under_id');
                
                $new_itmstk['company_id'] = $this->session->userdata('company_id');
                $new_itmstk['branch_id'] = $this->session->userdata('under_id');
                
                if($data['godown_id'] !='')
                {
                    $new_stock['godown_id'] = $data['godown_id'];
                    $new_itmstk['godown_id'] = $data['godown_id'];
                }
                else
                {
                   $new_stock['godown_id'] = $new_itmstk['godown_id'] = $data['godown_id'] = 0;  
                }
                
                if($data['qty']!='')
                {
                    $new_stock['qty'] = $data['qty'];
                    $new_itmstk['qty'] = $data['qty'];
                }
                else
                {
                    $new_stock['qty'] = 0;
                    $new_itmstk['qty'] = 0;
                }
                
                $new_stock['unit_id'] = $data['unit_id'];
                $new_itmstk['unit_id'] = $data['unit_id'];
                if($data['rate']!='')
                {
                    $new_stock['rate'] = $new_rate['rate'] = $data['rate'];
                }
                else
                {
                    $new_stock['rate'] = $new_rate['rate'] = 0;
                }
                $new_stock['stock_date'] = $new_rate['valid_from'] = $this->fiscal_start_date;
                $new_stock['status'] = $new_rate['status'] = 1;

    			unset($data['qty']);
    			unset($data['godown_id']);
    			unset($data['rate']);
    			unset($data['item']);
    			
				
				$ins_id =$this->item->f_save('item_master',$data);
				if($ins_id)
				{
				    $new_stock['item_id'] = $new_rate['item_id'] = $ins_id;
				    
				    $this->item->f_save('dms_stocks',$new_stock);
                    $this->item->f_save('dms_item_rates',$new_rate);
                    $new_itmstk['item_id'] = $ins_id;
                    
                    $this->item->f_save('item_stock',$new_itmstk);
                    
                    $this->message->set($this->lang->line('product-saved'));
				}
				else
				{
					$this->message->set($this->lang->line('product-not-saved'));
				}
				redirect('products/report');
			}
			#defining for where unit and = unit
			$sec_unit = $this->lang->line('unit');
			$first_unit = $this->lang->line('unit');
			#repopulate where unit  and = unit in validation error
			if($this->input->post('alt_unit_id')){
				$alt_id = $this->input->post('alt_unit_id');
				if(array_key_exists($alt_id,$alt_units)){
					$sec_unit = $alt_units[$alt_id];
				}
				$unit_id = $this->input->post('unit_id');
				if(array_key_exists($unit_id,$units)){
					$first_unit = $units[$unit_id];
				} 
			}	
			#----------------------------------------------------------------------------------------demo
			/*	$godowns = $this->stock->get_godowns(array('conditions'=>array('branch_id'=>$this->branchID)));
	        	if(empty($godowns)){
			              $this->message->set($this->lang->line('no-godown-found'),'i');
		         }
		*/
			#----------------------------------------------------------------------------------------demo
			$this->template->title($this->lang->line('add-new-product'));
			$this->template->main_heading($this->lang->line('add-new-product'));
			$this->template->breadcrumb(array($this->lang->line('products')=>'no_link',$this->lang->line('report')=>'products/report'));
			$this->template->slice('dms/message');
			$this->template->slice('products/new/new',array('godowns'=>$godowns,'items'=>$items,'units'=>$units,'alt_unit'=>$alt_units,'manus'=>$manus,'tint'=>$tint,'shape'=>$shape,'groups'=>$item_groups,'sec_unit'=>$sec_unit,'first_unit'=>$first_unit));
			$this->template->other_script('products/autocomplete_item_manu');
			$this->template->render();
		}

		#------------------------------------------------	

		public function check_alternative_unit($str)
		{
			if(!empty($str))
			{
				$alt_unit_id = $this->input->post('unit_id');
				if ($str == $alt_unit_id)
				{
					$this->form_validation->set_message('check_alternative_unit',$this->lang->line('check_alternative_unit'));
					return FALSE;
				}
				else
				{
					return TRUE;
				}
			}
			return true;
		}

		#------------------------------------------------

		public function report(){

			#load item_model
			$this->load->model('products/Item_model','item');
			$this->form_validation->set_rules('manu_name','lang:manufacturer name','required');
            //$this->form_validation->set_rules('itm','lang:item name','required');
            $conditions=array();
			if($this->form_validation->run() === true || $this->uri->segment(3) == 'manu')
            {
				$manu = ($this->input->post('manu_name'))?$this->input->post('manu_name',true):$this->uri->segment(4);
				if($manu != 'all')
                {
					$conditions['item.item_manufacturer_id'] =$manu;
				}
			}
			else
			{
				$manu = '';
			}
            
            if(!empty($this->input->post('itm')))
            { 
                $itm = $this->input->post('itm',true);
                if($itm != 'all')
                {
					$conditions['item.id'] =$itm;
				}
            }
            
          /*  $this->load->model('booking/Booking_model','sales_obj');
            $arr = $this->db->query("select id from item_master where id not in (select item_id from dms_stocks where branch_id='22')")->result_array();
            foreach($arr as $k=>$v)
            {
                $new_stock = array();
                        $new_stock['company_id'] = 1;
                        $new_stock['branch_id'] = 22;
                        $new_stock['godown_id'] = 23;
                        $new_stock['item_id'] = $v['id'];
                        $new_stock['qty']=0;
                        $new_stock['unit_id'] = 1;
                    	$new_stock['rate'] = 0;
                    	$new_stock['stock_status'] = 0;
                    	$new_stock['stock_date'] = $this->fiscal_start_date;
                    	$new_stock['status'] = 1;
                        $this->sales_obj->insert("dms_stocks",$new_stock);
            print_r($new_stock); echo "<br>";
            }
            
            $this->load->model('booking/Booking_model','sales_obj');
            $qry = $this->db->query("SELECT * FROM item_master WHERE id not in (SELECT item_id FROM dms_item_rates)")->result_array();
            foreach($qry as $k=>$v)
            {
                $itid = $v['id'];
            
                $arr = $this->db->query("SELECT * FROM dms_stocks WHERE item_id='$itid' and rate > 0")->row_array();
                $rate = $arr['rate'];
            
                $new_stock = array();
                $new_stock['company_id'] = 1;
                $new_stock['item_id'] = $itid;
                $new_stock['rate'] = $rate;
                $new_stock['valid_from'] = '2019-04-01';
                $new_stock['status']=1;
                $this->sales_obj->insert("dms_item_rates",$new_stock);
                print_r($new_stock); echo "<br>";
            }
            */
            
            //print_r($conditions);

			$this->template->title($this->lang->line('product-reports'));
			$this->template->main_heading($this->lang->line('product-reports'));
			$this->template->breadcrumb(array($this->lang->line('products')=>'products/add',$this->lang->line('report')=>'no_link'));
			#paginated result
			$conditions['item.company_id'] =  $this->session->userdata('company_id');
			$this->load->library('Pagination');
			$config['per_page'] = $this->per_page();
			$config['total_rows'] = $this->item->get_all($conditions,1);
			if($config['total_rows'] == 0)
			{ 
				$this->message->set($this->lang->line('no-items-found'),'i');
			}

			if($this->uri->segment(3) == 'manu' || $this->input->post('manu_name')){
				$config['base_url'] = base_url('products/report/manu/'.$manu);
				$config['uri_segment'] = 5;
				$offset = ($this->uri->segment(5))?$this->uri->segment(5):0;
			}else{
				$config['base_url'] = base_url('products/report');
				$config['uri_segment'] = 3;
				$offset = ($this->uri->segment(3))?$this->uri->segment(3):0;
			}
			# Pagination Config Customizations
			$config['full_tag_open'] = '<ul class="pagination">';
			$config['full_tag_close'] = '</ul>';
			$config['first_link'] = 'First';
			$config['last_link'] = 'Last';
			$config['next_link'] = '&raquo;';
			$config['prev_link'] = '&laquo;';
			$config['cur_tag_open'] = '<li class="active"><a href="#">';
			$config['cur_tag_close'] = '</a></li>';
			$config['num_tag_open'] = '<li>';
			$config['num_tag_close'] = '</li>';
			$this->pagination->initialize($config);
			$links = $this->pagination->create_links();
			$items = $this->item->get_all($conditions,0,$offset,$config['per_page']);
			if(empty($items)){
				$this->message->set($this->lang->line('no-items-found'),'i');
			}
			#manufactures name
			$this->load->model('products/Manufacture_model','manu');
			$this->load->library('Dms');
			$manus = $this->manu->listing();
			$manus['all'] = 'All';			
			ksort($manus);
    
                        $this->load->library('Stock');
                        $args['select'] = array('id','item_code','item_name');
		        $itms = $this->stock->get_stock_items($args);
                        $itms['all'] = 'All';			
			ksort($itms);

			$this->template->slice('dms/message');
			$this->template->slice('products/report/report',array('items'=>$items,'links'=>$links,'count'=>$offset+1,'manus'=>$manus,'manu'=>$manu,'itms'=>$itms,'itm'=>$itm));
			$this->template->slice('dms/modals/more_details');
			$this->template->slice('dms/modals/delete_confirm');
			$this->template->other_script('products/more_details');
			$this->template->render();
		}
		
		
		public function searchnew()
		{
		    $this->template->title($this->lang->line('search-product'));
			$this->template->main_heading($this->lang->line('search-product'));
			$this->template->breadcrumb(array($this->lang->line('products')=>'products/add',$this->lang->line('report')=>'products/report'));
			$this->template->slice('products/search/search');
			$this->template->other_script('products/search');
			$this->template->render();
		}

		#------------------------------------------------
		public function search(){
		   $items='';$links='';
		   $this->form_validation->set_rules('skey','lang:product name','required');
		 if($this->form_validation->run() === true || $this->uri->segment(3) == 'skey')
            {   
		 $skey = ($this->input->post('skey'))?$this->input->post('skey',true):$this->uri->segment(4);
		//$skey = $this->input->get('skey');
        
		$this->load->library('Stock');
		$this->load->library('Pagination');
		$config['per_page'] = 15;
		$items1 = $this->stock->get_search_items($skey);
		$config['total_rows'] = count($items1);
		$config['base_url'] = base_url('products/search/skey/'.$skey);
		$config['uri_segment'] = 5;
		# Pagination Config Customizations
        $config['full_tag_open'] = '<ul class="pagination">';
        $config['full_tag_close'] = '</ul>';
        $config['first_link'] = 'First';
        $config['last_link'] = 'Last';
        $config['next_link'] = '&raquo;';
        $config['prev_link'] = '&laquo;';
        $config['cur_tag_open'] = '<li class="active"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
		$this->pagination->initialize($config);
		$links = $this->pagination->create_links();
		$offset = ($this->uri->segment(5))?$this->uri->segment(5):0;
		$items = $this->stock->get_search_items_per($skey,$offset,$config['per_page']);
            }
	    $this->template->title($this->lang->line('search-product'));
		$this->template->main_heading($this->lang->line('search-product'));
		$this->template->breadcrumb(array($this->lang->line('products')=>'products/add',$this->lang->line('report')=>'products/report'));
	    $this->template->slice('products/search/search_new',array('items'=>$items,'links'=>$links,'count'=>$offset+1,'skey'=>$skey)); 
		$this->template->render();    
		}
		
		
		#------------------------------------------------

		#date : 11-6-2014
		#purpose : view all item types - item_type_master
		public function item_types(){

			$this->template->title($this->lang->line('item-types'));
			$this->template->main_heading($this->lang->line('item-types'));
			$this->template->breadcrumb(array($this->lang->line('settings')=>'preferences/index',$this->lang->line('item-types')=>'products/add_item_type',$this->lang->line('report')=>'no_link'));
			#get items for this 'fiscal year'
			$this->load->model('products/Item_model','item');
			$this->load->library('Dms');

			$this->load->library('Pagination');
			$config['total_rows'] = $this->item->get_item_types('',1);
			$config['per_page'] = $this->per_page();
			$config['base_url'] = base_url('products/item_types');
			# Pagination Config Customizations
			$config['full_tag_open'] = '<ul class="pagination">';
			$config['full_tag_close'] = '</ul>';
			$config['first_link'] = 'First';
			$config['last_link'] = 'Last';
			$config['next_link'] = '&raquo;';
			$config['prev_link'] = '&laquo;';
			$config['cur_tag_open'] = '<li class="active"><a href="#">';
			$config['cur_tag_close'] = '</a></li>';
			$config['num_tag_open'] = '<li>';
			$config['num_tag_close'] = '</li>';
			$this->pagination->initialize($config);
			$links = $this->pagination->create_links();
			$offset = ($this->uri->segment(3))?$this->uri->segment(3):0;

			$item_types = $this->item->get_item_types('',0,$offset,$config['per_page']);
			
			if(empty($item_types)){
				$this->message->set($this->lang->line('no-result-found'),'i');
			}
			$this->template->slice('dms/message');
			$this->template->slice('preferences/products/item-types/report',array('item_types'=>$item_types,'count'=>$offset,'links'=>$links));
			$this->template->render();
		}

		#------------------------------------------------
		#date : 23-6-2014
		#purpose : add item type
		public function add_item_type(){

			$this->template->title($this->lang->line('item-types'));
			$this->template->main_heading($this->lang->line('item-types'));
			$this->template->breadcrumb(array($this->lang->line('settings')=>'preferences/index',$this->lang->line('item-types')=>'no_link',$this->lang->line('report')=>'products/item_types'));
			$this->form_validation->set_rules('item_type','lang:item','trim|xss_clean|required|is_unique[item_type_master.item_type]');
			
			if($this->form_validation->run() === true){
				
				$this->load->library('Dms');
				$data = $this->input->post(NULL,true);	
				$data['company_id'] = $this->session->userdata('company_id');
				$data['created_by'] = $this->session->userdata('id');
				#getting fiscal year
				$fiscal_yr_id = $this->dms->get_default_fiscal_id();
				$data['fiscal_yr_id'] = $fiscal_yr_id;
				$data['default_data'] = 1;

				#save the manufacture data.
				if($this->db->insert('item_type_master',$data)){
					$this->message->set($this->lang->line('item-group-saved'));
				}else{
					$this->message->set($this->lang->line('item-group-not-saved'),'e');
				}
				redirect('products/item_types');
			}
			$this->template->slice('dms/message');
			$this->template->slice('preferences/products/item-types/new');
			$this->template->render();
		}
	
		#------------------------------------------------	
	
		#date : 11-6-2014
		#purpose : update product item details
		public function update(){

			if(!$this->uri->segment(3)){
				redirect('users/home');
			}
			$item_id = $this->uri->segment(3);
			if($this->if_exists('item_master',array('id'=>$item_id,'status'=>1)) === false){
				redirect('products/report');
			}
			$this->load->model('products/Item_model','item');
			$this->load->model('products/Unit_model','unit');
			$this->load->model('products/Manufacture_model','manu');
			$this->load->library('Stock');
			$alt_units = $this->stock->get_units($item_id);
			$alt_units[0] = 'Select';

			$total_stocks = $this->db->select('id')->get_where('dms_stocks',array('item_id'=>$item_id,'status'=>1))->num_rows();
			#validation rules
			$this->form_validation->set_rules('item_code','lang:item-code','required|trim|xss_clean|is_edit_unique[item_master.item_code]');
			$this->form_validation->set_rules('item_name','lang:item-name','required|trim|xss_clean|is_edit_unique[item_master.item_name]');
			$this->form_validation->set_rules('item_group_id','lang:item-type','required|trim|xss_clean');
			$this->form_validation->set_rules('item_manufacturer_id','lang:manufacturer-name','required|trim|xss_clean');
			$this->form_validation->set_rules('unit_id','lang:unit','required|trim|xss_clean');
			$this->form_validation->set_rules('alt_unit_id','lang:alternate-unit','trim|xss_clean|callback_check_alternative_unit');
			$this->form_validation->set_rules('unit_conversion','lang:conversion','trim|xss_clean');
			$this->form_validation->set_rules('alt_unit_conversion','lang:conversion','trim|xss_clean');
			$this->form_validation->set_rules('commodity_code','lang:commodity-code','trim|xss_clean');
			$this->form_validation->set_rules('stock_type','lang:commodity-code','trim|xss_clean');
			if(!empty($this->input->post('unit_id'))){
				$alt_units = $this->stock->get_units($this->input->post('unit_id'),1);
				$alt_units[0] = 'Select';
				ksort($alt_units);
				if($this->input->post('alt_unit_id') > 1){
					$this->form_validation->set_rules('unit_conversion','lang:conversion','required|trim|xss_clean|greater_than[0]');
					$this->form_validation->set_rules('alt_unit_conversion','lang:conversion','required|trim|xss_clean|greater_than[0]');
				}
			}

			if($this->form_validation->run() === TRUE){
				$data = $this->input->post(NULL,TRUE);
				if(empty($data['alt_unit_id']) && $data['alt_unit_id']==0){
					$data['alt_unit_id'] = 0;
					$data['unit_conversion']=0;
					$data['alt_unit_conversion']=0;
				}
				if(!empty($total_stocks)){
					unset($data['unit_id']);
				}
				if($this->item->my_update('item_master',$data,array('id'=>$item_id))){
					$this->message->set($this->lang->line('product-details-updated'));
				}else{
					$this->message->set($this->lang->line('product-details-not-updated'));
				}
				redirect('products/report');
			}

			#get product item details item_master
			$item = $this->item->get_all(array('item.id'=>$item_id))[0];
			$units = $this->unit->listing();

			#get alternate units

			$sec_unit = $this->lang->line('unit');
			$first_unit = $this->lang->line('unit');
			if(! $this->input->post(NULL,TRUE)){
				if((!empty($item['alt_unit_id'])) && ($item['alt_unit_id'] !=0)){
					
					$alt_id = $item['alt_unit_id'];
					$unit_id =$item['unit_id'];		
					$sec_unit = $alt_units[$alt_id];
					$first_unit = $units[$unit_id];
				} 
			}
			#load item_model
			#get all units
			ksort($alt_units);
			if(!empty($this->input->post('alt_unit_id'))){

				$alt_units = $this->stock->get_units($this->input->post('unit_id'),1);
				$alt_units[0] = 'Select';
				ksort($alt_units);
				$alt_id = $this->input->post('alt_unit_id');
				if(array_key_exists($alt_id,$alt_units)){
					$sec_unit = $alt_units[$alt_id];
				}
				$unit_id = $this->input->post('unit_id');
				if(array_key_exists($unit_id,$units)){
					$first_unit = $units[$unit_id];
				} 	
			}
			#manufature listing
			$manus = $this->manu->listing();
			$manus[''] = 'Select';
			ksort($manus);
			#item group listing
			$item_groups = $this->item->item_group_listing();
			$item_groups['']  = 'select';
			ksort($item_groups);
			#template
			$this->template->title($this->lang->line('manage-products'));
			$this->template->main_heading($this->lang->line('manage-products'));
			$this->template->breadcrumb(array($this->lang->line('products')=>'products/add',$this->lang->line('update')=>'no_link',$this->lang->line('report')=>'products/report'));
			$this->template->slice('dms/message');
			$this->template->slice('products/update/update',array('item'=>$item,'units'=>$units,'alt_units'=>$alt_units,'manus'=>$manus,'groups'=>$item_groups,'sec_unit'=>$sec_unit,'first_unit'=>$first_unit,'total_stocks'=>$total_stocks));
			$this->template->other_script('products/autocomplete_item_manu');
			
			$this->template->render();
		}

		#------------------------------------------------
		#date : 23-6-2014
		#purpose : delete item details
		public function delete($id){

			if(empty($id) || !$this->uri->segment(3)){
				rediect('products/report');
			}
			$id = $this->uri->segment(3);
			if($this->if_exists('item_master',array('id'=>$id,'status'=>1)) === false){
				redirect('products/report');
			}
			
			$total_stocks = $this->db->select('id')->get_where('dms_stocks',array('item_id'=>$id,'status'=>1))->num_rows();
			$total_rates = $this->db->select('id')->get_where('dms_item_rates',array('item_id'=>$id,'status'=>1))->num_rows();

			if(empty($total_stocks) && empty($total_rates)){
				if($this->db->update('item_master',array('status'=>0),array('id'=>$id))){
					$this->message->set($this->lang->line('product-deleted'));
				}else{
					$this->message->set($this->lang->line('product-not-deleted'),'e');
				}
			}else{
				$this->message->set($this->lang->line('can-not-delete-product'),'i');
			}
			redirect('products/report');
		}
	
		#------------------------------------------------
	
		#date : 11-6-2014
		#purpose : view all manufactureres - item_manufacturer_master
		public function mans(){

			$this->template->title($this->lang->line('manufacturers'));
			$this->template->main_heading($this->lang->line('manufacturers'));
			$this->template->breadcrumb(array($this->lang->line('settings')=>'preferences/index',$this->lang->line('vendor')=>'products/add_mans',$this->lang->line('report')=>'no_link'));
			#get items for this 'fiscal year'
			$this->load->model('products/Item_model','item');
			$this->load->library('Dms');
			$this->load->library('Pagination');
			$config['total_rows'] = $this->item->get_manus('',1);
			$config['per_page'] = $this->per_page();
			$config['base_url'] = base_url('products/mans');
			# Pagination Config Customizations
			$config['full_tag_open'] = '<ul class="pagination">';
			$config['full_tag_close'] = '</ul>';
			$config['first_link'] = 'First';
			$config['last_link'] = 'Last';
			$config['next_link'] = '&raquo;';
			$config['prev_link'] = '&laquo;';
			$config['cur_tag_open'] = '<li class="active"><a href="#">';
			$config['cur_tag_close'] = '</a></li>';
			$config['num_tag_open'] = '<li>';
			$config['num_tag_close'] = '</li>';
			$this->pagination->initialize($config);
			$offset = ($this->uri->segment(3))?$this->uri->segment(3):0;
			$item_types = $this->item->get_manus('',0,$offset,$config['per_page']);
			if(empty($item_types)){
				$this->message->set($this->lang->line('no-result-found'),'i');
			}
			$links = $this->pagination->create_links();
			$this->template->slice('dms/message');
			$this->template->slice('preferences/products/manufacturers/report',array('item_types'=>$item_types,'links'=>$links,'count'=>$offset));
			$this->template->slice('dms/modals/delete_confirm');
			$this->template->render();
		}

		#------------------------------------------------

		#date : 23-6-2014
		#purpose : add new manufactureres - item_manufacturer_master
		public function add_mans(){

			$this->template->title($this->lang->line('manufacturers'));
			$this->template->main_heading($this->lang->line('manufacturers'));
			$this->template->breadcrumb(array($this->lang->line('settings')=>'preferences/index',$this->lang->line('vendor')=>'no_link',$this->lang->line('report')=>'products/mans'));
			$this->form_validation->set_rules('manufacturer_name','lang:name','trim|xss_clean|required|callback_does_exist');
			$this->form_validation->set_rules('phone','lang:phone','trim|xss_clean|numeric');
			$this->form_validation->set_rules('mobile_no','lang:mobile','trim|xss_clean|is_natural|exact_length[10]|is_unique[item_manufacturer_master.mobile_no]');
			$this->form_validation->set_rules('manufacturer_email','lang:email','valid_email');
			$this->form_validation->set_rules('address','lang:addressl','trim|xss_clean');
			$this->form_validation->set_rules('tin_no','lang:tin-no','trim|xss_clean');
			$this->form_validation->set_rules('open_amount','lang:opening-blance','greater_than|trim|xss_clean');
			$this->form_validation->set_rules('dc_type','lang:dc','trim|xss_clean');

			if($this->form_validation->run() === true){
				
				$this->load->library('Dms');
				$data = $this->input->post(NULL,true);
				$open_amount = $this->input->post('open_amount',TRUE);
				$dc_type =  $this->input->post('dc_type',TRUE);
				$data['company_id'] = $this->session->userdata('company_id');
				$data['created_by'] = $this->session->userdata('id');

				#getting fiscal year
				$fiscal_yr_id = $this->dms->get_default_fiscal_id();
				$data['fiscal_yr_id'] = $fiscal_yr_id;

				$this->load->model('accounts/Ledger_model','ledger');
				#definfing ledger saving ledger data

				$ledger['company_id'] = $this->session->userdata('company_id');
				$ledger['ledger_name'] = $data['manufacturer_name'].'-'.$data['mobile_no'];
				$ledger['branch_id'] = $this->session->userdata('under_id');
				$ledger['sgroup_id'] = 23;
				$ledger['dc'] = $this->ledger->get_dc($ledger['sgroup_id']);
				$last_insert_id = $this->ledger->insert('dms_ledgers',$ledger);
				$open['ledger_id'] = $last_insert_id ;
				$data['ledger_id'] = $last_insert_id ;
				if(!empty($open_amount)){
					if($dc_type != $ledger['dc']){
						$open['open_amount'] = -$open_amount;
					}else{
						$open['open_amount'] = $open_amount;
					}
					$open['company_id'] = $this->session->userdata('company_id');
					$open['branch_id'] = $this->session->userdata('under_id');
					$open['open_date'] = $this->dms->get_fiscal_year()['start_date'];
					$this->ledger->insert('dms_ledger_open_bals',$open);
				}
				unset($data['open_amount']);unset($data['dc_type']);

				#save the manufacture data.
				if($this->db->insert('item_manufacturer_master',$data)){
					$this->message->set($this->lang->line('vendors_save_msg'));
				}else{
					$this->message->set($this->lang->line('vendors_save_err_msg'),'e');
				}
				redirect('products/mans');
			}
			$dc_array = array('cr' => 'Cr','dr' => 'Dr');
			$this->template->slice('dms/message');
			$this->template->slice('preferences/products/manufacturers/new',array('dc_array'=>$dc_array));
			$this->template->render();
		
		}

		#--------------------------------------------------------	
		#date : 19-6-2014
		#use :  callback validation for manufacture
		
		public function does_exist($manufacturer_name){
		
			$row = $this->db->get_where('item_manufacturer_master',array('company_id'=>$this->session->userdata('company_id'),'manufacturer_name'=>$manufacturer_name,'status'=>1))->row_array();
			if(!empty($row)){
				$this->form_validation->set_message('does_exist',$this->lang->line('vendor-already-exists'));
				return FALSE;
			}else{
				return TRUE;
			}		
		}

		#------------------------------------------------	
		#delete_mans
		#date : 23-6-2014
		#use :  delete manufacture
		
		public function delete_mans($id){
			if(empty($id)){
				rediect('products/mans');
			}
			$id = $this->uri->segment(3);
			$vendors = $this->db->get_where('item_manufacturer_master',array('id'=>$id,'status'=>1))->row_array();
			if(empty($vendors)){
				redirect('products/mans');
			}
			$ledgerID = $vendors['ledger_id'];

			$total_vouchers = $this->db->select('id')->from('dms_vouchers')->where(array('status !='=>0,'dr_ledger'=>$ledgerID))->or_where('cr_ledger',$ledgerID)->get()->num_rows();
			$total_pos = $this->db->select('id')->get_where('dms_purchase_orders',array('vendor_id'=>$id,'status !='=>0))->num_rows();
			$total_po_temps = $this->db->select('id')->get_where('dms_purchase_order_temp',array('vendor_id'=>$id))->num_rows();
			$total_purchases = $this->db->select('id')->get_where('dms_purchases',array('vendor_id'=>$id,'status !='=>0))->num_rows();
			$total_preturns = $this->db->select('id')->get_where('dms_purchase_returns',array('vendor_id'=>$id,'status !='=>0))->num_rows();
			$total_rnotes = $this->db->select('id')->get_where('dms_receipt_notes',array('vendor_id'=>$id,'status !='=>0))->num_rows();
			$total_rej_outs = $this->db->select('id')->get_where('dms_rejection_outs',array('vendor_id'=>$id,'status !='=>0))->num_rows();
			$total_vreceipts = $this->db->select('id')->get_where('dms_voucher_against_bills',array('customer_type_id'=>0,'customer_id'=>$id,'status !='=>0))->num_rows();
			
			if(empty($total_po_temps) && empty($total_pos) && empty($total_preturns) && empty($total_purchases) && empty($total_rej_outs) && empty($total_rnotes) && empty($total_vouchers) && empty($total_vreceipts)){
			
				if($this->db->update('item_manufacturer_master',array('status'=>0),array('id'=>$id))){
					$this->db->update('dms_ledgers',array('status'=>0),array('id'=>$ledgerID));
					$this->db->update('dms_ledger_open_bals',array('status'=>0),array('ledger_id'=>$ledgerID));
					$this->message->set($this->lang->line('vendor-deleted'));
				}else{
					$this->message->set($this->lang->line('vendor-not-deleted'));
				}
			}else{
				$this->message->set($this->lang->line('can-not-delete-vendor'),'i');
			}
			redirect('products/mans');
		}
	
		#------------------------------------------------	
		#update_mans
		#date : 23-6-2014
		#use :  update  manufacture 
		
		public function update_mans($id){

			if(empty($id) && !$this->input->post()){
				redirect('products/mans');
			}
			$manu_id = $this->uri->segment(3);
			#get details of id
			$manf= $this->db->get_where('item_manufacturer_master',array('id'=>$manu_id))->row_array();
			if(empty($manf)){
				redirect('products/mans');
			}
			$this->load->model('products/Manufacture_model','manu');
			$this->load->model('accounts/Ledger_model','ledger');
			$open_bal = array();
			if($manf['ledger_id'] !=0){
				$open_bal = $this->manu->open_balance($manf['ledger_id']);
			}
			#validation
			$this->form_validation->set_rules('manufacturer_name','manufacturer name','trim|xss_clean|required|is_edit_unique[item_manufacturer_master.manufacturer_name]');
			$this->form_validation->set_rules('phone','lang:phone','trim|xss_clean|numeric');
			$this->form_validation->set_rules('mobile_no','lang:mobile','required|trim|xss_clean|is_natural|exact_length[10]|is_edit_unique[item_manufacturer_master.mobile_no]');
			$this->form_validation->set_rules('manufacturer_email','lang:email','valid_email');
			$this->form_validation->set_rules('address','lang:addressl','trim|xss_clean');
			$this->form_validation->set_rules('tin_no','lang:tin-no','trim|xss_clean');
			$this->form_validation->set_rules('cst_no','lang:cst-no','trim|xss_clean');
			$this->form_validation->set_rules('pan_no','lang:pan-no','trim|xss_clean');
			$this->form_validation->set_rules('open_amount','lang:opening-blance','greater_than|trim|xss_clean');
			$this->form_validation->set_rules('dc_type','lang:dc','trim|xss_clean');
			
			if($this->form_validation->run() === true){
				
				$data = $this->input->post(NULL,true);
				$open_amount = $this->input->post('open_amount',TRUE);
				$dc_type =  $this->input->post('dc_type',TRUE);

				#------------------------updation of open_balalance------------------------------------------------
				if($this->input->post('open_id',TRUE)){

					if($open_amount != 0){

						$ledger['ledger_name'] = $data['manufacturer_name'].'-'.$data['mobile_no'];
						$ledger['sgroup_id'] = 23;
						$ledger['dc'] = $this->ledger->get_dc($ledger['sgroup_id']);
						$this->ledger->update(array('table'=>'dms_ledgers','data'=>$ledger,'conditions'=>array('id'=>$data['ledger_id'])));
						if($dc_type != $ledger['dc']){
							$open['open_amount'] = -$open_amount;
						}else{
							$open['open_amount'] = $open_amount;
						}
						$this->ledger->update(array('table'=>'dms_ledger_open_bals','data'=>$open,'conditions'=>array('id'=>$data['open_id'],'ledger_id'=>$data['ledger_id'])));

					}else{
						#checking vat is set to open balence
						if($open_bal['vat'] == 1){
							$ledger['ledger_name'] = $data['manufacturer_name'].'-'.$data['mobile_no'];
							$ledger['sgroup_id'] = 23;
							$ledger['dc'] = $this->ledger->get_dc($ledger['sgroup_id']);
							$this->ledger->update(array('table'=>'dms_ledgers','data'=>$ledger,'conditions'=>array('id'=>$data['ledger_id'])));
							$open['open_amount'] = 0;
							$this->ledger->update(array('table'=>'dms_ledger_open_bals','data'=>$open,'conditions'=>array('id'=>$data['open_id'],'ledger_id'=>$data['ledger_id'])));
						}else{
						
							#delete dms_open_balance data 
							$this->manu->my_update('dms_ledger_open_bals',array('status'=>0),array('id'=>$data['open_id'],'ledger_id'=>$data['ledger_id']));
						}
					}
					unset($data['open_id']);
					unset($data['ledger_id']);

				}else{
					#------------------------updation of open_balalance------------------------------------------------					
					$ledger['ledger_name'] = $data['manufacturer_name'].'-'.$data['mobile_no'];
					$ledger['sgroup_id'] = 23;
					$ledger['dc'] = $this->ledger->get_dc($ledger['sgroup_id']);
					$this->ledger->update(array('table'=>'dms_ledgers','data'=>$ledger,'conditions'=>array('id'=>$data['ledger_id'])));
						
					if(!empty($open_amount)){
						if($dc_type != $ledger['dc']){
							$open['open_amount'] = -$open_amount;
						}else{
							$open['open_amount'] = $open_amount;
						}
						$open['ledger_id'] = $data['ledger_id'];
						$open['company_id'] = $this->session->userdata('company_id');
						$open['branch_id'] = $this->session->userdata('under_id');
						$open['open_date'] = $this->dms->get_fiscal_year()['start_date'];
						$this->ledger->insert('dms_ledger_open_bals',$open);
					}
					unset($data['ledger_id']);
				}	
			
				$data['created_by'] = $this->session->userdata('id');
				unset($data['open_amount']);unset($data['dc_type']);
				#update the manufacture data.
				if($this->db->update('item_manufacturer_master',$data,array('id'=>$id))){
					$this->message->set($this->lang->line('vendor-update'));
				}else{
					$this->message->set($this->lang->line('vendor-update-err'),'e');
				}
				redirect('products/mans');

			}
			$dc_array = array('cr' => 'Cr','dr' => 'Dr');
			$this->template->title($this->lang->line('manufacturers'));
			$this->template->main_heading($this->lang->line('manufacturers'));
			$this->template->breadcrumb(array($this->lang->line('settings')=>'preferences/index',$this->lang->line('vendor')=>'products/add_mans',$this->lang->line('update')=>'no_link',$this->lang->line('report')=>'products/mans'));
			$this->template->slice('dms/message');
			$this->template->slice('preferences/products/manufacturers/update',array('manf'=>$manf,'open_bal'=>$open_bal,'dc_array'=>$dc_array));
			$this->template->render();
		
		}
		
		#--------------------------------------------------------
		#:date:14/07/2014
		#purpose: edit item_type_mster
		public function update_item_type(){

			if(!$this->uri->segment(3)){ 
				redirect('products/item_types');
			}
			$item_type_id = $this->uri->segment(3);
			#get item types detasild
			$item_types = $this->db->select(array('item_type','hsn'))->get_where('item_type_master',array('id'=>$item_type_id))->row_array();
			if(empty($item_types)){
				redirect('products/item_types');
			}
			#set validation
			$this->form_validation->set_rules('item_type','lang:item','trim|xss_clean|required|is_edit_unique[item_type_master.item_type]');
			if($this->form_validation->run() === true){

				$data = $this->input->post(NULL,TRUE);
				$data['company_id'] = $this->session->userdata('company_id');
				$data['created_by'] = $this->session->userdata('id');
				if($this->db->update('item_type_master',$data,array('id'=>$item_type_id))){
					$this->message->set($this->lang->line('item-group-updated'));
				}else{
					$this->message->set($this->lang->line('item-group-not-updated'),'e');	
				}
				redirect('products/item_types');
			}
			#template
			$this->template->title($this->lang->line('item-types'));
			$this->template->main_heading($this->lang->line('item-types'));
			$this->template->breadcrumb(array($this->lang->line('settings')=>'preferences/index',$this->lang->line('item-types')=>'products/add_item_type',$this->lang->line('update')=>'no_link',$this->lang->line('report')=>'products/item_types'));
			$this->template->slice('preferences/products/item-types/update',array('item_types'=>$item_types));
			$this->template->render();

		}

		#--------------------------------------------------------
		#date:10-07-2014
		#purpose: delete item types
		public function delete_item_type(){

			if(!$this->uri->segment(3)){ redirect('products/item_types'); }
			$item_type_id = $this->uri->segment(3);
			$item_types = $this->db->select('item_type')->get_where('item_type_master',array('id'=>$item_type_id))->row_array();
			if(empty($item_types)){
				redirect('products/item_types');
			}
			
			$total_items = $this->db->select('id')->get_where('item_master',array('item_group_id'=>$item_type_id,'status'=>1))->num_rows();		
			if(empty($total_items)){	
				if($this->db->update('item_type_master',array('status'=>0),array('id'=>$item_type_id))){
					$this->message->set($this->lang->line('item-group-deleted'));
				}else{
					$this->message->set($this->lang->line('item-group-not-deleted'));
				}
			}else{
				$this->message->set($this->lang->line('can-not-delete-item-type'));
			}
			redirect('products/item_types');
		}

		#--------------------------------------------------------
		
	}
?>