<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

class Purchase extends MY_Controller{

	public function __construct()
	{
		parent::__construct();

		$this->check_access_right();
		$this->userID = $this->session->userdata('id');
        $this->companyID = $this->session->userdata('company_id');
        $this->branchID = $this->session->userdata('under_id');
		#---------------- Checking Financial year is enabled / closed-----------------#
		$method_array = array('add','delete_temp','update_temp','update','delete');
		fiscal_status($this->uri->segment(2),$method_array,"purchase/report");              
		#---------------- Checking Financial year is enabled / closed-----------------#

		$this->load->model('purchase/Purchase_model','purchase_obj');
		$this->load->model('vouchers/Voucher_model','vouchers');
		$this->load->model('products/Item_model','item');
		$this->load->library(array('Stock','My_excel'));
		$this->load->model('branches/Branch_model','brch');
		#----------voucher type
		$this->vtype = 5;
		
		$flag=0;
	}

	public function add()
	{
		#----------voucher type
		$vtype_id = $this->vtype;

		#----------voucher type array
		$voucher_types = $this->vouchers->voucher_types($this->vtype);

		#----------voucher name
		$voucher_name = $this->vouchers->voucher_name($this->vtype);

		#-----------purchase cst checking details
		$purchase_cst = $this->stock->get_constant(array('purchase_cst'));

		#------------presumptive tax checking
		$presumptive_tax = $this->stock->get_tax_type();

		#------------cess %
		$cess = $this->stock->get_cess();
		
		#------------default Godown
		$godown = $this->stock->get_branch_godown($this->branchID);

		#-----------purchase date and next bill no
		$rules = "callback_bill_no_exists";
		$disabled = "";
		$result_array = $this->purchase_obj->next_bill_no($this->vtype);
		$vtype_id = $result_array['vtype_id'];
		$voucher_no = $result_array['bill_no'];
		$voucher_date = $result_array['bill_date'];
		if($result_array['vstatus'])
		{
			#-----------redirection if purchase_order / receipt_note / purchase_request conversion is pending
			if($result_array['p_status'] == 2)
			{
				redirect("order_to_purchase/po_purchase/".$result_array['pid']);
			}
			/*elseif($result_array['p_status'] == 3){
				redirect("receipt_to_purchase/purchase/".$result_array['pid']);
			}*/
			elseif($result_array['p_status'] == 4)
			{
				$this->message->set($this->lang->line('pending-purchase-exists'),'e');
				redirect("sales_to_purchase/add");
			}
			$group_id = $result_array['group_id'];
			$voucher_details = $this->dms->get_data(array('table' => 'dms_vouchers as a','join' => array('table' => 'dms_purchases as b','on' => 'a.table_group_id = b.group_id'),'columns' => 'b.id','conditions' => array('a.table_name' => 'dms_purchases','a.table_group_id' => $group_id)));
		/*	if(!empty($voucher_details)){
				redirect("purchase/update/id/".$voucher_details[0]['id']);
			} */
			$disabled = "readonly";
			$rules = "callback_bill_no_exists[$vtype_id.$group_id]";

			#------------checking cst enabled or not
		    /*$cst_status = $this->purchase_obj->get_cst($group_id);*/
		    $cst_status = 0;
			if($cst_status)
			{
				$purchase_cst = $cst_status;
			}
		}
		else
		{
			$group_id = $this->stock->get_group_id('dms_purchase_items1');
		}

        $branchs_id = $this->session->userdata('under_id');

        $previous_status = $this->brch->get_previous_status($branchs_id);
		#-------------adding data to purchase temp
		if(isset($_POST['btn_add']))
		{
			#-----------validation
			$this->form_validation->set_rules('vtype_id','lang:voucher-types','required|xss_clean');
			$this->form_validation->set_rules('purchase[bill_no]','lang:bill-no',"required|xss_clean|is_natural_no_zero|".$rules);
			$this->form_validation->set_rules('purchase[bill_date]','lang:bill-date','required|xss_clean|valid_date');
			$this->form_validation->set_rules('purchase[invoice_no]','lang:invoice-no','required|xss_clean');
			$this->form_validation->set_rules('purchase[invoice_date]','lang:invoice-date','required|xss_clean|is_date');
			$this->form_validation->set_rules('purchase[vendor_id]','lang:vendor','required|xss_clean');
			if(isset($_POST['newp'])) 
            { 
                $this->form_validation->set_rules('new_item[item_group_id]','lang:item-type','required|xss_clean');
                $this->form_validation->set_rules('new_item[item_code]','lang:item-code','required|xss_clean|is_unique[item_master.item_code]');
                $this->form_validation->set_rules('new_item[item_name]','lang:item-name','required|xss_clean');
            }
            else
            {
			    $this->form_validation->set_rules('item_id','lang:item-name','required|xss_clean');
            }
			//$this->form_validation->set_rules('cst','lang:cst','xss_clean|greater_or_equal[0]|less_or_equal[100]');
			$this->form_validation->set_rules('qty','lang:quantity','required|xss_clean|greater_than[0]|less_than[100000000]');
			$this->form_validation->set_rules('rate','lang:rate','required|xss_clean|greater_or_equal[0]|less_than[100000000]');
			$this->form_validation->set_rules('amount','lang:amount','xss_clean|required|greater_or_equal[0]|less_than[100000000]');
			$this->form_validation->set_rules('discount_per','lang:discount %','xss_clean|greater_than[0]|less_or_equal[100]');
			$this->form_validation->set_rules('discount_amt','lang:discount','xss_clean|greater_or_equal[0]|less_than[100000000]');

			#-----------adding temporary data
			if($this->form_validation->run('btn_add') === true)
			{
				$item_array = $this->input->post(NULL,true);
				$new_item = $this->input->post('new_item',true);
                $sal_tem =  $this->input->post('purchase',true);
                        
                if(isset($_POST['newp'])) 
                {                               
                    $new_stats = 1;
                    $new_item_details = array();
                    $new_item_details['company_id']=$this->companyID;
                    $new_item_details['item_group_id']=$new_item['item_group_id'];
                    $new_item_details['item_manufacturer_id'] = $sal_tem['vendor_id'];
                    $new_item_details['item_code'] = $new_item['item_code'];
                    $new_item_details['item_name'] = $new_item['item_name'];
                    $new_item_details['model_no'] = $new_item['model_no'];
                    $new_it = $this->db->select(array('name'))->from('item_types')->where('group_id',$new_item['item_group_id'])->get()->row_array();                                
                    $new_item_details['item_types'] = strtolower($new_it['name']);
                    $tp = $new_item_details['item_types'];
                    $cd = $new_item_details['item_code'];
                    if($tp=='aframe' || $tp=='alens')
        			{
        			    $new_item_details['code_id'] = substr($cd,3);
        			}
        			else if($tp=='contact' || $tp=='solution' || $tp=='oframe' || $tp=='olens')
        			{
        			    $new_item_details['code_id'] = substr($cd,2);
        			}
    			    else
    			    {
    			        $new_item_details['code_id'] = substr($cd,1);
    			    }
                    
                    $new_item_details['unit_id'] = 1;
                    $new_item_details['hsn'] = $new_item['hsn'];
                    $new_item_details['stock_type'] = 1;
                    $new_item_details['status'] = 1;

                    $item_check = $this->db->select(array('id'))->from('item_master')->where('item_code',$new_item_details['item_code'])->get()->row_array();          
                    if(empty($item_check))
                    {
                        $new_item_id = $this->purchase_obj->insert("item_master",$new_item_details);
                        if($new_item_id)
                        {
                            $new_stock = array();
                            $new_stock['company_id'] = $this->companyID;
                            $new_stock['branch_id'] = $this->session->userdata('under_id');
                            $new_stock['godown_id'] = $godown;
                            $new_stock['item_id'] = $new_item_id;
                            $new_stock['qty']=0;
                            $new_stock['unit_id'] = 1;
                            $new_stock['rate'] = 0;
                            $new_stock['stock_date'] = $this->dms->get_fiscal_year()['start_date'];
                            $new_stock['status'] = 1;
                            $this->purchase_obj->insert("dms_stocks",$new_stock);
                            
                             #---------------------------------------item stock----------------------------------#
                            $new_itmstk = array();
                            $new_itmstk['company_id'] =  $this->companyID;
                            $new_itmstk['branch_id'] =   $this->session->userdata('under_id');
                            $new_itmstk['item_id'] = $new_item_id;
                            $new_itmstk['godown_id'] = $godown;
                            $new_itmstk['qty'] = 0;
                            $new_itmstk['unit_id'] = 1;
                            $this->purchase_obj->insert("item_stock",$new_itmstk);
                            #-----------------------------------------------------------------------------------#
                        }
                        $item_array['item_id'] = $new_item_id;
                    }
                    else
                    {
                        $item_array['item_id'] = $item_check['id'];
                    }
                }
                
                $mrp = $item_array['mrp'];
                $rate2 = $item_array['rate2'];
                $lcost = $item_array['rate'];
                if(!empty($mrp))
                {
                    $new_rate = array();
                    $new_rate['company_id'] = $this->companyID;
                    $new_rate['item_id'] = $item_array['item_id'];
                    $new_rate['rate'] = $mrp;
                    $new_rate['rate2'] = $rate2;
                    $new_rate['landing_cost'] = $lcost;
                    $new_rate['valid_from'] = date('Y-m-d');
                    $new_rate['status'] = 1; 
                    $this->purchase_obj->insert("dms_item_rates",$new_rate);
                    $this->purchase_obj->insert("item_rates",$new_rate);
                }

				unset($item_array['purchase']);
				unset($item_array['vtype_id']);
				unset($item_array['btn_add']);
                unset($item_array['new_item']);  
                unset($item_array['newp']);  
                unset($item_array['mrp']);  
                unset($item_array['rate2']);  

                $item_array['unit_id'] = 1;
                $item_array['godown_id'] = $godown;
				$item_array['group_id'] = $group_id;
				$item_array['status'] = -1;
				$item_array['item_status'] = 2;//purchase only items

				$bl_date=$sal_tem['bill_date'];

				$item_array['rate'] = 0;
				if($item_array['qty'] != 0)
				{
					$item_array['rate'] = $item_array['amount'] / $item_array['qty'];
				}
				
				$bl_date = date('Y-m-d',strtotime($sal_tem['bill_date']));
				$purchase_temp_item_result = $this->purchase_obj->get_purchases_gst(array('columns' => array('b.id'),'conditions' => array('b.group_id' => $group_id,'item_id' => $item_array['item_id'],'godown_id' => $item_array['godown_id'],'unit_id' => $item_array['unit_id'],'a.status !=' => 0,'b.status !=' => 0,'b.item_status >' => 0),'numrows' => true));

				if($purchase_temp_item_result == 0)
				{
					if($sal_tem['tax_type'] == '0')
					{
						$cgst=$this->stock->get_item_cgst($item_array['item_id']);
						$sgst=$this->stock->get_item_sgst($item_array['item_id']);
						$item_array['cgst'] = $cgst;
						$item_array['sgst'] = $sgst;
						$item_array['cgst_amt'] = (((float)$item_array['amount']-(float)$item_array['discount_amt']) * (float)$cgst) / 100;
						$item_array['sgst_amt'] = (((float)$item_array['amount']-(float)$item_array['discount_amt']) * (float)$sgst) / 100;
					}
					else
					{
						$igst = $this->stock->get_item_igst($item_array['item_id']);
						$item_array['igst'] = $igst;
						$item_array['igst_amt'] = (((float)$item_array['amount']-(float)$item_array['discount_amt']) * (float)$igst) / 100;      
					}
					
					$this->db->trans_start();

					if($result_array['vstatus'] == 0)//data not in dms_purchases
					{
						$purchase_temp_array = $this->input->post('purchase',true);
						$purchase_temp_array = array_filter($purchase_temp_array);
						$purchase_temp_array['vtype_id'] = $this->input->post('vtype_id',true);
						$purchase_temp_array['branch_id'] = $this->session->userdata('under_id');
						$purchase_temp_array['group_id'] = $group_id;
						$purchase_temp_array['bill_date'] = date('Y-m-d',strtotime($purchase_temp_array['bill_date']));
						$voucher_date = $purchase_temp_array['bill_date'];
						$purchase_temp_array['invoice_date'] = date('Y-m-d',strtotime($purchase_temp_array['invoice_date']));
						$purchase_temp_array['status'] = -1;
						$purchase_temp_array['tax_type'] = $sal_tem['tax_type'];
						
						$this->purchase_obj->insert("dms_purchases",$purchase_temp_array);
					}

					$branch_id = $this->session->userdata('under_id');
                    $godown_id = $this->stock->get_branch_godown($branch_id); 
                     
                    $purchase_items_id = $this->purchase_obj->insert("dms_purchase_items1",$item_array); 
					
					if($purchase_items_id)
					{
						$this->purchase_obj->insert('dms_stocks',array('company_id' => $this->session->userdata('company_id'),'branch_id' => $this->session->userdata('under_id'),'godown_id' => $item_array['godown_id'],'item_id' => $item_array['item_id'],'qty' => $item_array['qty'],'unit_id' => $item_array['unit_id'],'rate' => $item_array['rate'],'amount' => $item_array['amount'],'stock_date' => $voucher_date,'stock_status' => 2,'table_group_id' => $group_id,'table_id' => $purchase_items_id,'status' => -1));
						$this->message->set($this->lang->line('purchase-add-success'));
					}
					else
					{
						$this->message->set($this->lang->line('purchase-add-error'),'e');
					}

					$this->db->trans_complete();
				}
				else
				{
					$this->message->set($this->lang->line('purchase-add-error'),'e');
				}
				redirect('purchase/add');
			}
		}

		if(isset($_POST['btn_save']))
		{
			$this->form_validation->set_rules('payment_mode','lang:payment-mode','required|xss_clean');
			if($this->input->post('payment_mode',true) == 2)
			{
				$this->form_validation->set_rules('credit_period','lang:credit-period','required|xss_clean|is_natural');
			}
			elseif($this->input->post('payment_mode',true) > 2)
			{
				$this->form_validation->set_rules('ccd','lang:transaction-type','required|xss_clean');
				$this->form_validation->set_rules('cd_no','lang:cd-no','required|xss_clean|max_length[64]');
				$this->form_validation->set_rules('cheque_date','lang:cheque-date',"required|xss_clean|is_date|check_date[$voucher_date.>=]");
			}
			$this->form_validation->set_rules('remarks','lang:remarks','xss_clean');
			$this->form_validation->set_rules('freight','lang:freight','xss_clean|greater_or_equal[0]|less_than[100000000]');
			$this->form_validation->set_rules('other_expense','lang:other-expense','xss_clean|greater_or_equal[0]|less_than[100000000]');
			$this->form_validation->set_rules('bill_discount_per','lang:discount %','xss_clean|greater_or_equal[0]|less_or_equal[100]');
			$this->form_validation->set_rules('bill_discount_amt','lang:discount','xss_clean|greater_or_equal[0]|less_than[100000000]');

			if($this->form_validation->run('btn_save') === true)
			{
				$narration = $this->input->post('remarks',true);
				$payment_mode = $this->input->post('payment_mode',true);
				$freight = $this->input->post('freight',true);
				$other_expense = $this->input->post('other_expense',true);
				$bill_discount_amt = $this->input->post('bill_discount_amt',true);
                $cour_charge = $this->input->post('courier_charge',true);
                $cour_gst = $this->input->post('cour_gst_amt',true);

				$purchase_entry_array = array('bill_discount_per' => $this->input->post('bill_discount_per',true),'bill_discount_amt' => $bill_discount_amt,'bill_freight' => $freight,'other_expense' => $other_expense,'cess' => $cess,'courier_charge'=>$cour_charge,'courier_gst'=>$cour_gst,'narration' => $narration,'payment_mode' => $payment_mode,'cr_period' => $this->input->post('credit_period',true),'status' => 1);
                $purchase_entry_check = $this->purchase_obj->get_purchases_gst(array('columns' => array('a.vtype_id','a.bill_no','a.bill_date','a.vendor_id'),'conditions' => array('a.group_id' => $group_id,'a.status !=' => 0,'b.item_status >' => 0)));
                           
				if($purchase_entry_check)
				{
					$bill_date = $purchase_entry_check[0]['bill_date'];
					$vtype_id = $purchase_entry_check[0]['vtype_id'];
					$bill_no = $purchase_entry_check[0]['bill_no'];
					$vendor_id = $purchase_entry_check[0]['vendor_id'];

					$this->db->trans_start();

					if($this->purchase_obj->update(array('table' => 'dms_purchases','data' => $purchase_entry_array,'conditions' => array('group_id' => $group_id))))
					{
                        $this->purchase_obj->update(array('table' => 'dms_purchase_items1','data' => array('status' => 1),'conditions' => array('group_id' => $group_id,'status !=' => 0,'item_status >' => 0)));
                                           
						$voucher_status = 1;
						$voucher_amount = $this->input->post('grand_total',true);
						$round_off_amount = $this->input->post('round_off_amount',true);
						$vat_amount = $this->input->post('vat_total',true);
						$cess_amount = 0;//$this->input->post('cess_total',true);
                        $cour_charge = $this->input->post('tot_cour_amt',true);
						if($payment_mode > 2)
						{
							$bill_date_time = strtotime($bill_date);
							$cheque_date = date('Y-m-d',strtotime($this->input->post('cheque_date',true)));
							$cheque_date_time = strtotime($cheque_date);
							if($this->input->post('ccd',true) == 1 && $cheque_date_time > $bill_date_time)
							{
								$voucher_status = 3;
							}
						}
						elseif($payment_mode == 2)
						{
						/*	if($this->dms->branch_type())
							{*/
								$vendor_ledger_id = $this->dms->get_data(array('table' =>'item_manufacturer_master','columns' => 'ledger_id','conditions' => array('id' => $vendor_id)));
								$payment_mode = $vendor_ledger_id[0]['ledger_id'];
						/*	}
							else
							{
								$vendor_ledger_id = $this->dms->get_data(array('table' =>'branch_master','columns' => 'ledger_id','conditions' => array('id' => $vendor_id)));
								$payment_mode = $vendor_ledger_id[0]['ledger_id'];
							}*/
						}
						$voucher_group_id = $this->stock->get_group_id('dms_vouchers');
						(float)$voucher_amount -= (float)$bill_discount_amt;
						(float)$voucher_amount += (float)$round_off_amount;
						$voucher_array = array('company_id' => $this->session->userdata('company_id'),'branch_id' => $this->session->userdata('under_id'),'group_id' => $voucher_group_id,'vtype_id' => $vtype_id,'vno' => $bill_no,'vorder_no' => 1,'vdate' => $bill_date,'dr_ledger' => 3,'cr_ledger' => $payment_mode,'vamount' => $voucher_amount,'narration' => $narration,'table_name' => 'dms_purchases','table_group_id' => $group_id,'status' => $voucher_status);
						$voucher_data = $this->dms->get_data(array('table' =>'dms_vouchers','columns' => 'id','conditions' => array('table_name' => 'dms_purchases','table_group_id' => $group_id),'numrows' => true));
						if($voucher_data == 0)
						{
						    $voucher_success = $this->purchase_obj->insert('dms_vouchers',$voucher_array);
							if($voucher_success)
							{
								#-----------VAT
								$voucher_array['dr_ledger'] = 11;
								$voucher_array['vorder_no'] = 2;
								$voucher_array['vamount'] = $vat_amount;
								$this->purchase_obj->insert('dms_vouchers',$voucher_array);
								#-----------CESS
								$voucher_array['dr_ledger'] = 15;
								$voucher_array['vorder_no'] = 3;
								$voucher_array['vamount'] = $cess_amount;
								$this->purchase_obj->insert('dms_vouchers',$voucher_array);
								#-----------Freight
								$voucher_array['dr_ledger'] = 13;
								$voucher_array['vorder_no'] = 4;
								$voucher_array['vamount'] = $freight;
								$this->purchase_obj->insert('dms_vouchers',$voucher_array);
								#-----------Other Expense
								$voucher_array['dr_ledger'] = 14;
								$voucher_array['vorder_no'] = 5;
								$voucher_array['vamount'] = $other_expense;
								$this->purchase_obj->insert('dms_vouchers',$voucher_array);
                                #-----------Courier Charge
                                $voucher_array['dr_ledger'] = 19;
								$voucher_array['vorder_no'] = 6;
								$voucher_array['vamount'] = $cour_charge;
								$this->purchase_obj->insert('dms_vouchers',$voucher_array);

								if($payment_mode > 2)
								{
									$this->purchase_obj->insert('dms_voucher_banks',array('group_id' => $voucher_group_id,'cash_type' => $this->input->post('ccd',true),'cd_no' => $this->input->post('cd_no',true),'pdc' => $cheque_date,'vdate' => $bill_date));
								}
							}
						}

						$branch_id = $this->session->userdata('under_id');
                        $godown_id = $this->stock->get_branch_godown($branch_id); 
                                         
                        $purchase_items_array = $this->purchase_obj->get_purchase_itemss(array('columns' => array('id','item_id'),'conditions' => array('group_id' => $group_id,'status' => 1,'item_status >' => 0)));
                            
                        $stk_stat = 0;                        
						foreach($purchase_items_array as $key => $value)
						{
							if($this->purchase_obj->update_others(array('table' => 'dms_stocks','data' => array('status' => 1),'conditions' => array('stock_status' => 2,'table_id' => $value['id']))))
							{
							    $stk_stat =1;
							}
						}
						
						$this->message->set($this->lang->line('purchase-save-success'));
						
						if($stk_stat == 1)
						{
						    $this->message->set($this->lang->line('stock-updated'));
						}
					}
					else
					{
						$this->message->set($this->lang->line('purchase-save-error'),'e');
					}

					$this->db->trans_complete();
				}
				else
				{
					$this->message->set($this->lang->line('purchase-save-error'),'e');
				}
				redirect('purchase/add');
			}
		}

		$vendors = $this->stock->get_vendors();
		$vendor_id = "";

		$units = $items = $goDowns = array();
		$units[''] = "Select";
		$args['select'] = array('id','item_code','item_name');
		$items = $this->stock->get_stock_items($args);
		if(empty($items))
		{
			$this->message->set($this->lang->line('no-items-found'),'i');
		}
		if($this->input->post('item_id',true))
		{
			$itemID = $this->input->post('item_id',true);
		//	$goDowns = $this->stock->get_item_godowns(array('item_id'=>$itemID,'listing'=>1));
			$units = $this->stock->get_units($itemID);
		}
           
		#------------purchase temp data
		$purchase_temp_data = array();
		$price_list_id = $stock_count = $primary_unit['symbol'] = $invoice_no = "";
		$invoice_date = date('Y-m-d');
		if($result_array['vstatus'])
		{
            $purchase_temp_data = $this->purchase_obj->get_purchases_gst(array('columns' => array('a.group_id','a.bill_date','a.vendor_id','a.invoice_no','a.invoice_date','a.tax_type','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.discount_per','b.discount_amt','b.godown_id','b.cgst','b.sgst','b.igst','b.cgst_amt','b.sgst_amt','b.igst_amt'),'conditions' => array('a.created_by' => $this->session->userdata('id'),'vtype_id' => $vtype_id,'bill_no' => $voucher_no,'a.status =' => -1,'b.status !=' => 0)));
                       
			$vendor_id = $purchase_temp_data[0]['vendor_id'];
			$invoice_no = $purchase_temp_data[0]['invoice_no'];
			$invoice_date = $purchase_temp_data[0]['invoice_date'];

            $b_date = $purchase_temp_data[0]['bill_date'];
            $tax_type = $purchase_temp_data[0]['tax_type'];
		}
		else
		{
			$purchase_array = $this->input->post('purchase',true);

			#------------stock count of this item
		/*	if($this->input->post('item_id',true) && $this->input->post('godown_id',true) && $purchase_array['bill_date'] != "")
			{
				$stock_count = $this->stock->get_stock_count($this->input->post('godown_id',true),$this->input->post('item_id',true),$purchase_array['bill_date']);
				$primary_unit = $this->stock->get_primary_unit($this->input->post('item_id',true));
			} */
			if($this->input->post('item_id',true) &&  $purchase_array['bill_date'] != "")
			{
				$stock_count = $this->stock->get_stock_count($godown,$this->input->post('item_id',true),$purchase_array['bill_date']);
				$primary_unit = $this->stock->get_primary_unit($this->input->post('item_id',true));
			} 
		}
        
        $this->load->model('products/Manufacture_model','manu');		
        $this->load->model('godown/Godown_model','godown');
        $this->load->model('products/Unit_model','unit');
        

        $units1 = $this->unit->listing();
        $item_groups1 = $this->item->item_group_listing();
      //  $godowns1 = $this->godown->listing();

		$items[''] = 'Select';ksort($items);
	//	$goDowns[''] = 'Select';ksort($goDowns);
		$vendors[''] = 'Select';ksort($vendors);
        $item_groups1['']  = 'select';ksort($item_groups1);
      //  ksort($godowns1);
 
        $qr_cour = $this->db->select(array('cgst','sgst'))->from('other_gst')->where('specialisation','courier')->get()->row_array();              
        $cour_gst = $qr_cour['cgst']+$qr_cour['sgst'];

		#------------payment modes
		$payment_mode = $this->stock->payment_modes();

		#------------cheque / dd details
		$cd_status = 1;
		if($this->input->post('payment_mode',true) > 2)
		{
			$cd_status = 0;
		}

		#------------template
		$this->template->title("New Purchase Voucher");
		$this->template->main_heading($this->lang->line("$voucher_name"));
		$this->template->breadcrumb(array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line("$voucher_name") => 'no_link',$this->lang->line('report') => 'purchase/report'));
		$this->template->slice('dms/message');
		$this->template->slice('purchase/purchase_entry/add',array('voucher_types' => $voucher_types,'voucher_type' => $vtype_id,'voucher_name' => $voucher_name,'voucher_no' => $voucher_no,'voucher_date' => $voucher_date,'b_date'=>$b_date,'vendors' => $vendors,'items' => $items,'units' => $units,'goDowns' => $goDowns,'purchase_temp_status' =>$result_array['vstatus'],'purchase_temp_data' => $purchase_temp_data,'vendor_id' => $vendor_id,'invoice_no' => $invoice_no,'invoice_date' => $invoice_date,'purchase_cst' => $purchase_cst,'presumptive_tax' => $presumptive_tax,'cess' => $cess,'payment_mode' => $payment_mode,'disabled' => $disabled,'stock_count' => $stock_count,'primary_unit' => $primary_unit['symbol'],'cd_status' => $cd_status,'cour_gst'=>$cour_gst,'tax_type'=>$tax_type,'units1'=>$units1,'groups1'=>$item_groups1,'godowns1'=>$godowns1,'previous_status'=>$previous_status));
		$this->template->other_script('purchase/purchase_script');
		$this->template->render();
	}

	public function delete_temp()
	{
		#----------purchase temp data
		$uri_array = $this->uri->uri_to_assoc(3);
		if(isset($uri_array['idu']) || isset($uri_array['ida']))
		{
			if(isset($uri_array['idu']))
			{
				$id = $uri_array['idu'];
				unset($uri_array['idu']);

				#-----------redirect uri
				$redirect_uri = "purchase/update/".$this->uri->assoc_to_uri($uri_array);
			}
			else
			{
				$id = $uri_array['ida'];
				unset($uri_array['ida']);

				#-----------redirect uri
				$redirect_uri = "purchase/add/".$this->uri->assoc_to_uri($uri_array);
			}

			$result = $this->purchase_obj->get_purchase_itemss(array('columns' => array('group_id','status','item_status','created_by'),'conditions' => array('id' => $id,'status !=' => 0)));
			if(!empty($result))
			{
				$row = $result[0];
				if($row['status'] == -1)
				{
					if($row['created_by'] == $this->session->userdata('id'))
					{
						#----------start transaction
						$this->db->trans_start();

						if($this->purchase_obj->delete(array('table' => 'dms_purchase_items1','conditions' => array('id' => $id))))
						{
							#-------------deleting stock bal. from dms_stocks
							$this->purchase_obj->delete(array('table' => 'dms_stocks','conditions' => array('table_id' => $id,'stock_status' => 2)));

							$count = $this->purchase_obj->get_purchase_itemss(array('columns' => array('group_id'),'conditions' => array('group_id' => $row['group_id'],'status !=' => 0),'numrows' => true));
							if($count == 0){
								$this->purchase_obj->delete(array('table' => 'dms_purchases','conditions' => array('group_id' => $row['group_id'])));
							}
							$this->message->set($this->lang->line('purchase-item-delete-success'));
						}
						else
						{
							$this->message->set($this->lang->line('purchase-item-delete-error'),'e');
						}

						#----------end transaction
						$this->db->trans_complete();
					}
					else
					{
						redirect('users/logout');
					}
				}
				else
				{
					#----------start transaction
					$this->db->trans_start();

					#-------------deleting item from dms_purchase_items
					if($row['item_status'] == 2)//purchase entry
					{
						$this->purchase_obj->update(array('table' => 'dms_purchase_items1','data' => array('status' => 0),'conditions' => array('id' => $id)));
					}
					else//purchase order
					{
						$this->purchase_obj->update(array('table' => 'dms_purchase_items1','data' => array('item_status' => -1),'conditions' => array('id' => $id)));
					}

					#-------------changing purchase bill status
					$this->purchase_obj->update(array('table' => 'dms_purchases','data' => array('status' => -1),'conditions' => array('group_id' => $row['group_id'])));

					#-------------deleting stock bal. from dms_stocks
					$this->purchase_obj->update_others(array('table' => 'dms_stocks','data' => array('status' => 0),'conditions' => array('table_id' => $id,'stock_status' => 2)));

					#-------------checking whether purchase bill is deleted
					$count = $this->purchase_obj->get_purchase_itemss(array('columns' => array('group_id'),'conditions' => array('group_id' => $row['group_id'],'status !=' => 0,'item_status >' => 0),'numrows' => true));
					if($count == 0){

						#-------------deleting purchase bill
						$this->purchase_obj->update(array('table' => 'dms_purchases','data' => array('status' => 0),'conditions' => array('group_id' => $row['group_id'])));

						#-------------deleting stock from dms_vouchers
						$this->purchase_obj->update_others(array('table' => 'dms_vouchers','data' => array('status' => 0),'conditions' => array('table_name' => 'dms_purchases','table_group_id' => $row['group_id'])));

						#-------------deleting stock from dms_voucher_banks
						$cheque_details = $this->vouchers->cheque_data(array('columns' => 'b.id','conditions' => array('table_name' => 'dms_purchases','table_group_id' => $row['group_id'])));
						if(!empty($cheque_details))
						{
							$this->purchase_obj->update_others(array('table' => 'dms_voucher_banks','data' => array('status' => 0),'conditions' => array('id' => $cheque_details[0]['id'])));
						}

						#-----------redirect uri
						$redirect_uri = "purchase/report/".$this->uri->assoc_to_uri($uri_array);
					}

					#----------end transaction
					$this->db->trans_complete();

					$this->message->set($this->lang->line('purchase-item-delete-success'));
				}
			}
			redirect($redirect_uri);
		}
		redirect('users/logout');
	}

	public function update_temp()
	{
		#----------purchase temp data
		$uri_array = $this->uri->uri_to_assoc(3);
		if(isset($uri_array['idu']) || isset($uri_array['ida']))
		{
			if(isset($uri_array['idu']))
			{
				$purchase_temp_id = $uri_array['idu'];
				unset($uri_array['idu']);

				#-----------redirect uri
				$redirect_uri = "purchase/update/".$this->uri->assoc_to_uri($uri_array);
			}
			else
			{
				$purchase_temp_id = $uri_array['ida'];
				unset($uri_array['ida']);

				#-----------redirect uri
				$redirect_uri = "purchase/add/".$this->uri->assoc_to_uri($uri_array);
			}		

            $row = $this->purchase_obj->get_purchase_itemss(array('columns' => array('id','group_id','item_id','qty','unit_id','rate','amount','discount_per','discount_amt','cgst','sgst','igst','cgst_amt','sgst_amt','igst_amt','godown_id','status','item_status','created_by'),'conditions' => array('id' => $purchase_temp_id,'status !=' => 0)));
			if(!empty($row))
			{
				$purchase_temp_data = $row[0];$continue = 1;
				
				if($purchase_temp_data['status'] == -1){
					if($purchase_temp_data['created_by'] != $this->session->userdata('id'))
					{
						$continue = 0;
					}
				}
				if($continue == 1)
				{
					#-----------validation
					$this->form_validation->set_rules('qty','lang:quantity','required|xss_clean|greater_than[0]|less_than[100000000]');
				    $this->form_validation->set_rules('rate','lang:rate','required|xss_clean|greater_or_equal[0]|less_than[100000000]');
					$this->form_validation->set_rules('amount','lang:amount','xss_clean|required|greater_or_equal[0]|less_than[100000000]');
					$this->form_validation->set_rules('discount_per','lang:discount %','xss_clean|greater_or_equal[0]|less_or_equal[100]');
					$this->form_validation->set_rules('discount_amt','lang:discount','xss_clean|greater_or_equal[0]|less_than[100000000]');
				
					#-----------updating temporary data
					if($this->form_validation->run() === true)
					{
						$item_temp_array = $this->input->post(NULL,true);
						$t_type = $item_temp_array['tax_type'];
                        $item_name = $item_temp_array['item_name'];
                        $model_no = $item_temp_array['model_no'];
                        $hsn = $item_temp_array['hsn'];
                        $lcost = $item_temp_array['rate'];
						$mrp = $item_temp_array['mrp'];
                        $rate2 = $item_temp_array['rate2'];
                        
                        if(!empty($mrp))
                        {
                            $new_rate = array();
                            $new_rate['company_id'] = $this->companyID;
                            $new_rate['item_id'] = $item_temp_array['item_id'];
                            $new_rate['rate'] = $mrp;
                            $new_rate['rate2'] = $rate2;
                            $new_rate['landing_cost'] = $lcost;
                            $new_rate['valid_from'] = date('Y-m-d');
                            $new_rate['status'] = 1; 
                            $this->purchase_obj->insert("dms_item_rates",$new_rate);
                        }
                        
                        unset($item_temp_array['tax_type']);
                        unset($item_temp_array['mrp']);
                        unset($item_temp_array['rate2']);
                        unset($item_temp_array['item_name']);
                        unset($item_temp_array['model_no']);
                        unset($item_temp_array['hsn']);
                        
						#----------rate calculation
						$item_temp_array['rate'] = 0;
						if($item_temp_array['qty'] != 0)
						{
							$item_temp_array['rate'] = (float)$item_temp_array['amount'] / (float)$item_temp_array['qty'];
						}

						#------------presumptive tax checking
						$presumptive_tax = $this->stock->get_tax_type();
						
						if($t_type == '0')
    					{
    						$cgst = $this->stock->get_item_cgst($item_temp_array['item_id']);
    						$sgst = $this->stock->get_item_sgst($item_temp_array['item_id']);
    						$item_temp_array['cgst'] = $cgst;
    						$item_temp_array['sgst'] = $sgst;
    						$item_temp_array['cgst_amt'] = (((float)$item_temp_array['amount']-(float)$item_temp_array['discount_amt']) * (float)$cgst) / 100;
    						$item_temp_array['sgst_amt'] = (((float)$item_temp_array['amount']-(float)$item_temp_array['discount_amt']) * (float)$sgst) / 100;
    					}
    					else
    					{
    						$igst = $this->stock->get_item_igst($item_temp_array['item_id']);
    						$item_temp_array['igst'] = $igst;
    						$item_temp_array['igst_amt'] = (((float)$item_temp_array['amount']-(float)$item_temp_array['discount_amt']) * (float)$igst) / 100;      
    					}
						
						#----------start transaction
						$this->db->trans_start();
						
						if($this->purchase_obj->update_others(array('table' => 'dms_purchase_items1','data' => $item_temp_array,'conditions' => array('id' => $purchase_temp_id))))
						{
							$this->message->set($this->lang->line('purchase-edit-temp-success'));
						}

                        $this->purchase_obj->update_others(array('table' => 'item_master','data' => array('item_name'=>$item_name,'model_no'=>$model_no,'hsn'=>$hsn),'conditions' => array('id' => $item_temp_array['item_id'])));

						#--------------updating bill status in dms_purchases
						$this->purchase_obj->update_others(array('table' => 'dms_purchases','data' => array('status' => -1),'conditions' => array('group_id' => $purchase_temp_data['group_id'])));
                        $branch_id = $this->session->userdata('under_id');
                        $godown_id = $this->stock->get_branch_godown($branch_id);  
                    
						#--------------updating temporary stock balance in dms_stocks
						if($purchase_temp_data['item_status'] == 2)
						{
						    $this->purchase_obj->update_others(array('table' => 'dms_stocks','data' => array('item_id' => $item_temp_array['item_id'],'qty' => $item_temp_array['qty'],'rate' => $item_temp_array['rate'],'amount' => $item_temp_array['amount'],'status' => $purchase_temp_data['status']),'conditions' => "(stock_status = 2 or stock_status = 1) and table_id = $purchase_temp_id"));
						}
                        
						#----------end transaction
						$this->db->trans_complete();
                       // echo '<script>window.location.href = "'.base_url('purchase/add').'";</script>';
                      
						redirect($redirect_uri);
					}

					#----------voucher name
					$voucher_name = $this->vouchers->voucher_name($this->vtype);

					#-----------purchase cst checking details
					$purchase_cst = $this->stock->get_constant(array('purchase_cst'));

					#------------presumptive tax checking
					$presumptive_tax = $this->stock->get_tax_type();

					#------------checking cst enabled or not
					/*$cst_status = $this->purchase_obj->get_cst($purchase_temp_data['group_id']);*/
					$cst_status = 0;
					if($cst_status)
					{
						$purchase_cst = $cst_status;
					}

					#------------item details / unit details / godown details
					$units = array();$goDowns = array();$itemsn = array();
					$itemsn = $this->stock->get_stock_items($args);
					$item_details = $this->stock->get_item($purchase_temp_data['item_id'],array('item_code','item_name','model_no','hsn'));
					$items[$purchase_temp_data['item_id']] = $item_details['item_code']." / ".$item_details['item_name']." ".$item_details['model_no'];
					$mrpa = $this->db->select(array('rate'))->from('dms_item_rates')->where('item_id',$purchase_temp_data['item_id'])->get()->result_array();

                    foreach($mrpa as $mp => $mrpitem)
                    {
                        $mrp = $mrpitem['rate'];
                    }
                    	$mrpaitem = $this->db->select(array('rate2'))->from('dms_item_rates')->where('item_id',$purchase_temp_data['item_id'])->get()->result_array();

                    foreach($mrpaitem as $mprate => $mrpitemrate)
                    {
                    $rate2 = $mrpitemrate['rate2'];
                    }
					$goDowns = $this->stock->get_item_godowns(array('item_id'=>$purchase_temp_data['item_id'],'listing'=>1));
					$goDowns[''] = 'Select';
					ksort($goDowns);
					$units = $this->stock->get_units($purchase_temp_data['item_id']);

					#------------sale date
					$purchase_date = $this->purchase_obj->get_purchases_gst(array('columns' => array('bill_date','tax_type'),'conditions' => array('a.group_id' => $purchase_temp_data['group_id'],'a.status !=' => 0,'b.item_status >' => 0)))[0];

					#------------stock count of this item
					$stock_count = $this->stock->get_stock_count($purchase_temp_data['godown_id'],$purchase_temp_data['item_id'],$purchase_date['bill_date']);

					#------------primary unit details
					$primary_unit = $this->stock->get_primary_unit($purchase_temp_data['item_id']);

					#------------template
					$this->template->title("Update Purchase Voucher");
					$this->template->main_heading($this->lang->line("$voucher_name"));
					$this->template->breadcrumb(array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line("$voucher_name") => 'purchase/add',$this->lang->line("update") => 'no_link',$this->lang->line('report') => 'purchase/report',$this->lang->line('go-back') => array($redirect_uri)));
					$this->template->slice('dms/message');
					$this->template->slice('purchase/purchase_entry/edit_temp',array('voucher_name' => $voucher_name,'items' => $items,'itemsn' => $itemsn,'units' => $units,'goDowns' => $goDowns,'purchase_temp_data' => $purchase_temp_data,'mrp'=>$mrp,'rate2'=>$rate2,'purchase_cst' => $purchase_cst,'presumptive_tax' => $presumptive_tax,'stock_count' => $stock_count,'unit_symbol' => $primary_unit['symbol'],'purchase_date' => $purchase_date['bill_date'],'tax_type'=>$purchase_date['tax_type'],'item_details' => $item_details));
					$this->template->other_script('purchase/purchase_script');
					$this->template->render();
				}
				else
				{
					redirect('users/logout');
				}
			}
			else
			{
				redirect('users/logout');
			}
		}
		else
		{
			redirect('users/logout');
		}
	}

	public function bill_no_exists($bill_no,$v_details = NULL)
	{
		if($v_details == NULL){
			$where = array('vtype_id' => $this->input->post('vtype_id',true),'bill_no' => $bill_no,'status !=' => 0);
		}
		else{
			$exp = explode('.', $v_details);
			$where = array('vtype_id' => $exp[0],'bill_no' => $bill_no,'group_id !=' => $exp[1],'status !=' => 0);
		}
		$row = $this->purchase_obj->get_bills(array('columns' => array('id'),'conditions' => $where,'numrows' => true));
		if($row == 0){
			return true;
		}
		return false;
	}

	public function report()
    {	
		$vtype_id = $this->vtype;
		$conditions = array('vtype_id' => $vtype_id,'status' => 1);
		$like_array = array();$vnos="";

		#----------voucher name
		$voucher_name = $this->vouchers->voucher_name($this->vtype);

		#----------voucher type array
		$voucher_types = $this->vouchers->voucher_types($this->vtype);

		#----------item array
		$args['select'] = array('id','item_code','item_name','model_no');
		$items = array(); //$this->stock->get_stock_items($args);
		$items[''] = "All";
		ksort($items);
		$item_id = "";
                $vendors = $this->stock->get_vendors();
                $vendors[''] = "All";
		ksort($vendors);
                $vendor_id = "";

		#----------uri array
		$uri_array  = $this->uri->uri_to_assoc(3);

		#----------redirect
		$redirect = "";
		$cond=$branch_id='';
		
		#----------pagination
		$this->load->library('Pagination');
		$config['per_page'] = $this->per_page();
		$config['base_url'] = base_url('purchase/report');
		$config['uri_segment'] = 3;

		#----------dates within financial year
		$cur_date = date('Y-m-d');
		$from_date = $cur_date;
		$to_date = $cur_date;
		$cur_fiscal_yr = $this->dms->get_fiscal_year();
		if($from_date < $cur_fiscal_yr['start_date'] || $from_date > $cur_fiscal_yr['end_date'] || $to_date < $cur_fiscal_yr['start_date'] || $to_date > $cur_fiscal_yr['end_date'])
		{
			$from_date = $cur_fiscal_yr['end_date'];
			$to_date = $cur_fiscal_yr['end_date'];
		}

		#----------validation
		$this->form_validation->set_rules('vtype_id','voucher-types','required|xss_clean');
		$this->form_validation->set_rules('from_date','From Date','required|xss_clean|valid_date');
		$this->form_validation->set_rules('to_date','To Date','required|xss_clean|valid_date');
		$this->form_validation->set_rules('bill_no','bill-no','xss_clean|trim');
		$this->form_validation->set_rules('item_id','item','xss_clean|trim');
		if($this->form_validation->run() === true)
		{
			$vtype_id = $this->input->post('vtype_id',true);
			$from_date = date('Y-m-d',strtotime($this->input->post('from_date',true)));
			$to_date = date('Y-m-d',strtotime($this->input->post('to_date',true)));
			$conditions['vtype_id'] = $vtype_id;
			$config['base_url'] .= '/vt/'.$vtype_id.'/fdate/'.$from_date.'/tdate/'.$to_date;
			$config['uri_segment'] += 6;
			$redirect .= '/vt/'.$vtype_id.'/fdate/'.$from_date.'/tdate/'.$to_date;
			if(!empty($this->input->post('bill_no',true))){
				$vnos = $this->input->post('bill_no',true);
				$cond .= " and p.bill_no like '%$vnos%'";
				$like_array['bill_no'] = $vnos;
				$config['base_url'] .= '/vn/'.$vnos;
				$config['uri_segment'] += 2;
				$redirect .= '/vn/'.$vnos;
			}
			if(!empty($this->input->post('branch_id',true))){
				$branch_id = $this->input->post('branch_id',true);
				$cond .= " and p.branch_id='$branch_id'";
				$conditions['branch_id'] = $branch_id;
				$config['base_url'] .= '/branch/'.$branch_id;
				$config['uri_segment'] += 2;
				$redirect .= '/branch/'.$branch_id;
			}
			if(!empty($this->input->post('item_id',true))){
				$item_id = $this->input->post('item_id',true);                             
				$config['base_url'] .= '/item/'.$item_id;
				$config['uri_segment'] += 2;
				$redirect .= '/item/'.$item_id;
			}
            if(!empty($this->input->post('vendor_id',true))){
				$vendor_id = $this->input->post('vendor_id',true);
				$config['base_url'] .= '/vendor/'.$vendor_id;
				$config['uri_segment'] += 2;
				$redirect .= '/vendor/'.$vendor_id;
                $conditions['vendor_id'] = $vendor_id;
			}
		}
		elseif(isset($uri_array['vt']))
		{
			$vtype_id = $uri_array['vt'];
			$conditions['vtype_id'] = $vtype_id;
			$config['base_url'] .= '/vt/'.$conditions['vtype_id'];
			$config['uri_segment'] += 2;
			$redirect .= '/vt/'.$vtype_id;
			if(isset($uri_array['fdate']) && isset($uri_array['tdate'])){
				$from_date = date('Y-m-d',strtotime($uri_array['fdate']));
				$to_date = date('Y-m-d',strtotime($uri_array['tdate']));
				$config['base_url'] .= '/fdate/'.$from_date.'/tdate/'.$to_date;
				$config['uri_segment'] += 4;
				$redirect .= '/fdate/'.$from_date.'/tdate/'.$to_date;
			}
			if(isset($uri_array['vn'])){
				$vnos = $uri_array['vn'];
				$like_array['bill_no'] = $vnos;
				$config['base_url'] .= '/vn/'.$vnos;
				$config['uri_segment'] += 2;
				$redirect .= '/vn/'.$vnos;
			}
			if(isset($uri_array['branch'])){
				$branch_id = $uri_array['branch'];
				$cond .= " and p.branch_id='$branch_id'";
				$conditions['branch_id'] = $branch_id;
				$config['base_url'] .= '/branch/'.$branch_id;
				$config['uri_segment'] += 2;
				$redirect .= '/branch/'.$branch_id;
			}
		    if(isset($uri_array['item'])){
				$item_id = $uri_array['item'];
				$config['base_url'] .= '/item/'.$item_id;
				$config['uri_segment'] += 2;
				$redirect .= '/item/'.$item_id;
			}
            if(isset($uri_array['vendor'])){
				$vendor_id = $uri_array['vendor'];
				$config['base_url'] .= '/vendor/'.$vendor_id;
				$config['uri_segment'] += 2;
				$redirect .= '/vendor/'.$vendor_id;
			}
		}
        if($branch_id==''){
		    $cond .= " and p.branch_id='$this->branchID'";
		}
		#----------between condition
		$between = "bill_date between '$from_date' and '$to_date'";
         if($this->userID > 0)
         {
             $conditions['created_by'] = $this->userID;
         }
		#----------total rows
		$config['total_rows'] = $this->purchase_obj->get_bills(array('columns' => array('id'),'conditions' => $conditions,'between' => $between,'like' => $like_array,'numrows'=>true,'item_condition' => $item_id));
        if($config['total_rows'] == 0){
			$this->message->set($this->lang->line('no-voucher'),'i');
		}

		#----------pagination
		$offset = $this->uri->segment($config['uri_segment'],0);
		# Pagination Config Customizations
        $config['full_tag_open'] = '<ul class="pagination">';
        $config['full_tag_close'] = '</ul>';
        $config['first_link'] = 'First';
        $config['last_link'] = 'Last';
        $config['next_link'] = '&raquo;';
        $config['prev_link'] = '&laquo;';
        $config['cur_tag_open'] = '<li class="active"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
		$this->pagination->initialize($config);
		$links = $this->pagination->create_links();
		$redirect .= '/'.$offset;

		#------------presumptive tax checking
		$presumptive_tax = $this->stock->get_tax_type();

		#----------purchase report datas
		//$purchase_array1=$this->purchase_obj->get_bills(array('conditions' => $conditions,'between' => $between,'like' => $like_array,'order_by'=>'bill_date','order'=>'DESC','limit'=>$config['per_page'],'offset'=>$offset,'item_condition' => $item_id));

		$purchase_array=$this->purchase_obj->get_bills(array('conditions' => $conditions,'between' => $between,'like' => $like_array,'order_by'=>'id','order'=>'DESC','limit'=>$config['per_page'],'offset'=>$offset,'item_condition' => $item_id));
    
        $this->load->model('branches/Branch_model','branch');
		$branches = $this->branch->listing(array('company_id'=>$this->session->userdata('company_id')));
		$branches[''] = 'Select';
		ksort($branches);
    
		#----------template
		$this->template->title("Purchase Report");
		$this->template->main_heading($this->lang->line("$voucher_name")." ".$this->lang->line("report"));
		$this->template->breadcrumb(array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line("$voucher_name") => 'purchase/add',$this->lang->line('report') => 'no_link'));
		$this->template->slice('purchase/purchase_entry/search',array('branches'=>$branches,'branch_id'=>$branch_id,'voucher_types' => $voucher_types,'vtype_id' => $vtype_id,'vnos' => $vnos,'from_date' => $from_date,'to_date' => $to_date,'rtype' => 'purchase','items' => $items,'item' => $item_id,'vendors'=>$vendors,'vendor_id'=>$vendor_id));
		$this->template->slice('dms/message');
		if(!empty($purchase_array)){
			$this->template->slice('purchase/purchase_entry/report',array('purchase_array' => $purchase_array,'presumptive_tax' => $presumptive_tax,'offset' => $offset,'links' => $links,'redirect' => $redirect));
			$this->template->slice('dms/modals/delete_confirm');
		}
		$this->template->other_script('purchase/purchase_script');
		$this->template->render();
	}

	public function view()
	{
		#----------voucher type
		$vtype_id = $this->vtype;

		$uri_array = $this->uri->uri_to_assoc(3);
		if(isset($uri_array['id']) || isset($uri_array['group_id']))
		{
			#----------voucher name
			$voucher_name = $this->vouchers->voucher_name($this->vtype);

			#----------breadcrumb
			$breadcrumb = array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line("$voucher_name") => 'purchase/add',$this->lang->line('report') => 'purchase/report',$this->lang->line("view") => 'no_link');

			if($this->uri->segment(3) == 'group_id')
			{
				$conditions = array('a.group_id' => $this->uri->segment(4),'a.status !=' => 0,'b.status !=' => 0,'b.item_status >' => 0);
				if($this->uri->segment(5) && $this->uri->segment(5) == 'vt')
				{
					$breadcrumb_url = "daybooks/index/vt/".$this->uri->segment(6);
					$breadcrumb[$this->lang->line("go-back")] = $breadcrumb_url;
				}
				elseif($this->uri->segment(5) && ($this->uri->segment(5) == 'id' || $this->uri->segment(5) == 'mid' || $this->uri->segment(5) == 'sid'))
				{
					$breadcrumb_url = "stock_item_register/index/".$this->uri->segment(5)."/".$this->uri->segment(6);
					if($this->uri->segment(7) && $this->uri->segment(7) == 'rtype'){
						$breadcrumb_url .= "/rtype/".$this->uri->segment(8);
					}
					$breadcrumb[$this->lang->line("go-back")] = $breadcrumb_url;
				}
				elseif($this->uri->segment(5) && $this->uri->segment(5) == 'vp')
				{
					$breadcrumb[$this->lang->line("go-back")] = "vat_detailed_reports/index/ttyp/3/vp/".$this->uri->segment(6)."/fdate/".$this->uri->segment(8)."/tdate/".$this->uri->segment(10);
				}
				else
				{
					$breadcrumb_url = "ledger_reports/index/";
					if($this->uri->segment(5))
					{
						$breadcrumb_url .= $this->uri->segment(5);
					}
					if($this->uri->segment(6))
					{
						$breadcrumb_url .= "/sid/".$this->uri->segment(6);
					}
					if($this->uri->segment(7))
					{
						$breadcrumb_url .= "/tbp/".$this->uri->segment(7);
					}
					$breadcrumb[$this->lang->line("go-back")] = $breadcrumb_url;
				}
			}
			else
			{
				#----------purchase primary key
				$purchase_id = $uri_array['id'];
				unset($uri_array['id']);
				$conditions = array('a.id' => $purchase_id,'a.status !=' => 0,'b.status !=' => 0,'b.item_status >' => 0);
				$breadcrumb[$this->lang->line("go-back")] = "purchase/report/".$this->uri->assoc_to_uri($uri_array);
			}

			#----------purchase data
			
$purchase_array = $this->purchase_obj->get_purchases_gst(array('columns' => array('a.id as primary_id','a.vtype_id','a.bill_no','a.bill_date','a.invoice_no','a.invoice_date','a.group_id','a.vendor_id','a.bill_discount_per','a.bill_discount_amt','a.bill_freight','a.other_expense','a.cess','a.courier_charge','a.courier_gst','a.tax_type','a.narration','a.payment_mode','a.cr_period','a.created_by','a.created_on','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.discount_per','b.discount_amt','b.godown_id','b.cgst','b.igst','b.sgst','b.cgst_amt','b.sgst_amt','b.igst_amt'),'conditions' => $conditions));

$b_date=$purchase_array[0]['bill_date'];
$tax_type = $purchase_array[0]['tax_type'];
			if(!empty($purchase_array))
			{
				#------------presumptive tax checking
				$presumptive_tax = $this->stock->get_tax_type();

				#------------checking cst enabled or not
				/*$purchase_cst = $this->purchase_obj->get_cst($purchase_array[0]['group_id']);*/
				$purchase_cst = 0;

				$vendor_name = $this->stock->vendor_name($purchase_array[0]['vendor_id']);
				$voucher_type = $this->vouchers->voucher_name($purchase_array[0]['vtype_id']);
				$payment_mode = $this->stock->ledger_name($purchase_array[0]['payment_mode']);

				#--------------cheque / dd details
				$cd_status = 1;$ccd = $cd_no = $pdc = "";
				$cheque_dd_array = $this->vouchers->cheque_data(array('columns' => array('b.cash_type','b.cd_no','b.pdc'),'conditions' => array('a.table_name' => 'dms_purchases','a.table_group_id' => $purchase_array[0]['group_id'])));
				if(!empty($cheque_dd_array))
				{
					$cd_status = 0;
					$ccd = $cheque_dd_array[0]['cash_type'];
					$cd_no = $cheque_dd_array[0]['cd_no'];
					$pdc = $cheque_dd_array[0]['pdc'];
				}

				#----------template
				$this->template->title("Purchase Report");
				$this->template->main_heading($this->lang->line("$voucher_name")." ".$this->lang->line("view"));
				$this->template->breadcrumb($breadcrumb);
				$this->template->slice('dms/message');
				$this->template->slice('purchase/purchase_entry/view',array('purchase_array' => $purchase_array,'presumptive_tax' => $presumptive_tax,'purchase_cst' => $purchase_cst,'voucher_type' => $voucher_type,'b_date'=>$b_date,'vendor_name' => $vendor_name,'payment_mode' => $payment_mode,'cd_status' => $cd_status,'ccd' =>$ccd,'cd_no' =>$cd_no,'pdc' => $pdc,'tax_type'=>$tax_type));
				$this->template->other_script('purchase/purchase_script');
				$this->template->render();
			}
			else
			{
				redirect($breadcrumb[$this->lang->line("go-back")]);
			}
		}
		else
		{
			redirect('users/logout');
		}
	}

	public function update()
	{
		#----------voucher type
		$vtype_id = $this->vtype;

		#----------purchase primary key
		$uri_array = $this->uri->uri_to_assoc(3);
		if(isset($uri_array['id']))
		{
			$purchase_id = $uri_array['id'];
			$redirect = "/".$this->uri->assoc_to_uri($uri_array);
			unset($uri_array['id']);

			#----------redirect uri
			$redirect_uri = "purchase/report/".$this->uri->assoc_to_uri($uri_array);

			#----------redirect uri while updating
			$update_uri = $this->uri->assoc_to_uri($this->uri->uri_to_assoc(1));

			#----------voucher name
			$voucher_name = $this->vouchers->voucher_name($this->vtype);

			#-----------purchase cst checking details
			$purchase_cst = $this->stock->get_constant(array('purchase_cst'));

			#------------presumptive tax checking
			$presumptive_tax = $this->stock->get_tax_type();

			#------------cess %
			$cess = $this->stock->get_cess();

			#------------bill group_id and date
			$item_details = $this->purchase_obj->get_group($purchase_id);
			
			$godown = $this->stock->get_branch_godown($this->branchID);

			#-------------adding items to purchase bill
			if(isset($_POST['btn_add']))
			{
				#-----------validation
				if(isset($_POST['newp'])) 
                { 
                    $this->form_validation->set_rules('new_item[item_group_id]','lang:item-type','required|xss_clean');
                    $this->form_validation->set_rules('new_item[item_code]','lang:item-code','required|xss_clean');
                    $this->form_validation->set_rules('new_item[item_name]','lang:item-name','required|xss_clean');
                }
                else
                {
    			    $this->form_validation->set_rules('item_id','lang:item-name','required|xss_clean');
                }
				$this->form_validation->set_rules('qty','lang:quantity','required|xss_clean|greater_than[0]|less_than[100000000]');
    			$this->form_validation->set_rules('rate','lang:rate','required|xss_clean|greater_or_equal[0]|less_than[100000000]');
    			$this->form_validation->set_rules('amount','lang:amount','xss_clean|required|greater_or_equal[0]|less_than[100000000]');
    			$this->form_validation->set_rules('discount_per','lang:discount %','xss_clean|greater_than[0]|less_or_equal[100]');
    			$this->form_validation->set_rules('discount_amt','lang:discount','xss_clean|greater_or_equal[0]|less_than[100000000]');

				#-----------adding items
				if($this->form_validation->run('btn_add') === true)
				{
				    $new_item = $this->input->post('new_item',true);
				    $vendor_id =  $this->input->post('vendor_id',true);
				    $t_type =  $this->input->post('tax_type',true);
					$item_array['group_id'] = $item_details['group_id'];
					$item_array['item_id'] = $this->input->post('item_id',true);
					$item_array['qty'] = $this->input->post('qty',true);
					$item_array['unit_id'] = 1;
					$item_array['rate'] = $this->input->post('rate',true);
					$item_array['amount'] = $this->input->post('amount',true);
					
					if(isset($_POST['newp'])) 
                    {                               
                        $new_stats = 1;
                        $new_item_details = array();
                        $new_item_details['company_id']=$this->companyID;
                        $new_item_details['item_group_id']=$new_item['item_group_id'];
                        $new_item_details['item_manufacturer_id'] = $vendor_id;
                        $new_item_details['item_code'] = $new_item['item_code'];
                        $new_item_details['item_name'] = $new_item['item_name'];
                        $new_item_details['model_no'] = $new_item['model_no'];
                        $new_it = $this->db->select(array('name'))->from('item_types')->where('group_id',$new_item['item_group_id'])->get()->row_array();                                
                        $new_item_details['item_types'] = strtolower($new_it['name']);
                        $tp = $new_item_details['item_types'];
                        $cd = $new_item_details['item_code'];
                        if($tp=='contact' || $tp=='solution')
        			    {
        			        $new_item_details['code_id'] = substr($cd,2);
        			    }
        			    else
        			    {
        			        $new_item_details['code_id'] = substr($cd,1);
        			    }
                        
                        $new_item_details['unit_id'] = 1;
                        $new_item_details['hsn'] = $new_item['hsn'];
                        $new_item_details['stock_type'] = 1;
                        $new_item_details['status'] = 1;
                        
                        $item_check = $this->db->select(array('id'))->from('item_master')->where('item_code',$new_item_details['item_code'])->get()->row_array();          
                        if(empty($item_check))
                        {
                            $new_item_id = $this->purchase_obj->insert("item_master",$new_item_details);
                            if($new_item_id)
                            {
                                $new_stock = array();
                                $new_stock['company_id'] = $this->companyID;
                                $new_stock['branch_id'] = $this->session->userdata('under_id');
                                $new_stock['godown_id'] = $godown;
                                $new_stock['item_id'] = $new_item_id;
                                $new_stock['qty']=0;
                                $new_stock['unit_id'] = 1;
                                $new_stock['rate'] = 0;
                                $new_stock['stock_date'] = $this->dms->get_fiscal_year()['start_date'];
                                $new_stock['status'] = 1;
                                $this->purchase_obj->insert("dms_stocks",$new_stock);
                            }
                            $item_array['item_id'] = $new_item_id;
                        }
                        else
                        {
                            $item_array['item_id'] = $item_check['id'];
                        }
                    }
                    
                    $mrp = $this->input->post('mrp',true);
                    $rate2 = $this->input->post('rate2',true);
                    $lcost = $this->input->post('rate',true);
                    if(!empty($mrp))
                    {
                        $new_rate = array();
                        $new_rate['company_id'] = $this->companyID;
                        $new_rate['item_id'] = $item_array['item_id'];
                        $new_rate['rate'] = $mrp;
                        $new_rate['rate2'] = $rate2;
                        $new_rate['landing_cost'] = $lcost;
                        $new_rate['valid_from'] = date('Y-m-d');
                        $new_rate['status'] = 1; 
                        $this->purchase_obj->insert("dms_item_rates",$new_rate);
                    }

					#----------rate calculation
					$item_array['rate'] = 0;
					if($item_array['qty'] != 0)
					{
						$item_array['rate'] = (float)$item_array['amount'] / (float)$item_array['qty'];
					}

					$item_array['discount_per'] = $this->input->post('discount_per',true);
					$item_array['discount_amt'] = $this->input->post('discount_amt',true);
					$item_array['godown_id'] = $godown;
					$item_array['status'] = -1;
					$item_array['item_status'] = 2;//purchase only items
					
					$purchase_temp_item_result = $this->purchase_obj->get_purchases_gst(array('columns' => array('b.id'),'conditions' => array('b.group_id' => $item_array['group_id'],'item_id' => $item_array['item_id'],'godown_id' => $item_array['godown_id'],'unit_id' => $item_array['unit_id'],'a.status !=' => 0,'b.status !=' => 0,'b.item_status >' => 0),'numrows' => true));
					if($purchase_temp_item_result == 0)
                    {
					    #----------GST calculation
					    if($t_type == '0')
    					{
    						$cgst = $this->stock->get_item_cgst($item_array['item_id']);
    						$sgst = $this->stock->get_item_sgst($item_array['item_id']);
    						$item_array['cgst'] = $cgst;
    						$item_array['sgst'] = $sgst;
    						$item_array['cgst_amt'] = (((float)$item_array['amount']-(float)$item_array['discount_amt']) * (float)$cgst) / 100;
    						$item_array['sgst_amt'] = (((float)$item_array['amount']-(float)$item_array['discount_amt']) * (float)$sgst) / 100;
    					}
    					else
    					{
    						$igst = $this->stock->get_item_igst($item_array['item_id']);
    						$item_array['igst'] = $igst;
    						$item_array['igst_amt'] = (((float)$item_array['amount']-(float)$item_array['discount_amt']) * (float)$igst) / 100;      
    					}
    					
    					$this->db->trans_start();

                        $purchase_items_id = $this->purchase_obj->insert("dms_purchase_items1",$item_array);				

       		            if($purchase_items_id)
						{
							$this->purchase_obj->update_others(array('table' => 'dms_purchases','data' => array('status' => -1),'conditions' => array('group_id' => $item_array['group_id'])));
                            $this->purchase_obj->insert('dms_stocks',array('company_id' => $this->session->userdata('company_id'),'branch_id' => $this->session->userdata('under_id'),'godown_id' => $item_array['godown_id'],'item_id' => $item_array['item_id'],'qty' => $item_array['qty'],'unit_id' => $item_array['unit_id'],'rate' => $item_array['rate'],'amount' => $item_array['amount'],'stock_date' => $item_details['bill_date'],'stock_status' => 2,'table_group_id' => $item_array['group_id'],'table_id' => $purchase_items_id));
							$this->message->set($this->lang->line('purchase-add-success'));
						}
						else
						{
							$this->message->set($this->lang->line('purchase-add-error'),'e');
						}

						$this->db->trans_complete();
					}
					else
					{
						$this->message->set($this->lang->line('purchase-add-error'),'e');
					}
				//	redirect($update_uri);
				}
			}

			#------------saving purchase voucher
			if(isset($_POST['btn_update']))
			{
				#-----------validation
				$this->form_validation->set_rules('bill_no','lang:bill-no',"required|xss_clean|is_natural_no_zero|callback_bill_no_exists[$item_details[vtype_id].$item_details[group_id]]");

				$row = $this->purchase_obj->get_bills(array('columns' => array('pid','p_status'),'conditions' => array('id' => $purchase_id,'p_status >' => 0)));
				if(!empty($row))
				{
					$this->load->library('Purchase_lib');
					$pre_bill_date = $this->purchase_lib->get_bill_date($row[0]['pid'],$row[0]['p_status']);
					$this->form_validation->set_rules('bill_date','lang:bill-date',"required|xss_clean|valid_date|check_date[$pre_bill_date.>=]");
				}
				else
				{
					$this->form_validation->set_rules('bill_date','lang:bill-date','required|xss_clean|valid_date');
				}
				$this->form_validation->set_rules('invoice_no','lang:invoice-no','required|xss_clean');
				$this->form_validation->set_rules('invoice_date','lang:invoice-date','required|xss_clean|is_date');
				$this->form_validation->set_rules('vendor_id','lang:vendor','required|xss_clean');
				$this->form_validation->set_rules('payment_mode','lang:payment-mode','required|xss_clean');
				if($this->input->post('payment_mode',true) == 2)
				{
					$this->form_validation->set_rules('credit_period','lang:credit-period','required|xss_clean|is_natural');
				}
				elseif($this->input->post('payment_mode',true) > 2)
				{
					$this->form_validation->set_rules('ccd','lang:transaction-type','required|xss_clean');
					$this->form_validation->set_rules('cd_no','lang:cd-no','required|xss_clean|max_length[64]');
					$this->form_validation->set_rules('cheque_date','lang:cheque-date',"required|xss_clean|is_date|check_date[$item_details[bill_date].>=]");
				}
				$this->form_validation->set_rules('remarks','lang:remarks','xss_clean');
				$this->form_validation->set_rules('freight','lang:freight','xss_clean|greater_or_equal[0]|less_than[100000000]');
				$this->form_validation->set_rules('other_expense','lang:other-expense','xss_clean|greater_or_equal[0]|less_than[100000000]');
				$this->form_validation->set_rules('bill_discount_per','lang:discount %','xss_clean|greater_or_equal[0]|less_or_equal[100]');
				$this->form_validation->set_rules('bill_discount_amt','lang:discount','xss_clean|greater_or_equal[0]|less_than[100000000]');

				#-----------updating data
				if($this->form_validation->run('btn_update') === true)
				{
					$bill_date = date('Y-m-d',strtotime($this->input->post('bill_date',true)));
					$invoice_date = date('Y-m-d',strtotime($this->input->post('invoice_date',true)));
					$bill_no = $this->input->post('bill_no',true);
					$narration = $this->input->post('remarks',true);
					$payment_mode = $this->input->post('payment_mode',true);
					$freight = $this->input->post('freight',true);
					$other_expense = $this->input->post('other_expense',true);
                    $cour_charge = $this->input->post('courier_charge',true);
                    $cour_gst = $this->input->post('cour_gst_amt',true);
					$vendor_id = $this->input->post('vendor_id',true);
                    $tax_type = $this->input->post('tax_type',true);
					$bill_discount_amt = $this->input->post('bill_discount_amt',true);
					$purchase_entry_array=array('bill_no' => $bill_no,'bill_date' => $bill_date,'invoice_no' => $this->input->post('invoice_no',true),'invoice_date' => $invoice_date,'vendor_id' => $vendor_id,'bill_discount_per' => $this->input->post('bill_discount_per',true),'bill_discount_amt' => $bill_discount_amt,'bill_freight' => $freight,'other_expense' => $other_expense,'tax_type'=>$tax_type,'cess' => $cess,'narration' => $narration,'payment_mode' => $payment_mode,'cr_period' => $this->input->post('credit_period',true),'courier_charge'=>$this->input->post('courier_charge',true),'courier_gst'=>$this->input->post('cour_gst_amt',true),'status' => 1);

					#----------start transaction
					$this->db->trans_start();

					if($this->purchase_obj->update(array('table' => 'dms_purchases','data' => $purchase_entry_array,'conditions' => array('id' => $purchase_id))))
					{
						#-------------updating status of dms_purchase_items
					    $this->purchase_obj->update_others(array('table' => 'dms_purchase_items1','data' => array('status' => 1),'conditions' => array('group_id' => $item_details['group_id'],'status !=' => 0,'item_status >' => 0)));

						#-------------updating status of dms_stocks
						$this->purchase_obj->update_others(array('table' => 'dms_stocks','data' => array('status' => 1),'conditions' => "table_group_id = ".$item_details['group_id']." and (stock_status = 1 or stock_status = 2) and status != 0"));

						#-------------adding bill to dms_vouchers
						$voucher_status = 1;
						$voucher_amount = $this->input->post('grand_total',true);
						$round_off_amount = $this->input->post('round_off_amount',true);
						$vat_amount = $this->input->post('vat_total',true);
						$cess_amount = $this->input->post('cess_total',true);
                                                $cour_charge = $this->input->post('tot_cour_amt',true);
						if($payment_mode > 2)
						{
							$bill_date_time = strtotime($bill_date);
							$cheque_date = date('Y-m-d',strtotime($this->input->post('cheque_date',true)));
							$cheque_date_time = strtotime($cheque_date);
							if($this->input->post('ccd',true) == 1 && $cheque_date_time > $bill_date_time)
							{
								$voucher_status = 3;
							}
						}
						elseif($payment_mode == 2)
						{
							if($this->dms->branch_type())
							{
								$vendor_ledger_id = $this->dms->get_data(array('table' =>'item_manufacturer_master','columns' => 'ledger_id','conditions' => array('id' => $vendor_id)));
								$payment_mode = $vendor_ledger_id[0]['ledger_id'];
							}
							else
							{
								$vendor_ledger_id = $this->dms->get_data(array('table' =>'branch_master','columns' => 'ledger_id','conditions' => array('id' => $vendor_id)));
								$payment_mode = $vendor_ledger_id[0]['ledger_id'];
							}
						}
						(float)$voucher_amount -= (float)$bill_discount_amt;
						(float)$voucher_amount += (float)$round_off_amount;

						$voucher_data = $this->dms->get_data(array('table' => 'dms_vouchers','columns' => array('id','group_id'),'conditions' => array('table_name' => 'dms_purchases','table_group_id' => $item_details['group_id']),'order_by' => 'vorder_no','order' => 'asc','limit' => 1,'offset' => 0));
						if(empty($voucher_data))
						{
							$voucher_group_id = $this->stock->get_group_id('dms_vouchers');
							$voucher_array = array('company_id' => $this->session->userdata('company_id'),'branch_id' => $this->session->userdata('under_id'),'group_id' => $voucher_group_id,'vtype_id' => $item_details['vtype_id'],'vno' => $bill_no,'vorder_no' => 1,'vdate' => $bill_date,'dr_ledger' => 3,'cr_ledger' => $payment_mode,'vamount' => $voucher_amount,'narration' => $narration,'table_name' => 'dms_purchases','table_group_id' => $item_details['group_id'],'status' => $voucher_status);

							$voucher_success = $this->purchase_obj->insert('dms_vouchers',$voucher_array);
							if($voucher_success)
							{
								#-----------VAT
								$voucher_array['dr_ledger'] = 11;
								$voucher_array['vorder_no'] = 2;
								$voucher_array['vamount'] = $vat_amount;
								$this->purchase_obj->insert('dms_vouchers',$voucher_array);
								#-----------CESS
								$voucher_array['dr_ledger'] = 15;
								$voucher_array['vorder_no'] = 3;
								$voucher_array['vamount'] = $cess_amount;
								$this->purchase_obj->insert('dms_vouchers',$voucher_array);
								#-----------Freight
								$voucher_array['dr_ledger'] = 13;
								$voucher_array['vorder_no'] = 4;
								$voucher_array['vamount'] = $freight;
								$this->purchase_obj->insert('dms_vouchers',$voucher_array);
								#-----------Other Expense
								$voucher_array['dr_ledger'] = 14;
								$voucher_array['vorder_no'] = 5;
								$voucher_array['vamount'] = $other_expense;
								$this->purchase_obj->insert('dms_vouchers',$voucher_array);

                                $voucher_array['dr_ledger'] = 19;
								$voucher_array['vorder_no'] = 6;
								$voucher_array['vamount'] = $cour_charge;
								$this->purchase_obj->insert('dms_vouchers',$voucher_array);

								if($payment_mode > 2)
								{
									$this->purchase_obj->insert('dms_voucher_banks',array('group_id' => $voucher_group_id,'cash_type' => $this->input->post('ccd',true),'cd_no' => $this->input->post('cd_no',true),'pdc' => $cheque_date,'vdate' => $bill_date));
								}
							}
						}
						else
						{
							$voucher_array = array('vno' => $bill_no,'vdate' => $bill_date,'cr_ledger' => $payment_mode,'vamount' => $voucher_amount,'narration' => $narration,'status' => $voucher_status);
							$voucher_success = $this->purchase_obj->update_others(array('table' => 'dms_vouchers','data' => $voucher_array,'conditions' => array('id' => $voucher_data[0]['id'])));
							if($voucher_success)
							{
								#-----------VAT
								$voucher_array['vamount'] = $vat_amount;
								$this->purchase_obj->update_others(array('table' => 'dms_vouchers','data' => $voucher_array,'conditions' => array('group_id' => $voucher_data[0]['group_id'],'dr_ledger' => 11)));
								#-----------CESS
								$voucher_array['vamount'] = $cess_amount;
								$this->purchase_obj->update_others(array('table' => 'dms_vouchers','data' => $voucher_array,'conditions' => array('group_id' => $voucher_data[0]['group_id'],'dr_ledger' => 15)));
								#-----------Freight
								$voucher_array['vamount'] = $freight;
								$this->purchase_obj->update_others(array('table' => 'dms_vouchers','data' => $voucher_array,'conditions' => array('group_id' => $voucher_data[0]['group_id'],'dr_ledger' => 13)));
								#-----------Other Expense
								$voucher_array['vamount'] = $other_expense;
								$this->purchase_obj->update_others(array('table' => 'dms_vouchers','data' => $voucher_array,'conditions' => array('group_id' => $voucher_data[0]['group_id'],'dr_ledger' => 14)));
                                #-----------Courier Charge
                                $voucher_array['vamount'] = $cour_charge;
								$this->purchase_obj->update_others(array('table' => 'dms_vouchers','data' => $voucher_array,'conditions' => array('group_id' => $voucher_data[0]['group_id'],'dr_ledger' => 19)));

                                if($payment_mode > 2)
								{
									if($this->dms->get_data(array('table' => 'dms_voucher_banks','columns' => array('id'),'conditions' => array('group_id' => $voucher_data[0]['group_id']),'numrows' => true)) == 0)
									{
										$this->purchase_obj->insert('dms_voucher_banks',array('group_id' => $voucher_data[0]['group_id'],'cash_type' => $this->input->post('ccd',true),'cd_no' => $this->input->post('cd_no',true),'pdc' => $cheque_date,'vdate' => $bill_date));
									}
									else
									{
										$this->purchase_obj->update_others(array('table' => 'dms_voucher_banks','data' => array('cash_type' => $this->input->post('ccd',true),'cd_no' => $this->input->post('cd_no',true),'pdc' => $cheque_date,'vdate' => $bill_date),'conditions' => array('group_id' => $voucher_data[0]['group_id'])));
									}
								}
							}
						}
						$this->message->set($this->lang->line('purchase-edit-success'));
					}
					else
					{
						$this->message->set($this->lang->line('purchase-edit-error'),'e');
					}

					$this->db->trans_complete();

					redirect('purchase/report');
				}
			}

			$purchase_array = $this->purchase_obj->get_purchases_gst(array('columns' => array('a.vtype_id','a.bill_no','a.bill_date','a.invoice_no','a.invoice_date','a.group_id','a.vendor_id','a.bill_discount_per','a.bill_discount_amt','a.bill_freight','a.other_expense','a.tax_type','a.cess','a.courier_charge','a.courier_gst','a.narration','a.payment_mode','a.cr_period','a.status','a.created_by','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.discount_per','b.discount_amt','b.godown_id','b.cgst','b.sgst','b.igst','b.cgst_amt','b.sgst_amt','b.igst_amt'),'conditions' => array('a.id' => $purchase_id,'a.status !=' => 0,'b.status !=' => 0,'b.item_status >' => 0)));

            $b_date=$purchase_array[0]['bill_date'];
            $tax_type = $purchase_array[0]['tax_type'];

			if(!empty($purchase_array))
			{
				$continue = 1;
				if($purchase_array[0]['status'] == -1)
				{
					if($purchase_array[0]['created_by'] != $this->session->userdata('id'))
					{
						$continue = 0;
					}
				}
				if($continue == 1)
				{
					$stock_count="";$primary_unit['symbol']="";

					#------------checking cst enabled or not
				/*	$cst_status = $this->purchase_obj->get_cst($purchase_array[0]['group_id']);*/
				$cst_status = 0;
					if($cst_status)
					{
						$purchase_cst = $cst_status;
					}

					#------------vendor details
					$vendors = $this->stock->get_vendors();

					#------------payment modes
					$payment_modes = $this->stock->payment_modes();

					#------------item details / unit details / godown details
					$units = $goDowns = array();
					$units[''] = "Select";
					$args['select'] = array('id','item_code','item_name');
					$items = $this->stock->get_stock_items($args);
					if(empty($items)){
						$this->message->set($this->lang->line('no-items-found'),'i');
					}
					if($this->input->post('item_id',true)){
						$itemID = $this->input->post('item_id',true);
						$goDowns = $this->stock->get_item_godowns(array('item_id'=>$itemID,'listing'=>1));
						$units = $this->stock->get_units($itemID);
					}
 
					#------------stock count of this item
					if($this->input->post('item_id',true) && $this->input->post('godown_id',true) && $purchase_array[0]['bill_date'] != ""){
						$stock_count = $this->stock->get_stock_count($this->input->post('godown_id',true),$this->input->post('item_id',true),$purchase_array[0]['bill_date']);
						$primary_unit = $this->stock->get_primary_unit($this->input->post('item_id',true));
					}

					$voucher_type = $this->vouchers->voucher_name($purchase_array[0]['vtype_id']);
					
					$item_groups1 = $this->item->item_group_listing();
                    $item_groups1['']  = 'select';ksort($item_groups1);

					$items[''] = 'Select';ksort($items);
					$goDowns[''] = 'Select';ksort($goDowns);

                                        $qr_cour = $this->db->select(array('cgst','sgst'))->from('other_gst')->where('specialisation','courier')->get()->row_array();              
                                        $cour_gst = (float)$qr_cour['cgst']+(float)$qr_cour['sgst'];


					#--------------cheque / dd details
					$cd_status = 1;$ccd = $cd_no = $pdc = "";
					$cheque_dd_array = $this->vouchers->cheque_data(array('columns' => array('b.cash_type','b.cd_no','b.pdc'),'conditions' => array('a.table_name' => 'dms_purchases','a.table_group_id' => $purchase_array[0]['group_id'])));
					if(!empty($cheque_dd_array))
					{
						$cd_status = 0;
						$ccd = $cheque_dd_array[0]['cash_type'];
						$cd_no = $cheque_dd_array[0]['cd_no'];
						$pdc = $cheque_dd_array[0]['pdc'];
					}

					#----------template
					$this->template->title("Edit Purhcases");
					$this->template->main_heading($this->lang->line("edit")." ".$this->lang->line("$voucher_name"));
					$this->template->breadcrumb(array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line("$voucher_name") => 'purchase/add',$this->lang->line('report') => 'purchase/report',$this->lang->line("update") => 'no_link',$this->lang->line("go-back") => array($redirect_uri)));
					$this->template->slice('dms/message');
					$this->template->slice('purchase/purchase_entry/edit',array('purchase_array' => $purchase_array,'presumptive_tax' => $presumptive_tax,'purchase_cst' => $purchase_cst,'voucher_type' => $voucher_type,'vendors' => $vendors,'payment_mode' => $purchase_array[0]['payment_mode'],'b_date'=>$b_date,'voucher_name' => $voucher_name,'payment_modes' => $payment_modes,'items' => $items,'goDowns' => $goDowns,'units' => $units,'stock_count' => $stock_count,'primary_unit' => $primary_unit['symbol'],'cd_status' => $cd_status,'ccd' => $ccd,'cd_no' => $cd_no,'pdc' => $pdc,'redirect' => $redirect,'cour_gst'=>$cour_gst,'tax_type'=>$tax_type,'groups1'=>$item_groups1));
					$this->template->other_script('purchase/purchase_script');
					$this->template->render();
				}
				else
				{
					redirect('users/logout');
				}
			}
			else
			{
				redirect('users/logout');
			}
		}
		else
		{
			 redirect('users/logout');
		}
	}

	public function delete()
	{
		#----------purchase primary key
		$uri_array = $this->uri->uri_to_assoc(3);
		if(isset($uri_array['id']))
		{
			$id = $uri_array['id'];
			unset($uri_array['id']);

			#----------redirect uri
			$redirect_uri = "purchase/report/".$this->uri->assoc_to_uri($uri_array);

			$result = $this->purchase_obj->get_purchases_gst(array('columns' => array('a.group_id','a.status','a.created_by','b.id','b.item_status'),'conditions' => array('a.id' => $id,'a.status !=' => 0,'b.item_status >' => 0)));
			if(!empty($result))
			{
				$row = $result[0];$continue = 1;
				if($row['status'] == -1){
					if($row['created_by'] != $this->session->userdata('id')){
						$continue = 0;
					}
				}
				if($continue == 1)
				{
					#----------start transaction
					$this->db->trans_start();

					if($this->purchase_obj->update_others(array('table' => 'dms_purchases','data' => array('status' => 0),'conditions' => array('id' => $id))))
					{

						#-------------deleting stock from dms_vouchers
						$this->purchase_obj->update_others(array('table' => 'dms_vouchers','data' => array('status' => 0),'conditions' => array('table_name' => 'dms_purchases','table_group_id' => $row['group_id'])));

						#-------------deleting stock from dms_voucher_banks
						$cheque_details = $this->vouchers->cheque_data(array('columns' => 'b.id','conditions' => array('table_name' => 'dms_purchases','table_group_id' => $row['group_id'])));
						if(!empty($cheque_details))
						{
							$this->purchase_obj->update_others(array('table' => 'dms_voucher_banks','data' => array('status' => 0),'conditions' => array('id' => $cheque_details[0]['id'])));
						}

						foreach($result as $key => $value)
						{
							if($value['item_status'] == 2){
								#-------------deleting purchase_items of purchase
								$this->purchase_obj->update_others(array('table' => 'dms_purchase_items1','data' => array('status' => 0),'conditions' => array('id' => $value['id'])));
							}
							else{
								#-------------deleting purchase_items of purchase order
								$this->purchase_obj->update_others(array('table' => 'dms_purchase_items1','data' => array('item_status' => -1),'conditions' => array('id' => $value['id'])));
							}

							#-------------deleting stock bal. from dms_stocks
							$this->purchase_obj->update_others(array('table' => 'dms_stocks','data' => array('status' => 0),'conditions' => array('table_id' => $value['id'],'stock_status' => 2)));
						}
						$this->message->set($this->lang->line('purchase-delete-success'));
					}
					else
					{
						$this->message->set($this->lang->line('purchase-delete-error'),'e');
					}

					#----------end transaction
					$this->db->trans_complete();
				}
				else
				{
					redirect('users/logout');
				}
			}
			redirect($redirect_uri);
		}
		redirect('users/logout');
	}

	#----------------------------------------------------------------------------------

	public function pdf(){

		$pdf_name = 'purchase';
		$pdf_contents = '';
		if(!$this->uri->segment(4)){
			echo "<script>alert('".$this->lang->line('invalid-purchase-bill')."');window.close();</script>";
		}
		$purchase_id = $this->uri->segment(4);
		if($this->if_exists('dms_purchases',array('id'=>$purchase_id,'status'=>1)) === false){
			echo "<script>alert('".$this->lang->line('invalid-purchase-bill')."');window.close();</script>";
		}
		#----------voucher type
		$vtype_id = $this->vtype;

		#----------voucher name
		$voucher_name = $this->vouchers->voucher_name($this->vtype);
		$this->load->library('My_pdf');
		$this->load->library('To_words');
		$this->my_pdf->set_tin();
		$this->my_pdf->set_header();

		#----------purchase data
		
                $purchase_array = $this->purchase_obj->get_purchases_gst(array('columns' => array('a.vtype_id','a.bill_no','a.bill_date','a.invoice_no','a.invoice_date','a.group_id','a.vendor_id','a.bill_discount_per','a.bill_discount_amt','a.bill_freight','a.other_expense','a.cess','a.courier_charge','a.courier_gst','a.tax_type','a.narration','a.payment_mode','a.cr_period','a.created_by','a.created_on','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.discount_per','b.discount_amt','b.godown_id','b.cgst','b.sgst','b.igst','b.cgst_amt','b.sgst_amt','b.igst_amt'),'conditions' => array('a.id' => $purchase_id,'a.status !=' => 0,'b.status !=' => 0,'b.item_status >' => 0)));

                $b_date = $purchase_array[0]['bill_date'];
                $tax_type = $purchase_array[0]['tax_type']; 
		if(empty($purchase_array)){
			echo "<script>alert('".$this->lang->line('invalid-purchase-bill')."');window.close();</script>";
		}else{
			$this->load->model('purchase/Purchase_vehicle_model','purchase_vehicle');

			#------------presumptive tax checking
			$presumptive_tax = $this->stock->get_tax_type();

			#------------checking cst enabled or not
			/*$purchase_cst = $this->purchase_obj->get_cst($purchase_array[0]['group_id']);*/
			$purchase_cst = 0;
			$voucher_type = $this->vouchers->voucher_name($purchase_array[0]['vtype_id']);
			$payment_mode = $this->stock->ledger_name($purchase_array[0]['payment_mode']);
			$args = array();
			$args['select'] = array('dpv.id','dpv.group_id','dpv.route_id','dpv.vehicle_id','dpv.driver_id','dpv.km','dpv.remarks','dpv.vehicle_type','dpv.vehicle_no as vehicle_number','dpv.driver_name','dp.bill_no','dp.bill_date');
			$args['conditions'] = array('dpv.group_id'=>$purchase_array[0]['group_id']);
			$args['join'] = array('dms_purchases as dp'=>'dpv.group_id=dp.group_id','route_master as rm'=>'dpv.route_id=rm.id','vehicle_master as vm'=>'dpv.vehicle_id=vm.id','users as u'=>'dpv.driver_id=u.id');
			$purchase_vehicles = $this->purchase_vehicle->get($args);

			#--------------cheque / dd details
			$cd_status = 1;$ccd = $cd_no = $pdc = "";
			$cheque_dd_array = $this->vouchers->cheque_data(array('columns' => array('b.cash_type','b.cd_no','b.pdc'),'conditions' => array('a.table_name' => 'dms_purchases','a.table_group_id' => $purchase_array[0]['group_id'])));
			if(!empty($cheque_dd_array))
			{
				$cd_status = 0;
				$ccd = $cheque_dd_array[0]['cash_type'];
				$cd_no = $cheque_dd_array[0]['cd_no'];
				$pdc = $cheque_dd_array[0]['pdc'];
			}
			$pdf_contents = $this->load->view('purchase/purchase_entry/purchase_bill_pdf',array('purchase_array' => $purchase_array,'presumptive_tax' => $presumptive_tax,'purchase_cst' => $purchase_cst,'voucher_type' => $voucher_type,'$b_date'=>$b_date,'payment_mode' => $payment_mode,'cd_status' => $cd_status,'ccd' =>$ccd,'cd_no' =>$cd_no,'pdc' => $pdc,'vehicle_details'=>$purchase_vehicles,'tax_type'=>$tax_type),true);
		}
                 ob_end_clean();
		$this->my_pdf->output($pdf_name,$pdf_contents);
	}
	#-----------------------------------------------------------------------------------


        public function purchase_registry(){

		$vtype_id = $this->vtype;
		$conditions = array('a.status' => 1);
		$like_array = array();$vnos="";

		#----------voucher name
		$voucher_name = $this->vouchers->voucher_name($this->vtype);

		#----------voucher type array
		$voucher_types = $this->vouchers->voucher_types($this->vtype);

		#----------item array
		$args['select'] = array('id','item_code','item_name');
		/*$items = $this->stock->get_stock_items($args);
		$items[''] = "Select";
		ksort($items);
		$item_id = "";*/

		#----------uri array
		$uri_array  = $this->uri->uri_to_assoc(3);

		#----------redirect
		$redirect = "";

		#----------pagination
		$this->load->library('Pagination');
		$config['per_page'] = $this->per_page();
		$config['base_url'] = base_url('purchase/purchase_registry');
		$config['uri_segment'] = 3;

		#----------dates within financial year
		$cur_date = date('Y-m-d');
		$from_date = $cur_date;
		$to_date = $cur_date;
		$cur_fiscal_yr = $this->dms->get_fiscal_year();
		if($from_date < $cur_fiscal_yr['start_date'] || $from_date > $cur_fiscal_yr['end_date'] || $to_date < $cur_fiscal_yr['start_date'] || $to_date > $cur_fiscal_yr['end_date'])
		{
			$from_date = $cur_fiscal_yr['end_date'];
			$to_date = $cur_fiscal_yr['end_date'];
		}

		#----------validation
		//$this->form_validation->set_rules('vtype_id','voucher-types','required|xss_clean');
		$this->form_validation->set_rules('from_date','From Date','required|xss_clean|valid_date');
		$this->form_validation->set_rules('to_date','To Date','required|xss_clean|valid_date');
		//$this->form_validation->set_rules('bill_no','bill-no','xss_clean|trim');
		//$this->form_validation->set_rules('item_id','item','xss_clean|trim');
		if($this->form_validation->run() === true)
		{
			//$vtype_id = $this->input->post('vtype_id',true);
			$from_date = date('Y-m-d',strtotime($this->input->post('from_date',true)));
			$to_date = date('Y-m-d',strtotime($this->input->post('to_date',true)));
			//$conditions['vtype_id'] = $vtype_id;
			$config['base_url'] .= '/vt/'.'//'.'/fdate/'.$from_date.'/tdate/'.$to_date;
			$config['uri_segment'] += 6;
			$redirect .= '/fdate/'.$from_date.'/tdate/'.$to_date;

		}
		elseif(isset($uri_array['vt']))
		{
			//$vtype_id = $uri_array['vt'];
			//$conditions['vtype_id'] = $vtype_id;
			//$config['base_url'] .= '/vt/'.'//';
			$config['uri_segment'] += 2;
			//$redirect .= '/vt/'.'//';
			if(isset($uri_array['fdate']) && isset($uri_array['tdate']))
			{
				$from_date = date('Y-m-d',strtotime($uri_array['fdate']));
				$to_date = date('Y-m-d',strtotime($uri_array['tdate']));
				$config['base_url'] .= '/fdate/'.$from_date.'/tdate/'.$to_date;
				$config['uri_segment'] += 4;
				$redirect .= '/fdate/'.$from_date.'/tdate/'.$to_date;
			}
		}

		#----------between condition
		$between = "a.bill_date between '$from_date' and '$to_date'";

		#----------total rows
		
		$config['total_rows'] = $this->purchase_obj->get_bills_registry(array('columns' => array('a.id'),'conditions' => $conditions,'between' => $between,'like' => $like_array,'numrows'=>true));

		if($config['total_rows'] == 0){
			$this->message->set($this->lang->line('no-voucher'),'i');
		}

		#----------pagination
		$offset = $this->uri->segment($config['uri_segment'],0);
		# Pagination Config Customizations
        $config['full_tag_open'] = '<ul class="pagination">';
        $config['full_tag_close'] = '</ul>';
        $config['first_link'] = 'First';
        $config['last_link'] = 'Last';
        $config['next_link'] = '&raquo;';
        $config['prev_link'] = '&laquo;';
        $config['cur_tag_open'] = '<li class="active"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
		$this->pagination->initialize($config);
		$links = $this->pagination->create_links();
		$redirect .= '/'.$offset;

		#------------presumptive tax checking
		$presumptive_tax = $this->stock->get_tax_type();

		#----------purchase report datas
		
		$purchase_array=$this->purchase_obj->get_bills_registry(array('conditions' => $conditions,'between' => $between,'like' => $like_array,'order_by'=>'a.bill_date','order'=>'DESC','limit'=>$config['per_page'],'offset'=>$offset));

		#----------template
		$this->template->title("Purchase Report");
		$this->template->main_heading($this->lang->line("$voucher_name")." ".$this->lang->line("report"));
		$this->template->breadcrumb(array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line("$voucher_name") => 'purchase/add',$this->lang->line('report') => 'purchase/report',$this->lang->line('purchase-registry') => 'no_link'));

		$this->template->slice('purchase/purchase_entry/search_purchase_registry',array('voucher_types' => $voucher_types,'vtype_id' => $vtype_id,'vnos' => $vnos,'from_date' => $from_date,'to_date' => $to_date,'rtype' => 'purchase'));
		$this->template->slice('dms/message');
		if(!empty($purchase_array))
		{
			$this->template->slice('purchase/purchase_entry/purchase_registry',array('purchase_array' => $purchase_array,'presumptive_tax' => $presumptive_tax,'from_date'=>$from_date,'offset' => $offset,'links' => $links,'redirect' => $redirect));
			$this->template->slice('dms/modals/delete_confirm');
		}
		$this->template->other_script('purchase/purchase_script');
		$this->template->render();
	}
}
?>