<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

class Purchase_barcode extends MY_Controller{

	public function __construct()
	{
		parent::__construct();
		
		$this->check_access_right();
		$this->companyID = $this->session->userdata('company_id');
		$this->branch_id = $this->session->userdata('under_id');
		#---------------- Checking Financial year is enabled / closed-----------------#
		$method_array = array('add');
		fiscal_status($this->uri->segment(2),$method_array,"purchase/report");
		
		$this->load->model('purchase/Purchase_model','purchase_obj');
		$this->load->model('vouchers/Voucher_model','vouchers');
		$this->load->model('products/Manufacture_model','manu');		
        $this->load->model('godown/Godown_model','godown');
        $this->load->model('products/Unit_model','unit');
        $this->load->model('products/Item_model','item');
		$this->load->library(array('Stock','My_excel'));
		#----------voucher type
		$this->vtype = 5;
		
		$flag=0;
	}
	
	public function add()
	{
		#----------voucher type
		$vtype_id = $this->vtype;

		#----------voucher type array
		$voucher_types = $this->vouchers->voucher_types($this->vtype);

		#----------voucher name
		$voucher_name = $this->vouchers->voucher_name($this->vtype);

		#-----------purchase cst checking details
		$purchase_cst = $this->stock->get_constant(array('purchase_cst'));

		#------------presumptive tax checking
		$presumptive_tax = $this->stock->get_tax_type();

		#------------cess %
		$cess = $this->stock->get_cess();

		#-----------purchase date and next bill no
		$rules = "callback_bill_no_exists";
		$disabled = "";
		$result_array = $this->purchase_obj->next_bill_no($this->vtype);
		$vtype_id = $result_array['vtype_id'];
		$voucher_no = $result_array['bill_no'];
		$voucher_date = $result_array['bill_date'];
		if($result_array['vstatus'])
		{
			#-----------redirection if purchase_order / receipt_note / purchase_request conversion is pending
			if($result_array['p_status'] == 2){
				redirect("order_to_purchase/po_purchase/".$result_array['pid']);
			}
			/*elseif($result_array['p_status'] == 3){
				redirect("receipt_to_purchase/purchase/".$result_array['pid']);
			}*/
			elseif($result_array['p_status'] == 4){
				$this->message->set($this->lang->line('pending-purchase-exists'),'e');
				redirect("sales_to_purchase/add");
			}
			$group_id = $result_array['group_id'];
			$voucher_details = $this->dms->get_data(array('table' => 'dms_vouchers as a','join' => array('table' => 'dms_purchases as b','on' => 'a.table_group_id = b.group_id'),'columns' => 'b.id','conditions' => array('a.table_name' => 'dms_purchases','a.table_group_id' => $group_id)));
		/*	if(!empty($voucher_details)){
				redirect("purchase/update/id/".$voucher_details[0]['id']);
			} */
			$disabled = "readonly";
			$rules = "callback_bill_no_exists[$vtype_id.$group_id]";

			#------------checking cst enabled or not
			/*$cst_status = $this->purchase_obj->get_cst($group_id);*/
			$cst_status = 0;
			if($cst_status){
				$purchase_cst = $cst_status;
			}
		}
		else
		{
			$group_id = $this->stock->get_group_id('dms_purchase_items1');
		}

		#-------------adding data to purchase temp
		if(isset($_POST['btn_add']))
		{
		    #-----------validation
			$this->form_validation->set_rules('vtype_id','lang:voucher-types','required|xss_clean');
			//$this->form_validation->set_rules('purchase[bill_no]','lang:bill-no',"required|xss_clean|is_natural_no_zero|".$rules);
			$this->form_validation->set_rules('purchase[bill_no]','lang:bill-no',"required|xss_clean|is_natural_no_zero");
			$this->form_validation->set_rules('purchase[bill_date]','lang:bill-date','required|xss_clean|valid_date');
			$this->form_validation->set_rules('purchase[invoice_no]','lang:invoice-no','required|xss_clean');
			$this->form_validation->set_rules('purchase[invoice_date]','lang:invoice-date','required|xss_clean|is_date');
			$this->form_validation->set_rules('purchase[vendor_id]','lang:vendor','required|xss_clean');
			
			#-----------adding temporary data
			if($this->form_validation->run('btn_add') === true)
			{
				$item_array = $this->input->post(NULL,true);
                $sal_tem =  $this->input->post('purchase',true);
                
                unset($item_array['purchase']);
				unset($item_array['vtype_id']);
				unset($item_array['btn_add']);
                unset($item_array['new_item']);  

				$item_array['group_id'] = $group_id;
				$item_array['status'] = -1;
				$item_array['item_status'] = 2;//purchase only items
				$bl_date = $sal_tem['bill_date'];
				
				for($i=1;$i<=10;$i++)
                {
                    $result_array = $this->purchase_obj->next_bill_no($this->vtype);
                    $item_code = $item_array['code'.$i];
                              
                    if($item_code!=null )  
                    { 
                        $itemarray = array();
                        $data_salestemp = array();
                        
                        $qry_godown = $this->db->select('id')->from('godown_master')->where(array('branch_id' => $this->branch_id,'status'=>1))->get()->row_array();
		                $godown_id = $qry_godown['id'];
                                   
                        $item_id = $this->stock->get_item_datas($item_code);
                        $item_unit = $this->stock->get_unit_id($item_id); 
                                    
                        $itemarray['item_id'] = $item_id;
                                    
                        $cgst = $this->stock->get_item_cgst($itemarray['item_id']);
					    $sgst = $this->stock->get_item_sgst($itemarray['item_id']);
					    $igst = $this->stock->get_item_igst($item_array['item_id']);
					    
					    $purchase_temp_item_result = $this->purchase_obj->get_purchases_gst(array('columns' => array('b.id'),'conditions' => array('b.group_id' => $group_id,'item_id' => $item_array['item_id'],'godown_id' => $item_array['godown_id'],'unit_id' => $item_array['unit_id'],'a.status !=' => 0,'b.status !=' => 0,'b.item_status >' => 0),'numrows' => true));

        				if($purchase_temp_item_result == 0)
        				{
        				    $itemarray['group_id'] = $item_array['group_id'];
                            $itemarray['qty'] = $item_array['qty'.$i];
                            $itemarray['unit_id'] = $item_unit;
                            $itemarray['rate'] = $item_array['rate'.$i];
                            $itemarray['amount'] = (float)$itemarray['rate'] * (float)$itemarray['qty'];
                            $itemarray['discount_per'] = 0;
                            $itemarray['discount_amt'] = 0;
                            if($sal_tem['tax_type'] == '0')
					        {
                                $itemarray['cgst'] = $cgst;
        						$itemarray['sgst'] = $sgst;
        						$itemarray['cgst_amt'] = (((float)$itemarray['amount']-(float)$itemarray['discount_amt']) * (float)$cgst) / 100;
        						$itemarray['sgst_amt'] = (((float)$itemarray['amount']-(float)$itemarray['discount_amt']) * (float)$sgst) / 100;
					        }
					        else
        					{
        						$itemarray['igst'] = $igst;
        						$itemarray['igst_amt'] = (((float)$itemarray['amount']-(float)$itemarray['discount_amt']) * (float)$igst) / 100;      
        					}
                            
                            $itemarray['godown_id'] = $godown_id;
                            $itemarray['status'] = -1;
                            $itemarray['item_status'] = 2;

						    #----------start transaction
        					$this->db->trans_start();
        
        					#-----------bill date and next bill no
        					if($result_array['vstatus'] == 0)//data not in dms_purchases
        					{
        						$purchase_temp_array = $this->input->post('purchase',true);
        						$purchase_temp_array = array_filter($purchase_temp_array);
        						$purchase_temp_array['vtype_id'] = $this->input->post('vtype_id',true);
        						$purchase_temp_array['branch_id'] = $this->session->userdata('under_id');
        						$purchase_temp_array['group_id'] = $group_id;
        						$purchase_temp_array['bill_date'] = date('Y-m-d',strtotime($purchase_temp_array['bill_date']));
        						$voucher_date = $purchase_temp_array['bill_date'];
        						$purchase_temp_array['invoice_date'] = date('Y-m-d',strtotime($purchase_temp_array['invoice_date']));
        						$purchase_temp_array['status'] = -1;
        						$this->purchase_obj->insert("dms_purchases",$purchase_temp_array);
        					}
        					//print_r($itemarray);
        					$purchase_items_id = $this->purchase_obj->insert("dms_purchase_items1",$itemarray);
					
        					if($purchase_items_id)
        					{
        						#--------------adding temporary stock balance in dms_stocks
        						$stock_bal_temp = $this->stock->unit_conversion($item_array['item_id'],$item_array['unit_id'],$item_array['qty'],$item_array['rate'],$item_array['amount']);
        						if($stock_bal_temp)
        						{
        							$this->purchase_obj->insert('dms_stocks',array('company_id' => $this->session->userdata('company_id'),'branch_id' => $this->session->userdata('under_id'),'godown_id' => $item_array['godown_id'],'item_id' => $item_array['item_id'],'qty' => $stock_bal_temp['qty'],'unit_id' => $stock_bal_temp['primary_unit'],'rate' => $stock_bal_temp['rate'],'amount' => $stock_bal_temp['amount'],'stock_date' => $voucher_date,'stock_status' => 2,'table_group_id' => $group_id,'table_id' => $purchase_items_id,'status' => -1));
        						}
        						$this->message->set($this->lang->line('purchase-add-success'));
        					}
                            else
        					{
        						$this->message->set($this->lang->line('purchase-add-error'),'e');
        					}
        
        					#----------end transaction
        					$this->db->trans_complete();
        					
        				}
                    }
                }
			    
			    redirect('purchase_barcode/add');
			}
		}
    	
    	#------------saving purchase voucher
		if(isset($_POST['btn_save']))
		{
			#-----------validation
			$this->form_validation->set_rules('payment_mode','lang:payment-mode','required|xss_clean');
			if($this->input->post('payment_mode',true) == 2)
			{
				$this->form_validation->set_rules('credit_period','lang:credit-period','required|xss_clean|is_natural');
			}
			elseif($this->input->post('payment_mode',true) > 2)
			{
				$this->form_validation->set_rules('ccd','lang:transaction-type','required|xss_clean');
				$this->form_validation->set_rules('cd_no','lang:cd-no','required|xss_clean|max_length[64]');
				$this->form_validation->set_rules('cheque_date','lang:cheque-date',"required|xss_clean|is_date|check_date[$voucher_date.>=]");
			}
			$this->form_validation->set_rules('remarks','lang:remarks','xss_clean');
			$this->form_validation->set_rules('freight','lang:freight','xss_clean|greater_or_equal[0]|less_than[100000000]');
			$this->form_validation->set_rules('other_expense','lang:other-expense','xss_clean|greater_or_equal[0]|less_than[100000000]');
			$this->form_validation->set_rules('bill_discount_per','lang:discount %','xss_clean|greater_or_equal[0]|less_or_equal[100]');
			$this->form_validation->set_rules('bill_discount_amt','lang:discount','xss_clean|greater_or_equal[0]|less_than[100000000]');

			#-----------saving data
			if($this->form_validation->run('btn_save') === true)
			{
				$narration = $this->input->post('remarks',true);
				$payment_mode = $this->input->post('payment_mode',true);
				$freight = $this->input->post('freight',true);
				$other_expense = $this->input->post('other_expense',true);
				$bill_discount_amt = $this->input->post('bill_discount_amt',true);
                $cour_charge = $this->input->post('courier_charge',true);
                $cour_gst = $this->input->post('cour_gst_amt',true);

				$purchase_entry_array=array('bill_discount_per' => $this->input->post('bill_discount_per',true),'bill_discount_amt' => $bill_discount_amt,'bill_freight' => $freight,'other_expense' => $other_expense,'cess' => $cess,'courier_charge'=>$cour_charge,'courier_gst'=>$cour_gst,'narration' => $narration,'payment_mode' => $payment_mode,'cr_period' => $this->input->post('credit_period',true),'status' => 1);
                         
                $purchase_entry_check = $this->purchase_obj->get_purchases_gst(array('columns' => array('a.vtype_id','a.bill_no','a.bill_date','a.vendor_id'),'conditions' => array('a.group_id' => $group_id,'a.status !=' => 0,'b.item_status >' => 0)));
                           
				if($purchase_entry_check)
				{
					$bill_date = $purchase_entry_check[0]['bill_date'];
					$vtype_id = $purchase_entry_check[0]['vtype_id'];
					$bill_no = $purchase_entry_check[0]['bill_no'];
					$vendor_id = $purchase_entry_check[0]['vendor_id'];

					#----------start transaction
					$this->db->trans_start();

					if($this->purchase_obj->update(array('table' => 'dms_purchases','data' => $purchase_entry_array,'conditions' => array('group_id' => $group_id))))
					{
                        $this->purchase_obj->update(array('table' => 'dms_purchase_items1','data' => array('status' => 1),'conditions' => array('group_id' => $group_id,'status !=' => 0,'item_status >' => 0)));
                                           
						#-------------adding bill to dms_vouchers
						$voucher_status = 1;
						$voucher_amount = $this->input->post('grand_total',true);
						$round_off_amount = $this->input->post('round_off_amount',true);
						$vat_amount = $this->input->post('vat_total',true);
						$cess_amount = $this->input->post('cess_total',true);
                                                $cour_charge = $this->input->post('tot_cour_amt',true);
						if($payment_mode > 2)
						{
							$bill_date_time = strtotime($bill_date);
							$cheque_date = date('Y-m-d',strtotime($this->input->post('cheque_date',true)));
							$cheque_date_time = strtotime($cheque_date);
							if($this->input->post('ccd',true) == 1 && $cheque_date_time > $bill_date_time)
							{
								$voucher_status = 3;
							}
						}
						elseif($payment_mode == 2)
						{
							if($this->dms->branch_type())
							{
								$vendor_ledger_id = $this->dms->get_data(array('table' =>'item_manufacturer_master','columns' => 'ledger_id','conditions' => array('id' => $vendor_id)));
								$payment_mode = $vendor_ledger_id[0]['ledger_id'];
							}
							else
							{
								$vendor_ledger_id = $this->dms->get_data(array('table' =>'branch_master','columns' => 'ledger_id','conditions' => array('id' => $vendor_id)));
								$payment_mode = $vendor_ledger_id[0]['ledger_id'];
							}
						}
						$voucher_group_id = $this->stock->get_group_id('dms_vouchers');
						(float)$voucher_amount -= (float)$bill_discount_amt;
						(float)$voucher_amount += (float)$round_off_amount;
						$voucher_array = array('company_id' => $this->session->userdata('company_id'),'branch_id' => $this->session->userdata('under_id'),'group_id' => $voucher_group_id,'vtype_id' => $vtype_id,'vno' => $bill_no,'vorder_no' => 1,'vdate' => $bill_date,'dr_ledger' => 3,'cr_ledger' => $payment_mode,'vamount' => $voucher_amount,'narration' => $narration,'table_name' => 'dms_purchases','table_group_id' => $group_id,'status' => $voucher_status);
						$voucher_data = $this->dms->get_data(array('table' =>'dms_vouchers','columns' => 'id','conditions' => array('table_name' => 'dms_purchases','table_group_id' => $group_id),'numrows' => true));
						if($voucher_data == 0)
						{
							$voucher_success = $this->purchase_obj->insert('dms_vouchers',$voucher_array);
							if($voucher_success)
							{
								#-----------VAT
								$voucher_array['dr_ledger'] = 11;
								$voucher_array['vorder_no'] = 2;
								$voucher_array['vamount'] = $vat_amount;
								$this->purchase_obj->insert('dms_vouchers',$voucher_array);
								#-----------CESS
								$voucher_array['dr_ledger'] = 15;
								$voucher_array['vorder_no'] = 3;
								$voucher_array['vamount'] = $cess_amount;
								$this->purchase_obj->insert('dms_vouchers',$voucher_array);
								#-----------Freight
								$voucher_array['dr_ledger'] = 13;
								$voucher_array['vorder_no'] = 4;
								$voucher_array['vamount'] = $freight;
								$this->purchase_obj->insert('dms_vouchers',$voucher_array);
								#-----------Other Expense
								$voucher_array['dr_ledger'] = 14;
								$voucher_array['vorder_no'] = 5;
								$voucher_array['vamount'] = $other_expense;
								$this->purchase_obj->insert('dms_vouchers',$voucher_array);
 
                                $voucher_array['dr_ledger'] = 19;
								$voucher_array['vorder_no'] = 6;
								$voucher_array['vamount'] = $cour_charge;
								$this->purchase_obj->insert('dms_vouchers',$voucher_array);

								if($payment_mode > 2)
								{
									$this->purchase_obj->insert('dms_voucher_banks',array('group_id' => $voucher_group_id,'cash_type' => $this->input->post('ccd',true),'cd_no' => $this->input->post('cd_no',true),'pdc' => $cheque_date,'vdate' => $bill_date));
								}
							}
						}

						#-------------enabling temporarily added stocks in dms_stocks
                                            
                        $purchase_items_array = $this->purchase_obj->get_purchase_itemss(array('columns' => array('id'),'conditions' => array('group_id' => $group_id,'status' => 1,'item_status >' => 0)));
                                                
						foreach($purchase_items_array as $key => $value)
						{
							$this->purchase_obj->update_others(array('table' => 'dms_stocks','data' => array('status' => 1),'conditions' => array('stock_status' => 2,'table_id' => $value['id'])));
						}
						$this->message->set($this->lang->line('purchase-save-success'));
					}
					else{
						$this->message->set($this->lang->line('purchase-save-error'),'e');
					}

					#----------transaction completed
					$this->db->trans_complete();
				}
				else
				{
					$this->message->set($this->lang->line('purchase-save-error'),'e');
				}
				redirect('purchase_barcode/add');
			}
		}
        
        $branch_det = $this->db->select(array('id','branch_name','ledger_id','area_id'))->from('branch_master')->where('id',$this->branch_id)->get()->row_array();
        $branch_area = $branch_det['area_id'];

		#------------vendor details
		$vendors = $this->stock->get_vendors();
		$vendor_id = "";

        $itemcodes = $this->item->itemcode(); 
        
		#------------item details / unit details / godown details
		$units = $items = $goDowns = array();
		$units[''] = "Select";
		$args['select'] = array('id','item_code','item_name');
		$items = $this->stock->get_stock_items($args);
		if(empty($items)){
			$this->message->set($this->lang->line('no-items-found'),'i');
		}
		if($this->input->post('item_id',true)){
			$itemID = $this->input->post('item_id',true);
			$goDowns = $this->stock->get_item_godowns(array('item_id'=>$itemID,'listing'=>1));
			$units = $this->stock->get_units($itemID);
		}
           
		#------------purchase temp data
		$purchase_temp_data = array();
		$price_list_id = $stock_count = $primary_unit['symbol'] = $invoice_no = "";
		$invoice_date = date('Y-m-d');
		if($result_array['vstatus'])
		{
            $purchase_temp_data = $this->purchase_obj->get_purchases_gst(array('columns' => array('a.group_id','a.bill_date','a.vendor_id','a.invoice_no','a.invoice_date','a.tax_type','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.discount_per','b.discount_amt','b.godown_id','b.cgst','b.sgst','b.igst','b.cgst_amt','b.sgst_amt','b.igst_amt'),'conditions' => array('a.created_by' => $this->session->userdata('id'),'vtype_id' => $vtype_id,'bill_no' => $voucher_no,'a.status =' => -1,'b.status !=' => 0)));
                       
			$vendor_id = $purchase_temp_data[0]['vendor_id'];
			$invoice_no = $purchase_temp_data[0]['invoice_no'];
			$invoice_date = $purchase_temp_data[0]['invoice_date'];

            $b_date = $purchase_temp_data[0]['bill_date'];
            $tax_type = $purchase_temp_data[0]['tax_type'];
		}
		else
		{
			$purchase_array = $this->input->post('purchase',true);

			#------------stock count of this item
			if($this->input->post('item_id',true) && $this->input->post('godown_id',true) && $purchase_array['bill_date'] != ""){
				$stock_count = $this->stock->get_stock_count($this->input->post('godown_id',true),$this->input->post('item_id',true),$purchase_array['bill_date']);
				$primary_unit = $this->stock->get_primary_unit($this->input->post('item_id',true));
                    
			}
		}
                

                $units1 = $this->unit->listing();
                $item_groups1 = $this->item->item_group_listing();
                $godowns1 = $this->godown->listing();


		$items[''] = 'Select';ksort($items);
		$goDowns[''] = 'Select';ksort($goDowns);
		$vendors[''] = 'Select';ksort($vendors);
                $item_groups1['']  = 'select';ksort($item_groups1);
                ksort($godowns1);
 
                $qr_cour = $this->db->select(array('cgst','sgst'))->from('other_gst')->where('specialisation','courier')->get()->row_array();              
                $cour_gst = $qr_cour['cgst']+$qr_cour['sgst'];

		#------------payment modes
		$payment_mode = $this->stock->payment_modes();

		#------------cheque / dd details
		$cd_status = 1;
		if($this->input->post('payment_mode',true) > 2){
			$cd_status = 0;
		}

		#------------template
		$this->template->title("New Purchase Voucher");
		$this->template->main_heading($this->lang->line("$voucher_name"));
		$this->template->breadcrumb(array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line("$voucher_name") => 'no_link',$this->lang->line('report') => 'purchase/report'));
		$this->template->slice('dms/message');
		$this->template->slice('purchase/barcode/add',array('voucher_types' => $voucher_types,'voucher_type' => $vtype_id,'voucher_name' => $voucher_name,'voucher_no' => $voucher_no,'voucher_date' => $voucher_date,'b_date'=>$b_date,'vendors' => $vendors,'items' => $items,'units' => $units,'goDowns' => $goDowns,'purchase_temp_status' =>$result_array['vstatus'],'purchase_temp_data' => $purchase_temp_data,'vendor_id' => $vendor_id,'invoice_no' => $invoice_no,'invoice_date' => $invoice_date,'purchase_cst' => $purchase_cst,'presumptive_tax' => $presumptive_tax,'cess' => $cess,'payment_mode' => $payment_mode,'disabled' => $disabled,'stock_count' => $stock_count,'primary_unit' => $primary_unit['symbol'],'cd_status' => $cd_status,'cour_gst'=>$cour_gst,'tax_type'=>$tax_type,'units1'=>$units1,'groups1'=>$item_groups1,'godowns1'=>$godowns1,'itemcodes'=>$itemcodes,'branch_area'=>$branch_area));
		$this->template->other_script('barcode/purchase');
		$this->template->render();
				
	}
	
}