<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

class Receipt_to_purchase extends MY_Controller{

	public function __construct()
	{
		parent::__construct();

		$this->check_access_right();

		#---------------- Checking Financial year is enabled / closed-----------------#
		$method_array = array('purchase');
		fiscal_status($this->uri->segment(2),$method_array,"receipt_note/report");
		#---------------- Checking Financial year is enabled / closed-----------------#

		$this->load->model('purchase/Receipt_note_model','receipt');
		$this->load->model('vouchers/Voucher_model','vouchers');
		$this->load->library(array('Stock','Purchase_lib'));

		#----------voucher type
		$this->vtype = 5;
	}

	public function purchase()
	{
		#----------delivery primary key
		if($this->uri->segment(4))
		{
			$receipt_id = $this->uri->segment(4);

			#----------receipt note data
			$receipt_array = $this->receipt->get_purchases(array('columns' => array('a.id','a.branch_id','a.bill_date','a.invoice_no','a.invoice_date','a.group_id','a.vendor_id','a.bill_discount_per','a.bill_discount_amt','a.bill_freight','a.other_expense','a.cess','a.narration','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.discount_per','b.discount_amt','b.vat_amt','b.cst','b.godown_id'),'conditions' => array('a.id' => $receipt_id,'a.r_status' => 0,'b.item_status >' => 0,'b.status !=' => 0)));
			if(!empty($receipt_array))
			{
				$group_id = $receipt_array[0]['group_id'];

				#----------checking group_id exists for redirection
				$redirection_uri = $this->purchase_lib->rp_group_id_exists($group_id);
				if($redirection_uri)
				{
					redirect($redirection_uri);
				}
				else
				{
					#----------bill details
					$bill_details = $receipt_array[0];

					#----------voucher type array
					$voucher_types = $this->vouchers->voucher_types($this->vtype);
					$bill_prefix = $this->stock->get_voucher_prefix($this->vtype);
					#----------voucher name
					$voucher_name = $this->vouchers->voucher_name($this->vtype);

					#----------next bill no
					$voucher_no = $this->receipt->next_bill($this->vtype);

					#-----------validation
					$this->form_validation->set_rules('vtype_id','lang:voucher-types','required|xss_clean');
					$this->form_validation->set_rules('bill_no','lang:bill-no',"required|xss_clean|is_natural_no_zero|callback_bill_no_exists");
					$this->form_validation->set_rules('bill_date','lang:bill-date',"required|xss_clean|valid_date|check_date[$bill_details[bill_date].>=]");
					$this->form_validation->set_rules('payment_mode','lang:payment-mode','required|xss_clean');
					if($this->input->post('payment_mode',true) == 2){
						$this->form_validation->set_rules('credit_period','lang:credit-period','required|xss_clean|is_natural');
					}elseif($this->input->post('bill_date',true) && $this->input->post('payment_mode',true) > 2){
						$bill_date1 = date('Y-m-d',strtotime($this->input->post('bill_date',true)));
						$this->form_validation->set_rules('ccd','lang:cash-cheque-dd','required|xss_clean');
						$this->form_validation->set_rules('cd_no','lang:cd-no','required|xss_clean|max_length[64]');
						$this->form_validation->set_rules('cheque_date','lang:cheque-date',"required|xss_clean|is_date|check_date[$bill_date1.>=]");
					}
					$this->form_validation->set_rules('remarks','lang:remarks','xss_clean');
					$this->form_validation->set_rules('freight','lang:freight','xss_clean|greater_or_equal[0]|less_than[100000000]');
					$this->form_validation->set_rules('other_expense','lang:other-expense','xss_clean|greater_or_equal[0]|less_than[100000000]');
					$this->form_validation->set_rules('bill_discount_per','lang:discount %','xss_clean|greater_or_equal[0]|less_or_equal[100]');
					$this->form_validation->set_rules('bill_discount_amt','lang:discount','xss_clean|greater_or_equal[0]|less_than[100000000]');

					#-----------saving data
					if($this->form_validation->run() === true)
					{
						$vtype_id = $this->input->post('vtype_id',true);
						$bill_no = $this->input->post('bill_no',true);
						$bill_date = date('Y-m-d',strtotime($this->input->post('bill_date',true)));
						$payment_mode = $this->input->post('payment_mode',true);
						$narration = $this->input->post('remarks',true);
						$bill_discount_amt = $this->input->post('bill_discount_amt',true);
						$freight = $this->input->post('freight',true);
						$other_expense = $this->input->post('other_expense',true);

						$purchase_array = array('vtype_id' => $vtype_id,'branch_id' => $bill_details['branch_id'],'bill_no' => $bill_no,'bill_date' => $bill_date,'invoice_no' => $bill_details['invoice_no'],'invoice_date' => $bill_details['invoice_date'],'group_id' => $bill_details['group_id'],'pid' => $bill_details['id'],'p_status' => 3,'vendor_id' => $bill_details['vendor_id'],'bill_discount_per' => $this->input->post('bill_discount_per',true),'bill_discount_amt' => $bill_discount_amt,'bill_freight' => $freight,'other_expense' => $other_expense,'cess' => $bill_details['cess'],'narration' => $narration,'payment_mode' => $payment_mode,'cr_period' => $this->input->post('credit_period',true),'status' => 1);

						#----------start transaction
						$this->db->trans_start();

						if($this->receipt->insert('dms_purchases',$purchase_array)){
							$this->receipt->update_others(array('table' => 'dms_receipt_notes','data' => array('r_status' => 1),'conditions' => array('id' => $bill_details['id'])));
							$this->message->set($this->lang->line('purchase-save-success'));
						}else{
							$this->message->set($this->lang->line('purchase-save-error'),'e');
						}

						#-------------adding bill to dms_vouchers
						$voucher_status = 1;
						$voucher_amount = $this->input->post('grand_total',true);
						$round_off_amount = $this->input->post('round_off_amount',true);
						$vat_amount = $this->input->post('vat_total',true);
						$cess_amount = $this->input->post('cess_total',true);
						if($payment_mode > 2)
						{
							$bill_date_time = strtotime($bill_date);
							$cheque_date = date('Y-m-d',strtotime($this->input->post('cheque_date',true)));
							$cheque_date_time = strtotime($cheque_date);
							if($this->input->post('ccd',true) == 1 && $cheque_date_time > $bill_date_time)
							{
								$voucher_status = 3;
							}
						}elseif($payment_mode == 2){
							if($this->dms->branch_type())
							{
								$vendor_ledger_id = $this->dms->get_data(array('table' =>'item_manufacturer_master','columns' => 'ledger_id','conditions' => array('id' => $bill_details['vendor_id'])));
								$payment_mode = $vendor_ledger_id[0]['ledger_id'];
							}
							else
							{
								$vendor_ledger_id = $this->dms->get_data(array('table' =>'branch_master','columns' => 'ledger_id','conditions' => array('id' => $bill_details['vendor_id'])));
								$payment_mode = $vendor_ledger_id[0]['ledger_id'];
							}
						}
						$voucher_group_id = $this->stock->get_group_id('dms_vouchers');
						$voucher_amount -= $bill_discount_amt;
						$voucher_amount += $round_off_amount;
						$voucher_array = array('company_id' => $this->session->userdata('company_id'),'branch_id' => $this->session->userdata('under_id'),'group_id' => $voucher_group_id,'vtype_id' => $vtype_id,'vno' => $bill_no,'vorder_no' => 1,'vdate' => $bill_date,'dr_ledger' => 3,'cr_ledger' => $payment_mode,'vamount' => $voucher_amount,'narration' => $narration,'table_name' => 'dms_purchases','table_group_id' => $bill_details['group_id'],'status' => $voucher_status);
						$voucher_data = $this->dms->get_data(array('table' =>'dms_vouchers','columns' => 'id','conditions' => array('table_name' => 'dms_purchases','table_group_id' => $bill_details['group_id']),'numrows' => true));
						if($voucher_data == 0)
						{
							$voucher_success = $this->receipt->insert('dms_vouchers',$voucher_array);
							if($voucher_success)
							{
								#-----------VAT
								$voucher_array['dr_ledger'] = 11;
								$voucher_array['vorder_no'] = 2;
								$voucher_array['vamount'] = $vat_amount;
								$this->receipt->insert('dms_vouchers',$voucher_array);
								#-----------CESS
								$voucher_array['dr_ledger'] = 15;
								$voucher_array['vorder_no'] = 3;
								$voucher_array['vamount'] = $cess_amount;
								$this->receipt->insert('dms_vouchers',$voucher_array);
								#-----------Freight
								$voucher_array['dr_ledger'] = 13;
								$voucher_array['vorder_no'] = 4;
								$voucher_array['vamount'] = $freight;
								$this->receipt->insert('dms_vouchers',$voucher_array);
								#-----------Other Expense
								$voucher_array['dr_ledger'] = 14;
								$voucher_array['vorder_no'] = 5;
								$voucher_array['vamount'] = $other_expense;
								$this->receipt->insert('dms_vouchers',$voucher_array);

								if($payment_mode > 2)
								{
									$this->receipt->insert('dms_voucher_banks',array('group_id' => $voucher_group_id,'cash_type' => $this->input->post('ccd',true),'cd_no' => $this->input->post('cd_no',true),'pdc' => $cheque_date,'vdate' => $bill_date));
								}
							}
						}

						#----------transaction completed
						$this->db->trans_complete();

						redirect('purchase/report');
					}

					#------------presumptive tax checking
					$presumptive_tax = $this->stock->get_tax_type();

					#------------checking cst enabled or not
					$purchase_cst = $this->receipt->get_cst($bill_details['group_id']);

					$vendor_name = $this->stock->vendor_name($bill_details['vendor_id']);
					$voucher_type = $this->vouchers->voucher_name($this->vtype);

					#------------payment modes
					$payment_modes = $this->stock->payment_modes();

					#------------cheque / dd details
					$cd_status = 1;
					if($this->input->post('payment_mode',true) > 2){
						$cd_status = 0;
					}

					#------------template
					$this->template->title("New $voucher_name Voucher");
					$this->template->main_heading($this->lang->line("$voucher_name"));
					$this->template->breadcrumb(array($this->lang->line("$voucher_name") => 'no_link',$this->lang->line('report') => 'purchase/report'));
					$this->template->slice('dms/message');
					$this->template->slice('purchase/receipt_note/purchase',array('purchase_array' => $receipt_array,'vendor_name' => $vendor_name,'presumptive_tax' => $presumptive_tax,'purchase_cst' => $purchase_cst,'voucher_name' => $voucher_name,'voucher_types' => $voucher_types,'voucher_type' => $voucher_type,'voucher_no' => $voucher_no,'payment_modes' => $payment_modes,'cd_status' => $cd_status,'bill_prefix'=>$bill_prefix));
					$this->template->other_script('purchase/purchase');
					$this->template->render();
				}
			}
			else{
				redirect('users/logout');
			}
		}
		else{
			redirect('users/logout');
		}
	}

	public function bill_no_exists($bill_no)
	{
		$this->load->model('purchase/Purchase_model','purchase');
		$vtype_id = $this->input->post('vtype_id',true);
		$row = $this->purchase->get_bills(array('columns' => array('id'),'conditions' => array('vtype_id' => $vtype_id,'bill_no' => $bill_no,'status !=' => 0),'numrows' => true));
		if($row == 0){
			return true;
		}
		return false;
	}
}
?>