<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

class Rejection_in extends MY_Controller{

	var $companyID,$branchID,$createdBY;
	public function __construct()
	{
		parent::__construct();

		$this->check_access_right();

		#---------------- Checking Financial year is enabled / closed-----------------#
		$method_array = array('add','delete_temp','update_temp','update','delete');
		fiscal_status($this->uri->segment(2),$method_array,"rejection_in/report");
		#---------------- Checking Financial year is enabled / closed-----------------#

		$this->load->model('sales/Rejection_in_model','rejection_in');
		$this->load->model('vouchers/Voucher_model','vouchers');
		$this->load->library(array('Stock'));

		$this->companyID = $this->session->userdata('company_id');
		$this->branchID = $this->session->userdata('under_id');
		$this->createdBY = $this->session->userdata('id');

		#-----------checking branch_type
		$this->branch_status = 0;
		if($this->dms->branch_type()){
			$this->branch_status = 1;
		}

		#----------voucher type
		$this->vtype = 11;
	}

	public function add()
	{
		#----------loading models
		$this->load->model('designations/Designation_master_model','desig');
		$this->load->model('customers/Customer_type_model','customer_type');

		$vtype_id = $this->vtype;
		$voucher_types = $this->vouchers->voucher_types($this->vtype);
		$bill_prefix = $this->stock->get_voucher_prefix($this->vtype);
		$voucher_name = $this->vouchers->voucher_name($this->vtype);
		$sales_cst = $this->stock->get_constant(array('sales_cst'));
		$presumptive_tax = $this->stock->get_tax_type();
		$cess = $this->stock->get_cess();

		$Ckargs = array();
		$Ckargs['columns'] = array('id','r_status');
		$Ckargs['conditions'] = array('created_by'=>$this->createdBY,'status'=>-1,'branch_id'=>$this->branchID);

		$sales_return_temp = $this->rejection_in->get_bills($Ckargs);

		if(!empty($sales_return_temp)){
			if($sales_return_temp[0]['r_status'] == 1){
				$this->message->set($this->lang->line('pending-sales-return-exists'),'e');
				redirect('rejection_in_to_sales_return/sales_return/');
			}
		}

		#-----------sales_return date and next bill no
		$rules = "callback_bill_no_exists";
		$disabled = "";
		$result_array = $this->rejection_in->next_bill_no($this->vtype);
		$vtype_id = $result_array['vtype_id'];
		$voucher_no = $result_array['bill_no'];
		$voucher_date = $result_array['bill_date'];
		if($result_array['vstatus']){

			$disabled = "readonly";
			$group_id = $result_array['group_id'];
			$rules = "callback_bill_no_exists[$vtype_id.$group_id]";
			#------------checking cst enabled or not
			$cst_status = $this->rejection_in->get_cst($group_id);
			if($cst_status){
				$sales_cst = $cst_status;
			}
		}else{
			$group_id = $this->stock->get_group_id('dms_sales_return_items1');
		}

		#-------------adding data to sales_return temp
		if(isset($_POST['btn_add'])){
			#-----------validation
			$this->form_validation->set_rules('vtype_id','lang:voucher-types','required|xss_clean');
			$this->form_validation->set_rules('bill_no','lang:bill-no',"required|xss_clean|is_natural_no_zero|".$rules);
			$this->form_validation->set_rules('bill_date','lang:bill-date','required|xss_clean|valid_date');
			$this->form_validation->set_rules('customer_type','lang:customer-type','required|xss_clean');
			if($this->input->post('customer_type',true)){
				$custType = $this->input->post('customer_type',true);
			}
			$this->form_validation->set_rules('customer_id','lang:customer-name','required|xss_clean');
			$this->form_validation->set_rules('item_id','lang:item-name','required|xss_clean');
			$this->form_validation->set_rules('godown_id','lang:godown','required|xss_clean');
			$this->form_validation->set_rules('cst','lang:cst','xss_clean|greater_or_equal[0]|less_or_equal[100]');
		//	$this->form_validation->set_rules('qty','lang:quantity','required|xss_clean|greater_than[0]|less_than[100000000]|callback_check_bill_qty');
			$this->form_validation->set_rules('unit_id','lang:unit','required|xss_clean');
			$this->form_validation->set_rules('rate','lang:rate','required|xss_clean|greater_or_equal[0]|less_than[100000000]');
			$this->form_validation->set_rules('amount','lang:amount','xss_clean|required|greater_or_equal[0]|less_than[100000000]');

			#-----------adding temporary data
			if($this->form_validation->run('btn_add') === true)
			{
				$item_array = $this->input->post(NULL,true);

				unset($item_array['vtype_id']);
				unset($item_array['bill_no']);
				unset($item_array['bill_date']);
				unset($item_array['return_bill_no']);
				unset($item_array['customer_type']);
				unset($item_array['customer_id']);
				unset($item_array['btn_add']);
				$item_array['group_id'] = $group_id;
				$item_array['status'] = -1;

				#----------rate calculation
				$item_array['rate'] = 0;
				if($item_array['qty'] != 0){
					$item_array['rate'] = $item_array['amount'] / $item_array['qty'];
				}

				#------------checking same item,godown,unit with same group_id exists
				$sales_temp_item_result = $this->rejection_in->get_sales_gst(array('columns' => array('b.id'),'conditions' => array('b.group_id' => $group_id,'item_id' => $item_array['item_id'],'godown_id' => $item_array['godown_id'],'unit_id' => $item_array['unit_id'],'a.status !=' => 0,'b.status !=' => 0),'numrows' => true));
				if($sales_temp_item_result == 0)
				{
					#----------VAT calculation
				/*	$cst = 0;
					if(isset($item_array['cst'])){
						$cst = $item_array['cst'];
					}
					if(empty($presumptive_tax)){
						if($cst == 0){
							$vat_percent = $this->stock->get_item_vat($item_array['item_id']);
							$item_array['vat_percent'] = $vat_percent;
							$item_array['vat_amt'] = (($item_array['amount']-$item_array['discount_amt']) * $vat_percent) / 100;
						}
					}    */

                                        $cgst = $this->stock->get_item_cgst($item_array['item_id']);
                                        $sgst = $this->stock->get_item_sgst($item_array['item_id']);
                                        $item_array['cgst'] = $cgst;
                                        $item_array['sgst'] = $sgst;
					$item_array['cgst_amt'] = (($item_array['amount']-$item_array['discount_amt']) * $cgst) / 100;
					$item_array['sgst_amt'] = (($item_array['amount']-$item_array['discount_amt']) * $sgst) / 100;


					#----------start transaction
					$this->db->trans_start();

					#-----------bill date and next bill no
					if($result_array['vstatus'] == 0)//data not in dms_sales_returns
					{
						$sales_temp_array['vtype_id'] = $this->input->post('vtype_id',true);
						$sales_temp_array['branch_id'] = $this->branchID;
						$sales_temp_array['group_id'] = $group_id;
						$sales_temp_array['bill_no'] = $this->input->post('bill_no',true);
						$sales_temp_array['bill_date'] = date('Y-m-d',strtotime($this->input->post('bill_date',true)));
						if($this->input->post('return_bill_no',true) && $this->input->post('return_bill_no',true) != ""){
							$sales_temp_array['return_bill_no'] = $this->input->post('return_bill_no',true);
						}
						$sales_temp_array['customer_type_id'] = $this->input->post('customer_type',true);
						$sales_temp_array['customer_id'] = $this->input->post('customer_id',true);
						$sales_temp_array['status'] = -1;
						$voucher_date = $sales_temp_array['bill_date'];
						$this->rejection_in->insert("dms_rejection_ins",$sales_temp_array);
					}

					#--------------adding sales_return items
					$sales_items_id = $this->rejection_in->insert("dms_sales_return_items1",$item_array);
					if($sales_items_id){
						#--------------adding temporary stock balance in dms_stocks
						$stock_bal_temp = $this->stock->unit_conversion($item_array['item_id'],$item_array['unit_id'],$item_array['qty'],$item_array['rate'],$item_array['amount']);
						if($stock_bal_temp){
							$this->rejection_in->insert('dms_stocks',array('company_id' => $this->companyID,'branch_id' => $this->session->userdata('under_id'),'godown_id' => $item_array['godown_id'],'item_id' => $item_array['item_id'],'qty' => $stock_bal_temp['qty'],'unit_id' => $stock_bal_temp['primary_unit'],'rate' => $stock_bal_temp['rate'],'amount' => $stock_bal_temp['amount'],'stock_date' => $voucher_date,'stock_status' =>7,'table_group_id' => $group_id,'table_id' => $sales_items_id,'status' => -1));
						}
						$this->message->set($this->lang->line('rejection-in-add-success'));
					}else{
						$this->message->set($this->lang->line('rejection-in-add-error'),'e');
					}

					#----------transaction completed
					$this->db->trans_complete();
				}else{
					$this->message->set($this->lang->line('rejection-in-add-error'),'e');
				}
				redirect('rejection_in/add');
			}
		}

		#------------saving sales_return voucher
		if(isset($_POST['btn_save'])){
			#-----------validation
			$this->form_validation->set_rules('area_id','lang:area','required|xss_clean');
			$this->form_validation->set_rules('remarks','lang:remarks','xss_clean');
			$this->form_validation->set_rules('freight','lang:freight','xss_clean|greater_or_equal[0]|less_than[100000000]');
			$this->form_validation->set_rules('other_expense','lang:other-expense','xss_clean|greater_or_equal[0]|less_than[100000000]');
			#-----------saving data
			if($this->form_validation->run('btn_save') === true)
			{
				$narration = $this->input->post('remarks',true);
				$sales_entry_array=array('area_id' => $this->input->post('area_id',true),'bill_freight' => $this->input->post('freight',true),'other_expense' => $this->input->post('other_expense',true),'cess' => $cess,'narration' => $narration,'status' => 1);

				$sales_entry_check = $this->rejection_in->get_bills(array('columns' => array('vtype_id','bill_no','bill_date','return_bill_no'),'conditions' => array('group_id' => $group_id,'status !=' => 0)));

				if($sales_entry_check)
				{
					$bill_date = $sales_entry_check[0]['bill_date'];
					$vtype_id = $sales_entry_check[0]['vtype_id'];
					$bill_no = $sales_entry_check[0]['bill_no'];

					#----------start transaction
					#$this->db->trans_start();

					if($this->rejection_in->update(array('table' => 'dms_rejection_ins','data' => $sales_entry_array,'conditions' => array('group_id' => $group_id)))){
						$this->rejection_in->update(array('table' => 'dms_sales_return_items1','data' => array('status' => 1),'conditions' => array('group_id' => $group_id,'status !=' => 0)));


						#-------------changing bill status in dms_sales
						if($sales_entry_check[0]['return_bill_no'] > 0){
							$this->rejection_in->update_others(array('table' => 'dms_sales','data' => array('bill_status' => 3),'conditions' => array('id' => $sales_entry_check[0]['return_bill_no'])));
						}

						#-------------enabling temporarily added stocks
						$sales_items_array = $this->rejection_in->get_sales_itemss(array('columns' => array('id'),'conditions' => array('group_id' => $group_id,'status' => 1)));
						foreach($sales_items_array as $key => $value)
						{
							$this->rejection_in->update_others(array('table' => 'dms_stocks','data' => array('status' => 1),'conditions' => array('stock_status'=>7,'table_id' => $value['id'])));
						}
						$this->message->set($this->lang->line('rejection-in-save-success'));
					}
					else{
						$this->message->set($this->lang->line('rejection-in-save-error'),'e');
					}
					#$this->db->trans_complete();
				}
				else
				{
					$this->message->set($this->lang->line('rejection-in-save-error'),'e');
				}
				redirect('rejection_in/add');
			}
		}

		#------------item details / unit details / godown details
		$units = $goDowns = $customers = array();
		$units[''] = "Select";

		#------------sales_return temp data
		$sales_temp_data = array();
		$stock_count = $primary_unit['symbol'] = $cust_id = $return_bill = "";

		if($result_array['vstatus'])
		{
			#------------sales_return temp data
			$sales_temp_data = $this->rejection_in->get_sales(array('columns' => array('a.group_id','a.return_bill_no','a.customer_type_id','a.customer_id','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.godown_id','b.vat_amt','b.cst'),'conditions' => array('a.created_by' => $this->createdBY,'vtype_id' => $vtype_id,'bill_no' => $voucher_no,'a.status =' => -1,'b.status =' => -1)));
                       if(empty($sales_temp_data))
                       { 
                           $sales_temp_data = $this->rejection_in->get_sales_gst(array('columns' => array('a.group_id','a.return_bill_no','a.customer_type_id','a.customer_id','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.godown_id','b.cgst_amt','b.sgst_amt'),'conditions' => array('a.created_by' => $this->createdBY,'vtype_id' => $vtype_id,'bill_no' => $voucher_no,'a.status =' => -1,'b.status =' => -1)));
                       }

			#------------customer type
			$custType = $sales_temp_data[0]['customer_type_id'];

			#------------customer
			$cust_id = $sales_temp_data[0]['customer_id'];
			if($result_array['return_bill_no'] > 0){

				$return_bill = $result_array['return_bill_no'];
				$customerTypes = $this->rejection_in->get_customer_type($return_bill);
				$customers = $this->rejection_in->get_customer($return_bill);
				$return_bills[$return_bill] = $this->rejection_in->get_bill_no($return_bill);
				$items = $this->rejection_in->get_bill_itemss($return_bill);

			}else{

				$return_bills = $this->rejection_in->get_sales_bills();
				if($this->branch_status){
					$customerTypes = $this->desig->listing(array('department_id'=>0,'utype_status >'=>1));
				}else{
					$customerTypes = $this->desig->listing(array('id'=>2));
				}
				$args['select'] = array('id','item_code','item_name');
				$items = $this->stock->get_stock_items($args);
				if(empty($items)){
					$this->message->set($this->lang->line('no-items-found'),'i');
				}

			}
			#------------area details
			$this->load->model('areas/Area_model','area');
			$areas = $this->area->listing();
		}else{
			$custType=$cust_id='';
			$sales_array = $this->input->post();
			#------------customer type
			if($sales_array['customer_type'] != ""){
				$custType = $sales_array['customer_type'];
			}
			if($sales_array['customer_id'] != ""){
				$cust_id = $sales_array['customer_id'];
			}

			if($this->input->post('return_bill_no',true) && $this->input->post('return_bill_no',true) != ""){

				$return_bill = $this->input->post('return_bill_no',true);
				$customerTypes = $this->rejection_in->get_customer_type($return_bill);
				$customers = $this->rejection_in->get_customer($return_bill);
				$return_bills[$return_bill] = $this->rejection_in->get_bill_no($return_bill);
				$items = $this->rejection_in->get_bill_items($return_bill);

			}else{
				if($this->branch_status){
					$customerTypes = $this->desig->listing(array('department_id'=>0,'utype_status >'=>1));
				}else{
					$customerTypes = $this->desig->listing(array('id'=>2));
				}
				$return_bills = $this->rejection_in->get_sales_bills();
				$args['select'] = array('id','item_code','item_name');
				$items = $this->stock->get_stock_items($args);
				if(empty($items)){
					$this->message->set($this->lang->line('no-items-found'),'i');
				}
			}

			#------------stock count of this item
			if($this->input->post('item_id',true) && $this->input->post('godown_id',true) && $sales_array['bill_date'] != ""){
				$stock_count = $this->stock->get_stock_count($this->input->post('godown_id',true),$this->input->post('item_id',true),$sales_array['bill_date']);
				$primary_unit = $this->stock->get_primary_unit($this->input->post('item_id',true));
			}
		}

		if($this->input->post('item_id',true)){
			$itemID = $this->input->post('item_id',true);
			$goDowns = $this->stock->get_item_godowns(array('item_id'=>$itemID,'listing'=>1));
			$units = $this->stock->get_units($itemID);
		}
		if(!empty($custType)){
			$customers = $this->stock->get_customers($custType);
		}

		$customerTypes[''] = 'Select';ksort($customerTypes);
		$customers[''] = 'Select';ksort($customers);
		$return_bills[''] = 'Select';ksort($return_bills);
		$areas[''] = 'Select';ksort($areas);
		$items[''] = 'Select';ksort($items);
		$goDowns[''] = 'Select';ksort($goDowns);

		#------------template
		$this->template->title($this->lang->line("$voucher_name"));
		$this->template->main_heading($this->lang->line("$voucher_name"));
		$this->template->breadcrumb(array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line("$voucher_name") => 'no_link',$this->lang->line('report') => 'rejection_in/report'));
		$this->template->slice('dms/message');
		$this->template->slice('sales/rejection_in/add',array('voucher_types' => $voucher_types,'voucher_type' => $vtype_id,'voucher_name' => $voucher_name,'voucher_no' => $voucher_no,'voucher_date' => $voucher_date,'return_bills' => $return_bills,'return_bill' => $return_bill,'custType' => $custType,'customerTypes' => $customerTypes,'customers' => $customers,'cust_id' => $cust_id,'items' => $items,'units' => $units,'goDowns' => $goDowns,'sales_temp_status' =>$result_array['vstatus'],'sales_temp_data' => $sales_temp_data,'areas' => $areas,'sales_cst' => $sales_cst,'presumptive_tax' => $presumptive_tax,'cess' => $cess,'disabled' => $disabled,'stock_count' => $stock_count,'primary_unit' => $primary_unit['symbol'],'bill_prefix'=>$bill_prefix));
		$this->template->other_script('sales/rejection_in');
		$this->template->render();
	}

	#-----------------------------------------------------------------------------------------------------

	public function delete_temp()
	{
		#----------rejection in temp data
		$uri_array = $this->uri->uri_to_assoc(3);
		if(isset($uri_array['idu']) || isset($uri_array['ida']))
		{
			if(isset($uri_array['idu']))
			{
				$id = $uri_array['idu'];
				unset($uri_array['idu']);

				#-----------redirect uri
				$redirect_uri = "rejection_in/update/".$this->uri->assoc_to_uri($uri_array);
			}
			else
			{
				$id = $uri_array['ida'];
				unset($uri_array['ida']);

				#-----------redirect uri
				$redirect_uri = "rejection_in/add/".$this->uri->assoc_to_uri($uri_array);
			}

			$result = $this->rejection_in->get_sales_gst(array('columns' => array('a.group_id','a.return_bill_no','b.status','b.created_by'),'conditions' => array('b.id' => $id,'b.status !=' => 0)));
			if(!empty($result))
			{
				$row = $result[0];
				if($row['status'] == -1)
				{
					if($row['created_by'] == $this->createdBY)
					{
						#----------start transaction
						$this->db->trans_start();

						if($this->rejection_in->delete(array('table' => 'dms_sales_return_items1','conditions' => array('id' => $id))))
						{
							#-------------deleting stock bal. from dms_stocks
							$this->rejection_in->delete(array('table' => 'dms_stocks','conditions' => array('table_id' => $id,'stock_status' => 7)));

							$count = $this->rejection_in->get_sales_itemss(array('columns' => array('group_id'),'conditions' => array('group_id' => $row['group_id'],'status !=' => 0),'numrows' => true));
							if($count == 0){
								$this->rejection_in->delete(array('table' => 'dms_rejection_ins','conditions' => array('group_id' => $row['group_id'])));
							}
							$this->message->set($this->lang->line('rejection-in-item-delete-success'));
						}
						else
						{
							$this->message->set($this->lang->line('rejection-in-item-delete-error'),'e');
						}

						#----------end transaction
						$this->db->trans_complete();
					}
					else
					{
						redirect('users/logout');
					}
				}
				else
				{
					#----------start transaction
					$this->db->trans_start();

					#-------------deleting item from dms_sales_return_items
					$this->rejection_in->update(array('table' => 'dms_sales_return_items1','data' => array('status' => 0),'conditions' => array('id' => $id)));

					#-------------changing sales_return bill status
					$this->rejection_in->update(array('table' => 'dms_rejection_ins','data' => array('status' => -1),'conditions' => array('group_id' => $row['group_id'])));

					#-------------deleting stock bal. from dms_stocks
					$this->rejection_in->update_others(array('table' => 'dms_stocks','data' => array('status' => 0),'conditions' => array('table_id' => $id,'stock_status' => 7)));

					#-------------checking whether sales_return bill is deleted
					$count = $this->rejection_in->get_sales_itemss(array('columns' => array('group_id'),'conditions' => array('group_id' => $row['group_id'],'status !=' => 0),'numrows' => true));
					if($count == 0){

						#-------------deleting sales_return bill
						$this->rejection_in->update(array('table' => 'dms_rejection_ins','data' => array('status' => 0),'conditions' => array('group_id' => $row['group_id'])));

						#-------------updating sales_bill status
						if($row['return_bill_no'] > 0)
						{
							$this->rejection_in->update_others(array('table' => 'dms_sales','data' => array('bill_status' => 0),'conditions' => array('id' => $row['return_bill_no'])));
						}

						#-----------redirect uri
						$redirect_uri = "rejection_out/report/".$this->uri->assoc_to_uri($uri_array);
					}
					$this->message->set($this->lang->line('rejection-in-item-delete-success'));

					#----------end transaction
					$this->db->trans_complete();
				}
			}
			redirect($redirect_uri);
		}
		redirect('users/logout');
	}

	#----------------------------------------------------------------------------------------------------------------

	public function update_temp()
	{
		#----------rejection in temp data
		$uri_array = $this->uri->uri_to_assoc(3);
		if(isset($uri_array['idu']) || isset($uri_array['ida']))
		{
			if(isset($uri_array['idu']))
			{
				$sales_temp_id = $uri_array['idu'];
				unset($uri_array['idu']);

				#-----------redirect uri
				$redirect_uri = "rejection_in/update/".$this->uri->assoc_to_uri($uri_array);
			}
			else
			{
				$sales_temp_id = $uri_array['ida'];
				unset($uri_array['ida']);

				#-----------redirect uri
				$redirect_uri = "rejection_in/add/".$this->uri->assoc_to_uri($uri_array);
			}

			$row = $this->rejection_in->get_sales(array('columns' => array('a.group_id','a.bill_date','a.return_bill_no','b.item_id','b.qty','b.unit_id','b.rate','b.amount','vat_amt','cst','godown_id','b.status','b.created_by'),'conditions' => array('b.id' => $sales_temp_id,'b.status !=' => 0)));
                        if(empty($row))
                        {
                           $row = $this->rejection_in->get_sales_gst(array('columns' => array('a.group_id','a.bill_date','a.return_bill_no','b.item_id','b.qty','b.unit_id','b.rate','b.amount','cgst_amt','sgst_amt','godown_id','b.status','b.created_by'),'conditions' => array('b.id' => $sales_temp_id,'b.status !=' => 0)));
                        }
			if(!empty($row))
			{
				$sales_temp_data = $row[0];$continue = 1;
				if($sales_temp_data['status'] == -1){
					if($sales_temp_data['created_by'] != $this->createdBY){
						$continue = 0;
					}
				}
				if($continue == 1)
				{
					$rules = "callback_check_bill_qty";
					if($sales_temp_data['return_bill_no'] > 0){
						$rules = "callback_check_bill_qty[$sales_temp_data[return_bill_no].$sales_temp_data[item_id].$sales_temp_id]";
					}

					#-----------validation
					$this->form_validation->set_rules('godown_id','lang:godown','required|xss_clean');
					$this->form_validation->set_rules('cst','lang:cst','xss_clean|greater_or_equal[0]|less_or_equal[100]');
				//	$this->form_validation->set_rules('qty','lang:quantity',"required|xss_clean|greater_than[0]|less_than[100000000]|".$rules);
					$this->form_validation->set_rules('unit_id','lang:unit','required|xss_clean');
					$this->form_validation->set_rules('rate','lang:rate','required|xss_clean|greater_or_equal[0]|less_than[100000000]');
					$this->form_validation->set_rules('amount','lang:amount','xss_clean|required|greater_or_equal[0]|less_than[100000000]');
				//	$this->form_validation->set_rules('vat_amt','lang:vat-amt','xss_clean|greater_or_equal[0]|less_than[100000000]');

					#-----------updating temporary data
					if($this->form_validation->run() === true)
					{
						$item_temp_array = $this->input->post(NULL,true);
						$item_temp_array['status'] = -1;

						#----------rate calculation
						$item_temp_array['rate'] = 0;
						if($item_temp_array['qty'] != 0){
							$item_temp_array['rate'] = $item_temp_array['amount'] / $item_temp_array['qty'];
						}

						#----------start transaction
						$this->db->trans_start();

						$this->rejection_in->update_others(array('table' => 'dms_sales_return_items1','data' => $item_temp_array,'conditions' => array('id' => $sales_temp_id)));

						#--------------updating bill status in dms_sales_returns
						$this->rejection_in->update_others(array('table' => 'dms_rejection_ins','data' => array('status' => -1),'conditions' => array('group_id' => $sales_temp_data['group_id'])));

						$this->message->set($this->lang->line('rejection-in-edit-temp-success'));

						#--------------updating temporary stock balance in dms_stocks
						$stock_bal_temp = $this->stock->unit_conversion($sales_temp_data['item_id'],$item_temp_array['unit_id'],$item_temp_array['qty'],$item_temp_array['rate'],$item_temp_array['amount']);
						if($stock_bal_temp)
						{
							$this->rejection_in->update_others(array('table' => 'dms_stocks','data' => array('godown_id' => $item_temp_array['godown_id'],'qty' => $stock_bal_temp['qty'],'unit_id' => $stock_bal_temp['primary_unit'],'rate' => $stock_bal_temp['rate'],'amount' => $stock_bal_temp['amount']),'conditions' => array('stock_status' => 7,'table_id' => $sales_temp_id)));
						}

						#----------end transaction
						$this->db->trans_complete();

						redirect($redirect_uri);
					}

					#----------voucher name
					$voucher_name = $this->vouchers->voucher_name($this->vtype);

					#-----------sales cst checking details
					$sales_cst = $this->stock->get_constant(array('sales_cst'));

					#------------presumptive tax checking
					$presumptive_tax = $this->stock->get_tax_type();

					#------------checking cst enabled or not
					$cst_status = $this->rejection_in->get_cst($sales_temp_data['group_id']);
					if($cst_status){
						$sales_cst = $cst_status;
					}

					#------------item details / unit details / godown details
					$units = $goDowns = array();
					$item_details = $this->stock->get_item($sales_temp_data['item_id'],array('item_code','item_name'));
					$items[$sales_temp_data['item_id']] = $item_details['item_code']." / ".$item_details['item_name'];
					$goDowns = $this->stock->get_item_godowns(array('item_id'=>$sales_temp_data['item_id'],'listing'=>1));
					$goDowns[''] = 'Select';
					ksort($goDowns);
					$units = $this->stock->get_units($sales_temp_data['item_id']);

					#------------sales_return date
					$sale_date = $sales_temp_data['bill_date'];

					#------------stock count of this item
					$stock_count = $this->stock->get_stock_count($sales_temp_data['godown_id'],$sales_temp_data['item_id'],$sale_date);

					#------------primary unit details
					$primary_unit = $this->stock->get_primary_unit($sales_temp_data['item_id']);

					#------------template
					$this->template->title($this->lang->line("$voucher_name"));
					$this->template->main_heading($this->lang->line("$voucher_name"));
					$this->template->breadcrumb(array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line("$voucher_name") => 'rejection_in/add',$this->lang->line("update") => 'no_link',$this->lang->line('report') => 'rejection_in/report',$this->lang->line('go-back') => array($redirect_uri)));
					$this->template->slice('dms/message');
					$this->template->slice('sales/rejection_in/edit_temp',array('voucher_name' => $voucher_name,'items' => $items,'units' => $units,'goDowns' => $goDowns,'sales_temp_data' => $sales_temp_data,'sales_cst' => $sales_cst,'presumptive_tax' => $presumptive_tax,'stock_count' => $stock_count,'unit_symbol' => $primary_unit['symbol'],'sale_date' => $sale_date));
					$this->template->other_script('sales/rejection_in');
					$this->template->render();
				}
				else
				{
					redirect('users/logout');
				}
			}
			else
			{
				redirect('users/logout');
			}
		}
		else
		{
			redirect('users/logout');
		}
	}

	public function bill_no_exists($bill_no,$v_details = NULL)
	{
		if($v_details == NULL){
			$where = array('vtype_id' => $this->input->post('vtype_id',true),'bill_no' => $bill_no,'status !=' => 0);
		}
		else{
			$exp = explode('.', $v_details);
			$where = array('vtype_id' => $exp[0],'bill_no' => $bill_no,'group_id !=' => $exp[1],'status !=' => 0);
		}
		$row = $this->rejection_in->get_bills(array('columns' => array('id'),'conditions' => $where,'numrows' => true));
		if($row == 0){
			return true;
		}
		return false;
	}

	#-------------------------------------------------------------------------------------------------------

	public function report()
	{
		#----------voucher type
		$vtype_id = $this->vtype;
		$conditions = array('vtype_id' => $vtype_id,'status' => 1);
		$like_array = array();$vnos="";

		#----------voucher name
		$voucher_name = $this->vouchers->voucher_name($this->vtype);

		#----------voucher type array
		$voucher_types = $this->vouchers->voucher_types($this->vtype);

		#----------uri array
		$uri_array  = $this->uri->uri_to_assoc(3);

		#----------redirect
		$redirect = "";

		#----------pagination
		$this->load->library('Pagination');
		$config['per_page'] = $this->per_page();
		$config['base_url'] = base_url('rejection_in/report');
		$config['uri_segment'] = 3;

		#----------dates within financial year
		$cur_date = date('Y-m-d');
		$from_date = $cur_date;
		$to_date = $cur_date;
		$cur_fiscal_yr = $this->dms->get_fiscal_year();
		if($from_date < $cur_fiscal_yr['start_date'] || $from_date > $cur_fiscal_yr['end_date'] || $to_date < $cur_fiscal_yr['start_date'] || $to_date > $cur_fiscal_yr['end_date'])
		{
			$from_date = $cur_fiscal_yr['end_date'];
			$to_date = $cur_fiscal_yr['end_date'];
		}

		#----------validation
		$this->form_validation->set_rules('vtype_id','voucher-types','required|xss_clean');
		$this->form_validation->set_rules('from_date','From Date','required|xss_clean|valid_date');
		$this->form_validation->set_rules('to_date','To Date','required|xss_clean|valid_date');
		$this->form_validation->set_rules('bill_no','bill-no','xss_clean|trim');
		if($this->form_validation->run() === true)
		{
			$vtype_id = $this->input->post('vtype_id',true);
			$from_date = date('Y-m-d',strtotime($this->input->post('from_date',true)));
			$to_date = date('Y-m-d',strtotime($this->input->post('to_date',true)));
			$conditions['vtype_id'] = $vtype_id;
			$config['base_url'] .= '/vt/'.$vtype_id.'/fdate/'.$from_date.'/tdate/'.$to_date;
			$config['uri_segment'] += 6;
			$redirect .= '/vt/'.$vtype_id.'/fdate/'.$from_date.'/tdate/'.$to_date;
			if(!empty($this->input->post('bill_no',true)))
			{
				$vnos = $this->input->post('bill_no',true);
				$like_array['bill_no'] = $vnos;
				$config['base_url'] .= '/vn/'.$vnos;
				$config['uri_segment'] += 2;
				$redirect .= '/vn/'.$vnos;
			}
		}
		elseif(isset($uri_array['vt']))
		{
			$vtype_id = $uri_array['vt'];
			$conditions['vtype_id'] = $vtype_id;
			$config['base_url'] .= '/vt/'.$conditions['vtype_id'];
			$config['uri_segment'] += 2;
			$redirect .= '/vt/'.$vtype_id;
			if(isset($uri_array['fdate']) && isset($uri_array['tdate']))
			{
				$from_date = date('Y-m-d',strtotime($uri_array['fdate']));
				$to_date = date('Y-m-d',strtotime($uri_array['tdate']));
				$config['base_url'] .= '/fdate/'.$from_date.'/tdate/'.$to_date;
				$config['uri_segment'] += 4;
				$redirect .= '/fdate/'.$from_date.'/tdate/'.$to_date;
			}
			if(isset($uri_array['vn']))
			{
				$vnos = $uri_array['vn'];
				$like_array['bill_no'] = $vnos;
				$config['base_url'] .= '/vn/'.$vnos;
				$config['uri_segment'] += 2;
				$redirect .= '/vn/'.$vnos;
			}
		}

		#----------between condition
		$between = "bill_date between '$from_date' and '$to_date'";

		#----------total rows
		$config['total_rows'] = $this->rejection_in->get_bills(array('columns' => array('id'),'conditions' => $conditions,'between' => $between,'like' => $like_array,'numrows'=>true));

		if($config['total_rows'] == 0){
			$this->message->set($this->lang->line('no-voucher'),'i');
		}

		#----------pagination
		$offset = $this->uri->segment($config['uri_segment'],0);
		# Pagination Config Customizations
        $config['full_tag_open'] = '<ul class="pagination">';
        $config['full_tag_close'] = '</ul>';
        $config['first_link'] = 'First';
        $config['last_link'] = 'Last';
        $config['next_link'] = '&raquo;';
        $config['prev_link'] = '&laquo;';
        $config['cur_tag_open'] = '<li class="active"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
		$this->pagination->initialize($config);
		$links = $this->pagination->create_links();
		$redirect .= '/'.$offset;

		#------------presumptive tax checking
		$presumptive_tax = $this->stock->get_tax_type();

		#----------rejection in report datas
		$sales_array=$this->rejection_in->get_bills(array('conditions' => $conditions,'between' => $between,'like' => $like_array,'order_by'=>'bill_date','order'=>'DESC','limit'=>$config['per_page'],'offset'=>$offset));

		#----------template
		$report_head = $this->lang->line("$voucher_name")." ".$this->lang->line("report");
		$this->template->title($report_head);
		$this->template->main_heading($report_head);
		$this->template->breadcrumb(array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line("$voucher_name") => 'rejection_in/add',$this->lang->line('report') => 'no_link'));
		$this->template->slice('sales/sales_entry/search',array('voucher_types' => $voucher_types,'vtype_id' => $vtype_id,'vnos' => $vnos,'from_date' => $from_date,'to_date' => $to_date,'rtype' => 'rejection_in'));
		$this->template->slice('dms/message');
		if(!empty($sales_array))
		{
			$this->template->slice('sales/rejection_in/report',array('sales_array' => $sales_array,'presumptive_tax' => $presumptive_tax,'offset' => $offset,'links' => $links,'redirect' => $redirect));
			$this->template->slice('dms/modals/delete_confirm');
		}
		$this->template->other_script('sales/rejection_in');
		$this->template->render();
	}

	#------------------------------------------------------------------------------------------------------

	public function view()
	{
		#----------voucher type
		$vtype_id = $this->vtype;

		#----------rejection in primary key
		$uri_array = $this->uri->uri_to_assoc(3);
		if(isset($uri_array['id']) || isset($uri_array['group_id']))
		{
			#----------voucher name
			$voucher_name = $this->vouchers->voucher_name($this->vtype);

			#----------breadcrumb
			$breadcrumb = array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line("$voucher_name") => 'rejection_in/add',$this->lang->line('report') => 'rejection_in/report',$this->lang->line("view") => 'no_link');

			if(isset($uri_array['group_id']))
			{
				$conditions = array('a.group_id' => $uri_array['group_id'],'a.status !=' => 0,'b.status !=' => 0);
				if(isset($uri_array['id']) || isset($uri_array['mid']) || isset($uri_array['sid']))
				{
					if(isset($uri_array['id'])){
						$breadcrumb_url = "stock_item_register/index/id/".$uri_array['id'];
					}
					elseif(isset($uri_array['mid'])){
						$breadcrumb_url = "stock_item_register/index/mid/".$uri_array['mid'];
					}
					elseif(isset($uri_array['sid'])){
						$breadcrumb_url = "stock_item_register/index/sid/".$uri_array['sid'];
					}
					if(isset($uri_array['rtype'])){
						$breadcrumb_url .= "/rtype/".$uri_array['rtype'];
					}
					$breadcrumb[$this->lang->line("go-back")] = $breadcrumb_url;
				}
			}
			else
			{
				$sales_id = $uri_array['id'];
				unset($uri_array['id']);
				$conditions = array('a.id' => $sales_id,'a.status !=' => 0,'b.status !=' => 0);
				$breadcrumb[$this->lang->line("go-back")] = "rejection_in/report/".$this->uri->assoc_to_uri($uri_array);
			}

			#----------rejection in data
		/*	$sales_array = $this->rejection_in->get_sales(array('columns' => array('a.id as primary_id','a.vtype_id','a.group_id','a.bill_no','a.bill_date','a.return_bill_no','a.customer_type_id','a.customer_id','a.area_id','a.bill_freight','a.other_expense','a.cess','a.narration','a.created_by','a.created_on','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.godown_id','b.vat_amt','b.cst'),'conditions' => $conditions));
                        if(empty($sales_array))
                        {        */
                            $sales_array = $this->rejection_in->get_sales_gst(array('columns' => array('a.id as primary_id','a.vtype_id','a.group_id','a.bill_no','a.bill_date','a.return_bill_no','a.customer_type_id','a.customer_id','a.area_id','a.bill_freight','a.other_expense','a.cess','a.narration','a.created_by','a.created_on','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.godown_id','b.cgst_amt','b.sgst_amt'),'conditions' => $conditions));
 
             //           }
			if(!empty($sales_array))
			{
				#------------loading model
				$this->load->model('customers/Customer_type_model','customer_type');

				#------------presumptive tax checking
				$presumptive_tax = $this->stock->get_tax_type();

				#------------checking cst enabled or not
				$sales_cst = $this->rejection_in->get_cst($sales_array[0]['group_id']);

				$voucher_type = $this->vouchers->voucher_name($sales_array[0]['vtype_id']);
				$customer_name = $this->stock->get_customer($sales_array[0]['customer_type_id'],$sales_array[0]['customer_id']);
				$area_id = $this->dms->get_area($sales_array[0]['area_id']);

				#-------------return bill details
				$return_bill_no = "";
				if($sales_array[0]['return_bill_no'] > 0){
					$return_bill_no = $this->rejection_in->get_bill_no($sales_array[0]['return_bill_no']);
				}

				#----------template
				$report_head = $this->lang->line("view").' '.$this->lang->line("$voucher_name");
				$this->template->title($report_head);
				$this->template->main_heading($report_head);
				$this->template->breadcrumb($breadcrumb);
				$this->template->slice('dms/message');
				$this->template->slice('sales/rejection_in/view',array('sales_array' => $sales_array,'return_bill_no' => $return_bill_no,'presumptive_tax' => $presumptive_tax,'sales_cst' => $sales_cst,'voucher_type' => $voucher_type,'customer_name' => $customer_name,'area_id' => $area_id));
				$this->template->other_script('sales/rejection_in');
				$this->template->render();
			}
			else
			{
				redirect('users/logout');
			}
		}
		else
		{
			redirect('users/logout');
		}
	}

	#-------------------------------------------------------------------------------------------------------

	public function update(){

		$vtype_id = $this->vtype;

		#----------rejection in primary key
		$uri_array = $this->uri->uri_to_assoc(3);
		if(isset($uri_array['id']))
		{
			$sales_id = $uri_array['id'];
			$redirect = "/".$this->uri->assoc_to_uri($uri_array);
			unset($uri_array['id']);

			#----------redirect uri
			$redirect_uri = "rejection_in/report/".$this->uri->assoc_to_uri($uri_array);

			#----------redirect uri while updating
			$update_uri = $this->uri->assoc_to_uri($this->uri->uri_to_assoc(1));

			#----------voucher name
			$voucher_name = $this->vouchers->voucher_name($this->vtype);

			$sales_cst = $this->stock->get_constant(array('sales_cst'));
			$presumptive_tax = $this->stock->get_tax_type();
			$cess = $this->stock->get_cess();
			$item_details = $this->rejection_in->get_group($sales_id);

			if(isset($_POST['btn_add'])){

				$rules = "callback_check_bill_qty";
				if($item_details['return_bill_no'] > 0){
					$rules = "callback_check_bill_qty[$item_details[return_bill_no]]";
				}

				$this->form_validation->set_rules('item_id','lang:item-name','required|xss_clean|is_natural_no_zero');
				$this->form_validation->set_rules('godown_id','lang:godown','required|xss_clean');
				$this->form_validation->set_rules('cst','lang:cst','xss_clean|greater_or_equal[0]|less_or_equal[100]');
				$this->form_validation->set_rules('qty','lang:quantity',"required|xss_clean|greater_than[0]|less_than[100000000]|".$rules);
				$this->form_validation->set_rules('unit_id','lang:unit','required|xss_clean');
				$this->form_validation->set_rules('rate','lang:rate','required|xss_clean|greater_or_equal[0]|less_than[100000000]');
				$this->form_validation->set_rules('amount','lang:amount','xss_clean|required|greater_or_equal[0]|less_than[100000000]');

				if($this->form_validation->run('btn_add') === true){

					$item_array['group_id'] = $item_details['group_id'];
					$item_array['item_id'] = $this->input->post('item_id',true);
					$item_array['qty'] = $this->input->post('qty',true);
					$item_array['unit_id'] = $this->input->post('unit_id',true);
					//$item_array['rate'] = $this->input->post('rate',true);
					$item_array['amount'] = $this->input->post('amount',true);

					#----------rate calculation
					$item_array['rate'] = 0;
					if($item_array['qty'] != 0){
						$item_array['rate'] = $item_array['amount'] / $item_array['qty'];
					}

					$item_array['godown_id'] = $this->input->post('godown_id',true);
					$item_array['status'] = 1;

				//	$sales_temp_item_result = $this->rejection_in->get_sales(array('columns' => array('b.id'),'conditions' => array('b.group_id' => $item_array['group_id'],'item_id' => $item_array['item_id'],'godown_id' => $item_array['godown_id'],'unit_id' => $item_array['unit_id'],'a.status !=' => 0,'b.status !=' => 0),'numrows' => true));
                                        $sales_temp_item_result = $this->rejection_in->get_sales_gst(array('columns' => array('b.id'),'conditions' => array('b.group_id' => $item_array['group_id'],'item_id' => $item_array['item_id'],'godown_id' => $item_array['godown_id'],'unit_id' => $item_array['unit_id'],'a.status !=' => 0,'b.status !=' => 0),'numrows' => true));
					if($sales_temp_item_result == 0){

					/*	#----------VAT calculation
						$cst = 0;
						if($this->input->post('cst',true)){
							$cst = $this->input->post('cst',true);
							$item_array['cst'] = $cst;
						}
						if(empty($presumptive_tax)){
							if(!$cst){
								$vat_percent = $this->stock->get_item_vat($item_array['item_id']);
								$item_array['vat_percent'] = $vat_percent;
								$item_array['vat_amt'] = (($item_array['amount']-$item_array['discount_amt']) * $vat_percent) / 100;
							}
						}       */


$cgst = $this->stock->get_item_cgst($item_array['item_id']);
$sgst = $this->stock->get_item_sgst($item_array['item_id']);
$item_array['cgst'] = $cgst;
$item_array['sgst'] = $sgst;
$item_array['cgst_amt'] = (($item_array['amount']-$item_array['discount_amt']) * $cgst) / 100;
$item_array['sgst_amt'] = (($item_array['amount']-$item_array['discount_amt']) * $sgst) / 100;



						$this->db->trans_start();
						$sales_items_id = $this->rejection_in->insert("dms_sales_return_items1",$item_array);

						if($sales_items_id){

							$stock_bal = $this->stock->unit_conversion($item_array['item_id'],$item_array['unit_id'],$item_array['qty'],$item_array['rate'],$item_array['amount']);
							if($stock_bal){
								$this->rejection_in->insert('dms_stocks',array('company_id' => $this->companyID,'branch_id' => $this->session->userdata('under_id'),'godown_id' => $item_array['godown_id'],'item_id' => $item_array['item_id'],'qty' => $stock_bal['qty'],'unit_id' => $stock_bal['primary_unit'],'rate' => $stock_bal['rate'],'amount' => $stock_bal['amount'],'stock_date' => $item_details['bill_date'],'stock_status' => 7,'table_group_id' => $item_details['group_id'],'table_id' => $sales_items_id));
							}
							$this->message->set($this->lang->line('rejection-in-add-success'));

						}else{
							$this->message->set($this->lang->line('rejection-in-add-error'),'e');
						}
						$this->db->trans_complete();

					}else{
						$this->message->set($this->lang->line('rejection-in-add-error'),'e');
					}
					redirect($update_uri);
				}
			}

			if(isset($_POST['btn_update'])){

				$this->form_validation->set_rules('bill_no','lang:bill-no',"required|xss_clean|is_natural_no_zero|callback_bill_no_exists[$item_details[vtype_id].$item_details[group_id]]");
				$this->form_validation->set_rules('bill_date','lang:bill-date','required|xss_clean|valid_date');
				$this->form_validation->set_rules('remarks','lang:remarks','xss_clean');
				$this->form_validation->set_rules('freight','lang:freight','xss_clean|greater_or_equal[0]|less_than[100000000]');
				$this->form_validation->set_rules('area_id','lang:area','xss_clean|required');
				$this->form_validation->set_rules('other_expense','lang:other-expense','xss_clean|greater_or_equal[0]|less_than[100000000]');

				if($this->form_validation->run('btn_update') === true){

					$bill_date = date('Y-m-d',strtotime($this->input->post('bill_date',true)));
					$bill_no = $this->input->post('bill_no',true);
					$narration = $this->input->post('remarks',true);

					$sales_entry_array=array('bill_no' => $bill_no,'bill_date' => $bill_date,'bill_freight' => $this->input->post('freight',true),'area_id'=>$this->input->post('area_id',true),'other_expense' => $this->input->post('other_expense',true),'cess' => $cess,'narration' => $narration,'status' => 1);

					$this->db->trans_start();
					if($this->rejection_in->update(array('table' => 'dms_rejection_ins','data' => $sales_entry_array,'conditions' => array('id' => $sales_id)))){

						$this->rejection_in->update_others(array('table' => 'dms_sales_return_items1','data' => array('status' => 1),'conditions' => array('group_id' => $item_details['group_id'],'status !=' => 0)));
						$this->message->set($this->lang->line('rejection-in-edit-success'));

					}else{
						$this->message->set($this->lang->line('rejection-in-edit-error'),'e');
					}

					$this->db->trans_complete();
					redirect($update_uri);
				}
			}

		/*	$sales_array = $this->rejection_in->get_sales(array('columns' => array('a.vtype_id','a.bill_no','a.bill_date','a.group_id','a.return_bill_no','a.customer_type_id','a.customer_id','a.area_id','a.bill_freight','a.other_expense','a.cess','a.narration','a.status','a.created_by','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.godown_id','b.vat_amt','b.cst'),'conditions' => array('a.id' => $sales_id,'a.status !=' => 0,'b.status !=' => 0)));
                       if(empty($sales_array))
                       { */
                           $sales_array = $this->rejection_in->get_sales_gst(array('columns' => array('a.vtype_id','a.bill_no','a.bill_date','a.group_id','a.return_bill_no','a.customer_type_id','a.customer_id','a.area_id','a.bill_freight','a.other_expense','a.cess','a.narration','a.status','a.created_by','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.godown_id','b.cgst_amt','b.sgst_amt'),'conditions' => array('a.id' => $sales_id,'a.status !=' => 0,'b.status !=' => 0)));
                    //   }
			$report_head = $this->lang->line("edit")." ".$this->lang->line("$voucher_name");

			if(!empty($sales_array)){
				$continue = 1;
				if($sales_array[0]['status'] == -1){
					if($sales_array[0]['created_by'] != $this->createdBY){
						$continue = 0;
					}
				}
				if($continue == 1){

					$stock_count = $primary_unit['symbol'] = "";
					$this->load->model('customers/Customer_type_model','customer_type');
					$cst_status = $this->rejection_in->get_cst($sales_array[0]['group_id']);
					if($cst_status){
						$sales_cst = $cst_status;
					}
					$customer_name = $this->stock->get_customer($sales_array[0]['customer_type_id'],$sales_array[0]['customer_id']);
					$units = $goDowns = array();
					$units[''] = "Select";
					$return_bill_no = "";
					if($sales_array[0]['return_bill_no'] == 0){
						$args['select'] = array('id','item_code','item_name');
						$items = $this->stock->get_stock_items($args);
					}else{
						$return_bill_no = $this->rejection_in->get_bill_no($sales_array[0]['return_bill_no']);
						$items = $this->rejection_in->get_bill_itemss($sales_array[0]['return_bill_no']);
					}

					if(empty($items)){
						$this->message->set($this->lang->line('no-items-found'),'i');
					}
					if($this->input->post('item_id',true)){
						$itemID = $this->input->post('item_id',true);
						$goDowns = $this->stock->get_item_godowns(array('item_id'=>$itemID,'listing'=>1));
						$units = $this->stock->get_units($itemID);
					}
					if($this->input->post('item_id',true) && $this->input->post('godown_id',true) && $sales_array[0]['bill_date'] != ""){
						$stock_count = $this->stock->get_stock_count($this->input->post('godown_id',true),$this->input->post('item_id',true),$sales_array[0]['bill_date']);
						$primary_unit = $this->stock->get_primary_unit($this->input->post('item_id',true));
					}
					$voucher_type = $this->vouchers->voucher_name($sales_array[0]['vtype_id']);
					$this->load->model('areas/Area_model','area');
					$areas = $this->area->listing();

					$areas[''] = 'Select';ksort($areas);
					$items[''] = 'Select';ksort($items);
					$goDowns[''] = 'Select';ksort($goDowns);

					$this->template->title($report_head);
					$this->template->main_heading($report_head);
					$this->template->breadcrumb(array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line("$voucher_name") => 'rejection_in/add',$this->lang->line('report') => 'rejection_in/report',$this->lang->line("update") => 'no_link',$this->lang->line("go-back") => array($redirect_uri)));
					$this->template->slice('dms/message');
					$this->template->slice('sales/rejection_in/edit',array('sales_array' => $sales_array,'presumptive_tax' => $presumptive_tax,'sales_cst' => $sales_cst,'voucher_type' => $voucher_type,'customer_name' => $customer_name,'voucher_name' => $voucher_name,'items' => $items,'goDowns' => $goDowns,'units' => $units,'stock_count' => $stock_count,'primary_unit' => $primary_unit['symbol'],'areas' => $areas,'return_bill_no' => $return_bill_no,'redirect' => $redirect));
					$this->template->other_script('sales/rejection_in');
					$this->template->render();
				}else{
					redirect('users/logout');
				}
			}
			else
			{
				redirect('users/logout');
			}

		}
		else
		{
			redirect('users/logout');
		}
	}

	#----------------------------------------------------------------------------------------

	public function delete()
	{
		#----------rejection in primary key
		$uri_array = $this->uri->uri_to_assoc(3);
		if(isset($uri_array['id']))
		{
			$id = $uri_array['id'];
			unset($uri_array['id']);

			#----------redirect uri
			$redirect_uri = "rejection_in/report/".$this->uri->assoc_to_uri($uri_array);

			$result = $this->rejection_in->get_sales_gst(array('columns' => array('a.group_id','a.return_bill_no','a.status','a.created_by','b.id'),'conditions' => array('a.id' => $id,'a.status !=' => 0)));

			if(!empty($result))
			{
				$row = $result[0];$continue = 1;
				if($row['status'] == -1){
					if($row['created_by'] != $this->createdBY){
						$continue = 0;
					}
				}
				if($continue == 1)
				{
					if($this->rejection_in->update_others(array('table' => 'dms_rejection_ins','data' => array('status' => 0),'conditions' => array('id' => $id))))
					{
						#-------------deleting sales_return_items of sales_return
						$this->rejection_in->update_others(array('table' => 'dms_sales_return_items1','data' => array('status' => 0),'conditions' => array('group_id' => $row['group_id'])));

						#-------------updating sales_bill status
						if($row['return_bill_no'] > 0)
						{
							$this->rejection_in->update_others(array('table' => 'dms_sales','data' => array('bill_status' => 0),'conditions' => array('id' => $row['return_bill_no'])));
						}

						foreach($result as $key => $value)
						{
							#-------------deleting stock bal. from dms_stocks
							$this->rejection_in->update_others(array('table' => 'dms_stocks','data' => array('status' => 0),'conditions' => array('table_id' => $value['id'],'stock_status' => 7)));
						}
						$this->message->set($this->lang->line('rejection-in-delete-success'));
					}
					else
					{
						$this->message->set($this->lang->line('rejection-in-delete-error'),'e');
					}
				}
				else
				{
					redirect('users/logout');
				}
			}
			redirect($redirect_uri);
		}
		redirect('users/logout');
	}

	public function check_bill_qty($qty,$values = NULL)
	{
		if($this->input->post('return_bill_no',true) && $this->input->post('return_bill_no',true) != ""){
			$item_id = $this->input->post('item_id',true);
			$bill_id = $this->input->post('return_bill_no',true);
			$count = $this->rejection_in->get_item_count($bill_id,$item_id);
			$qty += $this->rejection_in->get_sales_return_item_count($bill_id,$item_id);
			if($qty > $count){
				return false;
			}
			return true;
		}elseif($values != NULL){
			$exp = explode(".",$values);
			$bill_id = $exp[0];
			if($this->input->post('item_id',true) && $this->input->post('item_id',true) != ""){
				$item_id = $this->input->post('item_id',true);
				$qty += $this->rejection_in->get_sales_return_item_count($bill_id,$item_id);
			}else{
				$item_id = $exp[1];
				$purchase_return_item_id = $exp[2];
				$qty += $this->rejection_in->get_sales_return_item_count($bill_id,$item_id,$purchase_return_item_id);
			}
			$count = $this->rejection_in->get_item_count($bill_id,$item_id);
			if($qty > $count){
				return false;
			}
			return true;
		}
	}

	#=======================================================

	public function pdf(){

		$pdf_name = 'rejection_in';
		$pdf_contents = '';
		if(!$this->uri->segment(4)){
			echo "<script>alert('".$this->lang->line('invalid-rejection-in-bill')."');window.close();</script>";
		}
		$sales_id = $this->uri->segment(4);
		if($this->if_exists('dms_rejection_ins',array('id'=>$sales_id,'status'=>1)) === false){
			echo "<script>alert('".$this->lang->line('invalid-rejection-in-bill')."');window.close();</script>";
		}
		#----------voucher type
		$vtype_id = $this->vtype;

		#----------voucher name
		$voucher_name = $this->vouchers->voucher_name($this->vtype);

		$this->load->library('My_pdf');
		$this->load->library('To_words');
		$this->my_pdf->set_tin();
		$this->my_pdf->set_header();

		#----------sales data
	/*	$sales_array = $this->rejection_in->get_sales(array('columns' => array('a.vtype_id','a.group_id','a.bill_no','a.bill_date','a.return_bill_no','a.customer_type_id','a.customer_id','a.area_id','a.bill_freight','a.other_expense','a.cess','a.narration','a.created_by','a.created_on','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.godown_id','b.vat_amt','b.cst'),'conditions' => array('a.id' => $sales_id,'a.status !=' => 0,'b.status !=' => 0)));

                if(empty($sales_array))
                { */
                    $sales_array = $this->rejection_in->get_sales_gst(array('columns' => array('a.vtype_id','a.group_id','a.bill_no','a.bill_date','a.return_bill_no','a.customer_type_id','a.customer_id','a.area_id','a.bill_freight','a.other_expense','a.cess','a.narration','a.created_by','a.created_on','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.godown_id','b.cgst_amt','b.sgst_amt'),'conditions' => array('a.id' => $sales_id,'a.status !=' => 0,'b.status !=' => 0))); 
            //    }
		if(empty($sales_array)){
			echo "<script>alert('".$this->lang->line('invalid-rejection-in-bill')."');window.close();</script>";
		}else{
			#------------loading model
			$this->load->model('customers/Customer_type_model','customer_type');
			$this->load->model('sales/Sales_return_vehicle_model','sales_return_vehicle');
			#------------presumptive tax checking
			$presumptive_tax = $this->stock->get_tax_type();
			#------------checking cst enabled or not
			$sales_cst = $this->rejection_in->get_cst($sales_array[0]['group_id']);
			$voucher_type = $this->vouchers->voucher_name($sales_array[0]['vtype_id']);
			$customer_name = $this->stock->get_customer($sales_array[0]['customer_type_id'],$sales_array[0]['customer_id']);

			$args = array();
			$args['select'] = array('dsrv.id','rm.route_name','vm.vehicle_no','concat(u.fname," ",u.lname) as driver','u.mobile','dsrv.vehicle_type','dsrv.vehicle_no as vehicle_number','dsrv.km','dsrv.remarks','dsrv.driver_name');
			$args['conditions'] = array('dsrv.group_id'=>$sales_array[0]['group_id']);
			$args['join'] = array('route_master as rm'=>'dsrv.route_id=rm.id','vehicle_master as vm'=>'dsrv.vehicle_id=vm.id','users as u'=>'dsrv.driver_id=u.id');
			$rejection_in_vehicles = $this->sales_return_vehicle->get($args);

			$area_id = $this->dms->get_area($sales_array[0]['area_id']);
			$return_bill_no = "";
			if($sales_array[0]['return_bill_no'] > 0){
				$return_bill_no = $this->rejection_in->get_bill_no($sales_array[0]['return_bill_no']);
			}


			$pdf_contents = $this->load->view('sales/rejection_in/rejection_in_pdf',array('sales_array' => $sales_array,'presumptive_tax' => $presumptive_tax,'sales_cst' => $sales_cst,'voucher_type' => $voucher_type,'customer_name' => $customer_name,'area_id' => $area_id,'return_bill_no'=>$return_bill_no,'vehicle_details'=>$rejection_in_vehicles),true);
		}
		$this->my_pdf->output($pdf_name,$pdf_contents);
	}
}
?>