<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

class Rejection_in_vehicles extends MY_Controller{
	
	var $companyID;
	var $branchID;
	var $createdBY;
	var $fiscal_start_date;
	var $fiscal_end_date;
	
	#------------------------------------
	
	public function __construct(){
		
		parent::__construct();
		$this->check_access_right();
		
		#---------------- Checking Financial year is enabled / closed-----------------#
		$method_array = array('assign','delete','edit');
		fiscal_status($this->uri->segment(2),$method_array,"rejection_in_vehicles/assigned_vehicles");
		#---------------- Checking Financial year is enabled / closed-----------------#
		$this->load->library('Stock');
		$this->companyID = $this->session->userdata('company_id');
		$this->branchID = $this->session->userdata('under_id');
		$this->createdBY = $this->session->userdata('id');
		$fiscals = $this->dms->get_fiscal_year();
		$this->fiscal_start_date = $fiscals['start_date'];
		$this->fiscal_end_date = $fiscals['end_date'];		
	}
	
	public function assign(){
		
		$uriArray = $this->uri->uri_to_assoc(5);
		$urlString = $this->uri->assoc_to_uri($uriArray);
		if(!$this->uri->segment(4) || !is_numeric($this->uri->segment(4))){
			redirect('rejection_in/report');
		}
		$salesID = $this->uri->segment(4);
		$this->load->model('sales/Rejection_in_model','rejection_in');
		$this->template->title($this->lang->line('assign-vehicles'));
		$this->template->main_heading($this->lang->line('assign-vehicles'));
		$this->template->breadcrumb(array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line("rejection-in") => 'rejection_in/add',$this->lang->line('report') => 'rejection_in/report',$this->lang->line('assign-vehicles')=>'no_link',$this->lang->line('assigned-vehicles')=>'rejection_in_vehicles/assigned_vehicles/id/'.$salesID.'/'.$urlString));
		$inputSelects = array('vehicles','drivers','routes');
		$vehicles =$drivers = $routes= $sales_vehicles = $sales_driver = array();
		
		$args = array();
		$args['columns'] = array('a.vtype_id','a.bill_no','a.bill_date','a.group_id');
		$args['conditions'] = array('a.id'=>$salesID,'a.status'=>1);
		$args['limit'] = 1;$args['offset'] =0;
		$sales = $this->rejection_in->get_sales($args);
		if(empty($sales)){
			redirect('rejection_in/report');
		}
		$sales_group_id = $sales[0]['group_id'];
		$vtype_id = $sales[0]['vtype_id'];
		$bill_prefix = $this->stock->get_voucher_prefix($vtype_id);
		$this->load->library('Transport_lib');
		$vehicles = $this->transport_lib->vehicles();
		$drivers = $this->transport_lib->drivers();
		$routes = $this->transport_lib->routes();
		
		if($this->input->post('vehicle_type')){
			$this->form_validation->set_rules('vehicle_id','lang:vehicle','xss_clean|required');
			$this->form_validation->set_rules('driver_id','lang:driver','xss_clean|required');
		}else{
			$this->form_validation->set_rules('vehicle_no','lang:vehicle','xss_clean|required');
			$this->form_validation->set_rules('driver_name','lang:driver','xss_clean');
		}
		$this->form_validation->set_rules('route_id','lang:to','xss_clean|required');
		$this->form_validation->set_rules('km','lang:km','xss_clean|is_numeric|greater_or_equal[0]');

		if($this->form_validation->run() === true){
			
			$this->load->model('sales/Sales_return_vehicle_model','sales_return_vehicle');
			$postedValues = $this->input->post();
			$postedValues['group_id'] = $sales_group_id;

			$vehicle_type = 1;
			if($this->input->post('vehicle_type')){

				$postedValues['vehicle_type'] = 0;
				$args = array();
				$args['select'] = array('dsrv.id');
				$args['conditions'] = array('dsrv.group_id'=>$sales_group_id,'dsrv.vehicle_id'=>$postedValues['vehicle_id']);
				$sales_vehicle = $this->sales_return_vehicle->get($args);

				$args = array();
				$args['select'] = array('dsrv.id');
				$args['conditions'] = array('dsrv.group_id'=>$sales_group_id,'dsrv.driver_id'=>$postedValues['driver_id']);
				$sales_driver = $this->sales_return_vehicle->get($args);

			}else{

				$postedValues['vehicle_type'] = 1;
				$postedValues['vehicle_id'] = '';
				$postedValues['driver_id'] = '';

			}
			
			if(empty($sales_vehicle) && empty($sales_driver)){
				
				if($this->sales_return_vehicle->save($postedValues)){
					$this->message->set($this->lang->line('vehicle-assigned'));
					redirect('sales_return_vehicles/assign/avid/'.$salesID.'/'.$urlString);
				}else{
					$this->message->set($this->lang->line('vehicle-not-assigned'),'e');
				}
			}else{
				$this->message->set($this->lang->line('same-vehicle-exists'),'e');
			}

		}
		
		foreach($inputSelects as $key=>$selectBox){
			$arrayName = $$selectBox;
			$arrayName[''] = 'Select';
			$$selectBox = $arrayName;
			ksort($$selectBox);
		}		
		# view starts here--------------------------------
		$this->template->slice('dms/message');
		$this->template->slice('sales/rejection_in/assign_vehicles',array('vehicles'=>$vehicles,'drivers'=>$drivers,'routes'=>$routes,'sales'=>$sales[0],'bill_prefix'=>$bill_prefix));
		$this->template->other_script('vehicles/assign_vehicle');
		$this->template->render();
	}	
	
	#-----------------------------------------------------------------------------------------------
	
	public function assigned_vehicles(){
		
		#----------sales primary key
		$uri_array = $this->uri->uri_to_assoc(3);
		if(isset($uri_array['id']))
		{
			$salesID = $uri_array['id'];			
			unset($uri_array['id']);

			#----------redirect uri
			$redirect_uri = "rejection_in/report/".$this->uri->assoc_to_uri($uri_array);

			$this->load->model('sales/Rejection_in_model','rejection_in');
			$this->load->model('sales/Sales_return_vehicle_model','sales_return_vehicle');
			$this->template->title($this->lang->line('assigned-vehicles'));
			$this->template->main_heading($this->lang->line('assigned-vehicles'));
			$this->template->breadcrumb(array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line("rejection-in") => 'rejection_in/add',$this->lang->line('report') =>'rejection_in/report',$this->lang->line('assigned-vehicles')=>'no_link',$this->lang->line('assign-vehicles')=>'rejection_in_vehicles/assign/avid/'.$salesID.'/'.$this->uri->assoc_to_uri($uri_array),$this->lang->line("go-back") => $redirect_uri));
			$inputSelects = array('vehicles','drivers','routes');
			$vehicles =$drivers = $routes= $sales_vehicles = array();

			$args = array();
			$args['columns'] = array('a.bill_no','a.bill_date','a.group_id');
			$args['conditions'] = array('a.id'=>$salesID,'a.status'=>1);
			$args['limit'] = 1;$args['offset'] =0;
			$sales = $this->rejection_in->get_sales($args);
			if(empty($sales)){
				redirect('rejection_in/report');
			}
			$sales_group_id = $sales[0]['group_id'];	

			$args = array();
			$args['select'] = array('dsrv.id','rm.route_name','vm.vehicle_no','concat(u.fname," ",u.lname) as driver','u.mobile','dsrv.vehicle_type','dsrv.vehicle_no as vehicle_number','dsrv.km','dsrv.remarks','dsrv.driver_name');
			$args['conditions'] = array('dsrv.group_id'=>$sales_group_id);
			$args['join'] = array('route_master as rm'=>'dsrv.route_id=rm.id','vehicle_master as vm'=>'dsrv.vehicle_id=vm.id','users as u'=>'dsrv.driver_id=u.id');
			$sales_vehicles = $this->sales_return_vehicle->get($args);	
			if(empty($sales_vehicles)){
				$this->message->set($this->lang->line('no-vehicle-assigned'),'e');
			}
			
			# view starts here--------------------------------
			$this->template->slice('dms/message');
			$this->template->slice('sales/rejection_in/assigned_vehicles',array('sales_vehicles'=>$sales_vehicles));
			$this->template->render();
		} else {
			redirect('users/logout');
		}				
	}

	#-----------------------------------------------------------------------------------------------

	public function delete(){

		$uriArray = $this->uri->uri_to_assoc(5);
		$urlString = $this->uri->assoc_to_uri($uriArray);
		if(!$this->uri->segment(4) || !is_numeric($this->uri->segment(4))){
			redirect('rejection_in/report');
		}
		$sales_vehicleID = $this->uri->segment(4);
		if($this->if_exists('dms_sales_return_vehicles',array('id'=>$sales_vehicleID,'status'=>1)) === false){
				redirect('rejection_in/report');
		}
		$this->load->model('sales/Sales_return_vehicle_model','sales_return_vehicle');
				
		if($this->sales_return_vehicle->update(array('status'=>0),array('id'=>$sales_vehicleID))){
			$this->message->set($this->lang->line('sales-vehicle-removed'));
		}else{
			$this->message->set($this->lang->line('sales-vehicle-not-removed'));
		}
		redirect('rejection_in_vehicles/assigned_vehicles/'.$urlString);
	}

	#-----------------------------------------------------------------------------------------------

	public function edit(){
		
		$uriArray = $this->uri->uri_to_assoc(5);
		$urlString = $this->uri->assoc_to_uri($uriArray);
		if(!$this->uri->segment(4) || !is_numeric($this->uri->segment(4))){
			redirect('rejection_in/report');
		}
		
		$sales_vehicleID = $this->uri->segment(4);
		if($this->if_exists('dms_sales_return_vehicles',array('id'=>$sales_vehicleID,'status'=>1)) === false){
				redirect('rejection_in/report');
		}
		$this->load->model('sales/Sales_return_vehicle_model','sales_return_vehicle');
		$this->template->title($this->lang->line('assigned-vehicles'));
		$this->template->main_heading($this->lang->line('assigned-vehicles'));
		$this->template->breadcrumb(array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line("rejection-in") => 'rejection_in/add',$this->lang->line('report') =>'rejection_in/report',$this->lang->line('assigned-vehicles')=>'rejection_in_vehicles/assigned_vehicles/'.$urlString,$this->lang->line('update')=>'no_link'));
		$inputSelects = array('vehicles','drivers','routes');
		$vehicles =$drivers = $routes= $sales_vehicles = $sales_driver = array();		
		$sales_vehicle = array();
		
		$this->load->library('Transport_lib');
		$vehicles = $this->transport_lib->vehicles();
		$drivers = $this->transport_lib->drivers();
		$routes = $this->transport_lib->routes();
				
		$args = array();
		$args['select'] = array('dsrv.id','dsrv.group_id','dsrv.route_id','dsrv.vehicle_id','dsrv.driver_id','dsrv.km','dsrv.remarks','dsrv.vehicle_type','dsrv.vehicle_no','dsrv.driver_name','dsr.vtype_id','dsr.bill_no','dsr.bill_date');
		$args['conditions'] = array('dsrv.id'=>$sales_vehicleID);
		$args['join'] = array('dms_rejection_ins as dsr'=>'dsrv.group_id=dsr.group_id','route_master as rm'=>'dsrv.route_id=rm.id','vehicle_master as vm'=>'dsrv.vehicle_id=vm.id','users as u'=>'dsrv.driver_id=u.id');
		$sales_vehicles = $this->sales_return_vehicle->get($args);

		if($this->input->post('vehicle_type')){
			$this->form_validation->set_rules('vehicle_id','lang:vehicle','xss_clean|required');
			$this->form_validation->set_rules('driver_id','lang:driver','xss_clean|required');
		}else{
			$this->form_validation->set_rules('vehicle_no','lang:vehicle','xss_clean|required');
			$this->form_validation->set_rules('driver_name','lang:driver','xss_clean');
		}
		$this->form_validation->set_rules('route_id','lang:to','xss_clean|required');
		$this->form_validation->set_rules('km','lang:km','xss_clean|is_numeric|greater_or_equal[0]');
	
		if($this->form_validation->run() === true){
			
			$sales_group_id = $sales_vehicles[0]['group_id'];
			$postedValues = $this->input->post();
			$vehicle_type = 1;
			if($this->input->post('vehicle_type')){

				$postedValues['vehicle_type'] = 0;
				$postedValues['vehicle_no'] = '';
				$postedValues['driver_name'] = '';
				$args = array();
				$args['select'] = array('dsrv.id');
				$args['conditions'] = array('dsrv.id !='=>$sales_vehicleID,'dsrv.group_id'=>$sales_group_id,'vehicle_id'=>$postedValues['vehicle_id']);
				$sales_vehicle = $this->sales_return_vehicle->get($args);

				$args = array();
				$args['select'] = array('dsrv.id');
				$args['conditions'] = array('dsrv.id !='=>$sales_vehicleID,'dsrv.group_id'=>$sales_group_id,'driver_id'=>$postedValues['driver_id']);
				$sales_driver = $this->sales_return_vehicle->get($args);

			}else{
				$postedValues['vehicle_type'] = 1;
				$postedValues['vehicle_id'] = '';
				$postedValues['driver_id'] = '';	
			}

			if(empty($sales_vehicle) && empty($sales_driver)){
				if($this->sales_return_vehicle->update($postedValues,array('id'=>$sales_vehicleID))){
					$this->message->set($this->lang->line('vehicle-assigned-edit-success'));
					redirect('rejection_in_vehicles/assigned_vehicles/'.$urlString);
				}else{
					$this->message->set($this->lang->line('vehicle-not-assigned'),'e');
				}
			}else{
				$this->message->set($this->lang->line('same-vehicle-exists'),'e');
			}			
		}
		
		foreach($inputSelects as $key=>$selectBox){
			$arrayName = $$selectBox;
			$arrayName[''] = 'Select';
			$$selectBox = $arrayName;
			ksort($$selectBox);
		}	
				
		# view starts here--------------------------------
		$this->template->slice('dms/message');
		$this->template->slice('sales/rejection_in/edit_assigned_vehicles',array('vehicles'=>$vehicles,'drivers'=>$drivers,'routes'=>$routes,'sales_vehicle'=>$sales_vehicles));
		$this->template->other_script('vehicles/assign_vehicle');
		$this->template->render();					
	}
	
	#-----------------------------------------------------------------------------------------------	
}