<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

class Rejection_out extends MY_Controller{

	var $companyID,$branchID,$createdBY;
	public function __construct()
	{
		parent::__construct();

		$this->check_access_right();

		#---------------- Checking Financial year is enabled / closed-----------------#
		$method_array = array('add','delete_temp','update_temp','update','delete');
		fiscal_status($this->uri->segment(2),$method_array,"rejection_out/report");
		#---------------- Checking Financial year is enabled / closed-----------------#

		$this->load->model('purchase/Rejection_out_model','rejection_out');
		$this->load->model('vouchers/Voucher_model','vouchers');
		$this->load->library(array('Stock'));
		$this->companyID = $this->session->userdata('company_id');
		$this->branchID = $this->session->userdata('under_id');
		$this->createdBY = $this->session->userdata('id');

		#-----------fiscal year dates
		$fiscal_years = $this->dms->get_fiscal_year();
		$this->fiscal_start_date = $fiscal_years['start_date'];
		$this->fiscal_end_date = $fiscal_years['end_date'];

		#-----------checking branch_type
		$this->branch_status = 0;
		if($this->dms->branch_type()){
			$this->branch_status = 1;
		}

		#----------voucher type
		$this->vtype = 12;
	}

	public function add()
	{
		#----------voucher type
		$vtype_id = $this->vtype;

		#----------voucher type array
		$voucher_types = $this->vouchers->voucher_types($this->vtype);
		$bill_prefix = $this->stock->get_voucher_prefix($this->vtype);
		#----------voucher name
		$voucher_name = $this->vouchers->voucher_name($this->vtype);

		#-----------purchase cst checking details
		$purchase_cst = $this->stock->get_constant(array('purchase_cst'));

		#------------presumptive tax checking
		$presumptive_tax = $this->stock->get_tax_type();

		#------------cess %
		$cess = $this->stock->get_cess();

		#-----------purchase date and next bill no
		$rules = "callback_bill_no_exists";
		$disabled = "";
		$result_array = $this->rejection_out->next_bill_no($this->vtype);
		$vtype_id = $result_array['vtype_id'];
		$voucher_no = $result_array['bill_no'];
		$voucher_date = $result_array['bill_date'];
		if($result_array['vstatus']){

			$disabled = "readonly";
			$group_id = $result_array['group_id'];
			$voucher_details = $this->dms->get_data(array('table' => 'dms_vouchers as a','join' => array('table' => 'dms_rejection_outs as b','on' => 'a.table_group_id = b.group_id'),'columns' => 'b.id','conditions' => array('a.table_name' => 'dms_rejection_outs','a.table_group_id' => $group_id)));
			if(!empty($voucher_details)){
				redirect("rejection_out/update/".$voucher_details[0]['id']);
			}
			$rules = "callback_bill_no_exists[$vtype_id.$group_id]";

			#------------checking cst enabled or not
			$cst_status = $this->rejection_out->get_cst($group_id);
			if($cst_status){
				$purchase_cst = $cst_status;
			}
		}else{
			$group_id = $this->stock->get_group_id('dms_purchase_return_items1');
		}

		#-------------adding data to purchase temp
		if(isset($_POST['btn_add']))
		{
			#-----------validation
			$this->form_validation->set_rules('vtype_id','lang:voucher-types','required|xss_clean');
			$this->form_validation->set_rules('bill_no','lang:bill-no',"required|xss_clean|is_natural_no_zero|".$rules);
			$this->form_validation->set_rules('bill_date','lang:bill-date','required|xss_clean|valid_date');
			$this->form_validation->set_rules('vendor_id','lang:vendor','required|xss_clean');
			$this->form_validation->set_rules('item_id','lang:item-name',"required|xss_clean");
			$this->form_validation->set_rules('godown_id','lang:godown','required|xss_clean');
			$this->form_validation->set_rules('cst','lang:cst','xss_clean|greater_or_equal[0]|less_or_equal[100]');
			$this->form_validation->set_rules('qty','lang:quantity','required|xss_clean|greater_than[0]|less_than[100000000]|callback_check_bill_qty');
			$this->form_validation->set_rules('unit_id','lang:unit','required|xss_clean');
			$this->form_validation->set_rules('rate','lang:rate','required|xss_clean|greater_or_equal[0]|less_than[100000000]');
			$this->form_validation->set_rules('amount','lang:amount','xss_clean|required|greater_or_equal[0]|less_than[100000000]');

			#-----------adding temporary data
			if($this->form_validation->run('btn_add') === true)
			{
				$item_array = $this->input->post(NULL,true);
				unset($item_array['vtype_id']);
				unset($item_array['bill_no']);
				unset($item_array['bill_date']);
				unset($item_array['return_bill_no']);
				unset($item_array['vendor_id']);
				unset($item_array['btn_add']);
				$item_array['group_id'] = $group_id;
				$item_array['status'] = -1;

				#----------rate calculation
				$item_array['rate'] = 0;
				if($item_array['qty'] != 0){
					$item_array['rate'] = $item_array['amount'] / $item_array['qty'];
				}

				#------------checking same item,godown,unit with same group_id exists
			/*	$purchase_temp_item_result = $this->rejection_out->get_purchases(array('columns' => array('b.id'),'conditions' => array('b.group_id' => $group_id,'item_id' => $item_array['item_id'],'godown_id' => $item_array['godown_id'],'unit_id' => $item_array['unit_id'],'a.status !=' => 0,'b.status !=' => 0),'numrows' => true));
				if(empty($purchase_temp_item_result))
				{   */
					$purchase_temp_item_result = $this->rejection_out->get_purchases_gst(array('columns' => array('b.id'),'conditions' => array('b.group_id' => $group_id,'item_id' => $item_array['item_id'],'godown_id' => $item_array['godown_id'],'unit_id' => $item_array['unit_id'],'a.status !=' => 0,'b.status !=' => 0),'numrows' => true));	
			//	}
				if($purchase_temp_item_result == 0)
				{
					#----------VAT calculation
			/*		$cst = 0;
					if(isset($item_array['cst'])){
						$cst = $item_array['cst'];
					}
					if(empty($presumptive_tax)){
						if($cst == 0){
							$vat_percent = $this->stock->get_item_vat($item_array['item_id']);
							$item_array['vat_percent'] = $vat_percent;
							$item_array['vat_amt'] = (($item_array['amount']-$item_array['discount_amt']) * $vat_percent) / 100;
						}
					}	*/
					
					$cgst = $this->stock->get_item_cgst($item_array['item_id']);
					$sgst = $this->stock->get_item_sgst($item_array['item_id']);
					$item_array['cgst'] = $cgst;
					$item_array['sgst'] = $sgst;
					$item_array['cgst_amt'] = (($item_array['amount']-$item_array['discount_amt']) * $cgst) / 100;
					$item_array['sgst_amt'] = (($item_array['amount']-$item_array['discount_amt']) * $sgst) / 100;
					#----------start transaction
					$this->db->trans_start();

					#-----------bill date and next bill no
					if($result_array['vstatus'] == 0)//data not in dms_purchase_returns
					{
						$purchase_temp_array['vtype_id'] = $this->input->post('vtype_id',true);
						$purchase_temp_array['branch_id'] = $this->branchID;
						$purchase_temp_array['group_id'] = $group_id;
						$purchase_temp_array['bill_no'] = $this->input->post('bill_no',true);
						$purchase_temp_array['bill_date'] = date('Y-m-d',strtotime($this->input->post('bill_date',true)));
						if($this->input->post('return_bill_no',true) && $this->input->post('return_bill_no',true) != ""){
							$purchase_temp_array['return_bill_no'] = $this->input->post('return_bill_no',true);
						}
						$purchase_temp_array['vendor_id'] = $this->input->post('vendor_id',true);
						$voucher_date = $purchase_temp_array['bill_date'];
						$purchase_temp_array['status'] = -1;
						$this->rejection_out->insert("dms_rejection_outs",$purchase_temp_array);
					}

					#--------------adding purchase items
					$purchase_items_id = $this->rejection_out->insert("dms_purchase_return_items1",$item_array);
					if($purchase_items_id)
					{
						#--------------adding temporary stock balance in dms_stocks
						$stock_bal_temp = $this->stock->unit_conversion($item_array['item_id'],$item_array['unit_id'],$item_array['qty'],$item_array['rate'],$item_array['amount']);
						if($stock_bal_temp)
						{
							$this->rejection_out->insert('dms_stocks',array('company_id' => $this->companyID,'branch_id' => $this->session->userdata('under_id'),'godown_id' => $item_array['godown_id'],'item_id' => $item_array['item_id'],'qty' => $stock_bal_temp['qty'],'unit_id' => $stock_bal_temp['primary_unit'],'rate' => $stock_bal_temp['rate'],'amount' => $stock_bal_temp['amount'],'stock_date' => $voucher_date,'stock_status' =>3,'table_group_id' => $group_id,'table_id' => $purchase_items_id,'status' => -1));
						}
						$this->message->set($this->lang->line('rejection-out-add-success'));
					}
					else
					{
						$this->message->set($this->lang->line('rejection-out-add-error'),'e');
					}

					#----------end transaction
					$this->db->trans_complete();
				}
				else{
					$this->message->set($this->lang->line('rejection-out-add-error'),'e');
				}
				redirect('rejection_out/add');
			}
		}

		#------------saving purchase_return voucher
		if(isset($_POST['btn_save']))
		{

			$this->form_validation->set_rules('remarks','lang:remarks','xss_clean');
			$this->form_validation->set_rules('freight','lang:freight','xss_clean|greater_or_equal[0]|less_than[100000000]');
			$this->form_validation->set_rules('other_expense','lang:other-expense','xss_clean|greater_or_equal[0]|less_than[100000000]');

			#-----------saving data
			if($this->form_validation->run('btn_save') === true)
			{
				$narration = $this->input->post('remarks',true);

				$purchase_entry_array=array('bill_freight' => $this->input->post('freight',true),'other_expense' => $this->input->post('other_expense',true),'cess' => $cess,'narration' => $narration,'status' =>1,'p_status' =>0,'bill_status'=> $this->branch_status);
				$purchase_entry_check = $this->rejection_out->get_bills(array('columns' => array('vtype_id','bill_no','bill_date','return_bill_no'),'conditions' => array('group_id' => $group_id,'status !=' => 0)));
				if($purchase_entry_check)
				{
					$bill_date = $purchase_entry_check[0]['bill_date'];
					$vtype_id = $purchase_entry_check[0]['vtype_id'];
					$bill_no = $purchase_entry_check[0]['bill_no'];

					#----------start transaction-----------------------
					$this->db->trans_start();

					if($this->rejection_out->update(array('table' => 'dms_rejection_outs','data' => $purchase_entry_array,'conditions' => array('group_id' => $group_id)))){
						$this->rejection_out->update(array('table' => 'dms_purchase_return_items1','data' => array('status' => 1),'conditions' => array('group_id' => $group_id,'status !=' => 0)));

						#-------------changing bill status in dms_purchases
						if($purchase_entry_check[0]['return_bill_no'] > 0){
							$this->rejection_out->update_others(array('table' => 'dms_purchases','data' => array('r_status' =>1),'conditions' => array('id' => $purchase_entry_check[0]['return_bill_no'])));
						}

						if($this->branch_status){

							#-------------enabling temporarily added stocks in dms_stocks
							$purchase_items_array = $this->rejection_out->get_purchase_itemss(array('columns' => array('id'),'conditions' => array('group_id' => $group_id,'status' => 1)));print_r($purchase_items_array);
							foreach($purchase_items_array as $key => $value){
								$this->rejection_out->update_others(array('table' => 'dms_stocks','data' => array('status' => 1),'conditions' => array('stock_status' =>3,'table_id' => $value['id'])));
							}
						}
						$this->message->set($this->lang->line('rejection-out-save-success'));
					}else{
						$this->message->set($this->lang->line('rejection-out-save-error'),'e');
					}

					#----------transaction completed
					$this->db->trans_complete();
				}else{
					$this->message->set($this->lang->line('rejection-out-save-error'),'e');
				}
				redirect('rejection_out/add');
			}
		}

		#------------vendor details and return bill details
		$vendor_id = "";$return_bill = "";

		#------------item details / unit details / godown details
		$units = $items = $goDowns = array();
		$units[''] = "Select";

		if($result_array['vstatus'] > 0 && $result_array['return_bill_no'] > 0)
		{
			$return_bill = $result_array['return_bill_no'];
			$vendors = $this->rejection_out->get_vendor($return_bill);
			$return_bills[$return_bill] = $this->rejection_out->get_bill_no($return_bill);
			$items = $this->rejection_out->get_bill_itemss($return_bill);
		}
		else
		{
			if($this->input->post('return_bill_no',true) && $this->input->post('return_bill_no',true) != ""){
				$return_bill = $this->input->post('return_bill_no',true);
				$vendors = $this->rejection_out->get_vendor($return_bill);
				$return_bills[$return_bill] = $this->rejection_out->get_bill_no($return_bill);
				$items = $this->rejection_out->get_bill_itemss($return_bill);
			}
			else
			{
				$return_bills = $this->rejection_out->get_purchase_bills();
				$vendors = $this->stock->get_vendors();
				$args['select'] = array('id','item_code','item_name');
				$items = $this->stock->get_stock_items($args);
				if(empty($items)){
					$this->message->set($this->lang->line('no-items-found'),'i');
				}
			}
			$return_bills[''] = 'Select';ksort($return_bills);
			$vendors[''] = 'Select';ksort($vendors);
		}
		if($this->input->post('item_id',true)){
			$itemID = $this->input->post('item_id',true);
			$goDowns = $this->stock->get_item_godowns(array('item_id'=>$itemID,'listing'=>1));
			$units = $this->stock->get_units($itemID);
		}

		#------------purchase_return temp data
		$purchase_temp_data = array();
		$stock_count = $primary_unit['symbol'] = "";
		if($result_array['vstatus'])
		{
	//		$purchase_temp_data = $this->rejection_out->get_purchases(array('columns' => array('a.group_id','a.vendor_id','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.godown_id','b.vat_amt','b.cst'),'conditions' => array('a.created_by' => $this->createdBY,'vtype_id' => $vtype_id,'bill_no' => $voucher_no,'a.status =' => -1,'b.status =' => -1)));
	
			$purchase_temp_data = $this->rejection_out->get_purchases_gst(array('columns' => array('a.group_id','a.vendor_id','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.godown_id','b.cgst_amt','b.sgst_amt'),'conditions' => array('a.created_by' => $this->createdBY,'vtype_id' => $vtype_id,'bill_no' => $voucher_no,'a.status =' => -1,'b.status =' => -1)));

			$vendor_id = $purchase_temp_data[0]['vendor_id'];
		}
		else
		{
			$purchase_array = $this->input->post('purchase',true);

			#------------stock count of this item
			if($this->input->post('item_id',true) && $this->input->post('godown_id',true) && $purchase_array['bill_date'] != ""){
				$stock_count = $this->stock->get_stock_count($this->input->post('godown_id',true),$this->input->post('item_id',true),$purchase_array['bill_date']);
				$primary_unit = $this->stock->get_primary_unit($this->input->post('item_id',true));
			}
		}
		$items[''] = 'Select';ksort($items);
		$goDowns[''] = 'Select';ksort($goDowns);

		#------------template
		$this->template->title($this->lang->line("$voucher_name"));
		$this->template->main_heading($this->lang->line("$voucher_name"));
		$this->template->breadcrumb(array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line("$voucher_name") => 'no_link',$this->lang->line("report") => 'rejection_out/report'));
		$this->template->slice('dms/message');
		$this->template->slice('purchase/rejection_out/add',array('voucher_types' => $voucher_types,'voucher_type' => $vtype_id,'voucher_name' => $voucher_name,'voucher_no' => $voucher_no,'voucher_date' => $voucher_date,'return_bills' => $return_bills,'return_bill' => $return_bill,'vendors' => $vendors,'items' => $items,'units' => $units,'goDowns' => $goDowns,'purchase_temp_status' =>$result_array['vstatus'],'purchase_temp_data' => $purchase_temp_data,'vendor_id' => $vendor_id,'purchase_cst' => $purchase_cst,'presumptive_tax' => $presumptive_tax,'cess' => $cess,'disabled' => $disabled,'stock_count' => $stock_count,'primary_unit' => $primary_unit['symbol'],'bill_prefix'=>$bill_prefix));
		$this->template->other_script('purchase/rejection_out');
		$this->template->render();
	}

	public function delete_temp()
	{
		#----------rejection out temp data
		$uri_array = $this->uri->uri_to_assoc(3);
		if(isset($uri_array['idu']) || isset($uri_array['ida']))
		{
			if(isset($uri_array['idu']))
			{
				$id = $uri_array['idu'];
				unset($uri_array['idu']);

				#-----------redirect uri
				$redirect_uri = "rejection_out/update/".$this->uri->assoc_to_uri($uri_array);
			}
			else
			{
				$id = $uri_array['ida'];
				unset($uri_array['ida']);

				#-----------redirect uri
				$redirect_uri = "rejection_out/add/".$this->uri->assoc_to_uri($uri_array);
			}

			$result = $this->rejection_out->get_purchase_itemss(array('columns' => array('group_id','status','created_by'),'conditions' => array('id' => $id,'status !=' => 0)));
			if(!empty($result))
			{
				$row = $result[0];
				if($row['status'] == -1)
				{
					if($row['created_by'] == $this->createdBY)
					{
						#----------start transaction
						$this->db->trans_start();

						if($this->rejection_out->delete(array('table' => 'dms_purchase_return_items1','conditions' => array('id' => $id))))
						{
							#-------------deleting stock bal. from dms_stocks
							$this->rejection_out->delete(array('table' => 'dms_stocks','conditions' => array('table_id' => $id,'stock_status' => 3)));

							$count = $this->rejection_out->get_purchase_itemss(array('columns' => array('group_id'),'conditions' => array('group_id' => $row['group_id'],'status !=' => 0),'numrows' => true));
							if($count == 0){
								$this->rejection_out->delete(array('table' => 'dms_rejection_outs','conditions' => array('group_id' => $row['group_id'])));
							}
							$this->message->set($this->lang->line('rejection-out-item-delete-success'));
						}
						else
						{
							$this->message->set($this->lang->line('rejection-out-item-delete-error'),'e');
						}

						#----------end transaction
						$this->db->trans_complete();
					}
					else
					{
						redirect('users/logout');
					}
				}
				else
				{
					#----------start transaction
					$this->db->trans_start();

					#-------------deleting item from dms_purchase_return_items
					$this->rejection_out->update(array('table' => 'dms_purchase_return_items1','data' => array('status' => 0),'conditions' => array('id' => $id)));

					#-------------changing purchase_return bill status
					$this->rejection_out->update(array('table' => 'dms_rejection_outs','data' => array('status' => -1),'conditions' => array('group_id' => $row['group_id'])));

					#-------------deleting stock bal. from dms_stocks
					$this->rejection_out->update_others(array('table' => 'dms_stocks','data' => array('status' => 0),'conditions' => array('table_id' => $id,'stock_status' => 3)));

					#-------------checking whether purchase_return bill is deleted
					$count = $this->rejection_out->get_purchase_itemss(array('columns' => array('group_id'),'conditions' => array('group_id' => $row['group_id'],'status !=' => 0),'numrows' => true));
					if($count == 0){

						#-------------deleting purchase_return bill
						$this->rejection_out->update(array('table' => 'dms_rejection_outs','data' => array('status' => 0),'conditions' => array('group_id' => $row['group_id'])));

						#-----------redirect uri
						$redirect_uri = "rejection_out/report/".$this->uri->assoc_to_uri($uri_array);

					}

					#----------end transaction
					$this->db->trans_complete();

					$this->message->set($this->lang->line('rejection-out-item-delete-success'));
				}
			}
			redirect($redirect_uri);
		}
		redirect('users/logout');
	}

	public function update_temp()
	{
		#----------rejection out temp data
		$uri_array = $this->uri->uri_to_assoc(3);
		if(isset($uri_array['idu']) || isset($uri_array['ida']))
		{
			if(isset($uri_array['idu']))
			{
				$purchase_temp_id = $uri_array['idu'];
				unset($uri_array['idu']);

				#-----------redirect uri
				$redirect_uri = "rejection_out/update/".$this->uri->assoc_to_uri($uri_array);
			}
			else
			{
				$purchase_temp_id = $uri_array['ida'];
				unset($uri_array['ida']);

				#-----------redirect uri
				$redirect_uri = "rejection_out/add/".$this->uri->assoc_to_uri($uri_array);
			}

			$row = $this->rejection_out->get_purchases_gst(array('columns' => array('a.group_id','a.bill_date','a.return_bill_no','b.id','b.item_id','b.godown_id','b.qty','b.unit_id','b.rate','b.amount','b.vat_amt','b.cst','b.status','b.created_by'),'conditions' => array('b.id' => $purchase_temp_id,'b.status !=' => 0)));
			if(!empty($row))
			{
				$purchase_temp_data = $row[0];$continue = 1;
				if($purchase_temp_data['status'] == -1){
					if($purchase_temp_data['created_by'] != $this->createdBY){
						$continue = 0;
					}
				}
				if($continue == 1)
				{
					$rules = "callback_check_bill_qty";
					if($purchase_temp_data['return_bill_no'] > 0){
						$rules = "callback_check_bill_qty[$purchase_temp_data[return_bill_no].$purchase_temp_data[item_id].$purchase_temp_id]";
					}
					#-----------validation
					$this->form_validation->set_rules('godown_id','lang:godown','required|xss_clean');
					$this->form_validation->set_rules('cst','lang:cst','xss_clean|greater_or_equal[0]|less_or_equal[100]');
					$this->form_validation->set_rules('qty','lang:quantity',"required|xss_clean|greater_than[0]|less_than[100000000]|".$rules);
					$this->form_validation->set_rules('unit_id','lang:unit','required|xss_clean');
					$this->form_validation->set_rules('rate','lang:rate','required|xss_clean|greater_or_equal[0]|less_than[100000000]');
					$this->form_validation->set_rules('amount','lang:amount','xss_clean|required|greater_or_equal[0]|less_than[100000000]');

					#-----------updating temporary data
					if($this->form_validation->run() === true)
					{
						$item_temp_array = $this->input->post(NULL,true);
						$item_temp_array['status'] = -1;

						#----------rate calculation
						$item_temp_array['rate'] = 0;
						if($item_temp_array['qty'] != 0){
							$item_temp_array['rate'] = $item_temp_array['amount'] / $item_temp_array['qty'];
						}

						#----------start transaction
						$this->db->trans_start();

						$this->rejection_out->update_others(array('table' => 'dms_purchase_return_items1','data' => $item_temp_array,'conditions' => array('id' => $purchase_temp_id)));

						#--------------updating bill status in dms_purchases
						$this->rejection_out->update_others(array('table' => 'dms_rejection_outs','data' => array('status' => -1),'conditions' => array('group_id' => $purchase_temp_data['group_id'])));

						$this->message->set($this->lang->line('rejection-out-edit-temp-success'));

						#--------------updating temporary stock balance in dms_stocks
						$stock_bal_temp = $this->stock->unit_conversion($purchase_temp_data['item_id'],$item_temp_array['unit_id'],$item_temp_array['qty'],$item_temp_array['rate'],$item_temp_array['amount']);
						if($stock_bal_temp)
						{
							$this->rejection_out->update_others(array('table' => 'dms_stocks','data' => array('godown_id' => $item_temp_array['godown_id'],'qty' => $stock_bal_temp['qty'],'unit_id' => $stock_bal_temp['primary_unit'],'rate' => $stock_bal_temp['rate'],'amount' => $stock_bal_temp['amount']),'conditions' => array('stock_status' =>3,'table_id' => $purchase_temp_id)));
						}
						#----------end transaction
						$this->db->trans_complete();

						redirect($redirect_uri);
					}

					#----------voucher name
					$voucher_name = $this->vouchers->voucher_name($this->vtype);

					#-----------purchase cst checking details
					$purchase_cst = $this->stock->get_constant(array('purchase_cst'));

					#------------presumptive tax checking
					$presumptive_tax = $this->stock->get_tax_type();

					#------------checking cst enabled or not
					$cst_status = $this->rejection_out->get_cst($purchase_temp_data['group_id']);
					if($cst_status){
						$purchase_cst = $cst_status;
					}

					#------------item details / unit details / godown details
					$units = array();$goDowns = array();
					$item_details = $this->stock->get_item($purchase_temp_data['item_id'],array('item_code','item_name'));
					$items[$purchase_temp_data['item_id']] = $item_details['item_code']." / ".$item_details['item_name'];
					$goDowns = $this->stock->get_item_godowns(array('item_id'=>$purchase_temp_data['item_id'],'listing'=>1));
					$goDowns[''] = 'Select';
					ksort($goDowns);
					$units = $this->stock->get_units($purchase_temp_data['item_id']);

					#------------purchase_return date
					$purchase_date = $purchase_temp_data['bill_date'];

					#------------stock count of this item
					$stock_count = $this->stock->get_stock_count($purchase_temp_data['godown_id'],$purchase_temp_data['item_id'],$purchase_date);


					#------------primary unit details
					$primary_unit = $this->stock->get_primary_unit($purchase_temp_data['item_id']);

					#------------template
					$this->template->title($this->lang->line("$voucher_name"));
					$this->template->main_heading($this->lang->line("$voucher_name"));
					$this->template->breadcrumb(array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line("$voucher_name") => 'rejection_out/add',$this->lang->line("update") => 'no_link',$this->lang->line('report') => 'rejection_out/report',$this->lang->line('go-back') => array($redirect_uri)));

					$this->template->slice('dms/message');
					$this->template->slice('purchase/rejection_out/edit_temp',array('voucher_name' => $voucher_name,'items' => $items,'units' => $units,'goDowns' => $goDowns,'purchase_temp_data' => $purchase_temp_data,'purchase_cst' => $purchase_cst,'presumptive_tax' => $presumptive_tax,'stock_count' => $stock_count,'unit_symbol' => $primary_unit['symbol'],'purchase_date' => $purchase_date));
					$this->template->other_script('purchase/rejection_out');
					$this->template->render();
				}
				else
				{
					redirect('users/logout');
				}
			}
			else
			{
				redirect('users/logout');
			}
		}
		else
		{
			redirect('users/logout');
		}
	}

	public function bill_no_exists($bill_no,$v_details = NULL)
	{
		if($v_details == NULL){
			$where = array('vtype_id' => $this->input->post('vtype_id',true),'bill_no' => $bill_no,'status !=' => 0);
		}
		else{
			$exp = explode('.', $v_details);
			$where = array('vtype_id' => $exp[0],'bill_no' => $bill_no,'group_id !=' => $exp[1],'status !=' => 0);
		}
		$row = $this->rejection_out->get_bills(array('columns' => array('id'),'conditions' => $where,'numrows' => true));
		if($row == 0){
			return true;
		}
		return false;
	}

	public function report()
	{
		#----------voucher type
		$vtype_id = $this->vtype;
		$conditions = array('vtype_id' => $vtype_id,'status' => 1);
		$like_array = array();$vnos="";

		#----------voucher name
		$voucher_name = $this->vouchers->voucher_name($this->vtype);

		#----------voucher type array
		$voucher_types = $this->vouchers->voucher_types($this->vtype);

		#----------uri array
		$uri_array  = $this->uri->uri_to_assoc(3);

		#----------redirect
		$redirect = "";

		#----------pagination
		$this->load->library('Pagination');
		$config['per_page'] = $this->per_page();
		$config['base_url'] = base_url('rejection_out/report');
		$config['uri_segment'] = 3;

		#----------dates within financial year
		$cur_date = date('Y-m-d');
		$from_date = $cur_date;
		$to_date = $cur_date;
		$cur_fiscal_yr = $this->dms->get_fiscal_year();
		if($from_date < $cur_fiscal_yr['start_date'] || $from_date > $cur_fiscal_yr['end_date'] || $to_date < $cur_fiscal_yr['start_date'] || $to_date > $cur_fiscal_yr['end_date'])
		{
			$from_date = $cur_fiscal_yr['end_date'];
			$to_date = $cur_fiscal_yr['end_date'];
		}

		#----------validation
		$this->form_validation->set_rules('vtype_id','voucher-types','required|xss_clean');
		$this->form_validation->set_rules('from_date','From Date','required|xss_clean|valid_date');
		$this->form_validation->set_rules('to_date','To Date','required|xss_clean|valid_date');
		$this->form_validation->set_rules('bill_no','bill-no','xss_clean|trim');
		if($this->form_validation->run() === true)
		{
			$vtype_id = $this->input->post('vtype_id',true);
			$from_date = date('Y-m-d',strtotime($this->input->post('from_date',true)));
			$to_date = date('Y-m-d',strtotime($this->input->post('to_date',true)));
			$conditions['vtype_id'] = $vtype_id;
			$config['base_url'] .= '/vt/'.$vtype_id.'/fdate/'.$from_date.'/tdate/'.$to_date;
			$config['uri_segment'] += 6;
			$redirect .= '/vt/'.$vtype_id.'/fdate/'.$from_date.'/tdate/'.$to_date;
			if(!empty($this->input->post('bill_no',true)))
			{
				$vnos = $this->input->post('bill_no',true);
				$like_array['bill_no'] = $vnos;
				$config['base_url'] .= '/vn/'.$vnos;
				$config['uri_segment'] += 2;
				$redirect .= '/vn/'.$vnos;
			}
		}
		elseif(isset($uri_array['vt']))
		{
			$vtype_id = $uri_array['vt'];
			$conditions['vtype_id'] = $vtype_id;
			$config['base_url'] .= '/vt/'.$conditions['vtype_id'];
			$config['uri_segment'] += 2;
			$redirect .= '/vt/'.$vtype_id;
			if(isset($uri_array['fdate']) && isset($uri_array['tdate']))
			{
				$from_date = date('Y-m-d',strtotime($uri_array['fdate']));
				$to_date = date('Y-m-d',strtotime($uri_array['tdate']));
				$config['base_url'] .= '/fdate/'.$from_date.'/tdate/'.$to_date;
				$config['uri_segment'] += 4;
				$redirect .= '/fdate/'.$from_date.'/tdate/'.$to_date;
			}
			if(isset($uri_array['vn']))
			{
				$vnos = $uri_array['vn'];
				$like_array['bill_no'] = $vnos;
				$config['base_url'] .= '/vn/'.$vnos;
				$config['uri_segment'] += 2;
				$redirect .= '/vn/'.$vnos;
			}
		}

		#----------between condition
		$between = "bill_date between '$from_date' and '$to_date'";

		#----------total rows
		$config['total_rows'] = $this->rejection_out->get_bills(array('columns' => array('id'),'conditions' => $conditions,'between' => $between,'like' => $like_array,'numrows'=>true));

		if($config['total_rows'] == 0){
			$this->message->set($this->lang->line('no-voucher'),'i');
		}

		#----------pagination
		$offset = $this->uri->segment($config['uri_segment'],0);
		# Pagination Config Customizations
        $config['full_tag_open'] = '<ul class="pagination">';
        $config['full_tag_close'] = '</ul>';
        $config['first_link'] = 'First';
        $config['last_link'] = 'Last';
        $config['next_link'] = '&raquo;';
        $config['prev_link'] = '&laquo;';
        $config['cur_tag_open'] = '<li class="active"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
		$this->pagination->initialize($config);
		$links = $this->pagination->create_links();
		$redirect .= '/'.$offset;

		#------------presumptive tax checking
		$presumptive_tax = $this->stock->get_tax_type();

		#----------purchase_return report datas
		$purchase_array=$this->rejection_out->get_bills(array('conditions' => $conditions,'between' => $between,'like' => $like_array,'order_by'=>'bill_date','order'=>'DESC','limit'=>$config['per_page'],'offset'=>$offset));

		#----------template
		$this->template->title($this->lang->line("$voucher_name"));
		$this->template->main_heading($this->lang->line("$voucher_name")." ".$this->lang->line("report"));
		$this->template->breadcrumb(array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line("$voucher_name") => 'rejection_out/add',$this->lang->line('report') => 'no_link'));
		$this->template->slice('sales/sales_entry/search',array('voucher_types' => $voucher_types,'vtype_id' => $vtype_id,'vnos' => $vnos,'from_date' => $from_date,'to_date' => $to_date,'rtype' => 'rejection_out'));
		$this->template->slice('dms/message');
		if(!empty($purchase_array))
		{
			$this->template->slice('purchase/rejection_out/report',array('purchase_array' =>$purchase_array,'branch_type' => $this->branch_status,'presumptive_tax' => $presumptive_tax,'offset' => $offset,'links' => $links,'redirect' => $redirect));
			$this->template->slice('dms/modals/delete_confirm');
		}
		$this->template->other_script('purchase/rejection_out');
		$this->template->render();
	}

	public function view()
	{
		#----------voucher type
		$vtype_id = $this->vtype;

		#----------rejection out primary key
		$uri_array = $this->uri->uri_to_assoc(3);
		if(isset($uri_array['id']) || isset($uri_array['group_id']))
		{
			#----------voucher name
			$voucher_name = $this->vouchers->voucher_name($this->vtype);

			#----------breadcrumb
			$breadcrumb = array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line("$voucher_name") => 'rejection_out/add',$this->lang->line('report') => 'rejection_out/report',$this->lang->line("view") => 'no_link');

			if(isset($uri_array['group_id']))
			{
				$conditions = array('a.group_id' => $uri_array['group_id'],'a.status !=' => 0,'b.status !=' => 0);
				if(isset($uri_array['id']) || isset($uri_array['mid']) || isset($uri_array['sid']))
				{
					if(isset($uri_array['id'])){
						$breadcrumb_url = "stock_item_register/index/id/".$uri_array['id'];
					}
					elseif(isset($uri_array['mid'])){
						$breadcrumb_url = "stock_item_register/index/mid/".$uri_array['mid'];
					}
					elseif(isset($uri_array['sid'])){
						$breadcrumb_url = "stock_item_register/index/sid/".$uri_array['sid'];
					}
					if(isset($uri_array['rtype'])){
						$breadcrumb_url .= "/rtype/".$uri_array['rtype'];
					}
					$breadcrumb[$this->lang->line("go-back")] = $breadcrumb_url;
				}
			}
			else
			{
				$purchase_id = $uri_array['id'];
				unset($uri_array['id']);
				$conditions = array('a.id' => $purchase_id,'a.status !=' => 0,'b.status !=' => 0);
				$breadcrumb[$this->lang->line("go-back")] = "rejection_out/report/".$this->uri->assoc_to_uri($uri_array);
			}

			#----------purchase_return data
			$purchase_array = $this->rejection_out->get_purchases(array('columns' => array('a.id as primary_id','a.vtype_id','a.bill_no','a.bill_date','a.return_bill_no','a.group_id','a.vendor_id','a.bill_freight','a.other_expense','a.cess','a.narration','a.created_by','a.created_on','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.godown_id','b.vat_amt','b.cst'),'conditions' => $conditions));
			if(empty($purchase_array))
			{
				$purchase_array = $this->rejection_out->get_purchases_gst(array('columns' => array('a.id as primary_id','a.vtype_id','a.bill_no','a.bill_date','a.return_bill_no','a.group_id','a.vendor_id','a.bill_freight','a.other_expense','a.cess','a.narration','a.created_by','a.created_on','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.godown_id','b.cgst_amt','b.sgst_amt'),'conditions' => $conditions));
			}
			if(!empty($purchase_array))
			{
				#------------presumptive tax checking
				$presumptive_tax = $this->stock->get_tax_type();

				#------------checking cst enabled or not
				$purchase_cst = $this->rejection_out->get_cst($purchase_array[0]['group_id']);
				$voucher_type = $this->vouchers->voucher_name($purchase_array[0]['vtype_id']);

				#-------------return bill details
				$return_bill_no = "";
				if($purchase_array[0]['return_bill_no'] > 0){
					$vendors = $this->rejection_out->get_vendor($purchase_array[0]['return_bill_no']);
					$return_bill_no = $this->rejection_out->get_bill_no($purchase_array[0]['return_bill_no']);
				}else{
					$vendors[''] = $this->stock->vendor_name($purchase_array[0]['vendor_id']);
				}

				#--------------cheque / dd details
				$cd_status = 1;$ccd = $cd_no = $pdc = "";
				$cheque_dd_array = $this->vouchers->cheque_data(array('columns' => array('b.cash_type','b.cd_no','b.pdc'),'conditions' => array('a.table_name' => 'dms_purchase_returns','a.table_group_id' => $purchase_array[0]['group_id'])));
				if(!empty($cheque_dd_array))
				{
					$cd_status = 0;
					$ccd = $cheque_dd_array[0]['cash_type'];
					$cd_no = $cheque_dd_array[0]['cd_no'];
					$pdc = $cheque_dd_array[0]['pdc'];
				}

				#----------template
				$report_head = $this->lang->line("$voucher_name")." ".$this->lang->line("view");
				$this->template->title($report_head);
				$this->template->main_heading($report_head);
				$this->template->breadcrumb($breadcrumb);
				$this->template->slice('dms/message');
				$this->template->slice('purchase/rejection_out/view',array('purchase_array' => $purchase_array,'return_bill_no' => $return_bill_no,'presumptive_tax' => $presumptive_tax,'purchase_cst' => $purchase_cst,'voucher_type' => $voucher_type,'vendors' => $vendors));
				$this->template->other_script('purchase/rejection_out');
				$this->template->render();
			}
			else
			{
				redirect('users/logout');
			}
		}
		else
		{
			redirect('users/logout');
		}
	}

	public function update()
	{
		#----------voucher type
		$vtype_id = $this->vtype;

		#----------rejection out primary key
		$uri_array = $this->uri->uri_to_assoc(3);
		if(isset($uri_array['id']))
		{
			$purchase_id = $uri_array['id'];
			$redirect = "/".$this->uri->assoc_to_uri($uri_array);
			unset($uri_array['id']);

			#----------redirect uri
			$redirect_uri = "rejection_out/report/".$this->uri->assoc_to_uri($uri_array);

			#----------redirect uri while updating
			$update_uri = $this->uri->assoc_to_uri($this->uri->uri_to_assoc(1));

			#----------voucher name
			$voucher_name = $this->vouchers->voucher_name($this->vtype);

			#-----------purchase cst checking details
			$purchase_cst = $this->stock->get_constant(array('purchase_cst'));

			#------------presumptive tax checking
			$presumptive_tax = $this->stock->get_tax_type();

			#------------cess %
			$cess = $this->stock->get_cess();

			#------------bill group_id, date, return_bill_no
			$item_details = $this->rejection_out->get_group($purchase_id);

			#-------------adding items to purchase bill
			if(isset($_POST['btn_add']))
			{
				$rules = "callback_check_bill_qty";
				if($item_details['return_bill_no'] > 0){
					$rules = "callback_check_bill_qty[$item_details[return_bill_no]]";
				}

				#-----------validation
				$this->form_validation->set_rules('item_id','lang:item-name','required|xss_clean|is_natural_no_zero');
				$this->form_validation->set_rules('godown_id','lang:godown','required|xss_clean');
				$this->form_validation->set_rules('cst','lang:cst','xss_clean|greater_or_equal[0]|less_or_equal[100]');
				$this->form_validation->set_rules('qty','lang:quantity',"required|xss_clean|greater_than[0]|less_than[100000000]|".$rules);
				$this->form_validation->set_rules('unit_id','lang:unit','required|xss_clean');
				$this->form_validation->set_rules('rate','lang:rate','required|xss_clean|greater_or_equal[0]|less_than[100000000]');
				$this->form_validation->set_rules('amount','lang:amount','xss_clean|required|greater_or_equal[0]|less_than[100000000]');

				#-----------adding items
				if($this->form_validation->run('btn_add') === true)
				{
					$item_array['group_id'] = $item_details['group_id'];
					$item_array['item_id'] = $this->input->post('item_id',true);
					$item_array['qty'] = $this->input->post('qty',true);
					$item_array['unit_id'] = $this->input->post('unit_id',true);
					//$item_array['rate'] = $this->input->post('rate',true);
					$item_array['amount'] = $this->input->post('amount',true);

					#----------rate calculation
					$item_array['rate'] = 0;
					if($item_array['qty'] != 0){
						$item_array['rate'] = $item_array['amount'] / $item_array['qty'];
					}

					$item_array['godown_id'] = $this->input->post('godown_id',true);
					$item_array['status'] = -1;
					$purchase_temp_item_result = $this->rejection_out->get_purchases_gst(array('columns' => array('b.id'),'conditions' => array('b.group_id' => $item_array['group_id'],'item_id' => $item_array['item_id'],'godown_id' => $item_array['godown_id'],'unit_id' => $item_array['unit_id'],'a.status !=' => 0,'b.status !=' => 0),'numrows' => true));
					if($purchase_temp_item_result == 0){

						#----------VAT calculation
					/*	$cst = 0;
						if($this->input->post('cst',true)){
							$cst = $this->input->post('cst',true);
							$item_array['cst'] = $cst;
						}
						if(empty($presumptive_tax)){
							if(!$cst){
								$vat_percent = $this->stock->get_item_vat($item_array['item_id']);
								$item_array['vat_percent'] = $vat_percent;
								$item_array['vat_amt'] = (($item_array['amount']-$item_array['discount_amt']) * $vat_percent) / 100;
							}
						}    */
						
						$cgst = $this->stock->get_item_cgst($item_array['item_id']);
                        $sgst = $this->stock->get_item_sgst($item_array['item_id']);
						$item_array['cgst'] = $cgst;
						$item_array['sgst'] = $sgst;
						$item_array['cgst_amt'] = (($item_array['amount']-$item_array['discount_amt']) * $cgst) / 100;
						$item_array['sgst_amt'] = (($item_array['amount']-$item_array['discount_amt']) * $sgst) / 100;
						
						#----------start transaction
						$this->db->trans_start();

						$purchase_items_id = $this->rejection_out->insert("dms_purchase_return_items1",$item_array);
						if($purchase_items_id)
						{
							#--------------updating bill status in dms_purchases
							$this->rejection_out->update_others(array('table' => 'dms_rejection_outs','data' => array('status' => -1),'conditions' => array('group_id' => $item_array['group_id'])));

							#--------------adding stock balance in dms_stocks
							$stock_bal = $this->stock->unit_conversion($item_array['item_id'],$item_array['unit_id'],$item_array['qty'],$item_array['rate'],$item_array['amount']);
							if($stock_bal)
							{
								$this->rejection_out->insert('dms_stocks',array('company_id' => $this->companyID,'branch_id' => $this->session->userdata('under_id'),'godown_id' => $item_array['godown_id'],'item_id' => $item_array['item_id'],'qty' => $stock_bal['qty'],'unit_id' => $stock_bal['primary_unit'],'rate' => $stock_bal['rate'],'amount' => $stock_bal['amount'],'stock_date' => $item_details['bill_date'],'stock_status' => 3,'table_group_id' => $item_details['group_id'],'table_id' => $purchase_items_id));
							}
							$this->message->set($this->lang->line('rejection-out-add-success'));
						}
						else
						{
							$this->message->set($this->lang->line('rejection-out-add-error'),'e');
						}

						#----------end transaction
						$this->db->trans_complete();

					}
					else{
						$this->message->set($this->lang->line('rejection-out-add-error'),'e');
					}
					redirect($update_uri);
				}
			}

			#------------saving purchase_return voucher
			if(isset($_POST['btn_update']))
			{
				#-----------validation
				$this->form_validation->set_rules('bill_no','lang:bill-no',"required|xss_clean|is_natural_no_zero|callback_bill_no_exists[$item_details[vtype_id].$item_details[group_id]]");
				$this->form_validation->set_rules('bill_date','lang:bill-date','required|xss_clean|valid_date');
				$this->form_validation->set_rules('remarks','lang:remarks','xss_clean');
				$this->form_validation->set_rules('freight','lang:freight','xss_clean|greater_or_equal[0]|less_than[100000000]');
				$this->form_validation->set_rules('other_expense','lang:other-expense','xss_clean|greater_or_equal[0]|less_than[100000000]');

				#-----------updating data
				if($this->form_validation->run('btn_update') === true)
				{
					$bill_date = date('Y-m-d',strtotime($this->input->post('bill_date',true)));
					$bill_no = $this->input->post('bill_no',true);
					$narration = $this->input->post('remarks',true);
					$purchase_entry_array=array('bill_no' => $bill_no,'bill_date' => $bill_date,'bill_freight' => $this->input->post('freight',true),'other_expense' => $this->input->post('other_expense',true),'cess' => $cess,'narration' => $narration,'status' => 1);

					#----------start transaction
					$this->db->trans_start();

					if($this->rejection_out->update(array('table' => 'dms_rejection_outs','data' => $purchase_entry_array,'conditions' => array('id' => $purchase_id))))
					{
						#-------------updating status of dms_purchase_items
						$this->rejection_out->update_others(array('table' => 'dms_purchase_return_items1','data' => array('status' => 1),'conditions' => array('group_id' => $item_details['group_id'],'status !=' => 0)));
						$this->message->set($this->lang->line('rejection-out-edit-success'));
					}else{
						$this->message->set($this->lang->line('rejection-out-edit-error'),'e');
					}

					#----------end transaction
					$this->db->trans_complete();

					redirect($update_uri);
				}
			}

			#----------rejection out data
			$purchase_array = $this->rejection_out->get_purchases(array('columns' => array('a.vtype_id','a.bill_no','a.bill_date','a.return_bill_no','a.group_id','a.vendor_id','a.bill_freight','a.other_expense','a.cess','a.narration','a.bill_status','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.godown_id','b.vat_amt','b.cst'),'conditions' => array('a.id' => $purchase_id,'a.status !=' => 0,'b.status !=' => 0)));
			if(empty($purchase_array))
			{
				$purchase_array = $this->rejection_out->get_purchases_gst(array('columns' => array('a.vtype_id','a.bill_no','a.bill_date','a.return_bill_no','a.group_id','a.vendor_id','a.bill_freight','a.other_expense','a.cess','a.narration','a.bill_status','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.godown_id','b.cgst_amt','b.sgst_amt'),'conditions' => array('a.id' => $purchase_id,'a.status !=' => 0,'b.status !=' => 0)));
			}
			if(!empty($purchase_array))
			{
				$stock_count = $primary_unit['symbol'] = "";
				
				if($purchase_array[0]['bill_status'] >= 2){
					$this->message->set($this->lang->line('bill-already-converted'),'e');
					redirect($redirect_uri);					
				}
				#------------checking cst enabled or not
				$cst_status = $this->rejection_out->get_cst($purchase_array[0]['group_id']);
				if($cst_status){
					$purchase_cst = $cst_status;
				}

				#------------item details / unit details / godown details
				$units = $goDowns = array();
				$units[''] = "Select";

				#------------vendor details and return bill details
				$return_bill_no = "";
				if($purchase_array[0]['return_bill_no'] == 0)
				{
					$vendors[''] = $this->stock->vendor_name($purchase_array[0]['vendor_id']);
					$args['select'] = array('id','item_code','item_name');
					$items = $this->stock->get_stock_items($args);
				}
				else
				{
					$vendors = $this->rejection_out->get_vendor($purchase_array[0]['return_bill_no']);
					$return_bill_no = $this->rejection_out->get_bill_no($purchase_array[0]['return_bill_no']);
					$items = $this->rejection_out->get_bill_itemss($purchase_array[0]['return_bill_no']);
				}

				if(empty($items)){
					$this->message->set($this->lang->line('no-items-found'),'i');
				}

				#------------item details / unit details / godown details
				if($this->input->post('item_id',true)){
					$itemID = $this->input->post('item_id',true);
					$goDowns = $this->stock->get_item_godowns(array('item_id'=>$itemID,'listing'=>1));
					$units = $this->stock->get_units($itemID);
				}

				#------------stock count of this item
				if($this->input->post('item_id',true) && $this->input->post('godown_id',true) && $purchase_array[0]['bill_date'] != ""){
					$stock_count = $this->stock->get_stock_count($this->input->post('godown_id',true),$this->input->post('item_id',true),$purchase_array[0]['bill_date']);
					$primary_unit = $this->stock->get_primary_unit($this->input->post('item_id',true));
				}

				$voucher_type = $this->vouchers->voucher_name($purchase_array[0]['vtype_id']);
				$items[''] = 'Select';ksort($items);
				$goDowns[''] = 'Select';ksort($goDowns);

				#----------template
				$edit_head = $this->lang->line("edit")." ".$this->lang->line("$voucher_name");
				$this->template->title($edit_head);
				$this->template->main_heading($edit_head);
				$this->template->breadcrumb(array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line("$voucher_name") => 'rejection_out/add',$this->lang->line('report') => 'rejection_out/report',$this->lang->line("update") => 'no_link',$this->lang->line("go-back") => array($redirect_uri)));
				$this->template->slice('dms/message');
				$this->template->slice('purchase/rejection_out/edit',array('purchase_array' => $purchase_array,'presumptive_tax' => $presumptive_tax,'purchase_cst' => $purchase_cst,'voucher_type' => $voucher_type,'vendors' => $vendors,'return_bill_no' => $return_bill_no,'voucher_name' => $voucher_name,'items' => $items,'goDowns' => $goDowns,'units' => $units,'stock_count' => $stock_count,'primary_unit' => $primary_unit['symbol'],'redirect' => $redirect));
				$this->template->other_script('purchase/rejection_out');
				$this->template->render();
			}
			else
			{
				redirect('users/logout');
			}
		}
		else
		{
			redirect('users/logout');
		}
	}

	public function delete()
	{
		#----------rejection out primary key
		$uri_array = $this->uri->uri_to_assoc(3);
		if(isset($uri_array['id']))
		{
			$id = $uri_array['id'];
			unset($uri_array['id']);

			#----------redirect uri
			$redirect_uri = "rejection_out/report/".$this->uri->assoc_to_uri($uri_array);

			$result = $this->rejection_out->get_purchases(array('columns' => array('a.group_id','a.status','a.return_bill_no','a.created_by','b.id'),'conditions' => array('a.id' => $id,'a.status !=' => 0)));
			if(empty($result))
			{
				$result = $this->rejection_out->get_purchases_gst(array('columns' => array('a.group_id','a.status','a.return_bill_no','a.created_by','b.id'),'conditions' => array('a.id' => $id,'a.status !=' => 0)));
			}
			if(!empty($result))
			{
				$row = $result[0];$continue = 1;
				if($row['status'] == -1){
					if($row['created_by'] != $this->createdBY){
						$continue = 0;
					}
				}
				if($continue == 1)
				{
					#----------start transaction
					$this->db->trans_start();

					if($this->rejection_out->update_others(array('table' => 'dms_rejection_outs','data' => array('status' => 0),'conditions' => array('id' => $id))))
					{

						if(!empty($row['return_bill_no']) && $row['return_bill_no'] >0){
							$this->rejection_out->update_others(array('table' => 'dms_purchases','data' => array('r_status' => 0),'conditions' => array('id' =>$row['return_bill_no'])));
						}
						#-------------deleting purchase_return_items
						$this->rejection_out->update_others(array('table' => 'dms_purchase_return_items1','data' => array('status' => 0),'conditions' => array('group_id' => $row['group_id'])));

						#-------------deleting stock bal. from dms_stocks
						foreach($result as $key => $value){
							$this->rejection_out->update_others(array('table' => 'dms_stocks','data' => array('status' => 0),'conditions' => array('table_id' => $value['id'],'stock_status' => 3)));
						}
						$this->message->set($this->lang->line('rejection-out-delete-success'));
					}
					else
					{
						$this->message->set($this->lang->line('rejection-out-delete-error'),'e');
					}

					#----------end transaction
					$this->db->trans_complete();
				}
				else
				{
					redirect('users/logout');
				}
			}
			redirect($redirect_uri);
		}
		redirect('users/logout');
	}

	public function check_bill_qty($qty,$values = NULL)
	{
		if($this->input->post('return_bill_no',true) && $this->input->post('return_bill_no',true) != ""){
			$item_id = $this->input->post('item_id',true);
			$bill_id = $this->input->post('return_bill_no',true);
			$count = $this->rejection_out->get_item_counts($bill_id,$item_id);
			$qty += $this->rejection_out->get_purchase_return_item_counts($bill_id,$item_id);
			if($qty > $count){
				return false;
			}
			return true;
		}
		elseif($values != NULL){
			$exp = explode(".",$values);
			$bill_id = $exp[0];
			if($this->input->post('item_id',true) && $this->input->post('item_id',true) != ""){
				$item_id = $this->input->post('item_id',true);
				$qty += $this->rejection_out->get_purchase_return_item_counts($bill_id,$item_id);
			}
			else{
				$item_id = $exp[1];
				$purchase_return_item_id = $exp[2];
				$qty += $this->rejection_out->get_purchase_return_item_counts($bill_id,$item_id,$purchase_return_item_id);
			}
			$count = $this->rejection_out->get_item_counts($bill_id,$item_id);
			if($qty > $count){
				return false;
			}
			return true;
		}
	}

	#-------------------------------------------------------------------

	public function pdf(){

		if(!$this->uri->segment(4)){
			echo "<script>alert('".$this->lang->line('invalid-rejection-out')."');window.close();</script>";
		}
		$rejectionID = $this->uri->segment(4);
		if($this->if_exists('dms_rejection_outs',array('id'=>$rejectionID,'status'=>1)) === false){
			echo "<script>alert('".$this->lang->line('invalid-rejection-out')."');window.close();</script>";
		}
		$pdf_name = 'Rejection_out';
		$this->load->model('purchase/Rejection_out_model','rejection_out');
		$this->load->model('purchase/Rejection_out_vehicle_model','rejection_out_vehicle');
		$this->load->library('Stock');
		$this->load->library('My_pdf');
		$this->load->library('To_words');

		$this->my_pdf->set_tin();
		$this->my_pdf->set_header();
		$rejection_out = array();
		$pdf_contents = '';
		$rejection_out = $this->rejection_out->get_purchases(array('columns' => array('a.vtype_id','a.bill_no','a.bill_date','a.return_bill_no','a.group_id','a.vendor_id','a.bill_freight','a.other_expense','a.cess','a.narration','a.created_by','a.created_on','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.godown_id','b.vat_amt','b.cst'),'conditions' => array('a.id' => $rejectionID,'a.status !=' => 0,'b.status !=' => 0)));
		if(empty($rejection_out))
		{
			$rejection_out = $this->rejection_out->get_purchases_gst(array('columns' => array('a.vtype_id','a.bill_no','a.bill_date','a.return_bill_no','a.group_id','a.vendor_id','a.bill_freight','a.other_expense','a.cess','a.narration','a.created_by','a.created_on','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.godown_id','b.cgst_amt','b.sgst_amt'),'conditions' => array('a.id' => $rejectionID,'a.status !=' => 0,'b.status !=' => 0)));
		}
		
		if(empty($rejection_out)){
			echo "<script>alert('".$this->lang->line('invalid-rejection-out')."');window.close();</script>";
		}else{
			#------------presumptive tax checking
			$presumptive_tax = $this->stock->get_tax_type();

			#------------checking cst enabled or not
			$purchase_cst = $this->rejection_out->get_cst($rejection_out[0]['group_id']);
			$voucher_type = $this->vouchers->voucher_name($rejection_out[0]['vtype_id']);
			$args = array();
			$args['select'] = array('dprv.id','rm.route_name','vm.vehicle_no','concat(u.fname," ",u.lname) as driver','u.mobile','dprv.km','dprv.remarks','dprv.vehicle_type','dprv.vehicle_no as vehicle_number','dprv.driver_name');
			$args['conditions'] = array('dprv.group_id'=>$rejection_out[0]['group_id']);
			$args['join'] = array('route_master as rm'=>'dprv.route_id=rm.id','vehicle_master as vm'=>'dprv.vehicle_id=vm.id','users as u'=>'dprv.driver_id=u.id');
			$purchase_vehicles = $this->rejection_out_vehicle->get($args);

			#-------------return bill details
			$return_bill_no = "";
			if($rejection_out[0]['return_bill_no'] > 0){
				$vendors = $this->rejection_out->get_vendor($rejection_out[0]['return_bill_no']);
				$return_bill_no = $this->rejection_out->get_bill_no($rejection_out[0]['return_bill_no']);
			}else{
				$vendors[''] = $this->stock->vendor_name($rejection_out[0]['vendor_id']);
			}
			$pdf_contents = $this->load->view('purchase/rejection_out/rejection_out_pdf',array('purchase_array' => $rejection_out,'return_bill_no' => $return_bill_no,'presumptive_tax' => $presumptive_tax,'purchase_cst' => $purchase_cst,'voucher_type' => $voucher_type,'vendors' => $vendors,'vehicle_details'=>$purchase_vehicles),true);
		}
		$this->my_pdf->output($pdf_name,$pdf_contents);
	}

	#-------------------------------------------------------------------
}
?>