<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

class Rejection_out_vehicles extends MY_Controller{
	
	var $companyID;
	var $branchID;
	var $createdBY;
	var $fiscal_start_date;
	var $fiscal_end_date;

	#------------------------------------

	public function __construct(){

		parent::__construct();
		$this->check_access_right();
		
		#---------------- Checking Financial year is enabled / closed-----------------#
		$method_array = array('assign','delete','edit');
		fiscal_status($this->uri->segment(2),$method_array,"rejection_out_vehicles/assigned_vehicles");
		#---------------- Checking Financial year is enabled / closed-----------------#
		$this->load->library('Stock');
		$this->companyID = $this->session->userdata('company_id');
		$this->branchID = $this->session->userdata('under_id');
		$this->createdBY = $this->session->userdata('id');
		$fiscals = $this->dms->get_fiscal_year();
		$this->fiscal_start_date = $fiscals['start_date'];
		$this->fiscal_end_date = $fiscals['end_date'];		
	}
	
	#-----------------------------------------------------------------------------------------------
	
	public function assigned_vehicles(){
		
		#----------rejection out primary key
		$uri_array = $this->uri->uri_to_assoc(3);
		if(isset($uri_array['id']))
		{
			$rejectionID = $uri_array['id'];			
			unset($uri_array['id']);

			#----------redirect uri
			$redirect_uri = "rejection_out/report/".$this->uri->assoc_to_uri($uri_array);

			$this->load->model('purchase/Rejection_out_model','rejection_out');
			$this->load->model('purchase/Rejection_out_vehicle_model','rejection_out_vehicle');
			
			$this->template->title($this->lang->line('assigned-vehicles'));
			$this->template->main_heading($this->lang->line('assigned-vehicles'));
			$this->template->breadcrumb(array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line("purchase-return") => 'rejection_out/add',$this->lang->line('report') =>'rejection_out/report',$this->lang->line('assigned-vehicles')=>'no_link',$this->lang->line('assign-vehicles')=>'rejection_out_vehicles/assign/avid/'.$rejectionID.'/'.$this->uri->assoc_to_uri($uri_array),$this->lang->line("go-back") => $redirect_uri));
			$inputSelects = array('vehicles','drivers','routes');
			$vehicles =$drivers = $routes= $purchase_return_vehicles = array();
			$args = array();
			$args['columns'] = array('a.bill_no','a.bill_date','a.group_id');
			$args['conditions'] = array('a.id'=>$rejectionID,'a.status'=>1);
			$args['limit'] = 1;$args['offset'] =0;
			$rejection_out = $this->rejection_out->get_purchases($args);
			if(empty($rejection_out)){
				redirect('rejection_out/report');
			}
			$rejection_out_group_id = $rejection_out[0]['group_id'];	

			$args = array();
			$args['select'] = array('dprv.id','rm.route_name','vm.vehicle_no','concat(u.fname," ",u.lname) as driver','u.mobile','dprv.km','dprv.remarks','dprv.vehicle_type','dprv.vehicle_no as vehicle_number','dprv.driver_name');
			$args['conditions'] = array('dprv.group_id'=>$rejection_out_group_id);
			$args['join'] = array('route_master as rm'=>'dprv.route_id=rm.id','vehicle_master as vm'=>'dprv.vehicle_id=vm.id','users as u'=>'dprv.driver_id=u.id');
			$rejection_out_vehicles = $this->rejection_out_vehicle->get($args);	

			if(empty($rejection_out_vehicles)){
				$this->message->set($this->lang->line('no-vehicle-assigned'),'e');
			}
			
			# view starts here--------------------------------
			$this->template->slice('dms/message');
			$this->template->slice('purchase/rejection_out/assigned_vehicles',array('purchase_vehicles'=>$rejection_out_vehicles));
			$this->template->render();
		}
		else
		{
			redirect('users/logout');
		}
	}
	
	#------------------------------------------------------------------------------------------
			
	public function assign(){
		
		$uriArray = $this->uri->uri_to_assoc(5);
		$urlString = $this->uri->assoc_to_uri($uriArray);
		if(!$this->uri->segment(4) || !is_numeric($this->uri->segment(4))){
			redirect('rejection_out/report');
		}
		$rejectionOutID = $this->uri->segment(4);
		$this->load->model('purchase/Rejection_out_model','rejection_out');
		
		$this->template->title($this->lang->line('assign-vehicles'));
		$this->template->main_heading($this->lang->line('assign-vehicles'));
		$this->template->breadcrumb(array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line("purchase-return") => 'rejection_out/add',$this->lang->line('report') => 'rejection_out/report',$this->lang->line('assign-vehicles')=>'no_link',$this->lang->line('assigned-vehicles')=>'rejection_out_vehicles/assigned_vehicles/id/'.$rejectionOutID.'/'.$urlString));

		$inputSelects = array('vehicles','drivers','routes');
		$vehicles=$drivers=$routes=$purchase_return_vehicles = array();
		
		$args = array();
		$args['columns'] = array('a.vtype_id','a.bill_no','a.bill_date','a.group_id');
		$args['conditions'] = array('a.id'=>$rejectionOutID,'a.status'=>1);
		$args['limit'] = 1;$args['offset'] =0;
		$rejection_out = $this->rejection_out->get_purchases($args);
		if(empty($rejection_out)){
			redirect('rejection_out/report');
		}
		$rejection_out_group_id = $rejection_out[0]['group_id'];
		$vtype_id = $rejection_out[0]['vtype_id'];
		$bill_prefix = $this->stock->get_voucher_prefix($vtype_id);
		$this->load->library('Transport_lib');
		$vehicles = $this->transport_lib->vehicles();
		$drivers = $this->transport_lib->drivers();
		$routes = $this->transport_lib->routes();
		
		if($this->input->post('vehicle_type')){
			$this->form_validation->set_rules('vehicle_id','lang:vehicle','xss_clean|required');
			$this->form_validation->set_rules('driver_id','lang:driver','xss_clean|required');
		}else{
			$this->form_validation->set_rules('vehicle_no','lang:vehicle','xss_clean|required');
			$this->form_validation->set_rules('driver_name','lang:driver','xss_clean');
		}

		$this->form_validation->set_rules('route_id','lang:route','xss_clean|required');
		$this->form_validation->set_rules('km','lang:km','xss_clean|is_numeric|greater_or_equal[0]');
	
		if($this->form_validation->run() === true){
			
			$this->load->model('purchase/Rejection_out_vehicle_model','rejection_out_vehicle');
			$postedValues = $this->input->post();
			$postedValues['group_id'] = $rejection_out_group_id;
			$vehicle_type = 1;
			if($this->input->post('vehicle_type')){
				
				$postedValues['vehicle_type'] = 0;			
				$args = array();
				$args['select'] = array('dprv.id');
				$args['conditions'] = array('dprv.group_id'=>$rejection_out_group_id,'dprv.vehicle_id'=>$postedValues['vehicle_id']);
				$rejection_out_vehicles = $this->rejection_out_vehicle->get($args);
			
				$args = array();
				$args['select'] = array('dprv.id');
				$args['conditions'] = array('dprv.group_id'=>$rejection_out_group_id,'dprv.driver_id'=>$postedValues['driver_id']);
				$rejection_out_driver = $this->rejection_out_vehicle->get($args);			
			}else{
				$postedValues['vehicle_type'] = 1;
				$postedValues['vehicle_id'] = '';
				$postedValues['driver_id'] = '';
			}
			
			if(empty($rejection_out_vehicles) && empty($rejection_out_driver)){
				
				if($this->rejection_out_vehicle->save($postedValues)){
					$this->message->set($this->lang->line('vehicle-assigned'));
					redirect('rejection_out_vehicles/assign/avid/'.$rejectionOutID.'/'.$urlString);
				}else{
					$this->message->set($this->lang->line('vehicle-not-assigned'),'e');
				}
			}else{
				$this->message->set($this->lang->line('same-vehicle-exists'),'e');
			}

		}
		foreach($inputSelects as $key=>$selectBox){
			$arrayName = $$selectBox;
			$arrayName[''] = 'Select';
			$$selectBox = $arrayName;
			ksort($$selectBox);
		}		
		# view starts here--------------------------------
		$this->template->slice('dms/message');
		$this->template->slice('purchase/rejection_out/assign_vehicles',array('vehicles'=>$vehicles,'drivers'=>$drivers,'routes'=>$routes,'sales'=>$rejection_out[0],'bill_prefix'=>$bill_prefix));
		$this->template->other_script('vehicles/assign_vehicle');
		$this->template->render();		
	}	

	#-----------------------------------------------------------------------------------------------

	public function delete(){

		$uriArray = $this->uri->uri_to_assoc(5);
		$urlString = $this->uri->assoc_to_uri($uriArray);
		if(!$this->uri->segment(4) || !is_numeric($this->uri->segment(4))){
			redirect('rejection_out/report');
		}
		$purchase_vehicleID = $this->uri->segment(4);
		if($this->if_exists('dms_purchase_return_vehicles',array('id'=>$purchase_vehicleID,'status'=>1)) === false){
				redirect('rejection_out/report');
		}
		$this->load->model('purchase/Rejection_out_vehicle_model','purchase_return_vehicle');
		
		if($this->purchase_return_vehicle->update(array('status'=>0),array('id'=>$purchase_vehicleID))){
			$this->message->set($this->lang->line('rejection-out-vehicle-removed'));
		}else{
			$this->message->set($this->lang->line('rejection-out-vehicle-not-removed'));
		}
		redirect('rejection_out_vehicles/assigned_vehicles/'.$urlString);
	}

	#-----------------------------------------------------------------------------------------------

	public function edit(){
		
		$uriArray = $this->uri->uri_to_assoc(5);
		$urlString = $this->uri->assoc_to_uri($uriArray);
		if(!$this->uri->segment(4) || !is_numeric($this->uri->segment(4))){
			redirect('rejection_out/report');
		}		
		$purchase_vehicleID = $this->uri->segment(4);
		if($this->if_exists('dms_purchase_return_vehicles',array('id'=>$purchase_vehicleID,'status'=>1)) === false){
				redirect('rejection_out/report');
		}
		$this->load->model('purchase/Rejection_out_vehicle_model','rejection_out_vehicle');
		$this->template->title($this->lang->line('assigned-vehicles'));
		$this->template->main_heading($this->lang->line('assigned-vehicles'));
		$this->template->breadcrumb(array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line("purchase-return") => 'rejection_out/add',$this->lang->line('report') =>'rejection_out/report',$this->lang->line('assigned-vehicles')=>'rejection_out_vehicles/assigned_vehicles/'.$urlString,$this->lang->line('update')=>'no_link'));
		$inputSelects = array('vehicles','drivers','routes');
		$vehicles =$drivers = $routes= $purchase_return_vehicles = array();		
		
		$this->load->library('Transport_lib');
		$vehicles = $this->transport_lib->vehicles();
		$drivers = $this->transport_lib->drivers();
		$routes = $this->transport_lib->routes();
				
		$args = array();
		$args['select'] = array('dprv.id','dprv.group_id','dprv.route_id','dprv.vehicle_id','dprv.driver_id','dprv.km','dprv.remarks','dprv.vehicle_type','dprv.vehicle_no','dprv.driver_name','dpr.vtype_id','dpr.bill_no','dpr.bill_date');
		$args['conditions'] = array('dprv.id'=>$purchase_vehicleID);
		$args['join'] = array('dms_rejection_outs as dpr'=>'dpr.group_id=dprv.group_id','route_master as rm'=>'dprv.route_id=rm.id','vehicle_master as vm'=>'dprv.vehicle_id=vm.id','users as u'=>'dprv.driver_id=u.id');
		$purchase_return_vehicles = $this->rejection_out_vehicle->get($args);

		if($this->input->post('vehicle_type')){
			$this->form_validation->set_rules('vehicle_id','lang:vehicle','xss_clean|required');
			$this->form_validation->set_rules('driver_id','lang:driver','xss_clean|required');
		}else{
			$this->form_validation->set_rules('vehicle_no','lang:vehicle','xss_clean|required');
			$this->form_validation->set_rules('driver_name','lang:driver','xss_clean');
		}
		$this->form_validation->set_rules('route_id','lang:route','xss_clean|required');
		$this->form_validation->set_rules('km','lang:km','xss_clean|is_numeric|greater_or_equal[0]');
	
		if($this->form_validation->run() === true){
			
			$purchase_group_id = $purchase_return_vehicles[0]['group_id'];
			$postedValues = $this->input->post();
			$vehicle_type = 1;
			if($this->input->post('vehicle_type')){
				$postedValues['vehicle_type'] = 0;
				$postedValues['vehicle_no'] = '';
				$postedValues['driver_name'] = '';				
				$args = array();
				$args['select'] = array('dprv.id');
				$args['conditions'] = array('dprv.id !='=>$purchase_vehicleID,'dprv.group_id'=>$purchase_group_id,'vehicle_id'=>$postedValues['vehicle_id']);
				$purchase_vehicle = $this->rejection_out_vehicle->get($args);
			
				$args = array();
				$args['select'] = array('dprv.id');
				$args['conditions'] = array('dprv.id !='=>$purchase_vehicleID,'dprv.group_id'=>$purchase_group_id,'driver_id'=>$postedValues['driver_id']);
				$purchase_driver = $this->rejection_out_vehicle->get($args);	
			}else{
				$postedValues['vehicle_type'] = 1;
				$postedValues['vehicle_id'] = '';
				$postedValues['driver_id'] = '';				
			}
			if(empty($purchase_vehicle) && empty($purchase_driver)){
				
				if($this->rejection_out_vehicle->update($postedValues,array('id'=>$purchase_vehicleID))){
					$this->message->set($this->lang->line('vehicle-assigned-edit-success'));
					redirect('rejection_out_vehicles/assigned_vehicles/'.$urlString);
				}else{
					$this->message->set($this->lang->line('vehicle-not-assigned'),'e');
				}
			}else{
				$this->message->set($this->lang->line('same-vehicle-exists'),'e');
			}			
		}		
		foreach($inputSelects as $key=>$selectBox){
			$arrayName = $$selectBox;
			$arrayName[''] = 'Select';
			$$selectBox = $arrayName;
			ksort($$selectBox);
		}	
				
		# view starts here--------------------------------
		$this->template->slice('dms/message');
		$this->template->slice('purchase/rejection_out/edit_assigned_vehicles',array('vehicles'=>$vehicles,'drivers'=>$drivers,'routes'=>$routes,'purchase_vehicle'=>$purchase_return_vehicles));
		$this->template->other_script('vehicles/assign_vehicle');
		$this->template->render();					
	}
	
	#-----------------------------------------------------------------------------------------------	
}