<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

class Request_to_delivery extends MY_Controller{

	public function __construct()
	{
		parent::__construct();

		$this->check_access_right();

		#---------------- Checking Financial year is enabled / closed-----------------#
		$method_array = array('pr_delivery','prd_update','prd_delete');
		fiscal_status($this->uri->segment(2),$method_array,"purchase_requests/approved_requests");
		#---------------- Checking Financial year is enabled / closed-----------------#

		$this->load->model('sales/Delivery_note_model','delivery_obj');
		$this->load->model('vouchers/Voucher_model','vouchers');
		$this->load->library(array('Stock','Sales_lib'));

		#----------voucher type
		$this->vtype = 10;
	}

	public function pr_delivery()
	{
		$l_date = '2017-07-01';
		#----------voucher type
		$vtype_id = $this->vtype;

		#----------purchase_requests primary key
		$pr_id = $this->uri->segment(3);

		#----------purchase_request data
		$purchase_request_array = $this->dms->get_data(array('table' => 'dms_purchase_requests as a','columns' => array('a.customer_id','a.requested_by','a.requested_to','a.request_date','b.item_id','b.qty','b.unit_id'),'join' => array('table' => 'dms_purchase_request_items as b','on' => 'a.id = b.pr_id'),'conditions' => array('a.id' => $pr_id,'a.req_status' => 3,'a.status' => 1,'b.status' => 1)));
		if(!empty($purchase_request_array))
		{
			#----------checking group_id exists for redirection
			$redirection_uri = $this->sales_lib->prd_id_exists($pr_id);
			if($redirection_uri){
				redirect($redirection_uri);
			}
			else
			{
				#-----------sales date and next bill no
				$disabled = "";
				$result_array = $this->delivery_obj->next_bill_no($this->vtype);
				$vtype_id = $result_array['vtype_id'];
				$voucher_no = $result_array['bill_no'];
				$voucher_date = $result_array['bill_date'];
				if($result_array['vstatus']){
					$disabled = "readonly";
					$group_id = $result_array['group_id'];
				}
				else{
					$group_id = $this->stock->get_group_id('dms_sales');
				}

				#----------sales order date
				$so_date = $purchase_request_array[0]['request_date'];

				#----------customer_id, customer_type_id, user_id
				$user = $usertype = "";
				$user_id = $purchase_request_array[0]['requested_by'];//primary key of users
				$user_details = $this->dms->get_users(array('columns' => array('id','branch_id','designation_id'),'conditions' => array('id' => $user_id)));
				if($purchase_request_array[0]['customer_id'] == 0){//branch or retailer
					$customer_id = $user_details[$user_id]['branch_id'];
					if($user_details[$user_id]['designation_id'] == 3){
						$customer_type_id = 3;//designation id
					}
					else{
						$customer_type_id = 1;//designation id
					}

					#------------customer_name
					$customer_name = $this->stock->get_customer($customer_type_id,$customer_id);
				}
				else{
					$customer_type_id = 2;
					$customer_id = $purchase_request_array[0]['customer_id'];
					$user = $user_id;

					#------------customer_name
					$customer_name = $this->stock->get_customer(2,$customer_id);

					#------------user designation
					$user_desig_name = $this->dms->get_desig($user,1);
					$usertype = $user_desig_name['designation_name'];
				}

				//echo $customer_type_id."---".$customer_id."---".$user;die;

				#------------cess %
				$cess = $this->stock->get_cess();

				#------------adding purchase requests data to delivery_notes
				if($result_array['vstatus'] == 0)//data not in dms_delivery_notes
				{
					$this->delivery_obj->insert("dms_delivery_notes",array('vtype_id' => $vtype_id,'branch_id' => $purchase_request_array[0]['requested_to'],'bill_no' => $voucher_no,'bill_date' => $voucher_date,'group_id' => $group_id,'sid' => $pr_id,'s_status' => 1,'customer_type_id' => $customer_type_id,'customer_id' => $customer_id,'user_id' => $user,'cess' => $cess,'status' => -1));

					$godown_id = $this->stock->get_godown();
					foreach($purchase_request_array as $pr_key => $pr_value)
					{
						$b_dt = $pr_value['request_date'];
						$l_date = '2017-07-01';
						$rate = $this->stock->get_item_rate($pr_value['item_id']);
						$amount = ($rate * $pr_value['qty']);
						/*if($b_dt < $l_date)
						{
							$vat = $this->stock->get_item_vat($pr_value['item_id']);
							$vat_amt = ($vat*$amount)/100;
							$items_exists = $this->delivery_obj->get_sales_items(array('columns' => 'id','conditions' => array('group_id' => $group_id,'item_id' => $pr_value['item_id'],'unit_id' => $pr_value['unit_id'],'rate' => $rate,'amount'=>$amount,'vat_percent' => $vat,'vat_amt' =>  $vat_amt,'godown_id' => $godown_id,'status !=' => 0,'item_status !=' => -1),'numrows' => true));
							if($items_exists == 0)
							{
								#--------------adding purchase items
								$purchase_items_id = $this->delivery_obj->insert("dms_sales_items",array('group_id' => $group_id,'item_id' => $pr_value['item_id'],'qty' => $pr_value['qty'],'unit_id' => $pr_value['unit_id'],'godown_id' => $godown_id,'status' => -1,'item_status' => 2));
								if($purchase_items_id)
								{
									#--------------adding temporary stock balance in dms_stocks
									$pur_stock_bal_temp = $this->stock->unit_conversion($pr_value['item_id'],$pr_value['unit_id'],$pr_value['qty'],0);
									if($pur_stock_bal_temp)
									{
										$this->delivery_obj->insert('dms_stocks',array('company_id' => $this->session->userdata('company_id'),'branch_id'=>$this->session->userdata('under_id'),'godown_id' => $godown_id,'item_id' => $pr_value['item_id'],'qty' => $pur_stock_bal_temp['qty'],'unit_id' => $pur_stock_bal_temp['primary_unit'],'rate' => $pur_stock_bal_temp['rate'],'stock_date' => $voucher_date,'stock_status' => 5,'table_group_id'=>$group_id,'table_id' => $purchase_items_id,'status' => -1));
									}
								}
							}
						}
						else
						{*/
							$cgst=$this->stock->get_item_cgst($pr_value['item_id']);
							$sgst = $this->stock->get_item_sgst($pr_value['item_id']);
							$cgst_amt = ((float)$cgst*(float)$amount)/100;
							$sgst_amt = ((float)$sgst*(float)$amount)/100;
							$items_exists = $this->delivery_obj->get_sales_itemss(array('columns' => 'id','conditions' => array('group_id' => $group_id,'item_id' => $pr_value['item_id'],'unit_id' => $pr_value['unit_id'],'godown_id' => $godown_id,'status !=' => 0,'item_status !=' => -1),'numrows' => true));
							if($items_exists == 0)
							{
								#--------------adding purchase items
								$purchase_items_id = $this->delivery_obj->insert("dms_sales_items1",array('group_id' => $group_id,'item_id' => $pr_value['item_id'],'qty' => $pr_value['qty'],'unit_id' => $pr_value['unit_id'],'rate'=>$rate,'amount'=>$amount,'cgst'=>$cgst,'sgst'=>$sgst,'cgst_amt'=>$cgst_amt,'sgst_amt'=>$sgst_amt,'godown_id' => $godown_id,'status' => -1,'item_status' => 2));
								if($purchase_items_id)
								{
									#--------------adding temporary stock balance in dms_stocks
									$pur_stock_bal_temp = $this->stock->unit_conversion($pr_value['item_id'],$pr_value['unit_id'],$pr_value['qty'],0);
									if($pur_stock_bal_temp)
									{
										$this->delivery_obj->insert('dms_stocks',array('company_id' => $this->session->userdata('company_id'),'branch_id'=>$this->session->userdata('under_id'),'godown_id' => $godown_id,'item_id' => $pr_value['item_id'],'qty' => $pur_stock_bal_temp['qty'],'unit_id' => $pur_stock_bal_temp['primary_unit'],'rate' => $pur_stock_bal_temp['rate'],'stock_date' => $voucher_date,'stock_status' => 5,'table_group_id'=>$group_id,'table_id' => $purchase_items_id,'status' => -1));
									}
								}
							}	
					//	}
					}
				}

				#------------presumptive tax checking
				$presumptive_tax = $this->stock->get_tax_type();

				#-------------adding data to sales temp
				if(isset($_POST['btn_add']))
				{
					#-----------validation
					$this->form_validation->set_rules('item_id','lang:item-name','required|xss_clean');
					$this->form_validation->set_rules('godown_id','lang:godown','required|xss_clean');
					$this->form_validation->set_rules('cst','lang:cst','xss_clean|greater_or_equal[0]|less_or_equal[100]');
					$this->form_validation->set_rules('qty','lang:quantity','required|xss_clean|greater_than[0]|less_than[100000000]');
					$this->form_validation->set_rules('unit_id','lang:unit','required|xss_clean');
					$this->form_validation->set_rules('rate','lang:rate','required|xss_clean|greater_or_equal[0]|less_than[100000000]');
					$this->form_validation->set_rules('amount','lang:amount','xss_clean|required|greater_or_equal[0]|less_than[100000000]');
					$this->form_validation->set_rules('discount_per','lang:discount %','xss_clean|greater_or_equal[0]|less_or_equal[100]');
					$this->form_validation->set_rules('discount_amt','lang:discount','xss_clean|greater_or_equal[0]|less_than[100000000]');

					#-----------adding temporary data
					if($this->form_validation->run('btn_add') === true)
					{
						#----------VAT calculation
						$b_date = '2017-09-18'; // $this->input->post('bill_date',true);
						$l_date = '2017-07-01';
						echo $l_date;
						if($b_date < $l_date)
						{
							$cst = $vat_amt = $vat_percent = 0;
							if($this->input->post('cst',true)){
								$cst = $this->input->post('cst',true);
							}
							
							
								if(empty($presumptive_tax)){
									if($cst == 0){
										$vat_percent = $this->stock->get_item_vat($this->input->post('item_id',true));
										$vat_amt = ((float)$vat_percent * (float)($this->input->post('amount',true) - (float)$this->input->post('discount_amt',true))) / 100;
									}
								}
						}
						else
						{
							$cgst = $this->stock->get_item_cgst($this->input->post('item_id',true));
							$sgst = $this->stock->get_item_sgst($this->input->post('item_id',true));
							$cgstAmt = ((float)$cgst * (float)($this->input->post('amount',true) - (float)$this->input->post('discount_amt',true))) / 100;	
							$sgstAmt = ((float)$sgst * (float)($this->input->post('amount',true) - (float)$this->input->post('discount_amt',true))) / 100;
						}

						#----------rate calculation
						$rate = 0;
						if($this->input->post('qty',true) != 0)
						{
							$rate = (float)$this->input->post('amount',true) / (float)$this->input->post('qty',true);
						}
					/*if($b_date < $l_date)
					{
						$item_array = array('group_id' => $group_id,'item_id' => $this->input->post('item_id',true),'qty' => $this->input->post('qty',true),'unit_id' => $this->input->post('unit_id',true),'rate' => $rate,'amount' => $this->input->post('amount',true),'discount_per' => $this->input->post('discount_per',true),'discount_amt' => $this->input->post('discount_amt',true),'vat_percent' => $vat_percent,'vat_amt' => $vat_amt,'cst' => $cst,'godown_id' => $this->input->post('godown_id',true),'status' => -1,'item_status' => 2);

						$sales_temp_item_result = $this->delivery_obj->get_sales_items(array('columns' => 'id','conditions' => array('group_id' => $group_id,'item_id' => $item_array['item_id'],'unit_id' => $item_array['unit_id'],'godown_id' => $item_array['godown_id'],'status !=' => 0,'item_status !=' => -1),'numrows' => true));
						if($sales_temp_item_result == 0)
						{
							#--------------adding sales items
							$sales_items_id = $this->delivery_obj->insert("dms_sales_items",$item_array);
							if($sales_items_id)
							{
								#--------------adding temporary stock balance in dms_stocks
								$stock_bal_temp = $this->stock->unit_conversion($item_array['item_id'],$item_array['unit_id'],$item_array['qty'],$item_array['rate'],$item_array['amount']);
								if($stock_bal_temp)
								{
									$this->delivery_obj->insert('dms_stocks',array('company_id' => $this->session->userdata('company_id'),'branch_id'=>$this->session->userdata('under_id'),'godown_id' => $item_array['godown_id'],'item_id' => $item_array['item_id'],'qty' => $stock_bal_temp['qty'],'unit_id' => $stock_bal_temp['primary_unit'],'rate' => $stock_bal_temp['rate'],'amount' => $stock_bal_temp['amount'],'stock_date' => $voucher_date,'stock_status' => 5,'table_group_id'=>$group_id,'table_id' => $sales_items_id,'status' => -1));
								}
								$this->message->set($this->lang->line('delivery-add-success'));
							}
							else
							{
								$this->message->set($this->lang->line('delivery-add-error'),'e');
							}
						}
						else{
							$this->message->set($this->lang->line('delivery-add-error'),'e');
						}
						$redirect_uri = $this->uri->uri_to_assoc(1);
						redirect($this->uri->assoc_to_uri($redirect_uri));
					}
					else
					{*/	
						$item_array = array('group_id' => $group_id,'item_id' => $this->input->post('item_id',true),'qty' => $this->input->post('qty',true),'unit_id' => $this->input->post('unit_id',true),'rate' => $rate,'amount' => $this->input->post('amount',true),'discount_per' => $this->input->post('discount_per',true),'discount_amt' => $this->input->post('discount_amt',true),'cgst' => $cgst,'sgst' => $sgst,'cgst_amt' => $cgstAmt,'sgst_amt' => $sgstAmt,'godown_id' => $this->input->post('godown_id',true),'status' => -1,'item_status' => 2);

						$sales_temp_item_result = $this->delivery_obj->get_sales_itemss(array('columns' => 'id','conditions' => array('group_id' => $group_id,'item_id' => $item_array['item_id'],'unit_id' => $item_array['unit_id'],'godown_id' => $item_array['godown_id'],'status !=' => 0,'item_status !=' => -1),'numrows' => true));
						if($sales_temp_item_result == 0)
						{
							#--------------adding sales items
							$sales_items_id = $this->delivery_obj->insert("dms_sales_items1",$item_array);
							if($sales_items_id)
							{
								#--------------adding temporary stock balance in dms_stocks
								$stock_bal_temp = $this->stock->unit_conversion($item_array['item_id'],$item_array['unit_id'],$item_array['qty'],$item_array['rate'],$item_array['amount']);
								if($stock_bal_temp)
								{
									$this->delivery_obj->insert('dms_stocks',array('company_id' => $this->session->userdata('company_id'),'branch_id'=>$this->session->userdata('under_id'),'godown_id' => $item_array['godown_id'],'item_id' => $item_array['item_id'],'qty' => $stock_bal_temp['qty'],'unit_id' => $stock_bal_temp['primary_unit'],'rate' => $stock_bal_temp['rate'],'amount' => $stock_bal_temp['amount'],'stock_date' => $voucher_date,'stock_status' => 5,'table_group_id'=>$group_id,'table_id' => $sales_items_id,'status' => -1));
								}
								$this->message->set($this->lang->line('delivery-add-success'));
							}
							else
							{
								$this->message->set($this->lang->line('delivery-add-error'),'e');
							}
						}
						else{
							$this->message->set($this->lang->line('delivery-add-error'),'e');
						}
						$redirect_uri = $this->uri->uri_to_assoc(1);
						redirect($this->uri->assoc_to_uri($redirect_uri));	
						
					//}
					}
				}

				#------------saving delivery_note voucher
				if(isset($_POST['btn_save']))
				{
					#-----------validation
					$this->form_validation->set_rules('vtype_id','lang:voucher-types','required|xss_clean');
					$this->form_validation->set_rules('bill_no','lang:bill-no',"required|xss_clean|is_natural_no_zero|callback_bill_no_exists[$vtype_id.$group_id]");
					$this->form_validation->set_rules('bill_date','lang:bill-date',"required|xss_clean|valid_date|check_date[$so_date.>=]");
					$this->form_validation->set_rules('area_id','lang:area','required|xss_clean');
					$this->form_validation->set_rules('payment_mode','lang:payment-mode','required|xss_clean');
					$this->form_validation->set_rules('credit_period','lang:credit-period','xss_clean|is_natural');
					if($this->input->post('payment_mode',true) && $this->input->post('payment_mode',true) == 2){
						$this->form_validation->set_rules('credit_period','lang:credit-period','required|xss_clean|is_natural');
					}
					$this->form_validation->set_rules('remarks','lang:remarks','xss_clean');
					$this->form_validation->set_rules('freight','lang:freight','xss_clean|greater_or_equal[0]');
					$this->form_validation->set_rules('other_expense','lang:other-expense','xss_clean|greater_or_equal[0]');
					$this->form_validation->set_rules('bill_discount_per','lang:discount %','xss_clean|greater_or_equal[0]|less_or_equal[100]');
					$this->form_validation->set_rules('bill_discount_amt','lang:discount','xss_clean|greater_or_equal[0]');

					#-----------saving data
					if($this->form_validation->run('btn_save') === true)
					{
						$l_date = '2017-07-01';
						$success = 0;
						$bill_date = date('Y-m-d',strtotime($this->input->post('bill_date',true)));
						$sales_entry_array=array('vtype_id' => $this->input->post('vtype_id',true),'bill_no' => $this->input->post('bill_no',true),'bill_date' => $bill_date,'area_id' => $this->input->post('area_id',true),'bill_discount_per' => $this->input->post('bill_discount_per',true),'bill_discount_amt' => $this->input->post('bill_discount_amt',true),'bill_freight' => $this->input->post('freight',true),'other_expense' => $this->input->post('other_expense',true),'narration' => $this->input->post('remarks',true),'status' => 1);
						if($this->delivery_obj->update(array('table' => 'dms_delivery_notes','data' => $sales_entry_array,'conditions' => array('group_id' => $group_id)))){
							#------------updating sales_item status
							/*if($bill_date < $l_date)
							{
								$this->delivery_obj->update_others(array('table' => 'dms_sales_items','data' => array('status' => 1),'conditions' => array('group_id' => $group_id)));
	
								#------------updating purchase_requests status
								$this->delivery_obj->update_others(array('table' => 'dms_purchase_requests','data' => array('req_status' => 4),'conditions' => array('id' => $pr_id)));
	
								$sales_items_array = $this->delivery_obj->get_sales_items(array('columns' => array('id'),'conditions' => array('group_id' => $group_id,'status' => 1,'item_status !=' => -1)));
								foreach($sales_items_array as $key => $value)
								{
									#-------------enabling temporarily added stocks
									$this->delivery_obj->update_others(array('table' => 'dms_stocks','data' => array('stock_date' => $bill_date,'status' => 1),'conditions' => array('stock_status' => 5,'table_id' => $value['id'])));
								}
								$this->message->set($this->lang->line('delivery-save-success'));
							}
							else
							{*/
								$this->delivery_obj->update_others(array('table' => 'dms_sales_items1','data' => array('status' => 1),'conditions' => array('group_id' => $group_id)));
	
								#------------updating purchase_requests status
								$this->delivery_obj->update_others(array('table' => 'dms_purchase_requests','data' => array('req_status' => 4),'conditions' => array('id' => $pr_id)));
	
								$sales_items_array = $this->delivery_obj->get_sales_itemss(array('columns' => array('id'),'conditions' => array('group_id' => $group_id,'status' => 1,'item_status !=' => -1)));
								foreach($sales_items_array as $key => $value)
								{
									#-------------enabling temporarily added stocks
									$this->delivery_obj->update_others(array('table' => 'dms_stocks','data' => array('stock_date' => $bill_date,'status' => 1),'conditions' => array('stock_status' => 5,'table_id' => $value['id'])));
								}
								$this->message->set($this->lang->line('delivery-save-success'));	
							//}
						}
						else
						{
							$this->message->set($this->lang->line('delivery-save-error'),'e');
						}
						redirect('delivery_note/add');
					}
				}

				#----------delivery items
				/*	$sales_items = $this->delivery_obj->get_sales_items(array('conditions' => array('group_id' => $group_id,'status !=' => 0,'item_status !=' => -1)));
				if(empty($sales_items))
				{*/
					$sales_items = $this->delivery_obj->get_sales_itemss(array('conditions' => array('group_id' => $group_id,'status !=' => 0,'item_status !=' => -1)));
			//	}
				#----------voucher type array
				$voucher_types = $this->vouchers->voucher_types($this->vtype);
				$bill_prefix = $this->stock->get_voucher_prefix($this->vtype);
				#----------voucher name
				$voucher_name = $this->vouchers->voucher_name($this->vtype);

				#-----------sales cst checking details
				$sales_cst = $this->stock->get_constant(array('sales_cst'));

				#------------item details / unit details / godown details
				$units = $goDowns = array();
				$units[''] = "Select";
				$args['select'] = array('id','item_code','item_name');
				$items = $this->stock->get_stock_items($args);
				if(empty($items)){
					$this->message->set($this->lang->line('no-items-found'),'i');
				}
				if($this->input->post('item_id',true)){
					$itemID = $this->input->post('item_id',true);
					$goDowns = $this->stock->get_item_godowns(array('item_id'=>$itemID,'listing'=>1));
					$units = $this->stock->get_units($itemID);
				}

				#------------area details
				$this->load->model('areas/Area_model','area');
				$areas = $this->area->listing();

				$items[''] = 'Select';ksort($items);
				$goDowns[''] = 'Select';ksort($goDowns);
				$areas[''] = 'Select';ksort($areas);

				#------------stock count of this item
				$stock_count = $primary_unit['symbol'] = "";
				if($this->input->post('item_id',true) && $this->input->post('godown_id',true) && $this->input->post('bill_date',true)){
					$bill_date = date('Y-m-d',strtotime($this->input->post('bill_date',true)));
					$stock_count = $this->stock->get_stock_count($this->input->post('godown_id',true),$this->input->post('item_id',true),$bill_date);
					$primary_unit = $this->stock->get_primary_unit($this->input->post('item_id',true));
				}

				#------------pricelist details
				$this->load->model('customers/Customer_type_model','customer_type');
				$pricelists = $this->customer_type->listing();
				$pricelists[''] = 'Select';ksort($pricelists);

				#------------payment modes
				$payment_modes = $this->stock->payment_modes();

				#------------checking cst enabled or not
				//$cst_status = $this->delivery_obj->get_cst($group_id);
				$cst_status = 0;
				if($cst_status){ $sales_cst = $cst_status; }

				#------------customer_type
				$customer_type = $this->dms->desig_name($customer_type_id);

				#------------user_name
				$user_name = $this->dms->get_user_name($user);

				#------------template
				$this->template->title("New Delivery Note Voucher");
				$this->template->main_heading($this->lang->line("$voucher_name"));
				$this->template->breadcrumb(array($this->lang->line("$voucher_name") => 'no_link',$this->lang->line('report') => 'delivery_note/report'));
				$this->template->slice('dms/message');
				$this->template->slice('purchase/requests/delivery',array('purchase_request_array' => $purchase_request_array,'customer_type' => $customer_type,'customer_name' => $customer_name,'user_type' => $usertype,'user' => $user_name,'voucher_types' => $voucher_types,'voucher_name' => $voucher_name,'voucher_type' => $vtype_id,'disabled' => $disabled,'items' => $items,'goDowns' => $goDowns,'units' => $units,'sales_cst' => $sales_cst,'stock_count' => $stock_count,'primary_unit' => $primary_unit['symbol'],'payment_modes' => $payment_modes,'sales_items' => $sales_items,'voucher_no' => $voucher_no,'voucher_date' => $voucher_date,'cess' => $cess,'areas' => $areas,'pricelists' => $pricelists,'bill_prefix'=>$bill_prefix));
				$this->template->other_script(array('sales/sales_order','purchase/purchase_request'));
				$this->template->render();
			}
		}
		else
		{
			redirect(base_url());
		}
	}

	public function prd_update()
	{
		#----------sales items id from sales / sales order
		$sales_temp_id = $this->uri->segment(3);
		echo $sales_temp_id;

	//	$row = $this->delivery_obj->get_sales_items(array('columns' => array('id','group_id','item_id','qty','unit_id','rate','amount','discount_per','discount_amt','vat_amt','cst','godown_id','item_status'),'conditions' => array('id' => $sales_temp_id)));
		
			$row = $this->delivery_obj->get_sales_itemss(array('columns' => array('id','group_id','item_id','qty','unit_id','rate','amount','discount_per','discount_amt','cgst_amt','sgst_amt','godown_id','item_status'),'conditions' => array('id' => $sales_temp_id)));
		
		if(!empty($row))
		{
			$sales_temp_data = $row[0];

			#-----------validation
			$this->form_validation->set_rules('godown_id','lang:godown','required|xss_clean');
			$this->form_validation->set_rules('cst','lang:cst','xss_clean|greater_or_equal[0]|less_or_equal[100]');
			$this->form_validation->set_rules('qty','lang:quantity','required|xss_clean|greater_than[0]|less_than[100000000]');
			$this->form_validation->set_rules('unit_id','lang:unit','required|xss_clean');
			$this->form_validation->set_rules('rate','lang:rate','required|xss_clean|greater_or_equal[0]|less_than[100000000]');
			$this->form_validation->set_rules('amount','lang:amount','xss_clean|required|greater_or_equal[0]|less_than[100000000]');
			$this->form_validation->set_rules('discount_per','lang:discount %','xss_clean|greater_or_equal[0]|less_or_equal[100]');
			$this->form_validation->set_rules('discount_amt','lang:discount','xss_clean|greater_or_equal[0]|less_than[100000000]');
			$this->form_validation->set_rules('vat_amt','lang:vat-amt','xss_clean|greater_or_equal[0]|less_than[100000000]');

			#-----------redirect uri
			$update_uri = $this->uri->uri_to_assoc(4);
			$redirect_uri = $this->uri->assoc_to_uri($update_uri);

			#-----------updating temporary data
			if($this->form_validation->run() === true)
			{
				$item_temp_array = $this->input->post(NULL,true);

				#----------rate calculation
				$item_temp_array['rate'] = 0;
				if($item_temp_array['qty'] != 0){
					$item_temp_array['rate'] = $item_temp_array['amount'] / $item_temp_array['qty'];
				}

				#------------presumptive tax checking
				$presumptive_tax = $this->stock->get_tax_type();

				#----------VAT calculation
			/*	$cst = 0;
				if(array_key_exists('cst',$item_temp_array)){
					$cst = $item_temp_array['cst'];
				}
				if(empty($presumptive_tax)){
					if($cst == 0){
						$item_temp_array['vat_percent'] = $this->stock->get_item_vat($sales_temp_data['item_id']);
					}
				} */
				$item_temp_array['cgst'] = $this->stock->get_item_cgst($sales_temp_data['item_id']);
				$item_temp_array['sgst'] = $this->stock->get_item_sgst($sales_temp_data['item_id']);

		//		if($sales_temp_data['item_status'] == 0 && ($sales_temp_data['qty'] != $item_temp_array['qty'] || $sales_temp_data['unit_id'] != $item_temp_array['unit_id'] || $sales_temp_data['rate'] != $item_temp_array['rate'] || $sales_temp_data['discount_per'] != $item_temp_array['discount_per'] || $sales_temp_data['discount_amt'] != $item_temp_array['discount_amt'] || $sales_temp_data['godown_id'] != $item_temp_array['godown_id'] || $sales_temp_data['cst'] != $cst || $sales_temp_data['vat_amt'] != $item_temp_array['vat_amt']))
		
				if($sales_temp_data['item_status'] == 0 && ($sales_temp_data['qty'] != $item_temp_array['qty'] || $sales_temp_data['unit_id'] != $item_temp_array['unit_id'] || $sales_temp_data['rate'] != $item_temp_array['rate'] || $sales_temp_data['discount_per'] != $item_temp_array['discount_per'] || $sales_temp_data['discount_amt'] != $item_temp_array['discount_amt'] || $sales_temp_data['godown_id'] != $item_temp_array['godown_id'] || $sales_temp_data['cgst_amt'] != $item_temp_array['cgst_amt'] || $sales_temp_data['sgst_amt'] != $item_temp_array['sgst_amt']))
				
				{
					$item_temp_array['group_id'] = $sales_temp_data['group_id'];
					$item_temp_array['item_id'] = $sales_temp_data['item_id'];
					$item_temp_array['status'] = -1;
					$item_temp_array['item_status'] = 2;
					$sales_temp_data['item_status'] = 2;
					if($this->delivery_obj->update_others(array('table' => 'dms_sales_items1','data' => array('item_status' => -1),'conditions' => array('id' => $sales_temp_id)))){
						$sales_temp_id = $this->delivery_obj->insert('dms_sales_items1',$item_temp_array);
						$this->message->set($this->lang->line('delivery-edit-temp-success'));
					}
				}
				else
				{
					$this->delivery_obj->update_others(array('table' => 'dms_sales_items1','data' => $item_temp_array,'conditions' => array('id' => $sales_temp_id)));
					$this->message->set($this->lang->line('delivery-edit-temp-success'));
				}

				#--------------updating temporary stock balance in dms_stocks
				if($sales_temp_data['item_status'] == 2)
				{
					$stock_bal_temp = $this->stock->unit_conversion($sales_temp_data['item_id'],$item_temp_array['unit_id'],$item_temp_array['qty'],$item_temp_array['rate'],$item_temp_array['amount']);
					if($stock_bal_temp)
					{
						if($this->stock->check_stock(array('stock_status' => 5,'table_id' => $sales_temp_id,'status !=' => 0)))
						{
							$this->delivery_obj->update_others(array('table' => 'dms_stocks','data' => array('godown_id' => $item_temp_array['godown_id'],'qty' => $stock_bal_temp['qty'],'unit_id' => $stock_bal_temp['primary_unit'],'rate' => $stock_bal_temp['rate'],'amount' => $stock_bal_temp['amount']),'conditions' => array('stock_status' => 5,'table_id' => $sales_temp_id)));
						}
						else
						{
							$this->delivery_obj->insert('dms_stocks',array('company_id' => $this->session->userdata('company_id'),'branch_id'=>$this->session->userdata('under_id'),'godown_id' => $item_temp_array['godown_id'],'item_id' => $sales_temp_data['item_id'],'qty' => $stock_bal_temp['qty'],'unit_id' => $stock_bal_temp['primary_unit'],'rate' => $stock_bal_temp['rate'],'amount' => $stock_bal_temp['amount'],'stock_status' => 5,'table_group_id'=>$sales_temp_data['group_id'],'table_id' => $sales_temp_id,'status' => -1));
						}
					}
				}
				redirect($redirect_uri);
			}

			#----------voucher name
			$voucher_name = $this->vouchers->voucher_name($this->vtype);

			#-----------sales cst checking details
			$sales_cst = $this->stock->get_constant(array('sales_cst'));

			#------------presumptive tax checking
			$presumptive_tax = $this->stock->get_tax_type();

			#------------checking cst enabled or not
			$cst_status = 0;
			//$cst_status = $this->delivery_obj->get_cst($sales_temp_data['group_id']);
			if($cst_status){
				$sales_cst = $cst_status;
			}

			#------------item details / unit details / godown details
			$units = array();$goDowns = array();
			$item_details = $this->stock->get_item($sales_temp_data['item_id'],array('item_code','item_name'));
			$items[$sales_temp_data['item_id']] = $item_details['item_code']." / ".$item_details['item_name'];
			$goDowns = $this->stock->get_item_godowns(array('item_id'=>$sales_temp_data['item_id'],'listing'=>1));
			$goDowns[''] = 'Select';
			ksort($goDowns);
			$units = $this->stock->get_units($sales_temp_data['item_id']);

			#------------sale date
			$sale_bill_date = $stock_count = "";
			$sale_data = $this->delivery_obj->get_bills(array('columns' => 'bill_date','conditions' => array('group_id' => $sales_temp_data['group_id'],'status !=' => 0)));
			if(!empty($sale_data))
			{
				$sale_bill_date = $sale_data[0]['bill_date'];

				#------------stock count of this item
				$stock_count = $this->stock->get_stock_count($sales_temp_data['godown_id'],$sales_temp_data['item_id'],$sale_bill_date);
			}

			#------------primary unit details
			$primary_unit = $this->stock->get_primary_unit($sales_temp_data['item_id']);

			#------------template
			$this->template->title("Update Delivery Note Voucher");
			$this->template->main_heading($this->lang->line("$voucher_name"));
			$this->template->breadcrumb(array($this->lang->line("$voucher_name") => 'order_to_delivery/delivery',$this->lang->line("update") => 'no_link',$this->lang->line('go-back') => array($redirect_uri)));
			$this->template->slice('dms/message');
			$this->template->slice('sales/sales_entry/edit_temp',array('voucher_name' => $voucher_name,'items' => $items,'units' => $units,'goDowns' => $goDowns,'sales_temp_data' => $sales_temp_data,'sales_cst' => $sales_cst,'presumptive_tax' => $presumptive_tax,'stock_count' => $stock_count,'unit_symbol' => $primary_unit['symbol'],'sale_date' => $sale_bill_date));
			$this->template->other_script('sales/sales_order');
			$this->template->render();
		}
		else
		{
			redirect(base_url());
		}
	}

	public function prd_delete()
	{
		$id=$this->uri->segment(3,0);

		#-----------redirect uri
		$update_uri = $this->uri->uri_to_assoc(4);
		$redirect_uri = $this->uri->assoc_to_uri($update_uri);
		$result = $this->delivery_obj->get_sales_itemss(array('columns' => array('group_id','status','item_status'),'conditions' => array('id' => $id)));
		if(!empty($result))
		{
			$row = $result[0];
			if($row['status'] == -1)
			{
				if($this->delivery_obj->delete(array('table' => 'dms_sales_items1','conditions' => array('id' => $id))))
				{
					#-------------deleting stock bal. from dms_stocks
					$this->delivery_obj->delete(array('table' => 'dms_stocks','conditions' => array('table_id' => $id,'stock_status' => 5)));

					$count = $this->delivery_obj->get_sales_itemss(array('columns' => array('group_id'),'conditions' => array('group_id' => $row['group_id'],'status !=' => 0),'numrows' => true));
					if($count == 0){
						$this->delivery_obj->delete(array('table' => 'dms_delivery_notes','conditions' => array('group_id' => $row['group_id'])));
						redirect('delivery_note/add');

					}
					$this->message->set($this->lang->line('delivery-item-delete-success'));
				}
				else
				{
					$this->message->set($this->lang->line('delivery-item-delete-error'),'e');
				}
			}
		}
		redirect($redirect_uri);
	}

	public function bill_no_exists($bill_no,$value)
	{
		$exp = explode('.',$value);
		$vtype_id = $exp[0];
		$group_id = $exp[1];
		$row = $this->delivery_obj->get_bills(array('columns' => array('id'),'conditions' => array('vtype_id' => $vtype_id,'group_id !=' => $group_id,'bill_no' => $bill_no,'status !=' => 0),'numrows' => true));
		if($row == 0){
			return true;
		}
		return false;
	}
}
?>