<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

class Request_to_sales extends MY_Controller{

	public function __construct()
	{
		parent::__construct();

		$this->check_access_right();
		$this->companyID = $this->session->userdata('company_id');
		#---------------- Checking Financial year is enabled / closed-----------------#
		$method_array = array('pr_sales','prs_update','prs_delete');
		fiscal_status($this->uri->segment(2),$method_array,"purchase_requests/approved_requests");
		#---------------- Checking Financial year is enabled / closed-----------------#

		$this->load->model('sales/Sales_model','sales_obj');
		$this->load->model('vouchers/Voucher_model','vouchers');
		$this->load->library(array('Stock','Targets','Sales_lib'));

		#----------voucher type
		$this->vtype = 6;
	}

	public function pr_sales()
	{
		#----------voucher type
		$vtype_id = $this->vtype;

		#----------sales order primary key
		$pr_id = $this->uri->segment(3);

		#----------purchase_request data
		$purchase_request_array = $this->dms->get_data(array('table' => 'dms_purchase_requests as a','columns' => array('a.customer_id','a.requested_by','a.requested_to','a.request_date','b.item_id','b.qty','b.unit_id'),'join' => array('table' => 'dms_purchase_request_items as b','on' => 'a.id = b.pr_id'),'conditions' => array('a.id' => $pr_id,'a.req_status' => 3,'a.status' => 1,'b.status' => 1)));
		if(!empty($purchase_request_array))
		{
			#----------checking group_id exists for redirection
			$redirection_uri = $this->sales_lib->prs_id_exists($pr_id);
			if($redirection_uri){
				redirect($redirection_uri);
			}
			else
			{
				#-----------sales date and next bill no
				$rules = "callback_bill_no_exists";
				$disabled = "";
				$result_array = $this->sales_obj->next_bill_no($this->vtype);
				$vtype_id = $result_array['vtype_id'];
				$voucher_no = $result_array['bill_no'];
				$voucher_date = $result_array['bill_date'];
				if($result_array['vstatus']){
					$disabled = "readonly";
					$group_id = $result_array['group_id'];
					$rules = "callback_bill_no_exists[$vtype_id.$group_id]";
				}
				else{
					$group_id = $this->stock->get_group_id('dms_sales_items1');
				}

				#----------sales order date
				$so_date = $purchase_request_array[0]['request_date'];

				#----------customer_id, customer_type_id, user_id
				$user = $usertype = $user_type = "";$user_points = 0;
				$user_id = $purchase_request_array[0]['requested_by'];//primary key of users
				$user_details = $this->dms->get_users(array('columns' => array('id','branch_id','designation_id'),'conditions' => array('id' => $user_id)));
				if($purchase_request_array[0]['customer_id'] == 0){//branch or retailer
					$customer_id = $user_details[$user_id]['branch_id'];
					if($user_details[$user_id]['designation_id'] == 3){
						$customer_type_id = 3;//designation id
						$customer = $this->dms->get_data(array('table' => 'retailer_master','columns' => 'ledger_id','conditions' => array('id' => $customer_id)));
					}
					else{
						$customer_type_id = 1;//designation id
						$customer = $this->dms->get_data(array('table' => 'branch_master','columns' => 'ledger_id','conditions' => array('id' => $customer_id)));
					}

					#------------customer_name
					$customer_name = $this->stock->get_customer($customer_type_id,$customer_id);

					$designation_id = $customer_type_id;
					$user_id = $customer_id;
				}
				else{
					$customer_type_id = 2;
					$customer_id = $purchase_request_array[0]['customer_id'];
					$user = $user_id;

					#------------customer_name
					$customer_name = $this->stock->get_customer(2,$customer_id);

					#------------user designation
					$user_desig_name = $this->dms->get_desig($user,1);
					$usertype = $user_desig_name['designation_name'];

					$designation_id = $this->dms->get_desig($user);
					if($designation_id == 4){
						$user_type = $designation_id;#"c";
					}
					elseif($designation_id == 5){
						$user_type = $designation_id;#"m";
					}
					elseif($designation_id == 6){
						$user_type = $designation_id;#"e";
					}
					$customer = $this->dms->get_data(array('table' => 'customer_master','columns' => 'ledger_id','conditions' => array('id' => $customer_id)));
				}

				#------------cess %
				$cess = $this->stock->get_cess();

				#------------adding purchase requests data to sales
				if($result_array['vstatus'] == 0)//data not in dms_sales
				{
					#----------start transaction
					$this->db->trans_start();

					$this->sales_obj->insert("dms_sales",array('vtype_id' => $vtype_id,'branch_id' => $purchase_request_array[0]['requested_to'],'bill_no' => $voucher_no,'bill_date' => $voucher_date,'group_id' => $group_id,'sid' => $pr_id,'s_status' => 1,'customer_type_id' => $customer_type_id,'customer_id' => $customer_id,'user_id' => $user,'cess' => $cess,'status' => -1));

					$godown_id = $this->stock->get_godown();
					foreach($purchase_request_array as $pr_key => $pr_value)
					{
						
						$l_date='2017-07-01';
						$b_date = $pr_value['request_date'];
						$rate = $this->stock->get_item_rate($pr_value['item_id']);
						$amount = $rate*$pr_value['qty'];
						if($b_date < $l_date)
						{
							$vat = $this->stock->get_item_vat($pr_value['item_id']);
							$vat_amt = ($vat*$amount)/100;
							$items_exists = $this->sales_obj->get_sales_items(array('columns' => 'id','conditions' => array('group_id' => $group_id,'item_id' => $pr_value['item_id'],'unit_id' => $pr_value['unit_id'],'godown_id' => $godown_id,'status !=' => 0,'item_status !=' => -1),'numrows' => true));
							if($items_exists == 0)
							{
								#--------------adding purchase items
								$purchase_items_id = $this->sales_obj->insert("dms_sales_items",array('group_id' => $group_id,'item_id' => $pr_value['item_id'],'qty' => $pr_value['qty'],'unit_id' => $pr_value['unit_id'],'rate'=>$rate,'amount'=>$amount,'vat_percent'=>$vat,'vat_amt'=>$vat_amt,'godown_id' => $godown_id,'status' => -1,'item_status' => 2));
								if($purchase_items_id)
								{
									#--------------adding temporary stock balance in dms_stocks
									$pur_stock_bal_temp = $this->stock->unit_conversion($pr_value['item_id'],$pr_value['unit_id'],$pr_value['qty'],0);
									if($pur_stock_bal_temp)
									{
										$this->sales_obj->insert('dms_stocks',array('company_id' => $this->session->userdata('company_id'),'branch_id'=>$this->session->userdata('under_id'),'godown_id' => $godown_id,'item_id' => $pr_value['item_id'],'qty' => $pur_stock_bal_temp['qty'],'unit_id' => $pur_stock_bal_temp['primary_unit'],'rate' => $pur_stock_bal_temp['rate'],'stock_date' => $voucher_date,'stock_status' => 6,'table_group_id'=>$group_id,'table_id' => $purchase_items_id,'status' => -1));
									}
								}
							}
						}
						else
						{
							$cgst = $this->stock->get_item_cgst($pr_value['item_id']);
							$sgst = $this->stock->get_item_sgst($pr_value['item_id']);
							$cgst_amt = ($cgst*$amount)/100;
							$sgst_amt = ($sgst*$amount)/100;

							$items_exists = $this->sales_obj->get_sales_itemss(array('columns' => 'id','conditions' => array('group_id' => $group_id,'item_id' => $pr_value['item_id'],'unit_id' => $pr_value['unit_id'],'godown_id' => $godown_id,'status !=' => 0,'item_status !=' => -1),'numrows' => true));
							if($items_exists == 0)
							{
								$purchase_items_id = $this->sales_obj->insert("dms_sales_items1",array('group_id' => $group_id,'item_id' => $pr_value['item_id'],'qty' => $pr_value['qty'],'unit_id' => $pr_value['unit_id'],'rate'=>$rate,'amount'=>$amount,'cgst'=>$cgst,'sgst'=>$sgst,'cgst_amt'=>$cgst_amt,'sgst_amt'=>$sgst_amt,'godown_id' => $godown_id,'status' => -1,'item_status' => 2));
								if($purchase_items_id)
								{
									#--------------adding temporary stock balance in dms_stocks
									$pur_stock_bal_temp = $this->stock->unit_conversion($pr_value['item_id'],$pr_value['unit_id'],$pr_value['qty'],0);
									if($pur_stock_bal_temp)
									{
										$this->sales_obj->insert('dms_stocks',array('company_id' => $this->session->userdata('company_id'),'branch_id'=>$this->session->userdata('under_id'),'godown_id' => $godown_id,'item_id' => $pr_value['item_id'],'qty' => $pur_stock_bal_temp['qty'],'unit_id' => $pur_stock_bal_temp['primary_unit'],'rate' => $pur_stock_bal_temp['rate'],'stock_date' => $voucher_date,'stock_status' => 6,'table_group_id'=>$group_id,'table_id' => $purchase_items_id,'status' => -1));
									}
								}
							}		
						}
					}

					#----------end transaction
					$this->db->trans_complete();
				}

				#------------presumptive tax checking
				$presumptive_tax = $this->stock->get_tax_type();

				#-------------adding data to sales temp
				if(isset($_POST['btn_add']))
				{
					#-----------validation
					$this->form_validation->set_rules('item_id','lang:item-name','required|xss_clean');
					$this->form_validation->set_rules('godown_id','lang:godown','required|xss_clean');
					$this->form_validation->set_rules('cst','lang:cst','xss_clean|greater_or_equal[0]|less_or_equal[100]');
					$this->form_validation->set_rules('qty','lang:quantity','required|xss_clean|greater_than[0]|less_than[100000000]');
					$this->form_validation->set_rules('unit_id','lang:unit','required|xss_clean');
					$this->form_validation->set_rules('rate','lang:rate','required|xss_clean|greater_or_equal[0]|less_than[100000000]');
					$this->form_validation->set_rules('amount','lang:amount','xss_clean|required|greater_or_equal[0]|less_than[100000000]');
					$this->form_validation->set_rules('discount_per','lang:discount %','xss_clean|greater_or_equal[0]|less_or_equal[100]');
					$this->form_validation->set_rules('discount_amt','lang:discount','xss_clean|greater_or_equal[0]|less_than[100000000]');

					#-----------adding temporary data
					if($this->form_validation->run('btn_add') === true)
					{
						#----------VAT calculation
						$bt_date = $this->input->post('bill_date',true);
						if($bt_date < $l_date)
						{
							$cst = $vat_amt = $vat_percent = 0;
							if($this->input->post('cst',true)){
								$cst = $this->input->post('cst',true);
							}
							if(empty($presumptive_tax)){
								if($cst == 0){
									$vat_percent = $this->stock->get_item_vat($this->input->post('item_id',true));
									$vat_amt = ($vat_percent * ($this->input->post('amount',true) - $this->input->post('discount_amt',true))) / 100;
								}
							}
						

						#----------rate calculation
							$rate = 0;
							if($this->input->post('qty',true) != 0){
								$rate = $this->input->post('amount',true) / $this->input->post('qty',true);
							}
	
							$item_array = array('group_id' => $group_id,'item_id' => $this->input->post('item_id',true),'qty' => $this->input->post('qty',true),'unit_id' => $this->input->post('unit_id',true),'rate' => $rate,'amount' => $this->input->post('amount',true),'discount_per' => $this->input->post('discount_per',true),'discount_amt' => $this->input->post('discount_amt',true),'vat_percent' => $vat_percent,'vat_amt' => $vat_amt,'cst' => $cst,'godown_id' => $this->input->post('godown_id',true),'status' => -1,'item_status' => 2);
	
							$sales_temp_item_result = $this->sales_obj->get_sales_items(array('columns' => 'id','conditions' => array('group_id' => $group_id,'item_id' => $item_array['item_id'],'unit_id' => $item_array['unit_id'],'godown_id' => $item_array['godown_id'],'status !=' => 0,'item_status !=' => -1),'numrows' => true));
							if($sales_temp_item_result == 0)
							{
								#--------------adding sales items
								$sales_items_id = $this->sales_obj->insert("dms_sales_items",$item_array);
								if($sales_items_id)
								{
									#--------------adding temporary stock balance in dms_stocks
									$stock_bal_temp = $this->stock->unit_conversion($item_array['item_id'],$item_array['unit_id'],$item_array['qty'],$item_array['rate'],$item_array['amount']);
									if($stock_bal_temp)
									{
										$this->sales_obj->insert('dms_stocks',array('company_id' => $this->session->userdata('company_id'),'branch_id'=>$this->session->userdata('under_id'),'godown_id' => $item_array['godown_id'],'item_id' => $item_array['item_id'],'qty' => $stock_bal_temp['qty'],'unit_id' => $stock_bal_temp['primary_unit'],'rate' => $stock_bal_temp['rate'],'amount' => $stock_bal_temp['amount'],'stock_date' => $voucher_date,'stock_status' => 6,'table_group_id' => $group_id,'table_id' => $sales_items_id,'status' => -1));
									}
									$this->message->set($this->lang->line('sales-add-success'));
								}
								else
								{
									$this->message->set($this->lang->line('sales-add-error'),'e');
								}
							}
							else{
								$this->message->set($this->lang->line('sales-add-error'),'e');
							}
							$redirect_uri = $this->uri->uri_to_assoc(1);
							redirect($this->uri->assoc_to_uri($redirect_uri));
						}
						else
						{
							$cgst = $this->stock->get_item_cgst($this->input->post('item_id',true));
							$sgst = $this->stock->get_item_sgst($this->input->post('item_id',true));
							$cgst_amt = ($cgst * ($this->input->post('amount',true) - $this->input->post('discount_amt',true))) / 100;
							$sgst_amt = ($sgst * ($this->input->post('amount',true) - $this->input->post('discount_amt',true))) / 100;
							$rate = 0;
							if($this->input->post('qty',true) != 0){
								$rate = $this->input->post('amount',true) / $this->input->post('qty',true);
							}
	
							$item_array = array('group_id' => $group_id,'item_id' => $this->input->post('item_id',true),'qty' => $this->input->post('qty',true),'unit_id' => $this->input->post('unit_id',true),'rate' => $rate,'amount' => $this->input->post('amount',true),'discount_per' => $this->input->post('discount_per',true),'discount_amt' => $this->input->post('discount_amt',true),'cgst' => $cgst,'sgst'=>$sgst,'cgst_amt' => $cgst_amt,'sgst_amt' => $sgst_amt,'godown_id' => $this->input->post('godown_id',true),'status' => -1,'item_status' => 2);
	
							$sales_temp_item_result = $this->sales_obj->get_sales_itemss(array('columns' => 'id','conditions' => array('group_id' => $group_id,'item_id' => $item_array['item_id'],'unit_id' => $item_array['unit_id'],'godown_id' => $item_array['godown_id'],'status !=' => 0,'item_status !=' => -1),'numrows' => true));
							if($sales_temp_item_result == 0)
							{
								#--------------adding sales items
								$sales_items_id = $this->sales_obj->insert("dms_sales_items1",$item_array);
								if($sales_items_id)
								{
									#--------------adding temporary stock balance in dms_stocks
									$stock_bal_temp = $this->stock->unit_conversion($item_array['item_id'],$item_array['unit_id'],$item_array['qty'],$item_array['rate'],$item_array['amount']);
									if($stock_bal_temp)
									{
										$this->sales_obj->insert('dms_stocks',array('company_id' => $this->session->userdata('company_id'),'branch_id'=>$this->session->userdata('under_id'),'godown_id' => $item_array['godown_id'],'item_id' => $item_array['item_id'],'qty' => $stock_bal_temp['qty'],'unit_id' => $stock_bal_temp['primary_unit'],'rate' => $stock_bal_temp['rate'],'amount' => $stock_bal_temp['amount'],'stock_date' => $voucher_date,'stock_status' => 6,'table_group_id' => $group_id,'table_id' => $sales_items_id,'status' => -1));
									}
									$this->message->set($this->lang->line('sales-add-success'));
								}
								else
								{
									$this->message->set($this->lang->line('sales-add-error'),'e');
								}
							}
							else{
								$this->message->set($this->lang->line('sales-add-error'),'e');
							}
							$redirect_uri = $this->uri->uri_to_assoc(1);
							redirect($this->uri->assoc_to_uri($redirect_uri));
							
							
						}
					}
				}

				#------------saving sales voucher
				if(isset($_POST['btn_save']))
				{
					#-----------validation
					$this->form_validation->set_rules('vtype_id','lang:voucher-types','required|xss_clean');
					$this->form_validation->set_rules('bill_no','lang:bill-no',"required|xss_clean|is_natural_no_zero|".$rules);
					$this->form_validation->set_rules('bill_date','lang:bill-date',"required|xss_clean|valid_date|check_date[$so_date.>=]");
					$this->form_validation->set_rules('area_id','lang:area','required|xss_clean');
					$this->form_validation->set_rules('payment_mode','lang:payment-mode','required|xss_clean');
					$this->form_validation->set_rules('credit_period','lang:credit-period','xss_clean|is_natural');
					if($this->input->post('payment_mode',true) == 2){
						$this->form_validation->set_rules('credit_period','lang:credit-period','required|xss_clean|is_natural');
					}
					elseif($this->input->post('payment_mode',true) > 2){
						$voucher_date = date('Y-m-d',strtotime($this->input->post('bill_date',true)));
						$this->form_validation->set_rules('ccd','lang:cash-cheque-dd','required|xss_clean');
						$this->form_validation->set_rules('cd_no','lang:cd-no','required|xss_clean');
						$this->form_validation->set_rules('cheque_date','lang:cheque-date',"required|xss_clean|is_date|check_date[$voucher_date.>=]");
					}
					$this->form_validation->set_rules('remarks','lang:remarks','xss_clean');
					$this->form_validation->set_rules('freight','lang:freight','xss_clean|greater_or_equal[0]');
					$this->form_validation->set_rules('other_expense','lang:other-expense','xss_clean|greater_or_equal[0]');
					$this->form_validation->set_rules('bill_discount_per','lang:discount %','xss_clean|greater_or_equal[0]|less_or_equal[100]');
					$this->form_validation->set_rules('bill_discount_amt','lang:discount','xss_clean|greater_or_equal[0]');

					#-----------saving data
					if($this->form_validation->run('btn_save') === true)
					{
						$vtype_id = $this->input->post('vtype_id',true);
						$voucher_no = $this->input->post('bill_no',true);
						$bill_no = $voucher_no;
						$voucher_date = date('Y-m-d',strtotime($this->input->post('bill_date',true)));
						$bill_date = $voucher_date;
						$payment_mode = $this->input->post('payment_mode',true);
						$narration = $this->input->post('remarks',true);
						$bill_discount_amt = $this->input->post('bill_discount_amt',true);
						$freight = $this->input->post('freight',true);
						$other_expense = $this->input->post('other_expense',true);
						$sales_entry_array=array('vtype_id' => $vtype_id,'bill_no' => $voucher_no,'bill_date' => $voucher_date,'area_id' => $this->input->post('area_id',true),'bill_discount_per' => $this->input->post('bill_discount_per',true),'bill_discount_amt' => $bill_discount_amt,'bill_freight' => $freight,'other_expense' => $other_expense,'narration' => $narration,'payment_mode' => $payment_mode,'cr_period' => $this->input->post('credit_period',true),'status' => 1);

						#----------start transaction
						$this->db->trans_start();

						#------------checking data is in dms_sales table
						if($this->sales_obj->update(array('table' => 'dms_sales','data' => $sales_entry_array,'conditions' => array('group_id' => $group_id))))
						{
							if($bill_date < $l_date)
							{
							#------------updating sales_item status
								$this->sales_obj->update_others(array('table' => 'dms_sales_items','data' => array('status' => 1),'conditions' => array('group_id' => $group_id,'status !=' => 0)));
							}
							else
							{
								$this->sales_obj->update_others(array('table' => 'dms_sales_items1','data' => array('status' => 1),'conditions' => array('group_id' => $group_id,'status !=' => 0)));	
							}
							#------------updating purchase_requests status
								$this->sales_obj->update_others(array('table' => 'dms_purchase_requests','data' => array('req_status' => 5),'conditions' => array('id' => $pr_id)));

							#-------------adding bill to dms_vouchers
							$voucher_status = 1;
							$voucher_amount = $this->input->post('grand_total',true);
							$vat_amount = $this->input->post('vat_total',true);
							$cess_amount = $this->input->post('cess_total',true);
							if($payment_mode > 2)
							{
								$bill_date_time = strtotime($bill_date);
								$cheque_date = date('Y-m-d',strtotime($this->input->post('cheque_date',true)));
								$cheque_date_time = strtotime($cheque_date);
								if($this->input->post('ccd',true) == 1 && $cheque_date_time > $bill_date_time)
								{
									$voucher_status = 3;
								}
							}
							elseif($payment_mode == 2){
								$payment_mode = $customer[0]['ledger_id'];//customer
							}
							$voucher_group_id = $this->stock->get_group_id('dms_vouchers');
							$voucher_amount -= $bill_discount_amt;
							$voucher_array = array('company_id' => $this->session->userdata('company_id'),'branch_id' => $this->session->userdata('under_id'),'group_id' => $voucher_group_id,'vtype_id' => $vtype_id,'vno' => $bill_no,'vorder_no' => 1,'vdate' => $bill_date,'dr_ledger' => $payment_mode,'cr_ledger' => 4,'vamount' => $voucher_amount,'narration' => $narration,'table_name' => 'dms_sales','table_group_id' => $group_id,'status' => $voucher_status);
							$voucher_data = $this->dms->get_data(array('table' =>'dms_vouchers','columns' => 'id','conditions' => array('table_name' => 'dms_sales','table_group_id' => $group_id),'numrows' => true));
							if($voucher_data == 0)
							{
								$voucher_success = $this->sales_obj->insert('dms_vouchers',$voucher_array);
								if($voucher_success)
								{
									#-----------VAT
									$voucher_array['cr_ledger'] = 12;
									$voucher_array['vorder_no'] = 2;

									$voucher_array['vamount'] = $vat_amount;
									$this->sales_obj->insert('dms_vouchers',$voucher_array);
									#-----------CESS
									$voucher_array['cr_ledger'] = 15;
									$voucher_array['vorder_no'] = 3;
									$voucher_array['vamount'] = $cess_amount;
									$this->sales_obj->insert('dms_vouchers',$voucher_array);
									#-----------Freight
									$voucher_array['dr_ledger'] = 13;
									$voucher_array['cr_ledger'] = $payment_mode;
									$voucher_array['vorder_no'] = 4;
									$voucher_array['vamount'] = $freight;
									$this->sales_obj->insert('dms_vouchers',$voucher_array);
									#-----------Other Expense
									$voucher_array['dr_ledger'] = 14;
									$voucher_array['vorder_no'] = 5;
									$voucher_array['vamount'] = $other_expense;
									$this->sales_obj->insert('dms_vouchers',$voucher_array);

									if($payment_mode > 2)
									{
										$this->sales_obj->insert('dms_voucher_banks',array('group_id' => $voucher_group_id,'cash_type' => $this->input->post('ccd',true),'cd_no' => $this->input->post('cd_no',true),'pdc' => $cheque_date,'vdate' => $bill_date));
									}
								}
							}
							if($bill_date < $l_date)
							{
								$sales_items_array = $this->sales_obj->get_sales_items(array('columns' => array('id'),'conditions' => array('group_id' => $group_id,'status' => 1,'item_status !=' => -1)));
							}
							else
							{
								$sales_items_array = $this->sales_obj->get_sales_itemss(array('columns' => array('id'),'conditions' => array('group_id' => $group_id,'status' => 1,'item_status !=' => -1)));	
							}
							foreach($sales_items_array as $key => $value)
							{
								#-------------enabling temporarily added stocks
								$this->sales_obj->update_others(array('table' => 'dms_stocks','data' => array('stock_date' => $voucher_date,'status' => 1),'conditions' => array('stock_status' => 6,'table_id' => $value['id'])));

								#--------------calculating user points
								if(!empty($user_id) && empty($user_type))
								{
									$user_points += $this->targets->get_bill_points($designation_id,$user_id,$value['item_id'],$value['unit_id'],$value['qty'],$value['rate'],$voucher_date);
								}
							}
							#--------------calculating user points
							if($user_points > 0)
							{
								$target_id = $this->targets->get_targets(array('columns' => 'a.id','conditions' => array('a.designation_id' => $designation_id,'a.user_id' => $user_id,'a.status' => 1),'bill_date' => $voucher_date));
								if($target_id)
								{
									$this->sales_obj->insert('user_points',array('designation_id' => $designation_id,'user_id' => $user_id,'targets_id' => $target_id['id'],'group_id' => $group_id,'sms_point' => $user_points,'actual_point'=>$user_points));
								}
							}
							if(!empty($user_type)){
								$user_data = $this->dms->get_data(array('table' =>'users','columns' => 'mobile','conditions' => array('id' => $user_id)));
								if(!empty($user_data)){
									$user_type_mobile=$user_data[0]['mobile'];
									$this->sales_obj->insert('dms_sms',array('company_id' =>$this->companyID,'bill_ref_no' => $group_id,'user_type'=>$user_type,'user_id'=>$user_id,'status'=>3));
								}
							}							
							$this->message->set($this->lang->line('sales-save-success'));
						}
						else{
							$this->message->set($this->lang->line('sales-save-error'),'e');
						}

						#----------transaction completed
						$this->db->trans_complete();

						redirect('sales/add');
					}
				}

				#----------sales items
				$sales_items = $this->sales_obj->get_sales_items(array('conditions' => array('group_id' => $group_id,'status !=' => 0,'item_status !=' => -1)));
				if(empty($sales_items))
				{
					$sales_items = $this->sales_obj->get_sales_itemss(array('conditions' => array('group_id' => $group_id,'status !=' => 0,'item_status !=' => -1)));
				}
				#----------voucher type array
				$voucher_types = $this->vouchers->voucher_types($this->vtype);
				$bill_prefix = $this->stock->get_voucher_prefix($this->vtype);
				#----------voucher name
				$voucher_name = $this->vouchers->voucher_name($this->vtype);

				#-----------sales cst checking details
				$sales_cst = $this->stock->get_constant(array('sales_cst'));

				#------------item details / unit details / godown details
				$units = array();$goDowns = array();
				$units[''] = "Select";
				$args['select'] = array('id','item_code','item_name');
				$items = $this->stock->get_stock_items($args);
				if(empty($items)){
					$this->message->set($this->lang->line('no-items-found'),'i');
				}
				if($this->input->post('item_id',true)){
					$itemID = $this->input->post('item_id',true);
					$goDowns = $this->stock->get_item_godowns(array('item_id'=>$itemID,'listing'=>1));
					$units = $this->stock->get_units($itemID);
				}

				$items[''] = 'Select';ksort($items);
				$goDowns[''] = 'Select';ksort($goDowns);

				#------------stock count of this item
				$stock_count = "";$primary_unit['symbol'] = "";
				if($this->input->post('item_id',true) && $this->input->post('godown_id',true) && $this->input->post('bill_date',true)){
					$bill_date = date('Y-m-d',strtotime($this->input->post('bill_date',true)));
					$stock_count = $this->stock->get_stock_count($this->input->post('godown_id',true),$this->input->post('item_id',true),$bill_date);
					$primary_unit = $this->stock->get_primary_unit($this->input->post('item_id',true));
				}

				#------------loading model
				$this->load->model('customers/Customer_type_model','customer_type');
				$pricelists = $this->customer_type->listing();
				$pricelists[''] = 'Select';ksort($pricelists);

				#------------area details
				$this->load->model('areas/Area_model','area');
				$areas = $this->area->listing();
				$areas[''] = 'Select';ksort($areas);

				#------------payment modes
				$payment_modes = $this->stock->payment_modes();

				#------------checking cst enabled or not
				$cst_status = $this->sales_obj->get_cst($group_id);
				if($cst_status){ $sales_cst = $cst_status; }

				#------------customer_type
				$customer_type = $this->dms->desig_name($customer_type_id);

				#------------user_name
				$user_name = $this->dms->get_user_name($user);

				#------------cheque / dd details
				$cd_status = 1;
				if($this->input->post('payment_mode',true) > 2){
					$cd_status = 0;
				}

				#------------template
				$this->template->title("New Sales Voucher");
				$this->template->main_heading($this->lang->line("$voucher_name"));
				$this->template->breadcrumb(array($this->lang->line("$voucher_name") => 'no_link',$this->lang->line('report') => 'sales/report'));
				$this->template->slice('dms/message');
				$this->template->slice('purchase/requests/sales',array('purchase_request_array' => $purchase_request_array,'customer_type' => $customer_type,'customer_name' => $customer_name,'user_type' => $usertype,'user' => $user_name,'pricelists' => $pricelists,'areas' => $areas,'voucher_types' => $voucher_types,'voucher_name' => $voucher_name,'voucher_type' => $vtype_id,'disabled' => $disabled,'items' => $items,'goDowns' => $goDowns,'units' => $units,'sales_cst' => $sales_cst,'stock_count' => $stock_count,'primary_unit' => $primary_unit['symbol'],'payment_modes' => $payment_modes,'sales_items' => $sales_items,'voucher_no' => $voucher_no,'voucher_date' => $voucher_date,'cess' => $cess,'cd_status' => $cd_status,'bill_prefix'=>$bill_prefix));
				$this->template->other_script(array('sales/sales_order','purchase/purchase_request'));
				$this->template->render();
			}
		}
		else{
			redirect('users/logout');
		}
	}

	public function prs_update()
	{
		#----------sales items id from sales / sales order
		$sales_temp_id = $this->uri->segment(3);

	//	$row = $this->sales_obj->get_sales_items(array('columns' => array('id','group_id','item_id','qty','unit_id','rate','amount','discount_per','discount_amt','vat_amt','cst','godown_id','item_status'),'conditions' => array('id' => $sales_temp_id)));
		$row = $this->sales_obj->get_sales_items(array('columns' => array('id','group_id','item_id','qty','unit_id','rate','amount','discount_per','discount_amt','cgst_amt','sgst_amt','godown_id','item_status'),'conditions' => array('id' => $sales_temp_id)));
	
		if(!empty($row))
		{
			$sales_temp_data = $row[0];

			#-----------validation
			$this->form_validation->set_rules('godown_id','lang:godown','required|xss_clean');
			$this->form_validation->set_rules('cst','lang:cst','xss_clean|greater_or_equal[0]|less_or_equal[100]');
			$this->form_validation->set_rules('qty','lang:quantity','required|xss_clean|greater_than[0]|less_than[100000000]');
			$this->form_validation->set_rules('unit_id','lang:unit','required|xss_clean');
			$this->form_validation->set_rules('rate','lang:rate','required|xss_clean|greater_or_equal[0]|less_than[100000000]');
			$this->form_validation->set_rules('amount','lang:amount','xss_clean|required|greater_or_equal[0]|less_than[100000000]');
			$this->form_validation->set_rules('discount_per','lang:discount %','xss_clean|greater_or_equal[0]|less_or_equal[100]');
			$this->form_validation->set_rules('discount_amt','lang:discount','xss_clean|greater_or_equal[0]|less_than[100000000]');
			$this->form_validation->set_rules('vat_amt','lang:vat-amt','xss_clean|greater_or_equal[0]|less_than[100000000]');

			#-----------redirect uri
			$update_uri = $this->uri->uri_to_assoc(4);
			$redirect_uri = $this->uri->assoc_to_uri($update_uri);

			#-----------updating temporary data
			if($this->form_validation->run() === true)
			{
				$item_temp_array = $this->input->post(NULL,true);

				#----------rate calculation
				$item_temp_array['rate'] = 0;
				if($item_temp_array['qty'] != 0){
					$item_temp_array['rate'] = $item_temp_array['amount'] / $item_temp_array['qty'];
				}

				#------------presumptive tax checking
				$presumptive_tax = $this->stock->get_tax_type();

				#----------VAT calculation
		/*		$cst = 0;
				if(array_key_exists('cst',$item_temp_array)){
					$cst = $item_temp_array['cst'];
				}
				if(empty($presumptive_tax)){
					if($cst == 0){
						$item_temp_array['vat_percent'] = $this->stock->get_item_vat($sales_temp_data['item_id']);
					}
				}	*/
				$item_temp_array['cgst']= $this->stock->get_item_cgst($sales_temp_data['item_id']);
				$item_temp_array['sgst']= $this->stock->get_item_sgst($sales_temp_data['item_id']);

				if($sales_temp_data['item_status'] == 0 && ($sales_temp_data['qty'] != $item_temp_array['qty'] || $sales_temp_data['unit_id'] != $item_temp_array['unit_id'] || $sales_temp_data['rate'] != $item_temp_array['rate'] || $sales_temp_data['discount_per'] != $item_temp_array['discount_per'] || $sales_temp_data['discount_amt'] != $item_temp_array['discount_amt'] || $sales_temp_data['godown_id'] != $item_temp_array['godown_id'] || $sales_temp_data['cgst_amt'] != $item_temp_array['cgst_amt'] || $sales_temp_data['sgst_amt'] != $item_temp_array['sgst_amt']))
				{
					$item_temp_array['group_id'] = $sales_temp_data['group_id'];
					$item_temp_array['item_id'] = $sales_temp_data['item_id'];
					$item_temp_array['status'] = -1;
					$item_temp_array['item_status'] = 2;
					$sales_temp_data['item_status'] = 2;
					if($this->sales_obj->update_others(array('table' => 'dms_sales_items1','data' => array('item_status' => -1),'conditions' => array('id' => $sales_temp_id)))){
						$sales_temp_id = $this->sales_obj->insert('dms_sales_items1',$item_temp_array);
						$this->message->set($this->lang->line('sales-edit-temp-success'));
					}
				}
				else
				{
					$item_temp_array['status'] = -1;
					$this->sales_obj->update_others(array('table' => 'dms_sales_items1','data' => $item_temp_array,'conditions' => array('id' => $sales_temp_id)));
					$this->message->set($this->lang->line('sales-edit-temp-success'));
				}

				#--------------updating bill status in dms_sales
				if($this->sales_obj->get_bills(array('columns' => 'id','conditions' => array('group_id' => $sales_temp_data['group_id'],'status =' => 1),'numrows' => true)) > 0)
				{
					$this->sales_obj->update_others(array('table' => 'dms_sales','data' => array('status' => -1),'conditions' => array('group_id' => $sales_temp_data['group_id'])));
				}

				#--------------updating temporary stock balance in dms_stocks
				if($sales_temp_data['item_status'] == 2)
				{
					$stock_bal_temp = $this->stock->unit_conversion($sales_temp_data['item_id'],$item_temp_array['unit_id'],$item_temp_array['qty'],$item_temp_array['rate'],$item_temp_array['amount']);
					if($stock_bal_temp)
					{
						$this->sales_obj->update_others(array('table' => 'dms_stocks','data' => array('godown_id' => $item_temp_array['godown_id'],'qty' => $stock_bal_temp['qty'],'unit_id' => $stock_bal_temp['primary_unit'],'rate' => $stock_bal_temp['rate'],'amount' => $stock_bal_temp['amount']),'conditions' => array('stock_status' => 6,'table_id' => $sales_temp_id)));
					}
				}
				redirect($redirect_uri);
			}

			#----------voucher name
			$voucher_name = $this->vouchers->voucher_name($this->vtype);

			#-----------sales cst checking details
			$sales_cst = $this->stock->get_constant(array('sales_cst'));

			#------------presumptive tax checking
			$presumptive_tax = $this->stock->get_tax_type();

			#------------checking cst enabled or not
			$cst_status = $this->sales_obj->get_cst($sales_temp_data['group_id']);
			if($cst_status){
				$sales_cst = $cst_status;
			}

			#------------item details / unit details / godown details
			$units = array();$goDowns = array();
			$item_details = $this->stock->get_item($sales_temp_data['item_id'],array('item_code','item_name'));
			$items[$sales_temp_data['item_id']] = $item_details['item_code']." / ".$item_details['item_name'];
			$goDowns = $this->stock->get_item_godowns(array('item_id'=>$sales_temp_data['item_id'],'listing'=>1));
			$goDowns[''] = 'Select';
			ksort($goDowns);
			$units = $this->stock->get_units($sales_temp_data['item_id']);

			#------------sale date
			$sale_bill_date = "";$stock_count = "";
			$sale_data = $this->sales_obj->get_bills(array('columns' => 'bill_date','conditions' => array('group_id' => $sales_temp_data['group_id'],'status !=' => 0)));
			if(!empty($sale_data))
			{
				$sale_bill_date = $sale_data[0]['bill_date'];

				#------------stock count of this item
				$stock_count = $this->stock->get_stock_count($sales_temp_data['godown_id'],$sales_temp_data['item_id'],$sale_bill_date);
			}

			#------------primary unit details
			$primary_unit = $this->stock->get_primary_unit($sales_temp_data['item_id']);

			#------------template
			$this->template->title("Update Sales Voucher");
			$this->template->main_heading($this->lang->line("$voucher_name"));
			$this->template->breadcrumb(array($this->lang->line("$voucher_name") => 'order_to_sales/so_sales',$this->lang->line("update") => 'no_link',$this->lang->line('go-back') => array($redirect_uri)));
			$this->template->slice('dms/message');
			$this->template->slice('sales/sales_entry/edit_temp',array('voucher_name' => $voucher_name,'items' => $items,'units' => $units,'goDowns' => $goDowns,'sales_temp_data' => $sales_temp_data,'sales_cst' => $sales_cst,'presumptive_tax' => $presumptive_tax,'stock_count' => $stock_count,'unit_symbol' => $primary_unit['symbol'],'sale_date' => $sale_bill_date));
			$this->template->other_script('sales/sales_order');
			$this->template->render();
		}
		else
		{
			redirect(base_url());
		}
	}

	public function prs_delete()
	{
		$id=$this->uri->segment(3,0);

		#-----------redirect uri
		$update_uri = $this->uri->uri_to_assoc(4);
		$redirect_uri = $this->uri->assoc_to_uri($update_uri);

		$result = $this->sales_obj->get_sales_itemss(array('columns' => array('group_id','status','item_status'),'conditions' => array('id' => $id)));
		if(!empty($result))
		{
			$row = $result[0];
			if($row['status'] == -1)
			{
				#----------start transaction
				$this->db->trans_start();

				if($this->sales_obj->delete(array('table' => 'dms_sales_items1','conditions' => array('id' => $id))))
				{
					#-------------deleting stock bal. from dms_stocks
					$this->sales_obj->delete(array('table' => 'dms_stocks','conditions' => array('table_id' => $id,'stock_status' => 6)));

					$count = $this->sales_obj->get_sales_itemss(array('columns' => array('group_id'),'conditions' => array('group_id' => $row['group_id'],'status !=' => 0),'numrows' => true));
					if($count == 0){
						$this->sales_obj->delete(array('table' => 'dms_sales','conditions' => array('group_id' => $row['group_id'])));
						redirect('sales/add');
					}
					$this->message->set($this->lang->line('sales-item-delete-success'));
				}
				else
				{
					$this->message->set($this->lang->line('sales-item-delete-error'),'e');
				}

				#----------end transaction
				$this->db->trans_complete();
			}
		}
		redirect($redirect_uri);
	}

	public function bill_no_exists($bill_no,$v_details = NULL)
	{
		if($v_details == NULL){
			$where = array('vtype_id' => $this->input->post('vtype_id',true),'bill_no' => $bill_no,'status !=' => 0);
		}
		else{
			$exp = explode('.', $v_details);
			$where = array('vtype_id' => $exp[0],'bill_no' => $bill_no,'group_id !=' => $exp[1],'status !=' => 0);
		}
		$row = $this->sales_obj->get_bills(array('columns' => array('id'),'conditions' => $where,'numrows' => true));
		if($row == 0){
			return true;
		}
		return false;
	}
}
?>