<?php if( !defined('BASEPATH')) exit ('No direct script access allowed');

	class Request_to_stock_transfer extends MY_Controller{
		var $company_Id,$branch_Id,$created_By;
		public function __construct(){
			parent ::__construct();
			$this->check_access_right();
			$this->load->library(array('Stock','Sales_lib'));
			$fiscals = $this->dms->get_fiscal_year();
			$this->fiscal_start_date = $fiscals['start_date'];
			$this->fiscal_end_date = $fiscals['end_date'];

			$this->company_Id = $this->session->userdata('company_id');
			$this->branch_Id = $this->session->userdata('under_id');
			$this->created_By = $this->session->userdata('id');
		}
       #--------------------------------------------------
		public function transfer($id){
			$purchase_request_id = $id;
			if(empty($purchase_request_id)){ redirect('users/logout');}
			$this->load->model('godown/Godown_model','godown');
			$this->load->model('vouchers/Voucher_model','voucher');
			$this->load->model('stocks/Stock_transfer_model','stocktransfer');
			$this->load->library('Stock');
			$purchase_request_array = $this->dms->get_data(array('table' => 'dms_purchase_requests as a','columns' => array('a.id','a.customer_id','a.requested_by','a.requested_to','a.request_date','b.item_id','b.qty','b.unit_id'),'join' => array('table' => 'dms_purchase_request_items as b','on' => 'a.id = b.pr_id'),'conditions' => array('a.id' =>$purchase_request_id,'a.req_status' => 3,'a.status' => 1,'b.status' => 1)));
			$transfer_Id =$this->stocktransfer->get_transfer_id();
			$transfer_date = cdateFormat($purchase_request_array[0]['request_date']);

			#checking request from branches :otherwise logout
			$designation = $this->dms->get_desig($purchase_request_array[0]['requested_by']);
			if($designation ==3){
				redirect('users/logout');
			}

			if(!empty($purchase_request_array)){
				$redirection_uri = $this->sales_lib->prst_id_exists($purchase_request_id);
				if($redirection_uri){
					redirect($redirection_uri);
				}

				if($this->input->post('save_stock')){
					$this->form_validation->set_rules('transfer_no','lang:transfer-id','required|trim|xss_clean|is_unique[dms_stock_transfers.transfer_no]');
					$this->form_validation->set_rules('transfer_date','lang:date',"is_date|required|xss_clean|valid_date|callback_check_transfer_date[$transfer_date]");
					$this->form_validation->set_rules('godown_to_id','lang:transfer-to','required|trim|xss_clean');
					$this->form_validation->set_rules('freight','lang:freight','trim|xss_clean');
					$this->form_validation->set_rules('other_expense','lang:other-expense','trim|xss_clean');
					$this->form_validation->set_rules('narration','lang:narration','trim|xss_clean');
					
			

					if($this->form_validation->run('save_stock') == TRUE){
						
						$data = $this->input->post(NULL,TRUE);
						$stocks = $this->input->post('stock',TRUE);

						$transfer_data['branch_id'] = $this->branch_Id;
						$transfer_data['transfer_no'] = $data['transfer_no'];
						$transfer_data['transfer_date'] =  date('Y-m-d',strtotime($data['transfer_date']));
						$transfer_data['godown_to_id'] = $data['godown_to_id'];
						$transfer_data['freight'] = $data['freight'];
						$transfer_data['other_expense'] = $data['other_expense'];
						$transfer_data['narration'] = $data['narration'];
						$transfer_data['group_id'] =$group_id = $this->stock->get_group_id('dms_stock_transfers');
						$transfer_data['sid'] = $purchase_request_id ;
						$transfer_data['s_status'] = 1;
						$transfer_data['st_status'] = 0;
						if($this->stocktransfer->f_save('dms_stock_transfers',$transfer_data)){

							#update purchase request status
							$this->stocktransfer->my_update('dms_purchase_requests',array('req_status'=>6),array('id'=>$purchase_request_array[0]['id']));
							foreach ($purchase_request_array as $pur_key =>$purchase) {
								$transfer_item['item_id'] = $purchase['item_id'];
								$transfer_item['qty'] = $purchase['qty'];
								$transfer_item['unit_id'] = $purchase['unit_id'];
								$transfer_item['group_id'] = $group_id;

								foreach ($stocks as $stock_key =>$stock){

									if($pur_key == $stock_key){
										$transfer_item['godown_from_id'] = $stock['godown_from_id'];
									}
								}
								if($this->stocktransfer->f_save('dms_stock_transfer_items',$transfer_item)){
									$stock_transfer_item_id = $this->db->insert_id();
									#saving dms stocks data for mds stocks 
									$conversion = $this->stock->unit_conversion($transfer_item['item_id'],$transfer_item['unit_id'],$transfer_item['qty']);
									$stock_item['unit_id'] = $conversion['primary_unit'];
									$stock_item['qty'] = -$conversion['qty'];
									$stock_item['company_id'] = $this->company_Id;
									$stock_item['branch_id'] = $this->branch_Id;
									$stock_item['item_id'] = $transfer_item['item_id'];
									$stock_item['stock_date'] = $transfer_data['transfer_date'] ;
									$stock_item['stock_status'] =10;
									$stock_item['godown_id'] = $transfer_item['godown_from_id'];
									$stock_item['table_id'] = $stock_transfer_item_id;
									$stock_item['status'] = 1;
									$stock_item['table_group_id'] = $group_id; 
									#ssaving stock data minus quantity for godown from id
									$this->stocktransfer->f_save('dms_stocks',$stock_item);
									#ssaving stock data plus  quantity fot godown to id
									$stock_item['status'] = -1; 
									$stock_item['qty'] = $conversion['qty'];
									$stock_item['godown_id'] = $transfer_data['godown_to_id'];
									$this->stocktransfer->f_save('dms_stocks',$stock_item);
								}		
							}
							//get common voucher no and voucher groupe id
							$voucher_group_id = $this->stock->get_group_id('dms_vouchers');
							$voucher_no = $this->voucher->get_voucher_number($voucher['vtype_id']);
							if(!empty($transfer_data['freight']) && $transfer_data['freight'] > 0){
								$voucher['company_id'] = $this->company_Id;
								$voucher['branch_id'] = $this->branch_Id;
								$voucher['group_id'] = $voucher_group_id;
								$voucher['vtype_id'] = 2;
								$voucher['vno'] = $voucher_no;
								$voucher['vorder_no'] =1;
								$voucher['vdate'] = $transfer_data['transfer_date'];
								$voucher['dr_ledger'] = 1;
								$voucher['cr_ledger'] = 13;
								$voucher['vamount'] = $transfer_data['freight'];
								$voucher['narration'] = $transfer_data['narration'];
								$voucher['table_name'] ='dms_stock_transfers';
								$voucher['table_group_id'] = $group_id; 
								$this->stocktransfer->f_save('dms_vouchers',$voucher);
							}
							if(!empty($transfer_data['other_expense']) && $transfer_data['other_expense'] > 0){

								#receipt voucher
								$voucher['company_id'] = $this->company_Id;
								$voucher['branch_id'] = $this->branch_Id;
								$voucher['group_id'] = $voucher_group_id;
								$voucher['vtype_id'] = 2;
								$voucher['vno'] = $voucher_no;
								$voucher['vorder_no'] = 2;
								$voucher['vdate'] = $transfer_data['transfer_date'];
								$voucher['dr_ledger'] = 1;
								$voucher['cr_ledger'] = 14;
								$voucher['vamount'] = $transfer_data['other_expense'];
								$voucher['narration'] = $transfer_data['narration'];
								$voucher['table_name'] ='dms_stock_transfers';
								$voucher['table_group_id'] = $group_id; 
								$this->stocktransfer->f_save('dms_vouchers',$voucher);

							}
							$this->message->set($this->lang->line('stock-transfer-saved'),'s');
							redirect('stock_transfer/report');
						}
					

					}
					
				}
			}else{
				redirect(base_url());
			}

			$branch_details = $this->dms->get_user_branch($purchase_request_array[0]['requested_by']);
			$godown_to = $this->godown->opt_listing(array('conditions'=>array('branch_id'=>$branch_details['id'])));
			$godown_to[' '] = 'Select';
			ksort($godown_to);

			#template
			$this->template->title('Purchase Request to Stock Transfer');
			$this->template->main_heading($this->lang->line('purchase-request').' '.$this->lang->line('to').' '.$this->lang->line('stock-transfer'));
			$this->template->slice('dms/message');
			$this->template->slice('stock_transfer/request_to_transfer/add',array('purchases'=>$purchase_request_array,'godown_to'=>$godown_to,'transfer_Id'=>$transfer_Id,'transfer_date'=>$transfer_date));
			$this->template->render();
		}
	   #--------------------------------------------------
		public function check_transfer_date($transfer_date,$request_date){
			if($transfer_date >=$request_date){
				return TRUE;
			}else{
				return FALSE;
			}
		}
		#--------------------------------------------------
	}
?>