<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

	class Route_master extends MY_Controller{

		public function __construct(){

			parent ::__construct();
			$this->load->model('routes/Route_model','route');
			
			#---------------- Checking Financial year is enabled / closed-----------------#
			$method_array = array('add','edit','delete');
			fiscal_status($this->uri->segment(2),$method_array,"route_master/report");	
			#---------------- Checking Financial year is enabled / closed-----------------#
			
		}
	 #-----------------------------------------------------------------------
		#date:3-12-2014,roopey
		#purpose:route adding
		public function add(){
			#validation settings
			$this->form_validation->set_rules('route_name','lang:route-name','required|trim|xss_clean|is_unique[route_master.route_name]');

			#validation checking
			if($this->form_validation->run() == TRUE){

				$data = $this->input->post(NULL,TRUE);
				$data['company_id'] = $this->session->userdata('company_id');
				$data['created_by'] = $this->session->userdata('id');
				$data['created_on'] = date('Y-m-d h:i:s');
				if($this->db->insert('route_master',$data)){

					$this->message->set($this->lang->line('route-saved'));
				}
				else{
					$this->message->set($this->lang->line('route-not-saved'));
				}
				redirect('route_master/report');

			}

			$this->template->title(' Vehicles Route Settings');
			$this->template->main_heading($this->lang->line('route-settings'));
			$this->template->breadcrumb(array($this->lang->line('settings')=>'preferences/',$this->lang->line('vehicles')=>'vehicles/',$this->lang->line('route')=>'route_master/report',$this->lang->line('new')=>'no_link'));
			$this->template->slice('dms/message');
			$this->template->slice('preferences/vehicles/route/new');
			$this->template->render();

		}
	 #-----------------------------------------------------------------------
		#date:4-12-2014
		#purpose:report view of route master
		public function report(){
			#pagination
   	 		$this->load->library('Pagination');
   	 		$config['total_rows'] = $this->route->get_all(array('numrows'=>TRUE));
   	 		$config['base_url'] = base_url('route_master/report');
   	 		$config['per_page'] = $this->per_page();
   	 		$config['uri_segment'] = 3;
			# Pagination Config Customizations
			$config['full_tag_open'] = '<ul class="pagination">';
			$config['full_tag_close'] = '</ul>';
			$config['first_link'] = 'First';
			$config['last_link'] = 'Last';
			$config['next_link'] = '&raquo;';
			$config['prev_link'] = '&laquo;';
			$config['cur_tag_open'] = '<li class="active"><a href="#">';
			$config['cur_tag_close'] = '</a></li>';
			$config['num_tag_open'] = '<li>';
			$config['num_tag_close'] = '</li>';	
   	 		$this->pagination->initialize($config);
   	 		$links = $this->pagination->create_links();
   	 		$offset = $this->uri->segment($config['uri_segment'],0);

   	 		$routes = $this->route->get_all(array('order_by'=>'created_on','order'=>'DESC','limit'=>$config['per_page'],'offset'=>$offset));
   	 		//echo '<pre>';print_r($routes);die;
   	 		if(empty($routes)){ 
   	 			$this->message->set($this->lang->line('no-route-found'),'i');
   	 		}
			$this->template->title(' Vehicles Route Settings');
			$this->template->main_heading($this->lang->line('route-settings'));
			$this->template->breadcrumb(array($this->lang->line('settings')=>'preferences/',$this->lang->line('vehicles')=>'vehicles/',$this->lang->line('route')=>'route_master/add',$this->lang->line('report')=>'no_link'));
			$this->template->slice('dms/message');
			$this->template->slice('preferences/vehicles/route/report',array('links'=>$links,'offset'=>$offset,'routes'=>$routes));
			$this->template->render();
		}
	 #-----------------------------------------------------------------------
		public function edit(){
			$route_id = $this->uri->segment(3);
   	 		if(empty($route_id)){ redirect('route_master/report');}
   	 		#get route id details 
   	 		$route = $this->route->get_all(array('conditions'=>array('id'=>$route_id)))[0];
   	 		if(empty($route)){
   	 			redirect('route_master/report');
   	 		}

   	 		#validation
   	 		$this->form_validation->set_rules('route_name','lang:route-name','required|trim|xss_clean|is_edit_unique[roure_master.route_name]');
   	 		if($this->form_validation->run() == TRUE){

   	 			$data = $this->input->post(NULL,TRUE);
   	 			$data['created_by'] = $this->session->userdata('id');
   	 			$data['created_on'] = date('Y-m-d h:i:s');

   	 			if($this->db->update('route_master',$data,array('id'=>$route_id))){
   	 				$this->message->set($this->lang->line('route-updated'));
   	 			}
   	 			else{
   	 				$this->message->set($this->lang->line('route-not-updated'));
   	 			}
   	 			$call_ck_uri = $this->uri->uri_to_assoc(4);
				redirect($this->uri->assoc_to_uri($call_ck_uri));
   	 		}



   	 		$this->template->title(' Vehicles Route Settings');
			$this->template->main_heading($this->lang->line('route-settings'));
			$this->template->breadcrumb(array($this->lang->line('settings')=>'preferences/',$this->lang->line('vehicles')=>'vehicles/',$this->lang->line('route')=>'route_master/report',$this->lang->line('update')=>'no_link'));
			$this->template->slice('dms/message');
			$this->template->slice('preferences/vehicles/route/edit',array('route'=>$route));
			$this->template->render();
   	 		//print_r($route);die;
		}
	 #-----------------------------------------------------------------------
		public function delete(){
			$route_id = $this->uri->segment(3);
			if(empty($route_id)){ redirect('route_master/report');}
			if($this->if_exists('route_master',array('id'=>$route_id,'status'=>1)) === false){
				redirect('route_master/report');
			}	
			#
			$data['status'] = 0;
			$data['created_by'] = $this->session->userdata('id');
			$data['created_on'] = date('Y-m-d h:i:s');

			if($this->db->update('route_master',$data,array('id'=>$route_id))){

				$this->message->set($this->lang->line('route-deleted'));
 			}
 			else{
 				$this->message->set($this->lang->line('route-not-deleted'));
 			}
 			redirect('route_master/report');

		}
	 #-----------------------------------------------------------------------
	}
?>