<?php  if( ! defined('BASEPATH')) exit ('No direct script access allowed');

	class Salary_settings extends MY_Controller{

		public function __construct(){

			parent :: __construct();
			$this->company_id = $this->session->userdata('company_id');
			#---------------- Checking Financial year is enabled / closed-----------------#
			$method_array = array('index');
			fiscal_status($this->uri->segment(2),$method_array,"users/home");	
			#---------------- Checking Financial year is enabled / closed-----------------#	
		}
	 #------------------------------------------------------------
		public function index(){

			$this->db->select('mm.*');
			$this->db->from('menu_master mm');
			if($this->session->userdata('user_desig') != -1){
				$this->db->join('user_privileges up','up.menu_id=mm.id');
				$this->db->where('up.user_group','individual');
				$this->db->where('up.owner_id',$this->session->userdata('id'));
			}
			$this->db->where('mm.menu_group','salary-settings');
			$this->db->where('mm.menu_parent !=','0');
			$this->db->order_by('menu_order','ASC');
			$menus = $this->db->get()->result_array();

			$this->template->title($this->lang->line('salary-settings'));
			$this->template->main_heading($this->lang->line('salary-settings'));
			$this->template->breadcrumb(array($this->lang->line('settings')=>'preferences/',$this->lang->line('salary-settings')=>'no_link'));
			$this->template->slice('preferences/general/link_list',array('menus'=>$menus));
			$this->template->render();
		}
	 #------------------------------------------------------------

		function salary_percentage(){

			$this->load->model('vehicle_types/Vehicle_type_model','vehicle_type');
			$this->load->model('salary/Salary_settings_model','salary_settings');
			$this->template->title($this->lang->line('salary-settings'));
			$this->template->main_heading($this->lang->line('salary-percentage'));
			$this->template->breadcrumb(array($this->lang->line('salary-settings') => 'salary_settings/index',$this->lang->line('salary-percentage') =>'no_link' ));

			$this->form_validation->set_rules('name','lang:name','xss_clean|trim|required');
			$this->form_validation->set_rules('vehicle_type','lang:vehicle types','xss_clean|trim|required');
			$this->form_validation->set_rules('percentage','lang:salary-percentage','trim|xss_clean|required');
			
			if($this->form_validation->run() === true){

				$name = $this->input->post('name');
				$vehicle_type = $this->input->post('vehicle_type');
				$percentage = $this->input->post('percentage');

				$args = array();
				$args['conditions'] = array('company_id'=>$this->company_id,'vehicle_type_id'=>$vehicle_type,'percentage'=>$percentage);
				$driver_salary_percentage = $this->salary_settings->get_salary_percentage($args);
				if(empty($driver_salary_percentage)){
					if($this->salary_settings->save('dms_salary_percentages',array('company_id'=>$this->company_id,'name'=>$name,'vehicle_type_id'=>$vehicle_type,'percentage'=>$percentage))){
						$this->message->set($this->lang->line('salary-percent-save'),'s');
					}
				}else{
					$this->message->set($this->lang->line('salary-percent-exists'),'e');
				}
			}

			$vehicle_types = array();
			
			$vehicle_types = $this->vehicle_type->listing(array('company_id'=>$this->company_id));
			$vehicle_types[''] = 'Select A Type';
			ksort($vehicle_types);

			$args = array();
			$args['select'] = array('dsp.id','dsp.company_id','dsp.name','dsp.vehicle_type_id','dsp.percentage','vtm.vehicle_type');
			$args['conditions'] = array('dsp.company_id'=>$this->company_id);
			$args['join'] = array('vehicle_type_master as vtm'=>'vtm.id=dsp.vehicle_type_id');
			$salary_percentages = $this->salary_settings->get_salary_percentage($args);
			

			# view starts here--------------------------------
			$this->template->slice('dms/message');
			$this->template->slice('salary_settings/salary_percentage',array('vehicleTypes'=>$vehicle_types,'salary_percentages'=>$salary_percentages));
			$this->template->render();
			#-------------------------------------------------------------
		}

		#_____________________________________________________________________________

		public function edit_salary_percentage(){

			$this->load->model('vehicle_types/Vehicle_type_model','vehicle_type');
			$this->load->model('salary/Salary_settings_model','salary_settings');
			$this->template->title($this->lang->line('salary-settings'));
			$this->template->main_heading($this->lang->line('edit-salary-percentage'));
			$this->template->breadcrumb(array($this->lang->line('salary-settings') => 'salary_settings/index',$this->lang->line('salary-percentage') =>'no_link' ));

			$this->form_validation->set_rules('name','lang:name','xss_clean|trim|required');
			$this->form_validation->set_rules('vehicle_type','lang:vehicle types','xss_clean|trim|required');
			$this->form_validation->set_rules('percentage','lang:salary-percentage','trim|xss_clean|required');
			
			if(!$this->uri->segment(3)){

			}
			$salary_percentage_id = $this->uri->segment(3);
			if($this->form_validation->run() === true){

				$name = $this->input->post('name');
				$vehicle_type = $this->input->post('vehicle_type');
				$percentage = $this->input->post('percentage');

				$args = array();
				$args['conditions'] = array('company_id'=>$this->company_id,'vehicle_type_id'=>$vehicle_type,'percentage'=>$percentage,'id !'=>$salary_percentage_id);
				$driver_salary_percentage = $this->salary_settings->get_salary_percentage($args);
				if(empty($driver_salary_percentage)){
					if($this->salary_settings->update('dms_salary_percentages',array('name'=>$name,'vehicle_type_id'=>$vehicle_type,'percentage'=>$percentage),array('id'=>$salary_percentage_id))){
						$this->message->set($this->lang->line('salary-percent-save'),'s');
						redirect('salary_settings/salary_percentage');
					}
				}else{
					$this->message->set($this->lang->line('salary-percent-exists'),'e');
				}
			}

			$vehicle_types = array();
			
			$vehicle_types = $this->vehicle_type->listing(array('company_id'=>$this->company_id));
			$vehicle_types[''] = 'Select A Type';
			ksort($vehicle_types);

			$args = array();
			$args['select'] = array('dsp.id','dsp.company_id','dsp.name','dsp.vehicle_type_id','dsp.percentage');
			$args['conditions'] = array('dsp.id'=>$salary_percentage_id);
			$args['join'] = array('vehicle_type_master as vtm'=>'vtm.id=dsp.vehicle_type_id');
			$salary_percentages = $this->salary_settings->get_salary_percentage($args);

			
			# view starts here--------------------------------
			$this->template->slice('dms/message');
			$this->template->slice('salary_settings/edit_salary_percentage',array('vehicleTypes'=>$vehicle_types,'salary_percentages'=>$salary_percentages));
			$this->template->render();
			#-------------------------------------------------------------

		}

		#_____________________________________________________________________________

		public function delete_salary_percentage(){

			if(!$this->uri->segment(3)){

			}
			$salary_percentage_id = $this->uri->segment(3);
			$this->load->model('salary/Salary_model','salary');

			$args = array();
			$args['select'] = array('id');
			$args['from'] = 'dms_driver_salary_bills';
			$args['conditions'] = array('percentage_id'=>$salary_percentage_id,'status'=>1);
			$driver_salary_voucher = $this->salary->get($args);

			if(empty($driver_salary_voucher)){
				$this->message->set($this->lang->line('salary-percent-deleted'),'s');
				$this->salary->delete('dms_salary_percentages',array('id'=>$salary_percentage_id));
			}else{
				$this->message->set($this->lang->line('salary-percent-already-in-use'),'e');
			}
			redirect('salary_settings/salary_percentage');
		}

		#_____________________________________________________________________________

		public function allowance() {

			$this->load->model('salary/Salary_settings_model','salary_settings');
			$this->template->title($this->lang->line('salary-settings'));
			$this->template->main_heading($this->lang->line('salary-allowance'));
			$this->template->breadcrumb(array($this->lang->line('salary-settings') => 'salary_settings/index',$this->lang->line('salary-allowance') =>'no_link' ));

			$this->form_validation->set_rules('allowance_code','lang:allowance-code','xss_clean|trim|required');
			$this->form_validation->set_rules('allowance','lang:allowance-name','xss_clean|trim|required');

			if($this->form_validation->run() === true){

				$allowance_code = $this->input->post('allowance_code');
				$allowance = $this->input->post('allowance');

				$args = array();
				$args['conditions'] = array('company_id'=>$this->company_id,'allowance_code'=>$allowance_code);
				$driver_salary_percentage = $this->salary_settings->get_salary_allowance($args);

				if(empty($driver_salary_percentage)){

					if($this->salary_settings->save('dms_salary_allowances',array('company_id'=>$this->company_id,'allowance_code'=>$allowance_code,'allowance'=>$allowance))){
						$this->message->set($this->lang->line('salary-allowance-save'),'s');
						redirect('salary_settings/allowance');
					}
				}else{
					$this->message->set($this->lang->line('salary-allowance-exists'),'e');
				}
			}

			$args = array();
			$args['conditions'] = array('company_id'=>$this->company_id);
			$salary_allowances = $this->salary_settings->get_salary_allowance($args);

			# view starts here--------------------------------
			$this->template->slice('dms/message');
			$this->template->slice('salary_settings/salary_allowance',array('salary_allowances'=>$salary_allowances));
			$this->template->render();
			#-------------------------------------------------------------

		}
	}
?>